/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors.tree;

import com.android.server.usb.descriptors.UsbACInterface;
import com.android.server.usb.descriptors.UsbConfigDescriptor;
import com.android.server.usb.descriptors.UsbDescriptor;
import com.android.server.usb.descriptors.UsbDescriptorParser;
import com.android.server.usb.descriptors.UsbDeviceDescriptor;
import com.android.server.usb.descriptors.UsbEndpointDescriptor;
import com.android.server.usb.descriptors.UsbInterfaceDescriptor;
import com.android.server.usb.descriptors.report.ReportCanvas;
import com.android.server.usb.descriptors.tree.UsbDescriptorsACInterfaceNode;
import com.android.server.usb.descriptors.tree.UsbDescriptorsConfigNode;
import com.android.server.usb.descriptors.tree.UsbDescriptorsDeviceNode;
import com.android.server.usb.descriptors.tree.UsbDescriptorsEndpointNode;
import com.android.server.usb.descriptors.tree.UsbDescriptorsInterfaceNode;
import java.util.ArrayList;

public final class UsbDescriptorsTree {
    private static final String TAG = "UsbDescriptorsTree";
    private UsbDescriptorsDeviceNode mDeviceNode;
    private UsbDescriptorsConfigNode mConfigNode;
    private UsbDescriptorsInterfaceNode mInterfaceNode;

    private void addDeviceDescriptor(UsbDeviceDescriptor deviceDescriptor) {
        this.mDeviceNode = new UsbDescriptorsDeviceNode(deviceDescriptor);
    }

    private void addConfigDescriptor(UsbConfigDescriptor configDescriptor) {
        this.mConfigNode = new UsbDescriptorsConfigNode(configDescriptor);
        this.mDeviceNode.addConfigDescriptorNode(this.mConfigNode);
    }

    private void addInterfaceDescriptor(UsbInterfaceDescriptor interfaceDescriptor) {
        this.mInterfaceNode = new UsbDescriptorsInterfaceNode(interfaceDescriptor);
        this.mConfigNode.addInterfaceNode(this.mInterfaceNode);
    }

    private void addEndpointDescriptor(UsbEndpointDescriptor endpointDescriptor) {
        this.mInterfaceNode.addEndpointNode(new UsbDescriptorsEndpointNode(endpointDescriptor));
    }

    private void addACInterface(UsbACInterface acInterface) {
        this.mInterfaceNode.addACInterfaceNode(new UsbDescriptorsACInterfaceNode(acInterface));
    }

    public void parse(UsbDescriptorParser parser) {
        ArrayList<UsbDescriptor> descriptors = parser.getDescriptors();
        block7: for (int descrIndex = 0; descrIndex < descriptors.size(); ++descrIndex) {
            UsbDescriptor descriptor = descriptors.get(descrIndex);
            switch (descriptor.getType()) {
                case 1: {
                    this.addDeviceDescriptor((UsbDeviceDescriptor)descriptor);
                    continue block7;
                }
                case 2: {
                    this.addConfigDescriptor((UsbConfigDescriptor)descriptor);
                    continue block7;
                }
                case 4: {
                    this.addInterfaceDescriptor((UsbInterfaceDescriptor)descriptor);
                    continue block7;
                }
                case 5: {
                    this.addEndpointDescriptor((UsbEndpointDescriptor)descriptor);
                    continue block7;
                }
                case 36: {
                    this.addACInterface((UsbACInterface)descriptor);
                    continue block7;
                }
            }
        }
    }

    public void report(ReportCanvas canvas) {
        this.mDeviceNode.report(canvas);
    }
}

