/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors.report;

import android.hardware.usb.UsbDeviceConnection;
import com.android.server.usb.descriptors.report.ReportCanvas;

public final class TextReportCanvas
extends ReportCanvas {
    private static final String TAG = "TextReportCanvas";
    private final StringBuilder mStringBuilder;
    private int mListIndent;
    private static final int LIST_INDENT_AMNT = 2;

    public TextReportCanvas(UsbDeviceConnection connection, StringBuilder stringBuilder) {
        super(connection);
        this.mStringBuilder = stringBuilder;
    }

    private void writeListIndent() {
        for (int space = 0; space < this.mListIndent; ++space) {
            this.mStringBuilder.append(" ");
        }
    }

    @Override
    public void write(String text) {
        this.mStringBuilder.append(text);
    }

    @Override
    public void openHeader(int level) {
        this.writeListIndent();
        this.mStringBuilder.append("[");
    }

    @Override
    public void closeHeader(int level) {
        this.mStringBuilder.append("]\n");
    }

    @Override
    public void openParagraph(boolean emphasis) {
        this.writeListIndent();
    }

    @Override
    public void closeParagraph() {
        this.mStringBuilder.append("\n");
    }

    @Override
    public void writeParagraph(String text, boolean inRed) {
        this.openParagraph(inRed);
        if (inRed) {
            this.mStringBuilder.append("*" + text + "*");
        } else {
            this.mStringBuilder.append(text);
        }
        this.closeParagraph();
    }

    @Override
    public void openList() {
        this.mListIndent += 2;
    }

    @Override
    public void closeList() {
        this.mListIndent -= 2;
    }

    @Override
    public void openListItem() {
        this.writeListIndent();
        this.mStringBuilder.append("- ");
    }

    @Override
    public void closeListItem() {
        this.mStringBuilder.append("\n");
    }
}

