/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbACInterface;

public class UsbACMixerUnit
extends UsbACInterface {
    private static final String TAG = "UsbACMixerUnit";
    protected byte mUnitID;
    protected byte mNumInputs;
    protected byte[] mInputIDs;
    protected byte mNumOutputs;

    public UsbACMixerUnit(int length, byte type, byte subtype, byte subClass) {
        super(length, type, subtype, subClass);
    }

    public byte getUnitID() {
        return this.mUnitID;
    }

    public byte getNumInputs() {
        return this.mNumInputs;
    }

    public byte[] getInputIDs() {
        return this.mInputIDs;
    }

    public byte getNumOutputs() {
        return this.mNumOutputs;
    }

    protected static int calcControlArraySize(int numInputs, int numOutputs) {
        int totalChannels = numInputs * numOutputs;
        return (totalChannels + 7) / 8;
    }

    @Override
    public int parseRawDescriptors(ByteStream stream) {
        this.mUnitID = stream.getByte();
        this.mNumInputs = stream.getByte();
        this.mInputIDs = new byte[this.mNumInputs];
        for (int input = 0; input < this.mNumInputs; ++input) {
            this.mInputIDs[input] = stream.getByte();
        }
        this.mNumOutputs = stream.getByte();
        return this.mLength;
    }
}

