/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbPort;
import android.hardware.usb.UsbPortStatus;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UEventObserver;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.provider.Settings;
import android.util.Pair;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.FgThread;
import com.android.server.usb.UsbAlsaManager;
import com.android.server.usb.UsbDebuggingManager;
import com.android.server.usb.UsbProfileGroupSettingsManager;
import com.android.server.usb.UsbSettingsManager;
import com.android.server.usb.UsbUserSettingsManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class UsbDeviceManager {
    private static final String TAG = "UsbDeviceManager";
    private static final boolean DEBUG = false;
    private static final String USB_PERSISTENT_CONFIG_PROPERTY = "persist.sys.usb.config";
    private static final String USB_CONFIG_PROPERTY = "sys.usb.config";
    private static final String USB_STATE_PROPERTY = "sys.usb.state";
    private static final String NORMAL_BOOT = "normal";
    private static final String USB_STATE_MATCH = "DEVPATH=/devices/virtual/android_usb/android0";
    private static final String ACCESSORY_START_MATCH = "DEVPATH=/devices/virtual/misc/usb_accessory";
    private static final String FUNCTIONS_PATH = "/sys/class/android_usb/android0/functions";
    private static final String STATE_PATH = "/sys/class/android_usb/android0/state";
    private static final String RNDIS_ETH_ADDR_PATH = "/sys/class/android_usb/android0/f_rndis/ethaddr";
    private static final String AUDIO_SOURCE_PCM_PATH = "/sys/class/android_usb/android0/f_audio_source/pcm";
    private static final String MIDI_ALSA_PATH = "/sys/class/android_usb/android0/f_midi/alsa";
    private static final int MSG_UPDATE_STATE = 0;
    private static final int MSG_ENABLE_ADB = 1;
    private static final int MSG_SET_CURRENT_FUNCTIONS = 2;
    private static final int MSG_SYSTEM_READY = 3;
    private static final int MSG_BOOT_COMPLETED = 4;
    private static final int MSG_USER_SWITCHED = 5;
    private static final int MSG_UPDATE_USER_RESTRICTIONS = 6;
    private static final int MSG_UPDATE_PORT_STATE = 7;
    private static final int MSG_ACCESSORY_MODE_ENTER_TIMEOUT = 8;
    private static final int MSG_UPDATE_CHARGING_STATE = 9;
    private static final int MSG_UPDATE_HOST_STATE = 10;
    private static final int MSG_LOCALE_CHANGED = 11;
    private static final int AUDIO_MODE_SOURCE = 1;
    private static final int UPDATE_DELAY = 1000;
    private static final int ACCESSORY_REQUEST_TIMEOUT = 10000;
    private static final String BOOT_MODE_PROPERTY = "ro.bootmode";
    private static final String ADB_NOTIFICATION_CHANNEL_ID_TV = "usbdevicemanager.adb.tv";
    private UsbHandler mHandler;
    private boolean mBootCompleted;
    private final Object mLock = new Object();
    private final Context mContext;
    private final ContentResolver mContentResolver;
    @GuardedBy(value="mLock")
    private UsbProfileGroupSettingsManager mCurrentSettings;
    private NotificationManager mNotificationManager;
    private final boolean mHasUsbAccessory;
    private boolean mUseUsbNotification;
    private boolean mAdbEnabled;
    private boolean mAudioSourceEnabled;
    private boolean mMidiEnabled;
    private int mMidiCard;
    private int mMidiDevice;
    private HashMap<String, HashMap<String, Pair<String, String>>> mOemModeMap;
    private String[] mAccessoryStrings;
    private UsbDebuggingManager mDebuggingManager;
    private final UsbAlsaManager mUsbAlsaManager;
    private final UsbSettingsManager mSettingsManager;
    private Intent mBroadcastedIntent;
    private boolean mPendingBootBroadcast;
    private static Set<Integer> sBlackListedInterfaces = new HashSet<Integer>();
    private final UEventObserver mUEventObserver = new UEventObserver(){

        @Override
        public void onUEvent(UEventObserver.UEvent event) {
            String state = event.get("USB_STATE");
            String accessory = event.get("ACCESSORY");
            if (state != null) {
                UsbDeviceManager.this.mHandler.updateState(state);
            } else if ("START".equals(accessory)) {
                UsbDeviceManager.this.startAccessoryMode();
            }
        }
    };

    public UsbDeviceManager(Context context, UsbAlsaManager alsaManager, UsbSettingsManager settingsManager) {
        this.mContext = context;
        this.mUsbAlsaManager = alsaManager;
        this.mSettingsManager = settingsManager;
        this.mContentResolver = context.getContentResolver();
        PackageManager pm = this.mContext.getPackageManager();
        this.mHasUsbAccessory = pm.hasSystemFeature("android.hardware.usb.accessory");
        UsbDeviceManager.initRndisAddress();
        this.readOemUsbOverrideConfig();
        this.mHandler = new UsbHandler(FgThread.get().getLooper());
        if (this.nativeIsStartRequested()) {
            this.startAccessoryMode();
        }
        boolean secureAdbEnabled = SystemProperties.getBoolean("ro.adb.secure", false);
        boolean dataEncrypted = "1".equals(SystemProperties.get("vold.decrypt"));
        if (secureAdbEnabled && !dataEncrypted) {
            this.mDebuggingManager = new UsbDebuggingManager(context);
        }
        BroadcastReceiver portReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                UsbPort port = (UsbPort)intent.getParcelableExtra("port");
                UsbPortStatus status = (UsbPortStatus)intent.getParcelableExtra("portStatus");
                UsbDeviceManager.this.mHandler.updateHostState(port, status);
            }
        };
        BroadcastReceiver chargingReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                int chargePlug = intent.getIntExtra("plugged", -1);
                boolean usbCharging = chargePlug == 2;
                UsbDeviceManager.this.mHandler.sendMessage(9, usbCharging);
            }
        };
        BroadcastReceiver hostReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                Iterator<Map.Entry<String, UsbDevice>> devices = ((UsbManager)context.getSystemService("usb")).getDeviceList().entrySet().iterator();
                if (intent.getAction().equals("android.hardware.usb.action.USB_DEVICE_ATTACHED")) {
                    UsbDeviceManager.this.mHandler.sendMessage(10, devices, true);
                } else {
                    UsbDeviceManager.this.mHandler.sendMessage(10, devices, false);
                }
            }
        };
        BroadcastReceiver languageChangedReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                UsbDeviceManager.this.mHandler.sendEmptyMessage(11);
            }
        };
        this.mContext.registerReceiver(portReceiver, new IntentFilter("android.hardware.usb.action.USB_PORT_CHANGED"));
        this.mContext.registerReceiver(chargingReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        IntentFilter filter = new IntentFilter("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        this.mContext.registerReceiver(hostReceiver, filter);
        this.mContext.registerReceiver(languageChangedReceiver, new IntentFilter("android.intent.action.LOCALE_CHANGED"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UsbProfileGroupSettingsManager getCurrentSettings() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentSettings;
        }
    }

    public void systemReady() {
        StorageManager storageManager;
        StorageVolume primary;
        this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (this.isTv()) {
            this.mNotificationManager.createNotificationChannel(new NotificationChannel(ADB_NOTIFICATION_CHANNEL_ID_TV, this.mContext.getString(17039444), 4));
        }
        boolean massStorageSupported = (primary = (storageManager = StorageManager.from(this.mContext)).getPrimaryVolume()) != null && primary.allowMassStorage();
        this.mUseUsbNotification = !massStorageSupported && this.mContext.getResources().getBoolean(17957042);
        try {
            Settings.Global.putInt(this.mContentResolver, "adb_enabled", this.mAdbEnabled ? 1 : 0);
        }
        catch (SecurityException e) {
            Slog.d(TAG, "ADB_ENABLED is restricted.");
        }
        this.mHandler.sendEmptyMessage(3);
    }

    public void bootCompleted() {
        this.mHandler.sendEmptyMessage(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentUser(int newCurrentUserId, UsbProfileGroupSettingsManager settings) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentSettings = settings;
            this.mHandler.obtainMessage(5, newCurrentUserId, 0).sendToTarget();
        }
    }

    public void updateUserRestrictions() {
        this.mHandler.sendEmptyMessage(6);
    }

    private void startAccessoryMode() {
        if (!this.mHasUsbAccessory) {
            return;
        }
        this.mAccessoryStrings = this.nativeGetAccessoryStrings();
        boolean enableAudio = this.nativeGetAudioMode() == 1;
        boolean enableAccessory = this.mAccessoryStrings != null && this.mAccessoryStrings[0] != null && this.mAccessoryStrings[1] != null;
        String functions = null;
        if (enableAccessory && enableAudio) {
            functions = "accessory,audio_source";
        } else if (enableAccessory) {
            functions = "accessory";
        } else if (enableAudio) {
            functions = "audio_source";
        }
        if (functions != null) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(8), 10000L);
            this.setCurrentFunctions(functions, false);
        }
    }

    private static void initRndisAddress() {
        int ETH_ALEN = 6;
        int[] address = new int[6];
        address[0] = 2;
        String serial = SystemProperties.get("ro.serialno", "1234567890ABCDEF");
        int serialLength = serial.length();
        for (int i = 0; i < serialLength; ++i) {
            int n = i % 5 + 1;
            address[n] = address[n] ^ serial.charAt(i);
        }
        String addrString = String.format(Locale.US, "%02X:%02X:%02X:%02X:%02X:%02X", address[0], address[1], address[2], address[3], address[4], address[5]);
        try {
            FileUtils.stringToFile(RNDIS_ETH_ADDR_PATH, addrString);
        }
        catch (IOException e) {
            Slog.e(TAG, "failed to write to /sys/class/android_usb/android0/f_rndis/ethaddr");
        }
    }

    private boolean isTv() {
        return this.mContext.getPackageManager().hasSystemFeature("android.software.leanback");
    }

    public UsbAccessory getCurrentAccessory() {
        return this.mHandler.getCurrentAccessory();
    }

    public ParcelFileDescriptor openAccessory(UsbAccessory accessory, UsbUserSettingsManager settings) {
        UsbAccessory currentAccessory = this.mHandler.getCurrentAccessory();
        if (currentAccessory == null) {
            throw new IllegalArgumentException("no accessory attached");
        }
        if (!currentAccessory.equals(accessory)) {
            String error = accessory.toString() + " does not match current accessory " + currentAccessory;
            throw new IllegalArgumentException(error);
        }
        settings.checkPermission(accessory);
        return this.nativeOpenAccessory();
    }

    public boolean isFunctionEnabled(String function) {
        return UsbManager.containsFunction(SystemProperties.get(USB_CONFIG_PROPERTY), function);
    }

    public void setCurrentFunctions(String functions, boolean usbDataUnlocked) {
        this.mHandler.sendMessage(2, functions, usbDataUnlocked);
    }

    private void readOemUsbOverrideConfig() {
        String[] configList = this.mContext.getResources().getStringArray(17236019);
        if (configList != null) {
            for (String config : configList) {
                HashMap<String, Pair<String, String>> overrideMap;
                String[] items = config.split(":");
                if (items.length != 3 && items.length != 4) continue;
                if (this.mOemModeMap == null) {
                    this.mOemModeMap = new HashMap();
                }
                if ((overrideMap = this.mOemModeMap.get(items[0])) == null) {
                    overrideMap = new HashMap();
                    this.mOemModeMap.put(items[0], overrideMap);
                }
                if (overrideMap.containsKey(items[1])) continue;
                if (items.length == 3) {
                    overrideMap.put(items[1], new Pair<String, String>(items[2], ""));
                    continue;
                }
                overrideMap.put(items[1], new Pair<String, String>(items[2], items[3]));
            }
        }
    }

    private String applyOemOverrideFunction(String usbFunctions) {
        if (usbFunctions == null || this.mOemModeMap == null) {
            return usbFunctions;
        }
        String bootMode = SystemProperties.get(BOOT_MODE_PROPERTY, "unknown");
        Slog.d(TAG, "applyOemOverride usbfunctions=" + usbFunctions + " bootmode=" + bootMode);
        Map overridesMap = this.mOemModeMap.get(bootMode);
        if (overridesMap != null && !bootMode.equals(NORMAL_BOOT) && !bootMode.equals("unknown")) {
            Pair overrideFunctions = (Pair)overridesMap.get(usbFunctions);
            if (overrideFunctions != null) {
                Slog.d(TAG, "OEM USB override: " + usbFunctions + " ==> " + (String)overrideFunctions.first + " persist across reboot " + (String)overrideFunctions.second);
                if (!((String)overrideFunctions.second).equals("")) {
                    String newFunction = this.mAdbEnabled ? UsbManager.addFunction((String)overrideFunctions.second, "adb") : (String)overrideFunctions.second;
                    Slog.d(TAG, "OEM USB override persisting: " + newFunction + "in prop: " + UsbDeviceManager.getPersistProp(false));
                    SystemProperties.set(UsbDeviceManager.getPersistProp(false), newFunction);
                }
                return (String)overrideFunctions.first;
            }
            if (this.mAdbEnabled) {
                String newFunction = UsbManager.addFunction("none", "adb");
                SystemProperties.set(UsbDeviceManager.getPersistProp(false), newFunction);
            } else {
                SystemProperties.set(UsbDeviceManager.getPersistProp(false), "none");
            }
        }
        return usbFunctions;
    }

    public static String getPersistProp(boolean functions) {
        String bootMode = SystemProperties.get(BOOT_MODE_PROPERTY, "unknown");
        String persistProp = USB_PERSISTENT_CONFIG_PROPERTY;
        if (!bootMode.equals(NORMAL_BOOT) && !bootMode.equals("unknown")) {
            persistProp = functions ? "persist.sys.usb." + bootMode + ".func" : "persist.sys.usb." + bootMode + ".config";
        }
        return persistProp;
    }

    public void allowUsbDebugging(boolean alwaysAllow, String publicKey) {
        if (this.mDebuggingManager != null) {
            this.mDebuggingManager.allowUsbDebugging(alwaysAllow, publicKey);
        }
    }

    public void denyUsbDebugging() {
        if (this.mDebuggingManager != null) {
            this.mDebuggingManager.denyUsbDebugging();
        }
    }

    public void clearUsbDebuggingKeys() {
        if (this.mDebuggingManager == null) {
            throw new RuntimeException("Cannot clear Usb Debugging keys, UsbDebuggingManager not enabled");
        }
        this.mDebuggingManager.clearUsbDebuggingKeys();
    }

    public void dump(IndentingPrintWriter pw) {
        if (this.mHandler != null) {
            this.mHandler.dump(pw);
        }
        if (this.mDebuggingManager != null) {
            this.mDebuggingManager.dump(pw);
        }
    }

    private native String[] nativeGetAccessoryStrings();

    private native ParcelFileDescriptor nativeOpenAccessory();

    private native boolean nativeIsStartRequested();

    private native int nativeGetAudioMode();

    static /* synthetic */ String[] access$902(UsbDeviceManager x0, String[] x1) {
        x0.mAccessoryStrings = x1;
        return x1;
    }

    static {
        sBlackListedInterfaces.add(1);
        sBlackListedInterfaces.add(2);
        sBlackListedInterfaces.add(3);
        sBlackListedInterfaces.add(7);
        sBlackListedInterfaces.add(8);
        sBlackListedInterfaces.add(9);
        sBlackListedInterfaces.add(10);
        sBlackListedInterfaces.add(11);
        sBlackListedInterfaces.add(13);
        sBlackListedInterfaces.add(14);
        sBlackListedInterfaces.add(224);
    }

    private final class UsbHandler
    extends Handler {
        private boolean mConnected;
        private boolean mHostConnected;
        private boolean mSourcePower;
        private boolean mSinkPower;
        private boolean mConfigured;
        private boolean mUsbDataUnlocked;
        private boolean mAudioAccessoryConnected;
        private boolean mAudioAccessorySupported;
        private String mCurrentFunctions;
        private boolean mCurrentFunctionsApplied;
        private UsbAccessory mCurrentAccessory;
        private int mUsbNotificationId;
        private boolean mAdbNotificationShown;
        private int mCurrentUser;
        private boolean mUsbCharging;
        private String mCurrentOemFunctions;
        private boolean mHideUsbNotification;
        private boolean mSupportsAllCombinations;

        public UsbHandler(Looper looper) {
            super(looper);
            this.mCurrentUser = -10000;
            try {
                if (this.isNormalBoot()) {
                    this.mCurrentFunctions = SystemProperties.get(UsbDeviceManager.USB_CONFIG_PROPERTY, "none");
                    this.mCurrentFunctionsApplied = this.mCurrentFunctions.equals(SystemProperties.get(UsbDeviceManager.USB_STATE_PROPERTY));
                } else {
                    this.mCurrentFunctions = SystemProperties.get(UsbDeviceManager.getPersistProp(true), "none");
                    this.mCurrentFunctionsApplied = SystemProperties.get(UsbDeviceManager.USB_CONFIG_PROPERTY, "none").equals(SystemProperties.get(UsbDeviceManager.USB_STATE_PROPERTY));
                }
                UsbDeviceManager.this.mAdbEnabled = UsbManager.containsFunction(SystemProperties.get(UsbDeviceManager.USB_PERSISTENT_CONFIG_PROPERTY), "adb");
                String persisted = SystemProperties.get(UsbDeviceManager.USB_PERSISTENT_CONFIG_PROPERTY);
                if (UsbManager.containsFunction(persisted, "mtp") || UsbManager.containsFunction(persisted, "ptp")) {
                    SystemProperties.set(UsbDeviceManager.USB_PERSISTENT_CONFIG_PROPERTY, UsbManager.removeFunction(UsbManager.removeFunction(persisted, "mtp"), "ptp"));
                }
                String state = FileUtils.readTextFile(new File(UsbDeviceManager.STATE_PATH), 0, null).trim();
                this.updateState(state);
                UsbDeviceManager.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("adb_enabled"), false, new AdbSettingsObserver());
                UsbDeviceManager.this.mUEventObserver.startObserving(UsbDeviceManager.USB_STATE_MATCH);
                UsbDeviceManager.this.mUEventObserver.startObserving(UsbDeviceManager.ACCESSORY_START_MATCH);
            }
            catch (Exception e) {
                Slog.e(UsbDeviceManager.TAG, "Error initializing UsbHandler", e);
            }
        }

        public void sendMessage(int what, boolean arg) {
            this.removeMessages(what);
            Message m = Message.obtain((Handler)this, what);
            m.arg1 = arg ? 1 : 0;
            this.sendMessage(m);
        }

        public void sendMessage(int what, Object arg) {
            this.removeMessages(what);
            Message m = Message.obtain((Handler)this, what);
            m.obj = arg;
            this.sendMessage(m);
        }

        public void sendMessage(int what, Object arg, boolean arg1) {
            this.removeMessages(what);
            Message m = Message.obtain((Handler)this, what);
            m.obj = arg;
            m.arg1 = arg1 ? 1 : 0;
            this.sendMessage(m);
        }

        public void updateState(String state) {
            int configured;
            int connected;
            if ("DISCONNECTED".equals(state)) {
                connected = 0;
                configured = 0;
            } else if ("CONNECTED".equals(state)) {
                connected = 1;
                configured = 0;
            } else if ("CONFIGURED".equals(state)) {
                connected = 1;
                configured = 1;
            } else {
                Slog.e(UsbDeviceManager.TAG, "unknown state " + state);
                return;
            }
            this.removeMessages(0);
            Message msg = Message.obtain((Handler)this, 0);
            msg.arg1 = connected;
            msg.arg2 = configured;
            this.sendMessageDelayed(msg, connected == 0 ? 1000L : 0L);
        }

        public void updateHostState(UsbPort port, UsbPortStatus status) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = port;
            args.arg2 = status;
            this.removeMessages(7);
            Message msg = this.obtainMessage(7, args);
            this.sendMessageDelayed(msg, 1000L);
        }

        private boolean waitForState(String state) {
            String value = null;
            for (int i = 0; i < 20; ++i) {
                value = SystemProperties.get(UsbDeviceManager.USB_STATE_PROPERTY);
                if (state.equals(value)) {
                    return true;
                }
                SystemClock.sleep(50L);
            }
            Slog.e(UsbDeviceManager.TAG, "waitForState(" + state + ") FAILED: got " + value);
            return false;
        }

        private void setUsbConfig(String config) {
            SystemProperties.set(UsbDeviceManager.USB_CONFIG_PROPERTY, config);
        }

        private void setAdbEnabled(boolean enable) {
            if (enable != UsbDeviceManager.this.mAdbEnabled) {
                UsbDeviceManager.this.mAdbEnabled = enable;
                String oldFunctions = this.mCurrentFunctions;
                String newFunction = this.applyAdbFunction(SystemProperties.get(UsbDeviceManager.USB_PERSISTENT_CONFIG_PROPERTY, "none"));
                SystemProperties.set(UsbDeviceManager.USB_PERSISTENT_CONFIG_PROPERTY, newFunction);
                if (oldFunctions.equals("mtp") && !this.mUsbDataUnlocked && enable) {
                    oldFunctions = "none";
                }
                this.setEnabledFunctions(oldFunctions, true, this.mUsbDataUnlocked);
                this.updateAdbNotification(false);
            }
            if (UsbDeviceManager.this.mDebuggingManager != null) {
                UsbDeviceManager.this.mDebuggingManager.setAdbEnabled(UsbDeviceManager.this.mAdbEnabled);
            }
        }

        private void setEnabledFunctions(String functions, boolean forceRestart, boolean usbDataUnlocked) {
            if (usbDataUnlocked != this.mUsbDataUnlocked) {
                this.mUsbDataUnlocked = usbDataUnlocked;
                this.updateUsbNotification(false);
                forceRestart = true;
            }
            String oldFunctions = this.mCurrentFunctions;
            boolean oldFunctionsApplied = this.mCurrentFunctionsApplied;
            if (this.trySetEnabledFunctions(functions, forceRestart)) {
                return;
            }
            if (oldFunctionsApplied && !oldFunctions.equals(functions)) {
                Slog.e(UsbDeviceManager.TAG, "Failsafe 1: Restoring previous USB functions.");
                if (this.trySetEnabledFunctions(oldFunctions, false)) {
                    return;
                }
            }
            Slog.e(UsbDeviceManager.TAG, "Failsafe 2: Restoring default USB functions.");
            if (this.trySetEnabledFunctions(null, false)) {
                return;
            }
            Slog.e(UsbDeviceManager.TAG, "Failsafe 3: Restoring empty function list (with ADB if enabled).");
            if (this.trySetEnabledFunctions("none", false)) {
                return;
            }
            Slog.e(UsbDeviceManager.TAG, "Unable to set any USB functions!");
        }

        private boolean isNormalBoot() {
            String bootMode = SystemProperties.get(UsbDeviceManager.BOOT_MODE_PROPERTY, "unknown");
            return bootMode.equals(UsbDeviceManager.NORMAL_BOOT) || bootMode.equals("unknown");
        }

        private boolean trySetEnabledFunctions(String functions, boolean forceRestart) {
            if (functions == null || this.applyAdbFunction(functions).equals("none")) {
                functions = this.getDefaultFunctions();
            }
            functions = this.applyAdbFunction(functions);
            String oemFunctions = UsbDeviceManager.this.applyOemOverrideFunction(functions);
            if (!this.isNormalBoot() && !this.mCurrentFunctions.equals(functions)) {
                SystemProperties.set(UsbDeviceManager.getPersistProp(true), functions);
            }
            if (!((functions.equals(oemFunctions) || this.mCurrentOemFunctions != null && this.mCurrentOemFunctions.equals(oemFunctions)) && this.mCurrentFunctions.equals(functions) && this.mCurrentFunctionsApplied && !forceRestart)) {
                Slog.i(UsbDeviceManager.TAG, "Setting USB config to " + functions);
                this.mCurrentFunctions = functions;
                this.mCurrentOemFunctions = oemFunctions;
                this.mCurrentFunctionsApplied = false;
                this.setUsbConfig("none");
                if (!this.waitForState("none")) {
                    Slog.e(UsbDeviceManager.TAG, "Failed to kick USB config");
                    return false;
                }
                this.setUsbConfig(oemFunctions);
                if (UsbDeviceManager.this.mBootCompleted && (UsbManager.containsFunction(functions, "mtp") || UsbManager.containsFunction(functions, "ptp"))) {
                    this.updateUsbStateBroadcastIfNeeded(true);
                }
                if (!this.waitForState(oemFunctions)) {
                    Slog.e(UsbDeviceManager.TAG, "Failed to switch USB config to " + functions);
                    return false;
                }
                this.mCurrentFunctionsApplied = true;
            }
            return true;
        }

        private String applyAdbFunction(String functions) {
            if (functions == null) {
                functions = "";
            }
            functions = UsbDeviceManager.this.mAdbEnabled ? UsbManager.addFunction(functions, "adb") : UsbManager.removeFunction(functions, "adb");
            return functions;
        }

        private boolean isUsbTransferAllowed() {
            UserManager userManager = (UserManager)UsbDeviceManager.this.mContext.getSystemService("user");
            return !userManager.hasUserRestriction("no_usb_file_transfer");
        }

        private void updateCurrentAccessory() {
            boolean enteringAccessoryMode = this.hasMessages(8);
            if (this.mConfigured && enteringAccessoryMode) {
                if (UsbDeviceManager.this.mAccessoryStrings != null) {
                    this.mCurrentAccessory = new UsbAccessory(UsbDeviceManager.this.mAccessoryStrings);
                    Slog.d(UsbDeviceManager.TAG, "entering USB accessory mode: " + this.mCurrentAccessory);
                    if (UsbDeviceManager.this.mBootCompleted) {
                        UsbDeviceManager.this.getCurrentSettings().accessoryAttached(this.mCurrentAccessory);
                    }
                } else {
                    Slog.e(UsbDeviceManager.TAG, "nativeGetAccessoryStrings failed");
                }
            } else if (!enteringAccessoryMode) {
                this.notifyAccessoryModeExit();
            }
        }

        private void notifyAccessoryModeExit() {
            Slog.d(UsbDeviceManager.TAG, "exited USB accessory mode");
            this.setEnabledFunctions(null, false, false);
            if (this.mCurrentAccessory != null) {
                if (UsbDeviceManager.this.mBootCompleted) {
                    UsbDeviceManager.this.mSettingsManager.usbAccessoryRemoved(this.mCurrentAccessory);
                }
                this.mCurrentAccessory = null;
                UsbDeviceManager.access$902(UsbDeviceManager.this, null);
            }
        }

        private boolean isUsbStateChanged(Intent intent) {
            Set<String> keySet = intent.getExtras().keySet();
            if (UsbDeviceManager.this.mBroadcastedIntent == null) {
                for (String key : keySet) {
                    if (!intent.getBooleanExtra(key, false)) continue;
                    return true;
                }
            } else {
                if (!keySet.equals(UsbDeviceManager.this.mBroadcastedIntent.getExtras().keySet())) {
                    return true;
                }
                for (String key : keySet) {
                    if (intent.getBooleanExtra(key, false) == UsbDeviceManager.this.mBroadcastedIntent.getBooleanExtra(key, false)) continue;
                    return true;
                }
            }
            return false;
        }

        private void updateUsbStateBroadcastIfNeeded(boolean configChanged) {
            Intent intent = new Intent("android.hardware.usb.action.USB_STATE");
            intent.addFlags(0x31000000);
            intent.putExtra("connected", this.mConnected);
            intent.putExtra("host_connected", this.mHostConnected);
            intent.putExtra("configured", this.mConfigured);
            intent.putExtra("unlocked", this.isUsbTransferAllowed() && this.mUsbDataUnlocked);
            intent.putExtra("config_changed", configChanged);
            if (this.mCurrentFunctions != null) {
                String[] functions = this.mCurrentFunctions.split(",");
                for (int i = 0; i < functions.length; ++i) {
                    String function = functions[i];
                    if ("none".equals(function)) continue;
                    intent.putExtra(function, true);
                }
            }
            if (!this.isUsbStateChanged(intent) && !configChanged) {
                return;
            }
            UsbDeviceManager.this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
            UsbDeviceManager.this.mBroadcastedIntent = intent;
        }

        private void updateUsbFunctions() {
            this.updateAudioSourceFunction();
            this.updateMidiFunction();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateAudioSourceFunction() {
            boolean enabled = UsbManager.containsFunction(this.mCurrentFunctions, "audio_source");
            if (enabled != UsbDeviceManager.this.mAudioSourceEnabled) {
                int card = -1;
                int device = -1;
                if (enabled) {
                    try (Scanner scanner = null;){
                        scanner = new Scanner(new File(UsbDeviceManager.AUDIO_SOURCE_PCM_PATH));
                        card = scanner.nextInt();
                        device = scanner.nextInt();
                    }
                }
                UsbDeviceManager.this.mUsbAlsaManager.setAccessoryAudioState(enabled, card, device);
                UsbDeviceManager.this.mAudioSourceEnabled = enabled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateMidiFunction() {
            boolean enabled = UsbManager.containsFunction(this.mCurrentFunctions, "midi");
            if (enabled != UsbDeviceManager.this.mMidiEnabled) {
                if (enabled) {
                    try (Scanner scanner = null;){
                        scanner = new Scanner(new File(UsbDeviceManager.MIDI_ALSA_PATH));
                        UsbDeviceManager.this.mMidiCard = scanner.nextInt();
                        UsbDeviceManager.this.mMidiDevice = scanner.nextInt();
                    }
                }
                UsbDeviceManager.this.mMidiEnabled = enabled;
            }
            UsbDeviceManager.this.mUsbAlsaManager.setPeripheralMidiState(UsbDeviceManager.this.mMidiEnabled && this.mConfigured, UsbDeviceManager.this.mMidiCard, UsbDeviceManager.this.mMidiDevice);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.mConnected = msg.arg1 == 1;
                    this.mConfigured = msg.arg2 == 1;
                    this.updateUsbNotification(false);
                    this.updateAdbNotification(false);
                    if (UsbDeviceManager.this.mBootCompleted) {
                        this.updateUsbStateBroadcastIfNeeded(false);
                    }
                    if (UsbManager.containsFunction(this.mCurrentFunctions, "accessory")) {
                        this.updateCurrentAccessory();
                    }
                    if (UsbDeviceManager.this.mBootCompleted) {
                        if (!this.mConnected) {
                            this.setEnabledFunctions(null, !UsbDeviceManager.this.mAdbEnabled, false);
                        }
                        this.updateUsbFunctions();
                        break;
                    }
                    UsbDeviceManager.this.mPendingBootBroadcast = true;
                    break;
                }
                case 7: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    boolean prevHostConnected = this.mHostConnected;
                    UsbPort port = (UsbPort)args.arg1;
                    UsbPortStatus status = (UsbPortStatus)args.arg2;
                    this.mHostConnected = status.getCurrentDataRole() == 1;
                    this.mSourcePower = status.getCurrentPowerRole() == 1;
                    this.mSinkPower = status.getCurrentPowerRole() == 2;
                    this.mAudioAccessoryConnected = status.getCurrentMode() == 4;
                    this.mAudioAccessorySupported = port.isModeSupported(4);
                    this.mSupportsAllCombinations = status.isRoleCombinationSupported(1, 1) && status.isRoleCombinationSupported(2, 1) && status.isRoleCombinationSupported(1, 2) && status.isRoleCombinationSupported(2, 1);
                    args.recycle();
                    this.updateUsbNotification(false);
                    if (UsbDeviceManager.this.mBootCompleted) {
                        if (!this.mHostConnected && !prevHostConnected) break;
                        this.updateUsbStateBroadcastIfNeeded(false);
                        break;
                    }
                    UsbDeviceManager.this.mPendingBootBroadcast = true;
                    break;
                }
                case 9: {
                    this.mUsbCharging = msg.arg1 == 1;
                    this.updateUsbNotification(false);
                    break;
                }
                case 10: {
                    Iterator devices = (Iterator)msg.obj;
                    boolean connected = msg.arg1 == 1;
                    this.mHideUsbNotification = false;
                    while (devices.hasNext()) {
                        Map.Entry pair = (Map.Entry)devices.next();
                        UsbDevice device = (UsbDevice)pair.getValue();
                        int configurationCount = device.getConfigurationCount() - 1;
                        block15: while (configurationCount >= 0) {
                            UsbConfiguration config = device.getConfiguration(configurationCount);
                            --configurationCount;
                            for (int interfaceCount = config.getInterfaceCount() - 1; interfaceCount >= 0; --interfaceCount) {
                                UsbInterface intrface = config.getInterface(interfaceCount);
                                if (!sBlackListedInterfaces.contains(intrface.getInterfaceClass())) continue;
                                this.mHideUsbNotification = true;
                                continue block15;
                            }
                        }
                    }
                    this.updateUsbNotification(false);
                    break;
                }
                case 1: {
                    this.setAdbEnabled(msg.arg1 == 1);
                    break;
                }
                case 2: {
                    String functions = (String)msg.obj;
                    this.setEnabledFunctions(functions, false, msg.arg1 == 1);
                    break;
                }
                case 6: {
                    boolean forceRestart = this.mUsbDataUnlocked && this.isUsbDataTransferActive() && !this.isUsbTransferAllowed();
                    this.setEnabledFunctions(this.mCurrentFunctions, forceRestart, this.mUsbDataUnlocked && !forceRestart);
                    break;
                }
                case 3: {
                    this.updateUsbNotification(false);
                    this.updateAdbNotification(false);
                    this.updateUsbFunctions();
                    break;
                }
                case 11: {
                    this.updateAdbNotification(true);
                    this.updateUsbNotification(true);
                    break;
                }
                case 4: {
                    UsbDeviceManager.this.mBootCompleted = true;
                    if (UsbDeviceManager.this.mPendingBootBroadcast) {
                        this.updateUsbStateBroadcastIfNeeded(false);
                        UsbDeviceManager.this.mPendingBootBroadcast = false;
                    }
                    this.setEnabledFunctions(null, false, false);
                    if (this.mCurrentAccessory != null) {
                        UsbDeviceManager.this.getCurrentSettings().accessoryAttached(this.mCurrentAccessory);
                    }
                    if (UsbDeviceManager.this.mDebuggingManager == null) break;
                    UsbDeviceManager.this.mDebuggingManager.setAdbEnabled(UsbDeviceManager.this.mAdbEnabled);
                    break;
                }
                case 5: {
                    if (this.mCurrentUser == msg.arg1) break;
                    if (this.mUsbDataUnlocked && this.isUsbDataTransferActive() && this.mCurrentUser != -10000) {
                        Slog.v(UsbDeviceManager.TAG, "Current user switched to " + msg.arg1 + "; resetting USB host stack for MTP or PTP");
                        this.setEnabledFunctions(null, true, false);
                    }
                    this.mCurrentUser = msg.arg1;
                    break;
                }
                case 8: {
                    if (this.mConnected && UsbManager.containsFunction(this.mCurrentFunctions, "accessory")) break;
                    this.notifyAccessoryModeExit();
                }
            }
        }

        private boolean isUsbDataTransferActive() {
            return UsbManager.containsFunction(this.mCurrentFunctions, "mtp") || UsbManager.containsFunction(this.mCurrentFunctions, "ptp");
        }

        public UsbAccessory getCurrentAccessory() {
            return this.mCurrentAccessory;
        }

        private void updateUsbNotification(boolean force) {
            if (UsbDeviceManager.this.mNotificationManager == null || !UsbDeviceManager.this.mUseUsbNotification || "0".equals(SystemProperties.get("persist.charging.notify"))) {
                return;
            }
            if (this.mHideUsbNotification && !this.mSupportsAllCombinations) {
                if (this.mUsbNotificationId != 0) {
                    UsbDeviceManager.this.mNotificationManager.cancelAsUser(null, this.mUsbNotificationId, UserHandle.ALL);
                    this.mUsbNotificationId = 0;
                    Slog.d(UsbDeviceManager.TAG, "Clear notification");
                }
                return;
            }
            int id2 = 0;
            int titleRes = 0;
            Resources r = UsbDeviceManager.this.mContext.getResources();
            if (this.mAudioAccessoryConnected && !this.mAudioAccessorySupported) {
                titleRes = 17040907;
                id2 = 41;
            } else if (this.mConnected) {
                if (!this.mUsbDataUnlocked) {
                    if (this.mSourcePower) {
                        titleRes = 17040905;
                        id2 = 31;
                    } else {
                        titleRes = 17040895;
                        id2 = 32;
                    }
                } else if (UsbManager.containsFunction(this.mCurrentFunctions, "mtp")) {
                    titleRes = 17040902;
                    id2 = 27;
                } else if (UsbManager.containsFunction(this.mCurrentFunctions, "ptp")) {
                    titleRes = 17040904;
                    id2 = 28;
                } else if (UsbManager.containsFunction(this.mCurrentFunctions, "midi")) {
                    titleRes = 17040896;
                    id2 = 29;
                } else if (UsbManager.containsFunction(this.mCurrentFunctions, "accessory")) {
                    titleRes = 17040894;
                    id2 = 30;
                } else if (this.mSourcePower) {
                    titleRes = 17040905;
                    id2 = 31;
                } else {
                    titleRes = 17040895;
                    id2 = 32;
                }
            } else if (this.mSourcePower) {
                titleRes = 17040905;
                id2 = 31;
            } else if (this.mHostConnected && this.mSinkPower && this.mUsbCharging) {
                titleRes = 17040895;
                id2 = 32;
            }
            if (id2 != this.mUsbNotificationId || force) {
                if (this.mUsbNotificationId != 0) {
                    UsbDeviceManager.this.mNotificationManager.cancelAsUser(null, this.mUsbNotificationId, UserHandle.ALL);
                    Slog.d(UsbDeviceManager.TAG, "Clear notification");
                    this.mUsbNotificationId = 0;
                }
                if (id2 != 0) {
                    CharSequence message;
                    String channel;
                    PendingIntent pi;
                    Intent intent;
                    CharSequence title = r.getText(titleRes);
                    if (titleRes != 17040907) {
                        intent = Intent.makeRestartActivityTask(new ComponentName("com.android.settings", "com.android.settings.deviceinfo.UsbModeChooserActivity"));
                        pi = PendingIntent.getActivityAsUser(UsbDeviceManager.this.mContext, 0, intent, 0, null, UserHandle.CURRENT);
                        channel = SystemNotificationChannels.USB;
                        message = r.getText(17040903);
                    } else {
                        intent = new Intent();
                        intent.setClassName("com.android.settings", "com.android.settings.HelpTrampoline");
                        intent.putExtra("android.intent.extra.TEXT", "help_url_audio_accessory_not_supported");
                        pi = UsbDeviceManager.this.mContext.getPackageManager().resolveActivity(intent, 0) != null ? PendingIntent.getActivity(UsbDeviceManager.this.mContext, 0, intent, 0) : null;
                        channel = SystemNotificationChannels.ALERTS;
                        message = r.getText(17040906);
                    }
                    Notification.Builder builder = new Notification.Builder(UsbDeviceManager.this.mContext, channel).setSmallIcon(17303428).setWhen(0L).setOngoing(true).setTicker(title).setDefaults(0).setColor(UsbDeviceManager.this.mContext.getColor(17170763)).setContentTitle(title).setContentText(message).setContentIntent(pi).setVisibility(1);
                    if (titleRes == 17040907) {
                        builder.setStyle(new Notification.BigTextStyle().bigText(message));
                    }
                    Notification notification = builder.build();
                    UsbDeviceManager.this.mNotificationManager.notifyAsUser(null, id2, notification, UserHandle.ALL);
                    Slog.d(UsbDeviceManager.TAG, "push notification:" + title);
                    this.mUsbNotificationId = id2;
                }
            }
        }

        private void updateAdbNotification(boolean force) {
            if (UsbDeviceManager.this.mNotificationManager == null) {
                return;
            }
            int id2 = 26;
            int titleRes = 17039443;
            if (UsbDeviceManager.this.mAdbEnabled && this.mConnected) {
                if ("0".equals(SystemProperties.get("persist.adb.notify"))) {
                    return;
                }
                if (force && this.mAdbNotificationShown) {
                    this.mAdbNotificationShown = false;
                    UsbDeviceManager.this.mNotificationManager.cancelAsUser(null, 26, UserHandle.ALL);
                }
                if (!this.mAdbNotificationShown) {
                    Resources r = UsbDeviceManager.this.mContext.getResources();
                    CharSequence title = r.getText(17039443);
                    CharSequence message = r.getText(17039442);
                    Intent intent = new Intent("android.settings.APPLICATION_DEVELOPMENT_SETTINGS");
                    intent.addFlags(0x10008000);
                    PendingIntent pi = PendingIntent.getActivityAsUser(UsbDeviceManager.this.mContext, 0, intent, 0, null, UserHandle.CURRENT);
                    Notification notification = new Notification.Builder(UsbDeviceManager.this.mContext, SystemNotificationChannels.DEVELOPER).setSmallIcon(17303428).setWhen(0L).setOngoing(true).setTicker(title).setDefaults(0).setColor(UsbDeviceManager.this.mContext.getColor(17170763)).setContentTitle(title).setContentText(message).setContentIntent(pi).setVisibility(1).extend(new Notification.TvExtender().setChannelId(UsbDeviceManager.ADB_NOTIFICATION_CHANNEL_ID_TV)).build();
                    this.mAdbNotificationShown = true;
                    UsbDeviceManager.this.mNotificationManager.notifyAsUser(null, 26, notification, UserHandle.ALL);
                }
            } else if (this.mAdbNotificationShown) {
                this.mAdbNotificationShown = false;
                UsbDeviceManager.this.mNotificationManager.cancelAsUser(null, 26, UserHandle.ALL);
            }
        }

        private String getDefaultFunctions() {
            String func = SystemProperties.get(UsbDeviceManager.getPersistProp(true), "none");
            if (UsbManager.containsFunction(func, "adb")) {
                return "adb";
            }
            return "mtp";
        }

        public void dump(IndentingPrintWriter pw) {
            pw.println("USB Device State:");
            pw.println("  mCurrentFunctions: " + this.mCurrentFunctions);
            pw.println("  mCurrentOemFunctions: " + this.mCurrentOemFunctions);
            pw.println("  mCurrentFunctionsApplied: " + this.mCurrentFunctionsApplied);
            pw.println("  mConnected: " + this.mConnected);
            pw.println("  mConfigured: " + this.mConfigured);
            pw.println("  mUsbDataUnlocked: " + this.mUsbDataUnlocked);
            pw.println("  mCurrentAccessory: " + this.mCurrentAccessory);
            pw.println("  mHostConnected: " + this.mHostConnected);
            pw.println("  mSourcePower: " + this.mSourcePower);
            pw.println("  mSinkPower: " + this.mSinkPower);
            pw.println("  mUsbCharging: " + this.mUsbCharging);
            pw.println("  mHideUsbNotification: " + this.mHideUsbNotification);
            pw.println("  mAudioAccessoryConnected: " + this.mAudioAccessoryConnected);
            try {
                pw.println("  Kernel state: " + FileUtils.readTextFile(new File(UsbDeviceManager.STATE_PATH), 0, null).trim());
                pw.println("  Kernel function list: " + FileUtils.readTextFile(new File(UsbDeviceManager.FUNCTIONS_PATH), 0, null).trim());
            }
            catch (IOException e) {
                pw.println("IOException: " + e);
            }
        }
    }

    private class AdbSettingsObserver
    extends ContentObserver {
        public AdbSettingsObserver() {
            super(null);
        }

        @Override
        public void onChange(boolean selfChange) {
            boolean enable = Settings.Global.getInt(UsbDeviceManager.this.mContentResolver, "adb_enabled", 0) > 0;
            UsbDeviceManager.this.mHandler.sendMessage(1, enable);
        }
    }
}

