/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.tv;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.media.tv.ITvRemoteProvider;
import android.media.tv.ITvRemoteServiceInput;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;

final class TvRemoteProviderProxy
implements ServiceConnection {
    private static final String TAG = "TvRemoteProvProxy";
    private static final boolean DEBUG = Log.isLoggable("TvRemoteProvProxy", 2);
    private static final boolean DEBUG_KEY = false;
    protected static final String SERVICE_INTERFACE = "com.android.media.tv.remoteprovider.TvRemoteProvider";
    private final Context mContext;
    private final ComponentName mComponentName;
    private final int mUserId;
    private final int mUid;
    private final Handler mHandler;
    private final Object mLock = new Object();
    private ProviderMethods mProviderMethods;
    private boolean mRunning;
    private boolean mBound;
    private Connection mActiveConnection;
    private boolean mConnectionReady;

    public TvRemoteProviderProxy(Context context, ComponentName componentName, int userId, int uid) {
        this.mContext = context;
        this.mComponentName = componentName;
        this.mUserId = userId;
        this.mUid = uid;
        this.mHandler = new Handler();
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "Proxy");
        pw.println(prefix + "  mUserId=" + this.mUserId);
        pw.println(prefix + "  mRunning=" + this.mRunning);
        pw.println(prefix + "  mBound=" + this.mBound);
        pw.println(prefix + "  mActiveConnection=" + this.mActiveConnection);
        pw.println(prefix + "  mConnectionReady=" + this.mConnectionReady);
    }

    public void setProviderSink(ProviderMethods provider) {
        this.mProviderMethods = provider;
    }

    public boolean hasComponentName(String packageName, String className) {
        return this.mComponentName.getPackageName().equals(packageName) && this.mComponentName.getClassName().equals(className);
    }

    public void start() {
        if (!this.mRunning) {
            if (DEBUG) {
                Slog.d(TAG, this + ": Starting");
            }
            this.mRunning = true;
            this.updateBinding();
        }
    }

    public void stop() {
        if (this.mRunning) {
            if (DEBUG) {
                Slog.d(TAG, this + ": Stopping");
            }
            this.mRunning = false;
            this.updateBinding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebindIfDisconnected() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mActiveConnection == null && this.shouldBind()) {
                this.unbind();
                this.bind();
            }
        }
    }

    private void updateBinding() {
        if (this.shouldBind()) {
            this.bind();
        } else {
            this.unbind();
        }
    }

    private boolean shouldBind() {
        return this.mRunning;
    }

    private void bind() {
        block5: {
            if (!this.mBound) {
                if (DEBUG) {
                    Slog.d(TAG, this + ": Binding");
                }
                Intent service = new Intent(SERVICE_INTERFACE);
                service.setComponent(this.mComponentName);
                try {
                    this.mBound = this.mContext.bindServiceAsUser(service, this, 0x4000001, new UserHandle(this.mUserId));
                    if (!this.mBound && DEBUG) {
                        Slog.d(TAG, this + ": Bind failed");
                    }
                }
                catch (SecurityException ex) {
                    if (!DEBUG) break block5;
                    Slog.d(TAG, this + ": Bind failed", ex);
                }
            }
        }
    }

    private void unbind() {
        if (this.mBound) {
            if (DEBUG) {
                Slog.d(TAG, this + ": Unbinding");
            }
            this.mBound = false;
            this.disconnect();
            this.mContext.unbindService(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        if (DEBUG) {
            Slog.d(TAG, this + ": onServiceConnected()");
        }
        if (this.mBound) {
            this.disconnect();
            ITvRemoteProvider provider = ITvRemoteProvider.Stub.asInterface(service);
            if (provider != null) {
                Connection connection = new Connection(provider);
                if (connection.register()) {
                    Object object = this.mLock;
                    synchronized (object) {
                        this.mActiveConnection = connection;
                    }
                    if (DEBUG) {
                        Slog.d(TAG, this + ": Connected successfully.");
                    }
                } else if (DEBUG) {
                    Slog.d(TAG, this + ": Registration failed");
                }
            } else {
                Slog.e(TAG, this + ": Service returned invalid remote-control provider binder");
            }
        }
    }

    @Override
    public void onServiceDisconnected(ComponentName name) {
        if (DEBUG) {
            Slog.d(TAG, this + ": Service disconnected");
        }
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectionReady(Connection connection) {
        Object object = this.mLock;
        synchronized (object) {
            if (DEBUG) {
                Slog.d(TAG, "onConnectionReady");
            }
            if (this.mActiveConnection == connection) {
                if (DEBUG) {
                    Slog.d(TAG, "mConnectionReady = true");
                }
                this.mConnectionReady = true;
            }
        }
    }

    private void onConnectionDied(Connection connection) {
        if (this.mActiveConnection == connection) {
            if (DEBUG) {
                Slog.d(TAG, this + ": Service connection died");
            }
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mActiveConnection != null) {
                this.mConnectionReady = false;
                this.mActiveConnection.dispose();
                this.mActiveConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputBridgeConnected(IBinder token) {
        Object object = this.mLock;
        synchronized (object) {
            if (DEBUG) {
                Slog.d(TAG, this + ": inputBridgeConnected token: " + token);
            }
            if (this.mConnectionReady) {
                this.mActiveConnection.onInputBridgeConnected(token);
            }
        }
    }

    private static final class RemoteServiceInputProvider
    extends ITvRemoteServiceInput.Stub {
        private final WeakReference<Connection> mConnectionRef;

        public RemoteServiceInputProvider(Connection connection) {
            this.mConnectionRef = new WeakReference<Connection>(connection);
        }

        public void dispose() {
            this.mConnectionRef.clear();
        }

        @Override
        public void openInputBridge(IBinder token, String name, int width, int height, int maxPointers) throws RemoteException {
            Connection connection = (Connection)this.mConnectionRef.get();
            if (connection != null) {
                connection.openInputBridge(token, name, width, height, maxPointers);
            }
        }

        @Override
        public void closeInputBridge(IBinder token) throws RemoteException {
            Connection connection = (Connection)this.mConnectionRef.get();
            if (connection != null) {
                connection.closeInputBridge(token);
            }
        }

        @Override
        public void clearInputBridge(IBinder token) throws RemoteException {
            Connection connection = (Connection)this.mConnectionRef.get();
            if (connection != null) {
                connection.clearInputBridge(token);
            }
        }

        @Override
        public void sendTimestamp(IBinder token, long timestamp) throws RemoteException {
            Connection connection = (Connection)this.mConnectionRef.get();
            if (connection != null) {
                connection.sendTimestamp(token, timestamp);
            }
        }

        @Override
        public void sendKeyDown(IBinder token, int keyCode) throws RemoteException {
            Connection connection = (Connection)this.mConnectionRef.get();
            if (connection != null) {
                connection.sendKeyDown(token, keyCode);
            }
        }

        @Override
        public void sendKeyUp(IBinder token, int keyCode) throws RemoteException {
            Connection connection = (Connection)this.mConnectionRef.get();
            if (connection != null) {
                connection.sendKeyUp(token, keyCode);
            }
        }

        @Override
        public void sendPointerDown(IBinder token, int pointerId, int x, int y) throws RemoteException {
            Connection connection = (Connection)this.mConnectionRef.get();
            if (connection != null) {
                connection.sendPointerDown(token, pointerId, x, y);
            }
        }

        @Override
        public void sendPointerUp(IBinder token, int pointerId) throws RemoteException {
            Connection connection = (Connection)this.mConnectionRef.get();
            if (connection != null) {
                connection.sendPointerUp(token, pointerId);
            }
        }

        @Override
        public void sendPointerSync(IBinder token) throws RemoteException {
            Connection connection = (Connection)this.mConnectionRef.get();
            if (connection != null) {
                connection.sendPointerSync(token);
            }
        }
    }

    private final class Connection
    implements IBinder.DeathRecipient {
        private final ITvRemoteProvider mTvRemoteProvider;
        private final RemoteServiceInputProvider mServiceInputProvider;

        public Connection(ITvRemoteProvider provider) {
            this.mTvRemoteProvider = provider;
            this.mServiceInputProvider = new RemoteServiceInputProvider(this);
        }

        public boolean register() {
            if (DEBUG) {
                Slog.d(TvRemoteProviderProxy.TAG, "Connection::register()");
            }
            try {
                this.mTvRemoteProvider.asBinder().linkToDeath(this, 0);
                this.mTvRemoteProvider.setRemoteServiceInputSink(this.mServiceInputProvider);
                TvRemoteProviderProxy.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        TvRemoteProviderProxy.this.onConnectionReady(Connection.this);
                    }
                });
                return true;
            }
            catch (RemoteException ex) {
                this.binderDied();
                return false;
            }
        }

        public void dispose() {
            if (DEBUG) {
                Slog.d(TvRemoteProviderProxy.TAG, "Connection::dispose()");
            }
            this.mTvRemoteProvider.asBinder().unlinkToDeath(this, 0);
            this.mServiceInputProvider.dispose();
        }

        public void onInputBridgeConnected(IBinder token) {
            if (DEBUG) {
                Slog.d(TvRemoteProviderProxy.TAG, this + ": onInputBridgeConnected");
            }
            try {
                this.mTvRemoteProvider.onInputBridgeConnected(token);
            }
            catch (RemoteException ex) {
                Slog.e(TvRemoteProviderProxy.TAG, "Failed to deliver onInputBridgeConnected. ", ex);
            }
        }

        @Override
        public void binderDied() {
            TvRemoteProviderProxy.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TvRemoteProviderProxy.this.onConnectionDied(Connection.this);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void openInputBridge(IBinder token, String name, int width, int height, int maxPointers) {
            Object object = TvRemoteProviderProxy.this.mLock;
            synchronized (object) {
                if (TvRemoteProviderProxy.this.mActiveConnection == this && Binder.getCallingUid() == TvRemoteProviderProxy.this.mUid) {
                    if (DEBUG) {
                        Slog.d(TvRemoteProviderProxy.TAG, this + ": openInputBridge," + " token=" + token + ", name=" + name);
                    }
                    long idToken = Binder.clearCallingIdentity();
                    try {
                        if (TvRemoteProviderProxy.this.mProviderMethods == null) return;
                        TvRemoteProviderProxy.this.mProviderMethods.openInputBridge(TvRemoteProviderProxy.this, token, name, width, height, maxPointers);
                    }
                    finally {
                        Binder.restoreCallingIdentity(idToken);
                    }
                } else {
                    if (!DEBUG) return;
                    Slog.w(TvRemoteProviderProxy.TAG, "openInputBridge, Invalid connection or incorrect uid: " + Binder.getCallingUid());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void closeInputBridge(IBinder token) {
            Object object = TvRemoteProviderProxy.this.mLock;
            synchronized (object) {
                if (TvRemoteProviderProxy.this.mActiveConnection == this && Binder.getCallingUid() == TvRemoteProviderProxy.this.mUid) {
                    if (DEBUG) {
                        Slog.d(TvRemoteProviderProxy.TAG, this + ": closeInputBridge," + " token=" + token);
                    }
                    long idToken = Binder.clearCallingIdentity();
                    try {
                        if (TvRemoteProviderProxy.this.mProviderMethods == null) return;
                        TvRemoteProviderProxy.this.mProviderMethods.closeInputBridge(TvRemoteProviderProxy.this, token);
                    }
                    finally {
                        Binder.restoreCallingIdentity(idToken);
                    }
                } else {
                    if (!DEBUG) return;
                    Slog.w(TvRemoteProviderProxy.TAG, "closeInputBridge, Invalid connection or incorrect uid: " + Binder.getCallingUid());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void clearInputBridge(IBinder token) {
            Object object = TvRemoteProviderProxy.this.mLock;
            synchronized (object) {
                if (TvRemoteProviderProxy.this.mActiveConnection == this && Binder.getCallingUid() == TvRemoteProviderProxy.this.mUid) {
                    if (DEBUG) {
                        Slog.d(TvRemoteProviderProxy.TAG, this + ": clearInputBridge," + " token=" + token);
                    }
                    long idToken = Binder.clearCallingIdentity();
                    try {
                        if (TvRemoteProviderProxy.this.mProviderMethods == null) return;
                        TvRemoteProviderProxy.this.mProviderMethods.clearInputBridge(TvRemoteProviderProxy.this, token);
                    }
                    finally {
                        Binder.restoreCallingIdentity(idToken);
                    }
                } else {
                    if (!DEBUG) return;
                    Slog.w(TvRemoteProviderProxy.TAG, "clearInputBridge, Invalid connection or incorrect uid: " + Binder.getCallingUid());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void sendTimestamp(IBinder token, long timestamp) {
            Object object = TvRemoteProviderProxy.this.mLock;
            synchronized (object) {
                if (TvRemoteProviderProxy.this.mActiveConnection == this && Binder.getCallingUid() == TvRemoteProviderProxy.this.mUid) {
                    long idToken = Binder.clearCallingIdentity();
                    try {
                        if (TvRemoteProviderProxy.this.mProviderMethods == null) return;
                        TvRemoteProviderProxy.this.mProviderMethods.sendTimeStamp(TvRemoteProviderProxy.this, token, timestamp);
                    }
                    finally {
                        Binder.restoreCallingIdentity(idToken);
                    }
                } else {
                    if (!DEBUG) return;
                    Slog.w(TvRemoteProviderProxy.TAG, "sendTimeStamp, Invalid connection or incorrect uid: " + Binder.getCallingUid());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void sendKeyDown(IBinder token, int keyCode) {
            Object object = TvRemoteProviderProxy.this.mLock;
            synchronized (object) {
                if (TvRemoteProviderProxy.this.mActiveConnection == this && Binder.getCallingUid() == TvRemoteProviderProxy.this.mUid) {
                    long idToken = Binder.clearCallingIdentity();
                    try {
                        if (TvRemoteProviderProxy.this.mProviderMethods == null) return;
                        TvRemoteProviderProxy.this.mProviderMethods.sendKeyDown(TvRemoteProviderProxy.this, token, keyCode);
                    }
                    finally {
                        Binder.restoreCallingIdentity(idToken);
                    }
                } else {
                    if (!DEBUG) return;
                    Slog.w(TvRemoteProviderProxy.TAG, "sendKeyDown, Invalid connection or incorrect uid: " + Binder.getCallingUid());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void sendKeyUp(IBinder token, int keyCode) {
            Object object = TvRemoteProviderProxy.this.mLock;
            synchronized (object) {
                if (TvRemoteProviderProxy.this.mActiveConnection == this && Binder.getCallingUid() == TvRemoteProviderProxy.this.mUid) {
                    long idToken = Binder.clearCallingIdentity();
                    try {
                        if (TvRemoteProviderProxy.this.mProviderMethods == null) return;
                        TvRemoteProviderProxy.this.mProviderMethods.sendKeyUp(TvRemoteProviderProxy.this, token, keyCode);
                    }
                    finally {
                        Binder.restoreCallingIdentity(idToken);
                    }
                } else {
                    if (!DEBUG) return;
                    Slog.w(TvRemoteProviderProxy.TAG, "sendKeyUp, Invalid connection or incorrect uid: " + Binder.getCallingUid());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void sendPointerDown(IBinder token, int pointerId, int x, int y) {
            Object object = TvRemoteProviderProxy.this.mLock;
            synchronized (object) {
                if (TvRemoteProviderProxy.this.mActiveConnection == this && Binder.getCallingUid() == TvRemoteProviderProxy.this.mUid) {
                    long idToken = Binder.clearCallingIdentity();
                    try {
                        if (TvRemoteProviderProxy.this.mProviderMethods == null) return;
                        TvRemoteProviderProxy.this.mProviderMethods.sendPointerDown(TvRemoteProviderProxy.this, token, pointerId, x, y);
                    }
                    finally {
                        Binder.restoreCallingIdentity(idToken);
                    }
                } else {
                    if (!DEBUG) return;
                    Slog.w(TvRemoteProviderProxy.TAG, "sendPointerDown, Invalid connection or incorrect uid: " + Binder.getCallingUid());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void sendPointerUp(IBinder token, int pointerId) {
            Object object = TvRemoteProviderProxy.this.mLock;
            synchronized (object) {
                if (TvRemoteProviderProxy.this.mActiveConnection == this && Binder.getCallingUid() == TvRemoteProviderProxy.this.mUid) {
                    long idToken = Binder.clearCallingIdentity();
                    try {
                        if (TvRemoteProviderProxy.this.mProviderMethods == null) return;
                        TvRemoteProviderProxy.this.mProviderMethods.sendPointerUp(TvRemoteProviderProxy.this, token, pointerId);
                    }
                    finally {
                        Binder.restoreCallingIdentity(idToken);
                    }
                } else {
                    if (!DEBUG) return;
                    Slog.w(TvRemoteProviderProxy.TAG, "sendPointerUp, Invalid connection or incorrect uid: " + Binder.getCallingUid());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void sendPointerSync(IBinder token) {
            Object object = TvRemoteProviderProxy.this.mLock;
            synchronized (object) {
                if (TvRemoteProviderProxy.this.mActiveConnection == this && Binder.getCallingUid() == TvRemoteProviderProxy.this.mUid) {
                    long idToken = Binder.clearCallingIdentity();
                    try {
                        if (TvRemoteProviderProxy.this.mProviderMethods == null) return;
                        TvRemoteProviderProxy.this.mProviderMethods.sendPointerSync(TvRemoteProviderProxy.this, token);
                    }
                    finally {
                        Binder.restoreCallingIdentity(idToken);
                    }
                } else {
                    if (!DEBUG) return;
                    Slog.w(TvRemoteProviderProxy.TAG, "sendPointerSync, Invalid connection or incorrect uid: " + Binder.getCallingUid());
                }
                return;
            }
        }
    }

    public static interface ProviderMethods {
        public void openInputBridge(TvRemoteProviderProxy var1, IBinder var2, String var3, int var4, int var5, int var6);

        public void closeInputBridge(TvRemoteProviderProxy var1, IBinder var2);

        public void clearInputBridge(TvRemoteProviderProxy var1, IBinder var2);

        public void sendTimeStamp(TvRemoteProviderProxy var1, IBinder var2, long var3);

        public void sendKeyDown(TvRemoteProviderProxy var1, IBinder var2, int var3);

        public void sendKeyUp(TvRemoteProviderProxy var1, IBinder var2, int var3);

        public void sendPointerDown(TvRemoteProviderProxy var1, IBinder var2, int var3, int var4, int var5);

        public void sendPointerUp(TvRemoteProviderProxy var1, IBinder var2, int var3);

        public void sendPointerSync(TvRemoteProviderProxy var1, IBinder var2);
    }
}

