/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.timezone;

import com.android.server.timezone.PackageVersions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

final class PackageStatus {
    static final int CHECK_STARTED = 1;
    static final int CHECK_COMPLETED_SUCCESS = 2;
    static final int CHECK_COMPLETED_FAILURE = 3;
    final int mCheckStatus;
    final PackageVersions mVersions;

    PackageStatus(int checkStatus, PackageVersions versions) {
        this.mCheckStatus = checkStatus;
        if (checkStatus < 1 || checkStatus > 3) {
            throw new IllegalArgumentException("Unknown checkStatus " + checkStatus);
        }
        if (versions == null) {
            throw new NullPointerException("versions == null");
        }
        this.mVersions = versions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageStatus that = (PackageStatus)o;
        if (this.mCheckStatus != that.mCheckStatus) {
            return false;
        }
        return this.mVersions.equals(that.mVersions);
    }

    public int hashCode() {
        int result = this.mCheckStatus;
        result = 31 * result + this.mVersions.hashCode();
        return result;
    }

    public String toString() {
        return "PackageStatus{mCheckStatus=" + this.mCheckStatus + ", mVersions=" + this.mVersions + '}';
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface CheckStatus {
    }
}

