/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.search;

import android.app.AppGlobals;
import android.app.SearchableInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.IPackageManager;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class Searchables {
    private static final String LOG_TAG = "Searchables";
    private static final String MD_LABEL_DEFAULT_SEARCHABLE = "android.app.default_searchable";
    private static final String MD_SEARCHABLE_SYSTEM_SEARCH = "*";
    private Context mContext;
    private HashMap<ComponentName, SearchableInfo> mSearchablesMap = null;
    private ArrayList<SearchableInfo> mSearchablesList = null;
    private ArrayList<SearchableInfo> mSearchablesInGlobalSearchList = null;
    private List<ResolveInfo> mGlobalSearchActivities;
    private ComponentName mCurrentGlobalSearchActivity = null;
    private ComponentName mWebSearchActivity = null;
    public static String GOOGLE_SEARCH_COMPONENT_NAME = "com.android.googlesearch/.GoogleSearch";
    public static String ENHANCED_GOOGLE_SEARCH_COMPONENT_NAME = "com.google.android.providers.enhancedgooglesearch/.Launcher";
    private final IPackageManager mPm;
    private int mUserId;
    private static final Comparator<ResolveInfo> GLOBAL_SEARCH_RANKER = new Comparator<ResolveInfo>(){

        @Override
        public int compare(ResolveInfo lhs, ResolveInfo rhs) {
            if (lhs == rhs) {
                return 0;
            }
            boolean lhsSystem = Searchables.isSystemApp(lhs);
            boolean rhsSystem = Searchables.isSystemApp(rhs);
            if (lhsSystem && !rhsSystem) {
                return -1;
            }
            if (rhsSystem && !lhsSystem) {
                return 1;
            }
            return rhs.priority - lhs.priority;
        }
    };

    public Searchables(Context context, int userId) {
        this.mContext = context;
        this.mUserId = userId;
        this.mPm = AppGlobals.getPackageManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchableInfo getSearchableInfo(ComponentName activity) {
        ActivityInfo ai;
        SearchableInfo result;
        Searchables searchables = this;
        synchronized (searchables) {
            result = this.mSearchablesMap.get(activity);
            if (result != null) {
                return result;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
            ai = null;
        }
        try {
            ai = this.mPm.getActivityInfo(activity, 128, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting activity info " + re);
            return null;
        }
        String refActivityName = null;
        Bundle md = ai.metaData;
        if (md != null) {
            refActivityName = md.getString(MD_LABEL_DEFAULT_SEARCHABLE);
        }
        if (refActivityName == null && (md = ai.applicationInfo.metaData) != null) {
            refActivityName = md.getString(MD_LABEL_DEFAULT_SEARCHABLE);
        }
        if (refActivityName != null) {
            if (refActivityName.equals(MD_SEARCHABLE_SYSTEM_SEARCH)) {
                return null;
            }
            String pkg = activity.getPackageName();
            ComponentName referredActivity = refActivityName.charAt(0) == '.' ? new ComponentName(pkg, pkg + refActivityName) : new ComponentName(pkg, refActivityName);
            Searchables searchables2 = this;
            synchronized (searchables2) {
                result = this.mSearchablesMap.get(referredActivity);
                if (result != null) {
                    this.mSearchablesMap.put(activity, result);
                    return result;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSearchableList() {
        HashMap<ComponentName, SearchableInfo> newSearchablesMap = new HashMap<ComponentName, SearchableInfo>();
        ArrayList<SearchableInfo> newSearchablesList = new ArrayList<SearchableInfo>();
        ArrayList<SearchableInfo> newSearchablesInGlobalSearchList = new ArrayList<SearchableInfo>();
        Intent intent = new Intent("android.intent.action.SEARCH");
        long ident = Binder.clearCallingIdentity();
        try {
            List<ResolveInfo> searchList = this.queryIntentActivities(intent, 0x10000080);
            Intent webSearchIntent = new Intent("android.intent.action.WEB_SEARCH");
            List<ResolveInfo> webSearchInfoList = this.queryIntentActivities(webSearchIntent, 0x10000080);
            if (searchList != null || webSearchInfoList != null) {
                int search_count = searchList == null ? 0 : searchList.size();
                int web_search_count = webSearchInfoList == null ? 0 : webSearchInfoList.size();
                int count = search_count + web_search_count;
                for (int ii = 0; ii < count; ++ii) {
                    SearchableInfo searchable;
                    ResolveInfo info = ii < search_count ? searchList.get(ii) : webSearchInfoList.get(ii - search_count);
                    ActivityInfo ai = info.activityInfo;
                    if (newSearchablesMap.get(new ComponentName(ai.packageName, ai.name)) != null || (searchable = SearchableInfo.getActivityMetaData(this.mContext, ai, this.mUserId)) == null) continue;
                    newSearchablesList.add(searchable);
                    newSearchablesMap.put(searchable.getSearchActivity(), searchable);
                    if (!searchable.shouldIncludeInGlobalSearch()) continue;
                    newSearchablesInGlobalSearchList.add(searchable);
                }
            }
            List<ResolveInfo> newGlobalSearchActivities = this.findGlobalSearchActivities();
            ComponentName newGlobalSearchActivity = this.findGlobalSearchActivity(newGlobalSearchActivities);
            ComponentName newWebSearchActivity = this.findWebSearchActivity(newGlobalSearchActivity);
            Searchables searchables = this;
            synchronized (searchables) {
                this.mSearchablesMap = newSearchablesMap;
                this.mSearchablesList = newSearchablesList;
                this.mSearchablesInGlobalSearchList = newSearchablesInGlobalSearchList;
                this.mGlobalSearchActivities = newGlobalSearchActivities;
                this.mCurrentGlobalSearchActivity = newGlobalSearchActivity;
                this.mWebSearchActivity = newWebSearchActivity;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private List<ResolveInfo> findGlobalSearchActivities() {
        Intent intent = new Intent("android.search.action.GLOBAL_SEARCH");
        List<ResolveInfo> activities = this.queryIntentActivities(intent, 0x10010000);
        if (activities != null && !activities.isEmpty()) {
            Collections.sort(activities, GLOBAL_SEARCH_RANKER);
        }
        return activities;
    }

    private ComponentName findGlobalSearchActivity(List<ResolveInfo> installed) {
        ComponentName globalSearchComponent;
        String searchProviderSetting = this.getGlobalSearchProviderSetting();
        if (!TextUtils.isEmpty(searchProviderSetting) && (globalSearchComponent = ComponentName.unflattenFromString(searchProviderSetting)) != null && this.isInstalled(globalSearchComponent)) {
            return globalSearchComponent;
        }
        return this.getDefaultGlobalSearchProvider(installed);
    }

    private boolean isInstalled(ComponentName globalSearch) {
        Intent intent = new Intent("android.search.action.GLOBAL_SEARCH");
        intent.setComponent(globalSearch);
        List<ResolveInfo> activities = this.queryIntentActivities(intent, 65536);
        return activities != null && !activities.isEmpty();
    }

    private static final boolean isSystemApp(ResolveInfo res) {
        return (res.activityInfo.applicationInfo.flags & 1) != 0;
    }

    private ComponentName getDefaultGlobalSearchProvider(List<ResolveInfo> providerList) {
        if (providerList != null && !providerList.isEmpty()) {
            ActivityInfo ai = providerList.get((int)0).activityInfo;
            return new ComponentName(ai.packageName, ai.name);
        }
        Log.w(LOG_TAG, "No global search activity found");
        return null;
    }

    private String getGlobalSearchProviderSetting() {
        return Settings.Secure.getString(this.mContext.getContentResolver(), "search_global_search_activity");
    }

    private ComponentName findWebSearchActivity(ComponentName globalSearchActivity) {
        if (globalSearchActivity == null) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.WEB_SEARCH");
        intent.setPackage(globalSearchActivity.getPackageName());
        List<ResolveInfo> activities = this.queryIntentActivities(intent, 65536);
        if (activities != null && !activities.isEmpty()) {
            ActivityInfo ai = activities.get((int)0).activityInfo;
            return new ComponentName(ai.packageName, ai.name);
        }
        Log.w(LOG_TAG, "No web search activity found");
        return null;
    }

    private List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
        List activities = null;
        try {
            activities = this.mPm.queryIntentActivities(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags, this.mUserId).getList();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return activities;
    }

    public synchronized ArrayList<SearchableInfo> getSearchablesList() {
        ArrayList<SearchableInfo> result = new ArrayList<SearchableInfo>(this.mSearchablesList);
        return result;
    }

    public synchronized ArrayList<SearchableInfo> getSearchablesInGlobalSearchList() {
        return new ArrayList<SearchableInfo>(this.mSearchablesInGlobalSearchList);
    }

    public synchronized ArrayList<ResolveInfo> getGlobalSearchActivities() {
        return new ArrayList<ResolveInfo>(this.mGlobalSearchActivities);
    }

    public synchronized ComponentName getGlobalSearchActivity() {
        return this.mCurrentGlobalSearchActivity;
    }

    public synchronized ComponentName getWebSearchActivity() {
        return this.mWebSearchActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("Searchable authorities:");
        Searchables searchables = this;
        synchronized (searchables) {
            if (this.mSearchablesList != null) {
                for (SearchableInfo info : this.mSearchablesList) {
                    pw.print("  ");
                    pw.println(info.getSuggestAuthority());
                }
            }
        }
    }
}

