/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.print;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.print.IPrintDocumentAdapter;
import android.print.IPrintJobStateChangeListener;
import android.print.IPrintManager;
import android.print.IPrintServicesChangeListener;
import android.print.IPrinterDiscoveryObserver;
import android.print.PrintAttributes;
import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.print.PrinterId;
import android.printservice.PrintServiceInfo;
import android.printservice.recommendation.IRecommendationsChangeListener;
import android.printservice.recommendation.RecommendationInfo;
import android.provider.Settings;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.Preconditions;
import com.android.server.SystemService;
import com.android.server.print.UserState;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

public final class PrintManagerService
extends SystemService {
    private static final String LOG_TAG = "PrintManagerService";
    private final PrintManagerImpl mPrintManagerImpl;

    public PrintManagerService(Context context) {
        super(context);
        this.mPrintManagerImpl = new PrintManagerImpl(context);
    }

    @Override
    public void onStart() {
        this.publishBinderService("print", this.mPrintManagerImpl);
    }

    @Override
    public void onUnlockUser(int userHandle) {
        this.mPrintManagerImpl.handleUserUnlocked(userHandle);
    }

    @Override
    public void onStopUser(int userHandle) {
        this.mPrintManagerImpl.handleUserStopped(userHandle);
    }

    class PrintManagerImpl
    extends IPrintManager.Stub {
        private static final int BACKGROUND_USER_ID = -10;
        private final Object mLock = new Object();
        private final Context mContext;
        private final UserManager mUserManager;
        private final SparseArray<UserState> mUserStates = new SparseArray();

        PrintManagerImpl(Context context) {
            this.mContext = context;
            this.mUserManager = (UserManager)context.getSystemService("user");
            this.registerContentObservers();
            this.registerBroadcastReceivers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Bundle print(String printJobName, IPrintDocumentAdapter adapter, PrintAttributes attributes, String packageName, int appId, int userId) {
            UserState userState;
            String resolvedPackageName;
            int resolvedAppId;
            printJobName = Preconditions.checkStringNotEmpty(printJobName);
            adapter = Preconditions.checkNotNull(adapter);
            packageName = Preconditions.checkStringNotEmpty(packageName);
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return null;
                }
                resolvedAppId = this.resolveCallingAppEnforcingPermissions(appId);
                resolvedPackageName = this.resolveCallingPackageNameEnforcingSecurity(packageName);
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                Bundle bundle = userState.print(printJobName, adapter, attributes, resolvedPackageName, resolvedAppId);
                return bundle;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<PrintJobInfo> getPrintJobInfos(int appId, int userId) {
            UserState userState;
            int resolvedAppId;
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return null;
                }
                resolvedAppId = this.resolveCallingAppEnforcingPermissions(appId);
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                List<PrintJobInfo> list = userState.getPrintJobInfos(resolvedAppId);
                return list;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PrintJobInfo getPrintJobInfo(PrintJobId printJobId, int appId, int userId) {
            UserState userState;
            int resolvedAppId;
            if (printJobId == null) {
                return null;
            }
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return null;
                }
                resolvedAppId = this.resolveCallingAppEnforcingPermissions(appId);
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                PrintJobInfo printJobInfo = userState.getPrintJobInfo(printJobId, resolvedAppId);
                return printJobInfo;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Icon getCustomPrinterIcon(PrinterId printerId, int userId) {
            UserState userState;
            printerId = Preconditions.checkNotNull(printerId);
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return null;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                Icon icon = userState.getCustomPrinterIcon(printerId);
                return icon;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelPrintJob(PrintJobId printJobId, int appId, int userId) {
            UserState userState;
            int resolvedAppId;
            if (printJobId == null) {
                return;
            }
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                resolvedAppId = this.resolveCallingAppEnforcingPermissions(appId);
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.cancelPrintJob(printJobId, resolvedAppId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void restartPrintJob(PrintJobId printJobId, int appId, int userId) {
            UserState userState;
            int resolvedAppId;
            if (printJobId == null) {
                return;
            }
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                resolvedAppId = this.resolveCallingAppEnforcingPermissions(appId);
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.restartPrintJob(printJobId, resolvedAppId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<PrintServiceInfo> getPrintServices(int selectionFlags, int userId) {
            UserState userState;
            Preconditions.checkFlagsArgument(selectionFlags, 3);
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRINT_SERVICES", null);
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return null;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                List<PrintServiceInfo> list = userState.getPrintServices(selectionFlags);
                return list;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPrintServiceEnabled(ComponentName service, boolean isEnabled, int userId) {
            UserState userState;
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            int appId = UserHandle.getAppId(Binder.getCallingUid());
            try {
                if (appId != 1000 && appId != UserHandle.getAppId(this.mContext.getPackageManager().getPackageUidAsUser("com.android.printspooler", resolvedUserId))) {
                    throw new SecurityException("Only system and print spooler can call this");
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(PrintManagerService.LOG_TAG, "Could not verify caller", e);
                return;
            }
            service = Preconditions.checkNotNull(service);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.setPrintServiceEnabled(service, isEnabled);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<RecommendationInfo> getPrintServiceRecommendations(int userId) {
            UserState userState;
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRINT_SERVICE_RECOMMENDATIONS", null);
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return null;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                List<RecommendationInfo> list = userState.getPrintServiceRecommendations();
                return list;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void createPrinterDiscoverySession(IPrinterDiscoveryObserver observer, int userId) {
            UserState userState;
            observer = Preconditions.checkNotNull(observer);
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.createPrinterDiscoverySession(observer);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroyPrinterDiscoverySession(IPrinterDiscoveryObserver observer, int userId) {
            UserState userState;
            observer = Preconditions.checkNotNull(observer);
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.destroyPrinterDiscoverySession(observer);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startPrinterDiscovery(IPrinterDiscoveryObserver observer, List<PrinterId> priorityList, int userId) {
            UserState userState;
            observer = Preconditions.checkNotNull(observer);
            if (priorityList != null) {
                priorityList = Preconditions.checkCollectionElementsNotNull(priorityList, "PrinterId");
            }
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.startPrinterDiscovery(observer, priorityList);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopPrinterDiscovery(IPrinterDiscoveryObserver observer, int userId) {
            UserState userState;
            observer = Preconditions.checkNotNull(observer);
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.stopPrinterDiscovery(observer);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validatePrinters(List<PrinterId> printerIds, int userId) {
            UserState userState;
            printerIds = Preconditions.checkCollectionElementsNotNull(printerIds, "PrinterId");
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.validatePrinters(printerIds);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startPrinterStateTracking(PrinterId printerId, int userId) {
            UserState userState;
            printerId = Preconditions.checkNotNull(printerId);
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.startPrinterStateTracking(printerId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopPrinterStateTracking(PrinterId printerId, int userId) {
            UserState userState;
            printerId = Preconditions.checkNotNull(printerId);
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.stopPrinterStateTracking(printerId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPrintJobStateChangeListener(IPrintJobStateChangeListener listener, int appId, int userId) throws RemoteException {
            UserState userState;
            int resolvedAppId;
            listener = Preconditions.checkNotNull(listener);
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                resolvedAppId = this.resolveCallingAppEnforcingPermissions(appId);
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.addPrintJobStateChangeListener(listener, resolvedAppId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePrintJobStateChangeListener(IPrintJobStateChangeListener listener, int userId) {
            UserState userState;
            listener = Preconditions.checkNotNull(listener);
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.removePrintJobStateChangeListener(listener);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPrintServicesChangeListener(IPrintServicesChangeListener listener, int userId) throws RemoteException {
            UserState userState;
            listener = Preconditions.checkNotNull(listener);
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRINT_SERVICES", null);
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.addPrintServicesChangeListener(listener);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePrintServicesChangeListener(IPrintServicesChangeListener listener, int userId) {
            UserState userState;
            listener = Preconditions.checkNotNull(listener);
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRINT_SERVICES", null);
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.removePrintServicesChangeListener(listener);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPrintServiceRecommendationsChangeListener(IRecommendationsChangeListener listener, int userId) throws RemoteException {
            UserState userState;
            listener = Preconditions.checkNotNull(listener);
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRINT_SERVICE_RECOMMENDATIONS", null);
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.addPrintServiceRecommendationsChangeListener(listener);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePrintServiceRecommendationsChangeListener(IRecommendationsChangeListener listener, int userId) {
            UserState userState;
            listener = Preconditions.checkNotNull(listener);
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRINT_SERVICE_RECOMMENDATIONS", null);
            int resolvedUserId = this.resolveCallingUserEnforcingPermissions(userId);
            Object object = this.mLock;
            synchronized (object) {
                if (this.resolveCallingProfileParentLocked(resolvedUserId) != this.getCurrentUserId()) {
                    return;
                }
                userState = this.getOrCreateUserStateLocked(resolvedUserId, false);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.removePrintServiceRecommendationsChangeListener(listener);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            fd = Preconditions.checkNotNull(fd);
            if (!DumpUtils.checkDumpPermission(this.mContext, PrintManagerService.LOG_TAG, pw = Preconditions.checkNotNull(pw))) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                long identity = Binder.clearCallingIdentity();
                try {
                    pw.println("PRINT MANAGER STATE (dumpsys print)");
                    int userStateCount = this.mUserStates.size();
                    for (int i = 0; i < userStateCount; ++i) {
                        UserState userState = this.mUserStates.valueAt(i);
                        userState.dump(fd, pw, "");
                        pw.println();
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        private void registerContentObservers() {
            final Uri enabledPrintServicesUri = Settings.Secure.getUriFor("disabled_print_services");
            ContentObserver observer = new ContentObserver(BackgroundThread.getHandler()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onChange(boolean selfChange, Uri uri, int userId) {
                    if (enabledPrintServicesUri.equals(uri)) {
                        Object object = PrintManagerImpl.this.mLock;
                        synchronized (object) {
                            int userCount = PrintManagerImpl.this.mUserStates.size();
                            for (int i = 0; i < userCount; ++i) {
                                if (userId != -1 && userId != PrintManagerImpl.this.mUserStates.keyAt(i)) continue;
                                ((UserState)PrintManagerImpl.this.mUserStates.valueAt(i)).updateIfNeededLocked();
                            }
                        }
                    }
                }
            };
            this.mContext.getContentResolver().registerContentObserver(enabledPrintServicesUri, false, observer, -1);
        }

        private void registerBroadcastReceivers() {
            PackageMonitor monitor = new PackageMonitor(){

                private boolean hasPrintService(String packageName) {
                    Intent intent = new Intent("android.printservice.PrintService");
                    intent.setPackage(packageName);
                    List<ResolveInfo> installedServices = PrintManagerImpl.this.mContext.getPackageManager().queryIntentServicesAsUser(intent, 0x10000004, this.getChangingUserId());
                    return installedServices != null && !installedServices.isEmpty();
                }

                private boolean hadPrintService(UserState userState, String packageName) {
                    List<PrintServiceInfo> installedServices = userState.getPrintServices(3);
                    if (installedServices == null) {
                        return false;
                    }
                    int numInstalledServices = installedServices.size();
                    for (int i = 0; i < numInstalledServices; ++i) {
                        if (!installedServices.get((int)i).getResolveInfo().serviceInfo.packageName.equals(packageName)) continue;
                        return true;
                    }
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onPackageModified(String packageName) {
                    if (!PrintManagerImpl.this.mUserManager.isUserUnlockingOrUnlocked(this.getChangingUserId())) {
                        return;
                    }
                    UserState userState = PrintManagerImpl.this.getOrCreateUserStateLocked(this.getChangingUserId(), false, false);
                    boolean prunePrintServices = false;
                    Object object = PrintManagerImpl.this.mLock;
                    synchronized (object) {
                        if (this.hadPrintService(userState, packageName) || this.hasPrintService(packageName)) {
                            userState.updateIfNeededLocked();
                            prunePrintServices = true;
                        }
                    }
                    if (prunePrintServices) {
                        userState.prunePrintServices();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onPackageRemoved(String packageName, int uid) {
                    if (!PrintManagerImpl.this.mUserManager.isUserUnlockingOrUnlocked(this.getChangingUserId())) {
                        return;
                    }
                    UserState userState = PrintManagerImpl.this.getOrCreateUserStateLocked(this.getChangingUserId(), false, false);
                    boolean prunePrintServices = false;
                    Object object = PrintManagerImpl.this.mLock;
                    synchronized (object) {
                        if (this.hadPrintService(userState, packageName)) {
                            userState.updateIfNeededLocked();
                            prunePrintServices = true;
                        }
                    }
                    if (prunePrintServices) {
                        userState.prunePrintServices();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean onHandleForceStop(Intent intent, String[] stoppedPackages, int uid, boolean doit) {
                    if (!PrintManagerImpl.this.mUserManager.isUserUnlockingOrUnlocked(this.getChangingUserId())) {
                        return false;
                    }
                    Object object = PrintManagerImpl.this.mLock;
                    synchronized (object) {
                        UserState userState = PrintManagerImpl.this.getOrCreateUserStateLocked(this.getChangingUserId(), false, false);
                        boolean stoppedSomePackages = false;
                        List<PrintServiceInfo> enabledServices = userState.getPrintServices(1);
                        if (enabledServices == null) {
                            return false;
                        }
                        Iterator<PrintServiceInfo> iterator = enabledServices.iterator();
                        block3: while (iterator.hasNext()) {
                            ComponentName componentName = iterator.next().getComponentName();
                            String componentPackage = componentName.getPackageName();
                            for (String stoppedPackage : stoppedPackages) {
                                if (!componentPackage.equals(stoppedPackage)) continue;
                                if (!doit) {
                                    return true;
                                }
                                stoppedSomePackages = true;
                                continue block3;
                            }
                        }
                        if (stoppedSomePackages) {
                            userState.updateIfNeededLocked();
                        }
                        return false;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onPackageAdded(String packageName, int uid) {
                    if (!PrintManagerImpl.this.mUserManager.isUserUnlockingOrUnlocked(this.getChangingUserId())) {
                        return;
                    }
                    Object object = PrintManagerImpl.this.mLock;
                    synchronized (object) {
                        if (this.hasPrintService(packageName)) {
                            UserState userState = PrintManagerImpl.this.getOrCreateUserStateLocked(this.getChangingUserId(), false, false);
                            userState.updateIfNeededLocked();
                        }
                    }
                }
            };
            monitor.register(this.mContext, BackgroundThread.getHandler().getLooper(), UserHandle.ALL, true);
        }

        private UserState getOrCreateUserStateLocked(int userId, boolean lowPriority) {
            return this.getOrCreateUserStateLocked(userId, lowPriority, true);
        }

        private UserState getOrCreateUserStateLocked(int userId, boolean lowPriority, boolean enforceUserUnlockingOrUnlocked) {
            if (enforceUserUnlockingOrUnlocked && !this.mUserManager.isUserUnlockingOrUnlocked(userId)) {
                throw new IllegalStateException("User " + userId + " must be unlocked for printing to be available");
            }
            UserState userState = this.mUserStates.get(userId);
            if (userState == null) {
                userState = new UserState(this.mContext, userId, this.mLock, lowPriority);
                this.mUserStates.put(userId, userState);
            }
            if (!lowPriority) {
                userState.increasePriority();
            }
            return userState;
        }

        private void handleUserUnlocked(final int userId) {
            BackgroundThread.getHandler().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    UserState userState;
                    if (!PrintManagerImpl.this.mUserManager.isUserUnlockingOrUnlocked(userId)) {
                        return;
                    }
                    Object object = PrintManagerImpl.this.mLock;
                    synchronized (object) {
                        userState = PrintManagerImpl.this.getOrCreateUserStateLocked(userId, true, false);
                        userState.updateIfNeededLocked();
                    }
                    userState.removeObsoletePrintJobs();
                }
            });
        }

        private void handleUserStopped(final int userId) {
            BackgroundThread.getHandler().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = PrintManagerImpl.this.mLock;
                    synchronized (object) {
                        UserState userState = (UserState)PrintManagerImpl.this.mUserStates.get(userId);
                        if (userState != null) {
                            userState.destroyLocked();
                            PrintManagerImpl.this.mUserStates.remove(userId);
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int resolveCallingProfileParentLocked(int userId) {
            if (userId != this.getCurrentUserId()) {
                long identity = Binder.clearCallingIdentity();
                try {
                    UserInfo parent = this.mUserManager.getProfileParent(userId);
                    if (parent != null) {
                        int n = parent.getUserHandle().getIdentifier();
                        return n;
                    }
                    int n = -10;
                    return n;
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            return userId;
        }

        private int resolveCallingAppEnforcingPermissions(int appId) {
            int callingUid = Binder.getCallingUid();
            if (callingUid == 0) {
                return appId;
            }
            int callingAppId = UserHandle.getAppId(callingUid);
            if (appId == callingAppId || callingAppId == 2000 || callingAppId == 1000) {
                return appId;
            }
            if (this.mContext.checkCallingPermission("com.android.printspooler.permission.ACCESS_ALL_PRINT_JOBS") != 0) {
                throw new SecurityException("Call from app " + callingAppId + " as app " + appId + " without com.android.printspooler.permission" + ".ACCESS_ALL_PRINT_JOBS");
            }
            return appId;
        }

        private int resolveCallingUserEnforcingPermissions(int userId) {
            try {
                return ActivityManager.getService().handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, true, "", null);
            }
            catch (RemoteException remoteException) {
                return userId;
            }
        }

        private String resolveCallingPackageNameEnforcingSecurity(String packageName) {
            String[] packages = this.mContext.getPackageManager().getPackagesForUid(Binder.getCallingUid());
            int packageCount = packages.length;
            for (int i = 0; i < packageCount; ++i) {
                if (!packageName.equals(packages[i])) continue;
                return packageName;
            }
            throw new IllegalArgumentException("packageName has to belong to the caller");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getCurrentUserId() {
            long identity = Binder.clearCallingIdentity();
            try {
                int n = ActivityManager.getCurrentUser();
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }
}

