/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.os.IBinder;
import android.os.SystemClock;
import android.view.WindowManagerInternal;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import com.android.server.LocalServices;
import com.android.server.policy.BarController;
import com.android.server.statusbar.StatusBarManagerInternal;

public class StatusBarController
extends BarController {
    private static final long TRANSITION_DURATION = 120L;
    private final WindowManagerInternal.AppTransitionListener mAppTransitionListener = new WindowManagerInternal.AppTransitionListener(){

        @Override
        public void onAppTransitionPendingLocked() {
            StatusBarController.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    StatusBarManagerInternal statusbar = StatusBarController.this.getStatusBarInternal();
                    if (statusbar != null) {
                        statusbar.appTransitionPending();
                    }
                }
            });
        }

        @Override
        public int onAppTransitionStartingLocked(int transit, IBinder openToken, IBinder closeToken, final Animation openAnimation, final Animation closeAnimation) {
            StatusBarController.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    StatusBarManagerInternal statusbar = StatusBarController.this.getStatusBarInternal();
                    if (statusbar != null) {
                        long startTime = StatusBarController.calculateStatusBarTransitionStartTime(openAnimation, closeAnimation);
                        long duration = closeAnimation != null || openAnimation != null ? 120L : 0L;
                        statusbar.appTransitionStarting(startTime, duration);
                    }
                }
            });
            return 0;
        }

        @Override
        public void onAppTransitionCancelledLocked(int transit) {
            StatusBarController.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    StatusBarManagerInternal statusbar = StatusBarController.this.getStatusBarInternal();
                    if (statusbar != null) {
                        statusbar.appTransitionCancelled();
                    }
                }
            });
        }

        @Override
        public void onAppTransitionFinishedLocked(IBinder token) {
            StatusBarController.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    StatusBarManagerInternal statusbar = LocalServices.getService(StatusBarManagerInternal.class);
                    if (statusbar != null) {
                        statusbar.appTransitionFinished();
                    }
                }
            });
        }
    };

    public StatusBarController() {
        super("StatusBar", 0x4000000, 0x10000000, 0x40000000, 1, 0x4000000, 8);
    }

    public void setTopAppHidesStatusBar(boolean hidesStatusBar) {
        StatusBarManagerInternal statusbar = this.getStatusBarInternal();
        if (statusbar != null) {
            statusbar.setTopAppHidesStatusBar(hidesStatusBar);
        }
    }

    @Override
    protected boolean skipAnimation() {
        return this.mWin.getAttrs().height == -1;
    }

    public WindowManagerInternal.AppTransitionListener getAppTransitionListener() {
        return this.mAppTransitionListener;
    }

    private static long calculateStatusBarTransitionStartTime(Animation openAnimation, Animation closeAnimation) {
        if (openAnimation != null && closeAnimation != null) {
            TranslateAnimation openTranslateAnimation = StatusBarController.findTranslateAnimation(openAnimation);
            TranslateAnimation closeTranslateAnimation = StatusBarController.findTranslateAnimation(closeAnimation);
            if (openTranslateAnimation != null) {
                float t = StatusBarController.findAlmostThereFraction(openTranslateAnimation.getInterpolator());
                return SystemClock.uptimeMillis() + openTranslateAnimation.getStartOffset() + (long)((float)openTranslateAnimation.getDuration() * t) - 120L;
            }
            if (closeTranslateAnimation != null) {
                return SystemClock.uptimeMillis();
            }
            return SystemClock.uptimeMillis();
        }
        return SystemClock.uptimeMillis();
    }

    private static TranslateAnimation findTranslateAnimation(Animation animation) {
        if (animation instanceof TranslateAnimation) {
            return (TranslateAnimation)animation;
        }
        if (animation instanceof AnimationSet) {
            AnimationSet set = (AnimationSet)animation;
            for (int i = 0; i < set.getAnimations().size(); ++i) {
                Animation a = set.getAnimations().get(i);
                if (!(a instanceof TranslateAnimation)) continue;
                return (TranslateAnimation)a;
            }
        }
        return null;
    }

    private static float findAlmostThereFraction(Interpolator interpolator2) {
        float val = 0.5f;
        for (float adj = 0.25f; adj >= 0.01f; adj /= 2.0f) {
            if (interpolator2.getInterpolation(val) < 0.99f) {
                val += adj;
                continue;
            }
            val -= adj;
        }
        return val;
    }
}

