/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.AlertDialog;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.media.AudioAttributes;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Vibrator;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.widget.Toast;
import com.android.server.policy.PhoneWindowManager;

public class AccessibilityShortcutController {
    private static final String TAG = "AccessibilityShortcutController";
    private static final AudioAttributes VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(11).build();
    private final Context mContext;
    private AlertDialog mAlertDialog;
    private boolean mIsShortcutEnabled;
    private boolean mEnabledOnLockScreen;
    private int mUserId;
    public FrameworkObjectProvider mFrameworkObjectProvider = new FrameworkObjectProvider();

    public static String getTargetServiceComponentNameString(Context context, int userId) {
        String currentShortcutServiceId = Settings.Secure.getStringForUser(context.getContentResolver(), "accessibility_shortcut_target_service", userId);
        if (currentShortcutServiceId != null) {
            return currentShortcutServiceId;
        }
        return context.getString(17039637);
    }

    public AccessibilityShortcutController(Context context, Handler handler, int initialUserId) {
        this.mContext = context;
        this.mUserId = initialUserId;
        ContentObserver co = new ContentObserver(handler){

            @Override
            public void onChange(boolean selfChange, Uri uri, int userId) {
                if (userId == AccessibilityShortcutController.this.mUserId) {
                    AccessibilityShortcutController.this.onSettingsChanged();
                }
            }
        };
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("accessibility_shortcut_target_service"), false, co, -1);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("accessibility_shortcut_enabled"), false, co, -1);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("accessibility_shortcut_on_lock_screen"), false, co, -1);
        this.setCurrentUser(this.mUserId);
    }

    public void setCurrentUser(int currentUserId) {
        this.mUserId = currentUserId;
        this.onSettingsChanged();
    }

    public boolean isAccessibilityShortcutAvailable(boolean phoneLocked) {
        return this.mIsShortcutEnabled && (!phoneLocked || this.mEnabledOnLockScreen);
    }

    public void onSettingsChanged() {
        boolean haveValidService = !TextUtils.isEmpty(AccessibilityShortcutController.getTargetServiceComponentNameString(this.mContext, this.mUserId));
        ContentResolver cr = this.mContext.getContentResolver();
        boolean enabled = Settings.Secure.getIntForUser(cr, "accessibility_shortcut_enabled", 1, this.mUserId) == 1;
        this.mEnabledOnLockScreen = Settings.Secure.getIntForUser(cr, "accessibility_shortcut_on_lock_screen", 0, this.mUserId) == 1;
        this.mIsShortcutEnabled = enabled && haveValidService;
    }

    public void performAccessibilityShortcut() {
        Vibrator vibrator;
        Slog.d(TAG, "Accessibility shortcut activated");
        ContentResolver cr = this.mContext.getContentResolver();
        int userId = ActivityManager.getCurrentUser();
        int dialogAlreadyShown = Settings.Secure.getIntForUser(cr, "accessibility_shortcut_dialog_shown", 0, userId);
        int audioAttributesUsage = this.hasFeatureLeanback() ? 11 : 10;
        Ringtone tone = RingtoneManager.getRingtone(this.mContext, Settings.System.DEFAULT_NOTIFICATION_URI);
        if (tone != null) {
            tone.setAudioAttributes(new AudioAttributes.Builder().setUsage(audioAttributesUsage).build());
            tone.play();
        }
        if ((vibrator = (Vibrator)this.mContext.getSystemService("vibrator")) != null && vibrator.hasVibrator()) {
            long[] vibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17236010);
            vibrator.vibrate(vibePattern, -1, VIBRATION_ATTRIBUTES);
        }
        if (dialogAlreadyShown == 0) {
            this.mAlertDialog = this.createShortcutWarningDialog(userId);
            if (this.mAlertDialog == null) {
                return;
            }
            Window w = this.mAlertDialog.getWindow();
            WindowManager.LayoutParams attr2 = w.getAttributes();
            attr2.type = 2009;
            w.setAttributes(attr2);
            this.mAlertDialog.show();
            Settings.Secure.putIntForUser(cr, "accessibility_shortcut_dialog_shown", 1, userId);
        } else {
            AccessibilityServiceInfo serviceInfo;
            if (this.mAlertDialog != null) {
                this.mAlertDialog.dismiss();
                this.mAlertDialog = null;
            }
            if ((serviceInfo = this.getInfoForTargetService()) == null) {
                Slog.e(TAG, "Accessibility shortcut set to invalid service");
                return;
            }
            String toastMessageFormatString = this.mContext.getString(this.isServiceEnabled(serviceInfo) ? 0x1040040 : 0x1040041);
            String toastMessage = String.format(toastMessageFormatString, serviceInfo.getResolveInfo().loadLabel(this.mContext.getPackageManager()).toString());
            Toast warningToast = this.mFrameworkObjectProvider.makeToastFromText(this.mContext, toastMessage, 1);
            warningToast.getWindowParams().privateFlags |= 0x10;
            warningToast.show();
            this.mFrameworkObjectProvider.getAccessibilityManagerInstance(this.mContext).performAccessibilityShortcut();
        }
    }

    private AlertDialog createShortcutWarningDialog(int userId) {
        AccessibilityServiceInfo serviceInfo = this.getInfoForTargetService();
        if (serviceInfo == null) {
            return null;
        }
        String warningMessage = String.format(this.mContext.getString(17039426), serviceInfo.getResolveInfo().loadLabel(this.mContext.getPackageManager()).toString());
        AlertDialog alertDialog = this.mFrameworkObjectProvider.getAlertDialogBuilder(ActivityThread.currentActivityThread().getSystemUiContext()).setTitle(17039427).setMessage(warningMessage).setCancelable(false).setPositiveButton(17040071, null).setNegativeButton(17039768, (d, which) -> Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "accessibility_shortcut_target_service", "", userId)).setOnCancelListener(d -> Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "accessibility_shortcut_dialog_shown", 0, userId)).create();
        return alertDialog;
    }

    private AccessibilityServiceInfo getInfoForTargetService() {
        String currentShortcutServiceString = AccessibilityShortcutController.getTargetServiceComponentNameString(this.mContext, -2);
        if (currentShortcutServiceString == null) {
            return null;
        }
        AccessibilityManager accessibilityManager = this.mFrameworkObjectProvider.getAccessibilityManagerInstance(this.mContext);
        return accessibilityManager.getInstalledServiceInfoWithComponentName(ComponentName.unflattenFromString(currentShortcutServiceString));
    }

    private boolean isServiceEnabled(AccessibilityServiceInfo serviceInfo) {
        AccessibilityManager accessibilityManager = this.mFrameworkObjectProvider.getAccessibilityManagerInstance(this.mContext);
        return accessibilityManager.getEnabledAccessibilityServiceList(-1).contains(serviceInfo);
    }

    private boolean hasFeatureLeanback() {
        return this.mContext.getPackageManager().hasSystemFeature("android.software.leanback");
    }

    public static class FrameworkObjectProvider {
        public AccessibilityManager getAccessibilityManagerInstance(Context context) {
            return AccessibilityManager.getInstance(context);
        }

        public AlertDialog.Builder getAlertDialogBuilder(Context context) {
            return new AlertDialog.Builder(context);
        }

        public Toast makeToastFromText(Context context, CharSequence charSequence, int duration) {
            return Toast.makeText(context, charSequence, duration);
        }
    }
}

