/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.ComponentName;
import android.text.TextUtils;
import android.text.format.Formatter;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import com.android.internal.util.Preconditions;
import com.android.server.pm.ShortcutLauncher;
import com.android.server.pm.ShortcutPackage;
import com.android.server.pm.ShortcutPackageItem;
import com.android.server.pm.ShortcutService;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.function.Consumer;
import libcore.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class ShortcutUser {
    private static final String TAG = "ShortcutService";
    static final String TAG_ROOT = "user";
    private static final String TAG_LAUNCHER = "launcher";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_KNOWN_LOCALES = "locales";
    private static final String ATTR_LAST_APP_SCAN_TIME = "last-app-scan-time2";
    private static final String ATTR_LAST_APP_SCAN_OS_FINGERPRINT = "last-app-scan-fp";
    private static final String KEY_USER_ID = "userId";
    private static final String KEY_LAUNCHERS = "launchers";
    private static final String KEY_PACKAGES = "packages";
    final ShortcutService mService;
    private final int mUserId;
    private final ArrayMap<String, ShortcutPackage> mPackages = new ArrayMap();
    private final ArrayMap<PackageWithUser, ShortcutLauncher> mLaunchers = new ArrayMap();
    private ComponentName mLastKnownLauncher;
    private ComponentName mCachedLauncher;
    private String mKnownLocales;
    private long mLastAppScanTime;
    private String mLastAppScanOsFingerprint;

    public ShortcutUser(ShortcutService service, int userId) {
        this.mService = service;
        this.mUserId = userId;
    }

    public int getUserId() {
        return this.mUserId;
    }

    public long getLastAppScanTime() {
        return this.mLastAppScanTime;
    }

    public void setLastAppScanTime(long lastAppScanTime) {
        this.mLastAppScanTime = lastAppScanTime;
    }

    public String getLastAppScanOsFingerprint() {
        return this.mLastAppScanOsFingerprint;
    }

    public void setLastAppScanOsFingerprint(String lastAppScanOsFingerprint) {
        this.mLastAppScanOsFingerprint = lastAppScanOsFingerprint;
    }

    ArrayMap<String, ShortcutPackage> getAllPackagesForTest() {
        return this.mPackages;
    }

    public boolean hasPackage(String packageName) {
        return this.mPackages.containsKey(packageName);
    }

    private void addPackage(ShortcutPackage p) {
        p.replaceUser(this);
        this.mPackages.put(p.getPackageName(), p);
    }

    public ShortcutPackage removePackage(String packageName) {
        ShortcutPackage removed = this.mPackages.remove(packageName);
        this.mService.cleanupBitmapsForPackage(this.mUserId, packageName);
        return removed;
    }

    ArrayMap<PackageWithUser, ShortcutLauncher> getAllLaunchersForTest() {
        return this.mLaunchers;
    }

    private void addLauncher(ShortcutLauncher launcher) {
        launcher.replaceUser(this);
        this.mLaunchers.put(PackageWithUser.of(launcher.getPackageUserId(), launcher.getPackageName()), launcher);
    }

    public ShortcutLauncher removeLauncher(int packageUserId, String packageName) {
        return this.mLaunchers.remove(PackageWithUser.of(packageUserId, packageName));
    }

    public ShortcutPackage getPackageShortcutsIfExists(String packageName) {
        ShortcutPackage ret = this.mPackages.get(packageName);
        if (ret != null) {
            ret.attemptToRestoreIfNeededAndSave();
        }
        return ret;
    }

    public ShortcutPackage getPackageShortcuts(String packageName) {
        ShortcutPackage ret = this.getPackageShortcutsIfExists(packageName);
        if (ret == null) {
            ret = new ShortcutPackage(this, this.mUserId, packageName);
            this.mPackages.put(packageName, ret);
        }
        return ret;
    }

    public ShortcutLauncher getLauncherShortcuts(String packageName, int launcherUserId) {
        PackageWithUser key = PackageWithUser.of(launcherUserId, packageName);
        ShortcutLauncher ret = this.mLaunchers.get(key);
        if (ret == null) {
            ret = new ShortcutLauncher(this, this.mUserId, packageName, launcherUserId);
            this.mLaunchers.put(key, ret);
        } else {
            ret.attemptToRestoreIfNeededAndSave();
        }
        return ret;
    }

    public void forAllPackages(Consumer<? super ShortcutPackage> callback) {
        int size = this.mPackages.size();
        for (int i = 0; i < size; ++i) {
            callback.accept(this.mPackages.valueAt(i));
        }
    }

    public void forAllLaunchers(Consumer<? super ShortcutLauncher> callback) {
        int size = this.mLaunchers.size();
        for (int i = 0; i < size; ++i) {
            callback.accept(this.mLaunchers.valueAt(i));
        }
    }

    public void forAllPackageItems(Consumer<? super ShortcutPackageItem> callback) {
        this.forAllLaunchers(callback);
        this.forAllPackages(callback);
    }

    public void forPackageItem(String packageName, int packageUserId, Consumer<ShortcutPackageItem> callback) {
        this.forAllPackageItems(spi -> {
            if (spi.getPackageUserId() == packageUserId && spi.getPackageName().equals(packageName)) {
                callback.accept((ShortcutPackageItem)spi);
            }
        });
    }

    public void onCalledByPublisher(String packageName) {
        this.detectLocaleChange();
        this.rescanPackageIfNeeded(packageName, false);
    }

    private String getKnownLocales() {
        if (TextUtils.isEmpty(this.mKnownLocales)) {
            this.mKnownLocales = this.mService.injectGetLocaleTagsForUser(this.mUserId);
            this.mService.scheduleSaveUser(this.mUserId);
        }
        return this.mKnownLocales;
    }

    public void detectLocaleChange() {
        String currentLocales = this.mService.injectGetLocaleTagsForUser(this.mUserId);
        if (this.getKnownLocales().equals(currentLocales)) {
            return;
        }
        this.mKnownLocales = currentLocales;
        this.forAllPackages(pkg -> {
            pkg.resetRateLimiting();
            pkg.resolveResourceStrings();
        });
        this.mService.scheduleSaveUser(this.mUserId);
    }

    public void rescanPackageIfNeeded(String packageName, boolean forceRescan) {
        boolean isNewApp = !this.mPackages.containsKey(packageName);
        ShortcutPackage shortcutPackage = this.getPackageShortcuts(packageName);
        if (!shortcutPackage.rescanPackageIfNeeded(isNewApp, forceRescan) && isNewApp) {
            this.mPackages.remove(packageName);
        }
    }

    public void attemptToRestoreIfNeededAndSave(ShortcutService s, String packageName, int packageUserId) {
        this.forPackageItem(packageName, packageUserId, spi -> spi.attemptToRestoreIfNeededAndSave());
    }

    public void saveToXml(XmlSerializer out, boolean forBackup) throws IOException, XmlPullParserException {
        int i;
        out.startTag(null, TAG_ROOT);
        if (!forBackup) {
            ShortcutService.writeAttr(out, ATTR_KNOWN_LOCALES, this.mKnownLocales);
            ShortcutService.writeAttr(out, ATTR_LAST_APP_SCAN_TIME, this.mLastAppScanTime);
            ShortcutService.writeAttr(out, ATTR_LAST_APP_SCAN_OS_FINGERPRINT, this.mLastAppScanOsFingerprint);
            ShortcutService.writeTagValue(out, TAG_LAUNCHER, this.mLastKnownLauncher);
        }
        int size = this.mLaunchers.size();
        for (i = 0; i < size; ++i) {
            this.saveShortcutPackageItem(out, this.mLaunchers.valueAt(i), forBackup);
        }
        size = this.mPackages.size();
        for (i = 0; i < size; ++i) {
            this.saveShortcutPackageItem(out, this.mPackages.valueAt(i), forBackup);
        }
        out.endTag(null, TAG_ROOT);
    }

    private void saveShortcutPackageItem(XmlSerializer out, ShortcutPackageItem spi, boolean forBackup) throws IOException, XmlPullParserException {
        if (forBackup) {
            if (!this.mService.shouldBackupApp(spi.getPackageName(), spi.getPackageUserId())) {
                return;
            }
            if (spi.getPackageUserId() != spi.getOwnerUserId()) {
                return;
            }
        }
        spi.saveToXml(out, forBackup);
    }

    public static ShortcutUser loadFromXml(ShortcutService s, XmlPullParser parser, int userId, boolean fromBackup) throws IOException, XmlPullParserException, ShortcutService.InvalidFileFormatException {
        ShortcutUser ret = new ShortcutUser(s, userId);
        try {
            int type;
            ret.mKnownLocales = ShortcutService.parseStringAttribute(parser, ATTR_KNOWN_LOCALES);
            long lastAppScanTime = ShortcutService.parseLongAttribute(parser, ATTR_LAST_APP_SCAN_TIME);
            long currentTime = s.injectCurrentTimeMillis();
            ret.mLastAppScanTime = lastAppScanTime < currentTime ? lastAppScanTime : 0L;
            ret.mLastAppScanOsFingerprint = ShortcutService.parseStringAttribute(parser, ATTR_LAST_APP_SCAN_OS_FINGERPRINT);
            int outerDepth = parser.getDepth();
            block12: while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type != 2) continue;
                int depth = parser.getDepth();
                String tag = parser.getName();
                if (depth == outerDepth + 1) {
                    switch (tag) {
                        case "launcher": {
                            ret.mLastKnownLauncher = ShortcutService.parseComponentNameAttribute(parser, ATTR_VALUE);
                            continue block12;
                        }
                        case "package": {
                            ShortcutPackage shortcuts = ShortcutPackage.loadFromXml(s, ret, parser, fromBackup);
                            ret.mPackages.put(shortcuts.getPackageName(), shortcuts);
                            continue block12;
                        }
                        case "launcher-pins": {
                            ret.addLauncher(ShortcutLauncher.loadFromXml(parser, ret, userId, fromBackup));
                            continue block12;
                        }
                    }
                }
                ShortcutService.warnForInvalidTag(depth, tag);
            }
        }
        catch (RuntimeException e) {
            throw new ShortcutService.InvalidFileFormatException("Unable to parse file", e);
        }
        return ret;
    }

    public ComponentName getLastKnownLauncher() {
        return this.mLastKnownLauncher;
    }

    public void setLauncher(ComponentName launcherComponent) {
        this.setLauncher(launcherComponent, false);
    }

    public void clearLauncher() {
        this.setLauncher(null);
    }

    public void forceClearLauncher() {
        this.setLauncher(null, true);
    }

    private void setLauncher(ComponentName launcherComponent, boolean allowPurgeLastKnown) {
        this.mCachedLauncher = launcherComponent;
        if (Objects.equal(this.mLastKnownLauncher, launcherComponent)) {
            return;
        }
        if (!allowPurgeLastKnown && launcherComponent == null) {
            return;
        }
        this.mLastKnownLauncher = launcherComponent;
        this.mService.scheduleSaveUser(this.mUserId);
    }

    public ComponentName getCachedLauncher() {
        return this.mCachedLauncher;
    }

    public void resetThrottling() {
        for (int i = this.mPackages.size() - 1; i >= 0; --i) {
            this.mPackages.valueAt(i).resetThrottling();
        }
    }

    public void mergeRestoredFile(ShortcutUser restored) {
        ShortcutService s = this.mService;
        int[] restoredLaunchers = new int[1];
        int[] restoredPackages = new int[1];
        int[] restoredShortcuts = new int[1];
        this.mLaunchers.clear();
        restored.forAllLaunchers(sl -> {
            if (s.isPackageInstalled(sl.getPackageName(), this.getUserId()) && !s.shouldBackupApp(sl.getPackageName(), this.getUserId())) {
                return;
            }
            this.addLauncher((ShortcutLauncher)sl);
            nArray[0] = restoredLaunchers[0] + 1;
        });
        restored.forAllPackages(sp -> {
            if (s.isPackageInstalled(sp.getPackageName(), this.getUserId()) && !s.shouldBackupApp(sp.getPackageName(), this.getUserId())) {
                return;
            }
            ShortcutPackage previous = this.getPackageShortcutsIfExists(sp.getPackageName());
            if (previous != null && previous.hasNonManifestShortcuts()) {
                Log.w(TAG, "Shortcuts for package " + sp.getPackageName() + " are being restored." + " Existing non-manifeset shortcuts will be overwritten.");
            }
            this.addPackage((ShortcutPackage)sp);
            nArray[0] = restoredPackages[0] + 1;
            nArray2[0] = restoredShortcuts[0] + sp.getShortcutCount();
        });
        restored.mLaunchers.clear();
        restored.mPackages.clear();
        Slog.i(TAG, "Restored: L=" + restoredLaunchers[0] + " P=" + restoredPackages[0] + " S=" + restoredShortcuts[0]);
    }

    public void dump(PrintWriter pw, String prefix) {
        int i;
        pw.print(prefix);
        pw.print("User: ");
        pw.print(this.mUserId);
        pw.print("  Known locales: ");
        pw.print(this.mKnownLocales);
        pw.print("  Last app scan: [");
        pw.print(this.mLastAppScanTime);
        pw.print("] ");
        pw.print(ShortcutService.formatTime(this.mLastAppScanTime));
        pw.print("  Last app scan FP: ");
        pw.print(this.mLastAppScanOsFingerprint);
        pw.println();
        prefix = prefix + prefix + "  ";
        pw.print(prefix);
        pw.print("Cached launcher: ");
        pw.print(this.mCachedLauncher);
        pw.println();
        pw.print(prefix);
        pw.print("Last known launcher: ");
        pw.print(this.mLastKnownLauncher);
        pw.println();
        for (i = 0; i < this.mLaunchers.size(); ++i) {
            this.mLaunchers.valueAt(i).dump(pw, prefix);
        }
        for (i = 0; i < this.mPackages.size(); ++i) {
            this.mPackages.valueAt(i).dump(pw, prefix);
        }
        pw.println();
        pw.print(prefix);
        pw.println("Bitmap directories: ");
        this.dumpDirectorySize(pw, prefix + "  ", this.mService.getUserBitmapFilePath(this.mUserId));
    }

    private void dumpDirectorySize(PrintWriter pw, String prefix, File path) {
        int numFiles = 0;
        long size = 0L;
        File[] children = path.listFiles();
        if (children != null) {
            for (File child : path.listFiles()) {
                if (child.isFile()) {
                    ++numFiles;
                    size += child.length();
                    continue;
                }
                if (!child.isDirectory()) continue;
                this.dumpDirectorySize(pw, prefix + "  ", child);
            }
        }
        pw.print(prefix);
        pw.print("Path: ");
        pw.print(path.getName());
        pw.print("/ has ");
        pw.print(numFiles);
        pw.print(" files, size=");
        pw.print(size);
        pw.print(" (");
        pw.print(Formatter.formatFileSize(this.mService.mContext, size));
        pw.println(")");
    }

    public JSONObject dumpCheckin(boolean clear) throws JSONException {
        int i;
        JSONObject result = new JSONObject();
        result.put(KEY_USER_ID, this.mUserId);
        JSONArray launchers = new JSONArray();
        for (i = 0; i < this.mLaunchers.size(); ++i) {
            launchers.put(this.mLaunchers.valueAt(i).dumpCheckin(clear));
        }
        result.put(KEY_LAUNCHERS, launchers);
        JSONArray packages = new JSONArray();
        for (i = 0; i < this.mPackages.size(); ++i) {
            packages.put(this.mPackages.valueAt(i).dumpCheckin(clear));
        }
        result.put(KEY_PACKAGES, packages);
        return result;
    }

    static final class PackageWithUser {
        final int userId;
        final String packageName;

        private PackageWithUser(int userId, String packageName) {
            this.userId = userId;
            this.packageName = Preconditions.checkNotNull(packageName);
        }

        public static PackageWithUser of(int userId, String packageName) {
            return new PackageWithUser(userId, packageName);
        }

        public static PackageWithUser of(ShortcutPackageItem spi) {
            return new PackageWithUser(spi.getPackageUserId(), spi.getPackageName());
        }

        public int hashCode() {
            return this.packageName.hashCode() ^ this.userId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PackageWithUser)) {
                return false;
            }
            PackageWithUser that = (PackageWithUser)obj;
            return this.userId == that.userId && this.packageName.equals(that.packageName);
        }

        public String toString() {
            return String.format("[Package: %d, %s]", this.userId, this.packageName);
        }
    }
}

