/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.util.ArrayMap;
import com.android.internal.util.ArrayUtils;

public class PackageKeySetData {
    static final long KEYSET_UNASSIGNED = -1L;
    private long mProperSigningKeySet;
    private long[] mUpgradeKeySets;
    private final ArrayMap<String, Long> mKeySetAliases = new ArrayMap();

    PackageKeySetData() {
        this.mProperSigningKeySet = -1L;
    }

    PackageKeySetData(PackageKeySetData original) {
        this.mProperSigningKeySet = original.mProperSigningKeySet;
        this.mUpgradeKeySets = ArrayUtils.cloneOrNull(original.mUpgradeKeySets);
        this.mKeySetAliases.putAll(original.mKeySetAliases);
    }

    protected void setProperSigningKeySet(long ks) {
        this.mProperSigningKeySet = ks;
    }

    protected long getProperSigningKeySet() {
        return this.mProperSigningKeySet;
    }

    protected void addUpgradeKeySet(String alias) {
        if (alias == null) {
            return;
        }
        Long ks = this.mKeySetAliases.get(alias);
        if (ks == null) {
            throw new IllegalArgumentException("Upgrade keyset alias " + alias + "does not refer to a defined keyset alias!");
        }
        this.mUpgradeKeySets = ArrayUtils.appendLong(this.mUpgradeKeySets, ks);
    }

    protected void addUpgradeKeySetById(long ks) {
        this.mUpgradeKeySets = ArrayUtils.appendLong(this.mUpgradeKeySets, ks);
    }

    protected void removeAllUpgradeKeySets() {
        this.mUpgradeKeySets = null;
    }

    protected long[] getUpgradeKeySets() {
        return this.mUpgradeKeySets;
    }

    protected ArrayMap<String, Long> getAliases() {
        return this.mKeySetAliases;
    }

    protected void setAliases(ArrayMap<String, Long> newAliases) {
        this.removeAllDefinedKeySets();
        int newAliasSize = newAliases.size();
        for (int i = 0; i < newAliasSize; ++i) {
            this.mKeySetAliases.put(newAliases.keyAt(i), newAliases.valueAt(i));
        }
    }

    protected void addDefinedKeySet(long ks, String alias) {
        this.mKeySetAliases.put(alias, ks);
    }

    protected void removeAllDefinedKeySets() {
        int aliasSize = this.mKeySetAliases.size();
        for (int i = 0; i < aliasSize; ++i) {
            this.mKeySetAliases.removeAt(i);
        }
    }

    protected boolean isUsingDefinedKeySets() {
        return this.mKeySetAliases.size() > 0;
    }

    protected boolean isUsingUpgradeKeySets() {
        return this.mUpgradeKeySets != null && this.mUpgradeKeySets.length > 0;
    }
}

