/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.Context;
import android.content.pm.IOtaDexopt;
import android.content.pm.PackageParser;
import android.os.Environment;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.storage.StorageManager;
import android.util.Log;
import android.util.Slog;
import com.android.internal.logging.MetricsLogger;
import com.android.server.pm.Installer;
import com.android.server.pm.InstructionSets;
import com.android.server.pm.OtaDexoptShellCommand;
import com.android.server.pm.PackageDexOptimizer;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageManagerServiceUtils;
import com.android.server.pm.dex.DexoptOptions;
import java.io.File;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class OtaDexoptService
extends IOtaDexopt.Stub {
    private static final String TAG = "OTADexopt";
    private static final boolean DEBUG_DEXOPT = true;
    private static final String[] NO_LIBRARIES = new String[]{"&"};
    private static final long BULK_DELETE_THRESHOLD = 0x40000000L;
    private final Context mContext;
    private final PackageManagerService mPackageManagerService;
    private List<String> mDexoptCommands;
    private int completeSize;
    private long availableSpaceBefore;
    private long availableSpaceAfterBulkDelete;
    private long availableSpaceAfterDexopt;
    private int importantPackageCount;
    private int otherPackageCount;
    private int dexoptCommandCountTotal;
    private int dexoptCommandCountExecuted;
    private long otaDexoptTimeStart;

    public OtaDexoptService(Context context, PackageManagerService packageManagerService) {
        this.mContext = context;
        this.mPackageManagerService = packageManagerService;
    }

    public static OtaDexoptService main(Context context, PackageManagerService packageManagerService) {
        OtaDexoptService ota = new OtaDexoptService(context, packageManagerService);
        ServiceManager.addService("otadexopt", ota);
        ota.moveAbArtifacts(packageManagerService.mInstaller);
        return ota;
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        new OtaDexoptShellCommand(this).exec(this, in, out, err, args, callback, resultReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void prepare() throws RemoteException {
        ArrayList<PackageParser.Package> others;
        List<PackageParser.Package> important;
        if (this.mDexoptCommands != null) {
            throw new IllegalStateException("already called prepare()");
        }
        Iterator iterator = this.mPackageManagerService.mPackages;
        synchronized (iterator) {
            important = PackageManagerServiceUtils.getPackagesForDexopt(this.mPackageManagerService.mPackages.values(), this.mPackageManagerService);
            others = new ArrayList<PackageParser.Package>(this.mPackageManagerService.mPackages.values());
            others.removeAll(important);
            this.mDexoptCommands = new ArrayList<String>(3 * this.mPackageManagerService.mPackages.size() / 2);
        }
        for (PackageParser.Package p : important) {
            this.mDexoptCommands.addAll(this.generatePackageDexopts(p, 4));
        }
        for (PackageParser.Package p : others) {
            if (p.coreApp) {
                throw new IllegalStateException("Found a core app that's not important");
            }
            this.mDexoptCommands.addAll(this.generatePackageDexopts(p, 0));
        }
        this.completeSize = this.mDexoptCommands.size();
        long spaceAvailable = this.getAvailableSpace();
        if (spaceAvailable < 0x40000000L) {
            Log.i(TAG, "Low on space, deleting oat files in an attempt to free up space: " + PackageManagerServiceUtils.packagesToString(others));
            for (PackageParser.Package pkg : others) {
                this.mPackageManagerService.deleteOatArtifactsOfPackage(pkg.packageName);
            }
        }
        long spaceAvailableNow = this.getAvailableSpace();
        this.prepareMetricsLogging(important.size(), others.size(), spaceAvailable, spaceAvailableNow);
    }

    @Override
    public synchronized void cleanup() throws RemoteException {
        Log.i(TAG, "Cleaning up OTA Dexopt state.");
        this.mDexoptCommands = null;
        this.availableSpaceAfterDexopt = this.getAvailableSpace();
        this.performMetricsLogging();
    }

    @Override
    public synchronized boolean isDone() throws RemoteException {
        if (this.mDexoptCommands == null) {
            throw new IllegalStateException("done() called before prepare()");
        }
        return this.mDexoptCommands.isEmpty();
    }

    @Override
    public synchronized float getProgress() throws RemoteException {
        if (this.completeSize == 0) {
            return 1.0f;
        }
        int commandsLeft = this.mDexoptCommands.size();
        return (float)(this.completeSize - commandsLeft) / (float)this.completeSize;
    }

    @Override
    public synchronized String nextDexoptCommand() throws RemoteException {
        if (this.mDexoptCommands == null) {
            throw new IllegalStateException("dexoptNextPackage() called before prepare()");
        }
        if (this.mDexoptCommands.isEmpty()) {
            return "(all done)";
        }
        String next = this.mDexoptCommands.remove(0);
        if (this.getAvailableSpace() > 0L) {
            ++this.dexoptCommandCountExecuted;
            Log.d(TAG, "Next command: " + next);
            return next;
        }
        Log.w(TAG, "Not enough space for OTA dexopt, stopping with " + (this.mDexoptCommands.size() + 1) + " commands left.");
        this.mDexoptCommands.clear();
        return "(no free space)";
    }

    private long getMainLowSpaceThreshold() {
        File dataDir = Environment.getDataDirectory();
        long lowThreshold = StorageManager.from(this.mContext).getStorageLowBytes(dataDir);
        if (lowThreshold == 0L) {
            throw new IllegalStateException("Invalid low memory threshold");
        }
        return lowThreshold;
    }

    private long getAvailableSpace() {
        long lowThreshold = this.getMainLowSpaceThreshold();
        File dataDir = Environment.getDataDirectory();
        long usableSpace = dataDir.getUsableSpace();
        return usableSpace - lowThreshold;
    }

    private synchronized List<String> generatePackageDexopts(PackageParser.Package pkg, int compilationReason) {
        final ArrayList<String> commands = new ArrayList<String>();
        Installer collectingInstaller = new Installer(this.mContext, true){

            @Override
            public void dexopt(String apkPath, int uid, String pkgName, String instructionSet, int dexoptNeeded, String outputPath, int dexFlags, String compilerFilter, String volumeUuid, String sharedLibraries, String seInfo, boolean downgrade) throws Installer.InstallerException {
                StringBuilder builder = new StringBuilder();
                builder.append("3 ");
                builder.append("dexopt");
                this.encodeParameter(builder, apkPath);
                this.encodeParameter(builder, uid);
                this.encodeParameter(builder, pkgName);
                this.encodeParameter(builder, instructionSet);
                this.encodeParameter(builder, dexoptNeeded);
                this.encodeParameter(builder, outputPath);
                this.encodeParameter(builder, dexFlags);
                this.encodeParameter(builder, compilerFilter);
                this.encodeParameter(builder, volumeUuid);
                this.encodeParameter(builder, sharedLibraries);
                this.encodeParameter(builder, seInfo);
                this.encodeParameter(builder, downgrade);
                commands.add(builder.toString());
            }

            private void encodeParameter(StringBuilder builder, Object arg) {
                builder.append(' ');
                if (arg == null) {
                    builder.append('!');
                    return;
                }
                String txt = String.valueOf(arg);
                if (txt.indexOf(0) != -1 || txt.indexOf(32) != -1 || "!".equals(txt)) {
                    throw new IllegalArgumentException("Invalid argument while executing " + arg);
                }
                builder.append(txt);
            }
        };
        OTADexoptPackageDexOptimizer optimizer = new OTADexoptPackageDexOptimizer(collectingInstaller, this.mPackageManagerService.mInstallLock, this.mContext);
        String[] libraryDependencies = pkg.usesLibraryFiles;
        if (pkg.isSystemApp()) {
            libraryDependencies = NO_LIBRARIES;
        }
        optimizer.performDexOpt(pkg, libraryDependencies, null, null, this.mPackageManagerService.getDexManager().getPackageUseInfoOrDefault(pkg.packageName), new DexoptOptions(pkg.packageName, compilationReason, 4));
        return commands;
    }

    @Override
    public synchronized void dexoptNextPackage() throws RemoteException {
        throw new UnsupportedOperationException();
    }

    private void moveAbArtifacts(Installer installer) {
        if (this.mDexoptCommands != null) {
            throw new IllegalStateException("Should not be ota-dexopting when trying to move.");
        }
        if (!this.mPackageManagerService.isUpgrade()) {
            Slog.d(TAG, "No upgrade, skipping A/B artifacts check.");
            return;
        }
        Collection<PackageParser.Package> pkgs = this.mPackageManagerService.getPackages();
        int packagePaths = 0;
        int pathsSuccessful = 0;
        for (PackageParser.Package pkg : pkgs) {
            String[] dexCodeInstructionSets;
            if (pkg == null || !PackageDexOptimizer.canOptimizePackage(pkg)) continue;
            if (pkg.codePath == null) {
                Slog.w(TAG, "Package " + pkg + " can be optimized but has null codePath");
                continue;
            }
            if (pkg.codePath.startsWith("/system") || pkg.codePath.startsWith("/vendor")) continue;
            String[] instructionSets = InstructionSets.getAppDexInstructionSets(pkg.applicationInfo);
            List<String> paths = pkg.getAllCodePathsExcludingResourceOnly();
            for (String dexCodeInstructionSet : dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(instructionSets)) {
                for (String path : paths) {
                    String oatDir = PackageDexOptimizer.getOatDir(new File(pkg.codePath)).getAbsolutePath();
                    ++packagePaths;
                    try {
                        installer.moveAb(path, dexCodeInstructionSet, oatDir);
                        ++pathsSuccessful;
                    }
                    catch (Installer.InstallerException installerException) {}
                }
            }
        }
        Slog.i(TAG, "Moved " + pathsSuccessful + "/" + packagePaths);
    }

    private void prepareMetricsLogging(int important, int others, long spaceBegin, long spaceBulk) {
        this.availableSpaceBefore = spaceBegin;
        this.availableSpaceAfterBulkDelete = spaceBulk;
        this.availableSpaceAfterDexopt = 0L;
        this.importantPackageCount = important;
        this.otherPackageCount = others;
        this.dexoptCommandCountTotal = this.mDexoptCommands.size();
        this.dexoptCommandCountExecuted = 0;
        this.otaDexoptTimeStart = System.nanoTime();
    }

    private static int inMegabytes(long value) {
        long in_mega_bytes = value / 0x100000L;
        if (in_mega_bytes > Integer.MAX_VALUE) {
            Log.w(TAG, "Recording " + in_mega_bytes + "MB of free space, overflowing range");
            return Integer.MAX_VALUE;
        }
        return (int)in_mega_bytes;
    }

    private void performMetricsLogging() {
        long finalTime = System.nanoTime();
        MetricsLogger.histogram(this.mContext, "ota_dexopt_available_space_before_mb", OtaDexoptService.inMegabytes(this.availableSpaceBefore));
        MetricsLogger.histogram(this.mContext, "ota_dexopt_available_space_after_bulk_delete_mb", OtaDexoptService.inMegabytes(this.availableSpaceAfterBulkDelete));
        MetricsLogger.histogram(this.mContext, "ota_dexopt_available_space_after_dexopt_mb", OtaDexoptService.inMegabytes(this.availableSpaceAfterDexopt));
        MetricsLogger.histogram(this.mContext, "ota_dexopt_num_important_packages", this.importantPackageCount);
        MetricsLogger.histogram(this.mContext, "ota_dexopt_num_other_packages", this.otherPackageCount);
        MetricsLogger.histogram(this.mContext, "ota_dexopt_num_commands", this.dexoptCommandCountTotal);
        MetricsLogger.histogram(this.mContext, "ota_dexopt_num_commands_executed", this.dexoptCommandCountExecuted);
        int elapsedTimeSeconds = (int)TimeUnit.NANOSECONDS.toSeconds(finalTime - this.otaDexoptTimeStart);
        MetricsLogger.histogram(this.mContext, "ota_dexopt_time_s", elapsedTimeSeconds);
    }

    private static class OTADexoptPackageDexOptimizer
    extends PackageDexOptimizer.ForcedUpdatePackageDexOptimizer {
        public OTADexoptPackageDexOptimizer(Installer installer, Object installLock, Context context) {
            super(installer, installLock, context, "*otadexopt*");
        }
    }
}

