/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Base64;
import android.util.LongSparseArray;
import android.util.Slog;
import com.android.internal.util.Preconditions;
import com.android.server.pm.KeySetHandle;
import com.android.server.pm.PackageManagerException;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageSetting;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.PublicKey;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class KeySetManagerService {
    static final String TAG = "KeySetManagerService";
    public static final int FIRST_VERSION = 1;
    public static final int CURRENT_VERSION = 1;
    public static final long KEYSET_NOT_FOUND = -1L;
    protected static final long PUBLIC_KEY_NOT_FOUND = -1L;
    private final LongSparseArray<KeySetHandle> mKeySets = new LongSparseArray();
    private final LongSparseArray<PublicKeyHandle> mPublicKeys = new LongSparseArray();
    protected final LongSparseArray<ArraySet<Long>> mKeySetMapping = new LongSparseArray();
    private final ArrayMap<String, PackageSetting> mPackages;
    private long lastIssuedKeySetId = 0L;
    private long lastIssuedKeyId = 0L;

    public KeySetManagerService(ArrayMap<String, PackageSetting> packages) {
        this.mPackages = packages;
    }

    public boolean packageIsSignedByLPr(String packageName, KeySetHandle ks) {
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new NullPointerException("Invalid package name");
        }
        if (pkg.keySetData == null) {
            throw new NullPointerException("Package has no KeySet data");
        }
        long id2 = this.getIdByKeySetLPr(ks);
        if (id2 == -1L) {
            return false;
        }
        ArraySet<Long> pkgKeys = this.mKeySetMapping.get(pkg.keySetData.getProperSigningKeySet());
        ArraySet<Long> testKeys = this.mKeySetMapping.get(id2);
        return pkgKeys.containsAll(testKeys);
    }

    public boolean packageIsSignedByExactlyLPr(String packageName, KeySetHandle ks) {
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new NullPointerException("Invalid package name");
        }
        if (pkg.keySetData == null || pkg.keySetData.getProperSigningKeySet() == -1L) {
            throw new NullPointerException("Package has no KeySet data");
        }
        long id2 = this.getIdByKeySetLPr(ks);
        if (id2 == -1L) {
            return false;
        }
        ArraySet<Long> pkgKeys = this.mKeySetMapping.get(pkg.keySetData.getProperSigningKeySet());
        ArraySet<Long> testKeys = this.mKeySetMapping.get(id2);
        return pkgKeys.equals(testKeys);
    }

    public void assertScannedPackageValid(PackageParser.Package pkg) throws PackageManagerException {
        ArraySet<String> upgradeAliases;
        if (pkg == null || pkg.packageName == null) {
            throw new PackageManagerException(-2, "Passed invalid package to keyset validation.");
        }
        ArraySet<PublicKey> signingKeys = pkg.mSigningKeys;
        if (signingKeys == null || signingKeys.size() <= 0 || signingKeys.contains(null)) {
            throw new PackageManagerException(-2, "Package has invalid signing-key-set.");
        }
        ArrayMap<String, ArraySet<PublicKey>> definedMapping = pkg.mKeySetMapping;
        if (definedMapping != null) {
            if (definedMapping.containsKey(null) || definedMapping.containsValue(null)) {
                throw new PackageManagerException(-2, "Package has null defined key set.");
            }
            int defMapSize = definedMapping.size();
            for (int i = 0; i < defMapSize; ++i) {
                if (definedMapping.valueAt(i).size() > 0 && !definedMapping.valueAt(i).contains(null)) continue;
                throw new PackageManagerException(-2, "Package has null/no public keys for defined key-sets.");
            }
        }
        if (!((upgradeAliases = pkg.mUpgradeKeySets) == null || definedMapping != null && definedMapping.keySet().containsAll(upgradeAliases))) {
            throw new PackageManagerException(-2, "Package has upgrade-key-sets without corresponding definitions.");
        }
    }

    public void addScannedPackageLPw(PackageParser.Package pkg) {
        Preconditions.checkNotNull(pkg, "Attempted to add null pkg to ksms.");
        Preconditions.checkNotNull(pkg.packageName, "Attempted to add null pkg to ksms.");
        PackageSetting ps = this.mPackages.get(pkg.packageName);
        Preconditions.checkNotNull(ps, "pkg: " + pkg.packageName + "does not have a corresponding entry in mPackages.");
        this.addSigningKeySetToPackageLPw(ps, pkg.mSigningKeys);
        if (pkg.mKeySetMapping != null) {
            this.addDefinedKeySetsToPackageLPw(ps, pkg.mKeySetMapping);
            if (pkg.mUpgradeKeySets != null) {
                this.addUpgradeKeySetsToPackageLPw(ps, pkg.mUpgradeKeySets);
            }
        }
    }

    void addSigningKeySetToPackageLPw(PackageSetting pkg, ArraySet<PublicKey> signingKeys) {
        long signingKeySetId = pkg.keySetData.getProperSigningKeySet();
        if (signingKeySetId != -1L) {
            ArraySet<PublicKey> existingKeys = this.getPublicKeysFromKeySetLPr(signingKeySetId);
            if (existingKeys != null && existingKeys.equals(signingKeys)) {
                return;
            }
            this.decrementKeySetLPw(signingKeySetId);
        }
        KeySetHandle ks = this.addKeySetLPw(signingKeys);
        long id2 = ks.getId();
        pkg.keySetData.setProperSigningKeySet(id2);
    }

    private long getIdByKeySetLPr(KeySetHandle ks) {
        for (int keySetIndex = 0; keySetIndex < this.mKeySets.size(); ++keySetIndex) {
            KeySetHandle value = this.mKeySets.valueAt(keySetIndex);
            if (!ks.equals(value)) continue;
            return this.mKeySets.keyAt(keySetIndex);
        }
        return -1L;
    }

    void addDefinedKeySetsToPackageLPw(PackageSetting pkg, ArrayMap<String, ArraySet<PublicKey>> definedMapping) {
        ArrayMap<String, Long> prevDefinedKeySets = pkg.keySetData.getAliases();
        ArrayMap<String, Long> newKeySetAliases = new ArrayMap<String, Long>();
        int defMapSize = definedMapping.size();
        for (int i = 0; i < defMapSize; ++i) {
            String alias = definedMapping.keyAt(i);
            ArraySet<PublicKey> pubKeys = definedMapping.valueAt(i);
            if (alias == null || pubKeys == null || pubKeys.size() <= 0) continue;
            KeySetHandle ks = this.addKeySetLPw(pubKeys);
            newKeySetAliases.put(alias, ks.getId());
        }
        int prevDefSize = prevDefinedKeySets.size();
        for (int i = 0; i < prevDefSize; ++i) {
            this.decrementKeySetLPw(prevDefinedKeySets.valueAt(i));
        }
        pkg.keySetData.removeAllUpgradeKeySets();
        pkg.keySetData.setAliases(newKeySetAliases);
    }

    void addUpgradeKeySetsToPackageLPw(PackageSetting pkg, ArraySet<String> upgradeAliases) {
        int uaSize = upgradeAliases.size();
        for (int i = 0; i < uaSize; ++i) {
            pkg.keySetData.addUpgradeKeySet(upgradeAliases.valueAt(i));
        }
    }

    public KeySetHandle getKeySetByAliasAndPackageNameLPr(String packageName, String alias) {
        PackageSetting p = this.mPackages.get(packageName);
        if (p == null || p.keySetData == null) {
            return null;
        }
        Long keySetId = p.keySetData.getAliases().get(alias);
        if (keySetId == null) {
            throw new IllegalArgumentException("Unknown KeySet alias: " + alias);
        }
        return this.mKeySets.get(keySetId);
    }

    public boolean isIdValidKeySetId(long id2) {
        return this.mKeySets.get(id2) != null;
    }

    public ArraySet<PublicKey> getPublicKeysFromKeySetLPr(long id2) {
        ArraySet<Long> pkIds = this.mKeySetMapping.get(id2);
        if (pkIds == null) {
            return null;
        }
        ArraySet<PublicKey> mPubKeys = new ArraySet<PublicKey>();
        int pkSize = pkIds.size();
        for (int i = 0; i < pkSize; ++i) {
            mPubKeys.add(this.mPublicKeys.get(pkIds.valueAt(i)).getKey());
        }
        return mPubKeys;
    }

    public KeySetHandle getSigningKeySetByPackageNameLPr(String packageName) {
        PackageSetting p = this.mPackages.get(packageName);
        if (p == null || p.keySetData == null || p.keySetData.getProperSigningKeySet() == -1L) {
            return null;
        }
        return this.mKeySets.get(p.keySetData.getProperSigningKeySet());
    }

    private KeySetHandle addKeySetLPw(ArraySet<PublicKey> keys) {
        if (keys == null || keys.size() == 0) {
            throw new IllegalArgumentException("Cannot add an empty set of keys!");
        }
        ArraySet<Long> addedKeyIds = new ArraySet<Long>(keys.size());
        int kSize = keys.size();
        for (int i = 0; i < kSize; ++i) {
            long id2 = this.addPublicKeyLPw(keys.valueAt(i));
            addedKeyIds.add(id2);
        }
        long existingKeySetId = this.getIdFromKeyIdsLPr(addedKeyIds);
        if (existingKeySetId != -1L) {
            for (int i = 0; i < kSize; ++i) {
                this.decrementPublicKeyLPw(addedKeyIds.valueAt(i));
            }
            KeySetHandle ks = this.mKeySets.get(existingKeySetId);
            ks.incrRefCountLPw();
            return ks;
        }
        long id3 = this.getFreeKeySetIDLPw();
        KeySetHandle ks = new KeySetHandle(id3);
        this.mKeySets.put(id3, ks);
        this.mKeySetMapping.put(id3, addedKeyIds);
        return ks;
    }

    private void decrementKeySetLPw(long id2) {
        KeySetHandle ks = this.mKeySets.get(id2);
        if (ks == null) {
            return;
        }
        if (ks.decrRefCountLPw() <= 0) {
            ArraySet<Long> pubKeys = this.mKeySetMapping.get(id2);
            int pkSize = pubKeys.size();
            for (int i = 0; i < pkSize; ++i) {
                this.decrementPublicKeyLPw(pubKeys.valueAt(i));
            }
            this.mKeySets.delete(id2);
            this.mKeySetMapping.delete(id2);
        }
    }

    private void decrementPublicKeyLPw(long id2) {
        PublicKeyHandle pk = this.mPublicKeys.get(id2);
        if (pk == null) {
            return;
        }
        if (pk.decrRefCountLPw() <= 0L) {
            this.mPublicKeys.delete(id2);
        }
    }

    private long addPublicKeyLPw(PublicKey key) {
        Preconditions.checkNotNull(key, "Cannot add null public key!");
        long id2 = this.getIdForPublicKeyLPr(key);
        if (id2 != -1L) {
            this.mPublicKeys.get(id2).incrRefCountLPw();
            return id2;
        }
        id2 = this.getFreePublicKeyIdLPw();
        this.mPublicKeys.put(id2, new PublicKeyHandle(id2, key));
        return id2;
    }

    private long getIdFromKeyIdsLPr(Set<Long> publicKeyIds) {
        for (int keyMapIndex = 0; keyMapIndex < this.mKeySetMapping.size(); ++keyMapIndex) {
            ArraySet<Long> value = this.mKeySetMapping.valueAt(keyMapIndex);
            if (!value.equals(publicKeyIds)) continue;
            return this.mKeySetMapping.keyAt(keyMapIndex);
        }
        return -1L;
    }

    private long getIdForPublicKeyLPr(PublicKey k) {
        String encodedPublicKey = new String(k.getEncoded());
        for (int publicKeyIndex = 0; publicKeyIndex < this.mPublicKeys.size(); ++publicKeyIndex) {
            PublicKey value = this.mPublicKeys.valueAt(publicKeyIndex).getKey();
            String encodedExistingKey = new String(value.getEncoded());
            if (!encodedPublicKey.equals(encodedExistingKey)) continue;
            return this.mPublicKeys.keyAt(publicKeyIndex);
        }
        return -1L;
    }

    private long getFreeKeySetIDLPw() {
        ++this.lastIssuedKeySetId;
        return this.lastIssuedKeySetId;
    }

    private long getFreePublicKeyIdLPw() {
        ++this.lastIssuedKeyId;
        return this.lastIssuedKeyId;
    }

    public void removeAppKeySetDataLPw(String packageName) {
        PackageSetting pkg = this.mPackages.get(packageName);
        Preconditions.checkNotNull(pkg, "pkg name: " + packageName + "does not have a corresponding entry in mPackages.");
        long signingKeySetId = pkg.keySetData.getProperSigningKeySet();
        this.decrementKeySetLPw(signingKeySetId);
        ArrayMap<String, Long> definedKeySets = pkg.keySetData.getAliases();
        for (int i = 0; i < definedKeySets.size(); ++i) {
            this.decrementKeySetLPw(definedKeySets.valueAt(i));
        }
        this.clearPackageKeySetDataLPw(pkg);
    }

    private void clearPackageKeySetDataLPw(PackageSetting pkg) {
        pkg.keySetData.setProperSigningKeySet(-1L);
        pkg.keySetData.removeAllDefinedKeySets();
        pkg.keySetData.removeAllUpgradeKeySets();
    }

    public String encodePublicKey(PublicKey k) throws IOException {
        return new String(Base64.encode(k.getEncoded(), 2));
    }

    public void dumpLPr(PrintWriter pw, String packageName, PackageManagerService.DumpState dumpState) {
        boolean printedHeader = false;
        for (Map.Entry<String, PackageSetting> e : this.mPackages.entrySet()) {
            String keySetPackage = e.getKey();
            if (packageName != null && !packageName.equals(keySetPackage)) continue;
            if (!printedHeader) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                pw.println("Key Set Manager:");
                printedHeader = true;
            }
            PackageSetting pkg = e.getValue();
            pw.print("  [");
            pw.print(keySetPackage);
            pw.println("]");
            if (pkg.keySetData == null) continue;
            boolean printedLabel = false;
            for (Map.Entry<String, Long> entry : pkg.keySetData.getAliases().entrySet()) {
                if (!printedLabel) {
                    pw.print("      KeySets Aliases: ");
                    printedLabel = true;
                } else {
                    pw.print(", ");
                }
                pw.print(entry.getKey());
                pw.print('=');
                pw.print(Long.toString(entry.getValue()));
            }
            if (printedLabel) {
                pw.println("");
            }
            printedLabel = false;
            if (pkg.keySetData.isUsingDefinedKeySets()) {
                ArrayMap<String, Long> definedKeySets = pkg.keySetData.getAliases();
                int dksSize = definedKeySets.size();
                for (int i = 0; i < dksSize; ++i) {
                    if (!printedLabel) {
                        pw.print("      Defined KeySets: ");
                        printedLabel = true;
                    } else {
                        pw.print(", ");
                    }
                    pw.print(Long.toString(definedKeySets.valueAt(i)));
                }
            }
            if (printedLabel) {
                pw.println("");
            }
            printedLabel = false;
            long signingKeySet = pkg.keySetData.getProperSigningKeySet();
            pw.print("      Signing KeySets: ");
            pw.print(Long.toString(signingKeySet));
            pw.println("");
            if (pkg.keySetData.isUsingUpgradeKeySets()) {
                for (long keySetId : pkg.keySetData.getUpgradeKeySets()) {
                    if (!printedLabel) {
                        pw.print("      Upgrade KeySets: ");
                        printedLabel = true;
                    } else {
                        pw.print(", ");
                    }
                    pw.print(Long.toString(keySetId));
                }
            }
            if (!printedLabel) continue;
            pw.println("");
        }
    }

    void writeKeySetManagerServiceLPr(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, "keyset-settings");
        serializer.attribute(null, "version", Integer.toString(1));
        this.writePublicKeysLPr(serializer);
        this.writeKeySetsLPr(serializer);
        serializer.startTag(null, "lastIssuedKeyId");
        serializer.attribute(null, "value", Long.toString(this.lastIssuedKeyId));
        serializer.endTag(null, "lastIssuedKeyId");
        serializer.startTag(null, "lastIssuedKeySetId");
        serializer.attribute(null, "value", Long.toString(this.lastIssuedKeySetId));
        serializer.endTag(null, "lastIssuedKeySetId");
        serializer.endTag(null, "keyset-settings");
    }

    void writePublicKeysLPr(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, "keys");
        for (int pKeyIndex = 0; pKeyIndex < this.mPublicKeys.size(); ++pKeyIndex) {
            long id2 = this.mPublicKeys.keyAt(pKeyIndex);
            PublicKeyHandle pkh = this.mPublicKeys.valueAt(pKeyIndex);
            String encodedKey = this.encodePublicKey(pkh.getKey());
            serializer.startTag(null, "public-key");
            serializer.attribute(null, "identifier", Long.toString(id2));
            serializer.attribute(null, "value", encodedKey);
            serializer.endTag(null, "public-key");
        }
        serializer.endTag(null, "keys");
    }

    void writeKeySetsLPr(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, "keysets");
        for (int keySetIndex = 0; keySetIndex < this.mKeySetMapping.size(); ++keySetIndex) {
            long id2 = this.mKeySetMapping.keyAt(keySetIndex);
            ArraySet<Long> keys = this.mKeySetMapping.valueAt(keySetIndex);
            serializer.startTag(null, "keyset");
            serializer.attribute(null, "identifier", Long.toString(id2));
            for (long keyId : keys) {
                serializer.startTag(null, "key-id");
                serializer.attribute(null, "identifier", Long.toString(keyId));
                serializer.endTag(null, "key-id");
            }
            serializer.endTag(null, "keyset");
        }
        serializer.endTag(null, "keysets");
    }

    void readKeySetsLPw(XmlPullParser parser, ArrayMap<Long, Integer> keySetRefCounts) throws XmlPullParserException, IOException {
        int type;
        long currentKeySetId = 0L;
        int outerDepth = parser.getDepth();
        String recordedVersionStr = parser.getAttributeValue(null, "version");
        if (recordedVersionStr == null) {
            int type2;
            while ((type2 = parser.next()) != 1 && (type2 != 3 || parser.getDepth() > outerDepth)) {
            }
            for (PackageSetting p : this.mPackages.values()) {
                this.clearPackageKeySetDataLPw(p);
            }
            return;
        }
        int recordedVersion = Integer.parseInt(recordedVersionStr);
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("keys")) {
                this.readKeysLPw(parser);
                continue;
            }
            if (tagName.equals("keysets")) {
                this.readKeySetListLPw(parser);
                continue;
            }
            if (tagName.equals("lastIssuedKeyId")) {
                this.lastIssuedKeyId = Long.parseLong(parser.getAttributeValue(null, "value"));
                continue;
            }
            if (!tagName.equals("lastIssuedKeySetId")) continue;
            this.lastIssuedKeySetId = Long.parseLong(parser.getAttributeValue(null, "value"));
        }
        this.addRefCountsFromSavedPackagesLPw(keySetRefCounts);
    }

    void readKeysLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String tagName;
            if (type == 3 || type == 4 || !(tagName = parser.getName()).equals("public-key")) continue;
            this.readPublicKeyLPw(parser);
        }
    }

    void readKeySetListLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        long currentKeySetId = 0L;
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String encodedID;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("keyset")) {
                encodedID = parser.getAttributeValue(null, "identifier");
                currentKeySetId = Long.parseLong(encodedID);
                int refCount = 0;
                this.mKeySets.put(currentKeySetId, new KeySetHandle(currentKeySetId, refCount));
                this.mKeySetMapping.put(currentKeySetId, new ArraySet());
                continue;
            }
            if (!tagName.equals("key-id")) continue;
            encodedID = parser.getAttributeValue(null, "identifier");
            long id2 = Long.parseLong(encodedID);
            this.mKeySetMapping.get(currentKeySetId).add(id2);
        }
    }

    void readPublicKeyLPw(XmlPullParser parser) throws XmlPullParserException {
        String encodedID = parser.getAttributeValue(null, "identifier");
        long identifier = Long.parseLong(encodedID);
        int refCount = 0;
        String encodedPublicKey = parser.getAttributeValue(null, "value");
        PublicKey pub = PackageParser.parsePublicKey(encodedPublicKey);
        if (pub != null) {
            PublicKeyHandle pkh = new PublicKeyHandle(identifier, refCount, pub);
            this.mPublicKeys.put(identifier, pkh);
        }
    }

    private void addRefCountsFromSavedPackagesLPw(ArrayMap<Long, Integer> keySetRefCounts) {
        int numRefCounts = keySetRefCounts.size();
        for (int i = 0; i < numRefCounts; ++i) {
            KeySetHandle ks = this.mKeySets.get(keySetRefCounts.keyAt(i));
            if (ks == null) {
                Slog.wtf(TAG, "Encountered non-existent key-set reference when reading settings");
                continue;
            }
            ks.setRefCountLPw(keySetRefCounts.valueAt(i));
        }
        ArraySet<Long> orphanedKeySets = new ArraySet<Long>();
        int numKeySets = this.mKeySets.size();
        for (int i = 0; i < numKeySets; ++i) {
            if (this.mKeySets.valueAt(i).getRefCountLPr() == 0) {
                Slog.wtf(TAG, "Encountered key-set w/out package references when reading settings");
                orphanedKeySets.add(this.mKeySets.keyAt(i));
            }
            ArraySet<Long> pubKeys = this.mKeySetMapping.valueAt(i);
            int pkSize = pubKeys.size();
            for (int j = 0; j < pkSize; ++j) {
                this.mPublicKeys.get(pubKeys.valueAt(j)).incrRefCountLPw();
            }
        }
        int numOrphans = orphanedKeySets.size();
        for (int i = 0; i < numOrphans; ++i) {
            this.decrementKeySetLPw((Long)orphanedKeySets.valueAt(i));
        }
    }

    class PublicKeyHandle {
        private final PublicKey mKey;
        private final long mId;
        private int mRefCount;

        public PublicKeyHandle(long id2, PublicKey key) {
            this.mId = id2;
            this.mRefCount = 1;
            this.mKey = key;
        }

        private PublicKeyHandle(long id2, int refCount, PublicKey key) {
            this.mId = id2;
            this.mRefCount = refCount;
            this.mKey = key;
        }

        public long getId() {
            return this.mId;
        }

        public PublicKey getKey() {
            return this.mKey;
        }

        public int getRefCountLPr() {
            return this.mRefCount;
        }

        public void incrRefCountLPw() {
            ++this.mRefCount;
        }

        public long decrRefCountLPw() {
            --this.mRefCount;
            return this.mRefCount;
        }
    }
}

