/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Icon;
import android.media.AudioAttributes;
import android.media.AudioSystem;
import android.metrics.LogMaker;
import android.net.Uri;
import android.os.Bundle;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.notification.Adjustment;
import android.service.notification.NotificationListenerService;
import android.service.notification.SnoozeCriterion;
import android.service.notification.StatusBarNotification;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import android.widget.RemoteViews;
import com.android.internal.logging.MetricsLogger;
import com.android.server.EventLogTags;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.NotificationUsageStats;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class NotificationRecord {
    static final String TAG = "NotificationRecord";
    static final boolean DBG = Log.isLoggable("NotificationRecord", 3);
    private static final int MAX_LOGTAG_LENGTH = 35;
    final StatusBarNotification sbn;
    final int mOriginalFlags;
    private final Context mContext;
    NotificationUsageStats.SingleNotificationStats stats;
    boolean isCanceled;
    boolean mIsSeen;
    private float mContactAffinity;
    private boolean mRecentlyIntrusive;
    private long mLastIntrusive;
    private boolean mIntercept;
    private long mRankingTimeMs;
    private long mCreationTimeMs;
    private long mVisibleSinceMs;
    private long mUpdateTimeMs;
    public boolean isUpdate;
    private int mPackagePriority;
    private int mAuthoritativeRank;
    private String mGlobalSortKey;
    private int mPackageVisibility;
    private int mUserImportance = -1000;
    private int mImportance = -1000;
    private CharSequence mImportanceExplanation = null;
    private int mSuppressedVisualEffects = 0;
    private String mUserExplanation;
    private String mPeopleExplanation;
    private boolean mPreChannelsNotification = true;
    private Uri mSound;
    private long[] mVibration;
    private AudioAttributes mAttributes;
    private NotificationChannel mChannel;
    private ArrayList<String> mPeopleOverride;
    private ArrayList<SnoozeCriterion> mSnoozeCriteria;
    private boolean mShowBadge;
    private LogMaker mLogMaker;
    private Light mLight;
    private String mGroupLogTag;
    private String mChannelIdLogTag;
    private final List<Adjustment> mAdjustments;

    public NotificationRecord(Context context, StatusBarNotification sbn, NotificationChannel channel) {
        this.sbn = sbn;
        this.mOriginalFlags = sbn.getNotification().flags;
        this.mRankingTimeMs = this.calculateRankingTimeMs(0L);
        this.mUpdateTimeMs = this.mCreationTimeMs = sbn.getPostTime();
        this.mContext = context;
        this.stats = new NotificationUsageStats.SingleNotificationStats();
        this.mChannel = channel;
        this.mPreChannelsNotification = this.isPreChannelsNotification();
        this.mSound = this.calculateSound();
        this.mVibration = this.calculateVibration();
        this.mAttributes = this.calculateAttributes();
        this.mImportance = this.calculateImportance();
        this.mLight = this.calculateLights();
        this.mAdjustments = new ArrayList<Adjustment>();
    }

    private boolean isPreChannelsNotification() {
        try {
            if ("miscellaneous".equals(this.getChannel().getId())) {
                ApplicationInfo applicationInfo = this.mContext.getPackageManager().getApplicationInfoAsUser(this.sbn.getPackageName(), 0, UserHandle.getUserId(this.sbn.getUid()));
                if (applicationInfo.targetSdkVersion < 26) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(TAG, "Can't find package", e);
        }
        return false;
    }

    private Uri calculateSound() {
        Notification n = this.sbn.getNotification();
        if (this.mContext.getPackageManager().hasSystemFeature("android.software.leanback")) {
            return null;
        }
        Uri sound = this.mChannel.getSound();
        if (this.mPreChannelsNotification && (this.getChannel().getUserLockedFields() & 0x20) == 0) {
            boolean useDefaultSound = (n.defaults & 1) != 0;
            sound = useDefaultSound ? Settings.System.DEFAULT_NOTIFICATION_URI : n.sound;
        }
        return sound;
    }

    private Light calculateLights() {
        Light light;
        int defaultLightColor = this.mContext.getResources().getColor(17170521);
        int defaultLightOn = this.mContext.getResources().getInteger(17694768);
        int defaultLightOff = this.mContext.getResources().getInteger(17694767);
        int channelLightColor = this.getChannel().getLightColor() != 0 ? this.getChannel().getLightColor() : defaultLightColor;
        Light light2 = light = this.getChannel().shouldShowLights() ? new Light(channelLightColor, defaultLightOn, defaultLightOff) : null;
        if (this.mPreChannelsNotification && (this.getChannel().getUserLockedFields() & 8) == 0) {
            Notification notification = this.sbn.getNotification();
            if ((notification.flags & 1) != 0) {
                light = new Light(notification.ledARGB, notification.ledOnMS, notification.ledOffMS);
                if ((notification.defaults & 4) != 0) {
                    light = new Light(defaultLightColor, defaultLightOn, defaultLightOff);
                }
            } else {
                light = null;
            }
        }
        return light;
    }

    private long[] calculateVibration() {
        long[] defaultVibration = NotificationManagerService.getLongArray(this.mContext.getResources(), 17235995, 17, NotificationManagerService.DEFAULT_VIBRATE_PATTERN);
        long[] vibration = this.getChannel().shouldVibrate() ? (this.getChannel().getVibrationPattern() == null ? defaultVibration : this.getChannel().getVibrationPattern()) : null;
        if (this.mPreChannelsNotification && (this.getChannel().getUserLockedFields() & 0x10) == 0) {
            Notification notification = this.sbn.getNotification();
            boolean useDefaultVibrate = (notification.defaults & 2) != 0;
            vibration = useDefaultVibrate ? defaultVibration : notification.vibrate;
        }
        return vibration;
    }

    private AudioAttributes calculateAttributes() {
        Notification n = this.sbn.getNotification();
        AudioAttributes attributes = this.getChannel().getAudioAttributes();
        if (attributes == null) {
            attributes = Notification.AUDIO_ATTRIBUTES_DEFAULT;
        }
        if (this.mPreChannelsNotification && (this.getChannel().getUserLockedFields() & 0x20) == 0) {
            if (n.audioAttributes != null) {
                attributes = n.audioAttributes;
            } else if (n.audioStreamType >= 0 && n.audioStreamType < AudioSystem.getNumStreamTypes()) {
                attributes = new AudioAttributes.Builder().setInternalLegacyStreamType(n.audioStreamType).build();
            } else if (n.audioStreamType != -1) {
                Log.w(TAG, String.format("Invalid stream type: %d", n.audioStreamType));
            }
        }
        return attributes;
    }

    private int calculateImportance() {
        Notification n = this.sbn.getNotification();
        int importance = this.getChannel().getImportance();
        int requestedImportance = 3;
        if (0 != (n.flags & 0x80)) {
            n.priority = 2;
        }
        n.priority = NotificationManagerService.clamp(n.priority, -2, 2);
        switch (n.priority) {
            case -2: {
                requestedImportance = 1;
                break;
            }
            case -1: {
                requestedImportance = 2;
                break;
            }
            case 0: {
                requestedImportance = 3;
                break;
            }
            case 1: 
            case 2: {
                requestedImportance = 4;
            }
        }
        this.stats.requestedImportance = requestedImportance;
        boolean bl = this.stats.isNoisy = this.mSound != null || this.mVibration != null;
        if (this.mPreChannelsNotification && (importance == -1000 || (this.getChannel().getUserLockedFields() & 4) == 0)) {
            if (!this.stats.isNoisy && requestedImportance > 2) {
                requestedImportance = 2;
            }
            if (this.stats.isNoisy && requestedImportance < 3) {
                requestedImportance = 3;
            }
            if (n.fullScreenIntent != null) {
                requestedImportance = 4;
            }
            importance = requestedImportance;
        }
        this.stats.naturalImportance = importance;
        return importance;
    }

    public void copyRankingInformation(NotificationRecord previous) {
        this.mContactAffinity = previous.mContactAffinity;
        this.mRecentlyIntrusive = previous.mRecentlyIntrusive;
        this.mPackagePriority = previous.mPackagePriority;
        this.mPackageVisibility = previous.mPackageVisibility;
        this.mIntercept = previous.mIntercept;
        this.mRankingTimeMs = this.calculateRankingTimeMs(previous.getRankingTimeMs());
        this.mCreationTimeMs = previous.mCreationTimeMs;
        this.mVisibleSinceMs = previous.mVisibleSinceMs;
        if (previous.sbn.getOverrideGroupKey() != null && !this.sbn.isAppGroup()) {
            this.sbn.setOverrideGroupKey(previous.sbn.getOverrideGroupKey());
        }
    }

    public Notification getNotification() {
        return this.sbn.getNotification();
    }

    public int getFlags() {
        return this.sbn.getNotification().flags;
    }

    public UserHandle getUser() {
        return this.sbn.getUser();
    }

    public String getKey() {
        return this.sbn.getKey();
    }

    public int getUserId() {
        return this.sbn.getUserId();
    }

    void dump(ProtoOutputStream proto, boolean redact) {
        proto.write(0x10E00000001L, this.sbn.getKey());
        if (this.getChannel() != null) {
            proto.write(1159641169924L, this.getChannel().getId());
        }
        proto.write(1155346202632L, this.getLight() != null);
        proto.write(1155346202631L, this.getVibration() != null);
        proto.write(0x10300000003L, this.sbn.getNotification().flags);
        proto.write(1159641169929L, this.getGroupKey());
        proto.write(1112396529674L, this.getImportance());
        if (this.getSound() != null) {
            proto.write(1159641169925L, this.getSound().toString());
        }
        if (this.getAudioAttributes() != null) {
            proto.write(1112396529670L, this.getAudioAttributes().getUsage());
        }
    }

    String formatRemoteViews(RemoteViews rv) {
        if (rv == null) {
            return "null";
        }
        return String.format("%s/0x%08x (%d bytes): %s", rv.getPackage(), rv.getLayoutId(), rv.estimateMemoryUsage(), rv.toString());
    }

    void dump(PrintWriter pw, String prefix, Context baseContext, boolean redact) {
        Notification notification = this.sbn.getNotification();
        Icon icon = notification.getSmallIcon();
        String iconStr = String.valueOf(icon);
        if (icon != null && icon.getType() == 2) {
            iconStr = iconStr + " / " + NotificationRecord.idDebugString(baseContext, icon.getResPackage(), icon.getResId());
        }
        pw.println(prefix + this);
        prefix = prefix + "  ";
        pw.println(prefix + "uid=" + this.sbn.getUid() + " userId=" + this.sbn.getUserId());
        pw.println(prefix + "icon=" + iconStr);
        pw.println(prefix + "flags=0x" + Integer.toHexString(notification.flags));
        pw.println(prefix + "pri=" + notification.priority);
        pw.println(prefix + "key=" + this.sbn.getKey());
        pw.println(prefix + "seen=" + this.mIsSeen);
        pw.println(prefix + "groupKey=" + this.getGroupKey());
        pw.println(prefix + "fullscreenIntent=" + notification.fullScreenIntent);
        pw.println(prefix + "contentIntent=" + notification.contentIntent);
        pw.println(prefix + "deleteIntent=" + notification.deleteIntent);
        pw.print(prefix + "tickerText=");
        if (!TextUtils.isEmpty(notification.tickerText)) {
            String ticker = notification.tickerText.toString();
            if (redact) {
                pw.print(ticker.length() > 16 ? ticker.substring(0, 8) : "");
                pw.println("...");
            } else {
                pw.println(ticker);
            }
        } else {
            pw.println("null");
        }
        pw.println(prefix + "contentView=" + this.formatRemoteViews(notification.contentView));
        pw.println(prefix + "bigContentView=" + this.formatRemoteViews(notification.bigContentView));
        pw.println(prefix + "headsUpContentView=" + this.formatRemoteViews(notification.headsUpContentView));
        pw.print(prefix + String.format("color=0x%08x", notification.color));
        pw.println(prefix + "timeout=" + TimeUtils.formatForLogging(notification.getTimeoutAfter()));
        if (notification.actions != null && notification.actions.length > 0) {
            pw.println(prefix + "actions={");
            int N = notification.actions.length;
            for (int i = 0; i < N; ++i) {
                Notification.Action action = notification.actions[i];
                if (action == null) continue;
                pw.println(String.format("%s    [%d] \"%s\" -> %s", prefix, i, action.title, action.actionIntent == null ? "null" : action.actionIntent.toString()));
            }
            pw.println(prefix + "  }");
        }
        if (notification.extras != null && notification.extras.size() > 0) {
            pw.println(prefix + "extras={");
            for (String key : notification.extras.keySet()) {
                pw.print(prefix + "    " + key + "=");
                Object val = notification.extras.get(key);
                if (val == null) {
                    pw.println("null");
                    continue;
                }
                pw.print(val.getClass().getSimpleName());
                if (!redact || !(val instanceof CharSequence) && !(val instanceof String)) {
                    if (val instanceof Bitmap) {
                        pw.print(String.format(" (%dx%d)", ((Bitmap)val).getWidth(), ((Bitmap)val).getHeight()));
                    } else if (val.getClass().isArray()) {
                        int N = Array.getLength(val);
                        pw.print(" (" + N + ")");
                        if (!redact) {
                            for (int j = 0; j < N; ++j) {
                                pw.println();
                                pw.print(String.format("%s      [%d] %s", prefix, j, String.valueOf(Array.get(val, j))));
                            }
                        }
                    } else {
                        pw.print(" (" + String.valueOf(val) + ")");
                    }
                }
                pw.println();
            }
            pw.println(prefix + "}");
        }
        pw.println(prefix + "stats=" + this.stats.toString());
        pw.println(prefix + "mContactAffinity=" + this.mContactAffinity);
        pw.println(prefix + "mRecentlyIntrusive=" + this.mRecentlyIntrusive);
        pw.println(prefix + "mPackagePriority=" + this.mPackagePriority);
        pw.println(prefix + "mPackageVisibility=" + this.mPackageVisibility);
        pw.println(prefix + "mUserImportance=" + NotificationListenerService.Ranking.importanceToString(this.mUserImportance));
        pw.println(prefix + "mImportance=" + NotificationListenerService.Ranking.importanceToString(this.mImportance));
        pw.println(prefix + "mImportanceExplanation=" + this.mImportanceExplanation);
        pw.println(prefix + "mIntercept=" + this.mIntercept);
        pw.println(prefix + "mGlobalSortKey=" + this.mGlobalSortKey);
        pw.println(prefix + "mRankingTimeMs=" + this.mRankingTimeMs);
        pw.println(prefix + "mCreationTimeMs=" + this.mCreationTimeMs);
        pw.println(prefix + "mVisibleSinceMs=" + this.mVisibleSinceMs);
        pw.println(prefix + "mUpdateTimeMs=" + this.mUpdateTimeMs);
        pw.println(prefix + "mSuppressedVisualEffects= " + this.mSuppressedVisualEffects);
        if (this.mPreChannelsNotification) {
            pw.println(prefix + String.format("defaults=0x%08x flags=0x%08x", notification.defaults, notification.flags));
            pw.println(prefix + "n.sound=" + notification.sound);
            pw.println(prefix + "n.audioStreamType=" + notification.audioStreamType);
            pw.println(prefix + "n.audioAttributes=" + notification.audioAttributes);
            pw.println(prefix + String.format("  led=0x%08x onMs=%d offMs=%d", notification.ledARGB, notification.ledOnMS, notification.ledOffMS));
            pw.println(prefix + "vibrate=" + Arrays.toString(notification.vibrate));
        }
        pw.println(prefix + "mSound= " + this.mSound);
        pw.println(prefix + "mVibration= " + this.mVibration);
        pw.println(prefix + "mAttributes= " + this.mAttributes);
        pw.println(prefix + "mLight= " + this.mLight);
        pw.println(prefix + "mShowBadge=" + this.mShowBadge);
        pw.println(prefix + "mColorized=" + notification.isColorized());
        pw.println(prefix + "effectiveNotificationChannel=" + this.getChannel());
        if (this.getPeopleOverride() != null) {
            pw.println(prefix + "overridePeople= " + TextUtils.join((CharSequence)",", this.getPeopleOverride()));
        }
        if (this.getSnoozeCriteria() != null) {
            pw.println(prefix + "snoozeCriteria=" + TextUtils.join((CharSequence)",", this.getSnoozeCriteria()));
        }
        pw.println(prefix + "mAdjustments=" + this.mAdjustments);
    }

    static String idDebugString(Context baseContext, String packageName, int id2) {
        Context c;
        if (packageName != null) {
            try {
                c = baseContext.createPackageContext(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                c = baseContext;
            }
        } else {
            c = baseContext;
        }
        Resources r = c.getResources();
        try {
            return r.getResourceName(id2);
        }
        catch (Resources.NotFoundException e) {
            return "<name unknown>";
        }
    }

    public final String toString() {
        return String.format("NotificationRecord(0x%08x: pkg=%s user=%s id=%d tag=%s importance=%d key=%s: %s)", System.identityHashCode(this), this.sbn.getPackageName(), this.sbn.getUser(), this.sbn.getId(), this.sbn.getTag(), this.mImportance, this.sbn.getKey(), this.sbn.getNotification());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdjustment(Adjustment adjustment) {
        List<Adjustment> list = this.mAdjustments;
        synchronized (list) {
            this.mAdjustments.add(adjustment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyAdjustments() {
        List<Adjustment> list = this.mAdjustments;
        synchronized (list) {
            for (Adjustment adjustment : this.mAdjustments) {
                Bundle signals = adjustment.getSignals();
                if (signals.containsKey("key_people")) {
                    ArrayList<String> people = adjustment.getSignals().getStringArrayList("key_people");
                    this.setPeopleOverride(people);
                }
                if (signals.containsKey("key_snooze_criteria")) {
                    ArrayList<SnoozeCriterion> snoozeCriterionList = adjustment.getSignals().getParcelableArrayList("key_snooze_criteria");
                    this.setSnoozeCriteria(snoozeCriterionList);
                }
                if (!signals.containsKey("key_group_key")) continue;
                String groupOverrideKey = adjustment.getSignals().getString("key_group_key");
                this.setOverrideGroupKey(groupOverrideKey);
            }
        }
    }

    public void setContactAffinity(float contactAffinity) {
        this.mContactAffinity = contactAffinity;
        if (this.mImportance < 3 && this.mContactAffinity > 0.5f) {
            this.setImportance(3, this.getPeopleExplanation());
        }
    }

    public float getContactAffinity() {
        return this.mContactAffinity;
    }

    public void setRecentlyIntrusive(boolean recentlyIntrusive) {
        this.mRecentlyIntrusive = recentlyIntrusive;
        if (recentlyIntrusive) {
            this.mLastIntrusive = System.currentTimeMillis();
        }
    }

    public boolean isRecentlyIntrusive() {
        return this.mRecentlyIntrusive;
    }

    public long getLastIntrusive() {
        return this.mLastIntrusive;
    }

    public void setPackagePriority(int packagePriority) {
        this.mPackagePriority = packagePriority;
    }

    public int getPackagePriority() {
        return this.mPackagePriority;
    }

    public void setPackageVisibilityOverride(int packageVisibility) {
        this.mPackageVisibility = packageVisibility;
    }

    public int getPackageVisibilityOverride() {
        return this.mPackageVisibility;
    }

    public void setUserImportance(int importance) {
        this.mUserImportance = importance;
        this.applyUserImportance();
    }

    private String getUserExplanation() {
        if (this.mUserExplanation == null) {
            this.mUserExplanation = this.mContext.getResources().getString(17039978);
        }
        return this.mUserExplanation;
    }

    private String getPeopleExplanation() {
        if (this.mPeopleExplanation == null) {
            this.mPeopleExplanation = this.mContext.getResources().getString(17039977);
        }
        return this.mPeopleExplanation;
    }

    private void applyUserImportance() {
        if (this.mUserImportance != -1000) {
            this.mImportance = this.mUserImportance;
            this.mImportanceExplanation = this.getUserExplanation();
        }
    }

    public int getUserImportance() {
        return this.mUserImportance;
    }

    public void setImportance(int importance, CharSequence explanation) {
        if (importance != -1000) {
            this.mImportance = importance;
            this.mImportanceExplanation = explanation;
        }
        this.applyUserImportance();
    }

    public int getImportance() {
        return this.mImportance;
    }

    public CharSequence getImportanceExplanation() {
        return this.mImportanceExplanation;
    }

    public boolean setIntercepted(boolean intercept) {
        this.mIntercept = intercept;
        return this.mIntercept;
    }

    public boolean isIntercepted() {
        return this.mIntercept;
    }

    public void setSuppressedVisualEffects(int effects) {
        this.mSuppressedVisualEffects = effects;
    }

    public int getSuppressedVisualEffects() {
        return this.mSuppressedVisualEffects;
    }

    public boolean isCategory(String category) {
        return Objects.equals(this.getNotification().category, category);
    }

    public boolean isAudioStream(int stream) {
        return this.getNotification().audioStreamType == stream;
    }

    public boolean isAudioAttributesUsage(int usage) {
        AudioAttributes attributes = this.getNotification().audioAttributes;
        return attributes != null && attributes.getUsage() == usage;
    }

    public long getRankingTimeMs() {
        return this.mRankingTimeMs;
    }

    public int getFreshnessMs(long now) {
        return (int)(now - this.mUpdateTimeMs);
    }

    public int getLifespanMs(long now) {
        return (int)(now - this.mCreationTimeMs);
    }

    public int getExposureMs(long now) {
        return this.mVisibleSinceMs == 0L ? 0 : (int)(now - this.mVisibleSinceMs);
    }

    public void setVisibility(boolean visible, int rank) {
        long now = System.currentTimeMillis();
        this.mVisibleSinceMs = visible ? now : this.mVisibleSinceMs;
        this.stats.onVisibilityChanged(visible);
        MetricsLogger.action(this.getLogMaker(now).setCategory(128).setType(visible ? 1 : 2).addTaggedData(798, rank));
        if (visible) {
            MetricsLogger.histogram(this.mContext, "note_freshness", this.getFreshnessMs(now));
        }
        EventLogTags.writeNotificationVisibility(this.getKey(), visible ? 1 : 0, this.getLifespanMs(now), this.getFreshnessMs(now), 0, rank);
    }

    private long calculateRankingTimeMs(long previousRankingTimeMs) {
        Notification n = this.getNotification();
        if (n.when != 0L && n.when <= this.sbn.getPostTime()) {
            return n.when;
        }
        if (previousRankingTimeMs > 0L) {
            return previousRankingTimeMs;
        }
        return this.sbn.getPostTime();
    }

    public void setGlobalSortKey(String globalSortKey) {
        this.mGlobalSortKey = globalSortKey;
    }

    public String getGlobalSortKey() {
        return this.mGlobalSortKey;
    }

    public boolean isSeen() {
        return this.mIsSeen;
    }

    public void setSeen() {
        this.mIsSeen = true;
    }

    public void setAuthoritativeRank(int authoritativeRank) {
        this.mAuthoritativeRank = authoritativeRank;
    }

    public int getAuthoritativeRank() {
        return this.mAuthoritativeRank;
    }

    public String getGroupKey() {
        return this.sbn.getGroupKey();
    }

    public void setOverrideGroupKey(String overrideGroupKey) {
        this.sbn.setOverrideGroupKey(overrideGroupKey);
        this.mGroupLogTag = null;
    }

    private String getGroupLogTag() {
        if (this.mGroupLogTag == null) {
            this.mGroupLogTag = this.shortenTag(this.sbn.getGroup());
        }
        return this.mGroupLogTag;
    }

    private String getChannelIdLogTag() {
        if (this.mChannelIdLogTag == null) {
            this.mChannelIdLogTag = this.shortenTag(this.mChannel.getId());
        }
        return this.mChannelIdLogTag;
    }

    private String shortenTag(String longTag) {
        if (longTag == null) {
            return null;
        }
        if (longTag.length() < 35) {
            return longTag;
        }
        return longTag.substring(0, 27) + "-" + Integer.toHexString(longTag.hashCode());
    }

    public boolean isImportanceFromUser() {
        return this.mImportance == this.mUserImportance;
    }

    public NotificationChannel getChannel() {
        return this.mChannel;
    }

    protected void updateNotificationChannel(NotificationChannel channel) {
        if (channel != null) {
            this.mChannel = channel;
            this.calculateImportance();
        }
    }

    public void setShowBadge(boolean showBadge) {
        this.mShowBadge = showBadge;
    }

    public boolean canShowBadge() {
        return this.mShowBadge;
    }

    public Light getLight() {
        return this.mLight;
    }

    public Uri getSound() {
        return this.mSound;
    }

    public long[] getVibration() {
        return this.mVibration;
    }

    public AudioAttributes getAudioAttributes() {
        return this.mAttributes;
    }

    public ArrayList<String> getPeopleOverride() {
        return this.mPeopleOverride;
    }

    protected void setPeopleOverride(ArrayList<String> people) {
        this.mPeopleOverride = people;
    }

    public ArrayList<SnoozeCriterion> getSnoozeCriteria() {
        return this.mSnoozeCriteria;
    }

    protected void setSnoozeCriteria(ArrayList<SnoozeCriterion> snoozeCriteria) {
        this.mSnoozeCriteria = snoozeCriteria;
    }

    public LogMaker getLogMaker(long now) {
        if (this.mLogMaker == null) {
            this.mLogMaker = new LogMaker(0).setPackageName(this.sbn.getPackageName()).addTaggedData(796, this.sbn.getId()).addTaggedData(797, this.sbn.getTag()).addTaggedData(857, this.getChannelIdLogTag());
        }
        return this.mLogMaker.clearCategory().clearType().clearSubtype().clearTaggedData(798).addTaggedData(858, this.mImportance).addTaggedData(946, this.getGroupLogTag()).addTaggedData(947, this.sbn.getNotification().isGroupSummary() ? 1 : 0).addTaggedData(793, this.getLifespanMs(now)).addTaggedData(795, this.getFreshnessMs(now)).addTaggedData(794, this.getExposureMs(now));
    }

    public LogMaker getLogMaker() {
        return this.getLogMaker(System.currentTimeMillis());
    }

    static final class Light {
        public final int color;
        public final int onMs;
        public final int offMs;

        public Light(int color2, int onMs, int offMs) {
            this.color = color2;
            this.onMs = onMs;
            this.offMs = offMs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Light light = (Light)o;
            if (this.color != light.color) {
                return false;
            }
            if (this.onMs != light.onMs) {
                return false;
            }
            return this.offMs == light.offMs;
        }

        public int hashCode() {
            int result = this.color;
            result = 31 * result + this.onMs;
            result = 31 * result + this.offMs;
            return result;
        }

        public String toString() {
            return "Light{color=" + this.color + ", onMs=" + this.onMs + ", offMs=" + this.offMs + '}';
        }
    }
}

