/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job;

import android.app.ActivityManager;
import android.app.job.IJobCallback;
import android.app.job.IJobService;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobWorkItem;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.WorkSource;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IBatteryStats;
import com.android.server.job.JobCompletedListener;
import com.android.server.job.JobPackageTracker;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.controllers.JobStatus;

public final class JobServiceContext
implements ServiceConnection {
    private static final boolean DEBUG = false;
    private static final String TAG = "JobServiceContext";
    private static final long EXECUTING_TIMESLICE_MILLIS = 600000L;
    private static final long OP_BIND_TIMEOUT_MILLIS = 18000L;
    private static final long OP_TIMEOUT_MILLIS = 8000L;
    private static final String[] VERB_STRINGS = new String[]{"VERB_BINDING", "VERB_STARTING", "VERB_EXECUTING", "VERB_STOPPING", "VERB_FINISHED"};
    static final int VERB_BINDING = 0;
    static final int VERB_STARTING = 1;
    static final int VERB_EXECUTING = 2;
    static final int VERB_STOPPING = 3;
    static final int VERB_FINISHED = 4;
    private static final int MSG_TIMEOUT = 0;
    public static final int NO_PREFERRED_UID = -1;
    private final Handler mCallbackHandler;
    private final JobCompletedListener mCompletedListener;
    private final Context mContext;
    private final Object mLock;
    private final IBatteryStats mBatteryStats;
    private final JobPackageTracker mJobPackageTracker;
    private PowerManager.WakeLock mWakeLock;
    private JobParameters mParams;
    int mVerb;
    private boolean mCancelled;
    private JobStatus mRunningJob;
    private JobCallback mRunningCallback;
    private int mPreferredUid;
    IJobService service;
    @GuardedBy(value="mLock")
    private boolean mAvailable;
    private long mExecutionStartTimeElapsed;
    private long mTimeoutElapsed;
    public String mStoppedReason;
    public long mStoppedTime;

    JobServiceContext(JobSchedulerService service, IBatteryStats batteryStats, JobPackageTracker tracker, Looper looper) {
        this(service.getContext(), service.getLock(), batteryStats, tracker, service, looper);
    }

    JobServiceContext(Context context, Object lock, IBatteryStats batteryStats, JobPackageTracker tracker, JobCompletedListener completedListener, Looper looper) {
        this.mContext = context;
        this.mLock = lock;
        this.mBatteryStats = batteryStats;
        this.mJobPackageTracker = tracker;
        this.mCallbackHandler = new JobServiceHandler(looper);
        this.mCompletedListener = completedListener;
        this.mAvailable = true;
        this.mVerb = 4;
        this.mPreferredUid = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeRunnableJob(JobStatus job) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAvailable) {
                Slog.e(TAG, "Starting new runnable but context is unavailable > Error.");
                return false;
            }
            this.mPreferredUid = -1;
            this.mRunningJob = job;
            this.mRunningCallback = new JobCallback();
            boolean isDeadlineExpired = job.hasDeadlineConstraint() && job.getLatestRunTimeElapsed() < SystemClock.elapsedRealtime();
            Uri[] triggeredUris = null;
            if (job.changedUris != null) {
                triggeredUris = new Uri[job.changedUris.size()];
                job.changedUris.toArray(triggeredUris);
            }
            String[] triggeredAuthorities = null;
            if (job.changedAuthorities != null) {
                triggeredAuthorities = new String[job.changedAuthorities.size()];
                job.changedAuthorities.toArray(triggeredAuthorities);
            }
            JobInfo ji = job.getJob();
            this.mParams = new JobParameters(this.mRunningCallback, job.getJobId(), ji.getExtras(), ji.getTransientExtras(), ji.getClipData(), ji.getClipGrantFlags(), isDeadlineExpired, triggeredUris, triggeredAuthorities);
            this.mExecutionStartTimeElapsed = SystemClock.elapsedRealtime();
            job.clearPersistedUtcTimes();
            this.mVerb = 0;
            this.scheduleOpTimeOutLocked();
            Intent intent = new Intent().setComponent(job.getServiceComponent());
            boolean binding = this.mContext.bindServiceAsUser(intent, this, 5, new UserHandle(job.getUserId()));
            if (!binding) {
                this.mRunningJob = null;
                this.mRunningCallback = null;
                this.mParams = null;
                this.mExecutionStartTimeElapsed = 0L;
                this.mVerb = 4;
                this.removeOpTimeOutLocked();
                return false;
            }
            try {
                this.mBatteryStats.noteJobStart(job.getBatteryName(), job.getSourceUid());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mJobPackageTracker.noteActive(job);
            this.mAvailable = false;
            this.mStoppedReason = null;
            this.mStoppedTime = 0L;
            return true;
        }
    }

    JobStatus getRunningJobLocked() {
        return this.mRunningJob;
    }

    private String getRunningJobNameLocked() {
        return this.mRunningJob != null ? this.mRunningJob.toShortString() : "<null>";
    }

    void cancelExecutingJobLocked(int reason, String debugReason) {
        this.doCancelLocked(reason, debugReason);
    }

    void preemptExecutingJobLocked() {
        this.doCancelLocked(2, "cancelled due to preemption");
    }

    int getPreferredUid() {
        return this.mPreferredUid;
    }

    void clearPreferredUid() {
        this.mPreferredUid = -1;
    }

    long getExecutionStartTimeElapsed() {
        return this.mExecutionStartTimeElapsed;
    }

    long getTimeoutElapsed() {
        return this.mTimeoutElapsed;
    }

    boolean timeoutIfExecutingLocked(String pkgName, int userId, boolean matchJobId, int jobId) {
        JobStatus executing = this.getRunningJobLocked();
        if (!(executing == null || userId != -1 && userId != executing.getUserId() || pkgName != null && !pkgName.equals(executing.getSourcePackageName()) || matchJobId && jobId != executing.getJobId() || this.mVerb != 2)) {
            this.mParams.setStopReason(3);
            this.sendStopMessageLocked("force timeout from shell");
            return true;
        }
        return false;
    }

    void doJobFinished(JobCallback cb, int jobId, boolean reschedule) {
        this.doCallback(cb, reschedule, "app called jobFinished");
    }

    void doAcknowledgeStopMessage(JobCallback cb, int jobId, boolean reschedule) {
        this.doCallback(cb, reschedule, null);
    }

    void doAcknowledgeStartMessage(JobCallback cb, int jobId, boolean ongoing) {
        this.doCallback(cb, ongoing, "finished start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    JobWorkItem doDequeueWork(JobCallback cb, int jobId) {
        long ident;
        block7: {
            JobWorkItem jobWorkItem;
            ident = Binder.clearCallingIdentity();
            try {
                Object object = this.mLock;
                // MONITORENTER : object
                this.assertCallerLocked(cb);
                if (this.mVerb != 3 && this.mVerb != 4) break block7;
                jobWorkItem = null;
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return jobWorkItem;
        }
        JobWorkItem work = this.mRunningJob.dequeueWorkLocked();
        if (work == null && !this.mRunningJob.hasExecutingWorkLocked()) {
            this.doCallbackLocked(false, "last work dequeued");
        }
        JobWorkItem jobWorkItem = work;
        // MONITOREXIT : object
        Binder.restoreCallingIdentity(ident);
        return jobWorkItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doCompleteWork(JobCallback cb, int jobId, int workId) {
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.assertCallerLocked(cb);
                boolean bl = this.mRunningJob.completeWorkLocked(ActivityManager.getService(), workId);
                return bl;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        Object object = this.mLock;
        synchronized (object) {
            JobStatus runningJob = this.mRunningJob;
            if (runningJob == null || !name.equals(runningJob.getServiceComponent())) {
                this.closeAndCleanupJobLocked(true, "connected for different component");
                return;
            }
            this.service = IJobService.Stub.asInterface(service);
            PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
            PowerManager.WakeLock wl = pm.newWakeLock(1, runningJob.getTag());
            wl.setWorkSource(new WorkSource(runningJob.getSourceUid()));
            wl.setReferenceCounted(false);
            wl.acquire();
            if (this.mWakeLock != null) {
                Slog.w(TAG, "Bound new job " + runningJob + " but live wakelock " + this.mWakeLock + " tag=" + this.mWakeLock.getTag());
                this.mWakeLock.release();
            }
            this.mWakeLock = wl;
            this.doServiceBoundLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDisconnected(ComponentName name) {
        Object object = this.mLock;
        synchronized (object) {
            this.closeAndCleanupJobLocked(true, "unexpectedly disconnected");
        }
    }

    private boolean verifyCallerLocked(JobCallback cb) {
        return this.mRunningCallback == cb;
    }

    private void assertCallerLocked(JobCallback cb) {
        if (!this.verifyCallerLocked(cb)) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Caller no longer running");
            if (cb.mStoppedReason != null) {
                sb.append(", last stopped ");
                TimeUtils.formatDuration(SystemClock.elapsedRealtime() - cb.mStoppedTime, sb);
                sb.append(" because: ");
                sb.append(cb.mStoppedReason);
            }
            throw new SecurityException(sb.toString());
        }
    }

    void doServiceBoundLocked() {
        this.removeOpTimeOutLocked();
        this.handleServiceBoundLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCallback(JobCallback cb, boolean reschedule, String reason) {
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                block8: {
                    if (this.verifyCallerLocked(cb)) break block8;
                    return;
                }
                this.doCallbackLocked(reschedule, reason);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    void doCallbackLocked(boolean reschedule, String reason) {
        this.removeOpTimeOutLocked();
        if (this.mVerb == 1) {
            this.handleStartedLocked(reschedule);
        } else if (this.mVerb == 2 || this.mVerb == 3) {
            this.handleFinishedLocked(reschedule, reason);
        }
    }

    void doCancelLocked(int arg1, String debugReason) {
        if (this.mVerb == 4) {
            return;
        }
        this.mParams.setStopReason(arg1);
        if (arg1 == 2) {
            this.mPreferredUid = this.mRunningJob != null ? this.mRunningJob.getUid() : -1;
        }
        this.handleCancelLocked(debugReason);
    }

    private void handleServiceBoundLocked() {
        if (this.mVerb != 0) {
            Slog.e(TAG, "Sending onStartJob for a job that isn't pending. " + VERB_STRINGS[this.mVerb]);
            this.closeAndCleanupJobLocked(false, "started job not pending");
            return;
        }
        if (this.mCancelled) {
            this.closeAndCleanupJobLocked(true, "cancelled while waiting for bind");
            return;
        }
        try {
            this.mVerb = 1;
            this.scheduleOpTimeOutLocked();
            this.service.startJob(this.mParams);
        }
        catch (Exception e) {
            Slog.e(TAG, "Error sending onStart message to '" + this.mRunningJob.getServiceComponent().getShortClassName() + "' ", e);
        }
    }

    private void handleStartedLocked(boolean workOngoing) {
        switch (this.mVerb) {
            case 1: {
                this.mVerb = 2;
                if (!workOngoing) {
                    this.handleFinishedLocked(false, "onStartJob returned false");
                    return;
                }
                if (this.mCancelled) {
                    this.handleCancelLocked(null);
                    return;
                }
                this.scheduleOpTimeOutLocked();
                break;
            }
            default: {
                Slog.e(TAG, "Handling started job but job wasn't starting! Was " + VERB_STRINGS[this.mVerb] + ".");
                return;
            }
        }
    }

    private void handleFinishedLocked(boolean reschedule, String reason) {
        switch (this.mVerb) {
            case 2: 
            case 3: {
                this.closeAndCleanupJobLocked(reschedule, reason);
                break;
            }
            default: {
                Slog.e(TAG, "Got an execution complete message for a job that wasn't beingexecuted. Was " + VERB_STRINGS[this.mVerb] + ".");
            }
        }
    }

    private void handleCancelLocked(String reason) {
        switch (this.mVerb) {
            case 0: 
            case 1: {
                this.mCancelled = true;
                this.applyStoppedReasonLocked(reason);
                break;
            }
            case 2: {
                this.sendStopMessageLocked(reason);
                break;
            }
            case 3: {
                break;
            }
            default: {
                Slog.e(TAG, "Cancelling a job without a valid verb: " + this.mVerb);
            }
        }
    }

    private void handleOpTimeoutLocked() {
        switch (this.mVerb) {
            case 0: {
                Slog.w(TAG, "Time-out while trying to bind " + this.getRunningJobNameLocked() + ", dropping.");
                this.closeAndCleanupJobLocked(false, "timed out while binding");
                break;
            }
            case 1: {
                Slog.w(TAG, "No response from client for onStartJob " + this.getRunningJobNameLocked());
                this.closeAndCleanupJobLocked(false, "timed out while starting");
                break;
            }
            case 3: {
                Slog.w(TAG, "No response from client for onStopJob " + this.getRunningJobNameLocked());
                this.closeAndCleanupJobLocked(true, "timed out while stopping");
                break;
            }
            case 2: {
                Slog.i(TAG, "Client timed out while executing (no jobFinished received), sending onStop: " + this.getRunningJobNameLocked());
                this.mParams.setStopReason(3);
                this.sendStopMessageLocked("timeout while executing");
                break;
            }
            default: {
                Slog.e(TAG, "Handling timeout for an invalid job state: " + this.getRunningJobNameLocked() + ", dropping.");
                this.closeAndCleanupJobLocked(false, "invalid timeout");
            }
        }
    }

    private void sendStopMessageLocked(String reason) {
        this.removeOpTimeOutLocked();
        if (this.mVerb != 2) {
            Slog.e(TAG, "Sending onStopJob for a job that isn't started. " + this.mRunningJob);
            this.closeAndCleanupJobLocked(false, reason);
            return;
        }
        try {
            this.applyStoppedReasonLocked(reason);
            this.mVerb = 3;
            this.scheduleOpTimeOutLocked();
            this.service.stopJob(this.mParams);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Error sending onStopJob to client.", e);
            this.closeAndCleanupJobLocked(true, "host crashed when trying to stop");
        }
    }

    private void closeAndCleanupJobLocked(boolean reschedule, String reason) {
        if (this.mVerb == 4) {
            return;
        }
        this.applyStoppedReasonLocked(reason);
        JobStatus completedJob = this.mRunningJob;
        this.mJobPackageTracker.noteInactive(completedJob, this.mParams.getStopReason());
        try {
            this.mBatteryStats.noteJobFinish(this.mRunningJob.getBatteryName(), this.mRunningJob.getSourceUid(), this.mParams.getStopReason());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.mWakeLock != null) {
            this.mWakeLock.release();
        }
        this.mContext.unbindService(this);
        this.mWakeLock = null;
        this.mRunningJob = null;
        this.mRunningCallback = null;
        this.mParams = null;
        this.mVerb = 4;
        this.mCancelled = false;
        this.service = null;
        this.mAvailable = true;
        this.removeOpTimeOutLocked();
        this.mCompletedListener.onJobCompletedLocked(completedJob, reschedule);
    }

    private void applyStoppedReasonLocked(String reason) {
        if (reason != null && this.mStoppedReason == null) {
            this.mStoppedReason = reason;
            this.mStoppedTime = SystemClock.elapsedRealtime();
            if (this.mRunningCallback != null) {
                this.mRunningCallback.mStoppedReason = this.mStoppedReason;
                this.mRunningCallback.mStoppedTime = this.mStoppedTime;
            }
        }
    }

    private void scheduleOpTimeOutLocked() {
        long timeoutMillis;
        this.removeOpTimeOutLocked();
        switch (this.mVerb) {
            case 2: {
                timeoutMillis = 600000L;
                break;
            }
            case 0: {
                timeoutMillis = 18000L;
                break;
            }
            default: {
                timeoutMillis = 8000L;
            }
        }
        Message m = this.mCallbackHandler.obtainMessage(0, this.mRunningCallback);
        this.mCallbackHandler.sendMessageDelayed(m, timeoutMillis);
        this.mTimeoutElapsed = SystemClock.elapsedRealtime() + timeoutMillis;
    }

    private void removeOpTimeOutLocked() {
        this.mCallbackHandler.removeMessages(0);
    }

    private class JobServiceHandler
    extends Handler {
        JobServiceHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    Object object = JobServiceContext.this.mLock;
                    synchronized (object) {
                        if (message.obj == JobServiceContext.this.mRunningCallback) {
                            JobServiceContext.this.handleOpTimeoutLocked();
                        } else {
                            JobCallback jc = (JobCallback)message.obj;
                            StringBuilder sb = new StringBuilder(128);
                            sb.append("Ignoring timeout of no longer active job");
                            if (jc.mStoppedReason != null) {
                                sb.append(", stopped ");
                                TimeUtils.formatDuration(SystemClock.elapsedRealtime() - jc.mStoppedTime, sb);
                                sb.append(" because: ");
                                sb.append(jc.mStoppedReason);
                            }
                            Slog.w(JobServiceContext.TAG, sb.toString());
                        }
                        break;
                    }
                }
                default: {
                    Slog.e(JobServiceContext.TAG, "Unrecognised message: " + message);
                }
            }
        }
    }

    final class JobCallback
    extends IJobCallback.Stub {
        public String mStoppedReason;
        public long mStoppedTime;

        JobCallback() {
        }

        @Override
        public void acknowledgeStartMessage(int jobId, boolean ongoing) {
            JobServiceContext.this.doAcknowledgeStartMessage(this, jobId, ongoing);
        }

        @Override
        public void acknowledgeStopMessage(int jobId, boolean reschedule) {
            JobServiceContext.this.doAcknowledgeStopMessage(this, jobId, reschedule);
        }

        @Override
        public JobWorkItem dequeueWork(int jobId) {
            return JobServiceContext.this.doDequeueWork(this, jobId);
        }

        @Override
        public boolean completeWork(int jobId, int workId) {
            return JobServiceContext.this.doCompleteWork(this, jobId, workId);
        }

        @Override
        public void jobFinished(int jobId, boolean reschedule) {
            JobServiceContext.this.doJobFinished(this, jobId, reschedule);
        }
    }
}

