/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.content.pm.IPackageManager;
import android.os.Binder;
import android.os.ShellCommand;
import android.os.UserHandle;
import com.android.server.job.JobSchedulerService;
import java.io.PrintWriter;

public final class JobSchedulerShellCommand
extends ShellCommand {
    public static final int CMD_ERR_NO_PACKAGE = -1000;
    public static final int CMD_ERR_NO_JOB = -1001;
    public static final int CMD_ERR_CONSTRAINTS = -1002;
    JobSchedulerService mInternal;
    IPackageManager mPM;

    JobSchedulerShellCommand(JobSchedulerService service) {
        this.mInternal = service;
        this.mPM = AppGlobals.getPackageManager();
    }

    @Override
    public int onCommand(String cmd) {
        PrintWriter pw = this.getOutPrintWriter();
        try {
            switch (cmd != null ? cmd : "") {
                case "run": {
                    return this.runJob(pw);
                }
                case "timeout": {
                    return this.timeout(pw);
                }
                case "monitor-battery": {
                    return this.monitorBattery(pw);
                }
                case "get-battery-seq": {
                    return this.getBatterySeq(pw);
                }
                case "get-battery-charging": {
                    return this.getBatteryCharging(pw);
                }
                case "get-battery-not-low": {
                    return this.getBatteryNotLow(pw);
                }
                case "get-storage-seq": {
                    return this.getStorageSeq(pw);
                }
                case "get-storage-not-low": {
                    return this.getStorageNotLow(pw);
                }
                case "get-job-state": {
                    return this.getJobState(pw);
                }
            }
            return this.handleDefaultCommands(cmd);
        }
        catch (Exception e) {
            pw.println("Exception: " + e);
            return -1;
        }
    }

    private void checkPermission(String operation) throws Exception {
        int uid = Binder.getCallingUid();
        if (uid == 0) {
            return;
        }
        int perm = this.mPM.checkUidPermission("android.permission.CHANGE_APP_IDLE_STATE", uid);
        if (perm != 0) {
            throw new SecurityException("Uid " + uid + " not permitted to " + operation);
        }
    }

    private boolean printError(int errCode, String pkgName, int userId, int jobId) {
        switch (errCode) {
            case -1000: {
                PrintWriter pw = this.getErrPrintWriter();
                pw.print("Package not found: ");
                pw.print(pkgName);
                pw.print(" / user ");
                pw.println(userId);
                return true;
            }
            case -1001: {
                PrintWriter pw = this.getErrPrintWriter();
                pw.print("Could not find job ");
                pw.print(jobId);
                pw.print(" in package ");
                pw.print(pkgName);
                pw.print(" / user ");
                pw.println(userId);
                return true;
            }
            case -1002: {
                PrintWriter pw = this.getErrPrintWriter();
                pw.print("Job ");
                pw.print(jobId);
                pw.print(" in package ");
                pw.print(pkgName);
                pw.print(" / user ");
                pw.print(userId);
                pw.println(" has functional constraints but --force not specified");
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runJob(PrintWriter pw) throws Exception {
        String opt;
        this.checkPermission("force scheduled jobs");
        boolean force = false;
        int userId = 0;
        block14: while ((opt = this.getNextOption()) != null) {
            switch (opt) {
                case "-f": 
                case "--force": {
                    force = true;
                    continue block14;
                }
                case "-u": 
                case "--user": {
                    userId = Integer.parseInt(this.getNextArgRequired());
                    continue block14;
                }
            }
            pw.println("Error: unknown option '" + opt + "'");
            return -1;
        }
        String pkgName = this.getNextArgRequired();
        int jobId = Integer.parseInt(this.getNextArgRequired());
        long ident = Binder.clearCallingIdentity();
        try {
            int ret = this.mInternal.executeRunCommand(pkgName, userId, jobId, force);
            if (this.printError(ret, pkgName, userId, jobId)) {
                int n = ret;
                return n;
            }
            pw.print("Running job");
            if (force) {
                pw.print(" [FORCED]");
            }
            pw.println();
            int n = ret;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int timeout(PrintWriter pw) throws Exception {
        String opt;
        this.checkPermission("force timeout jobs");
        int userId = -1;
        block10: while ((opt = this.getNextOption()) != null) {
            switch (opt) {
                case "-u": 
                case "--user": {
                    userId = UserHandle.parseUserArg(this.getNextArgRequired());
                    continue block10;
                }
            }
            pw.println("Error: unknown option '" + opt + "'");
            return -1;
        }
        if (userId == -2) {
            userId = ActivityManager.getCurrentUser();
        }
        String pkgName = this.getNextArg();
        String jobIdStr = this.getNextArg();
        int jobId = jobIdStr != null ? Integer.parseInt(jobIdStr) : -1;
        long ident = Binder.clearCallingIdentity();
        try {
            int n = this.mInternal.executeTimeoutCommand(pw, pkgName, userId, jobIdStr != null, jobId);
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int monitorBattery(PrintWriter pw) throws Exception {
        boolean enabled;
        this.checkPermission("change battery monitoring");
        String opt = this.getNextArgRequired();
        if ("on".equals(opt)) {
            enabled = true;
        } else if ("off".equals(opt)) {
            enabled = false;
        } else {
            this.getErrPrintWriter().println("Error: unknown option " + opt);
            return 1;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mInternal.setMonitorBattery(enabled);
            if (enabled) {
                pw.println("Battery monitoring enabled");
            } else {
                pw.println("Battery monitoring disabled");
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return 0;
    }

    private int getBatterySeq(PrintWriter pw) {
        int seq = this.mInternal.getBatterySeq();
        pw.println(seq);
        return 0;
    }

    private int getBatteryCharging(PrintWriter pw) {
        boolean val = this.mInternal.getBatteryCharging();
        pw.println(val);
        return 0;
    }

    private int getBatteryNotLow(PrintWriter pw) {
        boolean val = this.mInternal.getBatteryNotLow();
        pw.println(val);
        return 0;
    }

    private int getStorageSeq(PrintWriter pw) {
        int seq = this.mInternal.getStorageSeq();
        pw.println(seq);
        return 0;
    }

    private int getStorageNotLow(PrintWriter pw) {
        boolean val = this.mInternal.getStorageNotLow();
        pw.println(val);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getJobState(PrintWriter pw) throws Exception {
        String opt;
        this.checkPermission("force timeout jobs");
        int userId = 0;
        block10: while ((opt = this.getNextOption()) != null) {
            switch (opt) {
                case "-u": 
                case "--user": {
                    userId = UserHandle.parseUserArg(this.getNextArgRequired());
                    continue block10;
                }
            }
            pw.println("Error: unknown option '" + opt + "'");
            return -1;
        }
        if (userId == -2) {
            userId = ActivityManager.getCurrentUser();
        }
        String pkgName = this.getNextArgRequired();
        String jobIdStr = this.getNextArgRequired();
        int jobId = Integer.parseInt(jobIdStr);
        long ident = Binder.clearCallingIdentity();
        try {
            int ret = this.mInternal.getJobState(pw, pkgName, userId, jobId);
            this.printError(ret, pkgName, userId, jobId);
            int n = ret;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    public void onHelp() {
        PrintWriter pw = this.getOutPrintWriter();
        pw.println("Job scheduler (jobscheduler) commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("  run [-f | --force] [-u | --user USER_ID] PACKAGE JOB_ID");
        pw.println("    Trigger immediate execution of a specific scheduled job.");
        pw.println("    Options:");
        pw.println("      -f or --force: run the job even if technical constraints such as");
        pw.println("         connectivity are not currently met");
        pw.println("      -u or --user: specify which user's job is to be run; the default is");
        pw.println("         the primary or system user");
        pw.println("  timeout [-u | --user USER_ID] [PACKAGE] [JOB_ID]");
        pw.println("    Trigger immediate timeout of currently executing jobs, as if their.");
        pw.println("    execution timeout had expired.");
        pw.println("    Options:");
        pw.println("      -u or --user: specify which user's job is to be run; the default is");
        pw.println("         all users");
        pw.println("  monitor-battery [on|off]");
        pw.println("    Control monitoring of all battery changes.  Off by default.  Turning");
        pw.println("    on makes get-battery-seq useful.");
        pw.println("  get-battery-seq");
        pw.println("    Return the last battery update sequence number that was received.");
        pw.println("  get-battery-charging");
        pw.println("    Return whether the battery is currently considered to be charging.");
        pw.println("  get-battery-not-low");
        pw.println("    Return whether the battery is currently considered to not be low.");
        pw.println("  get-storage-seq");
        pw.println("    Return the last storage update sequence number that was received.");
        pw.println("  get-storage-not-low");
        pw.println("    Return whether storage is currently considered to not be low.");
        pw.println("  get-job-state [-u | --user USER_ID] PACKAGE JOB_ID");
        pw.println("    Return the current state of a job, may be any combination of:");
        pw.println("      pending: currently on the pending list, waiting to be active");
        pw.println("      active: job is actively running");
        pw.println("      user-stopped: job can't run because its user is stopped");
        pw.println("      backing-up: job can't run because app is currently backing up its data");
        pw.println("      no-component: job can't run because its component is not available");
        pw.println("      ready: job is ready to run (all constraints satisfied or bypassed)");
        pw.println("      waiting: if nothing else above is printed, job not ready to run");
        pw.println("    Options:");
        pw.println("      -u or --user: specify which user's job is to be run; the default is");
        pw.println("         the primary or system user");
        pw.println();
    }
}

