/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.Context;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.NetworkRequest;
import android.net.NetworkState;
import android.os.Handler;
import android.os.INetworkManagementService;
import android.os.Messenger;
import android.os.SystemClock;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.WakeupMessage;
import com.android.server.ConnectivityService;
import com.android.server.connectivity.Nat464Xlat;
import com.android.server.connectivity.NetworkMonitor;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public class NetworkAgentInfo
implements Comparable<NetworkAgentInfo> {
    public NetworkInfo networkInfo;
    public final Network network;
    public LinkProperties linkProperties;
    public NetworkCapabilities networkCapabilities;
    public final NetworkMonitor networkMonitor;
    public final NetworkMisc networkMisc;
    public boolean created;
    public boolean everConnected;
    public boolean everValidated;
    public boolean lastValidated;
    public boolean avoidUnvalidated;
    public boolean everCaptivePortalDetected;
    public boolean lastCaptivePortalDetected;
    public static final int EVENT_NETWORK_LINGER_COMPLETE = 1001;
    private final SortedSet<LingerTimer> mLingerTimers = new TreeSet<LingerTimer>();
    private final SparseArray<LingerTimer> mLingerTimerForRequest = new SparseArray();
    private WakeupMessage mLingerMessage;
    private long mLingerExpiryMs;
    private boolean mLingering;
    private int currentScore;
    private static final int UNVALIDATED_SCORE_PENALTY = 40;
    private static final int MAXIMUM_NETWORK_SCORE = 100;
    private final SparseArray<NetworkRequest> mNetworkRequests = new SparseArray();
    private int mNumRequestNetworkRequests = 0;
    private int mNumBackgroundNetworkRequests = 0;
    public final Messenger messenger;
    public final AsyncChannel asyncChannel;
    public Nat464Xlat clatd;
    private static final String TAG = ConnectivityService.class.getSimpleName();
    private static final boolean VDBG = false;
    private final ConnectivityService mConnService;
    private final Context mContext;
    private final Handler mHandler;
    private static final boolean ADD = true;
    private static final boolean REMOVE = false;

    public NetworkAgentInfo(Messenger messenger, AsyncChannel ac, Network net, NetworkInfo info, LinkProperties lp, NetworkCapabilities nc, int score, Context context, Handler handler, NetworkMisc misc, NetworkRequest defaultRequest, ConnectivityService connService) {
        this.messenger = messenger;
        this.asyncChannel = ac;
        this.network = net;
        this.networkInfo = info;
        this.linkProperties = lp;
        this.networkCapabilities = nc;
        this.currentScore = score;
        this.mConnService = connService;
        this.mContext = context;
        this.mHandler = handler;
        this.networkMonitor = this.mConnService.createNetworkMonitor(context, handler, this, defaultRequest);
        this.networkMisc = misc;
    }

    public ConnectivityService connService() {
        return this.mConnService;
    }

    public Handler handler() {
        return this.mHandler;
    }

    private void updateRequestCounts(boolean add, NetworkRequest request) {
        int delta = add ? 1 : -1;
        switch (request.type) {
            case REQUEST: 
            case TRACK_DEFAULT: {
                this.mNumRequestNetworkRequests += delta;
                break;
            }
            case BACKGROUND_REQUEST: {
                this.mNumRequestNetworkRequests += delta;
                this.mNumBackgroundNetworkRequests += delta;
                break;
            }
            case LISTEN: {
                break;
            }
            default: {
                Log.wtf(TAG, "Unhandled request type " + (Object)((Object)request.type));
            }
        }
    }

    public boolean addRequest(NetworkRequest networkRequest) {
        NetworkRequest existing = this.mNetworkRequests.get(networkRequest.requestId);
        if (existing == networkRequest) {
            return false;
        }
        if (existing != null) {
            Log.wtf(TAG, String.format("Duplicate requestId for %s and %s on %s", networkRequest, existing, this.name()));
            this.updateRequestCounts(false, existing);
        }
        this.mNetworkRequests.put(networkRequest.requestId, networkRequest);
        this.updateRequestCounts(true, networkRequest);
        return true;
    }

    public void removeRequest(int requestId) {
        NetworkRequest existing = this.mNetworkRequests.get(requestId);
        if (existing == null) {
            return;
        }
        this.updateRequestCounts(false, existing);
        this.mNetworkRequests.remove(requestId);
        if (existing.isRequest()) {
            this.unlingerRequest(existing);
        }
    }

    public boolean isSatisfyingRequest(int id2) {
        return this.mNetworkRequests.get(id2) != null;
    }

    public NetworkRequest requestAt(int index) {
        return this.mNetworkRequests.valueAt(index);
    }

    public int numRequestNetworkRequests() {
        return this.mNumRequestNetworkRequests;
    }

    public int numBackgroundNetworkRequests() {
        return this.mNumBackgroundNetworkRequests;
    }

    public int numForegroundNetworkRequests() {
        return this.mNumRequestNetworkRequests - this.mNumBackgroundNetworkRequests;
    }

    public int numNetworkRequests() {
        return this.mNetworkRequests.size();
    }

    public boolean isBackgroundNetwork() {
        return !this.isVPN() && this.numForegroundNetworkRequests() == 0 && this.mNumBackgroundNetworkRequests > 0;
    }

    public boolean satisfies(NetworkRequest request) {
        return this.created && request.networkCapabilities.satisfiedByNetworkCapabilities(this.networkCapabilities);
    }

    public boolean satisfiesImmutableCapabilitiesOf(NetworkRequest request) {
        return this.created && request.networkCapabilities.satisfiedByImmutableNetworkCapabilities(this.networkCapabilities);
    }

    public boolean isVPN() {
        return this.networkCapabilities.hasTransport(4);
    }

    private int getCurrentScore(boolean pretendValidated) {
        if (this.networkMisc.explicitlySelected && (this.networkMisc.acceptUnvalidated || pretendValidated)) {
            return 100;
        }
        int score = this.currentScore;
        if (!(this.lastValidated || pretendValidated || this.ignoreWifiUnvalidationPenalty())) {
            score -= 40;
        }
        if (score < 0) {
            score = 0;
        }
        return score;
    }

    private boolean ignoreWifiUnvalidationPenalty() {
        boolean isWifi = this.networkCapabilities.hasTransport(1) && this.networkCapabilities.hasCapability(12);
        boolean avoidBadWifi = this.mConnService.avoidBadWifi() || this.avoidUnvalidated;
        return isWifi && !avoidBadWifi && this.everValidated;
    }

    public int getCurrentScore() {
        return this.getCurrentScore(false);
    }

    public int getCurrentScoreAsValidated() {
        return this.getCurrentScore(true);
    }

    public void setCurrentScore(int newScore) {
        this.currentScore = newScore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkState getNetworkState() {
        NetworkAgentInfo networkAgentInfo = this;
        synchronized (networkAgentInfo) {
            String subscriberId = this.networkMisc != null ? this.networkMisc.subscriberId : null;
            return new NetworkState(new NetworkInfo(this.networkInfo), new LinkProperties(this.linkProperties), new NetworkCapabilities(this.networkCapabilities), this.network, subscriberId, null);
        }
    }

    public void lingerRequest(NetworkRequest request, long now, long duration) {
        if (this.mLingerTimerForRequest.get(request.requestId) != null) {
            Log.wtf(TAG, this.name() + ": request " + request.requestId + " already lingered");
        }
        long expiryMs = now + duration;
        LingerTimer timer = new LingerTimer(request, expiryMs);
        this.mLingerTimers.add(timer);
        this.mLingerTimerForRequest.put(request.requestId, timer);
    }

    public boolean unlingerRequest(NetworkRequest request) {
        LingerTimer timer = this.mLingerTimerForRequest.get(request.requestId);
        if (timer != null) {
            this.mLingerTimers.remove(timer);
            this.mLingerTimerForRequest.remove(request.requestId);
            return true;
        }
        return false;
    }

    public long getLingerExpiry() {
        return this.mLingerExpiryMs;
    }

    public void updateLingerTimer() {
        long newExpiry;
        long l = newExpiry = this.mLingerTimers.isEmpty() ? 0L : this.mLingerTimers.last().expiryMs;
        if (newExpiry == this.mLingerExpiryMs) {
            return;
        }
        if (this.mLingerMessage != null) {
            this.mLingerMessage.cancel();
            this.mLingerMessage = null;
        }
        if (newExpiry > 0L) {
            this.mLingerMessage = this.mConnService.makeWakeupMessage(this.mContext, this.mHandler, "NETWORK_LINGER_COMPLETE." + this.network.netId, 1001, this);
            this.mLingerMessage.schedule(newExpiry);
        }
        this.mLingerExpiryMs = newExpiry;
    }

    public void linger() {
        this.mLingering = true;
    }

    public void unlinger() {
        this.mLingering = false;
    }

    public boolean isLingering() {
        return this.mLingering;
    }

    public void clearLingerState() {
        if (this.mLingerMessage != null) {
            this.mLingerMessage.cancel();
            this.mLingerMessage = null;
        }
        this.mLingerTimers.clear();
        this.mLingerTimerForRequest.clear();
        this.updateLingerTimer();
        this.mLingering = false;
    }

    public void dumpLingerTimers(PrintWriter pw) {
        for (LingerTimer timer : this.mLingerTimers) {
            pw.println(timer);
        }
    }

    public void updateClat(INetworkManagementService netd) {
        if (Nat464Xlat.requiresClat(this)) {
            this.maybeStartClat(netd);
        } else {
            this.maybeStopClat();
        }
    }

    public void maybeStartClat(INetworkManagementService netd) {
        if (this.clatd != null && this.clatd.isStarted()) {
            return;
        }
        this.clatd = new Nat464Xlat(netd, this);
        this.clatd.start();
    }

    public void maybeStopClat() {
        if (this.clatd == null) {
            return;
        }
        this.clatd.stop();
        this.clatd = null;
    }

    public String toString() {
        return "NetworkAgentInfo{ ni{" + this.networkInfo + "}  " + "network{" + this.network + "}  nethandle{" + this.network.getNetworkHandle() + "}  " + "lp{" + this.linkProperties + "}  " + "nc{" + this.networkCapabilities + "}  Score{" + this.getCurrentScore() + "}  " + "everValidated{" + this.everValidated + "}  lastValidated{" + this.lastValidated + "}  " + "created{" + this.created + "} lingering{" + this.isLingering() + "} " + "explicitlySelected{" + this.networkMisc.explicitlySelected + "} " + "acceptUnvalidated{" + this.networkMisc.acceptUnvalidated + "} " + "everCaptivePortalDetected{" + this.everCaptivePortalDetected + "} " + "lastCaptivePortalDetected{" + this.lastCaptivePortalDetected + "} " + "clat{" + this.clatd + "} " + "}";
    }

    public String name() {
        return "NetworkAgentInfo [" + this.networkInfo.getTypeName() + " (" + this.networkInfo.getSubtypeName() + ") - " + Objects.toString(this.network) + "]";
    }

    @Override
    public int compareTo(NetworkAgentInfo other) {
        return other.getCurrentScore() - this.getCurrentScore();
    }

    public static class LingerTimer
    implements Comparable<LingerTimer> {
        public final NetworkRequest request;
        public final long expiryMs;

        public LingerTimer(NetworkRequest request, long expiryMs) {
            this.request = request;
            this.expiryMs = expiryMs;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LingerTimer)) {
                return false;
            }
            LingerTimer other = (LingerTimer)o;
            return this.request.requestId == other.request.requestId && this.expiryMs == other.expiryMs;
        }

        public int hashCode() {
            return Objects.hash(this.request.requestId, this.expiryMs);
        }

        @Override
        public int compareTo(LingerTimer other) {
            return this.expiryMs != other.expiryMs ? Long.compare(this.expiryMs, other.expiryMs) : Integer.compare(this.request.requestId, other.request.requestId);
        }

        public String toString() {
            return String.format("%s, expires %dms", this.request.toString(), this.expiryMs - SystemClock.elapsedRealtime());
        }
    }
}

