/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.INetdEventCallback;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.metrics.ConnectStats;
import android.net.metrics.DnsEvent;
import android.net.metrics.INetdEventListener;
import android.net.metrics.WakeupEvent;
import android.net.metrics.WakeupStats;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.BitUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.TokenBucket;
import com.android.server.connectivity.IpConnectivityEventBuilder;
import com.android.server.connectivity.metrics.nano.IpConnectivityLogClass;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.function.Function;

public class NetdEventListenerService
extends INetdEventListener.Stub {
    public static final String SERVICE_NAME = "netd_listener";
    private static final String TAG = NetdEventListenerService.class.getSimpleName();
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private static final int INITIAL_DNS_BATCH_SIZE = 100;
    private static final int CONNECT_LATENCY_BURST_LIMIT = 5000;
    private static final int CONNECT_LATENCY_FILL_RATE = 15000;
    private static final int CONNECT_LATENCY_MAXIMUM_RECORDS = 20000;
    static final int WAKEUP_EVENT_BUFFER_LENGTH = 1024;
    static final String WAKEUP_EVENT_IFACE_PREFIX = "iface:";
    @GuardedBy(value="this")
    private final SparseArray<DnsEvent> mDnsEvents = new SparseArray();
    @GuardedBy(value="this")
    private final SparseArray<ConnectStats> mConnectEvents = new SparseArray();
    @GuardedBy(value="this")
    private final ArrayMap<String, WakeupStats> mWakeupStats = new ArrayMap();
    @GuardedBy(value="this")
    private final WakeupEvent[] mWakeupEvents = new WakeupEvent[1024];
    @GuardedBy(value="this")
    private long mWakeupEventCursor = 0L;
    private final ConnectivityManager mCm;
    @GuardedBy(value="this")
    private final TokenBucket mConnectTb = new TokenBucket(15000, 5000);
    @GuardedBy(value="this")
    private INetdEventCallback mNetdEventCallback;

    public synchronized boolean registerNetdEventCallback(INetdEventCallback callback) {
        this.mNetdEventCallback = callback;
        return true;
    }

    public synchronized boolean unregisterNetdEventCallback() {
        this.mNetdEventCallback = null;
        return true;
    }

    public NetdEventListenerService(Context context) {
        this(context.getSystemService(ConnectivityManager.class));
    }

    public NetdEventListenerService(ConnectivityManager cm) {
        this.mCm = cm;
    }

    @Override
    public synchronized void onDnsEvent(int netId, int eventType, int returnCode, int latencyMs, String hostname, String[] ipAddresses, int ipAddressesCount, int uid) throws RemoteException {
        NetdEventListenerService.maybeVerboseLog("onDnsEvent(%d, %d, %d, %dms)", netId, eventType, returnCode, latencyMs);
        DnsEvent dnsEvent = this.mDnsEvents.get(netId);
        if (dnsEvent == null) {
            dnsEvent = this.makeDnsEvent(netId);
            this.mDnsEvents.put(netId, dnsEvent);
        }
        dnsEvent.addResult((byte)eventType, (byte)returnCode, latencyMs);
        if (this.mNetdEventCallback != null) {
            long timestamp = System.currentTimeMillis();
            this.mNetdEventCallback.onDnsEvent(hostname, ipAddresses, ipAddressesCount, timestamp, uid);
        }
    }

    @Override
    public synchronized void onConnectEvent(int netId, int error, int latencyMs, String ipAddr, int port, int uid) throws RemoteException {
        NetdEventListenerService.maybeVerboseLog("onConnectEvent(%d, %d, %dms)", netId, error, latencyMs);
        ConnectStats connectStats = this.mConnectEvents.get(netId);
        if (connectStats == null) {
            connectStats = this.makeConnectStats(netId);
            this.mConnectEvents.put(netId, connectStats);
        }
        connectStats.addEvent(error, latencyMs, ipAddr);
        if (this.mNetdEventCallback != null) {
            this.mNetdEventCallback.onConnectEvent(ipAddr, port, System.currentTimeMillis(), uid);
        }
    }

    @Override
    public synchronized void onWakeupEvent(String prefix, int uid, int gid, long timestampNs) {
        NetdEventListenerService.maybeVerboseLog("onWakeupEvent(%s, %d, %d, %sns)", prefix, uid, gid, timestampNs);
        String iface = prefix.replaceFirst(WAKEUP_EVENT_IFACE_PREFIX, "");
        long timestampMs = timestampNs > 0L ? timestampNs / 1000000L : System.currentTimeMillis();
        this.addWakeupEvent(iface, timestampMs, uid);
    }

    @GuardedBy(value="this")
    private void addWakeupEvent(String iface, long timestampMs, int uid) {
        int index = NetdEventListenerService.wakeupEventIndex(this.mWakeupEventCursor);
        ++this.mWakeupEventCursor;
        WakeupEvent event = new WakeupEvent();
        event.iface = iface;
        event.timestampMs = timestampMs;
        event.uid = uid;
        this.mWakeupEvents[index] = event;
        WakeupStats stats = this.mWakeupStats.get(iface);
        if (stats == null) {
            stats = new WakeupStats(iface);
            this.mWakeupStats.put(iface, stats);
        }
        stats.countEvent(event);
    }

    @GuardedBy(value="this")
    private WakeupEvent[] getWakeupEvents() {
        int length = (int)Math.min(this.mWakeupEventCursor, (long)this.mWakeupEvents.length);
        WakeupEvent[] out = new WakeupEvent[length];
        long inCursor = this.mWakeupEventCursor - 1L;
        int outIdx = out.length - 1;
        while (outIdx >= 0) {
            out[outIdx--] = this.mWakeupEvents[NetdEventListenerService.wakeupEventIndex(inCursor--)];
        }
        return out;
    }

    private static int wakeupEventIndex(long cursor) {
        return (int)Math.abs(cursor % 1024L);
    }

    public synchronized void flushStatistics(List<IpConnectivityLogClass.IpConnectivityEvent> events) {
        NetdEventListenerService.flushProtos(events, this.mConnectEvents, IpConnectivityEventBuilder::toProto);
        NetdEventListenerService.flushProtos(events, this.mDnsEvents, IpConnectivityEventBuilder::toProto);
        for (int i = 0; i < this.mWakeupStats.size(); ++i) {
            events.add(IpConnectivityEventBuilder.toProto(this.mWakeupStats.valueAt(i)));
        }
        this.mWakeupStats.clear();
    }

    public synchronized void dump(PrintWriter writer) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println(TAG + ":");
        pw.increaseIndent();
        this.list(pw);
        pw.decreaseIndent();
    }

    public synchronized void list(PrintWriter pw) {
        NetdEventListenerService.listEvents(pw, this.mConnectEvents, x -> x, "\n");
        NetdEventListenerService.listEvents(pw, this.mDnsEvents, x -> x, "\n");
        for (int i = 0; i < this.mWakeupStats.size(); ++i) {
            pw.println(this.mWakeupStats.valueAt(i));
        }
        for (WakeupEvent wakeup : this.getWakeupEvents()) {
            pw.println(wakeup);
        }
    }

    public synchronized void listAsProtos(PrintWriter pw) {
        NetdEventListenerService.listEvents(pw, this.mConnectEvents, IpConnectivityEventBuilder::toProto, "");
        NetdEventListenerService.listEvents(pw, this.mDnsEvents, IpConnectivityEventBuilder::toProto, "");
        for (int i = 0; i < this.mWakeupStats.size(); ++i) {
            pw.print(IpConnectivityEventBuilder.toProto(this.mWakeupStats.valueAt(i)));
        }
    }

    private static <T> void flushProtos(List<IpConnectivityLogClass.IpConnectivityEvent> out, SparseArray<T> in, Function<T, IpConnectivityLogClass.IpConnectivityEvent> mapper) {
        for (int i = 0; i < in.size(); ++i) {
            out.add(mapper.apply(in.valueAt(i)));
        }
        in.clear();
    }

    private static <T> void listEvents(PrintWriter pw, SparseArray<T> events, Function<T, Object> mapper, String separator) {
        for (int i = 0; i < events.size(); ++i) {
            pw.print(mapper.apply(events.valueAt(i)));
            pw.print(separator);
        }
    }

    private ConnectStats makeConnectStats(int netId) {
        long transports = this.getTransports(netId);
        return new ConnectStats(netId, transports, this.mConnectTb, 20000);
    }

    private DnsEvent makeDnsEvent(int netId) {
        long transports = this.getTransports(netId);
        return new DnsEvent(netId, transports, 100);
    }

    private long getTransports(int netId) {
        NetworkCapabilities nc = this.mCm.getNetworkCapabilities(new Network(netId));
        if (nc == null) {
            return 0L;
        }
        return BitUtils.packBits(nc.getTransportTypes());
    }

    private static void maybeLog(String s, Object ... args) {
    }

    private static void maybeVerboseLog(String s, Object ... args) {
    }
}

