/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Slog;
import com.android.server.backup.RefactoredBackupManagerService;
import com.android.server.backup.internal.PerformInitializeTask;

public class RunInitializeReceiver
extends BroadcastReceiver {
    private RefactoredBackupManagerService backupManagerService;

    public RunInitializeReceiver(RefactoredBackupManagerService backupManagerService) {
        this.backupManagerService = backupManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceive(Context context, Intent intent) {
        if ("android.app.backup.intent.INIT".equals(intent.getAction())) {
            Object object = this.backupManagerService.getQueueLock();
            synchronized (object) {
                Slog.v("BackupManagerService", "Running a device init");
                String[] pendingInits = (String[])this.backupManagerService.getPendingInits().toArray();
                this.backupManagerService.clearPendingInits();
                PerformInitializeTask initTask = new PerformInitializeTask(this.backupManagerService, pendingInits, null);
                this.backupManagerService.getWakelock().acquire();
                this.backupManagerService.getBackupHandler().post(initTask);
            }
        }
    }
}

