/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.internal;

import android.content.pm.PackageInfo;
import android.util.Slog;
import com.android.internal.backup.IBackupTransport;
import com.android.server.backup.RefactoredBackupManagerService;
import java.io.File;

public class PerformClearTask
implements Runnable {
    private RefactoredBackupManagerService backupManagerService;
    IBackupTransport mTransport;
    PackageInfo mPackage;

    PerformClearTask(RefactoredBackupManagerService backupManagerService, IBackupTransport transport, PackageInfo packageInfo) {
        this.backupManagerService = backupManagerService;
        this.mTransport = transport;
        this.mPackage = packageInfo;
    }

    @Override
    public void run() {
        try {
            File stateDir = new File(this.backupManagerService.getBaseStateDir(), this.mTransport.transportDirName());
            File stateFile = new File(stateDir, this.mPackage.packageName);
            stateFile.delete();
            this.mTransport.clearBackupData(this.mPackage);
        }
        catch (Exception e) {
            Slog.e("BackupManagerService", "Transport threw clearing data for " + this.mPackage + ": " + e.getMessage());
        }
        finally {
            try {
                this.mTransport.finishBackup();
            }
            catch (Exception e) {
                Slog.e("BackupManagerService", "Unable to mark clear operation finished: " + e.getMessage());
            }
            this.backupManagerService.getWakelock().release();
        }
    }
}

