/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.internal;

import android.app.backup.RestoreSet;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.EventLog;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.backup.IBackupTransport;
import com.android.server.backup.BackupRestoreTask;
import com.android.server.backup.DataChangedJournal;
import com.android.server.backup.RefactoredBackupManagerService;
import com.android.server.backup.fullbackup.PerformAdbBackupTask;
import com.android.server.backup.fullbackup.PerformFullTransportBackupTask;
import com.android.server.backup.internal.BackupRequest;
import com.android.server.backup.internal.PerformBackupTask;
import com.android.server.backup.internal.PerformClearTask;
import com.android.server.backup.params.AdbBackupParams;
import com.android.server.backup.params.AdbParams;
import com.android.server.backup.params.AdbRestoreParams;
import com.android.server.backup.params.BackupParams;
import com.android.server.backup.params.ClearParams;
import com.android.server.backup.params.ClearRetryParams;
import com.android.server.backup.params.RestoreGetSetsParams;
import com.android.server.backup.params.RestoreParams;
import com.android.server.backup.restore.ActiveRestoreSession;
import com.android.server.backup.restore.PerformAdbRestoreTask;
import com.android.server.backup.restore.PerformUnifiedRestoreTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Queue;

public class BackupHandler
extends Handler {
    public static final int MSG_RUN_BACKUP = 1;
    public static final int MSG_RUN_ADB_BACKUP = 2;
    public static final int MSG_RUN_RESTORE = 3;
    public static final int MSG_RUN_CLEAR = 4;
    public static final int MSG_RUN_GET_RESTORE_SETS = 6;
    public static final int MSG_RESTORE_SESSION_TIMEOUT = 8;
    public static final int MSG_FULL_CONFIRMATION_TIMEOUT = 9;
    public static final int MSG_RUN_ADB_RESTORE = 10;
    public static final int MSG_RETRY_INIT = 11;
    public static final int MSG_RETRY_CLEAR = 12;
    public static final int MSG_WIDGET_BROADCAST = 13;
    public static final int MSG_RUN_FULL_TRANSPORT_BACKUP = 14;
    public static final int MSG_REQUEST_BACKUP = 15;
    public static final int MSG_SCHEDULE_BACKUP_PACKAGE = 16;
    public static final int MSG_BACKUP_OPERATION_TIMEOUT = 17;
    public static final int MSG_RESTORE_OPERATION_TIMEOUT = 18;
    public static final int MSG_BACKUP_RESTORE_STEP = 20;
    public static final int MSG_OP_COMPLETE = 21;
    private RefactoredBackupManagerService backupManagerService;

    public BackupHandler(RefactoredBackupManagerService backupManagerService, Looper looper) {
        super(looper);
        this.backupManagerService = backupManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.backupManagerService.setLastBackupPass(System.currentTimeMillis());
                IBackupTransport transport = this.backupManagerService.getTransportManager().getCurrentTransportBinder();
                if (transport == null) {
                    Slog.v("BackupManagerService", "Backup requested but no transport available");
                    Object object = this.backupManagerService.getQueueLock();
                    synchronized (object) {
                        this.backupManagerService.setBackupRunning(false);
                    }
                    this.backupManagerService.getWakelock().release();
                    break;
                }
                ArrayList<BackupRequest> queue = new ArrayList<BackupRequest>();
                DataChangedJournal oldJournal = this.backupManagerService.getJournal();
                Object object = this.backupManagerService.getQueueLock();
                synchronized (object) {
                    if (this.backupManagerService.getPendingBackups().size() > 0) {
                        for (BackupRequest b : this.backupManagerService.getPendingBackups().values()) {
                            queue.add(b);
                        }
                        Slog.v("BackupManagerService", "clearing pending backups");
                        this.backupManagerService.getPendingBackups().clear();
                        this.backupManagerService.setJournal(null);
                    }
                }
                boolean staged = true;
                if (queue.size() > 0) {
                    try {
                        String dirName = transport.transportDirName();
                        PerformBackupTask pbt = new PerformBackupTask(this.backupManagerService, transport, dirName, queue, oldJournal, null, null, Collections.emptyList(), false, false);
                        Message pbtMessage = this.obtainMessage(20, pbt);
                        this.sendMessage(pbtMessage);
                    }
                    catch (Exception e) {
                        Slog.e("BackupManagerService", "Transport became unavailable attempting backup or error initializing backup task", e);
                        staged = false;
                    }
                } else {
                    Slog.v("BackupManagerService", "Backup requested but nothing pending");
                    staged = false;
                }
                if (staged) break;
                Object object2 = this.backupManagerService.getQueueLock();
                synchronized (object2) {
                    this.backupManagerService.setBackupRunning(false);
                }
                this.backupManagerService.getWakelock().release();
                break;
            }
            case 20: {
                try {
                    BackupRestoreTask task = (BackupRestoreTask)msg.obj;
                    task.execute();
                }
                catch (ClassCastException e) {
                    Slog.e("BackupManagerService", "Invalid backup task in flight, obj=" + msg.obj);
                }
                break;
            }
            case 21: {
                try {
                    Pair taskWithResult = (Pair)msg.obj;
                    ((BackupRestoreTask)taskWithResult.first).operationComplete((Long)taskWithResult.second);
                }
                catch (ClassCastException e) {
                    Slog.e("BackupManagerService", "Invalid completion in flight, obj=" + msg.obj);
                }
                break;
            }
            case 2: {
                AdbBackupParams params = (AdbBackupParams)msg.obj;
                PerformAdbBackupTask task = new PerformAdbBackupTask(this.backupManagerService, params.fd, params.observer, params.includeApks, params.includeObbs, params.includeShared, params.doWidgets, params.curPassword, params.encryptPassword, params.allApps, params.includeSystem, params.doCompress, params.includeKeyValue, params.packages, params.latch);
                new Thread((Runnable)task, "adb-backup").start();
                break;
            }
            case 14: {
                PerformFullTransportBackupTask task = (PerformFullTransportBackupTask)msg.obj;
                new Thread((Runnable)task, "transport-backup").start();
                break;
            }
            case 3: {
                RestoreParams params = (RestoreParams)msg.obj;
                Slog.d("BackupManagerService", "MSG_RUN_RESTORE observer=" + params.observer);
                PerformUnifiedRestoreTask task = new PerformUnifiedRestoreTask(this.backupManagerService, params.transport, params.observer, params.monitor, params.token, params.pkgInfo, params.pmToken, params.isSystemRestore, params.filterSet);
                Queue<PerformUnifiedRestoreTask> oldJournal = this.backupManagerService.getPendingRestores();
                synchronized (oldJournal) {
                    if (this.backupManagerService.isRestoreInProgress()) {
                        Slog.d("BackupManagerService", "Restore in progress, queueing.");
                        this.backupManagerService.getPendingRestores().add(task);
                    } else {
                        Slog.d("BackupManagerService", "Starting restore.");
                        this.backupManagerService.setRestoreInProgress(true);
                        Message restoreMsg = this.obtainMessage(20, task);
                        this.sendMessage(restoreMsg);
                    }
                    break;
                }
            }
            case 10: {
                AdbRestoreParams params = (AdbRestoreParams)msg.obj;
                PerformAdbRestoreTask task = new PerformAdbRestoreTask(this.backupManagerService, params.fd, params.curPassword, params.encryptPassword, params.observer, params.latch);
                new Thread((Runnable)task, "adb-restore").start();
                break;
            }
            case 4: {
                ClearParams params = (ClearParams)msg.obj;
                new PerformClearTask(this.backupManagerService, params.transport, params.packageInfo).run();
                break;
            }
            case 12: {
                ClearRetryParams params = (ClearRetryParams)msg.obj;
                this.backupManagerService.clearBackupData(params.transportName, params.packageName);
                break;
            }
            case 11: {
                Object params = this.backupManagerService.getQueueLock();
                synchronized (params) {
                    this.backupManagerService.recordInitPendingLocked(msg.arg1 != 0, (String)msg.obj);
                    this.backupManagerService.getAlarmManager().set(0, System.currentTimeMillis(), this.backupManagerService.getRunInitIntent());
                    break;
                }
            }
            case 6: {
                RestoreSet[] sets = null;
                RestoreGetSetsParams params = (RestoreGetSetsParams)msg.obj;
                try {
                    sets = params.transport.getAvailableRestoreSets();
                    ActiveRestoreSession oldJournal = params.session;
                    synchronized (oldJournal) {
                        params.session.mRestoreSets = sets;
                    }
                    if (sets != null) break;
                    EventLog.writeEvent(2831, new Object[0]);
                    break;
                }
                catch (Exception e) {
                    Slog.e("BackupManagerService", "Error from transport getting set list: " + e.getMessage());
                    break;
                }
                finally {
                    if (params.observer != null) {
                        try {
                            params.observer.restoreSetsAvailable(sets);
                        }
                        catch (RemoteException re) {
                            Slog.e("BackupManagerService", "Unable to report listing to observer");
                        }
                        catch (Exception e) {
                            Slog.e("BackupManagerService", "Restore observer threw: " + e.getMessage());
                        }
                    }
                    this.removeMessages(8);
                    this.sendEmptyMessageDelayed(8, 60000L);
                    this.backupManagerService.getWakelock().release();
                }
            }
            case 17: 
            case 18: {
                Slog.d("BackupManagerService", "Timeout message received for token=" + Integer.toHexString(msg.arg1));
                this.backupManagerService.handleCancel(msg.arg1, false);
                break;
            }
            case 8: {
                RefactoredBackupManagerService sets = this.backupManagerService;
                synchronized (sets) {
                    if (this.backupManagerService.getActiveRestoreSession() != null) {
                        Slog.w("BackupManagerService", "Restore session timed out; aborting");
                        this.backupManagerService.getActiveRestoreSession().markTimedOut();
                        ActiveRestoreSession activeRestoreSession = this.backupManagerService.getActiveRestoreSession();
                        activeRestoreSession.getClass();
                        this.post(activeRestoreSession.new ActiveRestoreSession.EndRestoreRunnable(this.backupManagerService, this.backupManagerService.getActiveRestoreSession()));
                    }
                    break;
                }
            }
            case 9: {
                SparseArray<AdbParams> sets = this.backupManagerService.getAdbBackupRestoreConfirmations();
                synchronized (sets) {
                    AdbParams params = this.backupManagerService.getAdbBackupRestoreConfirmations().get(msg.arg1);
                    if (params != null) {
                        Slog.i("BackupManagerService", "Full backup/restore timed out waiting for user confirmation");
                        this.backupManagerService.signalAdbBackupRestoreCompletion(params);
                        this.backupManagerService.getAdbBackupRestoreConfirmations().delete(msg.arg1);
                        if (params.observer != null) {
                            try {
                                params.observer.onTimeout();
                            }
                            catch (RemoteException e) {}
                        }
                    } else {
                        Slog.d("BackupManagerService", "couldn't find params for token " + msg.arg1);
                    }
                    break;
                }
            }
            case 13: {
                Intent intent = (Intent)msg.obj;
                this.backupManagerService.getContext().sendBroadcastAsUser(intent, UserHandle.SYSTEM);
                break;
            }
            case 15: {
                BackupParams params = (BackupParams)msg.obj;
                ArrayList<BackupRequest> kvQueue = new ArrayList<BackupRequest>();
                for (String packageName : params.kvPackages) {
                    kvQueue.add(new BackupRequest(packageName));
                }
                this.backupManagerService.setBackupRunning(true);
                this.backupManagerService.getWakelock().acquire();
                PerformBackupTask pbt = new PerformBackupTask(this.backupManagerService, params.transport, params.dirName, kvQueue, null, params.observer, params.monitor, params.fullPackages, true, params.nonIncrementalBackup);
                Message pbtMessage = this.obtainMessage(20, pbt);
                this.sendMessage(pbtMessage);
                break;
            }
            case 16: {
                String pkgName = (String)msg.obj;
                this.backupManagerService.dataChangedImpl(pkgName);
                break;
            }
        }
    }
}

