/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.backup.IBackupManager;
import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IBackupObserver;
import android.app.backup.IFullBackupRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.ISelectBackupTransportCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Environment;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Slog;
import com.android.internal.util.DumpUtils;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.BackupManagerServiceInterface;
import com.android.server.backup.FullBackupJob;
import com.android.server.backup.RefactoredBackupManagerService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;

public class Trampoline
extends IBackupManager.Stub {
    static final String TAG = "BackupManagerService";
    static final boolean DEBUG_TRAMPOLINE = false;
    static final String BACKUP_SUPPRESS_FILENAME = "backup-suppress";
    static final String BACKUP_DISABLE_PROPERTY = "ro.backup.disable";
    final Context mContext;
    final File mSuppressFile;
    final boolean mGlobalDisable;
    volatile BackupManagerServiceInterface mService;

    public Trampoline(Context context) {
        this.mContext = context;
        this.mGlobalDisable = this.isBackupDisabled();
        this.mSuppressFile = this.getSuppressFile();
        this.mSuppressFile.getParentFile().mkdirs();
    }

    protected BackupManagerServiceInterface createService() {
        if (this.isRefactoredServiceEnabled()) {
            Slog.i(TAG, "Instantiating RefactoredBackupManagerService");
            return this.createRefactoredBackupManagerService();
        }
        Slog.i(TAG, "Instantiating BackupManagerService");
        return this.createBackupManagerService();
    }

    protected boolean isBackupDisabled() {
        return SystemProperties.getBoolean(BACKUP_DISABLE_PROPERTY, false);
    }

    protected boolean isRefactoredServiceEnabled() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "backup_refactored_service_disabled", 1) == 0;
    }

    protected int binderGetCallingUid() {
        return Binder.getCallingUid();
    }

    protected File getSuppressFile() {
        return new File(new File(Environment.getDataDirectory(), "backup"), BACKUP_SUPPRESS_FILENAME);
    }

    protected BackupManagerServiceInterface createRefactoredBackupManagerService() {
        return new RefactoredBackupManagerService(this.mContext, this);
    }

    protected BackupManagerServiceInterface createBackupManagerService() {
        return new BackupManagerService(this.mContext, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(int whichUser) {
        if (whichUser == 0) {
            if (this.mGlobalDisable) {
                Slog.i(TAG, "Backup/restore not supported");
                return;
            }
            Trampoline trampoline = this;
            synchronized (trampoline) {
                if (!this.mSuppressFile.exists()) {
                    this.mService = this.createService();
                } else {
                    Slog.i(TAG, "Backup inactive in user " + whichUser);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackupServiceActive(int userHandle, boolean makeActive) {
        int caller = this.binderGetCallingUid();
        if (caller != 1000 && caller != 0) {
            throw new SecurityException("No permission to configure backup activity");
        }
        if (this.mGlobalDisable) {
            Slog.i(TAG, "Backup/restore not supported");
            return;
        }
        if (userHandle == 0) {
            Trampoline trampoline = this;
            synchronized (trampoline) {
                if (makeActive != this.isBackupServiceActive(userHandle)) {
                    Slog.i(TAG, "Making backup " + (makeActive ? "" : "in") + "active in user " + userHandle);
                    if (makeActive) {
                        this.mService = this.createService();
                        this.mSuppressFile.delete();
                    } else {
                        this.mService = null;
                        try {
                            this.mSuppressFile.createNewFile();
                        }
                        catch (IOException e) {
                            Slog.e(TAG, "Unable to persist backup service inactivity");
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBackupServiceActive(int userHandle) {
        if (userHandle == 0) {
            Trampoline trampoline = this;
            synchronized (trampoline) {
                return this.mService != null;
            }
        }
        return false;
    }

    @Override
    public void dataChanged(String packageName) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.dataChanged(packageName);
        }
    }

    @Override
    public void initializeTransports(String[] transportNames, IBackupObserver observer) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.initializeTransports(transportNames, observer);
        }
    }

    @Override
    public void clearBackupData(String transportName, String packageName) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.clearBackupData(transportName, packageName);
        }
    }

    @Override
    public void agentConnected(String packageName, IBinder agent) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.agentConnected(packageName, agent);
        }
    }

    @Override
    public void agentDisconnected(String packageName) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.agentDisconnected(packageName);
        }
    }

    @Override
    public void restoreAtInstall(String packageName, int token) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.restoreAtInstall(packageName, token);
        }
    }

    @Override
    public void setBackupEnabled(boolean isEnabled) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.setBackupEnabled(isEnabled);
        }
    }

    @Override
    public void setAutoRestore(boolean doAutoRestore) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.setAutoRestore(doAutoRestore);
        }
    }

    @Override
    public void setBackupProvisioned(boolean isProvisioned) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.setBackupProvisioned(isProvisioned);
        }
    }

    @Override
    public boolean isBackupEnabled() throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.isBackupEnabled() : false;
    }

    @Override
    public boolean setBackupPassword(String currentPw, String newPw) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.setBackupPassword(currentPw, newPw) : false;
    }

    @Override
    public boolean hasBackupPassword() throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.hasBackupPassword() : false;
    }

    @Override
    public void backupNow() throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.backupNow();
        }
    }

    @Override
    public void adbBackup(ParcelFileDescriptor fd, boolean includeApks, boolean includeObbs, boolean includeShared, boolean doWidgets, boolean allApps, boolean allIncludesSystem, boolean doCompress, boolean doKeyValue, String[] packageNames) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.adbBackup(fd, includeApks, includeObbs, includeShared, doWidgets, allApps, allIncludesSystem, doCompress, doKeyValue, packageNames);
        }
    }

    @Override
    public void fullTransportBackup(String[] packageNames) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.fullTransportBackup(packageNames);
        }
    }

    @Override
    public void adbRestore(ParcelFileDescriptor fd) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.adbRestore(fd);
        }
    }

    @Override
    public void acknowledgeFullBackupOrRestore(int token, boolean allow, String curPassword, String encryptionPassword, IFullBackupRestoreObserver observer) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.acknowledgeAdbBackupOrRestore(token, allow, curPassword, encryptionPassword, observer);
        }
    }

    @Override
    public String getCurrentTransport() throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.getCurrentTransport() : null;
    }

    @Override
    public String[] listAllTransports() throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.listAllTransports() : null;
    }

    @Override
    public ComponentName[] listAllTransportComponents() throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.listAllTransportComponents() : null;
    }

    @Override
    public String[] getTransportWhitelist() {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.getTransportWhitelist() : null;
    }

    @Override
    public String selectBackupTransport(String transport) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.selectBackupTransport(transport) : null;
    }

    @Override
    public void selectBackupTransportAsync(ComponentName transport, ISelectBackupTransportCallback listener) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.selectBackupTransportAsync(transport, listener);
        } else if (listener != null) {
            try {
                listener.onFailure(-2001);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public Intent getConfigurationIntent(String transport) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.getConfigurationIntent(transport) : null;
    }

    @Override
    public String getDestinationString(String transport) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.getDestinationString(transport) : null;
    }

    @Override
    public Intent getDataManagementIntent(String transport) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.getDataManagementIntent(transport) : null;
    }

    @Override
    public String getDataManagementLabel(String transport) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.getDataManagementLabel(transport) : null;
    }

    @Override
    public IRestoreSession beginRestoreSession(String packageName, String transportID) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.beginRestoreSession(packageName, transportID) : null;
    }

    @Override
    public void opComplete(int token, long result) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.opComplete(token, result);
        }
    }

    @Override
    public long getAvailableRestoreToken(String packageName) {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.getAvailableRestoreToken(packageName) : 0L;
    }

    @Override
    public boolean isAppEligibleForBackup(String packageName) {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.isAppEligibleForBackup(packageName) : false;
    }

    @Override
    public int requestBackup(String[] packages, IBackupObserver observer, IBackupManagerMonitor monitor, int flags) throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc == null) {
            return -2001;
        }
        return svc.requestBackup(packages, observer, monitor, flags);
    }

    @Override
    public void cancelBackups() throws RemoteException {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.cancelBackups();
        }
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.dump(fd, pw, args);
        } else {
            pw.println("Inactive");
        }
    }

    boolean beginFullBackup(FullBackupJob scheduledJob) {
        BackupManagerServiceInterface svc = this.mService;
        return svc != null ? svc.beginFullBackup(scheduledJob) : false;
    }

    void endFullBackup() {
        BackupManagerServiceInterface svc = this.mService;
        if (svc != null) {
            svc.endFullBackup();
        }
    }
}

