/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.IBackupAgent;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.FullBackup;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.BackupManagerServiceInterface;
import com.android.server.backup.FileMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import libcore.io.IoUtils;

public class KeyValueAdbRestoreEngine
implements Runnable {
    private static final String TAG = "KeyValueAdbRestoreEngine";
    private static final boolean DEBUG = false;
    private final BackupManagerServiceInterface mBackupManagerService;
    private final File mDataDir;
    FileMetadata mInfo;
    BackupManagerService.PerformAdbRestoreTask mRestoreTask;
    ParcelFileDescriptor mInFD;
    IBackupAgent mAgent;
    int mToken;

    public KeyValueAdbRestoreEngine(BackupManagerServiceInterface backupManagerService, File dataDir, FileMetadata info, ParcelFileDescriptor inFD, IBackupAgent agent, int token) {
        this.mBackupManagerService = backupManagerService;
        this.mDataDir = dataDir;
        this.mInfo = info;
        this.mInFD = inFD;
        this.mAgent = agent;
        this.mToken = token;
    }

    @Override
    public void run() {
        try {
            File restoreData = this.prepareRestoreData(this.mInfo, this.mInFD);
            this.invokeAgentForAdbRestore(this.mAgent, this.mInfo, restoreData, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File prepareRestoreData(FileMetadata info, ParcelFileDescriptor inFD) throws IOException {
        String pkg = info.packageName;
        File restoreDataName = new File(this.mDataDir, pkg + ".restore");
        File sortedDataName = new File(this.mDataDir, pkg + ".sorted");
        FullBackup.restoreFile(inFD, info.size, info.type, info.mode, info.mtime, restoreDataName);
        this.sortKeyValueData(restoreDataName, sortedDataName);
        return sortedDataName;
    }

    private void invokeAgentForAdbRestore(IBackupAgent agent, FileMetadata info, File restoreData, int versionCode) throws IOException {
        String pkg = info.packageName;
        File newStateName = new File(this.mDataDir, pkg + ".new");
        try {
            ParcelFileDescriptor backupData = ParcelFileDescriptor.open(restoreData, 0x10000000);
            ParcelFileDescriptor newState = ParcelFileDescriptor.open(newStateName, 0x3C000000);
            agent.doRestore(backupData, versionCode, newState, this.mToken, this.mBackupManagerService.getBackupManagerBinder());
        }
        catch (IOException e) {
            Slog.e(TAG, "Exception opening file. " + e);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Exception calling doRestore on agent: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortKeyValueData(File restoreData, File sortedData) throws IOException {
        FileOutputStream outputStream;
        block5: {
            FileInputStream inputStream = null;
            outputStream = null;
            try {
                inputStream = new FileInputStream(restoreData);
                outputStream = new FileOutputStream(sortedData);
                BackupDataInput reader = new BackupDataInput(inputStream.getFD());
                BackupDataOutput writer = new BackupDataOutput(outputStream.getFD());
                this.copyKeysInLexicalOrder(reader, writer);
                if (inputStream == null) break block5;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    IoUtils.closeQuietly(inputStream);
                }
                if (outputStream != null) {
                    IoUtils.closeQuietly(outputStream);
                }
                throw throwable;
            }
            IoUtils.closeQuietly(inputStream);
        }
        if (outputStream != null) {
            IoUtils.closeQuietly(outputStream);
        }
    }

    private void copyKeysInLexicalOrder(BackupDataInput in, BackupDataOutput out) throws IOException {
        HashMap<String, byte[]> data = new HashMap<String, byte[]>();
        while (in.readNextHeader()) {
            String key = in.getKey();
            int size = in.getDataSize();
            if (size < 0) {
                in.skipEntityData();
                continue;
            }
            byte[] value = new byte[size];
            in.readEntityData(value, 0, size);
            data.put(key, value);
        }
        ArrayList keys = new ArrayList(data.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            byte[] value = (byte[])data.get(key);
            out.writeEntityHeader(key, value.length);
            out.writeEntityData(value, value.length);
        }
    }
}

