/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.util.Slog;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileMetadata {
    public String packageName;
    public String installerPackageName;
    public int type;
    public String domain;
    public String path;
    public long mode;
    public long mtime;
    public long size;
    public int version;
    public boolean hasApk;

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("FileMetadata{");
        sb.append(this.packageName);
        sb.append(',');
        sb.append(this.type);
        sb.append(',');
        sb.append(this.domain);
        sb.append(':');
        sb.append(this.path);
        sb.append(',');
        sb.append(this.size);
        sb.append('}');
        return sb.toString();
    }

    public void dump() {
        StringBuilder b = new StringBuilder(128);
        b.append(this.type == 2 ? (char)'d' : '-');
        b.append((this.mode & 0x100L) != 0L ? (char)'r' : '-');
        b.append((this.mode & 0x80L) != 0L ? (char)'w' : '-');
        b.append((this.mode & 0x40L) != 0L ? (char)'x' : '-');
        b.append((this.mode & 0x20L) != 0L ? (char)'r' : '-');
        b.append((this.mode & 0x10L) != 0L ? (char)'w' : '-');
        b.append((this.mode & 8L) != 0L ? (char)'x' : '-');
        b.append((this.mode & 4L) != 0L ? (char)'r' : '-');
        b.append((this.mode & 2L) != 0L ? (char)'w' : '-');
        b.append((this.mode & 1L) != 0L ? (char)'x' : '-');
        b.append(String.format(" %9d ", this.size));
        Date stamp = new Date(this.mtime);
        b.append(new SimpleDateFormat("MMM dd HH:mm:ss ").format(stamp));
        b.append(this.packageName);
        b.append(" :: ");
        b.append(this.domain);
        b.append(" :: ");
        b.append(this.path);
        Slog.i("BackupManagerService", b.toString());
    }
}

