/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.app.ActivityManager;
import android.app.assist.AssistStructure;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.graphics.Rect;
import android.metrics.LogMaker;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.service.autofill.Dataset;
import android.service.autofill.FillContext;
import android.service.autofill.FillRequest;
import android.service.autofill.FillResponse;
import android.service.autofill.InternalValidator;
import android.service.autofill.SaveInfo;
import android.service.autofill.SaveRequest;
import android.service.autofill.ValueFinder;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.LocalLog;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillValue;
import android.view.autofill.IAutoFillManagerClient;
import android.view.autofill.IAutofillWindowPresenter;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.IResultReceiver;
import com.android.internal.util.ArrayUtils;
import com.android.server.autofill.AutofillManagerServiceImpl;
import com.android.server.autofill.Helper;
import com.android.server.autofill.RemoteFillService;
import com.android.server.autofill.ViewState;
import com.android.server.autofill.ui.AutoFillUI;
import com.android.server.autofill.ui.PendingUi;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

final class Session
implements RemoteFillService.FillServiceCallbacks,
ViewState.Listener,
AutoFillUI.AutoFillUiCallback {
    private static final String TAG = "AutofillSession";
    private static final String EXTRA_REQUEST_ID = "android.service.autofill.extra.REQUEST_ID";
    private final AutofillManagerServiceImpl mService;
    private final HandlerCaller mHandlerCaller;
    private final Object mLock;
    private final AutoFillUI mUi;
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    private static AtomicInteger sIdCounter = new AtomicInteger();
    public final int id;
    public final int uid;
    @GuardedBy(value="mLock")
    private IBinder mActivityToken;
    private final String mPackageName;
    @GuardedBy(value="mLock")
    private final ArrayMap<AutofillId, ViewState> mViewStates = new ArrayMap();
    @GuardedBy(value="mLock")
    private AutofillId mCurrentViewId;
    @GuardedBy(value="mLock")
    private IAutoFillManagerClient mClient;
    private final RemoteFillService mRemoteFillService;
    @GuardedBy(value="mLock")
    private SparseArray<FillResponse> mResponses;
    @GuardedBy(value="mLock")
    private ArrayList<FillContext> mContexts;
    private boolean mHasCallback;
    @GuardedBy(value="mLock")
    private Bundle mClientState;
    @GuardedBy(value="mLock")
    private boolean mDestroyed;
    @GuardedBy(value="mLock")
    private boolean mIsSaving;
    @GuardedBy(value="mLock")
    private PendingUi mPendingSaveUi;
    private final long mStartTime;
    @GuardedBy(value="mLock")
    private long mUiShownTime;
    @GuardedBy(value="mLock")
    private final LocalLog mUiLatencyHistory;
    private final IResultReceiver mAssistReceiver = new IResultReceiver.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(int resultCode, Bundle resultData) throws RemoteException {
            FillRequest request;
            AssistStructure structure = (AssistStructure)resultData.getParcelable("structure");
            if (structure == null) {
                Slog.e(Session.TAG, "No assist structure - app might have crashed providing it");
                return;
            }
            Bundle receiverExtras = resultData.getBundle("receiverExtras");
            if (receiverExtras == null) {
                Slog.e(Session.TAG, "No receiver extras - app might have crashed providing it");
                return;
            }
            int requestId = receiverExtras.getInt(Session.EXTRA_REQUEST_ID);
            if (Helper.sVerbose) {
                Slog.v(Session.TAG, "New structure for requestId " + requestId + ": " + structure);
            }
            Object object = Session.this.mLock;
            synchronized (object) {
                structure.ensureData();
                structure.sanitizeForParceling(true);
                int flags = structure.getFlags();
                if (Session.this.mContexts == null) {
                    Session.this.mContexts = new ArrayList(1);
                }
                Session.this.mContexts.add(new FillContext(requestId, structure));
                Session.this.cancelCurrentRequestLocked();
                int numContexts = Session.this.mContexts.size();
                for (int i = 0; i < numContexts; ++i) {
                    Session.this.fillContextWithAllowedValuesLocked((FillContext)Session.this.mContexts.get(i), flags);
                }
                request = new FillRequest(requestId, new ArrayList<FillContext>(Session.this.mContexts), Session.this.mClientState, flags);
            }
            Session.this.mRemoteFillService.onFillRequest(request);
        }
    };

    private AutofillId[] getIdsOfAllViewStatesLocked() {
        int numViewState = this.mViewStates.size();
        AutofillId[] ids = new AutofillId[numViewState];
        for (int i = 0; i < numViewState; ++i) {
            ids[i] = this.mViewStates.valueAt((int)i).id;
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getValueAsString(AutofillId id2) {
        AutofillValue value = null;
        Object object = this.mLock;
        synchronized (object) {
            ViewState state = this.mViewStates.get(id2);
            if (state == null) {
                if (Helper.sDebug) {
                    Slog.d(TAG, "getValue(): no view state for " + id2);
                }
                return null;
            }
            value = state.getCurrentValue();
            if (value == null) {
                if (Helper.sDebug) {
                    Slog.d(TAG, "getValue(): no current value for " + id2);
                }
                value = this.getValueFromContextsLocked(id2);
            }
        }
        if (value != null) {
            if (value.isText()) {
                return value.getTextValue().toString();
            }
            if (value.isList()) {
                CharSequence[] options = this.getAutofillOptionsFromContextsLocked(id2);
                if (options != null) {
                    int index = value.getListValue();
                    CharSequence option = options[index];
                    return option != null ? option.toString() : null;
                }
                Slog.w(TAG, "getValueAsString(): no autofill options for id " + id2);
            }
        }
        return null;
    }

    private void fillContextWithAllowedValuesLocked(FillContext fillContext, int flags) {
        AssistStructure.ViewNode[] nodes = fillContext.findViewNodesByAutofillIds(this.getIdsOfAllViewStatesLocked());
        int numViewState = this.mViewStates.size();
        for (int i = 0; i < numViewState; ++i) {
            ViewState viewState = this.mViewStates.valueAt(i);
            AssistStructure.ViewNode node = nodes[i];
            if (node == null) {
                if (!Helper.sVerbose) continue;
                Slog.v(TAG, "fillStructureWithAllowedValues(): no node for " + viewState.id);
                continue;
            }
            AutofillValue currentValue = viewState.getCurrentValue();
            AutofillValue filledValue = viewState.getAutofilledValue();
            AssistStructure.AutofillOverlay overlay = new AssistStructure.AutofillOverlay();
            if (filledValue != null && filledValue.equals(currentValue)) {
                overlay.value = currentValue;
            }
            if (this.mCurrentViewId != null) {
                overlay.focused = this.mCurrentViewId.equals(viewState.id);
                if (overlay.focused && (flags & 1) != 0) {
                    overlay.value = currentValue;
                }
            }
            node.setAutofillOverlay(overlay);
        }
    }

    private void cancelCurrentRequestLocked() {
        int canceledRequest = this.mRemoteFillService.cancelCurrentRequest();
        if (canceledRequest != Integer.MIN_VALUE && this.mContexts != null) {
            int numContexts = this.mContexts.size();
            for (int i = numContexts - 1; i >= 0; --i) {
                if (this.mContexts.get(i).getRequestId() != canceledRequest) continue;
                if (Helper.sDebug) {
                    Slog.d(TAG, "cancelCurrentRequest(): id = " + canceledRequest);
                }
                this.mContexts.remove(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestNewFillResponseLocked(int flags) {
        int requestId;
        while ((requestId = sIdCounter.getAndIncrement()) == Integer.MIN_VALUE) {
        }
        if (Helper.sVerbose) {
            Slog.v(TAG, "Requesting structure for requestId=" + requestId + ", flags=" + flags);
        }
        this.cancelCurrentRequestLocked();
        try {
            Bundle receiverExtras = new Bundle();
            receiverExtras.putInt(EXTRA_REQUEST_ID, requestId);
            long identity = Binder.clearCallingIdentity();
            try {
                if (!ActivityManager.getService().requestAutofillData(this.mAssistReceiver, receiverExtras, this.mActivityToken, flags)) {
                    Slog.w(TAG, "failed to request autofill data for " + this.mActivityToken);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    Session(AutofillManagerServiceImpl service, AutoFillUI ui, Context context, HandlerCaller handlerCaller, int userId, Object lock, int sessionId, int uid, IBinder activityToken, IBinder client, boolean hasCallback, LocalLog uiLatencyHistory, ComponentName componentName, String packageName) {
        this.id = sessionId;
        this.uid = uid;
        this.mStartTime = SystemClock.elapsedRealtime();
        this.mService = service;
        this.mLock = lock;
        this.mUi = ui;
        this.mHandlerCaller = handlerCaller;
        this.mRemoteFillService = new RemoteFillService(context, componentName, userId, this);
        this.mActivityToken = activityToken;
        this.mHasCallback = hasCallback;
        this.mUiLatencyHistory = uiLatencyHistory;
        this.mPackageName = packageName;
        this.mClient = IAutoFillManagerClient.Stub.asInterface(client);
        this.writeLog(906);
    }

    IBinder getActivityTokenLocked() {
        return this.mActivityToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchActivity(IBinder newActivity, IBinder newClient) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#switchActivity() rejected - session: " + this.id + " destroyed");
                return;
            }
            this.mActivityToken = newActivity;
            this.mClient = IAutoFillManagerClient.Stub.asInterface(newClient);
            this.updateTrackedIdsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFillRequestSuccess(int requestFlags, FillResponse response, int serviceUid, String servicePackageName) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#onFillRequestSuccess() rejected - session: " + this.id + " destroyed");
                return;
            }
        }
        if (response == null) {
            this.processNullResponseLocked(requestFlags);
            return;
        }
        this.mService.setLastResponse(serviceUid, this.id, response);
        if ((response.getDatasets() == null || response.getDatasets().isEmpty()) && response.getAuthentication() == null) {
            this.notifyUnavailableToClient(false);
        }
        object = this.mLock;
        synchronized (object) {
            this.processResponseLocked(response, requestFlags);
        }
        LogMaker log = this.newLogMaker(907, servicePackageName).setType(10).addTaggedData(909, response.getDatasets() == null ? 0 : response.getDatasets().size());
        this.mMetricsLogger.write(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFillRequestFailure(CharSequence message, String servicePackageName) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#onFillRequestFailure() rejected - session: " + this.id + " destroyed");
                return;
            }
            this.mService.resetLastResponse();
        }
        LogMaker log = this.newLogMaker(907, servicePackageName).setType(11);
        this.mMetricsLogger.write(log);
        this.getUiForShowing().showError(message, (AutoFillUI.AutoFillUiCallback)this);
        this.removeSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSaveRequestSuccess(String servicePackageName) {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsSaving = false;
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#onSaveRequestSuccess() rejected - session: " + this.id + " destroyed");
                return;
            }
        }
        LogMaker log = this.newLogMaker(918, servicePackageName).setType(10);
        this.mMetricsLogger.write(log);
        this.removeSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSaveRequestFailure(CharSequence message, String servicePackageName) {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsSaving = false;
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#onSaveRequestFailure() rejected - session: " + this.id + " destroyed");
                return;
            }
        }
        LogMaker log = this.newLogMaker(918, servicePackageName).setType(11);
        this.mMetricsLogger.write(log);
        this.getUiForShowing().showError(message, (AutoFillUI.AutoFillUiCallback)this);
        this.removeSelf();
    }

    private FillContext getFillContextByRequestIdLocked(int requestId) {
        if (this.mContexts == null) {
            return null;
        }
        int numContexts = this.mContexts.size();
        for (int i = 0; i < numContexts; ++i) {
            FillContext context = this.mContexts.get(i);
            if (context.getRequestId() != requestId) continue;
            return context;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authenticate(int requestId, int datasetIndex, IntentSender intent, Bundle extras) {
        Intent fillInIntent;
        if (Helper.sDebug) {
            Slog.d(TAG, "authenticate(): requestId=" + requestId + "; datasetIdx=" + datasetIndex + "; intentSender=" + intent);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#authenticate() rejected - session: " + this.id + " destroyed");
                return;
            }
            fillInIntent = this.createAuthFillInIntentLocked(requestId, extras);
            if (fillInIntent == null) {
                this.forceRemoveSelfLocked();
                return;
            }
        }
        this.mService.setAuthenticationSelected(this.id);
        int authenticationId = AutofillManager.makeAuthenticationId(requestId, datasetIndex);
        this.mHandlerCaller.getHandler().post(() -> this.startAuthentication(authenticationId, intent, fillInIntent));
    }

    @Override
    public void onServiceDied(RemoteFillService service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(int requestId, int datasetIndex, Dataset dataset) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#fill() rejected - session: " + this.id + " destroyed");
                return;
            }
        }
        this.mHandlerCaller.getHandler().post(() -> this.autoFill(requestId, datasetIndex, dataset, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#save() rejected - session: " + this.id + " destroyed");
                return;
            }
        }
        this.mHandlerCaller.getHandler().obtainMessage(1, this.id, 0).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelSave() {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsSaving = false;
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#cancelSave() rejected - session: " + this.id + " destroyed");
                return;
            }
        }
        this.mHandlerCaller.getHandler().post(() -> this.removeSelf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestShowFillUi(AutofillId id2, int width, int height, IAutofillWindowPresenter presenter) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#requestShowFillUi() rejected - session: " + id2 + " destroyed");
                return;
            }
            if (id2.equals(this.mCurrentViewId)) {
                try {
                    ViewState view = this.mViewStates.get(id2);
                    this.mClient.requestShowFillUi(this.id, id2, width, height, view.getVirtualBounds(), presenter);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Error requesting to show fill UI", e);
                }
            } else if (Helper.sDebug) {
                Slog.d(TAG, "Do not show full UI on " + id2 + " as it is not the current view (" + this.mCurrentViewId + ") anymore");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestHideFillUi(AutofillId id2) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mClient.requestHideFillUi(this.id, id2);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error requesting to hide fill UI", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startIntentSender(IntentSender intentSender) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#startIntentSender() rejected - session: " + this.id + " destroyed");
                return;
            }
            this.removeSelfLocked();
        }
        this.mHandlerCaller.getHandler().post(() -> {
            try {
                Object object = this.mLock;
                synchronized (object) {
                    this.mClient.startIntentSender(intentSender, null);
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error launching auth intent", e);
            }
        });
    }

    void setAuthenticationResultLocked(Bundle data, int authenticationId) {
        Dataset dataset;
        if (this.mDestroyed) {
            Slog.w(TAG, "Call to Session#setAuthenticationResultLocked() rejected - session: " + this.id + " destroyed");
            return;
        }
        if (this.mResponses == null) {
            Slog.w(TAG, "setAuthenticationResultLocked(" + authenticationId + "): no responses");
            this.removeSelf();
            return;
        }
        int requestId = AutofillManager.getRequestIdFromAuthenticationId(authenticationId);
        FillResponse authenticatedResponse = this.mResponses.get(requestId);
        if (authenticatedResponse == null || data == null) {
            this.removeSelf();
            return;
        }
        int datasetIdx = AutofillManager.getDatasetIdFromAuthenticationId(authenticationId);
        if (datasetIdx != 65535 && (dataset = authenticatedResponse.getDatasets().get(datasetIdx)) == null) {
            this.removeSelf();
            return;
        }
        Object result = data.getParcelable("android.view.autofill.extra.AUTHENTICATION_RESULT");
        if (Helper.sDebug) {
            Slog.d(TAG, "setAuthenticationResultLocked(): result=" + result);
        }
        if (result instanceof FillResponse) {
            this.writeLog(912);
            this.replaceResponseLocked(authenticatedResponse, (FillResponse)result);
        } else if (result instanceof Dataset) {
            if (datasetIdx != 65535) {
                this.writeLog(1126);
                Dataset dataset2 = (Dataset)result;
                authenticatedResponse.getDatasets().set(datasetIdx, dataset2);
                this.autoFill(requestId, datasetIdx, dataset2, false);
            } else {
                this.writeLog(1127);
            }
        } else {
            if (result != null) {
                Slog.w(TAG, "service returned invalid auth type: " + result);
            }
            this.writeLog(1128);
            this.processNullResponseLocked(0);
        }
    }

    void setHasCallbackLocked(boolean hasIt) {
        if (this.mDestroyed) {
            Slog.w(TAG, "Call to Session#setHasCallbackLocked() rejected - session: " + this.id + " destroyed");
            return;
        }
        this.mHasCallback = hasIt;
    }

    private FillResponse getLastResponseLocked(String logPrefix) {
        if (this.mContexts == null) {
            if (Helper.sDebug && logPrefix != null) {
                Slog.d(TAG, logPrefix + ": no contexts");
            }
            return null;
        }
        if (this.mResponses == null) {
            if (Helper.sVerbose && logPrefix != null) {
                Slog.v(TAG, logPrefix + ": no responses on session");
            }
            return null;
        }
        int lastResponseIdx = this.getLastResponseIndexLocked();
        if (lastResponseIdx < 0) {
            if (logPrefix != null) {
                Slog.w(TAG, logPrefix + ": did not get last response. mResponses=" + this.mResponses + ", mViewStates=" + this.mViewStates);
            }
            return null;
        }
        FillResponse response = this.mResponses.valueAt(lastResponseIdx);
        if (Helper.sVerbose && logPrefix != null) {
            Slog.v(TAG, logPrefix + ": mResponses=" + this.mResponses + ", mContexts=" + this.mContexts + ", mViewStates=" + this.mViewStates);
        }
        return response;
    }

    private SaveInfo getSaveInfoLocked() {
        FillResponse response = this.getLastResponseLocked(null);
        return response == null ? null : response.getSaveInfo();
    }

    public boolean showSaveLocked() {
        AutofillValue initialValue;
        SaveInfo saveInfo;
        if (this.mDestroyed) {
            Slog.w(TAG, "Call to Session#showSaveLocked() rejected - session: " + this.id + " destroyed");
            return false;
        }
        FillResponse response = this.getLastResponseLocked("showSaveLocked()");
        SaveInfo saveInfo2 = saveInfo = response == null ? null : response.getSaveInfo();
        if (saveInfo == null) {
            return true;
        }
        ArrayMap<AutofillId, AutofillValue> currentValues = new ArrayMap<AutofillId, AutofillValue>();
        ArraySet<AutofillId> allIds = new ArraySet<AutofillId>();
        Object[] requiredIds = saveInfo.getRequiredIds();
        boolean allRequiredAreNotEmpty = true;
        boolean atLeastOneChanged = false;
        if (requiredIds != null) {
            for (int i = 0; i < requiredIds.length; ++i) {
                AutofillId id3 = requiredIds[i];
                if (id3 == null) {
                    Slog.w(TAG, "null autofill id on " + Arrays.toString(requiredIds));
                    continue;
                }
                allIds.add(id3);
                ViewState viewState = this.mViewStates.get(id3);
                if (viewState == null) {
                    Slog.w(TAG, "showSaveLocked(): no ViewState for required " + id3);
                    allRequiredAreNotEmpty = false;
                    break;
                }
                AutofillValue value = viewState.getCurrentValue();
                if (value == null || value.isEmpty()) {
                    initialValue = this.getValueFromContextsLocked(id3);
                    if (initialValue != null) {
                        if (Helper.sDebug) {
                            Slog.d(TAG, "Value of required field " + id3 + " didn't change; " + "using initial value (" + initialValue + ") instead");
                        }
                        value = initialValue;
                    } else {
                        if (Helper.sDebug) {
                            Slog.d(TAG, "empty value for required " + id3);
                        }
                        allRequiredAreNotEmpty = false;
                        break;
                    }
                }
                currentValues.put(id3, value);
                AutofillValue filledValue = viewState.getAutofilledValue();
                if (value.equals(filledValue)) continue;
                if (Helper.sDebug) {
                    Slog.d(TAG, "found a change on required " + id3 + ": " + filledValue + " => " + value);
                }
                atLeastOneChanged = true;
            }
        }
        AutofillId[] optionalIds = saveInfo.getOptionalIds();
        if (allRequiredAreNotEmpty) {
            if (!atLeastOneChanged && optionalIds != null) {
                for (int i = 0; i < optionalIds.length; ++i) {
                    AutofillId id4 = optionalIds[i];
                    allIds.add(id4);
                    ViewState viewState = this.mViewStates.get(id4);
                    if (viewState == null) {
                        Slog.w(TAG, "no ViewState for optional " + id4);
                        continue;
                    }
                    if ((viewState.getState() & 8) != 0) {
                        AutofillValue currentValue = viewState.getCurrentValue();
                        currentValues.put(id4, currentValue);
                        AutofillValue filledValue = viewState.getAutofilledValue();
                        if (currentValue == null || currentValue.equals(filledValue)) continue;
                        if (Helper.sDebug) {
                            Slog.d(TAG, "found a change on optional " + id4 + ": " + filledValue + " => " + currentValue);
                        }
                        atLeastOneChanged = true;
                        break;
                    }
                    initialValue = this.getValueFromContextsLocked(id4);
                    if (Helper.sDebug) {
                        Slog.d(TAG, "no current value for " + id4 + "; initial value is " + initialValue);
                    }
                    if (initialValue == null) continue;
                    currentValues.put(id4, initialValue);
                }
            }
            if (atLeastOneChanged) {
                List<Dataset> datasets;
                if (Helper.sDebug) {
                    Slog.d(TAG, "at least one field changed, validate fields for save UI");
                }
                ValueFinder valueFinder = id2 -> this.getValueAsString(id2);
                InternalValidator validator = saveInfo.getValidator();
                if (validator != null) {
                    boolean isValid;
                    LogMaker log = this.newLogMaker(1133);
                    try {
                        isValid = validator.isValid(valueFinder);
                        log.setType(isValid ? 10 : 5);
                    }
                    catch (Exception e) {
                        Slog.e(TAG, "Not showing save UI because validation failed:", e);
                        log.setType(11);
                        this.mMetricsLogger.write(log);
                        return true;
                    }
                    this.mMetricsLogger.write(log);
                    if (!isValid) {
                        Slog.i(TAG, "not showing save UI because fields failed validation");
                        return true;
                    }
                }
                if ((datasets = response.getDatasets()) != null) {
                    block6: for (int i = 0; i < datasets.size(); ++i) {
                        Dataset dataset = datasets.get(i);
                        ArrayMap<AutofillId, AutofillValue> datasetValues = Helper.getFields(dataset);
                        if (Helper.sVerbose) {
                            Slog.v(TAG, "Checking if saved fields match contents of dataset #" + i + ": " + dataset + "; allIds=" + allIds);
                        }
                        for (int j = 0; j < allIds.size(); ++j) {
                            AutofillId id5 = (AutofillId)allIds.valueAt(j);
                            AutofillValue currentValue = (AutofillValue)currentValues.get(id5);
                            if (currentValue == null) {
                                if (!Helper.sDebug) continue block6;
                                Slog.d(TAG, "dataset has value for field that is null: " + id5);
                                continue block6;
                            }
                            AutofillValue datasetValue = datasetValues.get(id5);
                            if (!currentValue.equals(datasetValue)) {
                                if (!Helper.sDebug) continue block6;
                                Slog.d(TAG, "found a change on id " + id5);
                                continue block6;
                            }
                            if (!Helper.sVerbose) continue;
                            Slog.v(TAG, "no changes for id " + id5);
                        }
                        if (Helper.sDebug) {
                            Slog.d(TAG, "ignoring Save UI because all fields match contents of dataset #" + i + ": " + dataset);
                        }
                        return true;
                    }
                }
                if (Helper.sDebug) {
                    Slog.d(TAG, "Good news, everyone! All checks passed, show save UI!");
                }
                this.mService.logSaveShown(this.id);
                IAutoFillManagerClient client = this.getClient();
                this.mPendingSaveUi = new PendingUi(this.mActivityToken, this.id, client);
                this.getUiForShowing().showSaveUi(this.mService.getServiceLabel(), this.mService.getServiceIcon(), this.mService.getServicePackageName(), saveInfo, valueFinder, this.mPackageName, this, this.mPendingSaveUi);
                if (client != null) {
                    try {
                        client.setSaveUiState(this.id, true);
                    }
                    catch (RemoteException e) {
                        Slog.e(TAG, "Error notifying client to set save UI state to shown: " + e);
                    }
                }
                this.mIsSaving = true;
                return false;
            }
        }
        if (Helper.sDebug) {
            Slog.d(TAG, "showSaveLocked(): with no changes, comes no responsibilities.allRequiredAreNotNull=" + allRequiredAreNotEmpty + ", atLeastOneChanged=" + atLeastOneChanged);
        }
        return true;
    }

    boolean isSavingLocked() {
        return this.mIsSaving;
    }

    private AutofillValue getValueFromContextsLocked(AutofillId id2) {
        int numContexts = this.mContexts.size();
        for (int i = numContexts - 1; i >= 0; --i) {
            FillContext context = this.mContexts.get(i);
            AssistStructure.ViewNode node = context.findViewNodeByAutofillId(id2);
            if (node == null) continue;
            AutofillValue value = node.getAutofillValue();
            if (Helper.sDebug) {
                Slog.d(TAG, "getValueFromContexts(" + id2 + ") at " + i + ": " + value);
            }
            if (value == null || value.isEmpty()) continue;
            return value;
        }
        return null;
    }

    private CharSequence[] getAutofillOptionsFromContextsLocked(AutofillId id2) {
        int numContexts = this.mContexts.size();
        for (int i = numContexts - 1; i >= 0; --i) {
            FillContext context = this.mContexts.get(i);
            AssistStructure.ViewNode node = context.findViewNodeByAutofillId(id2);
            if (node == null || node.getAutofillOptions() == null) continue;
            return node.getAutofillOptions();
        }
        return null;
    }

    void callSaveLocked() {
        if (this.mDestroyed) {
            Slog.w(TAG, "Call to Session#callSaveLocked() rejected - session: " + this.id + " destroyed");
            return;
        }
        if (Helper.sVerbose) {
            Slog.v(TAG, "callSaveLocked(): mViewStates=" + this.mViewStates);
        }
        if (this.mContexts == null) {
            Slog.w(TAG, "callSaveLocked(): no contexts");
            return;
        }
        int numContexts = this.mContexts.size();
        for (int contextNum = 0; contextNum < numContexts; ++contextNum) {
            FillContext context = this.mContexts.get(contextNum);
            AssistStructure.ViewNode[] nodes = context.findViewNodesByAutofillIds(this.getIdsOfAllViewStatesLocked());
            if (Helper.sVerbose) {
                Slog.v(TAG, "callSaveLocked(): updating " + context);
            }
            for (int viewStateNum = 0; viewStateNum < this.mViewStates.size(); ++viewStateNum) {
                ViewState state = this.mViewStates.valueAt(viewStateNum);
                AutofillId id2 = state.id;
                AutofillValue value = state.getCurrentValue();
                if (value == null) {
                    if (!Helper.sVerbose) continue;
                    Slog.v(TAG, "callSaveLocked(): skipping " + id2);
                    continue;
                }
                AssistStructure.ViewNode node = nodes[viewStateNum];
                if (node == null) {
                    Slog.w(TAG, "callSaveLocked(): did not find node with id " + id2);
                    continue;
                }
                if (Helper.sVerbose) {
                    Slog.v(TAG, "callSaveLocked(): updating " + id2 + " to " + value);
                }
                node.updateAutofillValue(value);
            }
            context.getStructure().sanitizeForParceling(false);
            if (!Helper.sVerbose) continue;
            Slog.v(TAG, "Dumping structure of " + context + " before calling service.save()");
            context.getStructure().dump(false);
        }
        this.cancelCurrentRequestLocked();
        SaveRequest saveRequest = new SaveRequest(new ArrayList<FillContext>(this.mContexts), this.mClientState);
        this.mRemoteFillService.onSaveRequest(saveRequest);
    }

    private void requestNewFillResponseIfNecessaryLocked(AutofillId id2, ViewState viewState, int flags) {
        boolean restart;
        int state = viewState.getState();
        boolean bl = restart = (state & 4) != 0 && (flags & 1) != 0;
        if (restart) {
            if (Helper.sDebug) {
                Slog.d(TAG, "Re-starting session on view  " + id2);
            }
            viewState.setState(256);
            this.requestNewFillResponseLocked(flags);
            return;
        }
        if (this.shouldStartNewPartitionLocked(id2)) {
            if (Helper.sDebug) {
                Slog.d(TAG, "Starting partition for view id " + id2 + ": " + viewState.getStateAsString());
            }
            viewState.setState(32);
            this.requestNewFillResponseLocked(flags);
        }
    }

    private boolean shouldStartNewPartitionLocked(AutofillId id2) {
        if (this.mResponses == null) {
            return true;
        }
        int numResponses = this.mResponses.size();
        if (numResponses >= Helper.sPartitionMaxCount) {
            Slog.e(TAG, "Not starting a new partition on " + id2 + " because session " + this.id + " reached maximum of " + Helper.sPartitionMaxCount);
            return false;
        }
        for (int responseNum = 0; responseNum < numResponses; ++responseNum) {
            FillResponse response = this.mResponses.valueAt(responseNum);
            if (ArrayUtils.contains(response.getIgnoredIds(), id2)) {
                return false;
            }
            SaveInfo saveInfo = response.getSaveInfo();
            if (saveInfo != null && (ArrayUtils.contains(saveInfo.getOptionalIds(), id2) || ArrayUtils.contains(saveInfo.getRequiredIds(), id2))) {
                return false;
            }
            List<Dataset> datasets = response.getDatasets();
            if (datasets != null) {
                int numDatasets = datasets.size();
                for (int dataSetNum = 0; dataSetNum < numDatasets; ++dataSetNum) {
                    ArrayList<AutofillId> fields = datasets.get(dataSetNum).getFieldIds();
                    if (fields == null || !fields.contains(id2)) continue;
                    return false;
                }
            }
            if (!ArrayUtils.contains(response.getAuthenticationIds(), id2)) continue;
            return false;
        }
        return true;
    }

    void updateLocked(AutofillId id2, Rect virtualBounds, AutofillValue value, int action, int flags) {
        ViewState viewState;
        if (this.mDestroyed) {
            Slog.w(TAG, "Call to Session#updateLocked() rejected - session: " + id2 + " destroyed");
            return;
        }
        if (Helper.sVerbose) {
            Slog.v(TAG, "updateLocked(): id=" + id2 + ", action=" + action + ", flags=" + flags);
        }
        if ((viewState = this.mViewStates.get(id2)) == null) {
            if (action == 1 || action == 4 || action == 2) {
                boolean isIgnored;
                if (Helper.sVerbose) {
                    Slog.v(TAG, "Creating viewState for " + id2 + " on " + action);
                }
                viewState = new ViewState(this, id2, this, (isIgnored = this.isIgnoredLocked(id2)) ? 128 : 1);
                this.mViewStates.put(id2, viewState);
                if (isIgnored) {
                    if (Helper.sDebug) {
                        Slog.d(TAG, "updateLocked(): ignoring view " + id2);
                    }
                    return;
                }
            } else {
                if (Helper.sVerbose) {
                    Slog.v(TAG, "Ignored action " + action + " for " + id2);
                }
                return;
            }
        }
        switch (action) {
            case 1: {
                this.mCurrentViewId = viewState.id;
                viewState.update(value, virtualBounds, flags);
                viewState.setState(16);
                this.requestNewFillResponseLocked(flags);
                break;
            }
            case 4: {
                if (value == null || value.equals(viewState.getCurrentValue())) break;
                if (value.isEmpty() && viewState.getCurrentValue() != null && viewState.getCurrentValue().isText() && viewState.getCurrentValue().getTextValue() != null && this.getSaveInfoLocked() != null) {
                    int length = viewState.getCurrentValue().getTextValue().length();
                    if (Helper.sDebug) {
                        Slog.d(TAG, "updateLocked(" + id2 + "): resetting value that was " + length + " chars long");
                    }
                    LogMaker log = this.newLogMaker(1124).addTaggedData(1125, length);
                    this.mMetricsLogger.write(log);
                }
                viewState.setCurrentValue(value);
                AutofillValue filledValue = viewState.getAutofilledValue();
                if (value.equals(filledValue)) {
                    return;
                }
                viewState.setState(8);
                if (value.isText()) {
                    this.getUiForShowing().filterFillUi(value.getTextValue().toString(), this);
                    break;
                }
                this.getUiForShowing().filterFillUi(null, this);
                break;
            }
            case 2: {
                if (Helper.sVerbose && virtualBounds != null) {
                    Slog.w(TAG, "entered on virtual child " + id2 + ": " + virtualBounds);
                }
                this.requestNewFillResponseIfNecessaryLocked(id2, viewState, flags);
                if (this.mCurrentViewId != viewState.id) {
                    this.mUi.hideFillUi(this);
                    this.mCurrentViewId = viewState.id;
                }
                viewState.update(value, virtualBounds, flags);
                break;
            }
            case 3: {
                if (this.mCurrentViewId != viewState.id) break;
                if (Helper.sVerbose) {
                    Slog.d(TAG, "Exiting view " + id2);
                }
                this.mUi.hideFillUi(this);
                this.mCurrentViewId = null;
                break;
            }
            default: {
                Slog.w(TAG, "updateLocked(): unknown action: " + action);
            }
        }
    }

    private boolean isIgnoredLocked(AutofillId id2) {
        if (this.mResponses == null || this.mResponses.size() == 0) {
            return false;
        }
        FillResponse response = this.mResponses.valueAt(this.mResponses.size() - 1);
        return ArrayUtils.contains(response.getIgnoredIds(), id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFillReady(FillResponse response, AutofillId filledId, AutofillValue value) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#onFillReady() rejected - session: " + this.id + " destroyed");
                return;
            }
        }
        String filterText = null;
        if (value != null && value.isText()) {
            filterText = value.getTextValue().toString();
        }
        this.getUiForShowing().showFillUi(filledId, response, filterText, this.mService.getServicePackageName(), this.mPackageName, this);
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mUiShownTime == 0L) {
                this.mUiShownTime = SystemClock.elapsedRealtime();
                long duration = this.mUiShownTime - this.mStartTime;
                if (Helper.sDebug) {
                    StringBuilder msg = new StringBuilder("1st UI for ").append(this.mActivityToken).append(" shown in ");
                    TimeUtils.formatDuration(duration, msg);
                    Slog.d(TAG, msg.toString());
                }
                StringBuilder historyLog = new StringBuilder("id=").append(this.id).append(" app=").append(this.mActivityToken).append(" svc=").append(this.mService.getServicePackageName()).append(" latency=");
                TimeUtils.formatDuration(duration, historyLog);
                this.mUiLatencyHistory.log(historyLog.toString());
                LogMaker metricsLog = this.newLogMaker(1136).setCounterValue((int)duration);
                this.mMetricsLogger.write(metricsLog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDestroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IAutoFillManagerClient getClient() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUnavailableToClient(boolean sessionFinished) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentViewId == null) {
                return;
            }
            try {
                if (this.mHasCallback) {
                    this.mClient.notifyNoFillUi(this.id, this.mCurrentViewId, sessionFinished);
                } else if (sessionFinished) {
                    this.mClient.setSessionFinished(2);
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error notifying client no fill UI: id=" + this.mCurrentViewId, e);
            }
        }
    }

    private void updateTrackedIdsLocked() {
        if (this.mResponses == null || this.mResponses.size() == 0) {
            return;
        }
        FillResponse response = this.mResponses.valueAt(this.getLastResponseIndexLocked());
        ArraySet<AutofillId> trackedViews = null;
        boolean saveOnAllViewsInvisible = false;
        SaveInfo saveInfo = response.getSaveInfo();
        if (saveInfo != null) {
            boolean bl = saveOnAllViewsInvisible = (saveInfo.getFlags() & 1) != 0;
            if (saveOnAllViewsInvisible) {
                if (trackedViews == null) {
                    trackedViews = new ArraySet<AutofillId>();
                }
                if (saveInfo.getRequiredIds() != null) {
                    Collections.addAll(trackedViews, saveInfo.getRequiredIds());
                }
                if (saveInfo.getOptionalIds() != null) {
                    Collections.addAll(trackedViews, saveInfo.getOptionalIds());
                }
            }
        }
        List<Dataset> datasets = response.getDatasets();
        ArraySet<AutofillId> fillableIds = null;
        if (datasets != null) {
            for (int i = 0; i < datasets.size(); ++i) {
                Dataset dataset = datasets.get(i);
                ArrayList<AutofillId> fieldIds = dataset.getFieldIds();
                if (fieldIds == null) continue;
                for (int j = 0; j < fieldIds.size(); ++j) {
                    AutofillId id2 = fieldIds.get(j);
                    if (trackedViews != null && trackedViews.contains(id2)) continue;
                    fillableIds = ArrayUtils.add(fillableIds, id2);
                }
            }
        }
        try {
            if (Helper.sVerbose) {
                Slog.v(TAG, "updateTrackedIdsLocked(): " + trackedViews + " => " + fillableIds);
            }
            this.mClient.setTrackedViews(this.id, Helper.toArray(trackedViews), saveOnAllViewsInvisible, Helper.toArray(fillableIds));
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Cannot set tracked ids", e);
        }
    }

    private void replaceResponseLocked(FillResponse oldResponse, FillResponse newResponse) {
        this.setViewStatesLocked(oldResponse, 1, true);
        newResponse.setRequestId(oldResponse.getRequestId());
        this.mResponses.put(newResponse.getRequestId(), newResponse);
        this.processResponseLocked(newResponse, 0);
    }

    private void processNullResponseLocked(int flags) {
        if (Helper.sVerbose) {
            Slog.v(TAG, "canceling session " + this.id + " when server returned null");
        }
        if ((flags & 1) != 0) {
            this.getUiForShowing().showError(17039521, (AutoFillUI.AutoFillUiCallback)this);
        }
        this.mService.resetLastResponse();
        this.notifyUnavailableToClient(true);
        this.removeSelf();
    }

    private void processResponseLocked(FillResponse newResponse, int flags) {
        this.mUi.hideAll(this);
        int requestId = newResponse.getRequestId();
        if (Helper.sVerbose) {
            Slog.v(TAG, "processResponseLocked(): mCurrentViewId=" + this.mCurrentViewId + ",flags=" + flags + ", reqId=" + requestId + ", resp=" + newResponse);
        }
        if (this.mResponses == null) {
            this.mResponses = new SparseArray(4);
        }
        this.mResponses.put(requestId, newResponse);
        this.mClientState = newResponse.getClientState();
        this.setViewStatesLocked(newResponse, 2, false);
        this.updateTrackedIdsLocked();
        if (this.mCurrentViewId == null) {
            return;
        }
        ViewState currentView = this.mViewStates.get(this.mCurrentViewId);
        currentView.maybeCallOnFillReady(flags);
    }

    private void setViewStatesLocked(FillResponse response, int state, boolean clearResponse) {
        AutofillId[] authIds;
        SaveInfo saveInfo;
        List<Dataset> datasets = response.getDatasets();
        if (datasets != null) {
            for (int i = 0; i < datasets.size(); ++i) {
                Dataset dataset = datasets.get(i);
                if (dataset == null) {
                    Slog.w(TAG, "Ignoring null dataset on " + datasets);
                    continue;
                }
                this.setViewStatesLocked(response, dataset, state, clearResponse);
            }
        } else if (response.getAuthentication() != null) {
            for (AutofillId autofillId : response.getAuthenticationIds()) {
                ViewState viewState = this.createOrUpdateViewStateLocked(autofillId, state, null);
                if (!clearResponse) {
                    viewState.setResponse(response);
                    continue;
                }
                viewState.setResponse(null);
            }
        }
        if ((saveInfo = response.getSaveInfo()) != null) {
            AutofillId[] optionalIds;
            AutofillId[] requiredIds = saveInfo.getRequiredIds();
            if (requiredIds != null) {
                for (AutofillId id2 : requiredIds) {
                    this.createOrUpdateViewStateLocked(id2, state, null);
                }
            }
            if ((optionalIds = saveInfo.getOptionalIds()) != null) {
                for (AutofillId id3 : optionalIds) {
                    this.createOrUpdateViewStateLocked(id3, state, null);
                }
            }
        }
        if ((authIds = response.getAuthenticationIds()) != null) {
            for (AutofillId id4 : authIds) {
                this.createOrUpdateViewStateLocked(id4, state, null);
            }
        }
    }

    private void setViewStatesLocked(FillResponse response, Dataset dataset, int state, boolean clearResponse) {
        ArrayList<AutofillId> ids = dataset.getFieldIds();
        ArrayList<AutofillValue> values = dataset.getFieldValues();
        for (int j = 0; j < ids.size(); ++j) {
            AutofillId id2 = ids.get(j);
            AutofillValue value = values.get(j);
            ViewState viewState = this.createOrUpdateViewStateLocked(id2, state, value);
            if (response != null) {
                viewState.setResponse(response);
                continue;
            }
            if (!clearResponse) continue;
            viewState.setResponse(null);
        }
    }

    private ViewState createOrUpdateViewStateLocked(AutofillId id2, int state, AutofillValue value) {
        ViewState viewState = this.mViewStates.get(id2);
        if (viewState != null) {
            viewState.setState(state);
        } else {
            viewState = new ViewState(this, id2, this, state);
            if (Helper.sVerbose) {
                Slog.v(TAG, "Adding autofillable view with id " + id2 + " and state " + state);
            }
            this.mViewStates.put(id2, viewState);
        }
        if ((state & 4) != 0) {
            viewState.setAutofilledValue(value);
        }
        return viewState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoFill(int requestId, int datasetIndex, Dataset dataset, boolean generateEvent) {
        if (Helper.sDebug) {
            Slog.d(TAG, "autoFill(): requestId=" + requestId + "; datasetIdx=" + datasetIndex + "; dataset=" + dataset);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#autoFill() rejected - session: " + this.id + " destroyed");
                return;
            }
            if (dataset.getAuthentication() == null) {
                if (generateEvent) {
                    this.mService.logDatasetSelected(dataset.getId(), this.id);
                }
                this.autoFillApp(dataset);
                return;
            }
            this.mService.logDatasetAuthenticationSelected(dataset.getId(), this.id);
            this.setViewStatesLocked(null, dataset, 64, false);
            Intent fillInIntent = this.createAuthFillInIntentLocked(requestId, this.mClientState);
            if (fillInIntent == null) {
                this.forceRemoveSelfLocked();
                return;
            }
            int authenticationId = AutofillManager.makeAuthenticationId(requestId, datasetIndex);
            this.startAuthentication(authenticationId, dataset.getAuthentication(), fillInIntent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharSequence getServiceName() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mService.getServiceName();
        }
    }

    private Intent createAuthFillInIntentLocked(int requestId, Bundle extras) {
        Intent fillInIntent = new Intent();
        FillContext context = this.getFillContextByRequestIdLocked(requestId);
        if (context == null) {
            Slog.wtf(TAG, "createAuthFillInIntentLocked(): no FillContext. requestId=" + requestId + "; mContexts= " + this.mContexts);
            return null;
        }
        fillInIntent.putExtra("android.view.autofill.extra.ASSIST_STRUCTURE", context.getStructure());
        fillInIntent.putExtra("android.view.autofill.extra.CLIENT_STATE", extras);
        return fillInIntent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAuthentication(int authenticationId, IntentSender intent, Intent fillInIntent) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mClient.authenticate(this.id, authenticationId, intent, fillInIntent);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Error launching auth intent", e);
        }
    }

    public String toString() {
        return "Session: [id=" + this.id + ", pkg=" + this.mPackageName + "]";
    }

    void dumpLocked(String prefix, PrintWriter pw) {
        String prefix2 = prefix + "  ";
        pw.print(prefix);
        pw.print("id: ");
        pw.println(this.id);
        pw.print(prefix);
        pw.print("uid: ");
        pw.println(this.uid);
        pw.print(prefix);
        pw.print("mPackagename: ");
        pw.println(this.mPackageName);
        pw.print(prefix);
        pw.print("mActivityToken: ");
        pw.println(this.mActivityToken);
        pw.print(prefix);
        pw.print("mStartTime: ");
        pw.println(this.mStartTime);
        pw.print(prefix);
        pw.print("Time to show UI: ");
        if (this.mUiShownTime == 0L) {
            pw.println("N/A");
        } else {
            TimeUtils.formatDuration(this.mUiShownTime - this.mStartTime, pw);
            pw.println();
        }
        pw.print(prefix);
        pw.print("mResponses: ");
        if (this.mResponses == null) {
            pw.println("null");
        } else {
            pw.println(this.mResponses.size());
            for (int i = 0; i < this.mResponses.size(); ++i) {
                pw.print(prefix2);
                pw.print('#');
                pw.print(i);
                pw.print(' ');
                pw.println(this.mResponses.valueAt(i));
            }
        }
        pw.print(prefix);
        pw.print("mCurrentViewId: ");
        pw.println(this.mCurrentViewId);
        pw.print(prefix);
        pw.print("mViewStates size: ");
        pw.println(this.mViewStates.size());
        pw.print(prefix);
        pw.print("mDestroyed: ");
        pw.println(this.mDestroyed);
        pw.print(prefix);
        pw.print("mIsSaving: ");
        pw.println(this.mIsSaving);
        pw.print(prefix);
        pw.print("mPendingSaveUi: ");
        pw.println(this.mPendingSaveUi);
        for (Map.Entry<AutofillId, ViewState> entry : this.mViewStates.entrySet()) {
            pw.print(prefix);
            pw.print("State for id ");
            pw.println(entry.getKey());
            entry.getValue().dump(prefix2, pw);
        }
        pw.print(prefix);
        pw.print("mContexts: ");
        if (this.mContexts != null) {
            int numContexts = this.mContexts.size();
            for (int i = 0; i < numContexts; ++i) {
                FillContext context = this.mContexts.get(i);
                pw.print(prefix2);
                pw.print(context);
                if (!Helper.sVerbose) continue;
                pw.println(context.getStructure() + " (look at logcat)");
                context.getStructure().dump(false);
            }
        } else {
            pw.println("null");
        }
        pw.print(prefix);
        pw.print("mHasCallback: ");
        pw.println(this.mHasCallback);
        pw.print(prefix);
        pw.print("mClientState: ");
        pw.println(Helper.bundleToString(this.mClientState));
        this.mRemoteFillService.dump(prefix, pw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoFillApp(Dataset dataset) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                Slog.w(TAG, "Call to Session#autoFillApp() rejected - session: " + this.id + " destroyed");
                return;
            }
            try {
                int entryCount = dataset.getFieldIds().size();
                ArrayList<AutofillId> ids = new ArrayList<AutofillId>(entryCount);
                ArrayList<AutofillValue> values = new ArrayList<AutofillValue>(entryCount);
                boolean waitingDatasetAuth = false;
                for (int i = 0; i < entryCount; ++i) {
                    if (dataset.getFieldValues().get(i) == null) continue;
                    AutofillId viewId = dataset.getFieldIds().get(i);
                    ids.add(viewId);
                    values.add(dataset.getFieldValues().get(i));
                    ViewState viewState = this.mViewStates.get(viewId);
                    if (viewState == null || (viewState.getState() & 0x40) == 0) continue;
                    if (Helper.sVerbose) {
                        Slog.v(TAG, "autofillApp(): view " + viewId + " waiting auth");
                    }
                    waitingDatasetAuth = true;
                    viewState.resetState(64);
                }
                if (!ids.isEmpty()) {
                    if (waitingDatasetAuth) {
                        this.mUi.hideFillUi(this);
                    }
                    if (Helper.sDebug) {
                        Slog.d(TAG, "autoFillApp(): the buck is on the app: " + dataset);
                    }
                    this.mClient.autofill(this.id, ids, values);
                    this.setViewStatesLocked(null, dataset, 4, false);
                }
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Error autofilling activity: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AutoFillUI getUiForShowing() {
        Object object = this.mLock;
        synchronized (object) {
            this.mUi.setCallback(this);
            return this.mUi;
        }
    }

    RemoteFillService destroyLocked() {
        if (this.mDestroyed) {
            return null;
        }
        this.mUi.destroyAll(this.mPendingSaveUi, this, true);
        this.mUi.clearCallback(this);
        this.mDestroyed = true;
        this.writeLog(919);
        return this.mRemoteFillService;
    }

    void forceRemoveSelfLocked() {
        if (Helper.sVerbose) {
            Slog.v(TAG, "forceRemoveSelfLocked(): " + this.mPendingSaveUi);
        }
        boolean isPendingSaveUi = this.isSaveUiPendingLocked();
        this.mPendingSaveUi = null;
        this.removeSelfLocked();
        this.mUi.destroyAll(this.mPendingSaveUi, this, false);
        if (!isPendingSaveUi) {
            try {
                this.mClient.setSessionFinished(0);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error notifying client to finish session", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSelf() {
        Object object = this.mLock;
        synchronized (object) {
            this.removeSelfLocked();
        }
    }

    void removeSelfLocked() {
        if (Helper.sVerbose) {
            Slog.v(TAG, "removeSelfLocked(): " + this.mPendingSaveUi);
        }
        if (this.mDestroyed) {
            Slog.w(TAG, "Call to Session#removeSelfLocked() rejected - session: " + this.id + " destroyed");
            return;
        }
        if (this.isSaveUiPendingLocked()) {
            Slog.i(TAG, "removeSelfLocked() ignored, waiting for pending save ui");
            return;
        }
        RemoteFillService remoteFillService = this.destroyLocked();
        this.mService.removeSessionLocked(this.id);
        if (remoteFillService != null) {
            remoteFillService.destroy();
        }
    }

    void onPendingSaveUi(int operation, IBinder token) {
        this.getUiForShowing().onPendingSaveUi(operation, token);
    }

    boolean isSaveUiPendingForTokenLocked(IBinder token) {
        return this.isSaveUiPendingLocked() && token.equals(this.mPendingSaveUi.getToken());
    }

    private boolean isSaveUiPendingLocked() {
        return this.mPendingSaveUi != null && this.mPendingSaveUi.getState() == 2;
    }

    private int getLastResponseIndexLocked() {
        int lastResponseIdx = -1;
        int lastResponseId = -1;
        if (this.mResponses != null) {
            int responseCount = this.mResponses.size();
            for (int i = 0; i < responseCount; ++i) {
                if (this.mResponses.keyAt(i) <= lastResponseId) continue;
                lastResponseIdx = i;
            }
        }
        return lastResponseIdx;
    }

    private LogMaker newLogMaker(int category) {
        return this.newLogMaker(category, this.mService.getServicePackageName());
    }

    private LogMaker newLogMaker(int category, String servicePackageName) {
        return Helper.newLogMaker(category, this.mPackageName, servicePackageName);
    }

    private void writeLog(int category) {
        this.mMetricsLogger.write(this.newLogMaker(category));
    }
}

