/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.appwidget;

import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.KeyguardManager;
import android.app.PendingIntent;
import android.app.admin.DevicePolicyManagerInternal;
import android.appwidget.AppWidgetProviderInfo;
import android.appwidget.PendingHostUpdate;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.ShortcutServiceInternal;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.AttributeSet;
import android.util.LongSparseArray;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import android.util.TypedValue;
import android.util.Xml;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.WindowManager;
import android.widget.RemoteViews;
import com.android.internal.R;
import com.android.internal.app.UnlaunchableAppActivity;
import com.android.internal.appwidget.IAppWidgetHost;
import com.android.internal.appwidget.IAppWidgetService;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.widget.IRemoteViewsAdapterConnection;
import com.android.internal.widget.IRemoteViewsFactory;
import com.android.server.LocalServices;
import com.android.server.WidgetBackupProvider;
import com.android.server.policy.IconUtilities;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class AppWidgetServiceImpl
extends IAppWidgetService.Stub
implements WidgetBackupProvider,
DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener {
    private static final String TAG = "AppWidgetServiceImpl";
    private static boolean DEBUG = false;
    private static final String OLD_KEYGUARD_HOST_PACKAGE = "android";
    private static final String NEW_KEYGUARD_HOST_PACKAGE = "com.android.keyguard";
    private static final int KEYGUARD_HOST_ID = 1262836039;
    private static final String STATE_FILENAME = "appwidgets.xml";
    private static final int MIN_UPDATE_PERIOD = DEBUG ? 0 : 1800000;
    private static final int TAG_UNDEFINED = -1;
    private static final int UNKNOWN_UID = -1;
    private static final int LOADED_PROFILE_ID = -1;
    private static final int UNKNOWN_USER_ID = -10;
    private static final int CURRENT_VERSION = 1;
    private static final AtomicLong REQUEST_COUNTER = new AtomicLong();
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            if (DEBUG) {
                Slog.i(AppWidgetServiceImpl.TAG, "Received broadcast: " + action + " on user " + userId);
            }
            if ("android.intent.action.CONFIGURATION_CHANGED".equals(action)) {
                AppWidgetServiceImpl.this.onConfigurationChanged();
            } else if ("android.intent.action.MANAGED_PROFILE_AVAILABLE".equals(action) || "android.intent.action.MANAGED_PROFILE_UNAVAILABLE".equals(action)) {
                Object object = AppWidgetServiceImpl.this.mLock;
                synchronized (object) {
                    AppWidgetServiceImpl.this.reloadWidgetsMaskedState(userId);
                }
            } else if ("android.intent.action.PACKAGES_SUSPENDED".equals(action)) {
                String[] packages = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                AppWidgetServiceImpl.this.updateWidgetPackageSuspensionMaskedState(packages, true, this.getSendingUserId());
            } else if ("android.intent.action.PACKAGES_UNSUSPENDED".equals(action)) {
                String[] packages = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                AppWidgetServiceImpl.this.updateWidgetPackageSuspensionMaskedState(packages, false, this.getSendingUserId());
            } else {
                AppWidgetServiceImpl.this.onPackageBroadcastReceived(intent, userId);
            }
        }
    };
    private final HashMap<Pair<Integer, Intent.FilterComparison>, ServiceConnection> mBoundRemoteViewsServices = new HashMap();
    private final HashMap<Pair<Integer, Intent.FilterComparison>, HashSet<Integer>> mRemoteViewsServicesAppWidgets = new HashMap();
    private final Object mLock = new Object();
    private final ArrayList<Widget> mWidgets = new ArrayList();
    private final ArrayList<Host> mHosts = new ArrayList();
    private final ArrayList<Provider> mProviders = new ArrayList();
    private final ArraySet<Pair<Integer, String>> mPackagesWithBindWidgetPermission = new ArraySet();
    private final SparseIntArray mLoadedUserIds = new SparseIntArray();
    private final SparseArray<ArraySet<String>> mWidgetPackages = new SparseArray();
    private BackupRestoreController mBackupRestoreController;
    private final Context mContext;
    private IPackageManager mPackageManager;
    private AlarmManager mAlarmManager;
    private UserManager mUserManager;
    private AppOpsManager mAppOpsManager;
    private KeyguardManager mKeyguardManager;
    private DevicePolicyManagerInternal mDevicePolicyManagerInternal;
    private SecurityPolicy mSecurityPolicy;
    private Handler mSaveStateHandler;
    private Handler mCallbackHandler;
    private Locale mLocale;
    private final SparseIntArray mNextAppWidgetIds = new SparseIntArray();
    private boolean mSafeMode;
    private int mMaxWidgetBitmapMemory;
    private IconUtilities mIconUtilities;
    private static final int ID_VIEWS_UPDATE = 0;
    private static final int ID_PROVIDER_CHANGED = 1;

    AppWidgetServiceImpl(Context context) {
        this.mContext = context;
    }

    public void onStart() {
        this.mPackageManager = AppGlobals.getPackageManager();
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        this.mAppOpsManager = (AppOpsManager)this.mContext.getSystemService("appops");
        this.mKeyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        this.mDevicePolicyManagerInternal = LocalServices.getService(DevicePolicyManagerInternal.class);
        this.mSaveStateHandler = BackgroundThread.getHandler();
        this.mCallbackHandler = new CallbackHandler(this.mContext.getMainLooper());
        this.mBackupRestoreController = new BackupRestoreController();
        this.mSecurityPolicy = new SecurityPolicy();
        this.mIconUtilities = new IconUtilities(this.mContext);
        this.computeMaximumWidgetBitmapMemory();
        this.registerBroadcastReceiver();
        this.registerOnCrossProfileProvidersChangedListener();
    }

    private void computeMaximumWidgetBitmapMemory() {
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getRealSize(size);
        this.mMaxWidgetBitmapMemory = 6 * size.x * size.y;
    }

    private void registerBroadcastReceiver() {
        IntentFilter configFilter = new IntentFilter();
        configFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, configFilter, null, null);
        IntentFilter packageFilter = new IntentFilter();
        packageFilter.addAction("android.intent.action.PACKAGE_ADDED");
        packageFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        packageFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        packageFilter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, packageFilter, null, null);
        IntentFilter sdFilter = new IntentFilter();
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, sdFilter, null, null);
        IntentFilter offModeFilter = new IntentFilter();
        offModeFilter.addAction("android.intent.action.MANAGED_PROFILE_AVAILABLE");
        offModeFilter.addAction("android.intent.action.MANAGED_PROFILE_UNAVAILABLE");
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, offModeFilter, null, null);
        IntentFilter suspendPackageFilter = new IntentFilter();
        suspendPackageFilter.addAction("android.intent.action.PACKAGES_SUSPENDED");
        suspendPackageFilter.addAction("android.intent.action.PACKAGES_UNSUSPENDED");
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, suspendPackageFilter, null, null);
    }

    private void registerOnCrossProfileProvidersChangedListener() {
        if (this.mDevicePolicyManagerInternal != null) {
            this.mDevicePolicyManagerInternal.addOnCrossProfileWidgetProvidersChangeListener(this);
        }
    }

    public void setSafeMode(boolean safeMode) {
        this.mSafeMode = safeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConfigurationChanged() {
        Locale revised;
        if (DEBUG) {
            Slog.i(TAG, "onConfigurationChanged()");
        }
        if ((revised = Locale.getDefault()) == null || this.mLocale == null || !revised.equals(this.mLocale)) {
            this.mLocale = revised;
            Object object = this.mLock;
            synchronized (object) {
                SparseIntArray changedGroups = null;
                ArrayList<Provider> installedProviders = new ArrayList<Provider>(this.mProviders);
                HashSet<ProviderId> removedProviders = new HashSet<ProviderId>();
                int N = installedProviders.size();
                for (int i = N - 1; i >= 0; --i) {
                    boolean changed;
                    Provider provider = installedProviders.get(i);
                    int userId = provider.getUserId();
                    if (!this.mUserManager.isUserUnlockingOrUnlocked(userId) || this.isProfileWithLockedParent(userId)) continue;
                    this.ensureGroupStateLoadedLocked(userId);
                    if (removedProviders.contains(provider.id) || !(changed = this.updateProvidersForPackageLocked(provider.id.componentName.getPackageName(), provider.getUserId(), removedProviders))) continue;
                    if (changedGroups == null) {
                        changedGroups = new SparseIntArray();
                    }
                    int groupId = this.mSecurityPolicy.getGroupParent(provider.getUserId());
                    changedGroups.put(groupId, groupId);
                }
                if (changedGroups != null) {
                    int groupCount = changedGroups.size();
                    for (int i = 0; i < groupCount; ++i) {
                        int groupId = changedGroups.get(i);
                        this.saveGroupStateAsync(groupId);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPackageBroadcastReceived(Intent intent, int userId) {
        String action = intent.getAction();
        boolean added = false;
        boolean changed = false;
        boolean componentsModified = false;
        String[] pkgList = null;
        if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(action)) {
            pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            added = true;
        } else if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
            pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            added = false;
        } else {
            Uri uri = intent.getData();
            if (uri == null) {
                return;
            }
            String pkgName = uri.getSchemeSpecificPart();
            if (pkgName == null) {
                return;
            }
            pkgList = new String[]{pkgName};
            added = "android.intent.action.PACKAGE_ADDED".equals(action);
            changed = "android.intent.action.PACKAGE_CHANGED".equals(action);
        }
        if (pkgList == null || pkgList.length == 0) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mUserManager.isUserUnlockingOrUnlocked(userId) || this.isProfileWithLockedParent(userId)) {
                return;
            }
            this.ensureGroupStateLoadedLocked(userId, false);
            Bundle extras = intent.getExtras();
            if (added || changed) {
                boolean newPackageAdded = added && (extras == null || !extras.getBoolean("android.intent.extra.REPLACING", false));
                for (String pkgName : pkgList) {
                    int uid;
                    componentsModified |= this.updateProvidersForPackageLocked(pkgName, userId, null);
                    if (!newPackageAdded || userId != 0 || (uid = this.getUidForPackage(pkgName, userId)) < 0) continue;
                    this.resolveHostUidLocked(pkgName, uid);
                }
            } else {
                boolean packageRemovedPermanently;
                boolean bl = packageRemovedPermanently = extras == null || !extras.getBoolean("android.intent.extra.REPLACING", false);
                if (packageRemovedPermanently) {
                    for (String pkgName : pkgList) {
                        componentsModified |= this.removeHostsAndProvidersForPackageLocked(pkgName, userId);
                    }
                }
            }
            if (componentsModified) {
                this.saveGroupStateAsync(userId);
                this.scheduleNotifyGroupHostsForProvidersChangedLocked(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadWidgetsMaskedStateForGroup(int userId) {
        if (!this.mUserManager.isUserUnlockingOrUnlocked(userId)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            int[] profileIds;
            this.reloadWidgetsMaskedState(userId);
            for (int profileId : profileIds = this.mUserManager.getEnabledProfileIds(userId)) {
                this.reloadWidgetsMaskedState(profileId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadWidgetsMaskedState(int userId) {
        long identity = Binder.clearCallingIdentity();
        try {
            UserInfo user = this.mUserManager.getUserInfo(userId);
            boolean lockedProfile = !this.mUserManager.isUserUnlockingOrUnlocked(userId);
            boolean quietProfile = user.isQuietModeEnabled();
            int N = this.mProviders.size();
            for (int i = 0; i < N; ++i) {
                Provider provider = this.mProviders.get(i);
                int providerUserId = provider.getUserId();
                if (providerUserId != userId) continue;
                boolean changed = provider.setMaskedByLockedProfileLocked(lockedProfile);
                changed |= provider.setMaskedByQuietProfileLocked(quietProfile);
                try {
                    boolean suspended;
                    try {
                        suspended = this.mPackageManager.isPackageSuspendedForUser(provider.info.provider.getPackageName(), provider.getUserId());
                    }
                    catch (IllegalArgumentException ex) {
                        suspended = false;
                    }
                    changed |= provider.setMaskedBySuspendedPackageLocked(suspended);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Failed to query application info", e);
                }
                if (!changed) continue;
                if (provider.isMaskedLocked()) {
                    this.maskWidgetsViewsLocked(provider, null);
                    continue;
                }
                this.unmaskWidgetsViewsLocked(provider);
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWidgetPackageSuspensionMaskedState(String[] packagesArray, boolean suspended, int profileId) {
        if (packagesArray == null) {
            return;
        }
        ArraySet<String> packages = new ArraySet<String>(Arrays.asList(packagesArray));
        Object object = this.mLock;
        synchronized (object) {
            int N = this.mProviders.size();
            for (int i = 0; i < N; ++i) {
                Provider provider = this.mProviders.get(i);
                int providerUserId = provider.getUserId();
                if (providerUserId != profileId || !packages.contains(provider.info.provider.getPackageName()) || !provider.setMaskedBySuspendedPackageLocked(suspended)) continue;
                if (provider.isMaskedLocked()) {
                    this.maskWidgetsViewsLocked(provider, null);
                    continue;
                }
                this.unmaskWidgetsViewsLocked(provider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap createMaskedWidgetBitmap(String providerPackage, int providerUserId) {
        long identity = Binder.clearCallingIdentity();
        try {
            Context userContext = this.mContext.createPackageContextAsUser(providerPackage, 0, UserHandle.of(providerUserId));
            PackageManager pm = userContext.getPackageManager();
            Drawable icon = pm.getApplicationInfo(providerPackage, 0).loadUnbadgedIcon(pm);
            Bitmap bitmap = this.mIconUtilities.createIconBitmap(icon);
            return bitmap;
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(TAG, "Fail to get application icon", e);
            Bitmap bitmap = null;
            return bitmap;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private RemoteViews createMaskedWidgetRemoteViews(Bitmap icon, boolean showBadge, PendingIntent onClickIntent) {
        RemoteViews views = new RemoteViews(this.mContext.getPackageName(), 0x1090111);
        if (icon != null) {
            views.setImageViewBitmap(16909463, icon);
        }
        if (!showBadge) {
            views.setViewVisibility(16909464, 4);
        }
        if (onClickIntent != null) {
            views.setOnClickPendingIntent(16909465, onClickIntent);
        }
        return views;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maskWidgetsViewsLocked(Provider provider, Widget targetWidget) {
        int providerUserId;
        int widgetCount = provider.widgets.size();
        if (widgetCount == 0) {
            return;
        }
        String providerPackage = provider.info.provider.getPackageName();
        Bitmap iconBitmap = this.createMaskedWidgetBitmap(providerPackage, providerUserId = provider.getUserId());
        if (iconBitmap == null) {
            return;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            Intent onClickIntent;
            boolean showBadge;
            if (provider.maskedBySuspendedPackage) {
                UserInfo userInfo = this.mUserManager.getUserInfo(providerUserId);
                showBadge = userInfo.isManagedProfile();
                onClickIntent = this.mDevicePolicyManagerInternal.createShowAdminSupportIntent(providerUserId, true);
            } else if (provider.maskedByQuietProfile) {
                showBadge = true;
                onClickIntent = UnlaunchableAppActivity.createInQuietModeDialogIntent(providerUserId);
            } else {
                showBadge = true;
                onClickIntent = this.mKeyguardManager.createConfirmDeviceCredentialIntent(null, null, providerUserId);
                if (onClickIntent != null) {
                    onClickIntent.setFlags(0x10800000);
                }
            }
            for (int j = 0; j < widgetCount; ++j) {
                RemoteViews views;
                Widget widget = provider.widgets.get(j);
                if (targetWidget != null && targetWidget != widget) continue;
                PendingIntent intent = null;
                if (onClickIntent != null) {
                    intent = PendingIntent.getActivity(this.mContext, widget.appWidgetId, onClickIntent, 0x8000000);
                }
                if (!widget.replaceWithMaskedViewsLocked(views = this.createMaskedWidgetRemoteViews(iconBitmap, showBadge, intent))) continue;
                this.scheduleNotifyUpdateAppWidgetLocked(widget, widget.getEffectiveViewsLocked());
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void unmaskWidgetsViewsLocked(Provider provider) {
        int widgetCount = provider.widgets.size();
        for (int j = 0; j < widgetCount; ++j) {
            Widget widget = provider.widgets.get(j);
            if (!widget.clearMaskedViewsLocked()) continue;
            this.scheduleNotifyUpdateAppWidgetLocked(widget, widget.getEffectiveViewsLocked());
        }
    }

    private void resolveHostUidLocked(String pkg, int uid) {
        int N = this.mHosts.size();
        for (int i = 0; i < N; ++i) {
            Host host = this.mHosts.get(i);
            if (host.id.uid != -1 || !pkg.equals(host.id.packageName)) continue;
            if (DEBUG) {
                Slog.i(TAG, "host " + host.id + " resolved to uid " + uid);
            }
            host.id = new HostId(uid, host.id.hostId, host.id.packageName);
            return;
        }
    }

    private void ensureGroupStateLoadedLocked(int userId) {
        this.ensureGroupStateLoadedLocked(userId, true);
    }

    private void ensureGroupStateLoadedLocked(int userId, boolean enforceUserUnlockingOrUnlocked) {
        if (enforceUserUnlockingOrUnlocked && !this.isUserRunningAndUnlocked(userId)) {
            throw new IllegalStateException("User " + userId + " must be unlocked for widgets to be available");
        }
        if (enforceUserUnlockingOrUnlocked && this.isProfileWithLockedParent(userId)) {
            throw new IllegalStateException("Profile " + userId + " must have unlocked parent");
        }
        int[] profileIds = this.mSecurityPolicy.getEnabledGroupProfileIds(userId);
        int newMemberCount = 0;
        int profileIdCount = profileIds.length;
        for (int i = 0; i < profileIdCount; ++i) {
            int profileId = profileIds[i];
            if (this.mLoadedUserIds.indexOfKey(profileId) >= 0) {
                profileIds[i] = -1;
                continue;
            }
            ++newMemberCount;
        }
        if (newMemberCount <= 0) {
            return;
        }
        int newMemberIndex = 0;
        int[] newProfileIds = new int[newMemberCount];
        for (int i = 0; i < profileIdCount; ++i) {
            int profileId = profileIds[i];
            if (profileId == -1) continue;
            this.mLoadedUserIds.put(profileId, profileId);
            newProfileIds[newMemberIndex] = profileId;
            ++newMemberIndex;
        }
        this.clearProvidersAndHostsTagsLocked();
        this.loadGroupWidgetProvidersLocked(newProfileIds);
        this.loadGroupStateLocked(newProfileIds);
    }

    private boolean isUserRunningAndUnlocked(int userId) {
        return this.mUserManager.isUserUnlockingOrUnlocked(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (args.length > 0 && "--proto".equals(args[0])) {
                this.dumpProto(fd);
            } else {
                this.dumpInternal(pw);
            }
        }
    }

    private void dumpProto(FileDescriptor fd) {
        Slog.i(TAG, "dump proto for " + this.mWidgets.size() + " widgets");
        ProtoOutputStream proto = new ProtoOutputStream(fd);
        int N = this.mWidgets.size();
        for (int i = 0; i < N; ++i) {
            this.dumpProtoWidget(proto, this.mWidgets.get(i));
        }
        proto.flush();
    }

    private void dumpProtoWidget(ProtoOutputStream proto, Widget widget) {
        if (widget.host == null || widget.provider == null) {
            Slog.d(TAG, "skip dumping widget because host or provider is null: widget.host=" + widget.host + " widget.provider=" + widget.provider);
            return;
        }
        long token = proto.start(0x21100000001L);
        proto.write(0x10D00000001L, widget.host.getUserId() != widget.provider.getUserId());
        proto.write(1155346202626L, widget.host.callbacks == null);
        proto.write(1159641169923L, widget.host.id.packageName);
        proto.write(1159641169924L, widget.provider.id.componentName.getPackageName());
        proto.write(1159641169925L, widget.provider.id.componentName.getClassName());
        if (widget.options != null) {
            proto.write(1112396529670L, widget.options.getInt("appWidgetMinWidth", 0));
            proto.write(1112396529671L, widget.options.getInt("appWidgetMinHeight", 0));
            proto.write(1112396529672L, widget.options.getInt("appWidgetMaxWidth", 0));
            proto.write(1112396529673L, widget.options.getInt("appWidgetMaxHeight", 0));
        }
        proto.end(token);
    }

    private void dumpInternal(PrintWriter pw) {
        int i;
        int N = this.mProviders.size();
        pw.println("Providers:");
        for (i = 0; i < N; ++i) {
            AppWidgetServiceImpl.dumpProvider(this.mProviders.get(i), i, pw);
        }
        N = this.mWidgets.size();
        pw.println(" ");
        pw.println("Widgets:");
        for (i = 0; i < N; ++i) {
            AppWidgetServiceImpl.dumpWidget(this.mWidgets.get(i), i, pw);
        }
        N = this.mHosts.size();
        pw.println(" ");
        pw.println("Hosts:");
        for (i = 0; i < N; ++i) {
            AppWidgetServiceImpl.dumpHost(this.mHosts.get(i), i, pw);
        }
        N = this.mPackagesWithBindWidgetPermission.size();
        pw.println(" ");
        pw.println("Grants:");
        for (i = 0; i < N; ++i) {
            Pair<Integer, String> grant = this.mPackagesWithBindWidgetPermission.valueAt(i);
            AppWidgetServiceImpl.dumpGrant(grant, i, pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<PendingHostUpdate> startListening(IAppWidgetHost callbacks, String callingPackage, int hostId, int[] appWidgetIds) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "startListening() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            HostId id2 = new HostId(Binder.getCallingUid(), hostId, callingPackage);
            Host host = this.lookupOrAddHostLocked(id2);
            host.callbacks = callbacks;
            int N = appWidgetIds.length;
            ArrayList<PendingHostUpdate> outUpdates = new ArrayList<PendingHostUpdate>(N);
            LongSparseArray<PendingHostUpdate> updatesMap = new LongSparseArray<PendingHostUpdate>();
            for (int i = 0; i < N; ++i) {
                if (!host.getPendingUpdatesForId(appWidgetIds[i], updatesMap)) continue;
                int M = updatesMap.size();
                for (int j = 0; j < M; ++j) {
                    outUpdates.add(updatesMap.valueAt(j));
                }
            }
            return new ParceledListSlice<PendingHostUpdate>(outUpdates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopListening(String callingPackage, int hostId) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "stopListening() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId, false);
            HostId id2 = new HostId(Binder.getCallingUid(), hostId, callingPackage);
            Host host = this.lookupHostLocked(id2);
            if (host != null) {
                host.callbacks = null;
                this.pruneHostLocked(host);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int allocateAppWidgetId(String callingPackage, int hostId) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "allocateAppWidgetId() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            if (this.mNextAppWidgetIds.indexOfKey(userId) < 0) {
                this.mNextAppWidgetIds.put(userId, 1);
            }
            int appWidgetId = this.incrementAndGetAppWidgetIdLocked(userId);
            HostId id2 = new HostId(Binder.getCallingUid(), hostId, callingPackage);
            Host host = this.lookupOrAddHostLocked(id2);
            Widget widget = new Widget();
            widget.appWidgetId = appWidgetId;
            widget.host = host;
            host.widgets.add(widget);
            this.addWidgetLocked(widget);
            this.saveGroupStateAsync(userId);
            if (DEBUG) {
                Slog.i(TAG, "Allocated widget id " + appWidgetId + " for host " + host.id);
            }
            return appWidgetId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAppWidgetId(String callingPackage, int appWidgetId) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "deleteAppWidgetId() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            Widget widget = this.lookupWidgetLocked(appWidgetId, Binder.getCallingUid(), callingPackage);
            if (widget == null) {
                return;
            }
            this.deleteAppWidgetLocked(widget);
            this.saveGroupStateAsync(userId);
            if (DEBUG) {
                Slog.i(TAG, "Deleted widget id " + appWidgetId + " for host " + widget.host.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasBindAppWidgetPermission(String packageName, int grantId) {
        if (DEBUG) {
            Slog.i(TAG, "hasBindAppWidgetPermission() " + UserHandle.getCallingUserId());
        }
        this.mSecurityPolicy.enforceModifyAppWidgetBindPermissions(packageName);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(grantId);
            int packageUid = this.getUidForPackage(packageName, grantId);
            if (packageUid < 0) {
                return false;
            }
            Pair<Integer, String> packageId = Pair.create(grantId, packageName);
            return this.mPackagesWithBindWidgetPermission.contains(packageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBindAppWidgetPermission(String packageName, int grantId, boolean grantPermission) {
        if (DEBUG) {
            Slog.i(TAG, "setBindAppWidgetPermission() " + UserHandle.getCallingUserId());
        }
        this.mSecurityPolicy.enforceModifyAppWidgetBindPermissions(packageName);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(grantId);
            int packageUid = this.getUidForPackage(packageName, grantId);
            if (packageUid < 0) {
                return;
            }
            Pair<Integer, String> packageId = Pair.create(grantId, packageName);
            if (grantPermission) {
                this.mPackagesWithBindWidgetPermission.add(packageId);
            } else {
                this.mPackagesWithBindWidgetPermission.remove(packageId);
            }
            this.saveGroupStateAsync(grantId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntentSender createAppWidgetConfigIntentSender(String callingPackage, int appWidgetId, int intentFlags) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "createAppWidgetConfigIntentSender() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            IntentSender intentSender;
            this.ensureGroupStateLoadedLocked(userId);
            Widget widget = this.lookupWidgetLocked(appWidgetId, Binder.getCallingUid(), callingPackage);
            if (widget == null) {
                throw new IllegalArgumentException("Bad widget id " + appWidgetId);
            }
            Provider provider = widget.provider;
            if (provider == null) {
                throw new IllegalArgumentException("Widget not bound " + appWidgetId);
            }
            int secureFlags = intentFlags & 0xFFFFFF3C;
            Intent intent = new Intent("android.appwidget.action.APPWIDGET_CONFIGURE");
            intent.putExtra("appWidgetId", appWidgetId);
            intent.setComponent(provider.info.configure);
            intent.setFlags(secureFlags);
            long identity = Binder.clearCallingIdentity();
            try {
                intentSender = PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0x54000000, null, new UserHandle(provider.getUserId())).getIntentSender();
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(identity);
                throw throwable;
            }
            Binder.restoreCallingIdentity(identity);
            return intentSender;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bindAppWidgetId(String callingPackage, int appWidgetId, int providerProfileId, ComponentName providerComponent, Bundle options) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "bindAppWidgetId() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        if (!this.mSecurityPolicy.isEnabledGroupProfile(providerProfileId)) {
            return false;
        }
        if (!this.mSecurityPolicy.isProviderInCallerOrInProfileAndWhitelListed(providerComponent.getPackageName(), providerProfileId)) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            if (!this.mSecurityPolicy.hasCallerBindPermissionOrBindWhiteListedLocked(callingPackage)) {
                return false;
            }
            Widget widget = this.lookupWidgetLocked(appWidgetId, Binder.getCallingUid(), callingPackage);
            if (widget == null) {
                Slog.e(TAG, "Bad widget id " + appWidgetId);
                return false;
            }
            if (widget.provider != null) {
                Slog.e(TAG, "Widget id " + appWidgetId + " already bound to: " + widget.provider.id);
                return false;
            }
            int providerUid = this.getUidForPackage(providerComponent.getPackageName(), providerProfileId);
            if (providerUid < 0) {
                Slog.e(TAG, "Package " + providerComponent.getPackageName() + " not installed " + " for profile " + providerProfileId);
                return false;
            }
            ProviderId providerId = new ProviderId(providerUid, providerComponent);
            Provider provider = this.lookupProviderLocked(providerId);
            if (provider == null) {
                Slog.e(TAG, "No widget provider " + providerComponent + " for profile " + providerProfileId);
                return false;
            }
            if (provider.zombie) {
                Slog.e(TAG, "Can't bind to a 3rd party provider in safe mode " + provider);
                return false;
            }
            widget.provider = provider;
            Bundle bundle = widget.options = options != null ? AppWidgetServiceImpl.cloneIfLocalBinder(options) : new Bundle();
            if (!widget.options.containsKey("appWidgetCategory")) {
                widget.options.putInt("appWidgetCategory", 1);
            }
            provider.widgets.add(widget);
            this.onWidgetProviderAddedOrChangedLocked(widget);
            int widgetCount = provider.widgets.size();
            if (widgetCount == 1) {
                this.sendEnableIntentLocked(provider);
            }
            this.sendUpdateIntentLocked(provider, new int[]{appWidgetId});
            this.registerForBroadcastsLocked(provider, AppWidgetServiceImpl.getWidgetIds(provider.widgets));
            this.saveGroupStateAsync(userId);
            if (DEBUG) {
                Slog.i(TAG, "Bound widget " + appWidgetId + " to provider " + provider.id);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getAppWidgetIds(ComponentName componentName) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "getAppWidgetIds() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(componentName.getPackageName());
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            ProviderId providerId = new ProviderId(Binder.getCallingUid(), componentName);
            Provider provider = this.lookupProviderLocked(providerId);
            if (provider != null) {
                return AppWidgetServiceImpl.getWidgetIds(provider.widgets);
            }
            return new int[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getAppWidgetIdsForHost(String callingPackage, int hostId) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "getAppWidgetIdsForHost() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            HostId id2 = new HostId(Binder.getCallingUid(), hostId, callingPackage);
            Host host = this.lookupHostLocked(id2);
            if (host != null) {
                return AppWidgetServiceImpl.getWidgetIds(host.widgets);
            }
            return new int[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindRemoteViewsService(String callingPackage, int appWidgetId, Intent intent, IBinder callbacks) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "bindRemoteViewsService() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            Widget widget = this.lookupWidgetLocked(appWidgetId, Binder.getCallingUid(), callingPackage);
            if (widget == null) {
                throw new IllegalArgumentException("Bad widget id");
            }
            if (widget.provider == null) {
                throw new IllegalArgumentException("No provider for widget " + appWidgetId);
            }
            ComponentName componentName = intent.getComponent();
            String providerPackage = widget.provider.id.componentName.getPackageName();
            String servicePackage = componentName.getPackageName();
            if (!servicePackage.equals(providerPackage)) {
                throw new SecurityException("The taget service not in the same package as the widget provider");
            }
            this.mSecurityPolicy.enforceServiceExistsAndRequiresBindRemoteViewsPermission(componentName, widget.provider.getUserId());
            ServiceConnectionProxy connection = null;
            Intent.FilterComparison fc = new Intent.FilterComparison(intent);
            Pair<Integer, Intent.FilterComparison> key = Pair.create(appWidgetId, fc);
            if (this.mBoundRemoteViewsServices.containsKey(key)) {
                connection = (ServiceConnectionProxy)this.mBoundRemoteViewsServices.get(key);
                connection.disconnect();
                this.unbindService(connection);
                this.mBoundRemoteViewsServices.remove(key);
            }
            connection = new ServiceConnectionProxy(callbacks);
            this.bindService(intent, connection, widget.provider.info.getProfile());
            this.mBoundRemoteViewsServices.put(key, connection);
            Pair<Integer, Intent.FilterComparison> serviceId = Pair.create(widget.provider.id.uid, fc);
            this.incrementAppWidgetServiceRefCount(appWidgetId, serviceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindRemoteViewsService(String callingPackage, int appWidgetId, Intent intent) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "unbindRemoteViewsService() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            Pair<Integer, Intent.FilterComparison> key = Pair.create(appWidgetId, new Intent.FilterComparison(intent));
            if (this.mBoundRemoteViewsServices.containsKey(key)) {
                Widget widget = this.lookupWidgetLocked(appWidgetId, Binder.getCallingUid(), callingPackage);
                if (widget == null) {
                    throw new IllegalArgumentException("Bad widget id " + appWidgetId);
                }
                ServiceConnectionProxy connection = (ServiceConnectionProxy)this.mBoundRemoteViewsServices.get(key);
                connection.disconnect();
                this.mContext.unbindService(connection);
                this.mBoundRemoteViewsServices.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteHost(String callingPackage, int hostId) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "deleteHost() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            HostId id2 = new HostId(Binder.getCallingUid(), hostId, callingPackage);
            Host host = this.lookupHostLocked(id2);
            if (host == null) {
                return;
            }
            this.deleteHostLocked(host);
            this.saveGroupStateAsync(userId);
            if (DEBUG) {
                Slog.i(TAG, "Deleted host " + host.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllHosts() {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "deleteAllHosts() " + userId);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            boolean changed = false;
            int N = this.mHosts.size();
            for (int i = N - 1; i >= 0; --i) {
                Host host = this.mHosts.get(i);
                if (host.id.uid != Binder.getCallingUid()) continue;
                this.deleteHostLocked(host);
                changed = true;
                if (!DEBUG) continue;
                Slog.i(TAG, "Deleted host " + host.id);
            }
            if (changed) {
                this.saveGroupStateAsync(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppWidgetProviderInfo getAppWidgetInfo(String callingPackage, int appWidgetId) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "getAppWidgetInfo() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            Widget widget = this.lookupWidgetLocked(appWidgetId, Binder.getCallingUid(), callingPackage);
            if (widget != null && widget.provider != null && !widget.provider.zombie) {
                return AppWidgetServiceImpl.cloneIfLocalBinder(widget.provider.info);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteViews getAppWidgetViews(String callingPackage, int appWidgetId) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "getAppWidgetViews() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            Widget widget = this.lookupWidgetLocked(appWidgetId, Binder.getCallingUid(), callingPackage);
            if (widget != null) {
                return AppWidgetServiceImpl.cloneIfLocalBinder(widget.getEffectiveViewsLocked());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAppWidgetOptions(String callingPackage, int appWidgetId, Bundle options) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "updateAppWidgetOptions() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            Widget widget = this.lookupWidgetLocked(appWidgetId, Binder.getCallingUid(), callingPackage);
            if (widget == null) {
                return;
            }
            widget.options.putAll(options);
            this.sendOptionsChangedIntentLocked(widget);
            this.saveGroupStateAsync(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getAppWidgetOptions(String callingPackage, int appWidgetId) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "getAppWidgetOptions() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            Widget widget = this.lookupWidgetLocked(appWidgetId, Binder.getCallingUid(), callingPackage);
            if (widget != null && widget.options != null) {
                return AppWidgetServiceImpl.cloneIfLocalBinder(widget.options);
            }
            return Bundle.EMPTY;
        }
    }

    @Override
    public void updateAppWidgetIds(String callingPackage, int[] appWidgetIds, RemoteViews views) {
        if (DEBUG) {
            Slog.i(TAG, "updateAppWidgetIds() " + UserHandle.getCallingUserId());
        }
        this.updateAppWidgetIds(callingPackage, appWidgetIds, views, false);
    }

    @Override
    public void partiallyUpdateAppWidgetIds(String callingPackage, int[] appWidgetIds, RemoteViews views) {
        if (DEBUG) {
            Slog.i(TAG, "partiallyUpdateAppWidgetIds() " + UserHandle.getCallingUserId());
        }
        this.updateAppWidgetIds(callingPackage, appWidgetIds, views, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAppWidgetViewDataChanged(String callingPackage, int[] appWidgetIds, int viewId) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "notifyAppWidgetViewDataChanged() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        if (appWidgetIds == null || appWidgetIds.length == 0) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            for (int appWidgetId : appWidgetIds) {
                Widget widget = this.lookupWidgetLocked(appWidgetId, Binder.getCallingUid(), callingPackage);
                if (widget == null) continue;
                this.scheduleNotifyAppWidgetViewDataChanged(widget, viewId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAppWidgetProvider(ComponentName componentName, RemoteViews views) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "updateAppWidgetProvider() " + userId);
        }
        this.mSecurityPolicy.enforceCallFromPackage(componentName.getPackageName());
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            ProviderId providerId = new ProviderId(Binder.getCallingUid(), componentName);
            Provider provider = this.lookupProviderLocked(providerId);
            if (provider == null) {
                Slog.w(TAG, "Provider doesn't exist " + providerId);
                return;
            }
            ArrayList<Widget> instances = provider.widgets;
            int N = instances.size();
            for (int i = 0; i < N; ++i) {
                Widget widget = instances.get(i);
                this.updateAppWidgetInstanceLocked(widget, views, false);
            }
        }
    }

    @Override
    public boolean isRequestPinAppWidgetSupported() {
        return LocalServices.getService(ShortcutServiceInternal.class).isRequestPinItemSupported(UserHandle.getCallingUserId(), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestPinAppWidget(String callingPackage, ComponentName componentName, Bundle extras, IntentSender resultSender) {
        AppWidgetProviderInfo info;
        int callingUid = Binder.getCallingUid();
        int userId = UserHandle.getUserId(callingUid);
        if (DEBUG) {
            Slog.i(TAG, "requestPinAppWidget() " + userId);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            Provider provider = this.lookupProviderLocked(new ProviderId(callingUid, componentName));
            if (provider == null || provider.zombie) {
                return false;
            }
            info = provider.info;
            if ((info.widgetCategory & 1) == 0) {
                return false;
            }
        }
        return LocalServices.getService(ShortcutServiceInternal.class).requestPinAppWidget(callingPackage, info, extras, resultSender, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<AppWidgetProviderInfo> getInstalledProvidersForProfile(int categoryFilter, int profileId, String packageName) {
        int userId = UserHandle.getCallingUserId();
        if (DEBUG) {
            Slog.i(TAG, "getInstalledProvidersForProfiles() " + userId);
        }
        if (!this.mSecurityPolicy.isEnabledGroupProfile(profileId)) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            ArrayList<AppWidgetProviderInfo> result = new ArrayList<AppWidgetProviderInfo>();
            int providerCount = this.mProviders.size();
            for (int i = 0; i < providerCount; ++i) {
                int providerProfileId;
                boolean inPackage;
                Provider provider = this.mProviders.get(i);
                AppWidgetProviderInfo info = provider.info;
                boolean bl = inPackage = packageName == null || provider.id.componentName.getPackageName().equals(packageName);
                if (provider.zombie || (info.widgetCategory & categoryFilter) == 0 || !inPackage || (providerProfileId = info.getProfile().getIdentifier()) != profileId || !this.mSecurityPolicy.isProviderInCallerOrInProfileAndWhitelListed(provider.id.componentName.getPackageName(), providerProfileId)) continue;
                result.add(AppWidgetServiceImpl.cloneIfLocalBinder(info));
            }
            return new ParceledListSlice<AppWidgetProviderInfo>(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAppWidgetIds(String callingPackage, int[] appWidgetIds, RemoteViews views, boolean partially) {
        int userId = UserHandle.getCallingUserId();
        if (appWidgetIds == null || appWidgetIds.length == 0) {
            return;
        }
        this.mSecurityPolicy.enforceCallFromPackage(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureGroupStateLoadedLocked(userId);
            for (int appWidgetId : appWidgetIds) {
                Widget widget = this.lookupWidgetLocked(appWidgetId, Binder.getCallingUid(), callingPackage);
                if (widget == null) continue;
                this.updateAppWidgetInstanceLocked(widget, views, partially);
            }
        }
    }

    private int incrementAndGetAppWidgetIdLocked(int userId) {
        int appWidgetId = this.peekNextAppWidgetIdLocked(userId) + 1;
        this.mNextAppWidgetIds.put(userId, appWidgetId);
        return appWidgetId;
    }

    private void setMinAppWidgetIdLocked(int userId, int minWidgetId) {
        int nextAppWidgetId = this.peekNextAppWidgetIdLocked(userId);
        if (nextAppWidgetId < minWidgetId) {
            this.mNextAppWidgetIds.put(userId, minWidgetId);
        }
    }

    private int peekNextAppWidgetIdLocked(int userId) {
        if (this.mNextAppWidgetIds.indexOfKey(userId) < 0) {
            return 1;
        }
        return this.mNextAppWidgetIds.get(userId);
    }

    private Host lookupOrAddHostLocked(HostId id2) {
        Host host = this.lookupHostLocked(id2);
        if (host != null) {
            return host;
        }
        host = new Host();
        host.id = id2;
        this.mHosts.add(host);
        return host;
    }

    private void deleteHostLocked(Host host) {
        int N = host.widgets.size();
        for (int i = N - 1; i >= 0; --i) {
            Widget widget = host.widgets.remove(i);
            this.deleteAppWidgetLocked(widget);
        }
        this.mHosts.remove(host);
        host.callbacks = null;
    }

    private void deleteAppWidgetLocked(Widget widget) {
        this.unbindAppWidgetRemoteViewsServicesLocked(widget);
        Host host = widget.host;
        host.widgets.remove(widget);
        this.pruneHostLocked(host);
        this.removeWidgetLocked(widget);
        Provider provider = widget.provider;
        if (provider != null) {
            provider.widgets.remove(widget);
            if (!provider.zombie) {
                this.sendDeletedIntentLocked(widget);
                if (provider.widgets.isEmpty()) {
                    this.cancelBroadcasts(provider);
                    this.sendDisabledIntentLocked(provider);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelBroadcasts(Provider provider) {
        if (DEBUG) {
            Slog.i(TAG, "cancelBroadcasts() for " + provider);
        }
        if (provider.broadcast != null) {
            this.mAlarmManager.cancel(provider.broadcast);
            long token = Binder.clearCallingIdentity();
            try {
                provider.broadcast.cancel();
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            provider.broadcast = null;
        }
    }

    private void unbindAppWidgetRemoteViewsServicesLocked(Widget widget) {
        int appWidgetId = widget.appWidgetId;
        Iterator<Pair<Integer, Intent.FilterComparison>> it = this.mBoundRemoteViewsServices.keySet().iterator();
        while (it.hasNext()) {
            Pair<Integer, Intent.FilterComparison> key = it.next();
            if ((Integer)key.first != appWidgetId) continue;
            ServiceConnectionProxy conn = (ServiceConnectionProxy)this.mBoundRemoteViewsServices.get(key);
            conn.disconnect();
            this.mContext.unbindService(conn);
            it.remove();
        }
        this.decrementAppWidgetServiceRefCount(widget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyRemoteViewsService(final Intent intent, Widget widget) {
        ServiceConnection conn = new ServiceConnection(){

            @Override
            public void onServiceConnected(ComponentName name, IBinder service) {
                IRemoteViewsFactory cb = IRemoteViewsFactory.Stub.asInterface(service);
                try {
                    cb.onDestroy(intent);
                }
                catch (RemoteException re) {
                    Slog.e(AppWidgetServiceImpl.TAG, "Error calling remove view factory", re);
                }
                AppWidgetServiceImpl.this.mContext.unbindService(this);
            }

            @Override
            public void onServiceDisconnected(ComponentName name) {
            }
        };
        long token = Binder.clearCallingIdentity();
        try {
            this.mContext.bindServiceAsUser(intent, conn, 0x2000001, widget.provider.info.getProfile());
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void incrementAppWidgetServiceRefCount(int appWidgetId, Pair<Integer, Intent.FilterComparison> serviceId) {
        HashSet<Object> appWidgetIds = null;
        if (this.mRemoteViewsServicesAppWidgets.containsKey(serviceId)) {
            appWidgetIds = this.mRemoteViewsServicesAppWidgets.get(serviceId);
        } else {
            appWidgetIds = new HashSet();
            this.mRemoteViewsServicesAppWidgets.put(serviceId, appWidgetIds);
        }
        appWidgetIds.add(appWidgetId);
    }

    private void decrementAppWidgetServiceRefCount(Widget widget) {
        Iterator<Pair<Integer, Intent.FilterComparison>> it = this.mRemoteViewsServicesAppWidgets.keySet().iterator();
        while (it.hasNext()) {
            Pair<Integer, Intent.FilterComparison> key = it.next();
            HashSet<Integer> ids = this.mRemoteViewsServicesAppWidgets.get(key);
            if (!ids.remove(widget.appWidgetId) || !ids.isEmpty()) continue;
            this.destroyRemoteViewsService(((Intent.FilterComparison)key.second).getIntent(), widget);
            it.remove();
        }
    }

    private void saveGroupStateAsync(int groupId) {
        this.mSaveStateHandler.post(new SaveStateRunnable(groupId));
    }

    private void updateAppWidgetInstanceLocked(Widget widget, RemoteViews views, boolean isPartialUpdate) {
        if (widget != null && widget.provider != null && !widget.provider.zombie && !widget.host.zombie) {
            int memoryUsage;
            if (isPartialUpdate && widget.views != null) {
                widget.views.mergeRemoteViews(views);
            } else {
                widget.views = views;
            }
            if (UserHandle.getAppId(Binder.getCallingUid()) != 1000 && widget.views != null && (memoryUsage = widget.views.estimateMemoryUsage()) > this.mMaxWidgetBitmapMemory) {
                widget.views = null;
                throw new IllegalArgumentException("RemoteViews for widget update exceeds maximum bitmap memory usage (used: " + memoryUsage + ", max: " + this.mMaxWidgetBitmapMemory + ")");
            }
            this.scheduleNotifyUpdateAppWidgetLocked(widget, widget.getEffectiveViewsLocked());
        }
    }

    private void scheduleNotifyAppWidgetViewDataChanged(Widget widget, int viewId) {
        if (viewId == 0 || viewId == 1) {
            return;
        }
        long requestId = REQUEST_COUNTER.incrementAndGet();
        if (widget != null) {
            widget.updateRequestIds.put(viewId, requestId);
        }
        if (widget == null || widget.host == null || widget.host.zombie || widget.host.callbacks == null || widget.provider == null || widget.provider.zombie) {
            return;
        }
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = widget.host;
        args.arg2 = widget.host.callbacks;
        args.arg3 = requestId;
        args.argi1 = widget.appWidgetId;
        args.argi2 = viewId;
        this.mCallbackHandler.obtainMessage(4, args).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotifyAppWidgetViewDataChanged(Host host, IAppWidgetHost callbacks, int appWidgetId, int viewId, long requestId) {
        try {
            callbacks.viewDataChanged(appWidgetId, viewId);
            host.lastWidgetUpdateRequestId = requestId;
        }
        catch (RemoteException re) {
            callbacks = null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (callbacks == null) {
                host.callbacks = null;
                Set<Pair<Integer, Intent.FilterComparison>> keys = this.mRemoteViewsServicesAppWidgets.keySet();
                for (Pair<Integer, Intent.FilterComparison> key : keys) {
                    if (!this.mRemoteViewsServicesAppWidgets.get(key).contains(appWidgetId)) continue;
                    ServiceConnection connection = new ServiceConnection(){

                        @Override
                        public void onServiceConnected(ComponentName name, IBinder service) {
                            IRemoteViewsFactory cb = IRemoteViewsFactory.Stub.asInterface(service);
                            try {
                                cb.onDataSetChangedAsync();
                            }
                            catch (RemoteException e) {
                                Slog.e(AppWidgetServiceImpl.TAG, "Error calling onDataSetChangedAsync()", e);
                            }
                            AppWidgetServiceImpl.this.mContext.unbindService(this);
                        }

                        @Override
                        public void onServiceDisconnected(ComponentName name) {
                        }
                    };
                    int userId = UserHandle.getUserId((Integer)key.first);
                    Intent intent = ((Intent.FilterComparison)key.second).getIntent();
                    this.bindService(intent, connection, new UserHandle(userId));
                }
            }
        }
    }

    private void scheduleNotifyUpdateAppWidgetLocked(Widget widget, RemoteViews updateViews) {
        long requestId = REQUEST_COUNTER.incrementAndGet();
        if (widget != null) {
            widget.updateRequestIds.put(0, requestId);
        }
        if (widget == null || widget.provider == null || widget.provider.zombie || widget.host.callbacks == null || widget.host.zombie) {
            return;
        }
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = widget.host;
        args.arg2 = widget.host.callbacks;
        args.arg3 = updateViews != null ? updateViews.clone() : null;
        args.arg4 = requestId;
        args.argi1 = widget.appWidgetId;
        this.mCallbackHandler.obtainMessage(1, args).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotifyUpdateAppWidget(Host host, IAppWidgetHost callbacks, int appWidgetId, RemoteViews views, long requestId) {
        try {
            callbacks.updateAppWidget(appWidgetId, views);
            host.lastWidgetUpdateRequestId = requestId;
        }
        catch (RemoteException re) {
            Object object = this.mLock;
            synchronized (object) {
                Slog.e(TAG, "Widget host dead: " + host.id, re);
                host.callbacks = null;
            }
        }
    }

    private void scheduleNotifyProviderChangedLocked(Widget widget) {
        long requestId = REQUEST_COUNTER.incrementAndGet();
        if (widget != null) {
            widget.updateRequestIds.clear();
            widget.updateRequestIds.append(1, requestId);
        }
        if (widget == null || widget.provider == null || widget.provider.zombie || widget.host.callbacks == null || widget.host.zombie) {
            return;
        }
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = widget.host;
        args.arg2 = widget.host.callbacks;
        args.arg3 = widget.provider.info;
        args.arg4 = requestId;
        args.argi1 = widget.appWidgetId;
        this.mCallbackHandler.obtainMessage(2, args).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotifyProviderChanged(Host host, IAppWidgetHost callbacks, int appWidgetId, AppWidgetProviderInfo info, long requestId) {
        try {
            callbacks.providerChanged(appWidgetId, info);
            host.lastWidgetUpdateRequestId = requestId;
        }
        catch (RemoteException re) {
            Object object = this.mLock;
            synchronized (object) {
                Slog.e(TAG, "Widget host dead: " + host.id, re);
                host.callbacks = null;
            }
        }
    }

    private void scheduleNotifyGroupHostsForProvidersChangedLocked(int userId) {
        int[] profileIds = this.mSecurityPolicy.getEnabledGroupProfileIds(userId);
        int N = this.mHosts.size();
        for (int i = N - 1; i >= 0; --i) {
            Host host = this.mHosts.get(i);
            boolean hostInGroup = false;
            for (int profileId : profileIds) {
                if (host.getUserId() != profileId) continue;
                hostInGroup = true;
                break;
            }
            if (!hostInGroup || host == null || host.zombie || host.callbacks == null) continue;
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = host;
            args.arg2 = host.callbacks;
            this.mCallbackHandler.obtainMessage(3, args).sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotifyProvidersChanged(Host host, IAppWidgetHost callbacks) {
        try {
            callbacks.providersChanged();
        }
        catch (RemoteException re) {
            Object object = this.mLock;
            synchronized (object) {
                Slog.e(TAG, "Widget host dead: " + host.id, re);
                host.callbacks = null;
            }
        }
    }

    private static boolean isLocalBinder() {
        return Process.myPid() == Binder.getCallingPid();
    }

    private static RemoteViews cloneIfLocalBinder(RemoteViews rv) {
        if (AppWidgetServiceImpl.isLocalBinder() && rv != null) {
            return rv.clone();
        }
        return rv;
    }

    private static AppWidgetProviderInfo cloneIfLocalBinder(AppWidgetProviderInfo info) {
        if (AppWidgetServiceImpl.isLocalBinder() && info != null) {
            return info.clone();
        }
        return info;
    }

    private static Bundle cloneIfLocalBinder(Bundle bundle) {
        if (AppWidgetServiceImpl.isLocalBinder() && bundle != null) {
            return (Bundle)bundle.clone();
        }
        return bundle;
    }

    private Widget lookupWidgetLocked(int appWidgetId, int uid, String packageName) {
        int N = this.mWidgets.size();
        for (int i = 0; i < N; ++i) {
            Widget widget = this.mWidgets.get(i);
            if (widget.appWidgetId != appWidgetId || !this.mSecurityPolicy.canAccessAppWidget(widget, uid, packageName)) continue;
            return widget;
        }
        return null;
    }

    private Provider lookupProviderLocked(ProviderId id2) {
        int N = this.mProviders.size();
        for (int i = 0; i < N; ++i) {
            Provider provider = this.mProviders.get(i);
            if (!provider.id.equals(id2)) continue;
            return provider;
        }
        return null;
    }

    private Host lookupHostLocked(HostId hostId) {
        int N = this.mHosts.size();
        for (int i = 0; i < N; ++i) {
            Host host = this.mHosts.get(i);
            if (!host.id.equals(hostId)) continue;
            return host;
        }
        return null;
    }

    private void pruneHostLocked(Host host) {
        if (host.widgets.size() == 0 && host.callbacks == null) {
            if (DEBUG) {
                Slog.i(TAG, "Pruning host " + host.id);
            }
            this.mHosts.remove(host);
        }
    }

    private void loadGroupWidgetProvidersLocked(int[] profileIds) {
        ArrayList<ResolveInfo> allReceivers = null;
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
        for (int profileId : profileIds) {
            List<ResolveInfo> receivers = this.queryIntentReceivers(intent, profileId);
            if (receivers == null || receivers.isEmpty()) continue;
            if (allReceivers == null) {
                allReceivers = new ArrayList<ResolveInfo>();
            }
            allReceivers.addAll(receivers);
        }
        int N = allReceivers == null ? 0 : allReceivers.size();
        for (int i = 0; i < N; ++i) {
            ResolveInfo receiver = (ResolveInfo)allReceivers.get(i);
            this.addProviderLocked(receiver);
        }
    }

    private boolean addProviderLocked(ResolveInfo ri) {
        if ((ri.activityInfo.applicationInfo.flags & 0x40000) != 0) {
            return false;
        }
        if (!ri.activityInfo.isEnabled()) {
            return false;
        }
        ComponentName componentName = new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name);
        ProviderId providerId = new ProviderId(ri.activityInfo.applicationInfo.uid, componentName);
        Provider provider = this.parseProviderInfoXml(providerId, ri);
        if (provider != null) {
            Provider existing = this.lookupProviderLocked(providerId);
            if (existing == null) {
                ProviderId restoredProviderId = new ProviderId(-1, componentName);
                existing = this.lookupProviderLocked(restoredProviderId);
            }
            if (existing != null) {
                if (existing.zombie && !this.mSafeMode) {
                    existing.id = providerId;
                    existing.zombie = false;
                    existing.info = provider.info;
                    if (DEBUG) {
                        Slog.i(TAG, "Provider placeholder now reified: " + existing);
                    }
                }
            } else {
                this.mProviders.add(provider);
            }
            return true;
        }
        return false;
    }

    private void deleteWidgetsLocked(Provider provider, int userId) {
        int N = provider.widgets.size();
        for (int i = N - 1; i >= 0; --i) {
            Widget widget = provider.widgets.get(i);
            if (userId != -1 && userId != widget.host.getUserId()) continue;
            provider.widgets.remove(i);
            this.updateAppWidgetInstanceLocked(widget, null, false);
            widget.host.widgets.remove(widget);
            this.removeWidgetLocked(widget);
            widget.provider = null;
            this.pruneHostLocked(widget.host);
            widget.host = null;
        }
    }

    private void deleteProviderLocked(Provider provider) {
        this.deleteWidgetsLocked(provider, -1);
        this.mProviders.remove(provider);
        this.cancelBroadcasts(provider);
    }

    private void sendEnableIntentLocked(Provider p) {
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_ENABLED");
        intent.setComponent(p.info.provider);
        this.sendBroadcastAsUser(intent, p.info.getProfile());
    }

    private void sendUpdateIntentLocked(Provider provider, int[] appWidgetIds) {
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
        intent.putExtra("appWidgetIds", appWidgetIds);
        intent.setComponent(provider.info.provider);
        this.sendBroadcastAsUser(intent, provider.info.getProfile());
    }

    private void sendDeletedIntentLocked(Widget widget) {
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_DELETED");
        intent.setComponent(widget.provider.info.provider);
        intent.putExtra("appWidgetId", widget.appWidgetId);
        this.sendBroadcastAsUser(intent, widget.provider.info.getProfile());
    }

    private void sendDisabledIntentLocked(Provider provider) {
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_DISABLED");
        intent.setComponent(provider.info.provider);
        this.sendBroadcastAsUser(intent, provider.info.getProfile());
    }

    public void sendOptionsChangedIntentLocked(Widget widget) {
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE_OPTIONS");
        intent.setComponent(widget.provider.info.provider);
        intent.putExtra("appWidgetId", widget.appWidgetId);
        intent.putExtra("appWidgetOptions", widget.options);
        this.sendBroadcastAsUser(intent, widget.provider.info.getProfile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerForBroadcastsLocked(Provider provider, int[] appWidgetIds) {
        if (provider.info.updatePeriodMillis > 0) {
            boolean alreadyRegistered = provider.broadcast != null;
            Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
            intent.putExtra("appWidgetIds", appWidgetIds);
            intent.setComponent(provider.info.provider);
            long token = Binder.clearCallingIdentity();
            try {
                provider.broadcast = PendingIntent.getBroadcastAsUser(this.mContext, 1, intent, 0x8000000, provider.info.getProfile());
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            if (!alreadyRegistered) {
                long period = provider.info.updatePeriodMillis;
                if (period < (long)MIN_UPDATE_PERIOD) {
                    period = MIN_UPDATE_PERIOD;
                }
                long oldId = Binder.clearCallingIdentity();
                try {
                    this.mAlarmManager.setInexactRepeating(2, SystemClock.elapsedRealtime() + period, period, provider.broadcast);
                }
                finally {
                    Binder.restoreCallingIdentity(oldId);
                }
            }
        }
    }

    private static int[] getWidgetIds(ArrayList<Widget> widgets) {
        int instancesSize = widgets.size();
        int[] appWidgetIds = new int[instancesSize];
        for (int i = 0; i < instancesSize; ++i) {
            appWidgetIds[i] = widgets.get((int)i).appWidgetId;
        }
        return appWidgetIds;
    }

    private static void dumpProvider(Provider provider, int index, PrintWriter pw) {
        AppWidgetProviderInfo info = provider.info;
        pw.print("  [");
        pw.print(index);
        pw.print("] provider ");
        pw.println(provider.id);
        pw.print("    min=(");
        pw.print(info.minWidth);
        pw.print("x");
        pw.print(info.minHeight);
        pw.print(")   minResize=(");
        pw.print(info.minResizeWidth);
        pw.print("x");
        pw.print(info.minResizeHeight);
        pw.print(") updatePeriodMillis=");
        pw.print(info.updatePeriodMillis);
        pw.print(" resizeMode=");
        pw.print(info.resizeMode);
        pw.print(" widgetCategory=");
        pw.print(info.widgetCategory);
        pw.print(" autoAdvanceViewId=");
        pw.print(info.autoAdvanceViewId);
        pw.print(" initialLayout=#");
        pw.print(Integer.toHexString(info.initialLayout));
        pw.print(" initialKeyguardLayout=#");
        pw.print(Integer.toHexString(info.initialKeyguardLayout));
        pw.print(" zombie=");
        pw.println(provider.zombie);
    }

    private static void dumpHost(Host host, int index, PrintWriter pw) {
        pw.print("  [");
        pw.print(index);
        pw.print("] hostId=");
        pw.println(host.id);
        pw.print("    callbacks=");
        pw.println(host.callbacks);
        pw.print("    widgets.size=");
        pw.print(host.widgets.size());
        pw.print(" zombie=");
        pw.println(host.zombie);
    }

    private static void dumpGrant(Pair<Integer, String> grant, int index, PrintWriter pw) {
        pw.print("  [");
        pw.print(index);
        pw.print(']');
        pw.print(" user=");
        pw.print(grant.first);
        pw.print(" package=");
        pw.println((String)grant.second);
    }

    private static void dumpWidget(Widget widget, int index, PrintWriter pw) {
        pw.print("  [");
        pw.print(index);
        pw.print("] id=");
        pw.println(widget.appWidgetId);
        pw.print("    host=");
        pw.println(widget.host.id);
        if (widget.provider != null) {
            pw.print("    provider=");
            pw.println(widget.provider.id);
        }
        if (widget.host != null) {
            pw.print("    host.callbacks=");
            pw.println(widget.host.callbacks);
        }
        if (widget.views != null) {
            pw.print("    views=");
            pw.println(widget.views);
        }
    }

    private static void serializeProvider(XmlSerializer out, Provider p) throws IOException {
        out.startTag(null, "p");
        out.attribute(null, "pkg", p.info.provider.getPackageName());
        out.attribute(null, "cl", p.info.provider.getClassName());
        out.attribute(null, "tag", Integer.toHexString(p.tag));
        out.endTag(null, "p");
    }

    private static void serializeHost(XmlSerializer out, Host host) throws IOException {
        out.startTag(null, "h");
        out.attribute(null, "pkg", host.id.packageName);
        out.attribute(null, "id", Integer.toHexString(host.id.hostId));
        out.attribute(null, "tag", Integer.toHexString(host.tag));
        out.endTag(null, "h");
    }

    private static void serializeAppWidget(XmlSerializer out, Widget widget) throws IOException {
        out.startTag(null, "g");
        out.attribute(null, "id", Integer.toHexString(widget.appWidgetId));
        out.attribute(null, "rid", Integer.toHexString(widget.restoredId));
        out.attribute(null, "h", Integer.toHexString(widget.host.tag));
        if (widget.provider != null) {
            out.attribute(null, "p", Integer.toHexString(widget.provider.tag));
        }
        if (widget.options != null) {
            out.attribute(null, "min_width", Integer.toHexString(widget.options.getInt("appWidgetMinWidth")));
            out.attribute(null, "min_height", Integer.toHexString(widget.options.getInt("appWidgetMinHeight")));
            out.attribute(null, "max_width", Integer.toHexString(widget.options.getInt("appWidgetMaxWidth")));
            out.attribute(null, "max_height", Integer.toHexString(widget.options.getInt("appWidgetMaxHeight")));
            out.attribute(null, "host_category", Integer.toHexString(widget.options.getInt("appWidgetCategory")));
        }
        out.endTag(null, "g");
    }

    @Override
    public List<String> getWidgetParticipants(int userId) {
        return this.mBackupRestoreController.getWidgetParticipants(userId);
    }

    @Override
    public byte[] getWidgetState(String packageName, int userId) {
        return this.mBackupRestoreController.getWidgetState(packageName, userId);
    }

    @Override
    public void restoreStarting(int userId) {
        this.mBackupRestoreController.restoreStarting(userId);
    }

    @Override
    public void restoreWidgetState(String packageName, byte[] restoredState, int userId) {
        this.mBackupRestoreController.restoreWidgetState(packageName, restoredState, userId);
    }

    @Override
    public void restoreFinished(int userId) {
        this.mBackupRestoreController.restoreFinished(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Provider parseProviderInfoXml(ProviderId providerId, ResolveInfo ri) {
        Provider provider = null;
        ActivityInfo activityInfo = ri.activityInfo;
        try (XmlResourceParser parser = null;){
            Resources resources;
            int type;
            parser = activityInfo.loadXmlMetaData(this.mContext.getPackageManager(), "android.appwidget.provider");
            if (parser == null) {
                Slog.w(TAG, "No android.appwidget.provider meta-data for AppWidget provider '" + providerId + '\'');
                Provider provider2 = null;
                return provider2;
            }
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"appwidget-provider".equals(nodeName)) {
                Slog.w(TAG, "Meta-data does not start with appwidget-provider tag for AppWidget provider " + providerId.componentName + " for user " + providerId.uid);
                Provider provider3 = null;
                return provider3;
            }
            provider = new Provider();
            provider.id = providerId;
            AppWidgetProviderInfo info = provider.info = new AppWidgetProviderInfo();
            info.provider = providerId.componentName;
            info.providerInfo = activityInfo;
            long identity = Binder.clearCallingIdentity();
            try {
                PackageManager pm = this.mContext.getPackageManager();
                int userId = UserHandle.getUserId(providerId.uid);
                ApplicationInfo app = pm.getApplicationInfoAsUser(activityInfo.packageName, 0, userId);
                resources = pm.getResourcesForApplication(app);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            TypedArray sa = resources.obtainAttributes(attrs, R.styleable.AppWidgetProviderInfo);
            TypedValue value = sa.peekValue(0);
            info.minWidth = value != null ? value.data : 0;
            value = sa.peekValue(1);
            info.minHeight = value != null ? value.data : 0;
            value = sa.peekValue(8);
            info.minResizeWidth = value != null ? value.data : info.minWidth;
            value = sa.peekValue(9);
            info.minResizeHeight = value != null ? value.data : info.minHeight;
            info.updatePeriodMillis = sa.getInt(2, 0);
            info.initialLayout = sa.getResourceId(3, 0);
            info.initialKeyguardLayout = sa.getResourceId(10, 0);
            String className = sa.getString(4);
            if (className != null) {
                info.configure = new ComponentName(providerId.componentName.getPackageName(), className);
            }
            info.label = activityInfo.loadLabel(this.mContext.getPackageManager()).toString();
            info.icon = ri.getIconResource();
            info.previewImage = sa.getResourceId(5, 0);
            info.autoAdvanceViewId = sa.getResourceId(6, -1);
            info.resizeMode = sa.getInt(7, 0);
            info.widgetCategory = sa.getInt(11, 1);
            sa.recycle();
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUidForPackage(String packageName, int userId) {
        PackageInfo pkgInfo = null;
        long identity = Binder.clearCallingIdentity();
        try {
            pkgInfo = this.mPackageManager.getPackageInfo(packageName, 0, userId);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        if (pkgInfo == null || pkgInfo.applicationInfo == null) {
            return -1;
        }
        return pkgInfo.applicationInfo.uid;
    }

    private ActivityInfo getProviderInfo(ComponentName componentName, int userId) {
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
        intent.setComponent(componentName);
        List<ResolveInfo> receivers = this.queryIntentReceivers(intent, userId);
        if (!receivers.isEmpty()) {
            return receivers.get((int)0).activityInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResolveInfo> queryIntentReceivers(Intent intent, int userId) {
        long identity = Binder.clearCallingIdentity();
        try {
            int flags = 128;
            flags |= 0x10000000;
            if (this.isProfileWithUnlockedParent(userId)) {
                flags |= 0xC0000;
            }
            List list = this.mPackageManager.queryIntentReceivers(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags |= 0x400, userId).getList();
            return list;
        }
        catch (RemoteException re) {
            List<ResolveInfo> list = Collections.emptyList();
            return list;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUserUnlocked(int userId) {
        if (this.isProfileWithLockedParent(userId)) {
            return;
        }
        if (!this.mUserManager.isUserUnlockingOrUnlocked(userId)) {
            Slog.w(TAG, "User " + userId + " is no longer unlocked - exiting");
            return;
        }
        long time = SystemClock.elapsedRealtime();
        Object object = this.mLock;
        synchronized (object) {
            Trace.traceBegin(64L, "appwidget ensure");
            this.ensureGroupStateLoadedLocked(userId);
            Trace.traceEnd(64L);
            Trace.traceBegin(64L, "appwidget reload");
            this.reloadWidgetsMaskedStateForGroup(this.mSecurityPolicy.getGroupParent(userId));
            Trace.traceEnd(64L);
            int N = this.mProviders.size();
            for (int i = 0; i < N; ++i) {
                Provider provider = this.mProviders.get(i);
                if (provider.getUserId() != userId || provider.widgets.size() <= 0) continue;
                Trace.traceBegin(64L, "appwidget init " + provider.info.provider.getPackageName());
                this.sendEnableIntentLocked(provider);
                int[] appWidgetIds = AppWidgetServiceImpl.getWidgetIds(provider.widgets);
                this.sendUpdateIntentLocked(provider, appWidgetIds);
                this.registerForBroadcastsLocked(provider, appWidgetIds);
                Trace.traceEnd(64L);
            }
        }
        Slog.i(TAG, "Async processing of onUserUnlocked u" + userId + " took " + (SystemClock.elapsedRealtime() - time) + " ms");
    }

    private void loadGroupStateLocked(int[] profileIds) {
        ArrayList<LoadedWidgetState> loadedWidgets = new ArrayList<LoadedWidgetState>();
        int version = 0;
        for (int profileId : profileIds) {
            AtomicFile file = AppWidgetServiceImpl.getSavedStateFile(profileId);
            try {
                FileInputStream stream = file.openRead();
                version = this.readProfileStateFromFileLocked(stream, profileId, loadedWidgets);
                IoUtils.closeQuietly(stream);
            }
            catch (FileNotFoundException e) {
                Slog.w(TAG, "Failed to read state: " + e);
            }
        }
        if (version >= 0) {
            this.bindLoadedWidgetsLocked(loadedWidgets);
            this.performUpgradeLocked(version);
        } else {
            Slog.w(TAG, "Failed to read state, clearing widgets and hosts.");
            this.clearWidgetsLocked();
            this.mHosts.clear();
            int N = this.mProviders.size();
            for (int i = 0; i < N; ++i) {
                this.mProviders.get((int)i).widgets.clear();
            }
        }
    }

    private void bindLoadedWidgetsLocked(List<LoadedWidgetState> loadedWidgets) {
        int loadedWidgetCount = loadedWidgets.size();
        for (int i = loadedWidgetCount - 1; i >= 0; --i) {
            LoadedWidgetState loadedWidget = loadedWidgets.remove(i);
            Widget widget = loadedWidget.widget;
            widget.provider = this.findProviderByTag(loadedWidget.providerTag);
            if (widget.provider == null) continue;
            widget.host = this.findHostByTag(loadedWidget.hostTag);
            if (widget.host == null) continue;
            widget.provider.widgets.add(widget);
            widget.host.widgets.add(widget);
            this.addWidgetLocked(widget);
        }
    }

    private Provider findProviderByTag(int tag) {
        if (tag < 0) {
            return null;
        }
        int providerCount = this.mProviders.size();
        for (int i = 0; i < providerCount; ++i) {
            Provider provider = this.mProviders.get(i);
            if (provider.tag != tag) continue;
            return provider;
        }
        return null;
    }

    private Host findHostByTag(int tag) {
        if (tag < 0) {
            return null;
        }
        int hostCount = this.mHosts.size();
        for (int i = 0; i < hostCount; ++i) {
            Host host = this.mHosts.get(i);
            if (host.tag != tag) continue;
            return host;
        }
        return null;
    }

    void addWidgetLocked(Widget widget) {
        this.mWidgets.add(widget);
        this.onWidgetProviderAddedOrChangedLocked(widget);
    }

    void onWidgetProviderAddedOrChangedLocked(Widget widget) {
        if (widget.provider == null) {
            return;
        }
        int userId = widget.provider.getUserId();
        ArraySet<String> packages = this.mWidgetPackages.get(userId);
        if (packages == null) {
            packages = new ArraySet();
            this.mWidgetPackages.put(userId, packages);
        }
        packages.add(widget.provider.info.provider.getPackageName());
        if (widget.provider.isMaskedLocked()) {
            this.maskWidgetsViewsLocked(widget.provider, widget);
        } else {
            widget.clearMaskedViewsLocked();
        }
    }

    void removeWidgetLocked(Widget widget) {
        this.mWidgets.remove(widget);
        this.onWidgetRemovedLocked(widget);
    }

    private void onWidgetRemovedLocked(Widget widget) {
        if (widget.provider == null) {
            return;
        }
        int userId = widget.provider.getUserId();
        String packageName = widget.provider.info.provider.getPackageName();
        ArraySet<String> packages = this.mWidgetPackages.get(userId);
        if (packages == null) {
            return;
        }
        int N = this.mWidgets.size();
        for (int i = 0; i < N; ++i) {
            Widget w = this.mWidgets.get(i);
            if (w.provider == null || w.provider.getUserId() != userId || !packageName.equals(w.provider.info.provider.getPackageName())) continue;
            return;
        }
        packages.remove(packageName);
    }

    void clearWidgetsLocked() {
        this.mWidgets.clear();
        this.onWidgetsClearedLocked();
    }

    private void onWidgetsClearedLocked() {
        this.mWidgetPackages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBoundWidgetPackage(String packageName, int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system process can call this");
        }
        Object object = this.mLock;
        synchronized (object) {
            ArraySet<String> packages = this.mWidgetPackages.get(userId);
            if (packages != null) {
                return packages.contains(packageName);
            }
        }
        return false;
    }

    private void saveStateLocked(int userId) {
        this.tagProvidersAndHosts();
        for (int profileId : this.mSecurityPolicy.getEnabledGroupProfileIds(userId)) {
            AtomicFile file = AppWidgetServiceImpl.getSavedStateFile(profileId);
            try {
                FileOutputStream stream = file.startWrite();
                if (this.writeProfileStateToFileLocked(stream, profileId)) {
                    file.finishWrite(stream);
                    continue;
                }
                file.failWrite(stream);
                Slog.w(TAG, "Failed to save state, restoring backup.");
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed open state file for write: " + e);
            }
        }
    }

    private void tagProvidersAndHosts() {
        int providerCount = this.mProviders.size();
        int i = 0;
        while (i < providerCount) {
            Provider provider = this.mProviders.get(i);
            provider.tag = i++;
        }
        int hostCount = this.mHosts.size();
        int i2 = 0;
        while (i2 < hostCount) {
            Host host = this.mHosts.get(i2);
            host.tag = i2++;
        }
    }

    private void clearProvidersAndHostsTagsLocked() {
        int providerCount = this.mProviders.size();
        for (int i = 0; i < providerCount; ++i) {
            Provider provider = this.mProviders.get(i);
            provider.tag = -1;
        }
        int hostCount = this.mHosts.size();
        for (int i = 0; i < hostCount; ++i) {
            Host host = this.mHosts.get(i);
            host.tag = -1;
        }
    }

    private boolean writeProfileStateToFileLocked(FileOutputStream stream, int userId) {
        try {
            int i;
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(stream, StandardCharsets.UTF_8.name());
            out.startDocument(null, true);
            out.startTag(null, "gs");
            out.attribute(null, "version", String.valueOf(1));
            int N = this.mProviders.size();
            for (i = 0; i < N; ++i) {
                Provider provider = this.mProviders.get(i);
                if (provider.getUserId() != userId || provider.widgets.size() <= 0) continue;
                AppWidgetServiceImpl.serializeProvider(out, provider);
            }
            N = this.mHosts.size();
            for (i = 0; i < N; ++i) {
                Host host = this.mHosts.get(i);
                if (host.getUserId() != userId) continue;
                AppWidgetServiceImpl.serializeHost(out, host);
            }
            N = this.mWidgets.size();
            for (i = 0; i < N; ++i) {
                Widget widget = this.mWidgets.get(i);
                if (widget.host.getUserId() != userId) continue;
                AppWidgetServiceImpl.serializeAppWidget(out, widget);
            }
            for (Pair<Integer, String> binding : this.mPackagesWithBindWidgetPermission) {
                if ((Integer)binding.first != userId) continue;
                out.startTag(null, "b");
                out.attribute(null, "packageName", (String)binding.second);
                out.endTag(null, "b");
            }
            out.endTag(null, "gs");
            out.endDocument();
            return true;
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed to write state: " + e);
            return false;
        }
    }

    private int readProfileStateFromFileLocked(FileInputStream stream, int userId, List<LoadedWidgetState> outLoadedWidgets) {
        int version = -1;
        try {
            int type;
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            int legacyProviderIndex = -1;
            int legacyHostIndex = -1;
            do {
                String categoryString;
                String maxHeightString;
                String maxWidthString;
                String minHeightString;
                if ((type = parser.next()) != 2) continue;
                String tag = parser.getName();
                if ("gs".equals(tag)) {
                    String attributeValue = parser.getAttributeValue(null, "version");
                    try {
                        version = Integer.parseInt(attributeValue);
                    }
                    catch (NumberFormatException e) {
                        version = 0;
                    }
                    continue;
                }
                if ("p".equals(tag)) {
                    String tagAttribute;
                    int providerTag;
                    ComponentName componentName;
                    ActivityInfo providerInfo;
                    int uid;
                    ++legacyProviderIndex;
                    String pkg = parser.getAttributeValue(null, "pkg");
                    String cl = parser.getAttributeValue(null, "cl");
                    if ((pkg = this.getCanonicalPackageName(pkg, cl, userId)) == null || (uid = this.getUidForPackage(pkg, userId)) < 0 || (providerInfo = this.getProviderInfo(componentName = new ComponentName(pkg, cl), userId)) == null) continue;
                    ProviderId providerId = new ProviderId(uid, componentName);
                    Provider provider = this.lookupProviderLocked(providerId);
                    if (provider == null && this.mSafeMode) {
                        provider = new Provider();
                        provider.info = new AppWidgetProviderInfo();
                        provider.info.provider = providerId.componentName;
                        provider.info.providerInfo = providerInfo;
                        provider.zombie = true;
                        provider.id = providerId;
                        this.mProviders.add(provider);
                    }
                    provider.tag = providerTag = !TextUtils.isEmpty(tagAttribute = parser.getAttributeValue(null, "tag")) ? Integer.parseInt(tagAttribute, 16) : legacyProviderIndex;
                    continue;
                }
                if ("h".equals(tag)) {
                    int hostTag;
                    ++legacyHostIndex;
                    Host host = new Host();
                    String pkg = parser.getAttributeValue(null, "pkg");
                    int uid = this.getUidForPackage(pkg, userId);
                    if (uid < 0) {
                        host.zombie = true;
                    }
                    if (host.zombie && !this.mSafeMode) continue;
                    int hostId = Integer.parseInt(parser.getAttributeValue(null, "id"), 16);
                    String tagAttribute = parser.getAttributeValue(null, "tag");
                    host.tag = hostTag = !TextUtils.isEmpty(tagAttribute) ? Integer.parseInt(tagAttribute, 16) : legacyHostIndex;
                    host.id = new HostId(uid, hostId, pkg);
                    this.mHosts.add(host);
                    continue;
                }
                if ("b".equals(tag)) {
                    String packageName = parser.getAttributeValue(null, "packageName");
                    int uid = this.getUidForPackage(packageName, userId);
                    if (uid < 0) continue;
                    Pair<Integer, String> packageId = Pair.create(userId, packageName);
                    this.mPackagesWithBindWidgetPermission.add(packageId);
                    continue;
                }
                if (!"g".equals(tag)) continue;
                Widget widget = new Widget();
                widget.appWidgetId = Integer.parseInt(parser.getAttributeValue(null, "id"), 16);
                this.setMinAppWidgetIdLocked(userId, widget.appWidgetId + 1);
                String restoredIdString = parser.getAttributeValue(null, "rid");
                widget.restoredId = restoredIdString == null ? 0 : Integer.parseInt(restoredIdString, 16);
                Bundle options = new Bundle();
                String minWidthString = parser.getAttributeValue(null, "min_width");
                if (minWidthString != null) {
                    options.putInt("appWidgetMinWidth", Integer.parseInt(minWidthString, 16));
                }
                if ((minHeightString = parser.getAttributeValue(null, "min_height")) != null) {
                    options.putInt("appWidgetMinHeight", Integer.parseInt(minHeightString, 16));
                }
                if ((maxWidthString = parser.getAttributeValue(null, "max_width")) != null) {
                    options.putInt("appWidgetMaxWidth", Integer.parseInt(maxWidthString, 16));
                }
                if ((maxHeightString = parser.getAttributeValue(null, "max_height")) != null) {
                    options.putInt("appWidgetMaxHeight", Integer.parseInt(maxHeightString, 16));
                }
                if ((categoryString = parser.getAttributeValue(null, "host_category")) != null) {
                    options.putInt("appWidgetCategory", Integer.parseInt(categoryString, 16));
                }
                widget.options = options;
                int hostTag = Integer.parseInt(parser.getAttributeValue(null, "h"), 16);
                String providerString = parser.getAttributeValue(null, "p");
                int providerTag = providerString != null ? Integer.parseInt(parser.getAttributeValue(null, "p"), 16) : -1;
                LoadedWidgetState loadedWidgets = new LoadedWidgetState(widget, hostTag, providerTag);
                outLoadedWidgets.add(loadedWidgets);
            } while (type != 1);
        }
        catch (IOException | IndexOutOfBoundsException | NullPointerException | NumberFormatException | XmlPullParserException e) {
            Slog.w(TAG, "failed parsing " + e);
            return -1;
        }
        return version;
    }

    private void performUpgradeLocked(int fromVersion) {
        int version;
        if (fromVersion < 1) {
            Slog.v(TAG, "Upgrading widget database from " + fromVersion + " to " + 1);
        }
        if ((version = fromVersion) == 0) {
            int uid;
            HostId oldHostId = new HostId(Process.myUid(), 1262836039, OLD_KEYGUARD_HOST_PACKAGE);
            Host host = this.lookupHostLocked(oldHostId);
            if (host != null && (uid = this.getUidForPackage(NEW_KEYGUARD_HOST_PACKAGE, 0)) >= 0) {
                host.id = new HostId(uid, 1262836039, NEW_KEYGUARD_HOST_PACKAGE);
            }
            version = 1;
        }
        if (version != 1) {
            throw new IllegalStateException("Failed to upgrade widget database");
        }
    }

    private static File getStateFile(int userId) {
        return new File(Environment.getUserSystemDirectory(userId), STATE_FILENAME);
    }

    private static AtomicFile getSavedStateFile(int userId) {
        File dir = Environment.getUserSystemDirectory(userId);
        File settingsFile = AppWidgetServiceImpl.getStateFile(userId);
        if (!settingsFile.exists() && userId == 0) {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File oldFile = new File("/data/system/appwidgets.xml");
            oldFile.renameTo(settingsFile);
        }
        return new AtomicFile(settingsFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUserStopped(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int nextIdIndex;
            boolean crossProfileWidgetsChanged = false;
            int widgetCount = this.mWidgets.size();
            for (int i = widgetCount - 1; i >= 0; --i) {
                boolean providerInUser;
                Widget widget = this.mWidgets.get(i);
                boolean hostInUser = widget.host.getUserId() == userId;
                boolean hasProvider = widget.provider != null;
                boolean bl = providerInUser = hasProvider && widget.provider.getUserId() == userId;
                if (!hostInUser || hasProvider && !providerInUser) continue;
                this.removeWidgetLocked(widget);
                widget.host.widgets.remove(widget);
                widget.host = null;
                if (!hasProvider) continue;
                widget.provider.widgets.remove(widget);
                widget.provider = null;
            }
            int hostCount = this.mHosts.size();
            for (int i = hostCount - 1; i >= 0; --i) {
                Host host = this.mHosts.get(i);
                if (host.getUserId() != userId) continue;
                crossProfileWidgetsChanged |= !host.widgets.isEmpty();
                this.deleteHostLocked(host);
            }
            int grantCount = this.mPackagesWithBindWidgetPermission.size();
            for (int i = grantCount - 1; i >= 0; --i) {
                Pair<Integer, String> packageId = this.mPackagesWithBindWidgetPermission.valueAt(i);
                if ((Integer)packageId.first != userId) continue;
                this.mPackagesWithBindWidgetPermission.removeAt(i);
            }
            int userIndex = this.mLoadedUserIds.indexOfKey(userId);
            if (userIndex >= 0) {
                this.mLoadedUserIds.removeAt(userIndex);
            }
            if ((nextIdIndex = this.mNextAppWidgetIds.indexOfKey(userId)) >= 0) {
                this.mNextAppWidgetIds.removeAt(nextIdIndex);
            }
            if (crossProfileWidgetsChanged) {
                this.saveGroupStateAsync(userId);
            }
        }
    }

    private boolean updateProvidersForPackageLocked(String packageName, int userId, Set<ProviderId> removedProviders) {
        int i;
        boolean providersUpdated = false;
        HashSet<ProviderId> keep = new HashSet<ProviderId>();
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
        intent.setPackage(packageName);
        List<ResolveInfo> broadcastReceivers = this.queryIntentReceivers(intent, userId);
        int N = broadcastReceivers == null ? 0 : broadcastReceivers.size();
        for (i = 0; i < N; ++i) {
            ResolveInfo ri = broadcastReceivers.get(i);
            ActivityInfo ai = ri.activityInfo;
            if ((ai.applicationInfo.flags & 0x40000) != 0 || !packageName.equals(ai.packageName)) continue;
            ProviderId providerId = new ProviderId(ai.applicationInfo.uid, new ComponentName(ai.packageName, ai.name));
            Provider provider = this.lookupProviderLocked(providerId);
            if (provider == null) {
                if (!this.addProviderLocked(ri)) continue;
                keep.add(providerId);
                providersUpdated = true;
                continue;
            }
            Provider parsed = this.parseProviderInfoXml(providerId, ri);
            if (parsed != null) {
                keep.add(providerId);
                provider.info = parsed.info;
                int M = provider.widgets.size();
                if (M > 0) {
                    int[] appWidgetIds = AppWidgetServiceImpl.getWidgetIds(provider.widgets);
                    this.cancelBroadcasts(provider);
                    this.registerForBroadcastsLocked(provider, appWidgetIds);
                    for (int j = 0; j < M; ++j) {
                        Widget widget = provider.widgets.get(j);
                        widget.views = null;
                        this.scheduleNotifyProviderChangedLocked(widget);
                    }
                    this.sendUpdateIntentLocked(provider, appWidgetIds);
                }
            }
            providersUpdated = true;
        }
        N = this.mProviders.size();
        for (i = N - 1; i >= 0; --i) {
            Provider provider = this.mProviders.get(i);
            if (!packageName.equals(provider.info.provider.getPackageName()) || provider.getUserId() != userId || keep.contains(provider.id)) continue;
            if (removedProviders != null) {
                removedProviders.add(provider.id);
            }
            this.deleteProviderLocked(provider);
            providersUpdated = true;
        }
        return providersUpdated;
    }

    private void removeWidgetsForPackageLocked(String pkgName, int userId, int parentUserId) {
        int N = this.mProviders.size();
        for (int i = 0; i < N; ++i) {
            Provider provider = this.mProviders.get(i);
            if (!pkgName.equals(provider.info.provider.getPackageName()) || provider.getUserId() != userId || provider.widgets.size() <= 0) continue;
            this.deleteWidgetsLocked(provider, parentUserId);
        }
    }

    private boolean removeProvidersForPackageLocked(String pkgName, int userId) {
        boolean removed = false;
        int N = this.mProviders.size();
        for (int i = N - 1; i >= 0; --i) {
            Provider provider = this.mProviders.get(i);
            if (!pkgName.equals(provider.info.provider.getPackageName()) || provider.getUserId() != userId) continue;
            this.deleteProviderLocked(provider);
            removed = true;
        }
        return removed;
    }

    private boolean removeHostsAndProvidersForPackageLocked(String pkgName, int userId) {
        boolean removed = this.removeProvidersForPackageLocked(pkgName, userId);
        int N = this.mHosts.size();
        for (int i = N - 1; i >= 0; --i) {
            Host host = this.mHosts.get(i);
            if (!pkgName.equals(host.id.packageName) || host.getUserId() != userId) continue;
            this.deleteHostLocked(host);
            removed = true;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCanonicalPackageName(String packageName, String className, int userId) {
        long identity = Binder.clearCallingIdentity();
        try {
            AppGlobals.getPackageManager().getReceiverInfo(new ComponentName(packageName, className), 0, userId);
            String string2 = packageName;
            return string2;
        }
        catch (RemoteException re) {
            String[] packageNames = this.mContext.getPackageManager().currentToCanonicalPackageNames(new String[]{packageName});
            if (packageNames != null && packageNames.length > 0) {
                String string3 = packageNames[0];
                return string3;
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBroadcastAsUser(Intent intent, UserHandle userHandle) {
        long identity = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, userHandle);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindService(Intent intent, ServiceConnection connection, UserHandle userHandle) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mContext.bindServiceAsUser(intent, connection, 0x2000001, userHandle);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindService(ServiceConnection connection) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mContext.unbindService(connection);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCrossProfileWidgetProvidersChanged(int userId, List<String> packages) {
        int parentId = this.mSecurityPolicy.getProfileParent(userId);
        if (parentId != userId) {
            Object object = this.mLock;
            synchronized (object) {
                boolean providersChanged = false;
                ArraySet<String> previousPackages = new ArraySet<String>();
                int providerCount = this.mProviders.size();
                for (int i = 0; i < providerCount; ++i) {
                    Provider provider = this.mProviders.get(i);
                    if (provider.getUserId() != userId) continue;
                    previousPackages.add(provider.id.componentName.getPackageName());
                }
                int packageCount = packages.size();
                for (int i = 0; i < packageCount; ++i) {
                    String packageName = packages.get(i);
                    previousPackages.remove(packageName);
                    providersChanged |= this.updateProvidersForPackageLocked(packageName, userId, null);
                }
                int removedCount = previousPackages.size();
                for (int i = 0; i < removedCount; ++i) {
                    this.removeWidgetsForPackageLocked((String)previousPackages.valueAt(i), userId, parentId);
                }
                if (providersChanged || removedCount > 0) {
                    this.saveGroupStateAsync(userId);
                    this.scheduleNotifyGroupHostsForProvidersChangedLocked(userId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isProfileWithLockedParent(int userId) {
        long token = Binder.clearCallingIdentity();
        try {
            UserInfo parentInfo;
            UserInfo userInfo = this.mUserManager.getUserInfo(userId);
            if (userInfo != null && userInfo.isManagedProfile() && (parentInfo = this.mUserManager.getProfileParent(userId)) != null && !this.isUserRunningAndUnlocked(parentInfo.getUserHandle().getIdentifier())) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return false;
    }

    private boolean isProfileWithUnlockedParent(int userId) {
        UserInfo parentInfo;
        UserInfo userInfo = this.mUserManager.getUserInfo(userId);
        return userInfo != null && userInfo.isManagedProfile() && (parentInfo = this.mUserManager.getProfileParent(userId)) != null && this.mUserManager.isUserUnlockingOrUnlocked(parentInfo.getUserHandle());
    }

    static /* synthetic */ Host access$3700(AppWidgetServiceImpl x0, HostId x1) {
        return x0.lookupOrAddHostLocked(x1);
    }

    static /* synthetic */ int access$3800(AppWidgetServiceImpl x0, int x1) {
        return x0.incrementAndGetAppWidgetIdLocked(x1);
    }

    static /* synthetic */ void access$3900(AppWidgetServiceImpl x0, int x1) {
        x0.saveGroupStateAsync(x1);
    }

    private final class BackupRestoreController {
        private static final String TAG = "BackupRestoreController";
        private static final boolean DEBUG = true;
        private static final int WIDGET_STATE_VERSION = 2;
        private final HashSet<String> mPrunedApps = new HashSet();
        private final HashMap<Provider, ArrayList<RestoreUpdateRecord>> mUpdatesByProvider = new HashMap();
        private final HashMap<Host, ArrayList<RestoreUpdateRecord>> mUpdatesByHost = new HashMap();

        private BackupRestoreController() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> getWidgetParticipants(int userId) {
            Slog.i(TAG, "Getting widget participants for user: " + userId);
            HashSet<String> packages = new HashSet<String>();
            Object object = AppWidgetServiceImpl.this.mLock;
            synchronized (object) {
                int N = AppWidgetServiceImpl.this.mWidgets.size();
                for (int i = 0; i < N; ++i) {
                    Widget widget = (Widget)AppWidgetServiceImpl.this.mWidgets.get(i);
                    if (!this.isProviderAndHostInUser(widget, userId)) continue;
                    packages.add(widget.host.id.packageName);
                    Provider provider = widget.provider;
                    if (provider == null) continue;
                    packages.add(provider.id.componentName.getPackageName());
                }
            }
            return new ArrayList<String>(packages);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getWidgetState(String backedupPackage, int userId) {
            Slog.i(TAG, "Getting widget state for user: " + userId);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Object object = AppWidgetServiceImpl.this.mLock;
            synchronized (object) {
                if (!this.packageNeedsWidgetBackupLocked(backedupPackage, userId)) {
                    return null;
                }
                try {
                    int i;
                    FastXmlSerializer out = new FastXmlSerializer();
                    out.setOutput(stream, StandardCharsets.UTF_8.name());
                    out.startDocument(null, true);
                    out.startTag(null, "ws");
                    out.attribute(null, "version", String.valueOf(2));
                    out.attribute(null, "pkg", backedupPackage);
                    int index = 0;
                    int N = AppWidgetServiceImpl.this.mProviders.size();
                    for (i = 0; i < N; ++i) {
                        Provider provider = (Provider)AppWidgetServiceImpl.this.mProviders.get(i);
                        if (provider.widgets.isEmpty() || !provider.isInPackageForUser(backedupPackage, userId) && !provider.hostedByPackageForUser(backedupPackage, userId)) continue;
                        provider.tag = index++;
                        AppWidgetServiceImpl.serializeProvider(out, provider);
                    }
                    N = AppWidgetServiceImpl.this.mHosts.size();
                    index = 0;
                    for (i = 0; i < N; ++i) {
                        Host host = (Host)AppWidgetServiceImpl.this.mHosts.get(i);
                        if (host.widgets.isEmpty() || !host.isInPackageForUser(backedupPackage, userId) && !host.hostsPackageForUser(backedupPackage, userId)) continue;
                        host.tag = index++;
                        AppWidgetServiceImpl.serializeHost(out, host);
                    }
                    N = AppWidgetServiceImpl.this.mWidgets.size();
                    for (i = 0; i < N; ++i) {
                        Widget widget = (Widget)AppWidgetServiceImpl.this.mWidgets.get(i);
                        Provider provider = widget.provider;
                        if (!widget.host.isInPackageForUser(backedupPackage, userId) && (provider == null || !provider.isInPackageForUser(backedupPackage, userId))) continue;
                        AppWidgetServiceImpl.serializeAppWidget(out, widget);
                    }
                    out.endTag(null, "ws");
                    out.endDocument();
                }
                catch (IOException e) {
                    Slog.w(TAG, "Unable to save widget state for " + backedupPackage);
                    return null;
                }
            }
            return stream.toByteArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restoreStarting(int userId) {
            Slog.i(TAG, "Restore starting for user: " + userId);
            Object object = AppWidgetServiceImpl.this.mLock;
            synchronized (object) {
                this.mPrunedApps.clear();
                this.mUpdatesByProvider.clear();
                this.mUpdatesByHost.clear();
            }
        }

        /*
         * Exception decompiling
         */
        public void restoreWidgetState(String packageName, byte[] restoredState, int userId) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restoreFinished(int userId) {
            Slog.i(TAG, "restoreFinished for " + userId);
            UserHandle userHandle = new UserHandle(userId);
            Object object = AppWidgetServiceImpl.this.mLock;
            synchronized (object) {
                Set<Map.Entry<Provider, ArrayList<RestoreUpdateRecord>>> providerEntries = this.mUpdatesByProvider.entrySet();
                for (Map.Entry<Provider, ArrayList<RestoreUpdateRecord>> e : providerEntries) {
                    Provider provider = e.getKey();
                    ArrayList<RestoreUpdateRecord> updates = e.getValue();
                    int pending = this.countPendingUpdates(updates);
                    Slog.i(TAG, "Provider " + provider + " pending: " + pending);
                    if (pending <= 0) continue;
                    int[] oldIds = new int[pending];
                    int[] newIds = new int[pending];
                    int N = updates.size();
                    int nextPending = 0;
                    for (int i = 0; i < N; ++i) {
                        RestoreUpdateRecord r = updates.get(i);
                        if (r.notified) continue;
                        r.notified = true;
                        oldIds[nextPending] = r.oldId;
                        newIds[nextPending] = r.newId;
                        ++nextPending;
                        Slog.i(TAG, "   " + r.oldId + " => " + r.newId);
                    }
                    this.sendWidgetRestoreBroadcastLocked("android.appwidget.action.APPWIDGET_RESTORED", provider, null, oldIds, newIds, userHandle);
                }
                Set<Map.Entry<Host, ArrayList<RestoreUpdateRecord>>> hostEntries = this.mUpdatesByHost.entrySet();
                for (Map.Entry<Host, ArrayList<RestoreUpdateRecord>> e : hostEntries) {
                    Host host = e.getKey();
                    if (host.id.uid == -1) continue;
                    ArrayList<RestoreUpdateRecord> updates = e.getValue();
                    int pending = this.countPendingUpdates(updates);
                    Slog.i(TAG, "Host " + host + " pending: " + pending);
                    if (pending <= 0) continue;
                    int[] oldIds = new int[pending];
                    int[] newIds = new int[pending];
                    int N = updates.size();
                    int nextPending = 0;
                    for (int i = 0; i < N; ++i) {
                        RestoreUpdateRecord r = updates.get(i);
                        if (r.notified) continue;
                        r.notified = true;
                        oldIds[nextPending] = r.oldId;
                        newIds[nextPending] = r.newId;
                        ++nextPending;
                        Slog.i(TAG, "   " + r.oldId + " => " + r.newId);
                    }
                    this.sendWidgetRestoreBroadcastLocked("android.appwidget.action.APPWIDGET_HOST_RESTORED", null, host, oldIds, newIds, userHandle);
                }
            }
        }

        private Provider findProviderLocked(ComponentName componentName, int userId) {
            int providerCount = AppWidgetServiceImpl.this.mProviders.size();
            for (int i = 0; i < providerCount; ++i) {
                Provider provider = (Provider)AppWidgetServiceImpl.this.mProviders.get(i);
                if (provider.getUserId() != userId || !provider.id.componentName.equals(componentName)) continue;
                return provider;
            }
            return null;
        }

        private Widget findRestoredWidgetLocked(int restoredId, Host host, Provider p) {
            Slog.i(TAG, "Find restored widget: id=" + restoredId + " host=" + host + " provider=" + p);
            if (p == null || host == null) {
                return null;
            }
            int N = AppWidgetServiceImpl.this.mWidgets.size();
            for (int i = 0; i < N; ++i) {
                Widget widget = (Widget)AppWidgetServiceImpl.this.mWidgets.get(i);
                if (widget.restoredId != restoredId || !widget.host.id.equals(host.id) || !widget.provider.id.equals(p.id)) continue;
                Slog.i(TAG, "   Found at " + i + " : " + widget);
                return widget;
            }
            return null;
        }

        private boolean packageNeedsWidgetBackupLocked(String packageName, int userId) {
            int N = AppWidgetServiceImpl.this.mWidgets.size();
            for (int i = 0; i < N; ++i) {
                Widget widget = (Widget)AppWidgetServiceImpl.this.mWidgets.get(i);
                if (!this.isProviderAndHostInUser(widget, userId)) continue;
                if (widget.host.isInPackageForUser(packageName, userId)) {
                    return true;
                }
                Provider provider = widget.provider;
                if (provider == null || !provider.isInPackageForUser(packageName, userId)) continue;
                return true;
            }
            return false;
        }

        private void stashProviderRestoreUpdateLocked(Provider provider, int oldId, int newId) {
            ArrayList<RestoreUpdateRecord> r = this.mUpdatesByProvider.get(provider);
            if (r == null) {
                r = new ArrayList();
                this.mUpdatesByProvider.put(provider, r);
            } else if (this.alreadyStashed(r, oldId, newId)) {
                Slog.i(TAG, "ID remap " + oldId + " -> " + newId + " already stashed for " + provider);
                return;
            }
            r.add(new RestoreUpdateRecord(oldId, newId));
        }

        private boolean alreadyStashed(ArrayList<RestoreUpdateRecord> stash, int oldId, int newId) {
            int N = stash.size();
            for (int i = 0; i < N; ++i) {
                RestoreUpdateRecord r = stash.get(i);
                if (r.oldId != oldId || r.newId != newId) continue;
                return true;
            }
            return false;
        }

        private void stashHostRestoreUpdateLocked(Host host, int oldId, int newId) {
            ArrayList<RestoreUpdateRecord> r = this.mUpdatesByHost.get(host);
            if (r == null) {
                r = new ArrayList();
                this.mUpdatesByHost.put(host, r);
            } else if (this.alreadyStashed(r, oldId, newId)) {
                Slog.i(TAG, "ID remap " + oldId + " -> " + newId + " already stashed for " + host);
                return;
            }
            r.add(new RestoreUpdateRecord(oldId, newId));
        }

        private void sendWidgetRestoreBroadcastLocked(String action, Provider provider, Host host, int[] oldIds, int[] newIds, UserHandle userHandle) {
            Intent intent = new Intent(action);
            intent.putExtra("appWidgetOldIds", oldIds);
            intent.putExtra("appWidgetIds", newIds);
            if (provider != null) {
                intent.setComponent(provider.info.provider);
                AppWidgetServiceImpl.this.sendBroadcastAsUser(intent, userHandle);
            }
            if (host != null) {
                intent.setComponent(null);
                intent.setPackage(host.id.packageName);
                intent.putExtra("hostId", host.id.hostId);
                AppWidgetServiceImpl.this.sendBroadcastAsUser(intent, userHandle);
            }
        }

        private void pruneWidgetStateLocked(String pkg, int userId) {
            if (!this.mPrunedApps.contains(pkg)) {
                Slog.i(TAG, "pruning widget state for restoring package " + pkg);
                for (int i = AppWidgetServiceImpl.this.mWidgets.size() - 1; i >= 0; --i) {
                    Widget widget = (Widget)AppWidgetServiceImpl.this.mWidgets.get(i);
                    Host host = widget.host;
                    Provider provider = widget.provider;
                    if (!host.hostsPackageForUser(pkg, userId) && (provider == null || !provider.isInPackageForUser(pkg, userId))) continue;
                    host.widgets.remove(widget);
                    provider.widgets.remove(widget);
                    AppWidgetServiceImpl.this.unbindAppWidgetRemoteViewsServicesLocked(widget);
                    AppWidgetServiceImpl.this.removeWidgetLocked(widget);
                }
                this.mPrunedApps.add(pkg);
            } else {
                Slog.i(TAG, "already pruned " + pkg + ", continuing normally");
            }
        }

        private boolean isProviderAndHostInUser(Widget widget, int userId) {
            return widget.host.getUserId() == userId && (widget.provider == null || widget.provider.getUserId() == userId);
        }

        private Bundle parseWidgetIdOptions(XmlPullParser parser) {
            String categoryString;
            String maxHeightString;
            String maxWidthString;
            String minHeightString;
            Bundle options = new Bundle();
            String minWidthString = parser.getAttributeValue(null, "min_width");
            if (minWidthString != null) {
                options.putInt("appWidgetMinWidth", Integer.parseInt(minWidthString, 16));
            }
            if ((minHeightString = parser.getAttributeValue(null, "min_height")) != null) {
                options.putInt("appWidgetMinHeight", Integer.parseInt(minHeightString, 16));
            }
            if ((maxWidthString = parser.getAttributeValue(null, "max_width")) != null) {
                options.putInt("appWidgetMaxWidth", Integer.parseInt(maxWidthString, 16));
            }
            if ((maxHeightString = parser.getAttributeValue(null, "max_height")) != null) {
                options.putInt("appWidgetMaxHeight", Integer.parseInt(maxHeightString, 16));
            }
            if ((categoryString = parser.getAttributeValue(null, "host_category")) != null) {
                options.putInt("appWidgetCategory", Integer.parseInt(categoryString, 16));
            }
            return options;
        }

        private int countPendingUpdates(ArrayList<RestoreUpdateRecord> updates) {
            int pending = 0;
            int N = updates.size();
            for (int i = 0; i < N; ++i) {
                RestoreUpdateRecord r = updates.get(i);
                if (r.notified) continue;
                ++pending;
            }
            return pending;
        }

        private class RestoreUpdateRecord {
            public int oldId;
            public int newId;
            public boolean notified;

            public RestoreUpdateRecord(int theOldId, int theNewId) {
                this.oldId = theOldId;
                this.newId = theNewId;
                this.notified = false;
            }
        }
    }

    private final class SaveStateRunnable
    implements Runnable {
        final int mUserId;

        public SaveStateRunnable(int userId) {
            this.mUserId = userId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AppWidgetServiceImpl.this.mLock;
            synchronized (object) {
                AppWidgetServiceImpl.this.ensureGroupStateLoadedLocked(this.mUserId, false);
                AppWidgetServiceImpl.this.saveStateLocked(this.mUserId);
            }
        }
    }

    private class LoadedWidgetState {
        final Widget widget;
        final int hostTag;
        final int providerTag;

        public LoadedWidgetState(Widget widget, int hostTag, int providerTag) {
            this.widget = widget;
            this.hostTag = hostTag;
            this.providerTag = providerTag;
        }
    }

    private static final class ServiceConnectionProxy
    implements ServiceConnection {
        private final IRemoteViewsAdapterConnection mConnectionCb;

        ServiceConnectionProxy(IBinder connectionCb) {
            this.mConnectionCb = IRemoteViewsAdapterConnection.Stub.asInterface(connectionCb);
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this.mConnectionCb.onServiceConnected(service);
            }
            catch (RemoteException re) {
                Slog.e(AppWidgetServiceImpl.TAG, "Error passing service interface", re);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            this.disconnect();
        }

        public void disconnect() {
            try {
                this.mConnectionCb.onServiceDisconnected();
            }
            catch (RemoteException re) {
                Slog.e(AppWidgetServiceImpl.TAG, "Error clearing service interface", re);
            }
        }
    }

    private static final class Widget {
        int appWidgetId;
        int restoredId;
        Provider provider;
        RemoteViews views;
        RemoteViews maskedViews;
        Bundle options;
        Host host;
        SparseLongArray updateRequestIds = new SparseLongArray(2);

        private Widget() {
        }

        public String toString() {
            return "AppWidgetId{" + this.appWidgetId + ':' + this.host + ':' + this.provider + '}';
        }

        private boolean replaceWithMaskedViewsLocked(RemoteViews views) {
            this.maskedViews = views;
            return true;
        }

        private boolean clearMaskedViewsLocked() {
            if (this.maskedViews != null) {
                this.maskedViews = null;
                return true;
            }
            return false;
        }

        public RemoteViews getEffectiveViewsLocked() {
            return this.maskedViews != null ? this.maskedViews : this.views;
        }
    }

    private static final class HostId {
        final int uid;
        final int hostId;
        final String packageName;

        public HostId(int uid, int hostId, String packageName) {
            this.uid = uid;
            this.hostId = hostId;
            this.packageName = packageName;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HostId other = (HostId)obj;
            if (this.uid != other.uid) {
                return false;
            }
            if (this.hostId != other.hostId) {
                return false;
            }
            return !(this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName));
        }

        public int hashCode() {
            int result = this.uid;
            result = 31 * result + this.hostId;
            result = 31 * result + (this.packageName != null ? this.packageName.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "HostId{user:" + UserHandle.getUserId(this.uid) + ", app:" + UserHandle.getAppId(this.uid) + ", hostId:" + this.hostId + ", pkg:" + this.packageName + '}';
        }
    }

    private static final class Host {
        HostId id;
        ArrayList<Widget> widgets = new ArrayList();
        IAppWidgetHost callbacks;
        boolean zombie;
        int tag = -1;
        long lastWidgetUpdateRequestId;

        private Host() {
        }

        public int getUserId() {
            return UserHandle.getUserId(this.id.uid);
        }

        public boolean isInPackageForUser(String packageName, int userId) {
            return this.getUserId() == userId && this.id.packageName.equals(packageName);
        }

        private boolean hostsPackageForUser(String pkg, int userId) {
            int N = this.widgets.size();
            for (int i = 0; i < N; ++i) {
                Provider provider = this.widgets.get((int)i).provider;
                if (provider == null || provider.getUserId() != userId || provider.info == null || !pkg.equals(provider.info.provider.getPackageName())) continue;
                return true;
            }
            return false;
        }

        public boolean getPendingUpdatesForId(int appWidgetId, LongSparseArray<PendingHostUpdate> outUpdates) {
            long updateRequestId = this.lastWidgetUpdateRequestId;
            int N = this.widgets.size();
            for (int i = 0; i < N; ++i) {
                Widget widget = this.widgets.get(i);
                if (widget.appWidgetId != appWidgetId) continue;
                outUpdates.clear();
                for (int j = widget.updateRequestIds.size() - 1; j >= 0; --j) {
                    PendingHostUpdate update;
                    long requestId = widget.updateRequestIds.valueAt(j);
                    if (requestId <= updateRequestId) continue;
                    int id2 = widget.updateRequestIds.keyAt(j);
                    switch (id2) {
                        case 1: {
                            update = PendingHostUpdate.providerChanged(appWidgetId, widget.provider.info);
                            break;
                        }
                        case 0: {
                            update = PendingHostUpdate.updateAppWidget(appWidgetId, AppWidgetServiceImpl.cloneIfLocalBinder(widget.getEffectiveViewsLocked()));
                            break;
                        }
                        default: {
                            update = PendingHostUpdate.viewDataChanged(appWidgetId, id2);
                        }
                    }
                    outUpdates.put(requestId, update);
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return "Host{" + this.id + (this.zombie ? " Z" : "") + '}';
        }
    }

    private static final class ProviderId {
        final int uid;
        final ComponentName componentName;

        private ProviderId(int uid, ComponentName componentName) {
            this.uid = uid;
            this.componentName = componentName;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProviderId other = (ProviderId)obj;
            if (this.uid != other.uid) {
                return false;
            }
            return !(this.componentName == null ? other.componentName != null : !this.componentName.equals(other.componentName));
        }

        public int hashCode() {
            int result = this.uid;
            result = 31 * result + (this.componentName != null ? this.componentName.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ProviderId{user:" + UserHandle.getUserId(this.uid) + ", app:" + UserHandle.getAppId(this.uid) + ", cmp:" + this.componentName + '}';
        }
    }

    private static final class Provider {
        ProviderId id;
        AppWidgetProviderInfo info;
        ArrayList<Widget> widgets = new ArrayList();
        PendingIntent broadcast;
        boolean zombie;
        boolean maskedByLockedProfile;
        boolean maskedByQuietProfile;
        boolean maskedBySuspendedPackage;
        int tag = -1;

        private Provider() {
        }

        public int getUserId() {
            return UserHandle.getUserId(this.id.uid);
        }

        public boolean isInPackageForUser(String packageName, int userId) {
            return this.getUserId() == userId && this.id.componentName.getPackageName().equals(packageName);
        }

        public boolean hostedByPackageForUser(String packageName, int userId) {
            int N = this.widgets.size();
            for (int i = 0; i < N; ++i) {
                Widget widget = this.widgets.get(i);
                if (!packageName.equals(widget.host.id.packageName) || widget.host.getUserId() != userId) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "Provider{" + this.id + (this.zombie ? " Z" : "") + '}';
        }

        public boolean setMaskedByQuietProfileLocked(boolean masked) {
            boolean oldState = this.maskedByQuietProfile;
            this.maskedByQuietProfile = masked;
            return masked != oldState;
        }

        public boolean setMaskedByLockedProfileLocked(boolean masked) {
            boolean oldState = this.maskedByLockedProfile;
            this.maskedByLockedProfile = masked;
            return masked != oldState;
        }

        public boolean setMaskedBySuspendedPackageLocked(boolean masked) {
            boolean oldState = this.maskedBySuspendedPackage;
            this.maskedBySuspendedPackage = masked;
            return masked != oldState;
        }

        public boolean isMaskedLocked() {
            return this.maskedByQuietProfile || this.maskedByLockedProfile || this.maskedBySuspendedPackage;
        }
    }

    private final class SecurityPolicy {
        private SecurityPolicy() {
        }

        public boolean isEnabledGroupProfile(int profileId) {
            int parentId = UserHandle.getCallingUserId();
            return this.isParentOrProfile(parentId, profileId) && this.isProfileEnabled(profileId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getEnabledGroupProfileIds(int userId) {
            int parentId = this.getGroupParent(userId);
            long identity = Binder.clearCallingIdentity();
            try {
                int[] nArray = AppWidgetServiceImpl.this.mUserManager.getEnabledProfileIds(parentId);
                return nArray;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enforceServiceExistsAndRequiresBindRemoteViewsPermission(ComponentName componentName, int userId) {
            long identity = Binder.clearCallingIdentity();
            try {
                ServiceInfo serviceInfo = AppWidgetServiceImpl.this.mPackageManager.getServiceInfo(componentName, 4096, userId);
                if (serviceInfo == null) {
                    throw new SecurityException("Service " + componentName + " not installed for user " + userId);
                }
                if (!"android.permission.BIND_REMOTEVIEWS".equals(serviceInfo.permission)) {
                    throw new SecurityException("Service " + componentName + " in user " + userId + "does not require " + "android.permission.BIND_REMOTEVIEWS");
                }
            }
            catch (RemoteException remoteException) {
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        public void enforceModifyAppWidgetBindPermissions(String packageName) {
            AppWidgetServiceImpl.this.mContext.enforceCallingPermission("android.permission.MODIFY_APPWIDGET_BIND_PERMISSIONS", "hasBindAppWidgetPermission packageName=" + packageName);
        }

        public void enforceCallFromPackage(String packageName) {
            AppWidgetServiceImpl.this.mAppOpsManager.checkPackage(Binder.getCallingUid(), packageName);
        }

        public boolean hasCallerBindPermissionOrBindWhiteListedLocked(String packageName) {
            block2: {
                try {
                    AppWidgetServiceImpl.this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_APPWIDGET", null);
                }
                catch (SecurityException se) {
                    if (this.isCallerBindAppWidgetWhiteListedLocked(packageName)) break block2;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isCallerBindAppWidgetWhiteListedLocked(String packageName) {
            int userId = UserHandle.getCallingUserId();
            int packageUid = AppWidgetServiceImpl.this.getUidForPackage(packageName, userId);
            if (packageUid < 0) {
                throw new IllegalArgumentException("No package " + packageName + " for user " + userId);
            }
            Object object = AppWidgetServiceImpl.this.mLock;
            synchronized (object) {
                AppWidgetServiceImpl.this.ensureGroupStateLoadedLocked(userId);
                Pair<Integer, String> packageId = Pair.create(userId, packageName);
                if (AppWidgetServiceImpl.this.mPackagesWithBindWidgetPermission.contains(packageId)) {
                    return true;
                }
            }
            return false;
        }

        public boolean canAccessAppWidget(Widget widget, int uid, String packageName) {
            if (this.isHostInPackageForUid(widget.host, uid, packageName)) {
                return true;
            }
            if (this.isProviderInPackageForUid(widget.provider, uid, packageName)) {
                return true;
            }
            if (this.isHostAccessingProvider(widget.host, widget.provider, uid, packageName)) {
                return true;
            }
            int userId = UserHandle.getUserId(uid);
            return (widget.host.getUserId() == userId || widget.provider != null && widget.provider.getUserId() == userId) && AppWidgetServiceImpl.this.mContext.checkCallingPermission("android.permission.BIND_APPWIDGET") == 0;
        }

        private boolean isParentOrProfile(int parentId, int profileId) {
            if (parentId == profileId) {
                return true;
            }
            return this.getProfileParent(profileId) == parentId;
        }

        public boolean isProviderInCallerOrInProfileAndWhitelListed(String packageName, int profileId) {
            int callerId = UserHandle.getCallingUserId();
            if (profileId == callerId) {
                return true;
            }
            int parentId = this.getProfileParent(profileId);
            if (parentId != callerId) {
                return false;
            }
            return this.isProviderWhiteListed(packageName, profileId);
        }

        public boolean isProviderWhiteListed(String packageName, int profileId) {
            if (AppWidgetServiceImpl.this.mDevicePolicyManagerInternal == null) {
                return false;
            }
            List<String> crossProfilePackages = AppWidgetServiceImpl.this.mDevicePolicyManagerInternal.getCrossProfileWidgetProviders(profileId);
            return crossProfilePackages.contains(packageName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getProfileParent(int profileId) {
            long identity = Binder.clearCallingIdentity();
            try {
                UserInfo parent = AppWidgetServiceImpl.this.mUserManager.getProfileParent(profileId);
                if (parent != null) {
                    int n = parent.getUserHandle().getIdentifier();
                    return n;
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            return -10;
        }

        public int getGroupParent(int profileId) {
            int parentId = AppWidgetServiceImpl.this.mSecurityPolicy.getProfileParent(profileId);
            return parentId != -10 ? parentId : profileId;
        }

        public boolean isHostInPackageForUid(Host host, int uid, String packageName) {
            return host.id.uid == uid && host.id.packageName.equals(packageName);
        }

        public boolean isProviderInPackageForUid(Provider provider, int uid, String packageName) {
            return provider != null && provider.id.uid == uid && provider.id.componentName.getPackageName().equals(packageName);
        }

        public boolean isHostAccessingProvider(Host host, Provider provider, int uid, String packageName) {
            return host.id.uid == uid && provider != null && provider.id.componentName.getPackageName().equals(packageName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isProfileEnabled(int profileId) {
            long identity = Binder.clearCallingIdentity();
            try {
                UserInfo userInfo = AppWidgetServiceImpl.this.mUserManager.getUserInfo(profileId);
                if (userInfo == null || !userInfo.isEnabled()) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            return true;
        }
    }

    private final class CallbackHandler
    extends Handler {
        public static final int MSG_NOTIFY_UPDATE_APP_WIDGET = 1;
        public static final int MSG_NOTIFY_PROVIDER_CHANGED = 2;
        public static final int MSG_NOTIFY_PROVIDERS_CHANGED = 3;
        public static final int MSG_NOTIFY_VIEW_DATA_CHANGED = 4;

        public CallbackHandler(Looper looper) {
            super(looper, null, false);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)message.obj;
                    Host host = (Host)args.arg1;
                    IAppWidgetHost callbacks = (IAppWidgetHost)args.arg2;
                    RemoteViews views = (RemoteViews)args.arg3;
                    long requestId = (Long)args.arg4;
                    int appWidgetId = args.argi1;
                    args.recycle();
                    AppWidgetServiceImpl.this.handleNotifyUpdateAppWidget(host, callbacks, appWidgetId, views, requestId);
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)message.obj;
                    Host host = (Host)args.arg1;
                    IAppWidgetHost callbacks = (IAppWidgetHost)args.arg2;
                    AppWidgetProviderInfo info = (AppWidgetProviderInfo)args.arg3;
                    long requestId = (Long)args.arg4;
                    int appWidgetId = args.argi1;
                    args.recycle();
                    AppWidgetServiceImpl.this.handleNotifyProviderChanged(host, callbacks, appWidgetId, info, requestId);
                    break;
                }
                case 3: {
                    SomeArgs args = (SomeArgs)message.obj;
                    Host host = (Host)args.arg1;
                    IAppWidgetHost callbacks = (IAppWidgetHost)args.arg2;
                    args.recycle();
                    AppWidgetServiceImpl.this.handleNotifyProvidersChanged(host, callbacks);
                    break;
                }
                case 4: {
                    SomeArgs args = (SomeArgs)message.obj;
                    Host host = (Host)args.arg1;
                    IAppWidgetHost callbacks = (IAppWidgetHost)args.arg2;
                    long requestId = (Long)args.arg3;
                    int appWidgetId = args.argi1;
                    int viewId = args.argi2;
                    args.recycle();
                    AppWidgetServiceImpl.this.handleNotifyAppWidgetViewDataChanged(host, callbacks, appWidgetId, viewId, requestId);
                }
            }
        }
    }
}

