/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.AppGlobals;
import android.app.IActivityController;
import android.app.ResultInfo;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.service.voice.IVoiceInteractionSession;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.IntArray;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.os.BatteryStatsImpl;
import com.android.server.Watchdog;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.AppTimeTracker;
import com.android.server.am.ConfigurationContainer;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.EventLogTags;
import com.android.server.am.LaunchingTaskPositioner;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.RecentTasks;
import com.android.server.am.TaskRecord;
import com.android.server.wm.StackWindowController;
import com.android.server.wm.StackWindowListener;
import com.android.server.wm.WindowManagerService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

class ActivityStack<T extends StackWindowController>
extends ConfigurationContainer
implements StackWindowListener {
    private static final String TAG = "ActivityManager";
    private static final String TAG_ADD_REMOVE = "ActivityManager";
    private static final String TAG_APP = "ActivityManager";
    private static final String TAG_CLEANUP = "ActivityManager";
    private static final String TAG_CONTAINERS = "ActivityManager";
    private static final String TAG_PAUSE = "ActivityManager";
    private static final String TAG_RELEASE = "ActivityManager";
    private static final String TAG_RESULTS = "ActivityManager";
    private static final String TAG_SAVED_STATE = "ActivityManager";
    private static final String TAG_STACK = "ActivityManager";
    private static final String TAG_STATES = "ActivityManager";
    private static final String TAG_SWITCH = "ActivityManager";
    private static final String TAG_TASKS = "ActivityManager";
    private static final String TAG_TRANSITION = "ActivityManager";
    private static final String TAG_USER_LEAVING = "ActivityManager";
    private static final String TAG_VISIBILITY = "ActivityManager";
    static final int LAUNCH_TICK = 500;
    private static final int PAUSE_TIMEOUT = 500;
    private static final int STOP_TIMEOUT = 10000;
    private static final int DESTROY_TIMEOUT = 10000;
    private static final long ACTIVITY_INACTIVE_RESET_TIME = 0L;
    private static final boolean SHOW_APP_STARTING_PREVIEW = true;
    private static final long TRANSLUCENT_CONVERSION_TIMEOUT = 2000L;
    private static final int MAX_STOPPING_TO_FORCE = 3;
    static final int STACK_INVISIBLE = 0;
    static final int STACK_VISIBLE = 1;
    protected static final int REMOVE_TASK_MODE_DESTROYING = 0;
    static final int REMOVE_TASK_MODE_MOVING = 1;
    static final int REMOVE_TASK_MODE_MOVING_TO_TOP = 2;
    private static final int FIT_WITHIN_BOUNDS_DIVIDER = 3;
    final ActivityManagerService mService;
    private final WindowManagerService mWindowManager;
    T mWindowContainerController;
    private final RecentTasks mRecentTasks;
    private final ArrayList<TaskRecord> mTaskHistory = new ArrayList();
    final ArrayList<ActivityRecord> mLRUActivities = new ArrayList();
    final ArrayList<ActivityRecord> mNoAnimActivities = new ArrayList();
    ActivityRecord mPausingActivity = null;
    ActivityRecord mLastPausedActivity = null;
    ActivityRecord mLastNoHistoryActivity = null;
    ActivityRecord mResumedActivity = null;
    ActivityRecord mTranslucentActivityWaiting = null;
    ArrayList<ActivityRecord> mUndrawnActivitiesBelowTopTranslucent = new ArrayList();
    boolean mConfigWillChange;
    boolean mForceHidden = false;
    boolean mFullscreen = true;
    Rect mBounds = null;
    private boolean mUpdateBoundsDeferred;
    private boolean mUpdateBoundsDeferredCalled;
    private final Rect mDeferredBounds = new Rect();
    private final Rect mDeferredTaskBounds = new Rect();
    private final Rect mDeferredTaskInsetBounds = new Rect();
    long mLaunchStartTime = 0L;
    long mFullyDrawnStartTime = 0L;
    int mCurrentUser;
    final int mStackId;
    ArrayList<ActivityStack> mStacks;
    int mDisplayId;
    private final SparseArray<Configuration> mTmpConfigs = new SparseArray();
    private final SparseArray<Rect> mTmpBounds = new SparseArray();
    private final SparseArray<Rect> mTmpInsetBounds = new SparseArray();
    private final Rect mTmpRect2 = new Rect();
    protected final ActivityStackSupervisor mStackSupervisor;
    private final LaunchingTaskPositioner mTaskPositioner;
    private boolean mTopActivityOccludesKeyguard;
    private ActivityRecord mTopDismissingKeyguardActivity;
    static final int PAUSE_TIMEOUT_MSG = 101;
    static final int DESTROY_TIMEOUT_MSG = 102;
    static final int LAUNCH_TICK_MSG = 103;
    static final int STOP_TIMEOUT_MSG = 104;
    static final int DESTROY_ACTIVITIES_MSG = 105;
    static final int TRANSLUCENT_TIMEOUT_MSG = 106;
    final Handler mHandler;
    static final int FINISH_IMMEDIATELY = 0;
    static final int FINISH_AFTER_PAUSE = 1;
    static final int FINISH_AFTER_VISIBLE = 2;

    @Override
    protected int getChildCount() {
        return this.mTaskHistory.size();
    }

    protected ConfigurationContainer getChildAt(int index) {
        return this.mTaskHistory.get(index);
    }

    @Override
    protected ConfigurationContainer getParent() {
        return this.getDisplay();
    }

    @Override
    void onParentChanged() {
        super.onParentChanged();
        this.mStackSupervisor.updateUIDsPresentOnDisplay();
    }

    int numActivities() {
        int count = 0;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            count += this.mTaskHistory.get((int)taskNdx).mActivities.size();
        }
        return count;
    }

    ActivityStack(ActivityStackSupervisor.ActivityDisplay display, int stackId, ActivityStackSupervisor supervisor, RecentTasks recentTasks, boolean onTop) {
        this.mStackSupervisor = supervisor;
        this.mService = supervisor.mService;
        this.mHandler = new ActivityStackHandler(this.mService.mHandler.getLooper());
        this.mWindowManager = this.mService.mWindowManager;
        this.mStackId = stackId;
        this.mCurrentUser = this.mService.mUserController.getCurrentUserIdLocked();
        this.mRecentTasks = recentTasks;
        this.mTaskPositioner = this.mStackId == 2 ? new LaunchingTaskPositioner() : null;
        this.mTmpRect2.setEmpty();
        this.mWindowContainerController = this.createStackWindowController(display.mDisplayId, onTop, this.mTmpRect2);
        this.mStackSupervisor.mStacks.put(this.mStackId, this);
        this.postAddToDisplay(display, this.mTmpRect2.isEmpty() ? null : this.mTmpRect2, onTop);
    }

    T createStackWindowController(int displayId, boolean onTop, Rect outBounds) {
        return (T)new StackWindowController(this.mStackId, this, displayId, onTop, outBounds);
    }

    T getWindowContainerController() {
        return this.mWindowContainerController;
    }

    void reparent(ActivityStackSupervisor.ActivityDisplay activityDisplay, boolean onTop) {
        this.removeFromDisplay();
        this.mTmpRect2.setEmpty();
        this.postAddToDisplay(activityDisplay, this.mTmpRect2.isEmpty() ? null : this.mTmpRect2, onTop);
        this.adjustFocusToNextFocusableStackLocked("reparent", true);
        this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
        ((StackWindowController)this.mWindowContainerController).reparent(activityDisplay.mDisplayId, this.mTmpRect2, onTop);
    }

    private void postAddToDisplay(ActivityStackSupervisor.ActivityDisplay activityDisplay, Rect bounds, boolean onTop) {
        this.mDisplayId = activityDisplay.mDisplayId;
        this.mStacks = activityDisplay.mStacks;
        this.mBounds = bounds != null ? new Rect(bounds) : null;
        boolean bl = this.mFullscreen = this.mBounds == null;
        if (this.mTaskPositioner != null) {
            this.mTaskPositioner.setDisplay(activityDisplay.mDisplay);
            this.mTaskPositioner.configure(this.mBounds);
        }
        this.onParentChanged();
        activityDisplay.attachStack(this, this.findStackInsertIndex(onTop));
        if (this.mStackId == 3) {
            this.mStackSupervisor.resizeDockedStackLocked(this.mBounds, null, null, null, null, true);
        }
    }

    private void removeFromDisplay() {
        ActivityStackSupervisor.ActivityDisplay display = this.getDisplay();
        if (display != null) {
            display.detachStack(this);
        }
        this.mDisplayId = -1;
        this.mStacks = null;
        if (this.mTaskPositioner != null) {
            this.mTaskPositioner.reset();
        }
        if (this.mStackId == 3) {
            this.mStackSupervisor.resizeDockedStackLocked(null, null, null, null, null, true);
        }
    }

    void remove() {
        this.removeFromDisplay();
        this.mStackSupervisor.mStacks.remove(this.mStackId);
        ((StackWindowController)this.mWindowContainerController).removeContainer();
        this.mWindowContainerController = null;
        this.onParentChanged();
    }

    ActivityStackSupervisor.ActivityDisplay getDisplay() {
        return this.mStackSupervisor.getActivityDisplay(this.mDisplayId);
    }

    void getDisplaySize(Point out) {
        this.getDisplay().mDisplay.getSize(out);
    }

    void getStackDockedModeBounds(Rect currentTempTaskBounds, Rect outStackBounds, Rect outTempTaskBounds, boolean ignoreVisibility) {
        ((StackWindowController)this.mWindowContainerController).getStackDockedModeBounds(currentTempTaskBounds, outStackBounds, outTempTaskBounds, ignoreVisibility);
    }

    void prepareFreezingTaskBounds() {
        ((StackWindowController)this.mWindowContainerController).prepareFreezingTaskBounds();
    }

    void getWindowContainerBounds(Rect outBounds) {
        if (this.mWindowContainerController != null) {
            ((StackWindowController)this.mWindowContainerController).getBounds(outBounds);
            return;
        }
        outBounds.setEmpty();
    }

    void getBoundsForNewConfiguration(Rect outBounds) {
        ((StackWindowController)this.mWindowContainerController).getBoundsForNewConfiguration(outBounds);
    }

    void positionChildWindowContainerAtTop(TaskRecord child) {
        ((StackWindowController)this.mWindowContainerController).positionChildAtTop(child.getWindowContainerController(), true);
    }

    boolean deferScheduleMultiWindowModeChanged() {
        return false;
    }

    void deferUpdateBounds() {
        if (!this.mUpdateBoundsDeferred) {
            this.mUpdateBoundsDeferred = true;
            this.mUpdateBoundsDeferredCalled = false;
        }
    }

    void continueUpdateBounds() {
        boolean wasDeferred = this.mUpdateBoundsDeferred;
        this.mUpdateBoundsDeferred = false;
        if (wasDeferred && this.mUpdateBoundsDeferredCalled) {
            this.resize(this.mDeferredBounds.isEmpty() ? null : this.mDeferredBounds, this.mDeferredTaskBounds.isEmpty() ? null : this.mDeferredTaskBounds, this.mDeferredTaskInsetBounds.isEmpty() ? null : this.mDeferredTaskInsetBounds);
        }
    }

    boolean updateBoundsAllowed(Rect bounds, Rect tempTaskBounds, Rect tempTaskInsetBounds) {
        if (!this.mUpdateBoundsDeferred) {
            return true;
        }
        if (bounds != null) {
            this.mDeferredBounds.set(bounds);
        } else {
            this.mDeferredBounds.setEmpty();
        }
        if (tempTaskBounds != null) {
            this.mDeferredTaskBounds.set(tempTaskBounds);
        } else {
            this.mDeferredTaskBounds.setEmpty();
        }
        if (tempTaskInsetBounds != null) {
            this.mDeferredTaskInsetBounds.set(tempTaskInsetBounds);
        } else {
            this.mDeferredTaskInsetBounds.setEmpty();
        }
        this.mUpdateBoundsDeferredCalled = true;
        return false;
    }

    void setBounds(Rect bounds) {
        Rect rect = this.mBounds = this.mFullscreen ? null : new Rect(bounds);
        if (this.mTaskPositioner != null) {
            this.mTaskPositioner.configure(bounds);
        }
    }

    ActivityRecord topRunningActivityLocked() {
        return this.topRunningActivityLocked(false);
    }

    void getAllRunningVisibleActivitiesLocked(ArrayList<ActivityRecord> outActivities) {
        outActivities.clear();
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            this.mTaskHistory.get(taskNdx).getAllRunningVisibleActivitiesLocked(outActivities);
        }
    }

    private ActivityRecord topRunningActivityLocked(boolean focusableOnly) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ActivityRecord r = this.mTaskHistory.get(taskNdx).topRunningActivityLocked();
            if (r == null || focusableOnly && !r.isFocusable()) continue;
            return r;
        }
        return null;
    }

    ActivityRecord topRunningNonOverlayTaskActivity() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing || r.mTaskOverlay) continue;
                return r;
            }
        }
        return null;
    }

    ActivityRecord topRunningNonDelayedActivityLocked(ActivityRecord notTop) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing || r.delayedResume || r == notTop || !r.okToShowLocked()) continue;
                return r;
            }
        }
        return null;
    }

    final ActivityRecord topRunningActivityLocked(IBinder token, int taskId) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.taskId == taskId) continue;
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int i = activities.size() - 1; i >= 0; --i) {
                ActivityRecord r = activities.get(i);
                if (r.finishing || token == r.appToken || !r.okToShowLocked()) continue;
                return r;
            }
        }
        return null;
    }

    final ActivityRecord topActivity() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing) continue;
                return r;
            }
        }
        return null;
    }

    final TaskRecord topTask() {
        int size = this.mTaskHistory.size();
        if (size > 0) {
            return this.mTaskHistory.get(size - 1);
        }
        return null;
    }

    final TaskRecord bottomTask() {
        if (this.mTaskHistory.isEmpty()) {
            return null;
        }
        return this.mTaskHistory.get(0);
    }

    TaskRecord taskForIdLocked(int id2) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.taskId != id2) continue;
            return task;
        }
        return null;
    }

    ActivityRecord isInStackLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        return this.isInStackLocked(r);
    }

    ActivityRecord isInStackLocked(ActivityRecord r) {
        if (r == null) {
            return null;
        }
        TaskRecord task = r.getTask();
        Object stack = r.getStack();
        if (stack != null && task.mActivities.contains(r) && this.mTaskHistory.contains(task)) {
            if (stack != this) {
                Slog.w("ActivityManager", "Illegal state! task does not point to stack it is in.");
            }
            return r;
        }
        return null;
    }

    boolean isInStackLocked(TaskRecord task) {
        return this.mTaskHistory.contains(task);
    }

    boolean isUidPresent(int uid) {
        for (TaskRecord task : this.mTaskHistory) {
            for (ActivityRecord r : task.mActivities) {
                if (r.getUid() != uid) continue;
                return true;
            }
        }
        return false;
    }

    void getPresentUIDs(IntArray presentUIDs) {
        for (TaskRecord task : this.mTaskHistory) {
            for (ActivityRecord r : task.mActivities) {
                presentUIDs.add(r.getUid());
            }
        }
    }

    final void removeActivitiesFromLRUListLocked(TaskRecord task) {
        for (ActivityRecord r : task.mActivities) {
            this.mLRUActivities.remove(r);
        }
    }

    final boolean updateLRUListLocked(ActivityRecord r) {
        boolean hadit = this.mLRUActivities.remove(r);
        this.mLRUActivities.add(r);
        return hadit;
    }

    final boolean isHomeStack() {
        return this.mStackId == 0;
    }

    final boolean isRecentsStack() {
        return this.mStackId == 5;
    }

    final boolean isHomeOrRecentsStack() {
        return ActivityManager.StackId.isHomeOrRecentsStack(this.mStackId);
    }

    final boolean isDockedStack() {
        return this.mStackId == 3;
    }

    final boolean isPinnedStack() {
        return this.mStackId == 4;
    }

    final boolean isAssistantStack() {
        return this.mStackId == 6;
    }

    final boolean isOnHomeDisplay() {
        return this.isAttached() && this.mDisplayId == 0;
    }

    void moveToFront(String reason) {
        this.moveToFront(reason, null);
    }

    void moveToFront(String reason, TaskRecord task) {
        if (!this.isAttached()) {
            return;
        }
        this.mStacks.remove(this);
        this.mStacks.add(this.findStackInsertIndex(true), this);
        this.mStackSupervisor.setFocusStackUnchecked(reason, this);
        if (task != null) {
            this.insertTaskAtTop(task, null);
            return;
        }
        task = this.topTask();
        if (task != null) {
            ((StackWindowController)this.mWindowContainerController).positionChildAtTop(task.getWindowContainerController(), true);
        }
    }

    private void moveToBack(TaskRecord task) {
        if (!this.isAttached()) {
            return;
        }
        this.mStacks.remove(this);
        this.mStacks.add(0, this);
        if (task != null) {
            this.mTaskHistory.remove(task);
            this.mTaskHistory.add(0, task);
            this.updateTaskMovement(task, false);
            ((StackWindowController)this.mWindowContainerController).positionChildAtBottom(task.getWindowContainerController());
        }
    }

    private int findStackInsertIndex(boolean onTop) {
        if (onTop) {
            int addIndex = this.mStacks.size();
            if (addIndex > 0) {
                ActivityStack topStack = this.mStacks.get(addIndex - 1);
                if (ActivityManager.StackId.isAlwaysOnTop(topStack.mStackId) && topStack != this) {
                    --addIndex;
                }
            }
            return addIndex;
        }
        return 0;
    }

    boolean isFocusable() {
        if (ActivityManager.StackId.canReceiveKeys(this.mStackId)) {
            return true;
        }
        ActivityRecord r = this.topRunningActivityLocked();
        return r != null && r.isFocusable();
    }

    final boolean isAttached() {
        return this.mStacks != null;
    }

    void findTaskLocked(ActivityRecord target, ActivityStackSupervisor.FindTaskResult result) {
        Intent intent = target.intent;
        ActivityInfo info = target.info;
        ComponentName cls = intent.getComponent();
        if (info.targetActivity != null) {
            cls = new ComponentName(info.packageName, info.targetActivity);
        }
        int userId = UserHandle.getUserId(info.applicationInfo.uid);
        boolean isDocument = intent != null & intent.isDocument();
        Uri documentData = isDocument ? intent.getData() : null;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            Uri taskDocumentData;
            boolean taskIsDocument;
            ActivityRecord r;
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.voiceSession != null || task.userId != userId || (r = task.getTopActivity(false)) == null || r.finishing || r.userId != userId || r.launchMode == 3 || r.mActivityType != target.mActivityType) continue;
            Intent taskIntent = task.intent;
            Intent affinityIntent = task.affinityIntent;
            if (taskIntent != null && taskIntent.isDocument()) {
                taskIsDocument = true;
                taskDocumentData = taskIntent.getData();
            } else if (affinityIntent != null && affinityIntent.isDocument()) {
                taskIsDocument = true;
                taskDocumentData = affinityIntent.getData();
            } else {
                taskIsDocument = false;
                taskDocumentData = null;
            }
            if (taskIntent != null && taskIntent.getComponent() != null && taskIntent.getComponent().compareTo(cls) == 0 && Objects.equals(documentData, taskDocumentData)) {
                result.r = r;
                result.matchedByRootAffinity = false;
                break;
            }
            if (affinityIntent != null && affinityIntent.getComponent() != null && affinityIntent.getComponent().compareTo(cls) == 0 && Objects.equals(documentData, taskDocumentData)) {
                result.r = r;
                result.matchedByRootAffinity = false;
                break;
            }
            if (isDocument || taskIsDocument || result.r != null || task.rootAffinity == null || !task.rootAffinity.equals(target.taskAffinity)) continue;
            result.r = r;
            result.matchedByRootAffinity = true;
        }
    }

    ActivityRecord findActivityLocked(Intent intent, ActivityInfo info, boolean compareIntentFilters) {
        ComponentName cls = intent.getComponent();
        if (info.targetActivity != null) {
            cls = new ComponentName(info.packageName, info.targetActivity);
        }
        int userId = UserHandle.getUserId(info.applicationInfo.uid);
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (!r.okToShowLocked() || r.finishing || r.userId != userId || !(compareIntentFilters ? r.intent.filterEquals(intent) : r.intent.getComponent().equals(cls))) continue;
                return r;
            }
        }
        return null;
    }

    final void switchUserLocked(int userId) {
        if (this.mCurrentUser == userId) {
            return;
        }
        this.mCurrentUser = userId;
        int index = this.mTaskHistory.size();
        int i = 0;
        while (i < index) {
            TaskRecord task = this.mTaskHistory.get(i);
            if (task.okToShowLocked()) {
                this.mTaskHistory.remove(i);
                this.mTaskHistory.add(task);
                --index;
                continue;
            }
            ++i;
        }
    }

    void minimalResumeActivityLocked(ActivityRecord r) {
        this.setResumedActivityLocked(r, "minimalResumeActivityLocked");
        r.completeResumeLocked();
        this.setLaunchTime(r);
    }

    void addRecentActivityLocked(ActivityRecord r) {
        if (r != null) {
            TaskRecord task = r.getTask();
            this.mRecentTasks.addLocked(task);
            task.touchActiveTime();
        }
    }

    private void startLaunchTraces(String packageName) {
        if (this.mFullyDrawnStartTime != 0L) {
            Trace.asyncTraceEnd(64L, "drawing", 0);
        }
        Trace.asyncTraceBegin(64L, "launching: " + packageName, 0);
        Trace.asyncTraceBegin(64L, "drawing", 0);
    }

    private void stopFullyDrawnTraceIfNeeded() {
        if (this.mFullyDrawnStartTime != 0L && this.mLaunchStartTime == 0L) {
            Trace.asyncTraceEnd(64L, "drawing", 0);
            this.mFullyDrawnStartTime = 0L;
        }
    }

    void setLaunchTime(ActivityRecord r) {
        if (r.displayStartTime == 0L) {
            r.fullyDrawnStartTime = r.displayStartTime = SystemClock.uptimeMillis();
            if (this.mLaunchStartTime == 0L) {
                this.startLaunchTraces(r.packageName);
                this.mLaunchStartTime = this.mFullyDrawnStartTime = r.displayStartTime;
            }
        } else if (this.mLaunchStartTime == 0L) {
            this.startLaunchTraces(r.packageName);
            this.mLaunchStartTime = this.mFullyDrawnStartTime = SystemClock.uptimeMillis();
        }
    }

    private void clearLaunchTime(ActivityRecord r) {
        if (this.mStackSupervisor.mWaitingActivityLaunched.isEmpty()) {
            r.fullyDrawnStartTime = 0L;
            r.displayStartTime = 0L;
        } else {
            this.mStackSupervisor.removeTimeoutsForActivityLocked(r);
            this.mStackSupervisor.scheduleIdleTimeoutLocked(r);
        }
    }

    void awakeFromSleepingLocked() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                activities.get(activityNdx).setSleeping(false);
            }
        }
        if (this.mPausingActivity != null) {
            Slog.d("ActivityManager", "awakeFromSleepingLocked: previously pausing activity didn't pause");
            this.activityPausedLocked(this.mPausingActivity.appToken, true);
        }
    }

    void updateActivityApplicationInfoLocked(ApplicationInfo aInfo) {
        String packageName = aInfo.packageName;
        int userId = UserHandle.getUserId(aInfo.uid);
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord ar = (ActivityRecord)activities.get(activityNdx);
                if (userId != ar.userId || !packageName.equals(ar.packageName)) continue;
                ar.info.applicationInfo = aInfo;
            }
        }
    }

    void checkReadyForSleep() {
        if (this.shouldSleepActivities() && this.goToSleepIfPossible(false)) {
            this.mStackSupervisor.checkReadyForSleepLocked(true);
        }
    }

    boolean goToSleepIfPossible(boolean shuttingDown) {
        boolean shouldSleep = true;
        if (this.mResumedActivity != null) {
            if (!this.mStackSupervisor.inResumeTopActivity) {
                this.startPausingLocked(false, true, null, false);
            }
            shouldSleep = false;
        } else if (this.mPausingActivity != null) {
            shouldSleep = false;
        }
        if (!shuttingDown) {
            if (this.containsActivityFromStack(this.mStackSupervisor.mStoppingActivities)) {
                this.mStackSupervisor.scheduleIdleLocked();
                shouldSleep = false;
            }
            if (this.containsActivityFromStack(this.mStackSupervisor.mGoingToSleepActivities)) {
                shouldSleep = false;
            }
        }
        if (shouldSleep) {
            this.goToSleep();
        }
        return shouldSleep;
    }

    void goToSleep() {
        this.ensureActivitiesVisibleLocked(null, 0, false);
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.state != ActivityState.STOPPING && r.state != ActivityState.STOPPED && r.state != ActivityState.PAUSED && r.state != ActivityState.PAUSING) continue;
                r.setSleeping(true);
            }
        }
    }

    private boolean containsActivityFromStack(List<ActivityRecord> rs) {
        for (ActivityRecord r : rs) {
            if (r.getStack() != this) continue;
            return true;
        }
        return false;
    }

    private void schedulePauseTimeout(ActivityRecord r) {
        Message msg = this.mHandler.obtainMessage(101);
        msg.obj = r;
        r.pauseTime = SystemClock.uptimeMillis();
        this.mHandler.sendMessageDelayed(msg, 500L);
    }

    final boolean startPausingLocked(boolean userLeaving, boolean uiSleeping, ActivityRecord resuming, boolean pauseImmediately) {
        ActivityRecord prev;
        if (this.mPausingActivity != null) {
            Slog.wtf("ActivityManager", "Going to pause when pause is already pending for " + this.mPausingActivity + " state=" + (Object)((Object)this.mPausingActivity.state));
            if (!this.shouldSleepActivities()) {
                this.completePauseLocked(false, resuming);
            }
        }
        if ((prev = this.mResumedActivity) == null) {
            if (resuming == null) {
                Slog.wtf("ActivityManager", "Trying to pause when nothing is resumed");
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            }
            return false;
        }
        this.mResumedActivity = null;
        this.mPausingActivity = prev;
        this.mLastPausedActivity = prev;
        this.mLastNoHistoryActivity = (prev.intent.getFlags() & 0x40000000) != 0 || (prev.info.flags & 0x80) != 0 ? prev : null;
        prev.state = ActivityState.PAUSING;
        prev.getTask().touchActiveTime();
        this.clearLaunchTime(prev);
        ActivityRecord next = this.mStackSupervisor.topRunningActivityLocked();
        if (this.mService.mHasRecents && (next == null || next.noDisplay || next.getTask() != prev.getTask() || uiSleeping)) {
            prev.mUpdateTaskThumbnailWhenHidden = true;
        }
        this.stopFullyDrawnTraceIfNeeded();
        this.mService.updateCpuStats();
        if (prev.app != null && prev.app.thread != null) {
            try {
                EventLog.writeEvent(30013, prev.userId, System.identityHashCode(prev), prev.shortComponentName);
                this.mService.updateUsageStats(prev, false);
                prev.app.thread.schedulePauseActivity(prev.appToken, prev.finishing, userLeaving, prev.configChangeFlags, pauseImmediately);
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Exception thrown during pause", e);
                this.mPausingActivity = null;
                this.mLastPausedActivity = null;
                this.mLastNoHistoryActivity = null;
            }
        } else {
            this.mPausingActivity = null;
            this.mLastPausedActivity = null;
            this.mLastNoHistoryActivity = null;
        }
        if (!uiSleeping && !this.mService.isSleepingOrShuttingDownLocked()) {
            this.mStackSupervisor.acquireLaunchWakelock();
        }
        if (this.mPausingActivity != null) {
            if (!uiSleeping) {
                prev.pauseKeyDispatchingLocked();
            }
            if (pauseImmediately) {
                this.completePauseLocked(false, resuming);
                return false;
            }
            this.schedulePauseTimeout(prev);
            return true;
        }
        if (resuming == null) {
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void activityPausedLocked(IBinder token, boolean timeout) {
        ActivityRecord r = this.isInStackLocked(token);
        if (r != null) {
            this.mHandler.removeMessages(101, r);
            if (this.mPausingActivity == r) {
                this.mService.mWindowManager.deferSurfaceLayout();
                try {
                    this.completePauseLocked(true, null);
                }
                finally {
                    this.mService.mWindowManager.continueSurfaceLayout();
                }
                return;
            }
            EventLog.writeEvent(30012, r.userId, System.identityHashCode(r), r.shortComponentName, this.mPausingActivity != null ? this.mPausingActivity.shortComponentName : "(none)");
            if (r.state == ActivityState.PAUSING) {
                r.state = ActivityState.PAUSED;
                if (r.finishing) {
                    this.finishCurrentActivityLocked(r, 2, false);
                }
            }
        }
        this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completePauseLocked(boolean resumeNext, ActivityRecord resuming) {
        ActivityRecord prev = this.mPausingActivity;
        if (prev != null) {
            boolean wasStopping = prev.state == ActivityState.STOPPING;
            prev.state = ActivityState.PAUSED;
            if (prev.finishing) {
                prev = this.finishCurrentActivityLocked(prev, 2, false);
            } else if (prev.app != null) {
                if (this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.remove(prev)) {
                    // empty if block
                }
                if (prev.deferRelaunchUntilPaused) {
                    prev.relaunchActivityLocked(false, prev.preserveWindowOnDeferredRelaunch);
                } else if (wasStopping) {
                    prev.state = ActivityState.STOPPING;
                } else if (!prev.visible || this.shouldSleepOrShutDownActivities()) {
                    prev.setDeferHidingClient(false);
                    this.addToStopping(prev, true, false);
                }
            } else {
                prev = null;
            }
            if (prev != null) {
                prev.stopFreezingScreenLocked(true);
            }
            this.mPausingActivity = null;
        }
        if (resumeNext) {
            ActivityStack topStack = this.mStackSupervisor.getFocusedStack();
            if (!topStack.shouldSleepOrShutDownActivities()) {
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked(topStack, prev, null);
            } else {
                this.checkReadyForSleep();
                ActivityRecord top = topStack.topRunningActivityLocked();
                if (top == null || prev != null && top != prev) {
                    this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
                }
            }
        }
        if (prev != null) {
            long diff;
            prev.resumeKeyDispatchingLocked();
            if (prev.app != null && prev.cpuTimeAtResume > 0L && this.mService.mBatteryStatsService.isOnBattery() && (diff = this.mService.mProcessCpuTracker.getCpuTimeForPid(prev.app.pid) - prev.cpuTimeAtResume) > 0L) {
                BatteryStatsImpl bsi;
                BatteryStatsImpl batteryStatsImpl = bsi = this.mService.mBatteryStatsService.getActiveStatistics();
                synchronized (batteryStatsImpl) {
                    BatteryStatsImpl.Uid.Proc ps = bsi.getProcessStatsLocked(prev.info.applicationInfo.uid, prev.info.packageName);
                    if (ps != null) {
                        ps.addForegroundTimeLocked(diff);
                    }
                }
            }
            prev.cpuTimeAtResume = 0L;
        }
        if (this.mStackSupervisor.mAppVisibilitiesChangedSinceLastPause || this.mService.mStackSupervisor.getStack(4) != null) {
            this.mService.mTaskChangeNotificationController.notifyTaskStackChanged();
            this.mStackSupervisor.mAppVisibilitiesChangedSinceLastPause = false;
        }
        this.mStackSupervisor.ensureActivitiesVisibleLocked(resuming, 0, false);
    }

    void addToStopping(ActivityRecord r, boolean scheduleIdle, boolean idleDelayed) {
        boolean forceIdle;
        if (!this.mStackSupervisor.mStoppingActivities.contains(r)) {
            this.mStackSupervisor.mStoppingActivities.add(r);
        }
        boolean bl = forceIdle = this.mStackSupervisor.mStoppingActivities.size() > 3 || r.frontOfTask && this.mTaskHistory.size() <= 1;
        if (scheduleIdle || forceIdle) {
            if (!idleDelayed) {
                this.mStackSupervisor.scheduleIdleLocked();
            } else {
                this.mStackSupervisor.scheduleIdleTimeoutLocked(r);
            }
        } else {
            this.checkReadyForSleep();
        }
    }

    ActivityRecord findNextTranslucentActivity(ActivityRecord r) {
        TaskRecord task = r.getTask();
        if (task == null) {
            return null;
        }
        ActivityStack stack = task.getStack();
        if (stack == null) {
            return null;
        }
        ArrayList<TaskRecord> tasks = stack.mTaskHistory;
        int taskNdx = tasks.indexOf(task);
        ArrayList<ActivityRecord> activities = task.mActivities;
        int activityNdx = activities.indexOf(r) + 1;
        int numStacks = this.mStacks.size();
        for (int stackNdx = this.mStacks.indexOf(stack); stackNdx < numStacks; ++stackNdx) {
            ActivityStack historyStack = this.mStacks.get(stackNdx);
            tasks = historyStack.mTaskHistory;
            int numTasks = tasks.size();
            while (taskNdx < numTasks) {
                TaskRecord currentTask = tasks.get(taskNdx);
                activities = currentTask.mActivities;
                int numActivities = activities.size();
                while (activityNdx < numActivities) {
                    ActivityRecord activity = activities.get(activityNdx);
                    if (!activity.finishing) {
                        return historyStack.mFullscreen && currentTask.mFullscreen && activity.fullscreen ? null : activity;
                    }
                    ++activityNdx;
                }
                activityNdx = 0;
                ++taskNdx;
            }
            taskNdx = 0;
        }
        return null;
    }

    private boolean hasFullscreenTask() {
        for (int i = this.mTaskHistory.size() - 1; i >= 0; --i) {
            TaskRecord task = this.mTaskHistory.get(i);
            if (!task.mFullscreen) continue;
            return true;
        }
        return false;
    }

    private boolean isStackTranslucent(ActivityRecord starting, int stackBehindId) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing || !r.visible && r != starting) continue;
                if (r.fullscreen) {
                    return false;
                }
                if (this.isHomeOrRecentsStack() || !r.frontOfTask || !task.isOverHomeStack() || ActivityManager.StackId.isHomeOrRecentsStack(stackBehindId) || this.isAssistantStack()) continue;
                return false;
            }
        }
        return true;
    }

    boolean isVisible() {
        return this.mWindowContainerController != null && ((StackWindowController)this.mWindowContainerController).isVisible() && !this.mForceHidden;
    }

    int shouldBeVisible(ActivityRecord starting) {
        int stackBehindTopId;
        int stackBehindTopIndex;
        int dockedStackIndex;
        if (!this.isAttached() || this.mForceHidden) {
            return 0;
        }
        if (this.mStackSupervisor.isFrontStackOnDisplay(this) || this.mStackSupervisor.isFocusedStack(this)) {
            return 1;
        }
        int stackIndex = this.mStacks.indexOf(this);
        if (stackIndex == this.mStacks.size() - 1) {
            Slog.wtf("ActivityManager", "Stack=" + this + " isn't front stack but is at the top of the stack list");
            return 0;
        }
        ActivityStack topStack = this.getTopStackOnDisplay();
        int topStackId = topStack.mStackId;
        if (this.mStackId == 3) {
            if (topStack.isAssistantStack()) {
                return topStack.isStackTranslucent(starting, 3) ? 1 : 0;
            }
            return 1;
        }
        if (this.mStackId == 0 && (dockedStackIndex = this.mStacks.indexOf(this.mStackSupervisor.getStack(3))) > stackIndex && stackIndex != dockedStackIndex - 1) {
            return 0;
        }
        for (stackBehindTopIndex = this.mStacks.indexOf(topStack) - 1; stackBehindTopIndex >= 0 && this.mStacks.get(stackBehindTopIndex).topRunningActivityLocked() == null; --stackBehindTopIndex) {
        }
        int n = stackBehindTopId = stackBehindTopIndex >= 0 ? this.mStacks.get((int)stackBehindTopIndex).mStackId : -1;
        if (topStackId == 3 || ActivityManager.StackId.isAlwaysOnTop(topStackId)) {
            if (stackIndex == stackBehindTopIndex) {
                return 1;
            }
            if (ActivityManager.StackId.isAlwaysOnTop(topStackId) && stackIndex == stackBehindTopIndex - 1) {
                if (stackBehindTopId == 3) {
                    return 1;
                }
                if (stackBehindTopId == 6) {
                    return this.mStacks.get(stackBehindTopIndex).isStackTranslucent(starting, this.mStackId) ? 1 : 0;
                }
            }
        }
        if (ActivityManager.StackId.isBackdropToTranslucentActivity(topStackId) && topStack.isStackTranslucent(starting, stackBehindTopId)) {
            if (stackIndex == stackBehindTopIndex) {
                return 1;
            }
            if (stackBehindTopIndex >= 0 && (stackBehindTopId == 3 || stackBehindTopId == 4) && stackIndex == stackBehindTopIndex - 1) {
                return 1;
            }
        }
        if (ActivityManager.StackId.isStaticStack(this.mStackId)) {
            return 0;
        }
        for (int i = stackIndex + 1; i < this.mStacks.size(); ++i) {
            ActivityStack stack = this.mStacks.get(i);
            if (!stack.mFullscreen && !stack.hasFullscreenTask()) continue;
            if (!ActivityManager.StackId.isDynamicStacksVisibleBehindAllowed(stack.mStackId)) {
                return 0;
            }
            if (stack.isStackTranslucent(starting, -1)) continue;
            return 0;
        }
        return 1;
    }

    final int rankTaskLayers(int baseLayer) {
        int layer = 0;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ActivityRecord r = task.topRunningActivityLocked();
            task.mLayerRank = r == null || r.finishing || !r.visible ? -1 : baseLayer + layer++;
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureActivitiesVisibleLocked(ActivityRecord starting, int configChanges, boolean preserveWindows) {
        this.mTopActivityOccludesKeyguard = false;
        this.mTopDismissingKeyguardActivity = null;
        this.mStackSupervisor.mKeyguardController.beginActivityVisibilityUpdate();
        try {
            boolean stackInvisible;
            ActivityRecord top = this.topRunningActivityLocked();
            if (top != null) {
                this.checkTranslucentActivityWaiting(top);
            }
            boolean aboveTop = top != null;
            int stackVisibility = this.shouldBeVisible(starting);
            boolean behindFullscreenActivity = stackInvisible = stackVisibility != 1;
            boolean resumeNextActivity = this.mStackSupervisor.isFocusedStack(this) && this.isInStackLocked(starting) == null;
            boolean behindTranslucentActivity = false;
            for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
                TaskRecord task = this.mTaskHistory.get(taskNdx);
                ArrayList<ActivityRecord> activities = task.mActivities;
                for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                    boolean visibleIgnoringKeyguard;
                    boolean isTop;
                    ActivityRecord r = activities.get(activityNdx);
                    if (r.finishing) {
                        if (!r.mUpdateTaskThumbnailWhenHidden) continue;
                        r.updateThumbnailLocked(r.screenshotActivityLocked(), null);
                        r.mUpdateTaskThumbnailWhenHidden = false;
                        continue;
                    }
                    boolean bl = isTop = r == top;
                    if (aboveTop && !isTop) continue;
                    aboveTop = false;
                    r.visibleIgnoringKeyguard = visibleIgnoringKeyguard = r.shouldBeVisibleIgnoringKeyguard(behindFullscreenActivity);
                    boolean reallyVisible = this.checkKeyguardVisibility(r, visibleIgnoringKeyguard, isTop);
                    if (visibleIgnoringKeyguard && (behindFullscreenActivity = this.updateBehindFullscreen(stackInvisible, behindFullscreenActivity, task, r)) && !r.fullscreen) {
                        behindTranslucentActivity = true;
                    }
                    if (reallyVisible) {
                        if (r != starting) {
                            r.ensureActivityConfigurationLocked(0, preserveWindows);
                        }
                        if (r.app == null || r.app.thread == null) {
                            if (this.makeVisibleAndRestartIfNeeded(starting, configChanges, isTop, resumeNextActivity, r)) {
                                if (activityNdx >= activities.size()) {
                                    activityNdx = activities.size() - 1;
                                } else {
                                    resumeNextActivity = false;
                                }
                            }
                        } else if (r.visible) {
                            if (r.handleAlreadyVisible()) {
                                resumeNextActivity = false;
                            }
                        } else {
                            r.makeVisibleIfNeeded(starting);
                        }
                        configChanges |= r.configChangeFlags;
                        continue;
                    }
                    this.makeInvisible(r);
                }
                if (this.mStackId == 2) {
                    behindFullscreenActivity = stackVisibility == 0;
                    continue;
                }
                if (this.mStackId == 0) {
                    if (task.isHomeTask()) {
                        behindFullscreenActivity = true;
                        continue;
                    }
                    if (!task.isRecentsTask() || task.getTaskToReturnTo() != 0) continue;
                    behindFullscreenActivity = true;
                    continue;
                }
                if (this.mStackId != 1 || task.topRunningActivityLocked() == null || task.getTaskToReturnTo() == 0) continue;
                behindFullscreenActivity = true;
            }
            if (this.mTranslucentActivityWaiting != null && this.mUndrawnActivitiesBelowTopTranslucent.isEmpty()) {
                this.notifyActivityDrawnLocked(null);
            }
        }
        finally {
            this.mStackSupervisor.mKeyguardController.endActivityVisibilityUpdate();
        }
    }

    void addStartingWindowsForVisibleActivities(boolean taskSwitch) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            this.mTaskHistory.get(taskNdx).addStartingWindowsForVisibleActivities(taskSwitch);
        }
    }

    boolean topActivityOccludesKeyguard() {
        return this.mTopActivityOccludesKeyguard;
    }

    ActivityRecord getTopDismissingKeyguardActivity() {
        return this.mTopDismissingKeyguardActivity;
    }

    boolean checkKeyguardVisibility(ActivityRecord r, boolean shouldBeVisible, boolean isTop) {
        boolean isInPinnedStack = ((ActivityStack)r.getStack()).getStackId() == 4;
        boolean keyguardShowing = this.mStackSupervisor.mKeyguardController.isKeyguardShowing(this.mDisplayId != -1 ? this.mDisplayId : 0);
        boolean keyguardLocked = this.mStackSupervisor.mKeyguardController.isKeyguardLocked();
        boolean showWhenLocked = r.canShowWhenLocked() && !isInPinnedStack;
        boolean dismissKeyguard = r.hasDismissKeyguardWindows();
        if (shouldBeVisible) {
            boolean canShowWithKeyguard;
            if (dismissKeyguard && this.mTopDismissingKeyguardActivity == null) {
                this.mTopDismissingKeyguardActivity = r;
            }
            if (isTop) {
                this.mTopActivityOccludesKeyguard |= showWhenLocked;
            }
            boolean bl = canShowWithKeyguard = this.canShowWithInsecureKeyguard() && this.mStackSupervisor.mKeyguardController.canDismissKeyguard();
            if (canShowWithKeyguard) {
                return true;
            }
        }
        if (keyguardShowing) {
            return shouldBeVisible && this.mStackSupervisor.mKeyguardController.canShowActivityWhileKeyguardShowing(r, dismissKeyguard);
        }
        if (keyguardLocked) {
            return shouldBeVisible && this.mStackSupervisor.mKeyguardController.canShowWhileOccluded(dismissKeyguard, showWhenLocked);
        }
        return shouldBeVisible;
    }

    private boolean canShowWithInsecureKeyguard() {
        ActivityStackSupervisor.ActivityDisplay activityDisplay = this.getDisplay();
        if (activityDisplay == null) {
            throw new IllegalStateException("Stack is not attached to any display, stackId=" + this.mStackId);
        }
        int flags = activityDisplay.mDisplay.getFlags();
        return (flags & 0x20) != 0;
    }

    private void checkTranslucentActivityWaiting(ActivityRecord top) {
        if (this.mTranslucentActivityWaiting != top) {
            this.mUndrawnActivitiesBelowTopTranslucent.clear();
            if (this.mTranslucentActivityWaiting != null) {
                this.notifyActivityDrawnLocked(null);
                this.mTranslucentActivityWaiting = null;
            }
            this.mHandler.removeMessages(106);
        }
    }

    private boolean makeVisibleAndRestartIfNeeded(ActivityRecord starting, int configChanges, boolean isTop, boolean andResume, ActivityRecord r) {
        if (isTop || !r.visible) {
            if (r != starting) {
                r.startFreezingScreenLocked(r.app, configChanges);
            }
            if (!r.visible || r.mLaunchTaskBehind) {
                r.setVisible(true);
            }
            if (r != starting) {
                this.mStackSupervisor.startSpecificActivityLocked(r, andResume, false);
                return true;
            }
        }
        return false;
    }

    private void makeInvisible(ActivityRecord r) {
        if (!r.visible) {
            return;
        }
        try {
            boolean canEnterPictureInPicture = r.checkEnterPictureInPictureState("makeInvisible", true);
            boolean deferHidingClient = canEnterPictureInPicture && r.state != ActivityState.STOPPING && r.state != ActivityState.STOPPED;
            r.setDeferHidingClient(deferHidingClient);
            r.setVisible(false);
            switch (r.state) {
                case STOPPING: 
                case STOPPED: {
                    if (r.app != null && r.app.thread != null) {
                        r.app.thread.scheduleWindowVisibility(r.appToken, false);
                    }
                    r.supportsEnterPipOnTaskSwitch = false;
                    break;
                }
                case INITIALIZING: 
                case RESUMED: 
                case PAUSING: 
                case PAUSED: {
                    this.addToStopping(r, true, canEnterPictureInPicture);
                    break;
                }
            }
        }
        catch (Exception e) {
            Slog.w("ActivityManager", "Exception thrown making hidden: " + r.intent.getComponent(), e);
        }
    }

    private boolean updateBehindFullscreen(boolean stackInvisible, boolean behindFullscreenActivity, TaskRecord task, ActivityRecord r) {
        if (r.fullscreen) {
            behindFullscreenActivity = true;
        } else if (!this.isHomeOrRecentsStack() && r.frontOfTask && task.isOverHomeStack()) {
            behindFullscreenActivity = true;
        }
        return behindFullscreenActivity;
    }

    void convertActivityToTranslucent(ActivityRecord r) {
        this.mTranslucentActivityWaiting = r;
        this.mUndrawnActivitiesBelowTopTranslucent.clear();
        this.mHandler.sendEmptyMessageDelayed(106, 2000L);
    }

    void clearOtherAppTimeTrackers(AppTimeTracker except) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.appTimeTracker == except) continue;
                r.appTimeTracker = null;
            }
        }
    }

    void notifyActivityDrawnLocked(ActivityRecord r) {
        if (r == null || this.mUndrawnActivitiesBelowTopTranslucent.remove(r) && this.mUndrawnActivitiesBelowTopTranslucent.isEmpty()) {
            ActivityRecord waitingActivity = this.mTranslucentActivityWaiting;
            this.mTranslucentActivityWaiting = null;
            this.mUndrawnActivitiesBelowTopTranslucent.clear();
            this.mHandler.removeMessages(106);
            if (waitingActivity != null) {
                this.mWindowManager.setWindowOpaque(waitingActivity.appToken, false);
                if (waitingActivity.app != null && waitingActivity.app.thread != null) {
                    try {
                        waitingActivity.app.thread.scheduleTranslucentConversionComplete(waitingActivity.appToken, r != null);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    void cancelInitializingActivities() {
        ActivityRecord topActivity = this.topRunningActivityLocked();
        boolean aboveTop = true;
        boolean behindFullscreenActivity = false;
        if (this.shouldBeVisible(null) == 0) {
            aboveTop = false;
            behindFullscreenActivity = true;
        }
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (aboveTop) {
                    if (r == topActivity) {
                        aboveTop = false;
                    }
                    behindFullscreenActivity |= r.fullscreen;
                    continue;
                }
                r.removeOrphanedStartingWindow(behindFullscreenActivity);
                behindFullscreenActivity |= r.fullscreen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resumeTopActivityUncheckedLocked(ActivityRecord prev, ActivityOptions options) {
        if (this.mStackSupervisor.inResumeTopActivity) {
            return false;
        }
        boolean result = false;
        try {
            this.mStackSupervisor.inResumeTopActivity = true;
            result = this.resumeTopActivityInnerLocked(prev, options);
        }
        finally {
            this.mStackSupervisor.inResumeTopActivity = false;
        }
        ActivityRecord next = this.topRunningActivityLocked(true);
        if (next == null || !next.canTurnScreenOn()) {
            this.checkReadyForSleep();
        }
        return result;
    }

    void setResumedActivityLocked(ActivityRecord r, String reason) {
        this.mResumedActivity = r;
        r.state = ActivityState.RESUMED;
        this.mService.setResumedActivityUncheckLocked(r, reason);
        TaskRecord task = r.getTask();
        task.touchActiveTime();
        this.mRecentTasks.addLocked(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resumeTopActivityInnerLocked(ActivityRecord prev, ActivityOptions options) {
        TaskRecord prevTask;
        boolean hasRunningActivity;
        if (!this.mService.mBooting && !this.mService.mBooted) {
            return false;
        }
        ActivityRecord next = this.topRunningActivityLocked(true);
        boolean bl = hasRunningActivity = next != null;
        if (hasRunningActivity && this.getDisplay() == null) {
            return false;
        }
        this.mStackSupervisor.cancelInitializingActivities();
        boolean userLeaving = this.mStackSupervisor.mUserLeaving;
        this.mStackSupervisor.mUserLeaving = false;
        if (!hasRunningActivity) {
            return this.resumeTopActivityInNextFocusableStack(prev, options, "noMoreActivities");
        }
        next.delayedResume = false;
        if (this.mResumedActivity == next && next.state == ActivityState.RESUMED && this.mStackSupervisor.allResumedActivitiesComplete()) {
            this.executeAppTransition(options);
            return false;
        }
        TaskRecord nextTask = next.getTask();
        TaskRecord taskRecord = prevTask = prev != null ? prev.getTask() : null;
        if (prevTask != null && prevTask.getStack() == this && prevTask.isOverHomeStack() && prev.finishing && prev.frontOfTask) {
            if (prevTask == nextTask) {
                prevTask.setFrontOfTask();
            } else if (prevTask != this.topTask()) {
                int taskNdx = this.mTaskHistory.indexOf(prevTask) + 1;
                this.mTaskHistory.get(taskNdx).setTaskToReturnTo(1);
            } else {
                if (!this.isOnHomeDisplay()) {
                    return false;
                }
                if (!this.isHomeStack()) {
                    return this.isOnHomeDisplay() && this.mStackSupervisor.resumeHomeStackTask(prev, "prevFinished");
                }
            }
        }
        if (this.shouldSleepOrShutDownActivities() && this.mLastPausedActivity == next && this.mStackSupervisor.allPausedActivitiesComplete()) {
            this.executeAppTransition(options);
            return false;
        }
        if (!this.mService.mUserController.hasStartedUserState(next.userId)) {
            Slog.w("ActivityManager", "Skipping resume of top activity " + next + ": user " + next.userId + " is stopped");
            return false;
        }
        this.mStackSupervisor.mStoppingActivities.remove(next);
        this.mStackSupervisor.mGoingToSleepActivities.remove(next);
        next.sleeping = false;
        this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.remove(next);
        if (!this.mStackSupervisor.allPausedActivitiesComplete()) {
            return false;
        }
        this.mStackSupervisor.setLaunchSource(next.info.applicationInfo.uid);
        boolean lastResumedCanPip = false;
        ActivityStack lastFocusedStack = this.mStackSupervisor.getLastStack();
        if (lastFocusedStack != null && lastFocusedStack != this) {
            ActivityRecord lastResumed = lastFocusedStack.mResumedActivity;
            lastResumedCanPip = lastResumed != null && lastResumed.checkEnterPictureInPictureState("resumeTopActivity", userLeaving);
        }
        boolean resumeWhilePausing = (next.info.flags & 0x4000) != 0 && !lastResumedCanPip;
        boolean pausing = this.mStackSupervisor.pauseBackStacks(userLeaving, next, false);
        if (this.mResumedActivity != null) {
            pausing |= this.startPausingLocked(userLeaving, false, next, false);
        }
        if (pausing && !resumeWhilePausing) {
            if (next.app != null && next.app.thread != null) {
                this.mService.updateLruProcessLocked(next.app, true, null);
            }
            return true;
        }
        if (this.mResumedActivity == next && next.state == ActivityState.RESUMED && this.mStackSupervisor.allResumedActivitiesComplete()) {
            this.executeAppTransition(options);
            return true;
        }
        if (this.shouldSleepActivities() && this.mLastNoHistoryActivity != null && !this.mLastNoHistoryActivity.finishing) {
            this.requestFinishActivityLocked(this.mLastNoHistoryActivity.appToken, 0, null, "resume-no-history", false);
            this.mLastNoHistoryActivity = null;
        }
        if (prev != null && prev != next) {
            if (!this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.contains(prev) && next != null && !next.nowVisible) {
                this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.add(prev);
            } else if (prev.finishing) {
                prev.setVisibility(false);
            }
        }
        try {
            AppGlobals.getPackageManager().setPackageStoppedState(next.packageName, false, next.userId);
        }
        catch (RemoteException remoteException) {
        }
        catch (IllegalArgumentException e) {
            Slog.w("ActivityManager", "Failed trying to unstop package " + next.packageName + ": " + e);
        }
        boolean anim2 = true;
        if (prev != null) {
            if (prev.finishing) {
                if (this.mNoAnimActivities.contains(prev)) {
                    anim2 = false;
                    this.mWindowManager.prepareAppTransition(0, false);
                } else {
                    this.mWindowManager.prepareAppTransition(prev.getTask() == next.getTask() ? 7 : 9, false);
                }
                prev.setVisibility(false);
            } else if (this.mNoAnimActivities.contains(next)) {
                anim2 = false;
                this.mWindowManager.prepareAppTransition(0, false);
            } else {
                this.mWindowManager.prepareAppTransition(prev.getTask() == next.getTask() ? 6 : (next.mLaunchTaskBehind ? 16 : 8), false);
            }
        } else if (this.mNoAnimActivities.contains(next)) {
            anim2 = false;
            this.mWindowManager.prepareAppTransition(0, false);
        } else {
            this.mWindowManager.prepareAppTransition(6, false);
        }
        Bundle resumeAnimOptions = null;
        if (anim2) {
            ActivityOptions opts = next.getOptionsForTargetActivityLocked();
            if (opts != null) {
                resumeAnimOptions = opts.toBundle();
            }
            next.applyOptionsLocked();
        } else {
            next.clearOptionsLocked();
        }
        ActivityStack lastStack = this.mStackSupervisor.getLastStack();
        if (next.app != null && next.app.thread != null) {
            boolean lastActivityTranslucent = lastStack != null && (!lastStack.mFullscreen || lastStack.mLastPausedActivity != null && !lastStack.mLastPausedActivity.fullscreen);
            Object object = this.mWindowManager.getWindowManagerLock();
            synchronized (object) {
                if (!next.visible || next.stopped || lastActivityTranslucent) {
                    next.setVisibility(true);
                }
                next.startLaunchTickingLocked();
                ActivityRecord lastResumedActivity = lastStack == null ? null : lastStack.mResumedActivity;
                ActivityState lastState = next.state;
                this.mService.updateCpuStats();
                this.setResumedActivityLocked(next, "resumeTopActivityInnerLocked");
                this.mService.updateLruProcessLocked(next.app, true, null);
                this.updateLRUListLocked(next);
                this.mService.updateOomAdjLocked();
                boolean notUpdated = true;
                if (this.mStackSupervisor.isFocusedStack(this)) {
                    Configuration config;
                    if (this.mStackSupervisor.mKeyguardController.isKeyguardLocked()) {
                        this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
                    }
                    if ((config = this.mWindowManager.updateOrientationFromAppTokens(this.mStackSupervisor.getDisplayOverrideConfiguration(this.mDisplayId), next.mayFreezeScreenLocked(next.app) ? next.appToken : null, this.mDisplayId)) != null) {
                        next.frozenBeforeDestroy = true;
                    }
                    boolean bl2 = notUpdated = !this.mService.updateDisplayOverrideConfigurationLocked(config, next, false, this.mDisplayId);
                }
                if (notUpdated) {
                    ActivityRecord nextNext = this.topRunningActivityLocked();
                    if (nextNext != next) {
                        this.mStackSupervisor.scheduleResumeTopActivities();
                    }
                    if (!next.visible || next.stopped) {
                        next.setVisibility(true);
                    }
                    next.completeResumeLocked();
                    return true;
                }
                try {
                    ArrayList<ResultInfo> a = next.results;
                    if (a != null) {
                        int N = a.size();
                        if (!next.finishing && N > 0) {
                            next.app.thread.scheduleSendResult(next.appToken, a);
                        }
                    }
                    if (next.newIntents != null) {
                        next.app.thread.scheduleNewIntent(next.newIntents, next.appToken, false);
                    }
                    next.notifyAppResumed(next.stopped);
                    EventLog.writeEvent(30007, next.userId, System.identityHashCode(next), next.getTask().taskId, next.shortComponentName);
                    next.sleeping = false;
                    this.mService.showUnsupportedZoomDialogIfNeededLocked(next);
                    this.mService.showAskCompatModeDialogLocked(next);
                    next.app.pendingUiClean = true;
                    next.app.forceProcessStateUpTo(this.mService.mTopProcessState);
                    next.clearOptionsLocked();
                    next.app.thread.scheduleResumeActivity(next.appToken, next.app.repProcState, this.mService.isNextTransitionForward(), resumeAnimOptions);
                }
                catch (Exception e) {
                    next.state = lastState;
                    if (lastStack != null) {
                        lastStack.mResumedActivity = lastResumedActivity;
                    }
                    Slog.i("ActivityManager", "Restarting because process died: " + next);
                    if (!next.hasBeenLaunched) {
                        next.hasBeenLaunched = true;
                    } else if (lastStack != null && this.mStackSupervisor.isFrontStackOnDisplay(lastStack)) {
                        next.showStartingWindow(null, false, false);
                    }
                    this.mStackSupervisor.startSpecificActivityLocked(next, true, false);
                    return true;
                }
            }
            try {
                next.completeResumeLocked();
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Exception thrown during resume of " + next, e);
                this.requestFinishActivityLocked(next.appToken, 0, null, "resume-exception", true);
                return true;
            }
        }
        if (!next.hasBeenLaunched) {
            next.hasBeenLaunched = true;
        } else {
            next.showStartingWindow(null, false, false);
        }
        this.mStackSupervisor.startSpecificActivityLocked(next, true, true);
        return true;
    }

    private boolean resumeTopActivityInNextFocusableStack(ActivityRecord prev, ActivityOptions options, String reason) {
        if (!(this.mFullscreen && this.isOnHomeDisplay() || !this.adjustFocusToNextFocusableStackLocked(reason))) {
            return this.mStackSupervisor.resumeFocusedStackTopActivityLocked(this.mStackSupervisor.getFocusedStack(), prev, null);
        }
        ActivityOptions.abort(options);
        return this.isOnHomeDisplay() && this.mStackSupervisor.resumeHomeStackTask(prev, reason);
    }

    private TaskRecord getNextTask(TaskRecord targetTask) {
        int index = this.mTaskHistory.indexOf(targetTask);
        if (index >= 0) {
            int numTasks = this.mTaskHistory.size();
            for (int i = index + 1; i < numTasks; ++i) {
                TaskRecord task = this.mTaskHistory.get(i);
                if (task.userId != targetTask.userId) continue;
                return task;
            }
        }
        return null;
    }

    int getAdjustedPositionForTask(TaskRecord task, int suggestedPosition, ActivityRecord starting) {
        int maxPosition;
        if (starting != null && starting.okToShowLocked() || starting == null && task.okToShowLocked()) {
            return Math.min(suggestedPosition, maxPosition);
        }
        for (maxPosition = this.mTaskHistory.size(); maxPosition > 0; --maxPosition) {
            TaskRecord tmpTask = this.mTaskHistory.get(maxPosition - 1);
            if (!this.mStackSupervisor.isCurrentProfileLocked(tmpTask.userId) || tmpTask.topRunningActivityLocked() == null) break;
        }
        return Math.min(suggestedPosition, maxPosition);
    }

    private void insertTaskAtPosition(TaskRecord task, int position) {
        if (position >= this.mTaskHistory.size()) {
            this.insertTaskAtTop(task, null);
            return;
        }
        position = this.getAdjustedPositionForTask(task, position, null);
        this.mTaskHistory.remove(task);
        this.mTaskHistory.add(position, task);
        ((StackWindowController)this.mWindowContainerController).positionChildAt(task.getWindowContainerController(), position, task.mBounds, task.getOverrideConfiguration());
        this.updateTaskMovement(task, true);
    }

    private void insertTaskAtTop(TaskRecord task, ActivityRecord starting) {
        this.updateTaskReturnToForTopInsertion(task);
        this.mTaskHistory.remove(task);
        int position = this.getAdjustedPositionForTask(task, this.mTaskHistory.size(), starting);
        this.mTaskHistory.add(position, task);
        this.updateTaskMovement(task, true);
        ((StackWindowController)this.mWindowContainerController).positionChildAtTop(task.getWindowContainerController(), true);
    }

    private void updateTaskReturnToForTopInsertion(TaskRecord task) {
        boolean isLastTaskOverHome = false;
        if (task.isOverHomeStack() || task.isOverAssistantStack()) {
            TaskRecord nextTask = this.getNextTask(task);
            if (nextTask != null) {
                nextTask.setTaskToReturnTo(task.getTaskToReturnTo());
            } else {
                isLastTaskOverHome = true;
            }
        }
        if (!this.isOnHomeDisplay()) {
            task.setTaskToReturnTo(0);
            return;
        }
        ActivityStack lastStack = this.mStackSupervisor.getLastStack();
        if (lastStack == null) {
            return;
        }
        if (lastStack.isAssistantStack()) {
            task.setTaskToReturnTo(3);
            return;
        }
        boolean fromHomeOrRecents = lastStack.isHomeOrRecentsStack();
        TaskRecord topTask = lastStack.topTask();
        if (!this.isHomeOrRecentsStack() && (fromHomeOrRecents || this.topTask() != task)) {
            int returnToType;
            int n = returnToType = isLastTaskOverHome ? task.getTaskToReturnTo() : 0;
            if (fromHomeOrRecents && ActivityManager.StackId.allowTopTaskToReturnHome(this.mStackId)) {
                returnToType = topTask == null ? 1 : topTask.taskType;
            }
            task.setTaskToReturnTo(returnToType);
        }
    }

    final void startActivityLocked(ActivityRecord r, ActivityRecord focusedTopActivity, boolean newTask, boolean keepCurTransition, ActivityOptions options) {
        TaskRecord activityTask;
        TaskRecord rTask = r.getTask();
        int taskId = rTask.taskId;
        if (!r.mLaunchTaskBehind && (this.taskForIdLocked(taskId) == null || newTask)) {
            this.insertTaskAtTop(rTask, r);
        }
        TaskRecord task = null;
        if (!newTask) {
            boolean startIt = true;
            for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
                task = this.mTaskHistory.get(taskNdx);
                if (task.getTopActivity() == null) continue;
                if (task == rTask) {
                    if (startIt) break;
                    r.createWindowContainer();
                    ActivityOptions.abort(options);
                    return;
                }
                if (task.numFullscreen <= 0) continue;
                startIt = false;
            }
        }
        if (task == (activityTask = r.getTask()) && this.mTaskHistory.indexOf(task) != this.mTaskHistory.size() - 1) {
            this.mStackSupervisor.mUserLeaving = false;
        }
        task = activityTask;
        if (r.getWindowContainerController() == null) {
            r.createWindowContainer();
        }
        task.setFrontOfTask();
        if (!this.isHomeOrRecentsStack() || this.numActivities() > 0) {
            if ((r.intent.getFlags() & 0x10000) != 0) {
                this.mWindowManager.prepareAppTransition(0, keepCurTransition);
                this.mNoAnimActivities.add(r);
            } else {
                int transit = 6;
                if (newTask) {
                    if (r.mLaunchTaskBehind) {
                        transit = 16;
                    } else {
                        if (this.canEnterPipOnTaskSwitch(focusedTopActivity, null, r, options)) {
                            focusedTopActivity.supportsEnterPipOnTaskSwitch = true;
                        }
                        transit = 8;
                    }
                }
                this.mWindowManager.prepareAppTransition(transit, keepCurTransition);
                this.mNoAnimActivities.remove(r);
            }
            boolean doShow = true;
            if (newTask) {
                if ((r.intent.getFlags() & 0x200000) != 0) {
                    this.resetTaskIfNeededLocked(r, r);
                    doShow = this.topRunningNonDelayedActivityLocked(null) == r;
                }
            } else if (options != null && options.getAnimationType() == 5) {
                doShow = false;
            }
            if (r.mLaunchTaskBehind) {
                r.setVisibility(true);
                this.ensureActivitiesVisibleLocked(null, 0, false);
            } else if (doShow) {
                TaskRecord prevTask = r.getTask();
                ActivityRecord prev = prevTask.topRunningActivityWithStartingWindowLocked();
                if (prev != null) {
                    if (prev.getTask() != prevTask) {
                        prev = null;
                    } else if (prev.nowVisible) {
                        prev = null;
                    }
                }
                r.showStartingWindow(prev, newTask, this.isTaskSwitch(r, focusedTopActivity));
            }
        } else {
            ActivityOptions.abort(options);
        }
    }

    private boolean canEnterPipOnTaskSwitch(ActivityRecord pipCandidate, TaskRecord toFrontTask, ActivityRecord toFrontActivity, ActivityOptions opts) {
        int targetStackId;
        if (opts != null && opts.disallowEnterPictureInPictureWhileLaunching()) {
            return false;
        }
        if (pipCandidate == null || pipCandidate.getStackId() == 4) {
            return false;
        }
        int n = targetStackId = toFrontTask != null ? toFrontTask.getStackId() : toFrontActivity.getStackId();
        return targetStackId != 6;
    }

    private boolean isTaskSwitch(ActivityRecord r, ActivityRecord topFocusedActivity) {
        return topFocusedActivity != null && r.getTask() != topFocusedActivity.getTask();
    }

    private ActivityOptions resetTargetTaskIfNeededLocked(TaskRecord task, boolean forceReset) {
        ActivityOptions topOptions = null;
        int replyChainEnd = -1;
        boolean canMoveOptions = true;
        ArrayList<ActivityRecord> activities = task.mActivities;
        int numActivities = activities.size();
        int rootActivityNdx = task.findEffectiveRootIndex();
        for (int i = numActivities - 1; i > rootActivityNdx; --i) {
            boolean clearWhenTaskReset;
            ActivityRecord target = activities.get(i);
            if (target.frontOfTask) break;
            int flags = target.info.flags;
            boolean finishOnTaskLaunch = (flags & 2) != 0;
            boolean allowTaskReparenting = (flags & 0x40) != 0;
            boolean bl = clearWhenTaskReset = (target.intent.getFlags() & 0x80000) != 0;
            if (!finishOnTaskLaunch && !clearWhenTaskReset && target.resultTo != null) {
                if (replyChainEnd >= 0) continue;
                replyChainEnd = i;
                continue;
            }
            if (!finishOnTaskLaunch && !clearWhenTaskReset && allowTaskReparenting && target.taskAffinity != null && !target.taskAffinity.equals(task.affinity)) {
                int start;
                TaskRecord targetTask;
                ActivityRecord bottom;
                ActivityRecord activityRecord = bottom = !this.mTaskHistory.isEmpty() && !this.mTaskHistory.get((int)0).mActivities.isEmpty() ? this.mTaskHistory.get((int)0).mActivities.get(0) : null;
                if (bottom != null && target.taskAffinity != null && target.taskAffinity.equals(bottom.getTask().affinity)) {
                    targetTask = bottom.getTask();
                } else {
                    targetTask = this.createTaskRecord(this.mStackSupervisor.getNextTaskIdForUserLocked(target.userId), target.info, null, null, null, false, target.mActivityType);
                    targetTask.affinityIntent = target.intent;
                }
                boolean noOptions = canMoveOptions;
                for (int srcPos = start = replyChainEnd < 0 ? i : replyChainEnd; srcPos >= i; --srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    if (p.finishing) continue;
                    canMoveOptions = false;
                    if (noOptions && topOptions == null && (topOptions = p.takeOptionsLocked()) != null) {
                        noOptions = false;
                    }
                    p.reparent(targetTask, 0, "resetTargetTaskIfNeeded");
                }
                ((StackWindowController)this.mWindowContainerController).positionChildAtBottom(targetTask.getWindowContainerController());
                replyChainEnd = -1;
                continue;
            }
            if (forceReset || finishOnTaskLaunch || clearWhenTaskReset) {
                int end = clearWhenTaskReset ? activities.size() - 1 : (replyChainEnd < 0 ? i : replyChainEnd);
                boolean noOptions = canMoveOptions;
                for (int srcPos = i; srcPos <= end; ++srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    if (p.finishing) continue;
                    canMoveOptions = false;
                    if (noOptions && topOptions == null && (topOptions = p.takeOptionsLocked()) != null) {
                        noOptions = false;
                    }
                    if (!this.finishActivityLocked(p, 0, null, "reset-task", false)) continue;
                    --end;
                    --srcPos;
                }
                replyChainEnd = -1;
                continue;
            }
            replyChainEnd = -1;
        }
        return topOptions;
    }

    private int resetAffinityTaskIfNeededLocked(TaskRecord affinityTask, TaskRecord task, boolean topTaskIsHigher, boolean forceReset, int taskInsertionPoint) {
        int replyChainEnd = -1;
        int taskId = task.taskId;
        String taskAffinity = task.affinity;
        ArrayList<ActivityRecord> activities = affinityTask.mActivities;
        int numActivities = activities.size();
        int rootActivityNdx = affinityTask.findEffectiveRootIndex();
        for (int i = numActivities - 1; i > rootActivityNdx; --i) {
            int start;
            boolean allowTaskReparenting;
            ActivityRecord target = activities.get(i);
            if (target.frontOfTask) break;
            int flags = target.info.flags;
            boolean finishOnTaskLaunch = (flags & 2) != 0;
            boolean bl = allowTaskReparenting = (flags & 0x40) != 0;
            if (target.resultTo != null) {
                if (replyChainEnd >= 0) continue;
                replyChainEnd = i;
                continue;
            }
            if (!topTaskIsHigher || !allowTaskReparenting || taskAffinity == null || !taskAffinity.equals(target.taskAffinity)) continue;
            if (forceReset || finishOnTaskLaunch) {
                for (int srcPos = start = replyChainEnd >= 0 ? replyChainEnd : i; srcPos >= i; --srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    if (p.finishing) continue;
                    this.finishActivityLocked(p, 0, null, "move-affinity", false);
                }
            } else {
                ArrayList<ActivityRecord> taskActivities;
                int targetNdx;
                if (taskInsertionPoint < 0) {
                    taskInsertionPoint = task.mActivities.size();
                }
                for (int srcPos = start = replyChainEnd >= 0 ? replyChainEnd : i; srcPos >= i; --srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    p.reparent(task, taskInsertionPoint, "resetAffinityTaskIfNeededLocked");
                }
                ((StackWindowController)this.mWindowContainerController).positionChildAtTop(task.getWindowContainerController(), true);
                if (target.info.launchMode == 1 && (targetNdx = (taskActivities = task.mActivities).indexOf(target)) > 0) {
                    ActivityRecord p = taskActivities.get(targetNdx - 1);
                    if (p.intent.getComponent().equals(target.intent.getComponent())) {
                        this.finishActivityLocked(p, 0, null, "replace", false);
                    }
                }
            }
            replyChainEnd = -1;
        }
        return taskInsertionPoint;
    }

    final ActivityRecord resetTaskIfNeededLocked(ActivityRecord taskTop, ActivityRecord newActivity) {
        boolean forceReset = (newActivity.info.flags & 4) != 0;
        TaskRecord task = taskTop.getTask();
        boolean taskFound = false;
        ActivityOptions topOptions = null;
        int reparentInsertionPoint = -1;
        for (int i = this.mTaskHistory.size() - 1; i >= 0; --i) {
            TaskRecord targetTask = this.mTaskHistory.get(i);
            if (targetTask == task) {
                topOptions = this.resetTargetTaskIfNeededLocked(task, forceReset);
                taskFound = true;
                continue;
            }
            reparentInsertionPoint = this.resetAffinityTaskIfNeededLocked(targetTask, task, taskFound, forceReset, reparentInsertionPoint);
        }
        int taskNdx = this.mTaskHistory.indexOf(task);
        if (taskNdx >= 0) {
            while ((taskTop = this.mTaskHistory.get(taskNdx--).getTopActivity()) == null && taskNdx >= 0) {
            }
        }
        if (topOptions != null) {
            if (taskTop != null) {
                taskTop.updateOptionsLocked(topOptions);
            } else {
                topOptions.abort();
            }
        }
        return taskTop;
    }

    void sendActivityResultLocked(int callingUid, ActivityRecord r, String resultWho, int requestCode, int resultCode, Intent data) {
        if (callingUid > 0) {
            this.mService.grantUriPermissionFromIntentLocked(callingUid, r.packageName, data, r.getUriPermissionsLocked(), r.userId);
        }
        if (this.mResumedActivity == r && r.app != null && r.app.thread != null) {
            try {
                ArrayList<ResultInfo> list = new ArrayList<ResultInfo>();
                list.add(new ResultInfo(resultWho, requestCode, resultCode, data));
                r.app.thread.scheduleSendResult(r.appToken, list);
                return;
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Exception thrown sending result to " + r, e);
            }
        }
        r.addResultLocked(null, resultWho, requestCode, resultCode, data);
    }

    boolean isATopFinishingTask(TaskRecord task) {
        for (int i = this.mTaskHistory.size() - 1; i >= 0; --i) {
            TaskRecord current = this.mTaskHistory.get(i);
            ActivityRecord r = current.topRunningActivityLocked();
            if (r != null) {
                return false;
            }
            if (current != task) continue;
            return true;
        }
        return false;
    }

    private void adjustFocusedActivityStackLocked(ActivityRecord r, String reason) {
        if (!this.mStackSupervisor.isFocusedStack(this) || this.mResumedActivity != r && this.mResumedActivity != null) {
            return;
        }
        ActivityRecord next = this.topRunningActivityLocked();
        String myReason = reason + " adjustFocus";
        if (next != r) {
            boolean isAssistantOrOverAssistant;
            if (next != null && ActivityManager.StackId.keepFocusInStackIfPossible(this.mStackId) && this.isFocusable()) {
                return;
            }
            TaskRecord task = r.getTask();
            if (task == null) {
                throw new IllegalStateException("activity no longer associated with task:" + r);
            }
            boolean bl = isAssistantOrOverAssistant = task.getStack().isAssistantStack() || task.isOverAssistantStack();
            if (r.frontOfTask && this.isATopFinishingTask(task) && (task.isOverHomeStack() || isAssistantOrOverAssistant)) {
                if ((!this.mFullscreen || isAssistantOrOverAssistant) && this.adjustFocusToNextFocusableStackLocked(myReason)) {
                    return;
                }
                if (task.isOverHomeStack() && this.mStackSupervisor.moveHomeStackTaskToTop(myReason)) {
                    return;
                }
            }
        }
        this.mStackSupervisor.moveFocusableActivityStackToFrontLocked(this.mStackSupervisor.topRunningActivityLocked(), myReason);
    }

    private boolean adjustFocusToNextFocusableStackLocked(String reason) {
        return this.adjustFocusToNextFocusableStackLocked(reason, false);
    }

    private boolean adjustFocusToNextFocusableStackLocked(String reason, boolean allowFocusSelf) {
        if (this.isAssistantStack() && this.bottomTask() != null && this.bottomTask().getTaskToReturnTo() == 1) {
            return this.mStackSupervisor.moveHomeStackTaskToTop(reason);
        }
        ActivityStack stack = this.mStackSupervisor.getNextFocusableStackLocked(allowFocusSelf ? null : this);
        String myReason = reason + " adjustFocusToNextFocusableStack";
        if (stack == null) {
            return false;
        }
        ActivityRecord top = stack.topRunningActivityLocked();
        if (stack.isHomeOrRecentsStack() && (top == null || !top.visible)) {
            return this.mStackSupervisor.moveHomeStackTaskToTop(reason);
        }
        if (stack.isAssistantStack() && top != null && top.getTask().getTaskToReturnTo() == 1) {
            this.mStackSupervisor.moveHomeStackTaskToTop("adjustAssistantReturnToHome");
        }
        stack.moveToFront(myReason);
        return true;
    }

    final void stopActivityLocked(ActivityRecord r) {
        block6: {
            if (!((r.intent.getFlags() & 0x40000000) == 0 && (r.info.flags & 0x80) == 0 || r.finishing || this.shouldSleepActivities() || !this.requestFinishActivityLocked(r.appToken, 0, null, "stop-no-history", false))) {
                r.resumeKeyDispatchingLocked();
                return;
            }
            if (r.app != null && r.app.thread != null) {
                this.adjustFocusedActivityStackLocked(r, "stopActivity");
                r.resumeKeyDispatchingLocked();
                try {
                    r.stopped = false;
                    r.state = ActivityState.STOPPING;
                    if (!r.visible) {
                        r.setVisible(false);
                    }
                    EventLogTags.writeAmStopActivity(r.userId, System.identityHashCode(r), r.shortComponentName);
                    r.app.thread.scheduleStopActivity(r.appToken, r.visible, r.configChangeFlags);
                    if (this.shouldSleepOrShutDownActivities()) {
                        r.setSleeping(true);
                    }
                    Message msg = this.mHandler.obtainMessage(104, r);
                    this.mHandler.sendMessageDelayed(msg, 10000L);
                }
                catch (Exception e) {
                    Slog.w("ActivityManager", "Exception thrown during pause", e);
                    r.stopped = true;
                    r.state = ActivityState.STOPPED;
                    if (!r.deferRelaunchUntilPaused) break block6;
                    this.destroyActivityLocked(r, true, "stop-except");
                }
            }
        }
    }

    final boolean requestFinishActivityLocked(IBinder token, int resultCode, Intent resultData, String reason, boolean oomAdj) {
        ActivityRecord r = this.isInStackLocked(token);
        if (r == null) {
            return false;
        }
        this.finishActivityLocked(r, resultCode, resultData, reason, oomAdj);
        return true;
    }

    final void finishSubActivityLocked(ActivityRecord self, String resultWho, int requestCode) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.resultTo != self || r.requestCode != requestCode || (r.resultWho != null || resultWho != null) && (r.resultWho == null || !r.resultWho.equals(resultWho))) continue;
                this.finishActivityLocked(r, 0, null, "request-sub", false);
            }
        }
        this.mService.updateOomAdjLocked();
    }

    final TaskRecord finishTopRunningActivityLocked(ProcessRecord app, String reason) {
        ActivityRecord r = this.topRunningActivityLocked();
        TaskRecord finishedTask = null;
        if (r == null || r.app != app) {
            return null;
        }
        Slog.w("ActivityManager", "  Force finishing activity " + r.intent.getComponent().flattenToShortString());
        finishedTask = r.getTask();
        int taskNdx = this.mTaskHistory.indexOf(finishedTask);
        TaskRecord task = finishedTask;
        int activityNdx = task.mActivities.indexOf(r);
        this.finishActivityLocked(r, 0, null, reason, false);
        finishedTask = task;
        if (--activityNdx < 0) {
            while (--taskNdx >= 0 && (activityNdx = this.mTaskHistory.get((int)taskNdx).mActivities.size() - 1) < 0) {
            }
        }
        if (activityNdx >= 0) {
            r = this.mTaskHistory.get((int)taskNdx).mActivities.get(activityNdx);
            if (!(r.state != ActivityState.RESUMED && r.state != ActivityState.PAUSING && r.state != ActivityState.PAUSED || r.isHomeActivity() && this.mService.mHomeProcess == r.app)) {
                Slog.w("ActivityManager", "  Force finishing activity " + r.intent.getComponent().flattenToShortString());
                this.finishActivityLocked(r, 0, null, reason, false);
            }
        }
        return finishedTask;
    }

    final void finishVoiceTask(IVoiceInteractionSession session) {
        IBinder sessionBinder = session.asBinder();
        boolean didOne = false;
        block2: for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ActivityRecord r;
            int activityNdx;
            TaskRecord tr = this.mTaskHistory.get(taskNdx);
            if (tr.voiceSession != null && tr.voiceSession.asBinder() == sessionBinder) {
                for (activityNdx = tr.mActivities.size() - 1; activityNdx >= 0; --activityNdx) {
                    r = tr.mActivities.get(activityNdx);
                    if (r.finishing) continue;
                    this.finishActivityLocked(r, 0, null, "finish-voice", false);
                    didOne = true;
                }
                continue;
            }
            for (activityNdx = tr.mActivities.size() - 1; activityNdx >= 0; --activityNdx) {
                r = tr.mActivities.get(activityNdx);
                if (r.voiceSession == null || r.voiceSession.asBinder() != sessionBinder) continue;
                r.clearVoiceSessionLocked();
                try {
                    r.app.thread.scheduleLocalVoiceInteractionStarted(r.appToken, null);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.mService.finishRunningVoiceLocked();
                continue block2;
            }
        }
        if (didOne) {
            this.mService.updateOomAdjLocked();
        }
    }

    final boolean finishActivityAffinityLocked(ActivityRecord r) {
        ArrayList<ActivityRecord> activities = r.getTask().mActivities;
        for (int index = activities.indexOf(r); index >= 0; --index) {
            ActivityRecord cur = activities.get(index);
            if (!Objects.equals(cur.taskAffinity, r.taskAffinity)) break;
            this.finishActivityLocked(cur, 0, null, "request-affinity", true);
        }
        return true;
    }

    private void finishActivityResultsLocked(ActivityRecord r, int resultCode, Intent resultData) {
        ActivityRecord resultTo = r.resultTo;
        if (resultTo != null) {
            if (resultTo.userId != r.userId && resultData != null) {
                resultData.prepareToLeaveUser(r.userId);
            }
            if (r.info.applicationInfo.uid > 0) {
                this.mService.grantUriPermissionFromIntentLocked(r.info.applicationInfo.uid, resultTo.packageName, resultData, resultTo.getUriPermissionsLocked(), resultTo.userId);
            }
            resultTo.addResultLocked(r, r.resultWho, r.requestCode, resultCode, resultData);
            r.resultTo = null;
        }
        r.results = null;
        r.pendingResults = null;
        r.newIntents = null;
        r.icicle = null;
    }

    final boolean finishActivityLocked(ActivityRecord r, int resultCode, Intent resultData, String reason, boolean oomAdj) {
        return this.finishActivityLocked(r, resultCode, resultData, reason, oomAdj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean finishActivityLocked(ActivityRecord r, int resultCode, Intent resultData, String reason, boolean oomAdj, boolean pauseImmediately) {
        if (r.finishing) {
            Slog.w("ActivityManager", "Duplicate finish request for " + r);
            return false;
        }
        this.mWindowManager.deferSurfaceLayout();
        try {
            int transit;
            r.makeFinishingLocked();
            TaskRecord task = r.getTask();
            EventLog.writeEvent(30001, r.userId, System.identityHashCode(r), task.taskId, r.shortComponentName, reason);
            ArrayList<ActivityRecord> activities = task.mActivities;
            int index = activities.indexOf(r);
            if (index < activities.size() - 1) {
                task.setFrontOfTask();
                if ((r.intent.getFlags() & 0x80000) != 0) {
                    ActivityRecord next = activities.get(index + 1);
                    next.intent.addFlags(524288);
                }
            }
            r.pauseKeyDispatchingLocked();
            this.adjustFocusedActivityStackLocked(r, "finishActivity");
            this.finishActivityResultsLocked(r, resultCode, resultData);
            boolean endTask = index <= 0 && !task.isClearingToReuseTask();
            int n = transit = endTask ? 9 : 7;
            if (this.mResumedActivity == r) {
                if (endTask) {
                    this.mService.mTaskChangeNotificationController.notifyTaskRemovalStarted(task.taskId);
                }
                this.mWindowManager.prepareAppTransition(transit, false);
                r.setVisibility(false);
                if (this.mPausingActivity == null) {
                    this.startPausingLocked(false, false, null, pauseImmediately);
                }
                if (endTask) {
                    this.mStackSupervisor.removeLockedTaskLocked(task);
                }
            } else if (r.state != ActivityState.PAUSING) {
                boolean removedActivity;
                if (r.visible) {
                    this.prepareActivityHideTransitionAnimation(r, transit);
                }
                int finishMode = r.visible || r.nowVisible ? 2 : 1;
                boolean bl = removedActivity = this.finishCurrentActivityLocked(r, finishMode, oomAdj) == null;
                if (task.onlyHasTaskOverlayActivities(true)) {
                    for (ActivityRecord taskOverlay : task.mActivities) {
                        if (!taskOverlay.mTaskOverlay) continue;
                        this.prepareActivityHideTransitionAnimation(taskOverlay, transit);
                    }
                }
                boolean bl2 = removedActivity;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
        }
    }

    private void prepareActivityHideTransitionAnimation(ActivityRecord r, int transit) {
        this.mWindowManager.prepareAppTransition(transit, false);
        r.setVisibility(false);
        this.mWindowManager.executeAppTransition();
        if (!this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.contains(r)) {
            this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.add(r);
        }
    }

    final ActivityRecord finishCurrentActivityLocked(ActivityRecord r, int mode, boolean oomAdj) {
        boolean finishingActivityInNonFocusedStack;
        ActivityRecord next = this.mStackSupervisor.topRunningActivityLocked();
        if (mode == 2 && (r.visible || r.nowVisible) && next != null && !next.nowVisible) {
            if (!this.mStackSupervisor.mStoppingActivities.contains(r)) {
                this.addToStopping(r, false, false);
            }
            r.state = ActivityState.STOPPING;
            if (oomAdj) {
                this.mService.updateOomAdjLocked();
            }
            return r;
        }
        this.mStackSupervisor.mStoppingActivities.remove(r);
        this.mStackSupervisor.mGoingToSleepActivities.remove(r);
        this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.remove(r);
        if (this.mResumedActivity == r) {
            this.mResumedActivity = null;
        }
        ActivityState prevState = r.state;
        r.state = ActivityState.FINISHING;
        boolean bl = finishingActivityInNonFocusedStack = r.getStack() != this.mStackSupervisor.getFocusedStack() && prevState == ActivityState.PAUSED && mode == 2;
        if (mode == 0 || prevState == ActivityState.PAUSED && (mode == 1 || this.mStackId == 4) || finishingActivityInNonFocusedStack || prevState == ActivityState.STOPPING || prevState == ActivityState.STOPPED || prevState == ActivityState.INITIALIZING) {
            r.makeFinishingLocked();
            boolean activityRemoved = this.destroyActivityLocked(r, true, "finish-imm");
            if (finishingActivityInNonFocusedStack) {
                this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
            }
            if (activityRemoved) {
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            }
            return activityRemoved ? null : r;
        }
        this.mStackSupervisor.mFinishingActivities.add(r);
        r.resumeKeyDispatchingLocked();
        this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        return r;
    }

    void finishAllActivitiesLocked(boolean immediately) {
        boolean noActivitiesInStack = true;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                noActivitiesInStack = false;
                if (r.finishing && !immediately) continue;
                Slog.d("ActivityManager", "finishAllActivitiesLocked: finishing " + r + " immediately");
                this.finishCurrentActivityLocked(r, 0, false);
            }
        }
        if (noActivitiesInStack) {
            this.remove();
        }
    }

    final boolean shouldUpRecreateTaskLocked(ActivityRecord srec, String destAffinity) {
        if (srec == null || srec.getTask().affinity == null || !srec.getTask().affinity.equals(destAffinity)) {
            return true;
        }
        TaskRecord task = srec.getTask();
        if (srec.frontOfTask && task != null && task.getBaseIntent() != null && task.getBaseIntent().isDocument()) {
            if (task.getTaskToReturnTo() != 0) {
                return true;
            }
            int taskIdx = this.mTaskHistory.indexOf(task);
            if (taskIdx <= 0) {
                Slog.w("ActivityManager", "shouldUpRecreateTask: task not in history for " + srec);
                return false;
            }
            if (taskIdx == 0) {
                return true;
            }
            TaskRecord prevTask = this.mTaskHistory.get(taskIdx);
            if (!task.affinity.equals(prevTask.affinity)) {
                return true;
            }
        }
        return false;
    }

    final boolean navigateUpToLocked(ActivityRecord srec, Intent destIntent, int resultCode, Intent resultData) {
        ActivityRecord next;
        IActivityController controller;
        TaskRecord task = srec.getTask();
        ArrayList<ActivityRecord> activities = task.mActivities;
        int start = activities.indexOf(srec);
        if (!this.mTaskHistory.contains(task) || start < 0) {
            return false;
        }
        int finishTo = start - 1;
        ActivityRecord parent = finishTo < 0 ? null : activities.get(finishTo);
        boolean foundParentInTask = false;
        ComponentName dest = destIntent.getComponent();
        if (start > 0 && dest != null) {
            for (int i = finishTo; i >= 0; --i) {
                ActivityRecord r = activities.get(i);
                if (!r.info.packageName.equals(dest.getPackageName()) || !r.info.name.equals(dest.getClassName())) continue;
                finishTo = i;
                parent = r;
                foundParentInTask = true;
                break;
            }
        }
        if ((controller = this.mService.mController) != null && (next = this.topRunningActivityLocked(srec.appToken, 0)) != null) {
            boolean resumeOK = true;
            try {
                resumeOK = controller.activityResuming(next.packageName);
            }
            catch (RemoteException e) {
                this.mService.mController = null;
                Watchdog.getInstance().setActivityController(null);
            }
            if (!resumeOK) {
                return false;
            }
        }
        long origId = Binder.clearCallingIdentity();
        for (int i = start; i > finishTo; --i) {
            ActivityRecord r = activities.get(i);
            this.requestFinishActivityLocked(r.appToken, resultCode, resultData, "navigate-up", true);
            resultCode = 0;
            resultData = null;
        }
        if (parent != null && foundParentInTask) {
            int parentLaunchMode = parent.info.launchMode;
            int destIntentFlags = destIntent.getFlags();
            if (parentLaunchMode == 3 || parentLaunchMode == 2 || parentLaunchMode == 1 || (destIntentFlags & 0x4000000) != 0) {
                parent.deliverNewIntentLocked(srec.info.applicationInfo.uid, destIntent, srec.packageName);
            } else {
                try {
                    ActivityInfo aInfo = AppGlobals.getPackageManager().getActivityInfo(destIntent.getComponent(), 0, srec.userId);
                    int res = this.mService.mActivityStarter.startActivityLocked(srec.app.thread, destIntent, null, null, aInfo, null, null, null, parent.appToken, null, 0, -1, parent.launchedFromUid, parent.launchedFromPackage, -1, parent.launchedFromUid, 0, null, false, true, null, null, "navigateUpTo");
                    foundParentInTask = res == 0;
                }
                catch (RemoteException e) {
                    foundParentInTask = false;
                }
                this.requestFinishActivityLocked(parent.appToken, resultCode, resultData, "navigate-top", true);
            }
        }
        Binder.restoreCallingIdentity(origId);
        return foundParentInTask;
    }

    void onActivityRemovedFromStack(ActivityRecord r) {
        if (this.mResumedActivity == r) {
            this.mResumedActivity = null;
        }
        if (this.mPausingActivity == r) {
            this.mPausingActivity = null;
        }
        this.removeTimeoutsForActivityLocked(r);
    }

    private void cleanUpActivityLocked(ActivityRecord r, boolean cleanServices, boolean setState) {
        this.onActivityRemovedFromStack(r);
        r.deferRelaunchUntilPaused = false;
        r.frozenBeforeDestroy = false;
        if (setState) {
            r.state = ActivityState.DESTROYED;
            r.app = null;
        }
        this.mStackSupervisor.cleanupActivity(r);
        if (r.finishing && r.pendingResults != null) {
            for (WeakReference<PendingIntentRecord> apr : r.pendingResults) {
                PendingIntentRecord rec = (PendingIntentRecord)apr.get();
                if (rec == null) continue;
                this.mService.cancelIntentSenderLocked(rec, false);
            }
            r.pendingResults = null;
        }
        if (cleanServices) {
            this.cleanUpActivityServicesLocked(r);
        }
        this.removeTimeoutsForActivityLocked(r);
        this.mWindowManager.notifyAppRelaunchesCleared(r.appToken);
    }

    void removeTimeoutsForActivityLocked(ActivityRecord r) {
        this.mStackSupervisor.removeTimeoutsForActivityLocked(r);
        this.mHandler.removeMessages(101, r);
        this.mHandler.removeMessages(104, r);
        this.mHandler.removeMessages(102, r);
        r.finishLaunchTickingLocked();
    }

    private void removeActivityFromHistoryLocked(ActivityRecord r, String reason) {
        boolean onlyHasTaskOverlays;
        this.finishActivityResultsLocked(r, 0, null);
        r.makeFinishingLocked();
        r.takeFromHistory();
        this.removeTimeoutsForActivityLocked(r);
        r.state = ActivityState.DESTROYED;
        r.app = null;
        r.removeWindowContainer();
        TaskRecord task = r.getTask();
        boolean lastActivity = task != null ? task.removeActivity(r) : false;
        boolean bl = onlyHasTaskOverlays = task != null ? task.onlyHasTaskOverlayActivities(false) : false;
        if (lastActivity || onlyHasTaskOverlays) {
            if (this.mStackSupervisor.isFocusedStack(this) && task == this.topTask() && task.isOverHomeStack()) {
                this.mStackSupervisor.moveHomeStackTaskToTop(reason);
            }
            if (onlyHasTaskOverlays) {
                this.mStackSupervisor.removeTaskByIdLocked(task.taskId, false, false, true);
            }
            if (lastActivity) {
                this.removeTask(task, reason, 0);
            }
        }
        this.cleanUpActivityServicesLocked(r);
        r.removeUriPermissionsLocked();
    }

    private void cleanUpActivityServicesLocked(ActivityRecord r) {
        if (r.connections != null) {
            for (ConnectionRecord c : r.connections) {
                this.mService.mServices.removeConnectionLocked(c, null, r);
            }
            r.connections = null;
        }
    }

    final void scheduleDestroyActivities(ProcessRecord owner, String reason) {
        Message msg = this.mHandler.obtainMessage(105);
        msg.obj = new ScheduleDestroyArgs(owner, reason);
        this.mHandler.sendMessage(msg);
    }

    private void destroyActivitiesLocked(ProcessRecord owner, String reason) {
        boolean lastIsOpaque = false;
        boolean activityRemoved = false;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing) continue;
                if (r.fullscreen) {
                    lastIsOpaque = true;
                }
                if (owner != null && r.app != owner || !lastIsOpaque || !r.isDestroyable() || !this.destroyActivityLocked(r, true, reason)) continue;
                activityRemoved = true;
            }
        }
        if (activityRemoved) {
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        }
    }

    final boolean safelyDestroyActivityLocked(ActivityRecord r, String reason) {
        if (r.isDestroyable()) {
            return this.destroyActivityLocked(r, true, reason);
        }
        return false;
    }

    final int releaseSomeActivitiesLocked(ProcessRecord app, ArraySet<TaskRecord> tasks, String reason) {
        int maxTasks = tasks.size() / 4;
        if (maxTasks < 1) {
            maxTasks = 1;
        }
        int numReleased = 0;
        for (int taskNdx = 0; taskNdx < this.mTaskHistory.size() && maxTasks > 0; ++taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (!tasks.contains(task)) continue;
            int curNum = 0;
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int actNdx = 0; actNdx < activities.size(); ++actNdx) {
                ActivityRecord activity = activities.get(actNdx);
                if (activity.app != app || !activity.isDestroyable()) continue;
                this.destroyActivityLocked(activity, true, reason);
                if (activities.get(actNdx) != activity) {
                    --actNdx;
                }
                ++curNum;
            }
            if (curNum <= 0) continue;
            numReleased += curNum;
            --maxTasks;
            if (this.mTaskHistory.get(taskNdx) == task) continue;
            --taskNdx;
        }
        return numReleased;
    }

    final boolean destroyActivityLocked(ActivityRecord r, boolean removeFromApp, String reason) {
        boolean hadApp;
        EventLog.writeEvent(30018, r.userId, System.identityHashCode(r), r.getTask().taskId, r.shortComponentName, reason);
        boolean removedFromHistory = false;
        this.cleanUpActivityLocked(r, false, false);
        boolean bl = hadApp = r.app != null;
        if (hadApp) {
            boolean skipDestroy;
            block12: {
                if (removeFromApp) {
                    r.app.activities.remove(r);
                    if (this.mService.mHeavyWeightProcess == r.app && r.app.activities.size() <= 0) {
                        this.mService.mHeavyWeightProcess = null;
                        this.mService.mHandler.sendEmptyMessage(25);
                    }
                    if (r.app.activities.isEmpty()) {
                        this.mService.mServices.updateServiceConnectionActivitiesLocked(r.app);
                        this.mService.updateLruProcessLocked(r.app, false, null);
                        this.mService.updateOomAdjLocked();
                    }
                }
                skipDestroy = false;
                try {
                    r.app.thread.scheduleDestroyActivity(r.appToken, r.finishing, r.configChangeFlags);
                }
                catch (Exception e) {
                    if (!r.finishing) break block12;
                    this.removeActivityFromHistoryLocked(r, reason + " exceptionInScheduleDestroy");
                    removedFromHistory = true;
                    skipDestroy = true;
                }
            }
            r.nowVisible = false;
            if (r.finishing && !skipDestroy) {
                r.state = ActivityState.DESTROYING;
                Message msg = this.mHandler.obtainMessage(102, r);
                this.mHandler.sendMessageDelayed(msg, 10000L);
            } else {
                r.state = ActivityState.DESTROYED;
                r.app = null;
            }
        } else if (r.finishing) {
            this.removeActivityFromHistoryLocked(r, reason + " hadNoApp");
            removedFromHistory = true;
        } else {
            r.state = ActivityState.DESTROYED;
            r.app = null;
        }
        r.configChangeFlags = 0;
        if (!this.mLRUActivities.remove(r) && hadApp) {
            Slog.w("ActivityManager", "Activity " + r + " being finished, but not in LRU list");
        }
        return removedFromHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void activityDestroyedLocked(IBinder token, String reason) {
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityRecord r = ActivityRecord.forTokenLocked(token);
            if (r != null) {
                this.mHandler.removeMessages(102, r);
            }
            if (this.isInStackLocked(r) != null && r.state == ActivityState.DESTROYING) {
                this.cleanUpActivityLocked(r, true, false);
                this.removeActivityFromHistoryLocked(r, reason);
            }
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    private void removeHistoryRecordsForAppLocked(ArrayList<ActivityRecord> list, ProcessRecord app, String listName) {
        int i = list.size();
        while (i > 0) {
            ActivityRecord r = list.get(--i);
            if (r.app != app) continue;
            list.remove(i);
            this.removeTimeoutsForActivityLocked(r);
        }
    }

    private boolean removeHistoryRecordsForAppLocked(ProcessRecord app) {
        this.removeHistoryRecordsForAppLocked(this.mLRUActivities, app, "mLRUActivities");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mStoppingActivities, app, "mStoppingActivities");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mGoingToSleepActivities, app, "mGoingToSleepActivities");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mActivitiesWaitingForVisibleActivity, app, "mActivitiesWaitingForVisibleActivity");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mFinishingActivities, app, "mFinishingActivities");
        boolean hasVisibleActivities = false;
        int i = this.numActivities();
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                boolean remove;
                ActivityRecord r = activities.get(activityNdx);
                --i;
                if (r.app != app) continue;
                if (r.visible) {
                    hasVisibleActivities = true;
                }
                if (remove = !r.haveState && !r.stateNotNeeded || r.finishing ? true : !r.visible && r.launchCount > 2 && r.lastLaunchTime > SystemClock.uptimeMillis() - 60000L) {
                    if (!r.finishing) {
                        Slog.w("ActivityManager", "Force removing " + r + ": app died, no saved state");
                        EventLog.writeEvent(30001, r.userId, System.identityHashCode(r), r.getTask().taskId, r.shortComponentName, "proc died without state saved");
                        if (r.state == ActivityState.RESUMED) {
                            this.mService.updateUsageStats(r, false);
                        }
                    }
                } else {
                    r.app = null;
                    r.nowVisible = r.visible;
                    if (!r.haveState) {
                        r.icicle = null;
                    }
                }
                this.cleanUpActivityLocked(r, true, true);
                if (!remove) continue;
                this.removeActivityFromHistoryLocked(r, "appDied");
            }
        }
        return hasVisibleActivities;
    }

    private void updateTransitLocked(int transit, ActivityOptions options) {
        if (options != null) {
            ActivityRecord r = this.topRunningActivityLocked();
            if (r != null && r.state != ActivityState.RESUMED) {
                r.updateOptionsLocked(options);
            } else {
                ActivityOptions.abort(options);
            }
        }
        this.mWindowManager.prepareAppTransition(transit, false);
    }

    private void updateTaskMovement(TaskRecord task, boolean toFront) {
        if (task.isPersistable) {
            task.mLastTimeMoved = System.currentTimeMillis();
            if (!toFront) {
                task.mLastTimeMoved *= -1L;
            }
        }
        this.mStackSupervisor.invalidateTaskLayers();
    }

    void moveHomeStackTaskToTop() {
        int top;
        for (int taskNdx = top = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.taskType != 1) continue;
            this.mTaskHistory.remove(taskNdx);
            this.mTaskHistory.add(top, task);
            this.updateTaskMovement(task, true);
            return;
        }
    }

    final void moveTaskToFrontLocked(TaskRecord tr, boolean noAnimation, ActivityOptions options, AppTimeTracker timeTracker, String reason) {
        ActivityStack topStack = this.getTopStackOnDisplay();
        ActivityRecord topActivity = topStack != null ? topStack.topActivity() : null;
        int numTasks = this.mTaskHistory.size();
        int index = this.mTaskHistory.indexOf(tr);
        if (numTasks == 0 || index < 0) {
            if (noAnimation) {
                ActivityOptions.abort(options);
            } else {
                this.updateTransitLocked(10, options);
            }
            return;
        }
        if (timeTracker != null) {
            for (int i = tr.mActivities.size() - 1; i >= 0; --i) {
                tr.mActivities.get((int)i).appTimeTracker = timeTracker;
            }
        }
        this.insertTaskAtTop(tr, null);
        ActivityRecord top = tr.getTopActivity();
        if (top == null || !top.okToShowLocked()) {
            this.addRecentActivityLocked(top);
            ActivityOptions.abort(options);
            return;
        }
        ActivityRecord r = this.topRunningActivityLocked();
        this.mStackSupervisor.moveFocusableActivityStackToFrontLocked(r, reason);
        if (noAnimation) {
            this.mWindowManager.prepareAppTransition(0, false);
            if (r != null) {
                this.mNoAnimActivities.add(r);
            }
            ActivityOptions.abort(options);
        } else {
            this.updateTransitLocked(10, options);
        }
        if (this.canEnterPipOnTaskSwitch(topActivity, tr, null, options)) {
            topActivity.supportsEnterPipOnTaskSwitch = true;
        }
        this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        EventLog.writeEvent(30002, tr.userId, tr.taskId);
        this.mService.mTaskChangeNotificationController.notifyTaskMovedToFront(tr.taskId);
    }

    final boolean moveTaskToBackLocked(int taskId) {
        TaskRecord task;
        TaskRecord task2;
        boolean requiresMove;
        boolean canGoHome;
        TaskRecord tr = this.taskForIdLocked(taskId);
        if (tr == null) {
            Slog.i("ActivityManager", "moveTaskToBack: bad taskId=" + taskId);
            return false;
        }
        Slog.i("ActivityManager", "moveTaskToBack: " + tr);
        if (this.mStackSupervisor.isLockedTask(tr)) {
            this.mStackSupervisor.showLockTaskToast();
            return false;
        }
        if (this.mStackSupervisor.isFrontStackOnDisplay(this) && this.mService.mController != null) {
            ActivityRecord next = this.topRunningActivityLocked(null, taskId);
            if (next == null) {
                next = this.topRunningActivityLocked(null, 0);
            }
            if (next != null) {
                boolean moveOK = true;
                try {
                    moveOK = this.mService.mController.activityResuming(next.packageName);
                }
                catch (RemoteException e) {
                    this.mService.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
                if (!moveOK) {
                    return false;
                }
            }
        }
        boolean prevIsHome = false;
        boolean bl = canGoHome = !tr.isHomeTask() && tr.isOverHomeStack();
        if (canGoHome) {
            TaskRecord nextTask = this.getNextTask(tr);
            if (nextTask != null) {
                nextTask.setTaskToReturnTo(tr.getTaskToReturnTo());
            } else {
                prevIsHome = true;
            }
        }
        boolean bl2 = requiresMove = this.mTaskHistory.indexOf(tr) != 0;
        if (requiresMove) {
            this.mTaskHistory.remove(tr);
            this.mTaskHistory.add(0, tr);
            this.updateTaskMovement(tr, false);
            this.mWindowManager.prepareAppTransition(11, false);
            ((StackWindowController)this.mWindowContainerController).positionChildAtBottom(tr.getWindowContainerController());
        }
        if (this.mStackId == 4) {
            this.mStackSupervisor.removeStackLocked(4);
            return true;
        }
        int numTasks = this.mTaskHistory.size();
        for (int taskNdx = numTasks - 1; taskNdx >= 1 && !(task2 = this.mTaskHistory.get(taskNdx)).isOverHomeStack(); --taskNdx) {
            if (taskNdx != 1) continue;
            task2.setTaskToReturnTo(1);
        }
        TaskRecord taskRecord = task = this.mResumedActivity != null ? this.mResumedActivity.getTask() : null;
        if (prevIsHome || task == tr && canGoHome || numTasks <= 1 && this.isOnHomeDisplay()) {
            if (!this.mService.mBooting && !this.mService.mBooted) {
                return false;
            }
            tr.setTaskToReturnTo(0);
            return this.mStackSupervisor.resumeHomeStackTask(null, "moveTaskToBack");
        }
        this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        return true;
    }

    private ActivityStack getTopStackOnDisplay() {
        ArrayList<ActivityStack> stacks = this.getDisplay().mStacks;
        return stacks.isEmpty() ? null : stacks.get(stacks.size() - 1);
    }

    static void logStartActivity(int tag, ActivityRecord r, TaskRecord task) {
        Uri data = r.intent.getData();
        String strData = data != null ? data.toSafeString() : null;
        EventLog.writeEvent(tag, r.userId, System.identityHashCode(r), task.taskId, r.shortComponentName, r.intent.getAction(), r.intent.getType(), strData, r.intent.getFlags());
    }

    void ensureVisibleActivitiesConfigurationLocked(ActivityRecord start, boolean preserveWindow) {
        if (start == null || !start.visible) {
            return;
        }
        TaskRecord startTask = start.getTask();
        boolean behindFullscreen = false;
        boolean updatedConfig = false;
        for (int taskIndex = this.mTaskHistory.indexOf(startTask); taskIndex >= 0; --taskIndex) {
            int activityIndex;
            TaskRecord task = this.mTaskHistory.get(taskIndex);
            ArrayList<ActivityRecord> activities = task.mActivities;
            int n = activityIndex = start.getTask() == task ? activities.indexOf(start) : activities.size() - 1;
            while (activityIndex >= 0) {
                ActivityRecord r = activities.get(activityIndex);
                updatedConfig |= r.ensureActivityConfigurationLocked(0, preserveWindow);
                if (r.fullscreen) {
                    behindFullscreen = true;
                    break;
                }
                --activityIndex;
            }
            if (behindFullscreen) break;
        }
        if (updatedConfig) {
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        }
    }

    @Override
    public void requestResize(Rect bounds) {
        this.mService.resizeStack(this.mStackId, bounds, true, false, false, -1);
    }

    void resize(Rect bounds, Rect tempTaskBounds, Rect tempTaskInsetBounds) {
        if (!this.updateBoundsAllowed(bounds = TaskRecord.validateBounds(bounds), tempTaskBounds, tempTaskInsetBounds)) {
            return;
        }
        Rect taskBounds = tempTaskBounds != null ? tempTaskBounds : bounds;
        Rect insetBounds = tempTaskInsetBounds != null ? tempTaskInsetBounds : taskBounds;
        this.mTmpBounds.clear();
        this.mTmpConfigs.clear();
        this.mTmpInsetBounds.clear();
        for (int i = this.mTaskHistory.size() - 1; i >= 0; --i) {
            TaskRecord task = this.mTaskHistory.get(i);
            if (task.isResizeable()) {
                if (this.mStackId == 2) {
                    this.mTmpRect2.set(task.mBounds);
                    ActivityStack.fitWithinBounds(this.mTmpRect2, bounds);
                    task.updateOverrideConfiguration(this.mTmpRect2);
                } else {
                    task.updateOverrideConfiguration(taskBounds, insetBounds);
                }
            }
            this.mTmpConfigs.put(task.taskId, task.getOverrideConfiguration());
            this.mTmpBounds.put(task.taskId, task.mBounds);
            if (tempTaskInsetBounds == null) continue;
            this.mTmpInsetBounds.put(task.taskId, tempTaskInsetBounds);
        }
        this.mFullscreen = ((StackWindowController)this.mWindowContainerController).resize(bounds, this.mTmpConfigs, this.mTmpBounds, this.mTmpInsetBounds);
        this.setBounds(bounds);
    }

    private static void fitWithinBounds(Rect bounds, Rect stackBounds) {
        if (stackBounds == null || stackBounds.contains(bounds)) {
            return;
        }
        if (bounds.left < stackBounds.left || bounds.right > stackBounds.right) {
            int maxRight = stackBounds.right - stackBounds.width() / 3;
            int horizontalDiff = stackBounds.left - bounds.left;
            if (horizontalDiff < 0 && bounds.left >= maxRight || bounds.left + horizontalDiff >= maxRight) {
                horizontalDiff = maxRight - bounds.left;
            }
            bounds.left += horizontalDiff;
            bounds.right += horizontalDiff;
        }
        if (bounds.top < stackBounds.top || bounds.bottom > stackBounds.bottom) {
            int maxBottom = stackBounds.bottom - stackBounds.height() / 3;
            int verticalDiff = stackBounds.top - bounds.top;
            if (verticalDiff < 0 && bounds.top >= maxBottom || bounds.top + verticalDiff >= maxBottom) {
                verticalDiff = maxBottom - bounds.top;
            }
            bounds.top += verticalDiff;
            bounds.bottom += verticalDiff;
        }
    }

    boolean willActivityBeVisibleLocked(IBinder token) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.appToken == token) {
                    return true;
                }
                if (!r.fullscreen || r.finishing) continue;
                return false;
            }
        }
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        if (r == null) {
            return false;
        }
        if (r.finishing) {
            Slog.e("ActivityManager", "willActivityBeVisibleLocked: Returning false, would have returned true for r=" + r);
        }
        return !r.finishing;
    }

    void closeSystemDialogsLocked() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if ((r.info.flags & 0x100) == 0) continue;
                this.finishActivityLocked(r, 0, null, "close-sys", true);
            }
        }
    }

    boolean finishDisabledPackageActivitiesLocked(String packageName, Set<String> filterByClasses, boolean doit, boolean evenPersistent, int userId) {
        boolean didSomething = false;
        TaskRecord lastTask = null;
        ComponentName homeActivity = null;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            int numActivities = activities.size();
            for (int activityNdx = 0; activityNdx < numActivities; ++activityNdx) {
                boolean sameComponent;
                ActivityRecord r = activities.get(activityNdx);
                boolean bl = sameComponent = r.packageName.equals(packageName) && (filterByClasses == null || filterByClasses.contains(r.realActivity.getClassName())) || packageName == null && r.userId == userId;
                if (userId != -1 && r.userId != userId || !sameComponent && r.getTask() != lastTask || r.app != null && !evenPersistent && r.app.persistent) continue;
                if (!doit) {
                    if (r.finishing) continue;
                    return true;
                }
                if (r.isHomeActivity()) {
                    if (homeActivity != null && homeActivity.equals(r.realActivity)) {
                        Slog.i("ActivityManager", "Skip force-stop again " + r);
                        continue;
                    }
                    homeActivity = r.realActivity;
                }
                didSomething = true;
                Slog.i("ActivityManager", "  Force finishing activity " + r);
                if (sameComponent) {
                    if (r.app != null) {
                        r.app.removed = true;
                    }
                    r.app = null;
                }
                lastTask = r.getTask();
                if (!this.finishActivityLocked(r, 0, null, "force-stop", true)) continue;
                --numActivities;
                --activityNdx;
            }
        }
        return didSomething;
    }

    void getTasksLocked(List<ActivityManager.RunningTaskInfo> list, int callingUid, boolean allowed) {
        boolean focusedStack = this.mStackSupervisor.getFocusedStack() == this;
        boolean topTask = true;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.getTopActivity() == null) continue;
            ActivityRecord r = null;
            ActivityRecord top = null;
            int numActivities = 0;
            int numRunning = 0;
            ArrayList<ActivityRecord> activities = task.mActivities;
            if (!allowed && !task.isHomeTask() && task.effectiveUid != callingUid) continue;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord tmp = activities.get(activityNdx);
                if (tmp.finishing) continue;
                r = tmp;
                if (top == null || top.state == ActivityState.INITIALIZING) {
                    top = r;
                    numRunning = 0;
                    numActivities = 0;
                }
                ++numActivities;
                if (r.app == null || r.app.thread == null) continue;
                ++numRunning;
            }
            ActivityManager.RunningTaskInfo ci = new ActivityManager.RunningTaskInfo();
            ci.id = task.taskId;
            ci.stackId = this.mStackId;
            ci.baseActivity = r.intent.getComponent();
            ci.topActivity = top.intent.getComponent();
            ci.lastActiveTime = task.lastActiveTime;
            if (focusedStack && topTask) {
                ci.lastActiveTime = System.currentTimeMillis();
                topTask = false;
            }
            if (top.getTask() != null) {
                ci.description = top.getTask().lastDescription;
            }
            ci.numActivities = numActivities;
            ci.numRunning = numRunning;
            ci.supportsSplitScreenMultiWindow = task.supportsSplitScreen();
            ci.resizeMode = task.mResizeMode;
            list.add(ci);
        }
    }

    void unhandledBackLocked() {
        ArrayList<ActivityRecord> activities;
        int activityTop;
        int top = this.mTaskHistory.size() - 1;
        if (top >= 0 && (activityTop = (activities = this.mTaskHistory.get((int)top).mActivities).size() - 1) >= 0) {
            this.finishActivityLocked(activities.get(activityTop), 0, null, "unhandled-back", true);
        }
    }

    boolean handleAppDiedLocked(ProcessRecord app) {
        if (this.mPausingActivity != null && this.mPausingActivity.app == app) {
            this.mPausingActivity = null;
        }
        if (this.mLastPausedActivity != null && this.mLastPausedActivity.app == app) {
            this.mLastPausedActivity = null;
            this.mLastNoHistoryActivity = null;
        }
        return this.removeHistoryRecordsForAppLocked(app);
    }

    void handleAppCrashLocked(ProcessRecord app) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.app != app) continue;
                Slog.w("ActivityManager", "  Force finishing activity " + r.intent.getComponent().flattenToShortString());
                r.app = null;
                this.finishCurrentActivityLocked(r, 0, false);
            }
        }
    }

    boolean dumpActivitiesLocked(FileDescriptor fd, PrintWriter pw, boolean dumpAll, boolean dumpClient, String dumpPackage, boolean needSep, String header) {
        boolean printed = false;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (!(printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mTaskHistory.get((int)taskNdx).mActivities, "    ", "Hist", true, !dumpAll, dumpClient, dumpPackage, needSep, header, "    Task id #" + task.taskId + "\n" + "    mFullscreen=" + task.mFullscreen + "\n" + "    mBounds=" + task.mBounds + "\n" + "    mMinWidth=" + task.mMinWidth + "\n" + "    mMinHeight=" + task.mMinHeight + "\n" + "    mLastNonFullscreenBounds=" + task.mLastNonFullscreenBounds))) continue;
            header = null;
        }
        return printed;
    }

    ArrayList<ActivityRecord> getDumpActivitiesLocked(String name) {
        ArrayList<ActivityRecord> activities;
        block4: {
            block5: {
                ArrayList<ActivityRecord> list;
                int listTop;
                block3: {
                    activities = new ArrayList<ActivityRecord>();
                    if (!"all".equals(name)) break block3;
                    for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
                        activities.addAll(this.mTaskHistory.get((int)taskNdx).mActivities);
                    }
                    break block4;
                }
                if (!"top".equals(name)) break block5;
                int top = this.mTaskHistory.size() - 1;
                if (top < 0 || (listTop = (list = this.mTaskHistory.get((int)top).mActivities).size() - 1) < 0) break block4;
                activities.add(list.get(listTop));
                break block4;
            }
            ActivityManagerService.ItemMatcher matcher = new ActivityManagerService.ItemMatcher();
            matcher.build(name);
            for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
                for (ActivityRecord r1 : this.mTaskHistory.get((int)taskNdx).mActivities) {
                    if (!matcher.match(r1, r1.intent.getComponent())) continue;
                    activities.add(r1);
                }
            }
        }
        return activities;
    }

    ActivityRecord restartPackage(String packageName) {
        ActivityRecord starting = this.topRunningActivityLocked();
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord a = activities.get(activityNdx);
                if (!a.info.packageName.equals(packageName)) continue;
                a.forceNewConfig = true;
                if (starting == null || a != starting || !a.visible) continue;
                a.startFreezingScreenLocked(starting.app, 256);
            }
        }
        return starting;
    }

    void removeTask(TaskRecord task, String reason, int mode) {
        TaskRecord nextTask;
        for (ActivityRecord record : task.mActivities) {
            this.onActivityRemovedFromStack(record);
        }
        int taskNdx = this.mTaskHistory.indexOf(task);
        int topTaskNdx = this.mTaskHistory.size() - 1;
        if (task.isOverHomeStack() && taskNdx < topTaskNdx && !(nextTask = this.mTaskHistory.get(taskNdx + 1)).isOverHomeStack() && !nextTask.isOverAssistantStack()) {
            nextTask.setTaskToReturnTo(1);
        }
        this.mTaskHistory.remove(task);
        this.removeActivitiesFromLRUListLocked(task);
        this.updateTaskMovement(task, true);
        if (mode == 0 && task.mActivities.isEmpty()) {
            boolean isVoiceSession;
            boolean bl = isVoiceSession = task.voiceSession != null;
            if (isVoiceSession) {
                try {
                    task.voiceSession.taskFinished(task.intent, task.taskId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (task.autoRemoveFromRecents() || isVoiceSession) {
                this.mRecentTasks.remove(task);
                task.removedFromRecents();
            }
            task.removeWindowContainer();
        }
        if (this.mTaskHistory.isEmpty()) {
            if (this.isOnHomeDisplay() && mode != 2 && this.mStackSupervisor.isFocusedStack(this)) {
                String myReason = reason + " leftTaskHistoryEmpty";
                if (this.mFullscreen || !this.adjustFocusToNextFocusableStackLocked(myReason)) {
                    this.mStackSupervisor.moveHomeStackToFront(myReason);
                }
            }
            if (this.mStacks != null) {
                this.mStacks.remove(this);
                this.mStacks.add(0, this);
            }
            if (!this.isHomeOrRecentsStack()) {
                this.remove();
            }
        }
        task.setStack(null);
        if (this.mStackId == 4) {
            this.mService.mTaskChangeNotificationController.notifyActivityUnpinned();
        }
    }

    TaskRecord createTaskRecord(int taskId, ActivityInfo info, Intent intent, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, boolean toTop, int type) {
        TaskRecord task = new TaskRecord(this.mService, taskId, info, intent, voiceSession, voiceInteractor, type);
        this.addTask(task, toTop, "createTaskRecord");
        boolean isLockscreenShown = this.mService.mStackSupervisor.mKeyguardController.isKeyguardShowing(this.mDisplayId != -1 ? this.mDisplayId : 0);
        if (!this.layoutTaskInStack(task, info.windowLayout) && this.mBounds != null && task.isResizeable() && !isLockscreenShown) {
            task.updateOverrideConfiguration(this.mBounds);
        }
        task.createWindowContainer(toTop, (info.flags & 0x400) != 0);
        return task;
    }

    boolean layoutTaskInStack(TaskRecord task, ActivityInfo.WindowLayout windowLayout) {
        if (this.mTaskPositioner == null) {
            return false;
        }
        this.mTaskPositioner.updateDefaultBounds(task, this.mTaskHistory, windowLayout);
        return true;
    }

    ArrayList<TaskRecord> getAllTasks() {
        return new ArrayList<TaskRecord>(this.mTaskHistory);
    }

    void addTask(TaskRecord task, boolean toTop, String reason) {
        this.addTask(task, toTop ? Integer.MAX_VALUE : 0, true, reason);
        if (toTop) {
            ((StackWindowController)this.mWindowContainerController).positionChildAtTop(task.getWindowContainerController(), true);
        }
    }

    void addTask(TaskRecord task, int position, boolean schedulePictureInPictureModeChange, String reason) {
        this.mTaskHistory.remove(task);
        position = this.getAdjustedPositionForTask(task, position, null);
        boolean toTop = position >= this.mTaskHistory.size();
        ActivityStack prevStack = this.preAddTask(task, reason, toTop);
        this.mTaskHistory.add(position, task);
        task.setStack(this);
        if (toTop) {
            this.updateTaskReturnToForTopInsertion(task);
        }
        this.updateTaskMovement(task, toTop);
        this.postAddTask(task, prevStack, schedulePictureInPictureModeChange);
    }

    void positionChildAt(TaskRecord task, int index) {
        if (task.getStack() != this) {
            throw new IllegalArgumentException("AS.positionChildAt: task=" + task + " is not a child of stack=" + this + " current parent=" + task.getStack());
        }
        task.updateOverrideConfigurationForStack(this);
        ActivityRecord topRunningActivity = task.topRunningActivityLocked();
        boolean wasResumed = topRunningActivity == task.getStack().mResumedActivity;
        this.insertTaskAtPosition(task, index);
        task.setStack(this);
        this.postAddTask(task, null, true);
        if (wasResumed) {
            if (this.mResumedActivity != null) {
                Log.wtf("ActivityManager", "mResumedActivity was already set when moving mResumedActivity from other stack to this stack mResumedActivity=" + this.mResumedActivity + " other mResumedActivity=" + topRunningActivity);
            }
            this.mResumedActivity = topRunningActivity;
        }
        this.ensureActivitiesVisibleLocked(null, 0, false);
        this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
    }

    private ActivityStack preAddTask(TaskRecord task, String reason, boolean toTop) {
        ActivityStack prevStack = task.getStack();
        if (prevStack != null && prevStack != this) {
            prevStack.removeTask(task, reason, toTop ? 2 : 1);
        }
        return prevStack;
    }

    private void postAddTask(TaskRecord task, ActivityStack prevStack, boolean schedulePictureInPictureModeChange) {
        if (schedulePictureInPictureModeChange && prevStack != null) {
            this.mStackSupervisor.scheduleUpdatePictureInPictureModeIfNeeded(task, prevStack);
        } else if (task.voiceSession != null) {
            try {
                task.voiceSession.taskStarted(task.intent, task.taskId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    void moveToFrontAndResumeStateIfNeeded(ActivityRecord r, boolean moveToFront, boolean setResume, boolean setPause, String reason) {
        if (!moveToFront) {
            return;
        }
        if (setResume) {
            this.mResumedActivity = r;
            this.updateLRUListLocked(r);
        }
        if (setPause) {
            this.mPausingActivity = r;
            this.schedulePauseTimeout(r);
        }
        this.moveToFront(reason);
    }

    public int getStackId() {
        return this.mStackId;
    }

    public String toString() {
        return "ActivityStack{" + Integer.toHexString(System.identityHashCode(this)) + " stackId=" + this.mStackId + ", " + this.mTaskHistory.size() + " tasks}";
    }

    void onLockTaskPackagesUpdatedLocked() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            this.mTaskHistory.get(taskNdx).setLockTaskAuth();
        }
    }

    void executeAppTransition(ActivityOptions options) {
        this.mWindowManager.executeAppTransition();
        this.mNoAnimActivities.clear();
        ActivityOptions.abort(options);
    }

    boolean shouldSleepActivities() {
        ActivityStackSupervisor.ActivityDisplay display = this.getDisplay();
        return display != null ? display.isSleeping() : this.mService.isSleepingLocked();
    }

    boolean shouldSleepOrShutDownActivities() {
        return this.shouldSleepActivities() || this.mService.isShuttingDownLocked();
    }

    private class ActivityStackHandler
    extends Handler {
        ActivityStackHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 101: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w("ActivityManager", "Activity pause timeout for " + r);
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            if (r.app != null) {
                                ActivityStack.this.mService.logAppTooSlow(r.app, r.pauseTime, "pausing " + r);
                            }
                            ActivityStack.this.activityPausedLocked(r.appToken, true);
                            // MONITOREXIT @DISABLED, blocks:[0, 9, 12, 13] lbl13 : MonitorExitStatement: MONITOREXIT : var3_8
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            break;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[20, 9, 12, 13] lbl17 : MonitorExitStatement: MONITOREXIT : var3_8
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                }
                case 103: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            if (r.continueLaunchTickingLocked()) {
                                ActivityStack.this.mService.logAppTooSlow(r.app, r.launchTickTime, "launching " + r);
                            }
                            // MONITOREXIT @DISABLED, blocks:[1, 7, 12, 14] lbl28 : MonitorExitStatement: MONITOREXIT : var3_9
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            break;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[21, 7, 12, 14] lbl32 : MonitorExitStatement: MONITOREXIT : var3_9
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                }
                case 102: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w("ActivityManager", "Activity destroy timeout for " + r);
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityStack.this.activityDestroyedLocked(r != null ? r.appToken : null, "destroyTimeout");
                            // MONITOREXIT @DISABLED, blocks:[2, 10, 12, 15] lbl44 : MonitorExitStatement: MONITOREXIT : var3_10
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            break;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[22, 10, 12, 15] lbl48 : MonitorExitStatement: MONITOREXIT : var3_10
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                }
                case 104: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w("ActivityManager", "Activity stop timeout for " + r);
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            if (r.isInHistory()) {
                                r.activityStoppedLocked(null, null, null);
                            }
                            // MONITOREXIT @DISABLED, blocks:[16, 3, 11, 12] lbl61 : MonitorExitStatement: MONITOREXIT : var3_11
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            break;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[16, 23, 11, 12] lbl65 : MonitorExitStatement: MONITOREXIT : var3_11
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                }
                case 105: {
                    ScheduleDestroyArgs args = (ScheduleDestroyArgs)msg.obj;
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityStack.this.destroyActivitiesLocked(args.mOwner, args.mReason);
                            // MONITOREXIT @DISABLED, blocks:[17, 4, 8, 12] lbl75 : MonitorExitStatement: MONITOREXIT : var3_12
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            break;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[17, 8, 24, 12] lbl79 : MonitorExitStatement: MONITOREXIT : var3_12
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                }
                case 106: {
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            ActivityStack.this.notifyActivityDrawnLocked(null);
                            // MONITOREXIT @DISABLED, blocks:[18, 5, 6, 12] lbl88 : MonitorExitStatement: MONITOREXIT : var2_7
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            break;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[18, 6, 25, 12] lbl92 : MonitorExitStatement: MONITOREXIT : var2_7
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                }
            }
        }
    }

    private static class ScheduleDestroyArgs {
        final ProcessRecord mOwner;
        final String mReason;

        ScheduleDestroyArgs(ProcessRecord owner, String reason) {
            this.mOwner = owner;
            this.mReason = reason;
        }
    }

    static enum ActivityState {
        INITIALIZING,
        RESUMED,
        PAUSING,
        PAUSED,
        STOPPING,
        STOPPED,
        FINISHING,
        DESTROYING,
        DESTROYED;

    }
}

