/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.service.persistentdata.IPersistentDataBlockService;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.server.LocalServices;
import com.android.server.PersistentDataBlockManagerInternal;
import com.android.server.SystemServerInitThreadPool;
import com.android.server.SystemService;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;

public class PersistentDataBlockService
extends SystemService {
    private static final String TAG = PersistentDataBlockService.class.getSimpleName();
    private static final String PERSISTENT_DATA_BLOCK_PROP = "ro.frp.pst";
    private static final int HEADER_SIZE = 8;
    private static final int PARTITION_TYPE_MARKER = 428873843;
    private static final int FRP_CREDENTIAL_RESERVED_SIZE = 1000;
    private static final int MAX_FRP_CREDENTIAL_HANDLE_SIZE = 996;
    private static final int MAX_DATA_BLOCK_SIZE = 102400;
    public static final int DIGEST_SIZE_BYTES = 32;
    private static final String OEM_UNLOCK_PROP = "sys.oem_unlock_allowed";
    private static final String FLASH_LOCK_PROP = "ro.boot.flash.locked";
    private static final String FLASH_LOCK_LOCKED = "1";
    private static final String FLASH_LOCK_UNLOCKED = "0";
    private final Context mContext;
    private final String mDataBlockFile;
    private final Object mLock = new Object();
    private final CountDownLatch mInitDoneSignal = new CountDownLatch(1);
    private int mAllowedUid = -1;
    private long mBlockDeviceSize;
    @GuardedBy(value="mLock")
    private boolean mIsWritable = true;
    private final IBinder mService = new IPersistentDataBlockService.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int write(byte[] data) throws RemoteException {
            DataOutputStream outputStream;
            PersistentDataBlockService.this.enforceUid(Binder.getCallingUid());
            long maxBlockSize = PersistentDataBlockService.this.doGetMaximumDataBlockSize();
            if ((long)data.length > maxBlockSize) {
                return (int)(-maxBlockSize);
            }
            try {
                outputStream = new DataOutputStream(new FileOutputStream(new File(PersistentDataBlockService.this.mDataBlockFile)));
            }
            catch (FileNotFoundException e) {
                Slog.e(TAG, "partition not available?", e);
                return -1;
            }
            ByteBuffer headerAndData = ByteBuffer.allocate(data.length + 8);
            headerAndData.putInt(428873843);
            headerAndData.putInt(data.length);
            headerAndData.put(data);
            Object object = PersistentDataBlockService.this.mLock;
            synchronized (object) {
                if (!PersistentDataBlockService.this.mIsWritable) {
                    IoUtils.closeQuietly(outputStream);
                    return -1;
                }
                try {
                    byte[] checksum = new byte[32];
                    outputStream.write(checksum, 0, 32);
                    outputStream.write(headerAndData.array());
                    outputStream.flush();
                }
                catch (IOException e) {
                    Slog.e(TAG, "failed writing to the persistent data block", e);
                    int n = -1;
                    return n;
                }
                finally {
                    IoUtils.closeQuietly(outputStream);
                }
                if (PersistentDataBlockService.this.computeAndWriteDigestLocked()) {
                    return data.length;
                }
                return -1;
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public byte[] read() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void wipe() {
            PersistentDataBlockService.this.enforceOemUnlockWritePermission();
            Object object = PersistentDataBlockService.this.mLock;
            synchronized (object) {
                int ret = PersistentDataBlockService.this.nativeWipe(PersistentDataBlockService.this.mDataBlockFile);
                if (ret < 0) {
                    Slog.e(TAG, "failed to wipe persistent partition");
                } else {
                    PersistentDataBlockService.this.mIsWritable = false;
                    Slog.i(TAG, "persistent partition now wiped and unwritable");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOemUnlockEnabled(boolean enabled) throws SecurityException {
            if (ActivityManager.isUserAMonkey()) {
                return;
            }
            PersistentDataBlockService.this.enforceOemUnlockWritePermission();
            PersistentDataBlockService.this.enforceIsAdmin();
            if (enabled) {
                PersistentDataBlockService.this.enforceUserRestriction("no_oem_unlock");
                PersistentDataBlockService.this.enforceUserRestriction("no_factory_reset");
            }
            Object object = PersistentDataBlockService.this.mLock;
            synchronized (object) {
                PersistentDataBlockService.this.doSetOemUnlockEnabledLocked(enabled);
                PersistentDataBlockService.this.computeAndWriteDigestLocked();
            }
        }

        @Override
        public boolean getOemUnlockEnabled() {
            PersistentDataBlockService.this.enforceOemUnlockReadPermission();
            return PersistentDataBlockService.this.doGetOemUnlockEnabled();
        }

        @Override
        public int getFlashLockState() {
            String locked;
            PersistentDataBlockService.this.enforceOemUnlockReadPermission();
            switch (locked = SystemProperties.get(PersistentDataBlockService.FLASH_LOCK_PROP)) {
                case "1": {
                    return 1;
                }
                case "0": {
                    return 0;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getDataBlockSize() {
            DataInputStream inputStream;
            this.enforcePersistentDataBlockAccess();
            try {
                inputStream = new DataInputStream(new FileInputStream(new File(PersistentDataBlockService.this.mDataBlockFile)));
            }
            catch (FileNotFoundException e) {
                Slog.e(TAG, "partition not available");
                return 0;
            }
            try {
                Object e = PersistentDataBlockService.this.mLock;
                synchronized (e) {
                    try {
                        int n = PersistentDataBlockService.this.getTotalDataSizeLocked(inputStream);
                        return n;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (IOException e2) {
                            Slog.e(TAG, "error reading data block size");
                            int n = 0;
                            return n;
                        }
                    }
                }
            }
            finally {
                IoUtils.closeQuietly(inputStream);
            }
        }

        private void enforcePersistentDataBlockAccess() {
            if (PersistentDataBlockService.this.mContext.checkCallingPermission("android.permission.ACCESS_PDB_STATE") != 0) {
                PersistentDataBlockService.this.enforceUid(Binder.getCallingUid());
            }
        }

        @Override
        public long getMaximumDataBlockSize() {
            PersistentDataBlockService.this.enforceUid(Binder.getCallingUid());
            return PersistentDataBlockService.this.doGetMaximumDataBlockSize();
        }

        @Override
        public boolean hasFrpCredentialHandle() {
            this.enforcePersistentDataBlockAccess();
            return PersistentDataBlockService.this.mInternalService.getFrpCredentialHandle() != null;
        }
    };
    private PersistentDataBlockManagerInternal mInternalService = new PersistentDataBlockManagerInternal(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFrpCredentialHandle(byte[] handle) {
            FileOutputStream outputStream;
            Preconditions.checkArgument(handle == null || handle.length > 0, "handle must be null or non-empty");
            Preconditions.checkArgument(handle == null || handle.length <= 996, "handle must not be longer than 996");
            try {
                outputStream = new FileOutputStream(new File(PersistentDataBlockService.this.mDataBlockFile));
            }
            catch (FileNotFoundException e) {
                Slog.e(TAG, "partition not available", e);
                return;
            }
            ByteBuffer data = ByteBuffer.allocate(1000);
            data.putInt(handle == null ? 0 : handle.length);
            if (handle != null) {
                data.put(handle);
            }
            data.flip();
            Object object = PersistentDataBlockService.this.mLock;
            synchronized (object) {
                if (!PersistentDataBlockService.this.mIsWritable) {
                    IoUtils.closeQuietly(outputStream);
                    return;
                }
                try {
                    FileChannel channel = outputStream.getChannel();
                    channel.position(PersistentDataBlockService.this.getBlockDeviceSize() - 1L - 1000L);
                    channel.write(data);
                    outputStream.flush();
                }
                catch (IOException e) {
                    Slog.e(TAG, "unable to access persistent partition", e);
                    return;
                }
                finally {
                    IoUtils.closeQuietly(outputStream);
                }
                PersistentDataBlockService.this.computeAndWriteDigestLocked();
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public byte[] getFrpCredentialHandle() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    };

    public PersistentDataBlockService(Context context) {
        super(context);
        this.mContext = context;
        this.mDataBlockFile = SystemProperties.get(PERSISTENT_DATA_BLOCK_PROP);
        this.mBlockDeviceSize = -1L;
    }

    private int getAllowedUid(int userHandle) {
        String allowedPackage = this.mContext.getResources().getString(17039685);
        PackageManager pm = this.mContext.getPackageManager();
        int allowedUid = -1;
        try {
            allowedUid = pm.getPackageUidAsUser(allowedPackage, 0x100000, userHandle);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(TAG, "not able to find package " + allowedPackage, e);
        }
        return allowedUid;
    }

    @Override
    public void onStart() {
        SystemServerInitThreadPool.get().submit(() -> {
            this.mAllowedUid = this.getAllowedUid(0);
            this.enforceChecksumValidity();
            this.formatIfOemUnlockEnabled();
            this.publishBinderService("persistent_data_block", this.mService);
            this.mInitDoneSignal.countDown();
        }, TAG + ".onStart");
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            try {
                if (!this.mInitDoneSignal.await(10L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Service " + TAG + " init timeout");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Service " + TAG + " init interrupted", e);
            }
            LocalServices.addService(PersistentDataBlockManagerInternal.class, this.mInternalService);
        }
        super.onBootPhase(phase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatIfOemUnlockEnabled() {
        boolean enabled = this.doGetOemUnlockEnabled();
        if (enabled) {
            Object object = this.mLock;
            synchronized (object) {
                this.formatPartitionLocked(true);
            }
        }
        SystemProperties.set(OEM_UNLOCK_PROP, enabled ? FLASH_LOCK_LOCKED : FLASH_LOCK_UNLOCKED);
    }

    private void enforceOemUnlockReadPermission() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.READ_OEM_UNLOCK_STATE") == -1 && this.mContext.checkCallingOrSelfPermission("android.permission.OEM_UNLOCK_STATE") == -1) {
            throw new SecurityException("Can't access OEM unlock state. Requires READ_OEM_UNLOCK_STATE or OEM_UNLOCK_STATE permission.");
        }
    }

    private void enforceOemUnlockWritePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.OEM_UNLOCK_STATE", "Can't modify OEM unlock state");
    }

    private void enforceUid(int callingUid) {
        if (callingUid != this.mAllowedUid) {
            throw new SecurityException("uid " + callingUid + " not allowed to access PST");
        }
    }

    private void enforceIsAdmin() {
        int userId = UserHandle.getCallingUserId();
        boolean isAdmin = UserManager.get(this.mContext).isUserAdmin(userId);
        if (!isAdmin) {
            throw new SecurityException("Only the Admin user is allowed to change OEM unlock state");
        }
    }

    private void enforceUserRestriction(String userRestriction) {
        if (UserManager.get(this.mContext).hasUserRestriction(userRestriction)) {
            throw new SecurityException("OEM unlock is disallowed by user restriction: " + userRestriction);
        }
    }

    private int getTotalDataSizeLocked(DataInputStream inputStream) throws IOException {
        inputStream.skipBytes(32);
        int blockId = inputStream.readInt();
        int totalDataSize = blockId == 428873843 ? inputStream.readInt() : 0;
        return totalDataSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getBlockDeviceSize() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBlockDeviceSize == -1L) {
                this.mBlockDeviceSize = this.nativeGetBlockDeviceSize(this.mDataBlockFile);
            }
        }
        return this.mBlockDeviceSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enforceChecksumValidity() {
        byte[] storedDigest = new byte[32];
        Object object = this.mLock;
        synchronized (object) {
            byte[] digest = this.computeDigestLocked(storedDigest);
            if (digest == null || !Arrays.equals(storedDigest, digest)) {
                Slog.i(TAG, "Formatting FRP partition...");
                this.formatPartitionLocked(false);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean computeAndWriteDigestLocked() {
        byte[] digest = this.computeDigestLocked(null);
        if (digest != null) {
            DataOutputStream outputStream;
            try {
                outputStream = new DataOutputStream(new FileOutputStream(new File(this.mDataBlockFile)));
            }
            catch (FileNotFoundException e) {
                Slog.e(TAG, "partition not available?", e);
                return false;
            }
            try {
                outputStream.write(digest, 0, 32);
                outputStream.flush();
            }
            catch (IOException e) {
                Slog.e(TAG, "failed to write block checksum", e);
                boolean bl = false;
                return bl;
            }
            finally {
                IoUtils.closeQuietly(outputStream);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] computeDigestLocked(byte[] storedDigest) {
        MessageDigest md;
        DataInputStream inputStream;
        try {
            inputStream = new DataInputStream(new FileInputStream(new File(this.mDataBlockFile)));
        }
        catch (FileNotFoundException e) {
            Slog.e(TAG, "partition not available?", e);
            return null;
        }
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            Slog.e(TAG, "SHA-256 not supported?", e);
            IoUtils.closeQuietly(inputStream);
            return null;
        }
        try {
            int read;
            if (storedDigest != null && storedDigest.length == 32) {
                inputStream.read(storedDigest);
            } else {
                inputStream.skipBytes(32);
            }
            byte[] data = new byte[1024];
            md.update(data, 0, 32);
            while ((read = inputStream.read(data)) != -1) {
                md.update(data, 0, read);
            }
        }
        catch (IOException e) {
            Slog.e(TAG, "failed to read partition", e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IoUtils.closeQuietly(inputStream);
        }
        return md.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatPartitionLocked(boolean setOemUnlockEnabled) {
        DataOutputStream outputStream;
        try {
            outputStream = new DataOutputStream(new FileOutputStream(new File(this.mDataBlockFile)));
        }
        catch (FileNotFoundException e) {
            Slog.e(TAG, "partition not available?", e);
            return;
        }
        byte[] data = new byte[32];
        try {
            outputStream.write(data, 0, 32);
            outputStream.writeInt(428873843);
            outputStream.writeInt(0);
            outputStream.flush();
        }
        catch (IOException e) {
            Slog.e(TAG, "failed to format block", e);
            return;
        }
        finally {
            IoUtils.closeQuietly(outputStream);
        }
        this.doSetOemUnlockEnabledLocked(setOemUnlockEnabled);
        this.computeAndWriteDigestLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetOemUnlockEnabledLocked(boolean enabled) {
        FileOutputStream outputStream;
        try {
            outputStream = new FileOutputStream(new File(this.mDataBlockFile));
        }
        catch (FileNotFoundException e) {
            Slog.e(TAG, "partition not available", e);
            return;
        }
        try {
            FileChannel channel = outputStream.getChannel();
            channel.position(this.getBlockDeviceSize() - 1L);
            ByteBuffer data = ByteBuffer.allocate(1);
            data.put(enabled ? (byte)1 : 0);
            data.flip();
            channel.write(data);
            outputStream.flush();
            SystemProperties.set(OEM_UNLOCK_PROP, enabled ? FLASH_LOCK_LOCKED : FLASH_LOCK_UNLOCKED);
        }
        catch (IOException e) {
            try {
                Slog.e(TAG, "unable to access persistent partition", e);
                SystemProperties.set(OEM_UNLOCK_PROP, enabled ? FLASH_LOCK_LOCKED : FLASH_LOCK_UNLOCKED);
            }
            catch (Throwable throwable) {
                SystemProperties.set(OEM_UNLOCK_PROP, enabled ? FLASH_LOCK_LOCKED : FLASH_LOCK_UNLOCKED);
                IoUtils.closeQuietly(outputStream);
                throw throwable;
            }
            IoUtils.closeQuietly(outputStream);
            return;
        }
        IoUtils.closeQuietly(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doGetOemUnlockEnabled() {
        DataInputStream inputStream;
        try {
            inputStream = new DataInputStream(new FileInputStream(new File(this.mDataBlockFile)));
        }
        catch (FileNotFoundException e) {
            Slog.e(TAG, "partition not available");
            return false;
        }
        try {
            Object e = this.mLock;
            synchronized (e) {
                try {
                    inputStream.skip(this.getBlockDeviceSize() - 1L);
                    boolean bl = inputStream.readByte() != 0;
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (IOException e2) {
                        Slog.e(TAG, "unable to access persistent partition", e2);
                        boolean bl = false;
                        return bl;
                    }
                }
            }
        }
        finally {
            IoUtils.closeQuietly(inputStream);
        }
    }

    private long doGetMaximumDataBlockSize() {
        long actualSize = this.getBlockDeviceSize() - 8L - 32L - 1000L - 1L;
        return actualSize <= 102400L ? actualSize : 102400L;
    }

    private native long nativeGetBlockDeviceSize(String var1);

    private native int nativeWipe(String var1);

    static /* synthetic */ boolean access$700(PersistentDataBlockService x0) {
        return x0.enforceChecksumValidity();
    }
}

