/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.ConnectivityManager;
import android.net.Network;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Log;
import android.util.NtpTrustedTime;
import android.util.TimeUtils;
import android.util.TrustedTime;
import com.android.internal.util.DumpUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class NetworkTimeUpdateService
extends Binder {
    private static final String TAG = "NetworkTimeUpdateService";
    private static final boolean DBG = false;
    private static final int EVENT_AUTO_TIME_CHANGED = 1;
    private static final int EVENT_POLL_NETWORK_TIME = 2;
    private static final int EVENT_NETWORK_CHANGED = 3;
    private static final String ACTION_POLL = "com.android.server.NetworkTimeUpdateService.action.POLL";
    private static final int NETWORK_CHANGE_EVENT_DELAY_MS = 1000;
    private static int POLL_REQUEST = 0;
    private static final long NOT_SET = -1L;
    private long mNitzTimeSetTime = -1L;
    private long mNitzZoneSetTime = -1L;
    private Network mDefaultNetwork = null;
    private Context mContext;
    private TrustedTime mTime;
    private Handler mHandler;
    private AlarmManager mAlarmManager;
    private PendingIntent mPendingPollIntent;
    private SettingsObserver mSettingsObserver;
    private ConnectivityManager mCM;
    private NetworkTimeUpdateCallback mNetworkTimeUpdateCallback;
    private long mLastNtpFetchTime = -1L;
    private final PowerManager.WakeLock mWakeLock;
    private final long mPollingIntervalMs;
    private final long mPollingIntervalShorterMs;
    private final int mTryAgainTimesMax;
    private final int mTimeErrorThresholdMs;
    private int mTryAgainCounter;
    private BroadcastReceiver mNitzReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.NETWORK_SET_TIME".equals(action)) {
                NetworkTimeUpdateService.this.mNitzTimeSetTime = SystemClock.elapsedRealtime();
            } else if ("android.intent.action.NETWORK_SET_TIMEZONE".equals(action)) {
                NetworkTimeUpdateService.this.mNitzZoneSetTime = SystemClock.elapsedRealtime();
            }
        }
    };

    public NetworkTimeUpdateService(Context context) {
        this.mContext = context;
        this.mTime = NtpTrustedTime.getInstance(context);
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        this.mCM = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        Intent pollIntent = new Intent(ACTION_POLL, null);
        this.mPendingPollIntent = PendingIntent.getBroadcast(this.mContext, POLL_REQUEST, pollIntent, 0);
        this.mPollingIntervalMs = this.mContext.getResources().getInteger(17694830);
        this.mPollingIntervalShorterMs = this.mContext.getResources().getInteger(17694831);
        this.mTryAgainTimesMax = this.mContext.getResources().getInteger(17694832);
        this.mTimeErrorThresholdMs = this.mContext.getResources().getInteger(17694833);
        this.mWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, TAG);
    }

    public void systemRunning() {
        this.registerForTelephonyIntents();
        this.registerForAlarms();
        HandlerThread thread = new HandlerThread(TAG);
        thread.start();
        this.mHandler = new MyHandler(thread.getLooper());
        this.mNetworkTimeUpdateCallback = new NetworkTimeUpdateCallback();
        this.mCM.registerDefaultNetworkCallback(this.mNetworkTimeUpdateCallback, this.mHandler);
        this.mSettingsObserver = new SettingsObserver(this.mHandler, 1);
        this.mSettingsObserver.observe(this.mContext);
    }

    private void registerForTelephonyIntents() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.NETWORK_SET_TIME");
        intentFilter.addAction("android.intent.action.NETWORK_SET_TIMEZONE");
        this.mContext.registerReceiver(this.mNitzReceiver, intentFilter);
    }

    private void registerForAlarms() {
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                NetworkTimeUpdateService.this.mHandler.obtainMessage(2).sendToTarget();
            }
        }, new IntentFilter(ACTION_POLL));
    }

    private void onPollNetworkTime(int event) {
        if (!this.isAutomaticTimeRequested() || this.mDefaultNetwork == null) {
            return;
        }
        this.mWakeLock.acquire();
        try {
            this.onPollNetworkTimeUnderWakeLock(event);
        }
        finally {
            this.mWakeLock.release();
        }
    }

    private void onPollNetworkTimeUnderWakeLock(int event) {
        long refTime = SystemClock.elapsedRealtime();
        if (this.mNitzTimeSetTime != -1L && refTime - this.mNitzTimeSetTime < this.mPollingIntervalMs) {
            this.resetAlarm(this.mPollingIntervalMs);
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.mLastNtpFetchTime == -1L || refTime >= this.mLastNtpFetchTime + this.mPollingIntervalMs || event == 1) {
            if (this.mTime.getCacheAge() >= this.mPollingIntervalMs) {
                this.mTime.forceRefresh();
            }
            if (this.mTime.getCacheAge() < this.mPollingIntervalMs) {
                long ntp = this.mTime.currentTimeMillis();
                this.mTryAgainCounter = 0;
                if ((Math.abs(ntp - currentTime) > (long)this.mTimeErrorThresholdMs || this.mLastNtpFetchTime == -1L) && ntp / 1000L < Integer.MAX_VALUE) {
                    SystemClock.setCurrentTimeMillis(ntp);
                }
                this.mLastNtpFetchTime = SystemClock.elapsedRealtime();
            } else {
                ++this.mTryAgainCounter;
                if (this.mTryAgainTimesMax < 0 || this.mTryAgainCounter <= this.mTryAgainTimesMax) {
                    this.resetAlarm(this.mPollingIntervalShorterMs);
                } else {
                    this.mTryAgainCounter = 0;
                    this.resetAlarm(this.mPollingIntervalMs);
                }
                return;
            }
        }
        this.resetAlarm(this.mPollingIntervalMs);
    }

    private void resetAlarm(long interval) {
        this.mAlarmManager.cancel(this.mPendingPollIntent);
        long now = SystemClock.elapsedRealtime();
        long next = now + interval;
        this.mAlarmManager.set(3, next, this.mPendingPollIntent);
    }

    private boolean isAutomaticTimeRequested() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "auto_time", 0) != 0;
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        pw.print("PollingIntervalMs: ");
        TimeUtils.formatDuration(this.mPollingIntervalMs, pw);
        pw.print("\nPollingIntervalShorterMs: ");
        TimeUtils.formatDuration(this.mPollingIntervalShorterMs, pw);
        pw.println("\nTryAgainTimesMax: " + this.mTryAgainTimesMax);
        pw.print("TimeErrorThresholdMs: ");
        TimeUtils.formatDuration((long)this.mTimeErrorThresholdMs, pw);
        pw.println("\nTryAgainCounter: " + this.mTryAgainCounter);
        pw.print("LastNtpFetchTime: ");
        TimeUtils.formatDuration(this.mLastNtpFetchTime, pw);
        pw.println();
    }

    private static class SettingsObserver
    extends ContentObserver {
        private int mMsg;
        private Handler mHandler;

        SettingsObserver(Handler handler, int msg) {
            super(handler);
            this.mHandler = handler;
            this.mMsg = msg;
        }

        void observe(Context context) {
            ContentResolver resolver = context.getContentResolver();
            resolver.registerContentObserver(Settings.Global.getUriFor("auto_time"), false, this);
        }

        @Override
        public void onChange(boolean selfChange) {
            this.mHandler.obtainMessage(this.mMsg).sendToTarget();
        }
    }

    private class NetworkTimeUpdateCallback
    extends ConnectivityManager.NetworkCallback {
        private NetworkTimeUpdateCallback() {
        }

        @Override
        public void onAvailable(Network network) {
            Log.d(NetworkTimeUpdateService.TAG, String.format("New default network %s; checking time.", network));
            NetworkTimeUpdateService.this.mDefaultNetwork = network;
            NetworkTimeUpdateService.this.onPollNetworkTime(3);
        }

        @Override
        public void onLost(Network network) {
            if (network.equals(NetworkTimeUpdateService.this.mDefaultNetwork)) {
                NetworkTimeUpdateService.this.mDefaultNetwork = null;
            }
        }
    }

    private class MyHandler
    extends Handler {
        public MyHandler(Looper l) {
            super(l);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: 
                case 2: 
                case 3: {
                    NetworkTimeUpdateService.this.onPollNetworkTime(msg.what);
                }
            }
        }
    }
}

