/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.UserInfo;
import android.media.AudioAttributes;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManagerInternal;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.LocalServices;
import com.android.server.LockGuard;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AppOpsService
extends IAppOpsService.Stub {
    static final String TAG = "AppOps";
    static final boolean DEBUG = false;
    static final long WRITE_DELAY = 1800000L;
    Context mContext;
    final AtomicFile mFile;
    final Handler mHandler;
    boolean mWriteScheduled;
    boolean mFastWriteScheduled;
    final Runnable mWriteRunner = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AppOpsService appOpsService = AppOpsService.this;
            synchronized (appOpsService) {
                AppOpsService.this.mWriteScheduled = false;
                AppOpsService.this.mFastWriteScheduled = false;
                AsyncTask<Void, Void, Void> task = new AsyncTask<Void, Void, Void>(){

                    protected Void doInBackground(Void ... params) {
                        AppOpsService.this.writeState();
                        return null;
                    }
                };
                task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null);
            }
        }
    };
    private final SparseArray<UidState> mUidStates = new SparseArray();
    private final ArrayMap<IBinder, ClientRestrictionState> mOpUserRestrictions = new ArrayMap();
    final SparseArray<ArraySet<Callback>> mOpModeWatchers = new SparseArray();
    final ArrayMap<String, ArraySet<Callback>> mPackageModeWatchers = new ArrayMap();
    final ArrayMap<IBinder, Callback> mModeWatchers = new ArrayMap();
    final SparseArray<SparseArray<Restriction>> mAudioRestrictions = new SparseArray();
    final ArrayMap<IBinder, ClientState> mClients = new ArrayMap();

    public AppOpsService(File storagePath, Handler handler) {
        LockGuard.installLock((Object)this, 0);
        this.mFile = new AtomicFile(storagePath);
        this.mHandler = handler;
        this.readState();
    }

    public void publish(Context context) {
        this.mContext = context;
        ServiceManager.addService("appops", this.asBinder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            boolean changed = false;
            for (int i = this.mUidStates.size() - 1; i >= 0; --i) {
                UidState uidState = this.mUidStates.valueAt(i);
                String[] packageNames = AppOpsService.getPackagesForUid(uidState.uid);
                if (ArrayUtils.isEmpty(packageNames)) {
                    uidState.clear();
                    this.mUidStates.removeAt(i);
                    changed = true;
                    continue;
                }
                ArrayMap<String, Ops> pkgs = uidState.pkgOps;
                if (pkgs == null) continue;
                Iterator<Ops> it = pkgs.values().iterator();
                while (it.hasNext()) {
                    Ops ops = it.next();
                    int curUid = -1;
                    try {
                        curUid = AppGlobals.getPackageManager().getPackageUid(ops.packageName, 8192, UserHandle.getUserId(ops.uidState.uid));
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (curUid == ops.uidState.uid) continue;
                    Slog.i(TAG, "Pruning old package " + ops.packageName + "/" + ops.uidState + ": new uid=" + curUid);
                    it.remove();
                    changed = true;
                }
                if (!uidState.isDefault()) continue;
                this.mUidStates.removeAt(i);
            }
            if (changed) {
                this.scheduleFastWriteLocked();
            }
        }
        PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        packageManagerInternal.setExternalSourcesPolicy(new PackageManagerInternal.ExternalSourcesPolicy(){

            @Override
            public int getPackageTrustedToInstallApps(String packageName, int uid) {
                int appOpMode = AppOpsService.this.checkOperation(66, uid, packageName);
                switch (appOpMode) {
                    case 0: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                }
                return 2;
            }
        });
        StorageManagerInternal storageManagerInternal = LocalServices.getService(StorageManagerInternal.class);
        storageManagerInternal.addExternalStoragePolicy(new StorageManagerInternal.ExternalStorageMountPolicy(){

            @Override
            public int getMountMode(int uid, String packageName) {
                if (Process.isIsolated(uid)) {
                    return 0;
                }
                if (AppOpsService.this.noteOperation(59, uid, packageName) != 0) {
                    return 0;
                }
                if (AppOpsService.this.noteOperation(60, uid, packageName) != 0) {
                    return 2;
                }
                return 3;
            }

            @Override
            public boolean hasExternalStorage(int uid, String packageName) {
                int mountMode = this.getMountMode(uid, packageName);
                return mountMode == 2 || mountMode == 3;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packageRemoved(int uid, String packageName) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            UidState uidState = this.mUidStates.get(uid);
            if (uidState == null) {
                return;
            }
            boolean changed = false;
            if (uidState.pkgOps != null && uidState.pkgOps.remove(packageName) != null) {
                changed = true;
            }
            if (changed && uidState.pkgOps.isEmpty() && AppOpsService.getPackagesForUid(uid).length <= 0) {
                this.mUidStates.remove(uid);
            }
            if (changed) {
                this.scheduleFastWriteLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uidRemoved(int uid) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            if (this.mUidStates.indexOfKey(uid) >= 0) {
                this.mUidStates.remove(uid);
                this.scheduleFastWriteLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Slog.w(TAG, "Writing app ops before shutdown...");
        boolean doWrite = false;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            if (this.mWriteScheduled) {
                this.mWriteScheduled = false;
                doWrite = true;
            }
        }
        if (doWrite) {
            this.writeState();
        }
    }

    private ArrayList<AppOpsManager.OpEntry> collectOps(Ops pkgOps, int[] ops) {
        ArrayList<AppOpsManager.OpEntry> resOps = null;
        if (ops == null) {
            resOps = new ArrayList<AppOpsManager.OpEntry>();
            for (int j = 0; j < pkgOps.size(); ++j) {
                Op curOp = (Op)pkgOps.valueAt(j);
                resOps.add(new AppOpsManager.OpEntry(curOp.op, curOp.mode, curOp.time, curOp.rejectTime, curOp.duration, curOp.proxyUid, curOp.proxyPackageName));
            }
        } else {
            for (int j = 0; j < ops.length; ++j) {
                Op curOp = (Op)pkgOps.get(ops[j]);
                if (curOp == null) continue;
                if (resOps == null) {
                    resOps = new ArrayList();
                }
                resOps.add(new AppOpsManager.OpEntry(curOp.op, curOp.mode, curOp.time, curOp.rejectTime, curOp.duration, curOp.proxyUid, curOp.proxyPackageName));
            }
        }
        return resOps;
    }

    private ArrayList<AppOpsManager.OpEntry> collectOps(SparseIntArray uidOps, int[] ops) {
        ArrayList<AppOpsManager.OpEntry> resOps = null;
        if (ops == null) {
            resOps = new ArrayList<AppOpsManager.OpEntry>();
            for (int j = 0; j < uidOps.size(); ++j) {
                resOps.add(new AppOpsManager.OpEntry(uidOps.keyAt(j), uidOps.valueAt(j), 0L, 0L, 0, -1, null));
            }
        } else {
            for (int j = 0; j < ops.length; ++j) {
                int index = uidOps.indexOfKey(ops[j]);
                if (index < 0) continue;
                if (resOps == null) {
                    resOps = new ArrayList();
                }
                resOps.add(new AppOpsManager.OpEntry(uidOps.keyAt(index), uidOps.valueAt(index), 0L, 0L, 0, -1, null));
            }
        }
        return resOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AppOpsManager.PackageOps> getPackagesForOps(int[] ops) {
        this.mContext.enforcePermission("android.permission.GET_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
        ArrayList<AppOpsManager.PackageOps> res = null;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            int uidStateCount = this.mUidStates.size();
            for (int i = 0; i < uidStateCount; ++i) {
                UidState uidState = this.mUidStates.valueAt(i);
                if (uidState.pkgOps == null || uidState.pkgOps.isEmpty()) continue;
                ArrayMap<String, Ops> packages = uidState.pkgOps;
                int packageCount = packages.size();
                for (int j = 0; j < packageCount; ++j) {
                    Ops pkgOps = packages.valueAt(j);
                    ArrayList<AppOpsManager.OpEntry> resOps = this.collectOps(pkgOps, ops);
                    if (resOps == null) continue;
                    if (res == null) {
                        res = new ArrayList<AppOpsManager.PackageOps>();
                    }
                    AppOpsManager.PackageOps resPackage = new AppOpsManager.PackageOps(pkgOps.packageName, pkgOps.uidState.uid, resOps);
                    res.add(resPackage);
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AppOpsManager.PackageOps> getOpsForPackage(int uid, String packageName, int[] ops) {
        this.mContext.enforcePermission("android.permission.GET_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
        String resolvedPackageName = AppOpsService.resolvePackageName(uid, packageName);
        if (resolvedPackageName == null) {
            return Collections.emptyList();
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Ops pkgOps = this.getOpsRawLocked(uid, resolvedPackageName, false);
            if (pkgOps == null) {
                return null;
            }
            ArrayList<AppOpsManager.OpEntry> resOps = this.collectOps(pkgOps, ops);
            if (resOps == null) {
                return null;
            }
            ArrayList<AppOpsManager.PackageOps> res = new ArrayList<AppOpsManager.PackageOps>();
            AppOpsManager.PackageOps resPackage = new AppOpsManager.PackageOps(pkgOps.packageName, pkgOps.uidState.uid, resOps);
            res.add(resPackage);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AppOpsManager.PackageOps> getUidOps(int uid, int[] ops) {
        this.mContext.enforcePermission("android.permission.GET_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            UidState uidState = this.getUidStateLocked(uid, false);
            if (uidState == null) {
                return null;
            }
            ArrayList<AppOpsManager.OpEntry> resOps = this.collectOps(uidState.opModes, ops);
            if (resOps == null) {
                return null;
            }
            ArrayList<AppOpsManager.PackageOps> res = new ArrayList<AppOpsManager.PackageOps>();
            AppOpsManager.PackageOps resPackage = new AppOpsManager.PackageOps(null, uidState.uid, resOps);
            res.add(resPackage);
            return res;
        }
    }

    private void pruneOp(Op op, int uid, String packageName) {
        Ops ops;
        if (op.time == 0L && op.rejectTime == 0L && (ops = this.getOpsRawLocked(uid, packageName, false)) != null) {
            ops.remove(op.op);
            if (ops.size() <= 0) {
                UidState uidState = ops.uidState;
                ArrayMap<String, Ops> pkgOps = uidState.pkgOps;
                if (pkgOps != null) {
                    pkgOps.remove(ops.packageName);
                    if (pkgOps.isEmpty()) {
                        uidState.pkgOps = null;
                    }
                    if (uidState.isDefault()) {
                        this.mUidStates.remove(uid);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUidMode(int code, int uid, int mode) {
        if (Binder.getCallingPid() != Process.myPid()) {
            this.mContext.enforcePermission("android.permission.UPDATE_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
        }
        this.verifyIncomingOp(code);
        code = AppOpsManager.opToSwitch(code);
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            int defaultMode = AppOpsManager.opToDefaultMode(code);
            UidState uidState = this.getUidStateLocked(uid, false);
            if (uidState == null) {
                if (mode == defaultMode) {
                    return;
                }
                uidState = new UidState(uid);
                uidState.opModes = new SparseIntArray();
                uidState.opModes.put(code, mode);
                this.mUidStates.put(uid, uidState);
                this.scheduleWriteLocked();
            } else if (uidState.opModes == null) {
                if (mode != defaultMode) {
                    uidState.opModes = new SparseIntArray();
                    uidState.opModes.put(code, mode);
                    this.scheduleWriteLocked();
                }
            } else {
                if (uidState.opModes.get(code) == mode) {
                    return;
                }
                if (mode == defaultMode) {
                    uidState.opModes.delete(code);
                    if (uidState.opModes.size() <= 0) {
                        uidState.opModes = null;
                    }
                } else {
                    uidState.opModes.put(code, mode);
                }
                this.scheduleWriteLocked();
            }
        }
        String[] uidPackageNames = AppOpsService.getPackagesForUid(uid);
        ArrayMap callbackSpecs = null;
        AppOpsService appOpsService2 = this;
        synchronized (appOpsService2) {
            ArraySet<Callback> callbacks = this.mOpModeWatchers.get(code);
            if (callbacks != null) {
                int callbackCount = callbacks.size();
                for (int i = 0; i < callbackCount; ++i) {
                    Callback callback = callbacks.valueAt(i);
                    ArraySet changedPackages = new ArraySet();
                    Collections.addAll(changedPackages, uidPackageNames);
                    callbackSpecs = new ArrayMap();
                    callbackSpecs.put(callback, changedPackages);
                }
            }
            for (String uidPackageName : uidPackageNames) {
                callbacks = this.mPackageModeWatchers.get(uidPackageName);
                if (callbacks == null) continue;
                if (callbackSpecs == null) {
                    callbackSpecs = new ArrayMap();
                }
                int callbackCount = callbacks.size();
                for (int i = 0; i < callbackCount; ++i) {
                    Callback callback = callbacks.valueAt(i);
                    ArraySet<String> changedPackages = (ArraySet<String>)callbackSpecs.get(callback);
                    if (changedPackages == null) {
                        changedPackages = new ArraySet<String>();
                        callbackSpecs.put(callback, changedPackages);
                    }
                    changedPackages.add(uidPackageName);
                }
            }
        }
        if (callbackSpecs == null) {
            return;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            for (int i = 0; i < callbackSpecs.size(); ++i) {
                Callback callback = (Callback)callbackSpecs.keyAt(i);
                ArraySet reportedPackageNames = (ArraySet)callbackSpecs.valueAt(i);
                try {
                    if (reportedPackageNames == null) {
                        callback.mCallback.opChanged(code, uid, null);
                        continue;
                    }
                    int reportedPackageCount = reportedPackageNames.size();
                    for (int j = 0; j < reportedPackageCount; ++j) {
                        String reportedPackageName = (String)reportedPackageNames.valueAt(j);
                        callback.mCallback.opChanged(code, uid, reportedPackageName);
                    }
                    continue;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Error dispatching op op change", e);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMode(int code, int uid, String packageName, int mode) {
        if (Binder.getCallingPid() != Process.myPid()) {
            this.mContext.enforcePermission("android.permission.UPDATE_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
        }
        this.verifyIncomingOp(code);
        ArrayList<Callback> repCbs = null;
        code = AppOpsManager.opToSwitch(code);
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            UidState uidState = this.getUidStateLocked(uid, false);
            Op op = this.getOpLocked(code, uid, packageName, true);
            if (op != null && op.mode != mode) {
                op.mode = mode;
                ArraySet<Callback> cbs = this.mOpModeWatchers.get(code);
                if (cbs != null) {
                    if (repCbs == null) {
                        repCbs = new ArrayList<Callback>();
                    }
                    repCbs.addAll(cbs);
                }
                if ((cbs = this.mPackageModeWatchers.get(packageName)) != null) {
                    if (repCbs == null) {
                        repCbs = new ArrayList();
                    }
                    repCbs.addAll(cbs);
                }
                if (mode == AppOpsManager.opToDefaultMode(op.op)) {
                    this.pruneOp(op, uid, packageName);
                }
                this.scheduleFastWriteLocked();
            }
        }
        if (repCbs != null) {
            long identity = Binder.clearCallingIdentity();
            try {
                for (int i = 0; i < repCbs.size(); ++i) {
                    try {
                        ((Callback)repCbs.get((int)i)).mCallback.opChanged(code, uid, packageName);
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private static HashMap<Callback, ArrayList<ChangeRec>> addCallbacks(HashMap<Callback, ArrayList<ChangeRec>> callbacks, int op, int uid, String packageName, ArraySet<Callback> cbs) {
        if (cbs == null) {
            return callbacks;
        }
        if (callbacks == null) {
            callbacks = new HashMap();
        }
        boolean duplicate = false;
        int N = cbs.size();
        for (int i = 0; i < N; ++i) {
            Callback cb = cbs.valueAt(i);
            ArrayList<ChangeRec> reports = callbacks.get(cb);
            if (reports == null) {
                reports = new ArrayList();
                callbacks.put(cb, reports);
            } else {
                int reportCount = reports.size();
                for (int j = 0; j < reportCount; ++j) {
                    ChangeRec report = reports.get(j);
                    if (report.op != op || !report.pkg.equals(packageName)) continue;
                    duplicate = true;
                    break;
                }
            }
            if (duplicate) continue;
            reports.add(new ChangeRec(op, uid, packageName));
        }
        return callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAllModes(int reqUserId, String reqPackageName) {
        int callingPid = Binder.getCallingPid();
        int callingUid = Binder.getCallingUid();
        this.mContext.enforcePermission("android.permission.UPDATE_APP_OPS_STATS", callingPid, callingUid, null);
        reqUserId = ActivityManager.handleIncomingUser(callingPid, callingUid, reqUserId, true, true, "resetAllModes", null);
        int reqUid = -1;
        if (reqPackageName != null) {
            try {
                reqUid = AppGlobals.getPackageManager().getPackageUid(reqPackageName, 8192, reqUserId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        HashMap<Callback, ArrayList<ChangeRec>> callbacks = null;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            boolean bl;
            boolean bl2 = false;
            for (int i = this.mUidStates.size() - 1; i >= 0; --i) {
                UidState uidState = this.mUidStates.valueAt(i);
                SparseIntArray opModes = uidState.opModes;
                if (opModes != null && (uidState.uid == reqUid || reqUid == -1)) {
                    int uidOpCount = opModes.size();
                    for (int j = uidOpCount - 1; j >= 0; --j) {
                        int code = opModes.keyAt(j);
                        if (!AppOpsManager.opAllowsReset(code)) continue;
                        opModes.removeAt(j);
                        if (opModes.size() <= 0) {
                            uidState.opModes = null;
                        }
                        for (String packageName : AppOpsService.getPackagesForUid(uidState.uid)) {
                            callbacks = AppOpsService.addCallbacks(callbacks, code, uidState.uid, packageName, this.mOpModeWatchers.get(code));
                            callbacks = AppOpsService.addCallbacks(callbacks, code, uidState.uid, packageName, this.mPackageModeWatchers.get(packageName));
                        }
                    }
                }
                if (uidState.pkgOps == null || reqUserId != -1 && reqUserId != UserHandle.getUserId(uidState.uid)) continue;
                ArrayMap<String, Ops> packages = uidState.pkgOps;
                Iterator it = packages.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry ent = it.next();
                    String packageName = (String)ent.getKey();
                    if (reqPackageName != null && !reqPackageName.equals(packageName)) continue;
                    Ops pkgOps = (Ops)ent.getValue();
                    for (int j = pkgOps.size() - 1; j >= 0; --j) {
                        Op curOp = (Op)pkgOps.valueAt(j);
                        if (!AppOpsManager.opAllowsReset(curOp.op) || curOp.mode == AppOpsManager.opToDefaultMode(curOp.op)) continue;
                        curOp.mode = AppOpsManager.opToDefaultMode(curOp.op);
                        bl = true;
                        callbacks = AppOpsService.addCallbacks(callbacks, curOp.op, curOp.uid, packageName, this.mOpModeWatchers.get(curOp.op));
                        callbacks = AppOpsService.addCallbacks(callbacks, curOp.op, curOp.uid, packageName, this.mPackageModeWatchers.get(packageName));
                        if (curOp.time != 0L || curOp.rejectTime != 0L) continue;
                        pkgOps.removeAt(j);
                    }
                    if (pkgOps.size() != 0) continue;
                    it.remove();
                }
                if (!uidState.isDefault()) continue;
                this.mUidStates.remove(uidState.uid);
            }
            if (bl) {
                this.scheduleFastWriteLocked();
            }
        }
        if (callbacks != null) {
            for (Map.Entry entry : callbacks.entrySet()) {
                Callback cb = (Callback)entry.getKey();
                ArrayList reports = (ArrayList)entry.getValue();
                for (int i = 0; i < reports.size(); ++i) {
                    ChangeRec rep = (ChangeRec)reports.get(i);
                    try {
                        cb.mCallback.opChanged(rep.op, rep.uid, rep.pkg);
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startWatchingMode(int op, String packageName, IAppOpsCallback callback) {
        if (callback == null) {
            return;
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            ArraySet<Callback> cbs;
            op = op != -1 ? AppOpsManager.opToSwitch(op) : op;
            Callback cb = this.mModeWatchers.get(callback.asBinder());
            if (cb == null) {
                cb = new Callback(callback);
                this.mModeWatchers.put(callback.asBinder(), cb);
            }
            if (op != -1) {
                cbs = this.mOpModeWatchers.get(op);
                if (cbs == null) {
                    cbs = new ArraySet();
                    this.mOpModeWatchers.put(op, cbs);
                }
                cbs.add(cb);
            }
            if (packageName != null) {
                cbs = this.mPackageModeWatchers.get(packageName);
                if (cbs == null) {
                    cbs = new ArraySet();
                    this.mPackageModeWatchers.put(packageName, cbs);
                }
                cbs.add(cb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopWatchingMode(IAppOpsCallback callback) {
        if (callback == null) {
            return;
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Callback cb = this.mModeWatchers.remove(callback.asBinder());
            if (cb != null) {
                ArraySet<Callback> cbs;
                int i;
                cb.unlinkToDeath();
                for (i = this.mOpModeWatchers.size() - 1; i >= 0; --i) {
                    cbs = this.mOpModeWatchers.valueAt(i);
                    cbs.remove(cb);
                    if (cbs.size() > 0) continue;
                    this.mOpModeWatchers.removeAt(i);
                }
                for (i = this.mPackageModeWatchers.size() - 1; i >= 0; --i) {
                    cbs = this.mPackageModeWatchers.valueAt(i);
                    cbs.remove(cb);
                    if (cbs.size() > 0) continue;
                    this.mPackageModeWatchers.removeAt(i);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder getToken(IBinder clientToken) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            ClientState cs = this.mClients.get(clientToken);
            if (cs == null) {
                cs = new ClientState(clientToken);
                this.mClients.put(clientToken, cs);
            }
            return cs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkOperation(int code, int uid, String packageName) {
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        String resolvedPackageName = AppOpsService.resolvePackageName(uid, packageName);
        if (resolvedPackageName == null) {
            return 1;
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            if (this.isOpRestrictedLocked(uid, code, resolvedPackageName)) {
                return 1;
            }
            code = AppOpsManager.opToSwitch(code);
            UidState uidState = this.getUidStateLocked(uid, false);
            if (uidState != null && uidState.opModes != null && uidState.opModes.indexOfKey(code) >= 0) {
                return uidState.opModes.get(code);
            }
            Op op = this.getOpLocked(code, uid, resolvedPackageName, false);
            if (op == null) {
                return AppOpsManager.opToDefaultMode(code);
            }
            return op.mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkAudioOperation(int code, int usage, int uid, String packageName) {
        boolean suspended;
        try {
            suspended = this.isPackageSuspendedForUser(packageName, uid);
        }
        catch (IllegalArgumentException ex) {
            suspended = false;
        }
        if (suspended) {
            Log.i(TAG, "Audio disabled for suspended package=" + packageName + " for uid=" + uid);
            return 1;
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            int mode = this.checkRestrictionLocked(code, usage, uid, packageName);
            if (mode != 0) {
                return mode;
            }
            return this.checkOperation(code, uid, packageName);
        }
    }

    private boolean isPackageSuspendedForUser(String pkg, int uid) {
        try {
            return AppGlobals.getPackageManager().isPackageSuspendedForUser(pkg, UserHandle.getUserId(uid));
        }
        catch (RemoteException re) {
            throw new SecurityException("Could not talk to package manager service");
        }
    }

    private int checkRestrictionLocked(int code, int usage, int uid, String packageName) {
        Restriction r;
        SparseArray<Restriction> usageRestrictions = this.mAudioRestrictions.get(code);
        if (usageRestrictions != null && (r = usageRestrictions.get(usage)) != null && !r.exceptionPackages.contains(packageName)) {
            return r.mode;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAudioRestriction(int code, int usage, int uid, int mode, String[] exceptionPackages) {
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            SparseArray<Restriction> usageRestrictions = this.mAudioRestrictions.get(code);
            if (usageRestrictions == null) {
                usageRestrictions = new SparseArray();
                this.mAudioRestrictions.put(code, usageRestrictions);
            }
            usageRestrictions.remove(usage);
            if (mode != 0) {
                Restriction r = new Restriction();
                r.mode = mode;
                if (exceptionPackages != null) {
                    int N = exceptionPackages.length;
                    r.exceptionPackages = new ArraySet(N);
                    for (int i = 0; i < N; ++i) {
                        String pkg = exceptionPackages[i];
                        if (pkg == null) continue;
                        r.exceptionPackages.add(pkg.trim());
                    }
                }
                usageRestrictions.put(usage, r);
            }
        }
        this.notifyWatchersOfChange(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkPackage(int uid, String packageName) {
        Preconditions.checkNotNull(packageName);
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            if (this.getOpsRawLocked(uid, packageName, true) != null) {
                return 0;
            }
            return 2;
        }
    }

    @Override
    public int noteProxyOperation(int code, String proxyPackageName, int proxiedUid, String proxiedPackageName) {
        this.verifyIncomingOp(code);
        int proxyUid = Binder.getCallingUid();
        String resolveProxyPackageName = AppOpsService.resolvePackageName(proxyUid, proxyPackageName);
        if (resolveProxyPackageName == null) {
            return 1;
        }
        int proxyMode = this.noteOperationUnchecked(code, proxyUid, resolveProxyPackageName, -1, null);
        if (proxyMode != 0 || Binder.getCallingUid() == proxiedUid) {
            return proxyMode;
        }
        String resolveProxiedPackageName = AppOpsService.resolvePackageName(proxiedUid, proxiedPackageName);
        if (resolveProxiedPackageName == null) {
            return 1;
        }
        return this.noteOperationUnchecked(code, proxiedUid, resolveProxiedPackageName, proxyMode, resolveProxyPackageName);
    }

    @Override
    public int noteOperation(int code, int uid, String packageName) {
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        String resolvedPackageName = AppOpsService.resolvePackageName(uid, packageName);
        if (resolvedPackageName == null) {
            return 1;
        }
        return this.noteOperationUnchecked(code, uid, resolvedPackageName, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int noteOperationUnchecked(int code, int uid, String packageName, int proxyUid, String proxyPackageName) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Ops ops = this.getOpsRawLocked(uid, packageName, true);
            if (ops == null) {
                return 2;
            }
            Op op = this.getOpLocked(ops, code, true);
            if (this.isOpRestrictedLocked(uid, code, packageName)) {
                return 1;
            }
            if (op.duration == -1) {
                Slog.w(TAG, "Noting op not finished: uid " + uid + " pkg " + packageName + " code " + code + " time=" + op.time + " duration=" + op.duration);
            }
            op.duration = 0;
            int switchCode = AppOpsManager.opToSwitch(code);
            UidState uidState = ops.uidState;
            if (uidState.opModes != null && uidState.opModes.indexOfKey(switchCode) >= 0) {
                int uidMode = uidState.opModes.get(switchCode);
                if (uidMode != 0) {
                    op.rejectTime = System.currentTimeMillis();
                    return uidMode;
                }
            } else {
                Op switchOp;
                Op op2 = switchOp = switchCode != code ? this.getOpLocked(ops, switchCode, true) : op;
                if (switchOp.mode != 0) {
                    op.rejectTime = System.currentTimeMillis();
                    return switchOp.mode;
                }
            }
            op.time = System.currentTimeMillis();
            op.rejectTime = 0L;
            op.proxyUid = proxyUid;
            op.proxyPackageName = proxyPackageName;
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startOperation(IBinder token, int code, int uid, String packageName) {
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        String resolvedPackageName = AppOpsService.resolvePackageName(uid, packageName);
        if (resolvedPackageName == null) {
            return 1;
        }
        ClientState client = (ClientState)token;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Op switchOp;
            int uidMode;
            Ops ops = this.getOpsRawLocked(uid, resolvedPackageName, true);
            if (ops == null) {
                return 2;
            }
            Op op = this.getOpLocked(ops, code, true);
            if (this.isOpRestrictedLocked(uid, code, resolvedPackageName)) {
                return 1;
            }
            int switchCode = AppOpsManager.opToSwitch(code);
            UidState uidState = ops.uidState;
            if (uidState.opModes != null && (uidMode = uidState.opModes.get(switchCode)) != 0) {
                op.rejectTime = System.currentTimeMillis();
                return uidMode;
            }
            Op op2 = switchOp = switchCode != code ? this.getOpLocked(ops, switchCode, true) : op;
            if (switchOp.mode != 0) {
                op.rejectTime = System.currentTimeMillis();
                return switchOp.mode;
            }
            if (op.nesting == 0) {
                op.time = System.currentTimeMillis();
                op.rejectTime = 0L;
                op.duration = -1;
            }
            ++op.nesting;
            if (client.mStartedOps != null) {
                client.mStartedOps.add(op);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishOperation(IBinder token, int code, int uid, String packageName) {
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        String resolvedPackageName = AppOpsService.resolvePackageName(uid, packageName);
        if (resolvedPackageName == null) {
            return;
        }
        if (!(token instanceof ClientState)) {
            return;
        }
        ClientState client = (ClientState)token;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Op op = this.getOpLocked(code, uid, resolvedPackageName, true);
            if (op == null) {
                return;
            }
            if (client.mStartedOps != null && !client.mStartedOps.remove(op)) {
                throw new IllegalStateException("Operation not started: uid" + op.uid + " pkg=" + op.packageName + " op=" + op.op);
            }
            this.finishOperationLocked(op);
        }
    }

    @Override
    public int permissionToOpCode(String permission2) {
        if (permission2 == null) {
            return -1;
        }
        return AppOpsManager.permissionToOpCode(permission2);
    }

    void finishOperationLocked(Op op) {
        if (op.nesting <= 1) {
            if (op.nesting == 1) {
                op.duration = (int)(System.currentTimeMillis() - op.time);
                op.time += (long)op.duration;
            } else {
                Slog.w(TAG, "Finishing op nesting under-run: uid " + op.uid + " pkg " + op.packageName + " code " + op.op + " time=" + op.time + " duration=" + op.duration + " nesting=" + op.nesting);
            }
            op.nesting = 0;
        } else {
            --op.nesting;
        }
    }

    private void verifyIncomingUid(int uid) {
        if (uid == Binder.getCallingUid()) {
            return;
        }
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
    }

    private void verifyIncomingOp(int op) {
        if (op >= 0 && op < 70) {
            return;
        }
        throw new IllegalArgumentException("Bad operation #" + op);
    }

    private UidState getUidStateLocked(int uid, boolean edit) {
        UidState uidState = this.mUidStates.get(uid);
        if (uidState == null) {
            if (!edit) {
                return null;
            }
            uidState = new UidState(uid);
            this.mUidStates.put(uid, uidState);
        }
        return uidState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ops getOpsRawLocked(int uid, String packageName, boolean edit) {
        Ops ops;
        UidState uidState = this.getUidStateLocked(uid, edit);
        if (uidState == null) {
            return null;
        }
        if (uidState.pkgOps == null) {
            if (!edit) {
                return null;
            }
            uidState.pkgOps = new ArrayMap();
        }
        if ((ops = uidState.pkgOps.get(packageName)) == null) {
            if (!edit) {
                return null;
            }
            boolean isPrivileged = false;
            if (uid != 0) {
                long ident = Binder.clearCallingIdentity();
                try {
                    int pkgUid = -1;
                    try {
                        ApplicationInfo appInfo = ActivityThread.getPackageManager().getApplicationInfo(packageName, 0x10000000, UserHandle.getUserId(uid));
                        if (appInfo != null) {
                            pkgUid = appInfo.uid;
                            isPrivileged = (appInfo.privateFlags & 8) != 0;
                        } else if ("media".equals(packageName)) {
                            pkgUid = 1013;
                            isPrivileged = false;
                        } else if ("audioserver".equals(packageName)) {
                            pkgUid = 1041;
                            isPrivileged = false;
                        } else if ("cameraserver".equals(packageName)) {
                            pkgUid = 1047;
                            isPrivileged = false;
                        }
                    }
                    catch (RemoteException e) {
                        Slog.w(TAG, "Could not contact PackageManager", e);
                    }
                    if (pkgUid != uid) {
                        RuntimeException ex = new RuntimeException("here");
                        ex.fillInStackTrace();
                        Slog.w(TAG, "Bad call: specified package " + packageName + " under uid " + uid + " but it is really " + pkgUid, ex);
                        Ops ops2 = null;
                        return ops2;
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            ops = new Ops(packageName, uidState, isPrivileged);
            uidState.pkgOps.put(packageName, ops);
        }
        return ops;
    }

    private void scheduleWriteLocked() {
        if (!this.mWriteScheduled) {
            this.mWriteScheduled = true;
            this.mHandler.postDelayed(this.mWriteRunner, 1800000L);
        }
    }

    private void scheduleFastWriteLocked() {
        if (!this.mFastWriteScheduled) {
            this.mWriteScheduled = true;
            this.mFastWriteScheduled = true;
            this.mHandler.removeCallbacks(this.mWriteRunner);
            this.mHandler.postDelayed(this.mWriteRunner, 10000L);
        }
    }

    private Op getOpLocked(int code, int uid, String packageName, boolean edit) {
        Ops ops = this.getOpsRawLocked(uid, packageName, edit);
        if (ops == null) {
            return null;
        }
        return this.getOpLocked(ops, code, edit);
    }

    private Op getOpLocked(Ops ops, int code, boolean edit) {
        Op op = (Op)ops.get(code);
        if (op == null) {
            if (!edit) {
                return null;
            }
            op = new Op(ops.uidState.uid, ops.packageName, code);
            ops.put(code, op);
        }
        if (edit) {
            this.scheduleWriteLocked();
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOpRestrictedLocked(int uid, int code, String packageName) {
        int userHandle = UserHandle.getUserId(uid);
        int restrictionSetCount = this.mOpUserRestrictions.size();
        for (int i = 0; i < restrictionSetCount; ++i) {
            ClientRestrictionState restrictionState = this.mOpUserRestrictions.valueAt(i);
            if (!restrictionState.hasRestriction(code, packageName, userHandle)) continue;
            if (AppOpsManager.opAllowSystemBypassRestriction(code)) {
                AppOpsService appOpsService = this;
                synchronized (appOpsService) {
                    Ops ops = this.getOpsRawLocked(uid, packageName, true);
                    if (ops != null && ops.isPrivileged) {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readState() {
        AtomicFile atomicFile = this.mFile;
        synchronized (atomicFile) {
            AppOpsService appOpsService = this;
            synchronized (appOpsService) {
                FileInputStream stream;
                try {
                    stream = this.mFile.openRead();
                }
                catch (FileNotFoundException e) {
                    Slog.i(TAG, "No existing app ops " + this.mFile.getBaseFile() + "; starting empty");
                    return;
                }
                boolean success = false;
                this.mUidStates.clear();
                try {
                    int type;
                    XmlPullParser parser = Xml.newPullParser();
                    parser.setInput(stream, StandardCharsets.UTF_8.name());
                    while ((type = parser.next()) != 2 && type != 1) {
                    }
                    if (type != 2) {
                        throw new IllegalStateException("no start tag found");
                    }
                    int outerDepth = parser.getDepth();
                    while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                        if (type == 3 || type == 4) continue;
                        String tagName = parser.getName();
                        if (tagName.equals("pkg")) {
                            this.readPackage(parser);
                            continue;
                        }
                        if (tagName.equals("uid")) {
                            this.readUidOps(parser);
                            continue;
                        }
                        Slog.w(TAG, "Unknown element under <app-ops>: " + parser.getName());
                        XmlUtils.skipCurrentTag(parser);
                    }
                    success = true;
                }
                catch (IllegalStateException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                catch (NullPointerException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                catch (NumberFormatException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                catch (XmlPullParserException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                catch (IOException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                catch (IndexOutOfBoundsException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                finally {
                    if (!success) {
                        this.mUidStates.clear();
                    }
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    void readUidOps(XmlPullParser parser) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        int uid = Integer.parseInt(parser.getAttributeValue(null, "n"));
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("op")) {
                int code = Integer.parseInt(parser.getAttributeValue(null, "n"));
                int mode = Integer.parseInt(parser.getAttributeValue(null, "m"));
                UidState uidState = this.getUidStateLocked(uid, true);
                if (uidState.opModes == null) {
                    uidState.opModes = new SparseIntArray();
                }
                uidState.opModes.put(code, mode);
                continue;
            }
            Slog.w(TAG, "Unknown element under <uid-ops>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
    }

    void readPackage(XmlPullParser parser) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        String pkgName = parser.getAttributeValue(null, "n");
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("uid")) {
                this.readUid(parser, pkgName);
                continue;
            }
            Slog.w(TAG, "Unknown element under <pkg>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
    }

    void readUid(XmlPullParser parser, String pkgName) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        boolean isPrivileged;
        int uid;
        block16: {
            uid = Integer.parseInt(parser.getAttributeValue(null, "n"));
            String isPrivilegedString = parser.getAttributeValue(null, "p");
            isPrivileged = false;
            if (isPrivilegedString == null) {
                try {
                    IPackageManager packageManager = ActivityThread.getPackageManager();
                    if (packageManager != null) {
                        ApplicationInfo appInfo = ActivityThread.getPackageManager().getApplicationInfo(pkgName, 0, UserHandle.getUserId(uid));
                        if (appInfo != null) {
                            isPrivileged = (appInfo.privateFlags & 8) != 0;
                        }
                        break block16;
                    }
                    return;
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Could not contact PackageManager", e);
                }
            } else {
                isPrivileged = Boolean.parseBoolean(isPrivilegedString);
            }
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("op")) {
                Ops ops;
                String proxyPackageName;
                String proxyUid;
                String dur;
                String time;
                Op op = new Op(uid, pkgName, Integer.parseInt(parser.getAttributeValue(null, "n")));
                String mode = parser.getAttributeValue(null, "m");
                if (mode != null) {
                    op.mode = Integer.parseInt(mode);
                }
                if ((time = parser.getAttributeValue(null, "t")) != null) {
                    op.time = Long.parseLong(time);
                }
                if ((time = parser.getAttributeValue(null, "r")) != null) {
                    op.rejectTime = Long.parseLong(time);
                }
                if ((dur = parser.getAttributeValue(null, "d")) != null) {
                    op.duration = Integer.parseInt(dur);
                }
                if ((proxyUid = parser.getAttributeValue(null, "pu")) != null) {
                    op.proxyUid = Integer.parseInt(proxyUid);
                }
                if ((proxyPackageName = parser.getAttributeValue(null, "pp")) != null) {
                    op.proxyPackageName = proxyPackageName;
                }
                UidState uidState = this.getUidStateLocked(uid, true);
                if (uidState.pkgOps == null) {
                    uidState.pkgOps = new ArrayMap();
                }
                if ((ops = uidState.pkgOps.get(pkgName)) == null) {
                    ops = new Ops(pkgName, uidState, isPrivileged);
                    uidState.pkgOps.put(pkgName, ops);
                }
                ops.put(op.op, op);
                continue;
            }
            Slog.w(TAG, "Unknown element under <pkg>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeState() {
        AtomicFile atomicFile = this.mFile;
        synchronized (atomicFile) {
            FileOutputStream stream;
            List<AppOpsManager.PackageOps> allOps = this.getPackagesForOps(null);
            try {
                stream = this.mFile.startWrite();
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to write state: " + e);
                return;
            }
            try {
                int j;
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(stream, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.startTag(null, "app-ops");
                int uidStateCount = this.mUidStates.size();
                for (int i = 0; i < uidStateCount; ++i) {
                    UidState uidState = this.mUidStates.valueAt(i);
                    if (uidState.opModes == null || uidState.opModes.size() <= 0) continue;
                    out.startTag(null, "uid");
                    out.attribute(null, "n", Integer.toString(uidState.uid));
                    SparseIntArray uidOpModes = uidState.opModes;
                    int opCount = uidOpModes.size();
                    for (j = 0; j < opCount; ++j) {
                        int op = uidOpModes.keyAt(j);
                        int mode = uidOpModes.valueAt(j);
                        out.startTag(null, "op");
                        out.attribute(null, "n", Integer.toString(op));
                        out.attribute(null, "m", Integer.toString(mode));
                        out.endTag(null, "op");
                    }
                    out.endTag(null, "uid");
                }
                if (allOps != null) {
                    String lastPkg = null;
                    for (int i = 0; i < allOps.size(); ++i) {
                        AppOpsManager.PackageOps pkg = allOps.get(i);
                        if (!pkg.getPackageName().equals(lastPkg)) {
                            if (lastPkg != null) {
                                out.endTag(null, "pkg");
                            }
                            lastPkg = pkg.getPackageName();
                            out.startTag(null, "pkg");
                            out.attribute(null, "n", lastPkg);
                        }
                        out.startTag(null, "uid");
                        out.attribute(null, "n", Integer.toString(pkg.getUid()));
                        AppOpsService opCount = this;
                        synchronized (opCount) {
                            Ops ops = this.getOpsRawLocked(pkg.getUid(), pkg.getPackageName(), false);
                            if (ops != null) {
                                out.attribute(null, "p", Boolean.toString(ops.isPrivileged));
                            } else {
                                out.attribute(null, "p", Boolean.toString(false));
                            }
                        }
                        List<AppOpsManager.OpEntry> ops = pkg.getOps();
                        for (j = 0; j < ops.size(); ++j) {
                            String proxyPackageName;
                            int proxyUid;
                            int dur;
                            long time;
                            AppOpsManager.OpEntry op = ops.get(j);
                            out.startTag(null, "op");
                            out.attribute(null, "n", Integer.toString(op.getOp()));
                            if (op.getMode() != AppOpsManager.opToDefaultMode(op.getOp())) {
                                out.attribute(null, "m", Integer.toString(op.getMode()));
                            }
                            if ((time = op.getTime()) != 0L) {
                                out.attribute(null, "t", Long.toString(time));
                            }
                            if ((time = op.getRejectTime()) != 0L) {
                                out.attribute(null, "r", Long.toString(time));
                            }
                            if ((dur = op.getDuration()) != 0) {
                                out.attribute(null, "d", Integer.toString(dur));
                            }
                            if ((proxyUid = op.getProxyUid()) != -1) {
                                out.attribute(null, "pu", Integer.toString(proxyUid));
                            }
                            if ((proxyPackageName = op.getProxyPackageName()) != null) {
                                out.attribute(null, "pp", proxyPackageName);
                            }
                            out.endTag(null, "op");
                        }
                        out.endTag(null, "uid");
                    }
                    if (lastPkg != null) {
                        out.endTag(null, "pkg");
                    }
                }
                out.endTag(null, "app-ops");
                out.endDocument();
                this.mFile.finishWrite(stream);
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to write state, restoring backup.", e);
                this.mFile.failWrite(stream);
            }
        }
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        new Shell(this, this).exec(this, in, out, err, args, callback, resultReceiver);
    }

    static void dumpCommandHelp(PrintWriter pw) {
        pw.println("AppOps service (appops) commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("  set [--user <USER_ID>] <PACKAGE | UID> <OP> <MODE>");
        pw.println("    Set the mode for a particular application and operation.");
        pw.println("  get [--user <USER_ID>] <PACKAGE | UID> [<OP>]");
        pw.println("    Return the mode for a particular application and optional operation.");
        pw.println("  query-op [--user <USER_ID>] <OP> [<MODE>]");
        pw.println("    Print all packages that currently have the given op in the given mode.");
        pw.println("  reset [--user <USER_ID>] [<PACKAGE>]");
        pw.println("    Reset the given application or all applications to default modes.");
        pw.println("  write-settings");
        pw.println("    Immediately write pending changes to storage.");
        pw.println("  read-settings");
        pw.println("    Read the last written settings, replacing current state in RAM.");
        pw.println("  options:");
        pw.println("    <PACKAGE> an Android package name.");
        pw.println("    <OP>      an AppOps operation.");
        pw.println("    <MODE>    one of allow, ignore, deny, or default");
        pw.println("    <USER_ID> the user id under which the package is installed. If --user is not");
        pw.println("              specified, the current user is assumed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int onShellCommand(Shell shell, String cmd) {
        if (cmd == null) {
            return shell.handleDefaultCommands(cmd);
        }
        PrintWriter pw = shell.getOutPrintWriter();
        PrintWriter err = shell.getErrPrintWriter();
        try {
            switch (cmd) {
                case "set": {
                    int res = shell.parseUserPackageOp(true, err);
                    if (res < 0) {
                        return res;
                    }
                    String modeStr = shell.getNextArg();
                    if (modeStr == null) {
                        err.println("Error: Mode not specified.");
                        return -1;
                    }
                    int mode = shell.strModeToMode(modeStr, err);
                    if (mode < 0) {
                        return -1;
                    }
                    if (shell.packageName != null) {
                        shell.mInterface.setMode(shell.op, shell.packageUid, shell.packageName, mode);
                    } else {
                        shell.mInterface.setUidMode(shell.op, shell.nonpackageUid, mode);
                    }
                    return 0;
                }
                case "get": {
                    List<AppOpsManager.PackageOps> ops;
                    int res = shell.parseUserPackageOp(false, err);
                    if (res < 0) {
                        return res;
                    }
                    if (shell.packageName != null) {
                        int[] nArray;
                        IAppOpsService iAppOpsService = shell.mInterface;
                        int n = shell.packageUid;
                        String string2 = shell.packageName;
                        if (shell.op != -1) {
                            int[] nArray2 = new int[1];
                            nArray = nArray2;
                            nArray2[0] = shell.op;
                        } else {
                            nArray = null;
                        }
                        ops = iAppOpsService.getOpsForPackage(n, string2, nArray);
                    } else {
                        int[] nArray;
                        IAppOpsService iAppOpsService = shell.mInterface;
                        int n = shell.nonpackageUid;
                        if (shell.op != -1) {
                            int[] nArray3 = new int[1];
                            nArray = nArray3;
                            nArray3[0] = shell.op;
                        } else {
                            nArray = null;
                        }
                        ops = iAppOpsService.getUidOps(n, nArray);
                    }
                    if (ops == null || ops.size() <= 0) {
                        pw.println("No operations.");
                        return 0;
                    }
                    long now = System.currentTimeMillis();
                    for (int i = 0; i < ops.size(); ++i) {
                        List<AppOpsManager.OpEntry> entries = ops.get(i).getOps();
                        for (int j = 0; j < entries.size(); ++j) {
                            AppOpsManager.OpEntry ent = entries.get(j);
                            pw.print(AppOpsManager.opToName(ent.getOp()));
                            pw.print(": ");
                            switch (ent.getMode()) {
                                case 0: {
                                    pw.print("allow");
                                    break;
                                }
                                case 1: {
                                    pw.print("ignore");
                                    break;
                                }
                                case 2: {
                                    pw.print("deny");
                                    break;
                                }
                                case 3: {
                                    pw.print("default");
                                    break;
                                }
                                default: {
                                    pw.print("mode=");
                                    pw.print(ent.getMode());
                                }
                            }
                            if (ent.getTime() != 0L) {
                                pw.print("; time=");
                                TimeUtils.formatDuration(now - ent.getTime(), pw);
                                pw.print(" ago");
                            }
                            if (ent.getRejectTime() != 0L) {
                                pw.print("; rejectTime=");
                                TimeUtils.formatDuration(now - ent.getRejectTime(), pw);
                                pw.print(" ago");
                            }
                            if (ent.getDuration() == -1) {
                                pw.print(" (running)");
                            } else if (ent.getDuration() != 0) {
                                pw.print("; duration=");
                                TimeUtils.formatDuration((long)ent.getDuration(), pw);
                            }
                            pw.println();
                        }
                    }
                    return 0;
                }
                case "query-op": {
                    int res = shell.parseUserOpMode(1, err);
                    if (res < 0) {
                        return res;
                    }
                    List<AppOpsManager.PackageOps> ops = shell.mInterface.getPackagesForOps(new int[]{shell.op});
                    if (ops == null || ops.size() <= 0) {
                        pw.println("No operations.");
                        return 0;
                    }
                    for (int i = 0; i < ops.size(); ++i) {
                        AppOpsManager.PackageOps pkg = ops.get(i);
                        boolean hasMatch = false;
                        List<AppOpsManager.OpEntry> entries = ops.get(i).getOps();
                        for (int j = 0; j < entries.size(); ++j) {
                            AppOpsManager.OpEntry ent = entries.get(j);
                            if (ent.getOp() != shell.op || ent.getMode() != shell.mode) continue;
                            hasMatch = true;
                            break;
                        }
                        if (!hasMatch) continue;
                        pw.println(pkg.getPackageName());
                    }
                    return 0;
                }
                case "reset": {
                    String argument;
                    String packageName = null;
                    int userId = -2;
                    while ((argument = shell.getNextArg()) != null) {
                        if ("--user".equals(argument)) {
                            String userStr = shell.getNextArgRequired();
                            userId = UserHandle.parseUserArg(userStr);
                            continue;
                        }
                        if (packageName == null) {
                            packageName = argument;
                            continue;
                        }
                        err.println("Error: Unsupported argument: " + argument);
                        return -1;
                    }
                    if (userId == -2) {
                        userId = ActivityManager.getCurrentUser();
                    }
                    shell.mInterface.resetAllModes(userId, packageName);
                    pw.print("Reset all modes for: ");
                    if (userId == -1) {
                        pw.print("all users");
                    } else {
                        pw.print("user ");
                        pw.print(userId);
                    }
                    pw.print(", ");
                    if (packageName == null) {
                        pw.println("all packages");
                    } else {
                        pw.print("package ");
                        pw.println(packageName);
                    }
                    return 0;
                }
                case "write-settings": {
                    shell.mInternal.mContext.enforcePermission("android.permission.UPDATE_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
                    long token = Binder.clearCallingIdentity();
                    try {
                        AppOpsService appOpsService = shell.mInternal;
                        synchronized (appOpsService) {
                            shell.mInternal.mHandler.removeCallbacks(shell.mInternal.mWriteRunner);
                        }
                        shell.mInternal.writeState();
                        pw.println("Current settings written.");
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                    return 0;
                }
                case "read-settings": {
                    shell.mInternal.mContext.enforcePermission("android.permission.UPDATE_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
                    long token = Binder.clearCallingIdentity();
                    try {
                        shell.mInternal.readState();
                        pw.println("Last settings read.");
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                    return 0;
                }
            }
            return shell.handleDefaultCommands(cmd);
        }
        catch (RemoteException e) {
            pw.println("Remote exception: " + e);
            return -1;
        }
    }

    private void dumpHelp(PrintWriter pw) {
        pw.println("AppOps service (appops) dump options:");
        pw.println("  none");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mContext, TAG, pw)) {
            return;
        }
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if ("-h".equals(arg)) {
                    this.dumpHelp(pw);
                    return;
                }
                if ("-a".equals(arg)) continue;
                if (arg.length() > 0 && arg.charAt(0) == '-') {
                    pw.println("Unknown option: " + arg);
                    return;
                }
                pw.println("Unknown command: " + arg);
                return;
            }
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            int j;
            ArraySet<Callback> callbacks;
            int i;
            pw.println("Current AppOps Service state:");
            long now = System.currentTimeMillis();
            boolean needSep = false;
            if (this.mOpModeWatchers.size() > 0) {
                needSep = true;
                pw.println("  Op mode watchers:");
                for (i = 0; i < this.mOpModeWatchers.size(); ++i) {
                    pw.print("    Op ");
                    pw.print(AppOpsManager.opToName(this.mOpModeWatchers.keyAt(i)));
                    pw.println(":");
                    callbacks = this.mOpModeWatchers.valueAt(i);
                    for (j = 0; j < callbacks.size(); ++j) {
                        pw.print("      #");
                        pw.print(j);
                        pw.print(": ");
                        pw.println(callbacks.valueAt(j));
                    }
                }
            }
            if (this.mPackageModeWatchers.size() > 0) {
                needSep = true;
                pw.println("  Package mode watchers:");
                for (i = 0; i < this.mPackageModeWatchers.size(); ++i) {
                    pw.print("    Pkg ");
                    pw.print(this.mPackageModeWatchers.keyAt(i));
                    pw.println(":");
                    callbacks = this.mPackageModeWatchers.valueAt(i);
                    for (j = 0; j < callbacks.size(); ++j) {
                        pw.print("      #");
                        pw.print(j);
                        pw.print(": ");
                        pw.println(callbacks.valueAt(j));
                    }
                }
            }
            if (this.mModeWatchers.size() > 0) {
                needSep = true;
                pw.println("  All mode watchers:");
                for (i = 0; i < this.mModeWatchers.size(); ++i) {
                    pw.print("    ");
                    pw.print(this.mModeWatchers.keyAt(i));
                    pw.print(" -> ");
                    pw.println(this.mModeWatchers.valueAt(i));
                }
            }
            if (this.mClients.size() > 0) {
                needSep = true;
                pw.println("  Clients:");
                for (i = 0; i < this.mClients.size(); ++i) {
                    pw.print("    ");
                    pw.print(this.mClients.keyAt(i));
                    pw.println(":");
                    ClientState cs = this.mClients.valueAt(i);
                    pw.print("      ");
                    pw.println(cs);
                    if (cs.mStartedOps == null || cs.mStartedOps.size() <= 0) continue;
                    pw.println("      Started ops:");
                    for (j = 0; j < cs.mStartedOps.size(); ++j) {
                        Op op = cs.mStartedOps.get(j);
                        pw.print("        ");
                        pw.print("uid=");
                        pw.print(op.uid);
                        pw.print(" pkg=");
                        pw.print(op.packageName);
                        pw.print(" op=");
                        pw.println(AppOpsManager.opToName(op.op));
                    }
                }
            }
            if (this.mAudioRestrictions.size() > 0) {
                boolean printedHeader = false;
                for (int o = 0; o < this.mAudioRestrictions.size(); ++o) {
                    String op = AppOpsManager.opToName(this.mAudioRestrictions.keyAt(o));
                    SparseArray<Restriction> restrictions = this.mAudioRestrictions.valueAt(o);
                    for (int i2 = 0; i2 < restrictions.size(); ++i2) {
                        if (!printedHeader) {
                            pw.println("  Audio Restrictions:");
                            printedHeader = true;
                            needSep = true;
                        }
                        int usage = restrictions.keyAt(i2);
                        pw.print("    ");
                        pw.print(op);
                        pw.print(" usage=");
                        pw.print(AudioAttributes.usageToString(usage));
                        Restriction r = restrictions.valueAt(i2);
                        pw.print(": mode=");
                        pw.println(r.mode);
                        if (r.exceptionPackages.isEmpty()) continue;
                        pw.println("      Exceptions:");
                        for (int j2 = 0; j2 < r.exceptionPackages.size(); ++j2) {
                            pw.print("        ");
                            pw.println(r.exceptionPackages.valueAt(j2));
                        }
                    }
                }
            }
            if (needSep) {
                pw.println();
            }
            for (i = 0; i < this.mUidStates.size(); ++i) {
                ArrayMap<String, Ops> pkgOps;
                UidState uidState = this.mUidStates.valueAt(i);
                pw.print("  Uid ");
                UserHandle.formatUid(pw, uidState.uid);
                pw.println(":");
                needSep = true;
                SparseIntArray opModes = uidState.opModes;
                if (opModes != null) {
                    int opModeCount = opModes.size();
                    for (int j3 = 0; j3 < opModeCount; ++j3) {
                        int code = opModes.keyAt(j3);
                        int mode = opModes.valueAt(j3);
                        pw.print("      ");
                        pw.print(AppOpsManager.opToName(code));
                        pw.print(": mode=");
                        pw.println(mode);
                    }
                }
                if ((pkgOps = uidState.pkgOps) == null) continue;
                for (Ops ops : pkgOps.values()) {
                    pw.print("    Package ");
                    pw.print(ops.packageName);
                    pw.println(":");
                    for (int j4 = 0; j4 < ops.size(); ++j4) {
                        Op op = (Op)ops.valueAt(j4);
                        pw.print("      ");
                        pw.print(AppOpsManager.opToName(op.op));
                        pw.print(": mode=");
                        pw.print(op.mode);
                        if (op.time != 0L) {
                            pw.print("; time=");
                            TimeUtils.formatDuration(now - op.time, pw);
                            pw.print(" ago");
                        }
                        if (op.rejectTime != 0L) {
                            pw.print("; rejectTime=");
                            TimeUtils.formatDuration(now - op.rejectTime, pw);
                            pw.print(" ago");
                        }
                        if (op.duration == -1) {
                            pw.print(" (running)");
                        } else if (op.duration != 0) {
                            pw.print("; duration=");
                            TimeUtils.formatDuration((long)op.duration, pw);
                        }
                        pw.println();
                    }
                }
            }
            if (needSep) {
                pw.println();
            }
            int userRestrictionCount = this.mOpUserRestrictions.size();
            for (int i3 = 0; i3 < userRestrictionCount; ++i3) {
                int excludedPackageCount;
                int restrictionCount;
                IBinder token = this.mOpUserRestrictions.keyAt(i3);
                ClientRestrictionState restrictionState = this.mOpUserRestrictions.valueAt(i3);
                pw.println("  User restrictions for token " + token + ":");
                int n = restrictionCount = restrictionState.perUserRestrictions != null ? restrictionState.perUserRestrictions.size() : 0;
                if (restrictionCount > 0) {
                    pw.println("      Restricted ops:");
                    for (int j5 = 0; j5 < restrictionCount; ++j5) {
                        int userId = restrictionState.perUserRestrictions.keyAt(j5);
                        boolean[] restrictedOps = restrictionState.perUserRestrictions.valueAt(j5);
                        if (restrictedOps == null) continue;
                        StringBuilder restrictedOpsValue = new StringBuilder();
                        restrictedOpsValue.append("[");
                        int restrictedOpCount = restrictedOps.length;
                        for (int k = 0; k < restrictedOpCount; ++k) {
                            if (!restrictedOps[k]) continue;
                            if (restrictedOpsValue.length() > 1) {
                                restrictedOpsValue.append(", ");
                            }
                            restrictedOpsValue.append(AppOpsManager.opToName(k));
                        }
                        restrictedOpsValue.append("]");
                        pw.print("        ");
                        pw.print("user: ");
                        pw.print(userId);
                        pw.print(" restricted ops: ");
                        pw.println(restrictedOpsValue);
                    }
                }
                int n2 = excludedPackageCount = restrictionState.perUserExcludedPackages != null ? restrictionState.perUserExcludedPackages.size() : 0;
                if (excludedPackageCount <= 0) continue;
                pw.println("      Excluded packages:");
                for (int j6 = 0; j6 < excludedPackageCount; ++j6) {
                    int userId = restrictionState.perUserExcludedPackages.keyAt(j6);
                    Object[] packageNames = restrictionState.perUserExcludedPackages.valueAt(j6);
                    pw.print("        ");
                    pw.print("user: ");
                    pw.print(userId);
                    pw.print(" packages: ");
                    pw.println(Arrays.toString(packageNames));
                }
            }
        }
    }

    @Override
    public void setUserRestrictions(Bundle restrictions, IBinder token, int userHandle) {
        this.checkSystemUid("setUserRestrictions");
        Preconditions.checkNotNull(restrictions);
        Preconditions.checkNotNull(token);
        for (int i = 0; i < 70; ++i) {
            String restriction = AppOpsManager.opToRestriction(i);
            if (restriction == null) continue;
            this.setUserRestrictionNoCheck(i, restrictions.getBoolean(restriction, false), token, userHandle, null);
        }
    }

    @Override
    public void setUserRestriction(int code, boolean restricted, IBinder token, int userHandle, String[] exceptionPackages) {
        if (Binder.getCallingPid() != Process.myPid()) {
            this.mContext.enforcePermission("android.permission.MANAGE_APP_OPS_RESTRICTIONS", Binder.getCallingPid(), Binder.getCallingUid(), null);
        }
        if (userHandle != UserHandle.getCallingUserId() && this.mContext.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0 && this.mContext.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS") != 0) {
            throw new SecurityException("Need INTERACT_ACROSS_USERS_FULL or INTERACT_ACROSS_USERS to interact cross user ");
        }
        this.verifyIncomingOp(code);
        Preconditions.checkNotNull(token);
        this.setUserRestrictionNoCheck(code, restricted, token, userHandle, exceptionPackages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserRestrictionNoCheck(int code, boolean restricted, IBinder token, int userHandle, String[] exceptionPackages) {
        boolean notifyChange = false;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            ClientRestrictionState restrictionState = this.mOpUserRestrictions.get(token);
            if (restrictionState == null) {
                try {
                    restrictionState = new ClientRestrictionState(token);
                }
                catch (RemoteException e) {
                    return;
                }
                this.mOpUserRestrictions.put(token, restrictionState);
            }
            if (restrictionState.setRestriction(code, restricted, exceptionPackages, userHandle)) {
                notifyChange = true;
            }
            if (restrictionState.isDefault()) {
                this.mOpUserRestrictions.remove(token);
                restrictionState.destroy();
            }
        }
        if (notifyChange) {
            this.notifyWatchersOfChange(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWatchersOfChange(int code) {
        ArraySet<Callback> clonedCallbacks;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            ArraySet<Callback> callbacks = this.mOpModeWatchers.get(code);
            if (callbacks == null) {
                return;
            }
            clonedCallbacks = new ArraySet<Callback>(callbacks);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            int callbackCount = clonedCallbacks.size();
            for (int i = 0; i < callbackCount; ++i) {
                Callback callback = clonedCallbacks.valueAt(i);
                try {
                    callback.mCallback.opChanged(code, -1, null);
                    continue;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Error dispatching op op change", e);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(int userHandle) throws RemoteException {
        this.checkSystemUid("removeUser");
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            int tokenCount = this.mOpUserRestrictions.size();
            for (int i = tokenCount - 1; i >= 0; --i) {
                ClientRestrictionState opRestrictions = this.mOpUserRestrictions.valueAt(i);
                opRestrictions.removeUser(userHandle);
            }
            this.removeUidsForUserLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOperationActive(int code, int uid, String packageName) {
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        String resolvedPackageName = AppOpsService.resolvePackageName(uid, packageName);
        if (resolvedPackageName == null) {
            return false;
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            for (int i = this.mClients.size() - 1; i >= 0; --i) {
                ClientState client = this.mClients.valueAt(i);
                if (client.mStartedOps == null) continue;
                for (int j = client.mStartedOps.size() - 1; j >= 0; --j) {
                    Op op = client.mStartedOps.get(j);
                    if (op.op != code || op.uid != uid) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void removeUidsForUserLocked(int userHandle) {
        for (int i = this.mUidStates.size() - 1; i >= 0; --i) {
            int uid = this.mUidStates.keyAt(i);
            if (UserHandle.getUserId(uid) != userHandle) continue;
            this.mUidStates.removeAt(i);
        }
    }

    private void checkSystemUid(String function) {
        int uid = Binder.getCallingUid();
        if (uid != 1000) {
            throw new SecurityException(function + " must by called by the system");
        }
    }

    private static String resolvePackageName(int uid, String packageName) {
        if (uid == 0) {
            return "root";
        }
        if (uid == 2000) {
            return "com.android.shell";
        }
        if (uid == 1000 && packageName == null) {
            return "android";
        }
        return packageName;
    }

    private static String[] getPackagesForUid(int uid) {
        String[] packageNames = null;
        try {
            packageNames = AppGlobals.getPackageManager().getPackagesForUid(uid);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (packageNames == null) {
            return EmptyArray.STRING;
        }
        return packageNames;
    }

    private final class ClientRestrictionState
    implements IBinder.DeathRecipient {
        private final IBinder token;
        SparseArray<boolean[]> perUserRestrictions;
        SparseArray<String[]> perUserExcludedPackages;

        public ClientRestrictionState(IBinder token) throws RemoteException {
            token.linkToDeath(this, 0);
            this.token = token;
        }

        public boolean setRestriction(int code, boolean restricted, String[] excludedPackages, int userId) {
            int[] users;
            boolean changed = false;
            if (this.perUserRestrictions == null && restricted) {
                this.perUserRestrictions = new SparseArray();
            }
            if (userId == -1) {
                List<UserInfo> liveUsers = UserManager.get(AppOpsService.this.mContext).getUsers(false);
                users = new int[liveUsers.size()];
                for (int i = 0; i < liveUsers.size(); ++i) {
                    users[i] = liveUsers.get((int)i).id;
                }
            } else {
                users = new int[]{userId};
            }
            if (this.perUserRestrictions != null) {
                for (int thisUserId : users) {
                    boolean[] userRestrictions = this.perUserRestrictions.get(thisUserId);
                    if (userRestrictions == null && restricted) {
                        userRestrictions = new boolean[70];
                        this.perUserRestrictions.put(thisUserId, userRestrictions);
                    }
                    if (userRestrictions != null && userRestrictions[code] != restricted) {
                        userRestrictions[code] = restricted;
                        if (!restricted && this.isDefault(userRestrictions)) {
                            this.perUserRestrictions.remove(thisUserId);
                            userRestrictions = null;
                        }
                        changed = true;
                    }
                    if (userRestrictions == null) continue;
                    boolean noExcludedPackages = ArrayUtils.isEmpty(excludedPackages);
                    if (this.perUserExcludedPackages == null && !noExcludedPackages) {
                        this.perUserExcludedPackages = new SparseArray();
                    }
                    if (this.perUserExcludedPackages == null || Arrays.equals(excludedPackages, this.perUserExcludedPackages.get(thisUserId))) continue;
                    if (noExcludedPackages) {
                        this.perUserExcludedPackages.remove(thisUserId);
                        if (this.perUserExcludedPackages.size() <= 0) {
                            this.perUserExcludedPackages = null;
                        }
                    } else {
                        this.perUserExcludedPackages.put(thisUserId, excludedPackages);
                    }
                    changed = true;
                }
            }
            return changed;
        }

        public boolean hasRestriction(int restriction, String packageName, int userId) {
            if (this.perUserRestrictions == null) {
                return false;
            }
            boolean[] restrictions = this.perUserRestrictions.get(userId);
            if (restrictions == null) {
                return false;
            }
            if (!restrictions[restriction]) {
                return false;
            }
            if (this.perUserExcludedPackages == null) {
                return true;
            }
            String[] perUserExclusions = this.perUserExcludedPackages.get(userId);
            if (perUserExclusions == null) {
                return true;
            }
            return !ArrayUtils.contains(perUserExclusions, packageName);
        }

        public void removeUser(int userId) {
            if (this.perUserExcludedPackages != null) {
                this.perUserExcludedPackages.remove(userId);
                if (this.perUserExcludedPackages.size() <= 0) {
                    this.perUserExcludedPackages = null;
                }
            }
            if (this.perUserRestrictions != null) {
                this.perUserRestrictions.remove(userId);
                if (this.perUserRestrictions.size() <= 0) {
                    this.perUserRestrictions = null;
                }
            }
        }

        public boolean isDefault() {
            return this.perUserRestrictions == null || this.perUserRestrictions.size() <= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            AppOpsService appOpsService = AppOpsService.this;
            synchronized (appOpsService) {
                AppOpsService.this.mOpUserRestrictions.remove(this.token);
                if (this.perUserRestrictions == null) {
                    return;
                }
                int userCount = this.perUserRestrictions.size();
                for (int i = 0; i < userCount; ++i) {
                    boolean[] restrictions = this.perUserRestrictions.valueAt(i);
                    int restrictionCount = restrictions.length;
                    for (int j = 0; j < restrictionCount; ++j) {
                        if (!restrictions[j]) continue;
                        int changedCode = j;
                        AppOpsService.this.mHandler.post(() -> AppOpsService.this.notifyWatchersOfChange(changedCode));
                    }
                }
                this.destroy();
            }
        }

        public void destroy() {
            this.token.unlinkToDeath(this, 0);
        }

        private boolean isDefault(boolean[] array2) {
            if (ArrayUtils.isEmpty(array2)) {
                return true;
            }
            for (boolean value : array2) {
                if (!value) continue;
                return false;
            }
            return true;
        }
    }

    private static final class Restriction {
        private static final ArraySet<String> NO_EXCEPTIONS = new ArraySet();
        int mode;
        ArraySet<String> exceptionPackages = NO_EXCEPTIONS;

        private Restriction() {
        }
    }

    static class Shell
    extends ShellCommand {
        final IAppOpsService mInterface;
        final AppOpsService mInternal;
        int userId = 0;
        String packageName;
        String opStr;
        String modeStr;
        int op;
        int mode;
        int packageUid;
        int nonpackageUid;

        Shell(IAppOpsService iface, AppOpsService internal) {
            this.mInterface = iface;
            this.mInternal = internal;
        }

        @Override
        public int onCommand(String cmd) {
            return AppOpsService.onShellCommand(this, cmd);
        }

        @Override
        public void onHelp() {
            PrintWriter pw = this.getOutPrintWriter();
            AppOpsService.dumpCommandHelp(pw);
        }

        private int strOpToOp(String op, PrintWriter err) {
            try {
                return AppOpsManager.strOpToOp(op);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return Integer.parseInt(op);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return AppOpsManager.strDebugOpToOp(op);
                    }
                    catch (IllegalArgumentException e) {
                        err.println("Error: " + e.getMessage());
                        return -1;
                    }
                }
            }
        }

        int strModeToMode(String modeStr, PrintWriter err) {
            switch (modeStr) {
                case "allow": {
                    return 0;
                }
                case "deny": {
                    return 2;
                }
                case "ignore": {
                    return 1;
                }
                case "default": {
                    return 3;
                }
            }
            try {
                return Integer.parseInt(modeStr);
            }
            catch (NumberFormatException numberFormatException) {
                err.println("Error: Mode " + modeStr + " is not valid");
                return -1;
            }
        }

        int parseUserOpMode(int defMode, PrintWriter err) throws RemoteException {
            String argument;
            this.userId = -2;
            this.opStr = null;
            this.modeStr = null;
            while ((argument = this.getNextArg()) != null) {
                if ("--user".equals(argument)) {
                    this.userId = UserHandle.parseUserArg(this.getNextArgRequired());
                    continue;
                }
                if (this.opStr == null) {
                    this.opStr = argument;
                    continue;
                }
                if (this.modeStr != null) continue;
                this.modeStr = argument;
                break;
            }
            if (this.opStr == null) {
                err.println("Error: Operation not specified.");
                return -1;
            }
            this.op = this.strOpToOp(this.opStr, err);
            if (this.op < 0) {
                return -1;
            }
            if (this.modeStr != null) {
                this.mode = this.strModeToMode(this.modeStr, err);
                if (this.mode < 0) {
                    return -1;
                }
            } else {
                this.mode = defMode;
            }
            return 0;
        }

        int parseUserPackageOp(boolean reqOp, PrintWriter err) throws RemoteException {
            block25: {
                String argument22;
                this.userId = -2;
                this.packageName = null;
                this.opStr = null;
                while ((argument22 = this.getNextArg()) != null) {
                    if ("--user".equals(argument22)) {
                        this.userId = UserHandle.parseUserArg(this.getNextArgRequired());
                        continue;
                    }
                    if (this.packageName == null) {
                        this.packageName = argument22;
                        continue;
                    }
                    if (this.opStr != null) continue;
                    this.opStr = argument22;
                    break;
                }
                if (this.packageName == null) {
                    err.println("Error: Package name not specified.");
                    return -1;
                }
                if (this.opStr == null && reqOp) {
                    err.println("Error: Operation not specified.");
                    return -1;
                }
                if (this.opStr != null) {
                    this.op = this.strOpToOp(this.opStr, err);
                    if (this.op < 0) {
                        return -1;
                    }
                } else {
                    this.op = -1;
                }
                if (this.userId == -2) {
                    this.userId = ActivityManager.getCurrentUser();
                }
                this.nonpackageUid = -1;
                try {
                    this.nonpackageUid = Integer.parseInt(this.packageName);
                }
                catch (NumberFormatException argument22) {
                    // empty catch block
                }
                if (this.nonpackageUid == -1 && this.packageName.length() > 1 && this.packageName.charAt(0) == 'u' && this.packageName.indexOf(46) < 0) {
                    int i;
                    for (i = 1; i < this.packageName.length() && this.packageName.charAt(i) >= '0' && this.packageName.charAt(i) <= '9'; ++i) {
                    }
                    if (i > 1 && i < this.packageName.length()) {
                        String userStr = this.packageName.substring(1, i);
                        try {
                            int user = Integer.parseInt(userStr);
                            char type = this.packageName.charAt(i);
                            int startTypeVal = ++i;
                            while (i < this.packageName.length() && this.packageName.charAt(i) >= '0' && this.packageName.charAt(i) <= '9') {
                                ++i;
                            }
                            if (i <= startTypeVal) break block25;
                            String typeValStr = this.packageName.substring(startTypeVal, i);
                            try {
                                int typeVal = Integer.parseInt(typeValStr);
                                if (type == 'a') {
                                    this.nonpackageUid = UserHandle.getUid(user, typeVal + 10000);
                                } else if (type == 's') {
                                    this.nonpackageUid = UserHandle.getUid(user, typeVal);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.nonpackageUid != -1) {
                this.packageName = null;
            } else {
                this.packageUid = "root".equals(this.packageName) ? 0 : AppGlobals.getPackageManager().getPackageUid(this.packageName, 8192, this.userId);
                if (this.packageUid < 0) {
                    err.println("Error: No UID for " + this.packageName + " in user " + this.userId);
                    return -1;
                }
            }
            return 0;
        }
    }

    static final class ChangeRec {
        final int op;
        final int uid;
        final String pkg;

        ChangeRec(int _op, int _uid, String _pkg) {
            this.op = _op;
            this.uid = _uid;
            this.pkg = _pkg;
        }
    }

    public final class ClientState
    extends Binder
    implements IBinder.DeathRecipient {
        final IBinder mAppToken;
        final int mPid;
        final ArrayList<Op> mStartedOps;

        public ClientState(IBinder appToken) {
            this.mAppToken = appToken;
            this.mPid = Binder.getCallingPid();
            if (appToken instanceof Binder) {
                this.mStartedOps = null;
            } else {
                this.mStartedOps = new ArrayList();
                try {
                    this.mAppToken.linkToDeath(this, 0);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return "ClientState{mAppToken=" + this.mAppToken + ", " + (this.mStartedOps != null ? "pid=" + this.mPid : "local") + '}';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            AppOpsService appOpsService = AppOpsService.this;
            synchronized (appOpsService) {
                for (int i = this.mStartedOps.size() - 1; i >= 0; --i) {
                    AppOpsService.this.finishOperationLocked(this.mStartedOps.get(i));
                }
                AppOpsService.this.mClients.remove(this.mAppToken);
            }
        }
    }

    public final class Callback
    implements IBinder.DeathRecipient {
        final IAppOpsCallback mCallback;

        public Callback(IAppOpsCallback callback) {
            this.mCallback = callback;
            try {
                this.mCallback.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void unlinkToDeath() {
            this.mCallback.asBinder().unlinkToDeath(this, 0);
        }

        @Override
        public void binderDied() {
            AppOpsService.this.stopWatchingMode(this.mCallback);
        }
    }

    public static final class Op {
        public final int uid;
        public final String packageName;
        public int proxyUid = -1;
        public String proxyPackageName;
        public final int op;
        public int mode;
        public int duration;
        public long time;
        public long rejectTime;
        public int nesting;

        public Op(int _uid, String _packageName, int _op) {
            this.uid = _uid;
            this.packageName = _packageName;
            this.op = _op;
            this.mode = AppOpsManager.opToDefaultMode(this.op);
        }
    }

    public static final class Ops
    extends SparseArray<Op> {
        public final String packageName;
        public final UidState uidState;
        public final boolean isPrivileged;

        public Ops(String _packageName, UidState _uidState, boolean _isPrivileged) {
            this.packageName = _packageName;
            this.uidState = _uidState;
            this.isPrivileged = _isPrivileged;
        }
    }

    private static final class UidState {
        public final int uid;
        public ArrayMap<String, Ops> pkgOps;
        public SparseIntArray opModes;

        public UidState(int uid) {
            this.uid = uid;
        }

        public void clear() {
            this.pkgOps = null;
            this.opModes = null;
        }

        public boolean isDefault() {
            return !(this.pkgOps != null && !this.pkgOps.isEmpty() || this.opModes != null && this.opModes.size() > 0);
        }
    }
}

