/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;

public class LineBreakBufferedWriter
extends PrintWriter {
    private char[] buffer;
    private int bufferIndex;
    private final int bufferSize;
    private int lastNewline = -1;
    private final String lineSeparator;

    public LineBreakBufferedWriter(Writer out, int bufferSize) {
        this(out, bufferSize, 16);
    }

    public LineBreakBufferedWriter(Writer out, int bufferSize, int initialCapacity) {
        super(out);
        this.buffer = new char[Math.min(initialCapacity, bufferSize)];
        this.bufferIndex = 0;
        this.bufferSize = bufferSize;
        this.lineSeparator = System.getProperty("line.separator");
    }

    @Override
    public void flush() {
        this.writeBuffer(this.bufferIndex);
        this.bufferIndex = 0;
        super.flush();
    }

    @Override
    public void write(int c) {
        if (this.bufferIndex < this.buffer.length) {
            this.buffer[this.bufferIndex] = (char)c;
            ++this.bufferIndex;
            if ((char)c == '\n') {
                this.lastNewline = this.bufferIndex;
            }
        } else {
            this.write(new char[]{(char)c}, 0, 1);
        }
    }

    @Override
    public void println() {
        this.write(this.lineSeparator);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        while (this.bufferIndex + len > this.bufferSize) {
            int nextNewLine = -1;
            int maxLength = this.bufferSize - this.bufferIndex;
            for (int i = 0; i < maxLength; ++i) {
                if (buf[off + i] != '\n') continue;
                if (this.bufferIndex + i >= this.bufferSize) break;
                nextNewLine = i;
            }
            if (nextNewLine != -1) {
                this.appendToBuffer(buf, off, nextNewLine);
                this.writeBuffer(this.bufferIndex);
                this.bufferIndex = 0;
                this.lastNewline = -1;
                off += nextNewLine + 1;
                len -= nextNewLine + 1;
                continue;
            }
            if (this.lastNewline != -1) {
                this.writeBuffer(this.lastNewline);
                this.removeFromBuffer(this.lastNewline + 1);
                this.lastNewline = -1;
                continue;
            }
            int rest = this.bufferSize - this.bufferIndex;
            this.appendToBuffer(buf, off, rest);
            this.writeBuffer(this.bufferIndex);
            this.bufferIndex = 0;
            off += rest;
            len -= rest;
        }
        if (len > 0) {
            this.appendToBuffer(buf, off, len);
            for (int i = len - 1; i >= 0; --i) {
                if (buf[off + i] != '\n') continue;
                this.lastNewline = this.bufferIndex - len + i;
                break;
            }
        }
    }

    @Override
    public void write(String s, int off, int len) {
        while (this.bufferIndex + len > this.bufferSize) {
            int nextNewLine = -1;
            int maxLength = this.bufferSize - this.bufferIndex;
            for (int i = 0; i < maxLength; ++i) {
                if (s.charAt(off + i) != '\n') continue;
                if (this.bufferIndex + i >= this.bufferSize) break;
                nextNewLine = i;
            }
            if (nextNewLine != -1) {
                this.appendToBuffer(s, off, nextNewLine);
                this.writeBuffer(this.bufferIndex);
                this.bufferIndex = 0;
                this.lastNewline = -1;
                off += nextNewLine + 1;
                len -= nextNewLine + 1;
                continue;
            }
            if (this.lastNewline != -1) {
                this.writeBuffer(this.lastNewline);
                this.removeFromBuffer(this.lastNewline + 1);
                this.lastNewline = -1;
                continue;
            }
            int rest = this.bufferSize - this.bufferIndex;
            this.appendToBuffer(s, off, rest);
            this.writeBuffer(this.bufferIndex);
            this.bufferIndex = 0;
            off += rest;
            len -= rest;
        }
        if (len > 0) {
            this.appendToBuffer(s, off, len);
            for (int i = len - 1; i >= 0; --i) {
                if (s.charAt(off + i) != '\n') continue;
                this.lastNewline = this.bufferIndex - len + i;
                break;
            }
        }
    }

    private void appendToBuffer(char[] buf, int off, int len) {
        if (this.bufferIndex + len > this.buffer.length) {
            this.ensureCapacity(this.bufferIndex + len);
        }
        System.arraycopy((char[])buf, (int)off, (char[])this.buffer, (int)this.bufferIndex, (int)len);
        this.bufferIndex += len;
    }

    private void appendToBuffer(String s, int off, int len) {
        if (this.bufferIndex + len > this.buffer.length) {
            this.ensureCapacity(this.bufferIndex + len);
        }
        s.getChars(off, off + len, this.buffer, this.bufferIndex);
        this.bufferIndex += len;
    }

    private void ensureCapacity(int capacity) {
        int newSize = this.buffer.length * 2 + 2;
        if (newSize < capacity) {
            newSize = capacity;
        }
        this.buffer = Arrays.copyOf(this.buffer, newSize);
    }

    private void removeFromBuffer(int i) {
        int rest = this.bufferIndex - i;
        if (rest > 0) {
            System.arraycopy((char[])this.buffer, (int)(this.bufferIndex - rest), (char[])this.buffer, (int)0, (int)rest);
            this.bufferIndex = rest;
        } else {
            this.bufferIndex = 0;
        }
    }

    private void writeBuffer(int length) {
        if (length > 0) {
            super.write(this.buffer, 0, length);
        }
    }
}

