/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telecom.Connection;
import android.telephony.Rlog;
import java.io.IOException;

public class ImsRttTextHandler
extends Handler {
    private static final String LOG_TAG = "ImsRttTextHandler";
    public static final int MAX_CODEPOINTS_PER_SECOND = 30;
    public static final int MAX_BUFFERING_DELAY_MILLIS = 200;
    public static final int MAX_BUFFERED_CHARACTER_COUNT = 5;
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int INITIALIZE = 1;
    private static final int APPEND_TO_NETWORK_BUFFER = 2;
    private static final int SEND_TO_INCALL = 3;
    private static final int ATTEMPT_SEND_TO_NETWORK = 4;
    private static final int EXPIRE_SENT_CODEPOINT_COUNT = 5;
    private static final int TEARDOWN = 6;
    private Connection.RttTextStream mRttTextStream;
    private int mCodepointsAvailableForTransmission = 30;
    private StringBuffer mBufferedTextToNetwork = new StringBuffer();
    private InCallReaderThread mReaderThread;
    private StringBuffer mBufferedTextToIncall = new StringBuffer();
    private final NetworkWriter mNetworkWriter;

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                if (this.mRttTextStream != null || this.mReaderThread != null) {
                    Rlog.e(LOG_TAG, "RTT text stream already initialized. Ignoring.");
                    return;
                }
                this.mRttTextStream = (Connection.RttTextStream)msg.obj;
                this.mReaderThread = new InCallReaderThread(this.mRttTextStream);
                this.mReaderThread.start();
                break;
            }
            case 3: {
                String messageToIncall = (String)msg.obj;
                try {
                    this.mRttTextStream.write(messageToIncall);
                }
                catch (IOException e) {
                    Rlog.e(LOG_TAG, "IOException encountered writing to in-call: %s", e);
                    this.obtainMessage(6).sendToTarget();
                    this.mBufferedTextToIncall.append(messageToIncall);
                }
                break;
            }
            case 2: {
                this.mBufferedTextToNetwork.append((String)msg.obj);
                int numCodepointsBuffered = this.mBufferedTextToNetwork.codePointCount(0, this.mBufferedTextToNetwork.length());
                if (numCodepointsBuffered >= 5) {
                    this.sendMessageAtFrontOfQueue(this.obtainMessage(4));
                    break;
                }
                this.sendEmptyMessageDelayed(4, 200L);
                break;
            }
            case 4: {
                int numCodePointsAvailableInBuffer = this.mBufferedTextToNetwork.codePointCount(0, this.mBufferedTextToNetwork.length());
                int numCodePointsSent = Math.min(numCodePointsAvailableInBuffer, this.mCodepointsAvailableForTransmission);
                if (numCodePointsSent == 0) break;
                int endSendIndex = this.mBufferedTextToNetwork.offsetByCodePoints(0, numCodePointsSent);
                String stringToSend = this.mBufferedTextToNetwork.substring(0, endSendIndex);
                this.mBufferedTextToNetwork.delete(0, endSendIndex);
                this.mNetworkWriter.write(stringToSend);
                this.mCodepointsAvailableForTransmission -= numCodePointsSent;
                this.sendMessageDelayed(this.obtainMessage(5, numCodePointsSent, 0), 1000L);
                break;
            }
            case 5: {
                this.mCodepointsAvailableForTransmission += msg.arg1;
                if (this.mCodepointsAvailableForTransmission <= 0) break;
                this.sendMessageAtFrontOfQueue(this.obtainMessage(4));
                break;
            }
            case 6: {
                try {
                    if (this.mReaderThread != null) {
                        this.mReaderThread.join(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.mReaderThread = null;
                this.mRttTextStream = null;
            }
        }
    }

    public ImsRttTextHandler(Looper looper, NetworkWriter networkWriter) {
        super(looper);
        this.mNetworkWriter = networkWriter;
    }

    public void sendToInCall(String msg) {
        this.obtainMessage(3, msg).sendToTarget();
    }

    public void initialize(Connection.RttTextStream rttTextStream) {
        this.obtainMessage(1, rttTextStream).sendToTarget();
    }

    public void tearDown() {
        this.obtainMessage(6).sendToTarget();
    }

    private class InCallReaderThread
    extends Thread {
        private final Connection.RttTextStream mReaderThreadRttTextStream;

        public InCallReaderThread(Connection.RttTextStream textStream) {
            this.mReaderThreadRttTextStream = textStream;
        }

        @Override
        public void run() {
            while (true) {
                String charsReceived;
                try {
                    charsReceived = this.mReaderThreadRttTextStream.read();
                }
                catch (IOException e) {
                    Rlog.e(ImsRttTextHandler.LOG_TAG, "RttReaderThread - IOException encountered reading from in-call: %s", e);
                    ImsRttTextHandler.this.obtainMessage(6).sendToTarget();
                    break;
                }
                if (charsReceived == null) {
                    if (Thread.currentThread().isInterrupted()) {
                        Rlog.i(ImsRttTextHandler.LOG_TAG, "RttReaderThread - Thread interrupted. Finishing.");
                        break;
                    }
                    Rlog.e(ImsRttTextHandler.LOG_TAG, "RttReaderThread - Stream closed unexpectedly. Attempt to reinitialize.");
                    ImsRttTextHandler.this.obtainMessage(6).sendToTarget();
                    break;
                }
                if (charsReceived.length() == 0) continue;
                ImsRttTextHandler.this.obtainMessage(2, charsReceived).sendToTarget();
            }
        }
    }

    public static interface NetworkWriter {
        public void write(String var1);
    }
}

