/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.NetworkStats;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telecom.ConferenceParticipant;
import android.telecom.Connection;
import android.telecom.TelecomManager;
import android.telecom.VideoProfile;
import android.telephony.CarrierConfigManager;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ims.ImsServiceProxy;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import android.util.SparseIntArray;
import com.android.ims.ImsCall;
import com.android.ims.ImsCallProfile;
import com.android.ims.ImsConfigListener;
import com.android.ims.ImsConnectionStateListener;
import com.android.ims.ImsEcbm;
import com.android.ims.ImsException;
import com.android.ims.ImsManager;
import com.android.ims.ImsMultiEndpoint;
import com.android.ims.ImsReasonInfo;
import com.android.ims.ImsSuppServiceNotification;
import com.android.ims.ImsUtInterface;
import com.android.ims.internal.IImsVideoCallProvider;
import com.android.ims.internal.ImsVideoCallProviderWrapper;
import com.android.internal.os.SomeArgs;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.imsphone.ImsPhoneConnection;
import com.android.internal.telephony.imsphone.ImsPullCall;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public class ImsPhoneCallTracker
extends CallTracker
implements ImsPullCall {
    static final String LOG_TAG = "ImsPhoneCallTracker";
    static final String VERBOSE_STATE_TAG = "IPCTState";
    private static final boolean DBG = true;
    private static final boolean FORCE_VERBOSE_STATE_LOGGING = false;
    private static final boolean VERBOSE_STATE_LOGGING = Rlog.isLoggable("IPCTState", 2);
    private boolean[] mImsFeatureEnabled = new boolean[]{false, false, false, false, false, false};
    private final String[] mImsFeatureStrings = new String[]{"VoLTE", "ViLTE", "VoWiFi", "ViWiFi", "UTLTE", "UTWiFi"};
    private TelephonyMetrics mMetrics;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.android.ims.IMS_INCOMING_CALL")) {
                ImsPhoneCallTracker.this.log("onReceive : incoming call intent");
                if (ImsPhoneCallTracker.this.mImsManager == null) {
                    return;
                }
                if (ImsPhoneCallTracker.this.mServiceId < 0) {
                    return;
                }
                try {
                    ImsCall activeCall;
                    boolean isUssd = intent.getBooleanExtra("android:ussd", false);
                    if (isUssd) {
                        ImsPhoneCallTracker.this.log("onReceive : USSD");
                        ImsPhoneCallTracker.this.mUssdSession = ImsPhoneCallTracker.this.mImsManager.takeCall(ImsPhoneCallTracker.this.mServiceId, intent, ImsPhoneCallTracker.this.mImsUssdListener);
                        if (ImsPhoneCallTracker.this.mUssdSession != null) {
                            ImsPhoneCallTracker.this.mUssdSession.accept(2);
                        }
                        return;
                    }
                    boolean isUnknown = intent.getBooleanExtra("android:isUnknown", false);
                    ImsPhoneCallTracker.this.log("onReceive : isUnknown = " + isUnknown + " fg = " + (Object)((Object)ImsPhoneCallTracker.this.mForegroundCall.getState()) + " bg = " + (Object)((Object)ImsPhoneCallTracker.this.mBackgroundCall.getState()));
                    ImsCall imsCall = ImsPhoneCallTracker.this.mImsManager.takeCall(ImsPhoneCallTracker.this.mServiceId, intent, ImsPhoneCallTracker.this.mImsCallListener);
                    ImsPhoneConnection conn = new ImsPhoneConnection((Phone)ImsPhoneCallTracker.this.mPhone, imsCall, ImsPhoneCallTracker.this, isUnknown ? ImsPhoneCallTracker.this.mForegroundCall : ImsPhoneCallTracker.this.mRingingCall, isUnknown);
                    if (ImsPhoneCallTracker.this.mForegroundCall.hasConnections() && (activeCall = ImsPhoneCallTracker.this.mForegroundCall.getFirstConnection().getImsCall()) != null && imsCall != null) {
                        boolean answeringWillDisconnect = ImsPhoneCallTracker.this.shouldDisconnectActiveCallOnAnswer(activeCall, imsCall);
                        conn.setActiveCallDisconnectedOnAnswer(answeringWillDisconnect);
                    }
                    conn.setAllowAddCallDuringVideoCall(ImsPhoneCallTracker.this.mAllowAddCallDuringVideoCall);
                    ImsPhoneCallTracker.this.addConnection(conn);
                    ImsPhoneCallTracker.this.setVideoCallProvider(conn, imsCall);
                    TelephonyMetrics.getInstance().writeOnImsCallReceive(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getSession());
                    if (isUnknown) {
                        ImsPhoneCallTracker.this.mPhone.notifyUnknownConnection(conn);
                    } else {
                        if (ImsPhoneCallTracker.this.mForegroundCall.getState() != Call.State.IDLE || ImsPhoneCallTracker.this.mBackgroundCall.getState() != Call.State.IDLE) {
                            conn.update(imsCall, Call.State.WAITING);
                        }
                        ImsPhoneCallTracker.this.mPhone.notifyNewRingingConnection(conn);
                        ImsPhoneCallTracker.this.mPhone.notifyIncomingRing();
                    }
                    ImsPhoneCallTracker.this.updatePhoneState();
                    ImsPhoneCallTracker.this.mPhone.notifyPreciseCallStateChanged();
                }
                catch (ImsException e) {
                    ImsPhoneCallTracker.this.loge("onReceive : exception " + e);
                }
                catch (RemoteException e) {}
            } else if (intent.getAction().equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                int subId = intent.getIntExtra("subscription", -1);
                if (subId == ImsPhoneCallTracker.this.mPhone.getSubId()) {
                    ImsPhoneCallTracker.this.cacheCarrierConfiguration(subId);
                    ImsPhoneCallTracker.this.log("onReceive : Updating mAllowEmergencyVideoCalls = " + ImsPhoneCallTracker.this.mAllowEmergencyVideoCalls);
                }
            } else if ("android.telecom.action.CHANGE_DEFAULT_DIALER".equals(intent.getAction())) {
                ImsPhoneCallTracker.this.mDefaultDialerUid.set(ImsPhoneCallTracker.this.getPackageUid(context, intent.getStringExtra("android.telecom.extra.CHANGE_DEFAULT_DIALER_PACKAGE_NAME")));
            }
        }
    };
    static final int MAX_CONNECTIONS = 7;
    static final int MAX_CONNECTIONS_PER_CALL = 5;
    private static final int EVENT_HANGUP_PENDINGMO = 18;
    private static final int EVENT_RESUME_BACKGROUND = 19;
    private static final int EVENT_DIAL_PENDINGMO = 20;
    private static final int EVENT_EXIT_ECBM_BEFORE_PENDINGMO = 21;
    private static final int EVENT_VT_DATA_USAGE_UPDATE = 22;
    private static final int EVENT_DATA_ENABLED_CHANGED = 23;
    private static final int EVENT_GET_IMS_SERVICE = 24;
    private static final int EVENT_CHECK_FOR_WIFI_HANDOVER = 25;
    private static final int EVENT_ON_FEATURE_CAPABILITY_CHANGED = 26;
    private static final int TIMEOUT_HANGUP_PENDINGMO = 500;
    private static final int IMS_RETRY_STARTING_TIMEOUT_MS = 500;
    private static final int CEILING_SERVICE_RETRY_COUNT = 6;
    private static final int HANDOVER_TO_WIFI_TIMEOUT_MS = 60000;
    private ArrayList<ImsPhoneConnection> mConnections = new ArrayList();
    private RegistrantList mVoiceCallEndedRegistrants = new RegistrantList();
    private RegistrantList mVoiceCallStartedRegistrants = new RegistrantList();
    public ImsPhoneCall mRingingCall = new ImsPhoneCall(this, "RG");
    public ImsPhoneCall mForegroundCall = new ImsPhoneCall(this, "FG");
    public ImsPhoneCall mBackgroundCall = new ImsPhoneCall(this, "BG");
    public ImsPhoneCall mHandoverCall = new ImsPhoneCall(this, "HO");
    private final HashMap<Integer, Long> mVtDataUsageMap = new HashMap();
    private volatile NetworkStats mVtDataUsageSnapshot = null;
    private volatile NetworkStats mVtDataUsageUidSnapshot = null;
    private final AtomicInteger mDefaultDialerUid = new AtomicInteger(-1);
    private ImsPhoneConnection mPendingMO;
    private int mClirMode = 0;
    private Object mSyncHold = new Object();
    private ImsCall mUssdSession = null;
    private Message mPendingUssd = null;
    ImsPhone mPhone;
    private boolean mDesiredMute = false;
    private boolean mOnHoldToneStarted = false;
    private int mOnHoldToneId = -1;
    private PhoneConstants.State mState = PhoneConstants.State.IDLE;
    private int mImsServiceRetryCount;
    private ImsManager mImsManager;
    private int mServiceId = -1;
    private Call.SrvccState mSrvccState = Call.SrvccState.NONE;
    private boolean mIsInEmergencyCall = false;
    private boolean mIsDataEnabled = false;
    private int pendingCallClirMode;
    private int mPendingCallVideoState;
    private Bundle mPendingIntentExtras;
    private boolean pendingCallInEcm = false;
    private boolean mSwitchingFgAndBgCalls = false;
    private ImsCall mCallExpectedToResume = null;
    private boolean mAllowEmergencyVideoCalls = false;
    private boolean mIgnoreDataEnabledChangedForVideoCalls = false;
    private boolean mIsViLteDataMetered = false;
    private List<PhoneStateListener> mPhoneStateListeners = new ArrayList<PhoneStateListener>();
    private boolean mTreatDowngradedVideoCallsAsVideoCalls = false;
    private boolean mDropVideoCallWhenAnsweringAudioCall = false;
    private boolean mAllowAddCallDuringVideoCall = true;
    private boolean mNotifyVtHandoverToWifiFail = false;
    private boolean mSupportDowngradeVtToAudio = false;
    private static final SparseIntArray PRECISE_CAUSE_MAP = new SparseIntArray();
    private boolean mNotifyHandoverVideoFromWifiToLTE = false;
    private boolean mSupportPauseVideo = false;
    private Map<Pair<Integer, String>, Integer> mImsReasonCodeMap = new ArrayMap<Pair<Integer, String>, Integer>();
    private boolean mShouldUpdateImsConfigOnDisconnect = false;
    private SharedPreferenceProxy mSharedPreferenceProxy = context -> PreferenceManager.getDefaultSharedPreferences(context);
    private PhoneNumberUtilsProxy mPhoneNumberUtilsProxy = string2 -> PhoneNumberUtils.isEmergencyNumber(string2);
    private ImsServiceProxy.INotifyStatusChanged mNotifyStatusChangedCallback = () -> {
        try {
            int status = this.mImsManager.getImsServiceStatus();
            this.log("Status Changed: " + status);
            switch (status) {
                case 2: {
                    this.startListeningForCalls();
                    break;
                }
                case 0: 
                case 1: {
                    this.stopListeningForCalls();
                    break;
                }
                default: {
                    Log.w(LOG_TAG, "Unexpected State!");
                    break;
                }
            }
        }
        catch (ImsException e) {
            this.retryGetImsService();
        }
    };
    public IRetryTimeout mRetryTimeout = () -> {
        int timeout = (1 << this.mImsServiceRetryCount) * 500;
        if (this.mImsServiceRetryCount <= 6) {
            ++this.mImsServiceRetryCount;
        }
        return timeout;
    };
    private ImsCall.Listener mImsCallListener = new ImsCall.Listener(){

        @Override
        public void onCallProgressing(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("onCallProgressing");
            ImsPhoneCallTracker.this.mPendingMO = null;
            ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.ALERTING, 0);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallProgressing(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession());
        }

        @Override
        public void onCallStarted(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("onCallStarted");
            if (ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls && ImsPhoneCallTracker.this.mCallExpectedToResume != null && ImsPhoneCallTracker.this.mCallExpectedToResume == imsCall) {
                ImsPhoneCallTracker.this.log("onCallStarted: starting a call as a result of a switch.");
                ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls = false;
                ImsPhoneCallTracker.this.mCallExpectedToResume = null;
            }
            ImsPhoneCallTracker.this.mPendingMO = null;
            ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.ACTIVE, 0);
            if (ImsPhoneCallTracker.this.mNotifyVtHandoverToWifiFail && !imsCall.isWifiCall() && imsCall.isVideoCall() && ImsPhoneCallTracker.this.isWifiConnected()) {
                ImsPhoneCallTracker.this.sendMessageDelayed(ImsPhoneCallTracker.this.obtainMessage(25, imsCall), 60000L);
            }
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallStarted(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession());
        }

        @Override
        public void onCallUpdated(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("onCallUpdated");
            if (imsCall == null) {
                return;
            }
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                ImsPhoneCallTracker.this.processCallStateChange(imsCall, conn.getCall().mState, 0, true);
                ImsPhoneCallTracker.this.mMetrics.writeImsCallState(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession(), conn.getCall().mState);
            }
        }

        @Override
        public void onCallStartFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("onCallStartFailed reasonCode=" + reasonInfo.getCode());
            if (ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls && ImsPhoneCallTracker.this.mCallExpectedToResume != null && ImsPhoneCallTracker.this.mCallExpectedToResume == imsCall) {
                ImsPhoneCallTracker.this.log("onCallStarted: starting a call as a result of a switch.");
                ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls = false;
                ImsPhoneCallTracker.this.mCallExpectedToResume = null;
            }
            if (ImsPhoneCallTracker.this.mPendingMO != null) {
                if (reasonInfo.getCode() == 146 && ImsPhoneCallTracker.this.mBackgroundCall.getState() == Call.State.IDLE && ImsPhoneCallTracker.this.mRingingCall.getState() == Call.State.IDLE) {
                    ImsPhoneCallTracker.this.mForegroundCall.detach(ImsPhoneCallTracker.this.mPendingMO);
                    ImsPhoneCallTracker.this.removeConnection(ImsPhoneCallTracker.this.mPendingMO);
                    ImsPhoneCallTracker.this.mPendingMO.finalize();
                    ImsPhoneCallTracker.this.mPendingMO = null;
                    ImsPhoneCallTracker.this.mPhone.initiateSilentRedial();
                    return;
                }
                ImsPhoneCallTracker.this.mPendingMO = null;
                ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
                Call.State callState = conn != null ? conn.getState() : Call.State.DIALING;
                int cause = ImsPhoneCallTracker.this.getDisconnectCauseFromReasonInfo(reasonInfo, callState);
                if (conn != null) {
                    conn.setPreciseDisconnectCause(ImsPhoneCallTracker.this.getPreciseDisconnectCauseFromReasonInfo(reasonInfo));
                }
                ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.DISCONNECTED, cause);
                ImsPhoneCallTracker.this.mMetrics.writeOnImsCallStartFailed(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession(), reasonInfo);
            }
        }

        @Override
        public void onCallTerminated(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            Connection.VideoProvider videoProvider;
            ImsPhoneCallTracker.this.log("onCallTerminated reasonCode=" + reasonInfo.getCode());
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            Call.State callState = conn != null ? conn.getState() : Call.State.ACTIVE;
            int cause = ImsPhoneCallTracker.this.getDisconnectCauseFromReasonInfo(reasonInfo, callState);
            ImsPhoneCallTracker.this.log("cause = " + cause + " conn = " + conn);
            if (conn != null && (videoProvider = conn.getVideoProvider()) instanceof ImsVideoCallProviderWrapper) {
                ImsVideoCallProviderWrapper wrapper = (ImsVideoCallProviderWrapper)videoProvider;
                wrapper.removeImsVideoProviderCallback(conn);
            }
            if (ImsPhoneCallTracker.this.mOnHoldToneId == System.identityHashCode(conn)) {
                if (conn != null && ImsPhoneCallTracker.this.mOnHoldToneStarted) {
                    ImsPhoneCallTracker.this.mPhone.stopOnHoldTone(conn);
                }
                ImsPhoneCallTracker.this.mOnHoldToneStarted = false;
                ImsPhoneCallTracker.this.mOnHoldToneId = -1;
            }
            if (conn != null) {
                if (conn.isPulledCall() && (reasonInfo.getCode() == 1015 || reasonInfo.getCode() == 336 || reasonInfo.getCode() == 332) && ImsPhoneCallTracker.this.mPhone != null && ImsPhoneCallTracker.this.mPhone.getExternalCallTracker() != null) {
                    ImsPhoneCallTracker.this.log("Call pull failed.");
                    conn.onCallPullFailed(ImsPhoneCallTracker.this.mPhone.getExternalCallTracker().getConnectionById(conn.getPulledDialogId()));
                    cause = 0;
                } else if (conn.isIncoming() && conn.getConnectTime() == 0L && cause != 52) {
                    cause = cause == 2 ? 1 : 16;
                    ImsPhoneCallTracker.this.log("Incoming connection of 0 connect time detected - translated cause = " + cause);
                }
            }
            if (cause == 2 && conn != null && conn.getImsCall().isMerged()) {
                cause = 45;
            }
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallTerminated(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession(), reasonInfo);
            if (conn != null) {
                conn.setPreciseDisconnectCause(ImsPhoneCallTracker.this.getPreciseDisconnectCauseFromReasonInfo(reasonInfo));
            }
            ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.DISCONNECTED, cause);
            if (ImsPhoneCallTracker.this.mForegroundCall.getState() != Call.State.ACTIVE) {
                if (ImsPhoneCallTracker.this.mRingingCall.getState().isRinging()) {
                    ImsPhoneCallTracker.this.mPendingMO = null;
                } else if (ImsPhoneCallTracker.this.mPendingMO != null) {
                    ImsPhoneCallTracker.this.sendEmptyMessage(20);
                }
            }
            if (ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls) {
                ImsPhoneCallTracker.this.log("onCallTerminated: Call terminated in the midst of Switching Fg and Bg calls.");
                if (imsCall == ImsPhoneCallTracker.this.mCallExpectedToResume) {
                    ImsPhoneCallTracker.this.log("onCallTerminated: switching " + ImsPhoneCallTracker.this.mForegroundCall + " with " + ImsPhoneCallTracker.this.mBackgroundCall);
                    ImsPhoneCallTracker.this.mForegroundCall.switchWith(ImsPhoneCallTracker.this.mBackgroundCall);
                }
                ImsPhoneCallTracker.this.log("onCallTerminated: foreground call in state " + (Object)((Object)ImsPhoneCallTracker.this.mForegroundCall.getState()) + " and ringing call in state " + (ImsPhoneCallTracker.this.mRingingCall == null ? "null" : ImsPhoneCallTracker.this.mRingingCall.getState().toString()));
                if (ImsPhoneCallTracker.this.mForegroundCall.getState() == Call.State.HOLDING || ImsPhoneCallTracker.this.mRingingCall.getState() == Call.State.WAITING) {
                    ImsPhoneCallTracker.this.sendEmptyMessage(19);
                    ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls = false;
                    ImsPhoneCallTracker.this.mCallExpectedToResume = null;
                }
            }
            if (ImsPhoneCallTracker.this.mShouldUpdateImsConfigOnDisconnect) {
                ImsManager.updateImsServiceConfig(ImsPhoneCallTracker.this.mPhone.getContext(), ImsPhoneCallTracker.this.mPhone.getPhoneId(), true);
                ImsPhoneCallTracker.this.mShouldUpdateImsConfigOnDisconnect = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCallHeld(ImsCall imsCall) {
            if (ImsPhoneCallTracker.this.mForegroundCall.getImsCall() == imsCall) {
                ImsPhoneCallTracker.this.log("onCallHeld (fg) " + imsCall);
            } else if (ImsPhoneCallTracker.this.mBackgroundCall.getImsCall() == imsCall) {
                ImsPhoneCallTracker.this.log("onCallHeld (bg) " + imsCall);
            }
            Object object = ImsPhoneCallTracker.this.mSyncHold;
            synchronized (object) {
                Call.State oldState = ImsPhoneCallTracker.this.mBackgroundCall.getState();
                ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.HOLDING, 0);
                if (oldState == Call.State.ACTIVE) {
                    if (ImsPhoneCallTracker.this.mForegroundCall.getState() == Call.State.HOLDING || ImsPhoneCallTracker.this.mRingingCall.getState() == Call.State.WAITING) {
                        ImsPhoneCallTracker.this.sendEmptyMessage(19);
                    } else {
                        if (ImsPhoneCallTracker.this.mPendingMO != null) {
                            ImsPhoneCallTracker.this.dialPendingMO();
                        }
                        ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls = false;
                    }
                } else if (oldState == Call.State.IDLE && ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls && ImsPhoneCallTracker.this.mForegroundCall.getState() == Call.State.HOLDING) {
                    ImsPhoneCallTracker.this.sendEmptyMessage(19);
                    ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls = false;
                    ImsPhoneCallTracker.this.mCallExpectedToResume = null;
                }
            }
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallHeld(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCallHoldFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("onCallHoldFailed reasonCode=" + reasonInfo.getCode());
            Object object = ImsPhoneCallTracker.this.mSyncHold;
            synchronized (object) {
                Call.State bgState = ImsPhoneCallTracker.this.mBackgroundCall.getState();
                if (reasonInfo.getCode() == 148) {
                    if (ImsPhoneCallTracker.this.mPendingMO != null) {
                        ImsPhoneCallTracker.this.dialPendingMO();
                    }
                } else if (bgState == Call.State.ACTIVE) {
                    ImsPhoneCallTracker.this.mForegroundCall.switchWith(ImsPhoneCallTracker.this.mBackgroundCall);
                    if (ImsPhoneCallTracker.this.mPendingMO != null) {
                        ImsPhoneCallTracker.this.mPendingMO.setDisconnectCause(36);
                        ImsPhoneCallTracker.this.sendEmptyMessageDelayed(18, 500L);
                    }
                }
                ImsPhoneCallTracker.this.mPhone.notifySuppServiceFailed(PhoneInternalInterface.SuppService.HOLD);
            }
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallHoldFailed(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession(), reasonInfo);
        }

        @Override
        public void onCallResumed(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("onCallResumed");
            if (ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls) {
                if (imsCall != ImsPhoneCallTracker.this.mCallExpectedToResume) {
                    ImsPhoneCallTracker.this.log("onCallResumed : switching " + ImsPhoneCallTracker.this.mForegroundCall + " with " + ImsPhoneCallTracker.this.mBackgroundCall);
                    ImsPhoneCallTracker.this.mForegroundCall.switchWith(ImsPhoneCallTracker.this.mBackgroundCall);
                } else {
                    ImsPhoneCallTracker.this.log("onCallResumed : expected call resumed.");
                }
                ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls = false;
                ImsPhoneCallTracker.this.mCallExpectedToResume = null;
            }
            ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.ACTIVE, 0);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallResumed(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession());
        }

        @Override
        public void onCallResumeFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            if (ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls) {
                if (imsCall == ImsPhoneCallTracker.this.mCallExpectedToResume) {
                    ImsPhoneCallTracker.this.log("onCallResumeFailed : switching " + ImsPhoneCallTracker.this.mForegroundCall + " with " + ImsPhoneCallTracker.this.mBackgroundCall);
                    ImsPhoneCallTracker.this.mForegroundCall.switchWith(ImsPhoneCallTracker.this.mBackgroundCall);
                    if (ImsPhoneCallTracker.this.mForegroundCall.getState() == Call.State.HOLDING) {
                        ImsPhoneCallTracker.this.sendEmptyMessage(19);
                    }
                }
                ImsPhoneCallTracker.this.mCallExpectedToResume = null;
                ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls = false;
            }
            ImsPhoneCallTracker.this.mPhone.notifySuppServiceFailed(PhoneInternalInterface.SuppService.RESUME);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallResumeFailed(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession(), reasonInfo);
        }

        @Override
        public void onCallResumeReceived(ImsCall imsCall) {
            boolean useVideoPauseWorkaround;
            ImsPhoneCallTracker.this.log("onCallResumeReceived");
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                if (ImsPhoneCallTracker.this.mOnHoldToneStarted) {
                    ImsPhoneCallTracker.this.mPhone.stopOnHoldTone(conn);
                    ImsPhoneCallTracker.this.mOnHoldToneStarted = false;
                }
                conn.onConnectionEvent("android.telecom.event.CALL_REMOTELY_UNHELD", null);
            }
            if ((useVideoPauseWorkaround = ImsPhoneCallTracker.this.mPhone.getContext().getResources().getBoolean(17957048)) && ImsPhoneCallTracker.this.mSupportPauseVideo && VideoProfile.isVideo(conn.getVideoState())) {
                conn.changeToUnPausedState();
            }
            SuppServiceNotification supp = new SuppServiceNotification();
            supp.notificationType = 1;
            supp.code = 3;
            ImsPhoneCallTracker.this.mPhone.notifySuppSvcNotification(supp);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallResumeReceived(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession());
        }

        @Override
        public void onCallHoldReceived(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("onCallHoldReceived");
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                if (!ImsPhoneCallTracker.this.mOnHoldToneStarted && ImsPhoneCall.isLocalTone(imsCall) && conn.getState() == Call.State.ACTIVE) {
                    ImsPhoneCallTracker.this.mPhone.startOnHoldTone(conn);
                    ImsPhoneCallTracker.this.mOnHoldToneStarted = true;
                    ImsPhoneCallTracker.this.mOnHoldToneId = System.identityHashCode(conn);
                }
                conn.onConnectionEvent("android.telecom.event.CALL_REMOTELY_HELD", null);
                boolean useVideoPauseWorkaround = ImsPhoneCallTracker.this.mPhone.getContext().getResources().getBoolean(17957048);
                if (useVideoPauseWorkaround && ImsPhoneCallTracker.this.mSupportPauseVideo && VideoProfile.isVideo(conn.getVideoState())) {
                    conn.changeToPausedState();
                }
            }
            SuppServiceNotification supp = new SuppServiceNotification();
            supp.notificationType = 1;
            supp.code = 2;
            ImsPhoneCallTracker.this.mPhone.notifySuppSvcNotification(supp);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallHoldReceived(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession());
        }

        @Override
        public void onCallSuppServiceReceived(ImsCall call, ImsSuppServiceNotification suppServiceInfo) {
            ImsPhoneCallTracker.this.log("onCallSuppServiceReceived: suppServiceInfo=" + suppServiceInfo);
            SuppServiceNotification supp = new SuppServiceNotification();
            supp.notificationType = suppServiceInfo.notificationType;
            supp.code = suppServiceInfo.code;
            supp.index = suppServiceInfo.index;
            supp.number = suppServiceInfo.number;
            supp.history = suppServiceInfo.history;
            ImsPhoneCallTracker.this.mPhone.notifySuppSvcNotification(supp);
        }

        @Override
        public void onCallMerged(ImsCall call, ImsCall peerCall, boolean swapCalls) {
            ImsPhoneCall peerImsPhoneCall;
            ImsPhoneCallTracker.this.log("onCallMerged");
            ImsPhoneCall foregroundImsPhoneCall = ImsPhoneCallTracker.this.findConnection(call).getCall();
            ImsPhoneConnection peerConnection = ImsPhoneCallTracker.this.findConnection(peerCall);
            ImsPhoneCall imsPhoneCall = peerImsPhoneCall = peerConnection == null ? null : peerConnection.getCall();
            if (swapCalls) {
                ImsPhoneCallTracker.this.switchAfterConferenceSuccess();
            }
            foregroundImsPhoneCall.merge(peerImsPhoneCall, Call.State.ACTIVE);
            try {
                ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(call);
                ImsPhoneCallTracker.this.log("onCallMerged: ImsPhoneConnection=" + conn);
                ImsPhoneCallTracker.this.log("onCallMerged: CurrentVideoProvider=" + conn.getVideoProvider());
                ImsPhoneCallTracker.this.setVideoCallProvider(conn, call);
                ImsPhoneCallTracker.this.log("onCallMerged: CurrentVideoProvider=" + conn.getVideoProvider());
            }
            catch (Exception e) {
                ImsPhoneCallTracker.this.loge("onCallMerged: exception " + e);
            }
            ImsPhoneCallTracker.this.processCallStateChange(ImsPhoneCallTracker.this.mForegroundCall.getImsCall(), Call.State.ACTIVE, 0);
            if (peerConnection != null) {
                ImsPhoneCallTracker.this.processCallStateChange(ImsPhoneCallTracker.this.mBackgroundCall.getImsCall(), Call.State.HOLDING, 0);
            }
            if (!call.isMergeRequestedByConf()) {
                ImsPhoneCallTracker.this.log("onCallMerged :: calling onMultipartyStateChanged()");
                this.onMultipartyStateChanged(call, true);
            } else {
                ImsPhoneCallTracker.this.log("onCallMerged :: Merge requested by existing conference.");
                call.resetIsMergeRequestedByConf(false);
            }
            ImsPhoneCallTracker.this.logState();
        }

        @Override
        public void onCallMergeFailed(ImsCall call, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("onCallMergeFailed reasonInfo=" + reasonInfo);
            ImsPhoneCallTracker.this.mPhone.notifySuppServiceFailed(PhoneInternalInterface.SuppService.CONFERENCE);
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(call);
            if (conn != null) {
                conn.onConferenceMergeFailed();
                conn.handleMergeComplete();
            }
        }

        @Override
        public void onConferenceParticipantsStateChanged(ImsCall call, List<ConferenceParticipant> participants) {
            ImsPhoneCallTracker.this.log("onConferenceParticipantsStateChanged");
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(call);
            if (conn != null) {
                conn.updateConferenceParticipants(participants);
            }
        }

        @Override
        public void onCallSessionTtyModeReceived(ImsCall call, int mode) {
            ImsPhoneCallTracker.this.mPhone.onTtyModeReceived(mode);
        }

        @Override
        public void onCallHandover(ImsCall imsCall, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
            ImsPhoneConnection conn;
            boolean isHandoverToWifi;
            ImsPhoneCallTracker.this.log("onCallHandover ::  srcAccessTech=" + srcAccessTech + ", targetAccessTech=" + targetAccessTech + ", reasonInfo=" + reasonInfo);
            boolean bl = isHandoverToWifi = srcAccessTech != 0 && srcAccessTech != 18 && targetAccessTech == 18;
            if (isHandoverToWifi) {
                ImsPhoneCallTracker.this.removeMessages(25);
            }
            if ((conn = ImsPhoneCallTracker.this.findConnection(imsCall)) != null) {
                boolean isHandoverFromWifi;
                boolean bl2 = isHandoverFromWifi = srcAccessTech == 18 && targetAccessTech != 0 && targetAccessTech != 18;
                if (isHandoverFromWifi && imsCall.isVideoCall()) {
                    if (ImsPhoneCallTracker.this.mNotifyHandoverVideoFromWifiToLTE && ImsPhoneCallTracker.this.mIsDataEnabled) {
                        ImsPhoneCallTracker.this.log("onCallHandover :: notifying of WIFI to LTE handover.");
                        conn.onConnectionEvent("android.telephony.event.EVENT_HANDOVER_VIDEO_FROM_WIFI_TO_LTE", null);
                    }
                    if (!ImsPhoneCallTracker.this.mIsDataEnabled && ImsPhoneCallTracker.this.mIsViLteDataMetered) {
                        ImsPhoneCallTracker.this.downgradeVideoCall(1407, conn);
                    }
                }
            } else {
                ImsPhoneCallTracker.this.loge("onCallHandover :: connection null.");
            }
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallHandoverEvent(ImsPhoneCallTracker.this.mPhone.getPhoneId(), 18, imsCall.getCallSession(), srcAccessTech, targetAccessTech, reasonInfo);
        }

        @Override
        public void onCallHandoverFailed(ImsCall imsCall, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("onCallHandoverFailed :: srcAccessTech=" + srcAccessTech + ", targetAccessTech=" + targetAccessTech + ", reasonInfo=" + reasonInfo);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallHandoverEvent(ImsPhoneCallTracker.this.mPhone.getPhoneId(), 19, imsCall.getCallSession(), srcAccessTech, targetAccessTech, reasonInfo);
            boolean isHandoverToWifi = srcAccessTech != 18 && targetAccessTech == 18;
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null && isHandoverToWifi) {
                ImsPhoneCallTracker.this.log("onCallHandoverFailed - handover to WIFI Failed");
                ImsPhoneCallTracker.this.removeMessages(25);
                if (ImsPhoneCallTracker.this.mNotifyVtHandoverToWifiFail) {
                    conn.onHandoverToWifiFailed();
                }
            }
        }

        @Override
        public void onRttModifyRequestReceived(ImsCall imsCall) {
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                conn.onRttModifyRequestReceived();
            }
        }

        @Override
        public void onRttModifyResponseReceived(ImsCall imsCall, int status) {
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                conn.onRttModifyResponseReceived(status);
                if (status == 1) {
                    conn.startRttTextProcessing();
                }
            }
        }

        @Override
        public void onRttMessageReceived(ImsCall imsCall, String message) {
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                conn.onRttMessageReceived(message);
            }
        }

        @Override
        public void onMultipartyStateChanged(ImsCall imsCall, boolean isMultiParty) {
            ImsPhoneCallTracker.this.log("onMultipartyStateChanged to " + (isMultiParty ? "Y" : "N"));
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                conn.updateMultipartyState(isMultiParty);
            }
        }
    };
    private ImsCall.Listener mImsUssdListener = new ImsCall.Listener(){

        @Override
        public void onCallStarted(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("mImsUssdListener onCallStarted");
            if (imsCall == ImsPhoneCallTracker.this.mUssdSession && ImsPhoneCallTracker.this.mPendingUssd != null) {
                AsyncResult.forMessage(ImsPhoneCallTracker.this.mPendingUssd);
                ImsPhoneCallTracker.this.mPendingUssd.sendToTarget();
                ImsPhoneCallTracker.this.mPendingUssd = null;
            }
        }

        @Override
        public void onCallStartFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("mImsUssdListener onCallStartFailed reasonCode=" + reasonInfo.getCode());
            this.onCallTerminated(imsCall, reasonInfo);
        }

        @Override
        public void onCallTerminated(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("mImsUssdListener onCallTerminated reasonCode=" + reasonInfo.getCode());
            ImsPhoneCallTracker.this.removeMessages(25);
            if (imsCall == ImsPhoneCallTracker.this.mUssdSession) {
                ImsPhoneCallTracker.this.mUssdSession = null;
                if (ImsPhoneCallTracker.this.mPendingUssd != null) {
                    CommandException ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
                    AsyncResult.forMessage(ImsPhoneCallTracker.this.mPendingUssd, null, ex);
                    ImsPhoneCallTracker.this.mPendingUssd.sendToTarget();
                    ImsPhoneCallTracker.this.mPendingUssd = null;
                }
            }
            imsCall.close();
        }

        @Override
        public void onCallUssdMessageReceived(ImsCall call, int mode, String ussdMessage) {
            ImsPhoneCallTracker.this.log("mImsUssdListener onCallUssdMessageReceived mode=" + mode);
            int ussdMode = -1;
            switch (mode) {
                case 1: {
                    ussdMode = 1;
                    break;
                }
                case 0: {
                    ussdMode = 0;
                }
            }
            ImsPhoneCallTracker.this.mPhone.onIncomingUSSD(ussdMode, ussdMessage);
        }
    };
    private ImsConnectionStateListener mImsConnectionStateListener = new ImsConnectionStateListener(){

        @Override
        public void onImsConnected(int imsRadioTech) {
            ImsPhoneCallTracker.this.log("onImsConnected imsRadioTech=" + imsRadioTech);
            ImsPhoneCallTracker.this.mPhone.setServiceState(0);
            ImsPhoneCallTracker.this.mPhone.setImsRegistered(true);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsConnectionState(ImsPhoneCallTracker.this.mPhone.getPhoneId(), 1, null);
        }

        @Override
        public void onImsDisconnected(ImsReasonInfo imsReasonInfo) {
            ImsPhoneCallTracker.this.log("onImsDisconnected imsReasonInfo=" + imsReasonInfo);
            ImsPhoneCallTracker.this.resetImsCapabilities();
            ImsPhoneCallTracker.this.mPhone.setServiceState(1);
            ImsPhoneCallTracker.this.mPhone.setImsRegistered(false);
            ImsPhoneCallTracker.this.mPhone.processDisconnectReason(imsReasonInfo);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsConnectionState(ImsPhoneCallTracker.this.mPhone.getPhoneId(), 3, imsReasonInfo);
        }

        @Override
        public void onImsProgressing(int imsRadioTech) {
            ImsPhoneCallTracker.this.log("onImsProgressing imsRadioTech=" + imsRadioTech);
            ImsPhoneCallTracker.this.mPhone.setServiceState(1);
            ImsPhoneCallTracker.this.mPhone.setImsRegistered(false);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsConnectionState(ImsPhoneCallTracker.this.mPhone.getPhoneId(), 2, null);
        }

        @Override
        public void onImsResumed() {
            ImsPhoneCallTracker.this.log("onImsResumed");
            ImsPhoneCallTracker.this.mPhone.setServiceState(0);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsConnectionState(ImsPhoneCallTracker.this.mPhone.getPhoneId(), 4, null);
        }

        @Override
        public void onImsSuspended() {
            ImsPhoneCallTracker.this.log("onImsSuspended");
            ImsPhoneCallTracker.this.mPhone.setServiceState(1);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsConnectionState(ImsPhoneCallTracker.this.mPhone.getPhoneId(), 5, null);
        }

        @Override
        public void onFeatureCapabilityChanged(int serviceClass, int[] enabledFeatures, int[] disabledFeatures) {
            ImsPhoneCallTracker.this.log("onFeatureCapabilityChanged");
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = serviceClass;
            args.arg1 = enabledFeatures;
            args.arg2 = disabledFeatures;
            ImsPhoneCallTracker.this.removeMessages(26);
            ImsPhoneCallTracker.this.obtainMessage(26, args).sendToTarget();
        }

        @Override
        public void onVoiceMessageCountChanged(int count) {
            ImsPhoneCallTracker.this.log("onVoiceMessageCountChanged :: count=" + count);
            ImsPhoneCallTracker.this.mPhone.mDefaultPhone.setVoiceMessageCount(count);
        }

        @Override
        public void registrationAssociatedUriChanged(Uri[] uris) {
            ImsPhoneCallTracker.this.log("registrationAssociatedUriChanged");
            ImsPhoneCallTracker.this.mPhone.setCurrentSubscriberUris(uris);
        }
    };
    private ImsConfigListener.Stub mImsConfigListener = new ImsConfigListener.Stub(){

        @Override
        public void onGetFeatureResponse(int feature, int network, int value, int status) {
        }

        @Override
        public void onSetFeatureResponse(int feature, int network, int value, int status) {
            ImsPhoneCallTracker.this.mMetrics.writeImsSetFeatureValue(ImsPhoneCallTracker.this.mPhone.getPhoneId(), feature, network, value, status);
        }

        @Override
        public void onGetVideoQuality(int status, int quality) {
        }

        @Override
        public void onSetVideoQuality(int status) {
        }
    };

    public ImsPhoneCallTracker(ImsPhone phone) {
        this.mPhone = phone;
        this.mMetrics = TelephonyMetrics.getInstance();
        IntentFilter intentfilter = new IntentFilter();
        intentfilter.addAction("com.android.ims.IMS_INCOMING_CALL");
        intentfilter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        intentfilter.addAction("android.telecom.action.CHANGE_DEFAULT_DIALER");
        this.mPhone.getContext().registerReceiver(this.mReceiver, intentfilter);
        this.cacheCarrierConfiguration(this.mPhone.getSubId());
        this.mPhone.getDefaultPhone().registerForDataEnabledChanged(this, 23, null);
        this.mImsServiceRetryCount = 0;
        TelecomManager telecomManager = (TelecomManager)this.mPhone.getContext().getSystemService("telecom");
        this.mDefaultDialerUid.set(this.getPackageUid(this.mPhone.getContext(), telecomManager.getDefaultDialerPackage()));
        long currentTime = SystemClock.elapsedRealtime();
        this.mVtDataUsageSnapshot = new NetworkStats(currentTime, 1);
        this.mVtDataUsageUidSnapshot = new NetworkStats(currentTime, 1);
        this.sendEmptyMessage(24);
    }

    public void setSharedPreferenceProxy(SharedPreferenceProxy sharedPreferenceProxy) {
        this.mSharedPreferenceProxy = sharedPreferenceProxy;
    }

    public void setPhoneNumberUtilsProxy(PhoneNumberUtilsProxy phoneNumberUtilsProxy) {
        this.mPhoneNumberUtilsProxy = phoneNumberUtilsProxy;
    }

    private int getPackageUid(Context context, String pkg) {
        if (pkg == null) {
            return -1;
        }
        int uid = -1;
        try {
            uid = context.getPackageManager().getPackageUid(pkg, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            this.loge("Cannot find package uid. pkg = " + pkg);
        }
        return uid;
    }

    private PendingIntent createIncomingCallPendingIntent() {
        Intent intent = new Intent("com.android.ims.IMS_INCOMING_CALL");
        intent.addFlags(0x10000000);
        return PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
    }

    private void getImsService() throws ImsException {
        this.log("getImsService");
        this.mImsManager = ImsManager.getInstance(this.mPhone.getContext(), this.mPhone.getPhoneId());
        this.mImsManager.addNotifyStatusChangedCallbackIfAvailable(this.mNotifyStatusChangedCallback);
        this.mNotifyStatusChangedCallback.notifyStatusChanged();
    }

    private void startListeningForCalls() throws ImsException {
        this.mImsServiceRetryCount = 0;
        this.mServiceId = this.mImsManager.open(1, this.createIncomingCallPendingIntent(), this.mImsConnectionStateListener);
        this.mImsManager.setImsConfigListener(this.mImsConfigListener);
        this.getEcbmInterface().setEcbmStateListener(this.mPhone.getImsEcbmStateListener());
        if (this.mPhone.isInEcm()) {
            this.mPhone.exitEmergencyCallbackMode();
        }
        int mPreferredTtyMode = Settings.Secure.getInt(this.mPhone.getContext().getContentResolver(), "preferred_tty_mode", 0);
        this.mImsManager.setUiTTYMode(this.mPhone.getContext(), mPreferredTtyMode, null);
        ImsMultiEndpoint multiEndpoint = this.getMultiEndpointInterface();
        if (multiEndpoint != null) {
            multiEndpoint.setExternalCallStateListener(this.mPhone.getExternalCallTracker().getExternalCallStateListener());
        }
    }

    private void stopListeningForCalls() {
        try {
            if (this.mImsManager != null && this.mServiceId > 0) {
                this.mImsManager.close(this.mServiceId);
                this.mServiceId = -1;
            }
        }
        catch (ImsException imsException) {
            // empty catch block
        }
    }

    public void dispose() {
        this.log("dispose");
        this.mRingingCall.dispose();
        this.mBackgroundCall.dispose();
        this.mForegroundCall.dispose();
        this.mHandoverCall.dispose();
        this.clearDisconnected();
        this.mPhone.getContext().unregisterReceiver(this.mReceiver);
        this.mPhone.getDefaultPhone().unregisterForDataEnabledChanged(this);
        this.removeMessages(24);
    }

    protected void finalize() {
        this.log("ImsPhoneCallTracker finalized");
    }

    @Override
    public void registerForVoiceCallStarted(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallStartedRegistrants.add(r);
    }

    @Override
    public void unregisterForVoiceCallStarted(Handler h) {
        this.mVoiceCallStartedRegistrants.remove(h);
    }

    @Override
    public void registerForVoiceCallEnded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallEndedRegistrants.add(r);
    }

    @Override
    public void unregisterForVoiceCallEnded(Handler h) {
        this.mVoiceCallEndedRegistrants.remove(h);
    }

    public Connection dial(String dialString, int videoState, Bundle intentExtras) throws CallStateException {
        int oirMode;
        if (this.mSharedPreferenceProxy != null && this.mPhone.getDefaultPhone() != null) {
            SharedPreferences sp = this.mSharedPreferenceProxy.getDefaultSharedPreferences(this.mPhone.getContext());
            oirMode = sp.getInt("clir_key" + this.mPhone.getDefaultPhone().getPhoneId(), 0);
        } else {
            this.loge("dial; could not get default CLIR mode.");
            oirMode = 0;
        }
        return this.dial(dialString, oirMode, videoState, intentExtras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Connection dial(String dialString, int clirMode, int videoState, Bundle intentExtras) throws CallStateException {
        boolean isPhoneInEcmMode = this.isPhoneInEcbMode();
        boolean isEmergencyNumber = this.mPhoneNumberUtilsProxy.isEmergencyNumber(dialString);
        this.log("dial clirMode=" + clirMode);
        if (isEmergencyNumber) {
            clirMode = 2;
            this.log("dial emergency call, set clirModIe=" + clirMode);
        }
        this.clearDisconnected();
        if (this.mImsManager == null) {
            throw new CallStateException("service not available");
        }
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        if (isPhoneInEcmMode && isEmergencyNumber) {
            this.handleEcmTimer(1);
        }
        if (isEmergencyNumber && VideoProfile.isVideo(videoState) && !this.mAllowEmergencyVideoCalls) {
            this.loge("dial: carrier does not support video emergency calls; downgrade to audio-only");
            videoState = 0;
        }
        boolean holdBeforeDial = false;
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            if (this.mBackgroundCall.getState() != Call.State.IDLE) {
                throw new CallStateException("cannot dial in current state");
            }
            holdBeforeDial = true;
            this.mPendingCallVideoState = videoState;
            this.mPendingIntentExtras = intentExtras;
            this.switchWaitingOrHoldingAndActive();
        }
        Call.State fgState = Call.State.IDLE;
        Call.State bgState = Call.State.IDLE;
        this.mClirMode = clirMode;
        Object object = this.mSyncHold;
        synchronized (object) {
            if (holdBeforeDial) {
                fgState = this.mForegroundCall.getState();
                bgState = this.mBackgroundCall.getState();
                if (fgState == Call.State.ACTIVE) {
                    throw new CallStateException("cannot dial in current state");
                }
                if (bgState == Call.State.HOLDING) {
                    holdBeforeDial = false;
                }
            }
            this.mPendingMO = new ImsPhoneConnection((Phone)this.mPhone, this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall, isEmergencyNumber);
            this.mPendingMO.setVideoState(videoState);
        }
        this.addConnection(this.mPendingMO);
        if (!holdBeforeDial) {
            if (!isPhoneInEcmMode || isPhoneInEcmMode && isEmergencyNumber) {
                this.dialInternal(this.mPendingMO, clirMode, videoState, intentExtras);
            } else {
                try {
                    this.getEcbmInterface().exitEmergencyCallbackMode();
                }
                catch (ImsException e) {
                    e.printStackTrace();
                    throw new CallStateException("service not available");
                }
                this.mPhone.setOnEcbModeExitResponse(this, 14, null);
                this.pendingCallClirMode = clirMode;
                this.mPendingCallVideoState = videoState;
                this.pendingCallInEcm = true;
            }
        }
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
        return this.mPendingMO;
    }

    boolean isImsServiceReady() {
        if (this.mImsManager == null) {
            return false;
        }
        return this.mImsManager.isServiceAvailable();
    }

    private void cacheCarrierConfiguration(int subId) {
        CarrierConfigManager carrierConfigManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        if (carrierConfigManager == null) {
            this.loge("cacheCarrierConfiguration: No carrier config service found.");
            return;
        }
        PersistableBundle carrierConfig = carrierConfigManager.getConfigForSubId(subId);
        if (carrierConfig == null) {
            this.loge("cacheCarrierConfiguration: Empty carrier config.");
            return;
        }
        this.mAllowEmergencyVideoCalls = carrierConfig.getBoolean("allow_emergency_video_calls_bool");
        this.mTreatDowngradedVideoCallsAsVideoCalls = carrierConfig.getBoolean("treat_downgraded_video_calls_as_video_calls_bool");
        this.mDropVideoCallWhenAnsweringAudioCall = carrierConfig.getBoolean("drop_video_call_when_answering_audio_call_bool");
        this.mAllowAddCallDuringVideoCall = carrierConfig.getBoolean("allow_add_call_during_video_call");
        this.mNotifyVtHandoverToWifiFail = carrierConfig.getBoolean("notify_vt_handover_to_wifi_failure_bool");
        this.mSupportDowngradeVtToAudio = carrierConfig.getBoolean("support_downgrade_vt_to_audio_bool");
        this.mNotifyHandoverVideoFromWifiToLTE = carrierConfig.getBoolean("notify_handover_video_from_wifi_to_lte_bool");
        this.mIgnoreDataEnabledChangedForVideoCalls = carrierConfig.getBoolean("ignore_data_enabled_changed_for_video_calls");
        this.mIsViLteDataMetered = carrierConfig.getBoolean("vilte_data_is_metered_bool");
        this.mSupportPauseVideo = carrierConfig.getBoolean("support_pause_ims_video_calls_bool");
        String[] mappings = carrierConfig.getStringArray("ims_reasoninfo_mapping_string_array");
        if (mappings != null && mappings.length > 0) {
            for (String mapping : mappings) {
                String[] values = mapping.split(Pattern.quote("|"));
                if (values.length != 3) continue;
                try {
                    Integer fromCode = values[0].equals("*") ? null : Integer.valueOf(Integer.parseInt(values[0]));
                    String message = values[1];
                    int toCode = Integer.parseInt(values[2]);
                    this.addReasonCodeRemapping(fromCode, message, toCode);
                    this.log("Loaded ImsReasonInfo mapping : fromCode = " + fromCode == null ? "any" : fromCode + " ; message = " + message + " ; toCode = " + toCode);
                }
                catch (NumberFormatException nfe) {
                    this.loge("Invalid ImsReasonInfo mapping found: " + mapping);
                }
            }
        } else {
            this.log("No carrier ImsReasonInfo mappings defined.");
        }
    }

    private void handleEcmTimer(int action) {
        this.mPhone.handleTimerInEmergencyCallbackMode(action);
        switch (action) {
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.log("handleEcmTimer, unsupported action " + action);
            }
        }
    }

    private void dialInternal(ImsPhoneConnection conn, int clirMode, int videoState, Bundle intentExtras) {
        if (conn == null) {
            return;
        }
        if (conn.getAddress() == null || conn.getAddress().length() == 0 || conn.getAddress().indexOf(78) >= 0) {
            conn.setDisconnectCause(7);
            this.sendEmptyMessageDelayed(18, 500L);
            return;
        }
        this.setMute(false);
        int serviceType = this.mPhoneNumberUtilsProxy.isEmergencyNumber(conn.getAddress()) ? 2 : 1;
        int callType = ImsCallProfile.getCallTypeFromVideoState(videoState);
        conn.setVideoState(videoState);
        try {
            String[] callees = new String[]{conn.getAddress()};
            ImsCallProfile profile = this.mImsManager.createCallProfile(this.mServiceId, serviceType, callType);
            profile.setCallExtraInt("oir", clirMode);
            if (intentExtras != null) {
                if (intentExtras.containsKey("android.telecom.extra.CALL_SUBJECT")) {
                    intentExtras.putString("DisplayText", this.cleanseInstantLetteringMessage(intentExtras.getString("android.telecom.extra.CALL_SUBJECT")));
                }
                if (intentExtras.containsKey("CallPull")) {
                    profile.mCallExtras.putBoolean("CallPull", intentExtras.getBoolean("CallPull"));
                    int dialogId = intentExtras.getInt("android.telephony.ImsExternalCallTracker.extra.EXTERNAL_CALL_ID");
                    conn.setIsPulledCall(true);
                    conn.setPulledDialogId(dialogId);
                }
                profile.mCallExtras.putBundle("OemCallExtras", intentExtras);
            }
            ImsCall imsCall = this.mImsManager.makeCall(this.mServiceId, profile, callees, this.mImsCallListener);
            conn.setImsCall(imsCall);
            this.mMetrics.writeOnImsCallStart(this.mPhone.getPhoneId(), imsCall.getSession());
            this.setVideoCallProvider(conn, imsCall);
            conn.setAllowAddCallDuringVideoCall(this.mAllowAddCallDuringVideoCall);
        }
        catch (ImsException e) {
            this.loge("dialInternal : " + e);
            conn.setDisconnectCause(36);
            this.sendEmptyMessageDelayed(18, 500L);
            this.retryGetImsService();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void acceptCall(int videoState) throws CallStateException {
        this.log("acceptCall");
        if (this.mForegroundCall.getState().isAlive() && this.mBackgroundCall.getState().isAlive()) {
            throw new CallStateException("cannot accept call");
        }
        if (this.mRingingCall.getState() == Call.State.WAITING && this.mForegroundCall.getState().isAlive()) {
            this.setMute(false);
            boolean answeringWillDisconnect = false;
            ImsCall activeCall = this.mForegroundCall.getImsCall();
            ImsCall ringingCall = this.mRingingCall.getImsCall();
            if (this.mForegroundCall.hasConnections() && this.mRingingCall.hasConnections()) {
                answeringWillDisconnect = this.shouldDisconnectActiveCallOnAnswer(activeCall, ringingCall);
            }
            this.mPendingCallVideoState = videoState;
            if (answeringWillDisconnect) {
                this.mForegroundCall.hangup();
                try {
                    ringingCall.accept(ImsCallProfile.getCallTypeFromVideoState(videoState));
                }
                catch (ImsException e) {
                    throw new CallStateException("cannot accept call");
                }
            } else {
                this.switchWaitingOrHoldingAndActive();
            }
        } else if (this.mRingingCall.getState().isRinging()) {
            this.log("acceptCall: incoming...");
            this.setMute(false);
            try {
                ImsCall imsCall = this.mRingingCall.getImsCall();
                if (imsCall == null) {
                    throw new CallStateException("no valid ims call");
                }
                imsCall.accept(ImsCallProfile.getCallTypeFromVideoState(videoState));
                this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 2);
            }
            catch (ImsException e) {
                throw new CallStateException("cannot accept call");
            }
        } else {
            throw new CallStateException("phone not ringing");
        }
    }

    public void rejectCall() throws CallStateException {
        this.log("rejectCall");
        if (!this.mRingingCall.getState().isRinging()) {
            throw new CallStateException("phone not ringing");
        }
        this.hangup(this.mRingingCall);
    }

    private void switchAfterConferenceSuccess() {
        this.log("switchAfterConferenceSuccess fg =" + (Object)((Object)this.mForegroundCall.getState()) + ", bg = " + (Object)((Object)this.mBackgroundCall.getState()));
        if (this.mBackgroundCall.getState() == Call.State.HOLDING) {
            this.log("switchAfterConferenceSuccess");
            this.mForegroundCall.switchWith(this.mBackgroundCall);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void switchWaitingOrHoldingAndActive() throws CallStateException {
        this.log("switchWaitingOrHoldingAndActive");
        if (this.mRingingCall.getState() == Call.State.INCOMING) {
            throw new CallStateException("cannot be in the incoming state");
        }
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            ImsCall imsCall = this.mForegroundCall.getImsCall();
            if (imsCall == null) {
                throw new CallStateException("no ims call");
            }
            boolean switchingWithWaitingCall = !this.mBackgroundCall.getState().isAlive() && this.mRingingCall != null && this.mRingingCall.getState() == Call.State.WAITING;
            this.mSwitchingFgAndBgCalls = true;
            this.mCallExpectedToResume = switchingWithWaitingCall ? this.mRingingCall.getImsCall() : this.mBackgroundCall.getImsCall();
            this.mForegroundCall.switchWith(this.mBackgroundCall);
            try {
                imsCall.hold();
                this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 5);
                if (this.mCallExpectedToResume != null) return;
                this.log("mCallExpectedToResume is null");
                this.mSwitchingFgAndBgCalls = false;
                return;
            }
            catch (ImsException e) {
                this.mForegroundCall.switchWith(this.mBackgroundCall);
                throw new CallStateException(e.getMessage());
            }
        } else {
            if (this.mBackgroundCall.getState() != Call.State.HOLDING) return;
            this.resumeWaitingOrHolding();
        }
    }

    public void conference() {
        long conferenceConnectTime;
        ImsCall fgImsCall = this.mForegroundCall.getImsCall();
        if (fgImsCall == null) {
            this.log("conference no foreground ims call");
            return;
        }
        ImsCall bgImsCall = this.mBackgroundCall.getImsCall();
        if (bgImsCall == null) {
            this.log("conference no background ims call");
            return;
        }
        if (fgImsCall.isCallSessionMergePending()) {
            this.log("conference: skip; foreground call already in process of merging.");
            return;
        }
        if (bgImsCall.isCallSessionMergePending()) {
            this.log("conference: skip; background call already in process of merging.");
            return;
        }
        long foregroundConnectTime = this.mForegroundCall.getEarliestConnectTime();
        long backgroundConnectTime = this.mBackgroundCall.getEarliestConnectTime();
        if (foregroundConnectTime > 0L && backgroundConnectTime > 0L) {
            conferenceConnectTime = Math.min(this.mForegroundCall.getEarliestConnectTime(), this.mBackgroundCall.getEarliestConnectTime());
            this.log("conference - using connect time = " + conferenceConnectTime);
        } else if (foregroundConnectTime > 0L) {
            this.log("conference - bg call connect time is 0; using fg = " + foregroundConnectTime);
            conferenceConnectTime = foregroundConnectTime;
        } else {
            this.log("conference - fg call connect time is 0; using bg = " + backgroundConnectTime);
            conferenceConnectTime = backgroundConnectTime;
        }
        String foregroundId = "";
        ImsPhoneConnection foregroundConnection = this.mForegroundCall.getFirstConnection();
        if (foregroundConnection != null) {
            foregroundConnection.setConferenceConnectTime(conferenceConnectTime);
            foregroundConnection.handleMergeStart();
            foregroundId = foregroundConnection.getTelecomCallId();
        }
        String backgroundId = "";
        ImsPhoneConnection backgroundConnection = this.findConnection(bgImsCall);
        if (backgroundConnection != null) {
            backgroundConnection.handleMergeStart();
            backgroundId = backgroundConnection.getTelecomCallId();
        }
        this.log("conference: fgCallId=" + foregroundId + ", bgCallId=" + backgroundId);
        try {
            fgImsCall.merge(bgImsCall);
        }
        catch (ImsException e) {
            this.log("conference " + e.getMessage());
        }
    }

    public void explicitCallTransfer() {
    }

    public void clearDisconnected() {
        this.log("clearDisconnected");
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    public boolean canConference() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING && !this.mBackgroundCall.isFull() && !this.mForegroundCall.isFull();
    }

    public boolean canDial() {
        String disableCall = SystemProperties.get("ro.telephony.disable-call", "false");
        boolean ret = this.mPendingMO == null && !this.mRingingCall.isRinging() && !disableCall.equals("true") && (!this.mForegroundCall.getState().isAlive() || !this.mBackgroundCall.getState().isAlive());
        return ret;
    }

    public boolean canTransfer() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING;
    }

    private void internalClearDisconnected() {
        this.mRingingCall.clearDisconnected();
        this.mForegroundCall.clearDisconnected();
        this.mBackgroundCall.clearDisconnected();
        this.mHandoverCall.clearDisconnected();
    }

    private void updatePhoneState() {
        boolean isPendingMOIdle;
        PhoneConstants.State oldState = this.mState;
        boolean bl = isPendingMOIdle = this.mPendingMO == null || !this.mPendingMO.getState().isAlive();
        this.mState = this.mRingingCall.isRinging() ? PhoneConstants.State.RINGING : (!isPendingMOIdle || !this.mForegroundCall.isIdle() || !this.mBackgroundCall.isIdle() ? PhoneConstants.State.OFFHOOK : PhoneConstants.State.IDLE);
        if (this.mState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallEndedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (oldState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallStartedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
        this.log("updatePhoneState pendingMo = " + (this.mPendingMO == null ? "null" : this.mPendingMO.getState()) + ", fg= " + (Object)((Object)this.mForegroundCall.getState()) + "(" + this.mForegroundCall.getConnections().size() + "), bg= " + (Object)((Object)this.mBackgroundCall.getState()) + "(" + this.mBackgroundCall.getConnections().size() + ")");
        this.log("updatePhoneState oldState=" + (Object)((Object)oldState) + ", newState=" + (Object)((Object)this.mState));
        if (this.mState != oldState) {
            this.mPhone.notifyPhoneStateChanged();
            this.mMetrics.writePhoneState(this.mPhone.getPhoneId(), this.mState);
            this.notifyPhoneStateChanged(oldState, this.mState);
        }
    }

    private void handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private void dumpState() {
        int i;
        this.log("Phone State:" + (Object)((Object)this.mState));
        this.log("Ringing call: " + this.mRingingCall.toString());
        List<Connection> l = this.mRingingCall.getConnections();
        int s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
        this.log("Foreground call: " + this.mForegroundCall.toString());
        l = this.mForegroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
        this.log("Background call: " + this.mBackgroundCall.toString());
        l = this.mBackgroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
    }

    public void setTtyMode(int ttyMode) {
        if (this.mImsManager == null) {
            Log.w(LOG_TAG, "ImsManager is null when setting TTY mode");
            return;
        }
        try {
            this.mImsManager.setTtyMode(ttyMode);
        }
        catch (ImsException e) {
            this.loge("setTtyMode : " + e);
            this.retryGetImsService();
        }
    }

    public void setUiTTYMode(int uiTtyMode, Message onComplete) {
        if (this.mImsManager == null) {
            this.mPhone.sendErrorResponse(onComplete, this.getImsManagerIsNullException());
            return;
        }
        try {
            this.mImsManager.setUiTTYMode(this.mPhone.getContext(), uiTtyMode, onComplete);
        }
        catch (ImsException e) {
            this.loge("setUITTYMode : " + e);
            this.mPhone.sendErrorResponse(onComplete, e);
            this.retryGetImsService();
        }
    }

    public void setMute(boolean mute) {
        this.mDesiredMute = mute;
        this.mForegroundCall.setMute(mute);
    }

    public boolean getMute() {
        return this.mDesiredMute;
    }

    public void sendDtmf(char c, Message result) {
        this.log("sendDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.sendDtmf(c, result);
        }
    }

    public void startDtmf(char c) {
        this.log("startDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.startDtmf(c);
        } else {
            this.loge("startDtmf : no foreground call");
        }
    }

    public void stopDtmf() {
        this.log("stopDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.stopDtmf();
        } else {
            this.loge("stopDtmf : no foreground call");
        }
    }

    public void hangup(ImsPhoneConnection conn) throws CallStateException {
        this.log("hangup connection");
        if (conn.getOwner() != this) {
            throw new CallStateException("ImsPhoneConnection " + conn + "does not belong to ImsPhoneCallTracker " + this);
        }
        this.hangup(conn.getCall());
    }

    public void hangup(ImsPhoneCall call) throws CallStateException {
        this.log("hangup call");
        if (call.getConnections().size() == 0) {
            throw new CallStateException("no connections");
        }
        ImsCall imsCall = call.getImsCall();
        boolean rejectCall = false;
        if (call == this.mRingingCall) {
            this.log("(ringing) hangup incoming");
            rejectCall = true;
        } else if (call == this.mForegroundCall) {
            if (call.isDialingOrAlerting()) {
                this.log("(foregnd) hangup dialing or alerting...");
            } else {
                this.log("(foregnd) hangup foreground");
            }
        } else if (call == this.mBackgroundCall) {
            this.log("(backgnd) hangup waiting or background");
        } else {
            throw new CallStateException("ImsPhoneCall " + call + "does not belong to ImsPhoneCallTracker " + this);
        }
        call.onHangupLocal();
        try {
            if (imsCall != null) {
                if (rejectCall) {
                    imsCall.reject(504);
                    this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 3);
                } else {
                    imsCall.terminate(501);
                    this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 4);
                }
            } else if (this.mPendingMO != null && call == this.mForegroundCall) {
                this.mPendingMO.update(null, Call.State.DISCONNECTED);
                this.mPendingMO.onDisconnect();
                this.removeConnection(this.mPendingMO);
                this.mPendingMO = null;
                this.updatePhoneState();
                this.removeMessages(20);
            }
        }
        catch (ImsException e) {
            throw new CallStateException(e.getMessage());
        }
        this.mPhone.notifyPreciseCallStateChanged();
    }

    void callEndCleanupHandOverCallIfAny() {
        if (this.mHandoverCall.mConnections.size() > 0) {
            this.log("callEndCleanupHandOverCallIfAny, mHandoverCall.mConnections=" + this.mHandoverCall.mConnections);
            this.mHandoverCall.mConnections.clear();
            this.mConnections.clear();
            this.mState = PhoneConstants.State.IDLE;
        }
    }

    void resumeWaitingOrHolding() throws CallStateException {
        this.log("resumeWaitingOrHolding");
        try {
            if (this.mForegroundCall.getState().isAlive()) {
                ImsCall imsCall = this.mForegroundCall.getImsCall();
                if (imsCall != null) {
                    imsCall.resume();
                    this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 6);
                }
            } else if (this.mRingingCall.getState() == Call.State.WAITING) {
                ImsCall imsCall = this.mRingingCall.getImsCall();
                if (imsCall != null) {
                    imsCall.accept(ImsCallProfile.getCallTypeFromVideoState(this.mPendingCallVideoState));
                    this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 2);
                }
            } else {
                ImsCall imsCall = this.mBackgroundCall.getImsCall();
                if (imsCall != null) {
                    imsCall.resume();
                    this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 6);
                }
            }
        }
        catch (ImsException e) {
            throw new CallStateException(e.getMessage());
        }
    }

    public void sendUSSD(String ussdString, Message response) {
        this.log("sendUSSD");
        try {
            if (this.mUssdSession != null) {
                this.mUssdSession.sendUssd(ussdString);
                AsyncResult.forMessage(response, null, null);
                response.sendToTarget();
                return;
            }
            if (this.mImsManager == null) {
                this.mPhone.sendErrorResponse(response, this.getImsManagerIsNullException());
                return;
            }
            String[] callees = new String[]{ussdString};
            ImsCallProfile profile = this.mImsManager.createCallProfile(this.mServiceId, 1, 2);
            profile.setCallExtraInt("dialstring", 2);
            this.mUssdSession = this.mImsManager.makeCall(this.mServiceId, profile, callees, this.mImsUssdListener);
        }
        catch (ImsException e) {
            this.loge("sendUSSD : " + e);
            this.mPhone.sendErrorResponse(response, e);
            this.retryGetImsService();
        }
    }

    public void cancelUSSD() {
        if (this.mUssdSession == null) {
            return;
        }
        try {
            this.mUssdSession.terminate(501);
        }
        catch (ImsException imsException) {
            // empty catch block
        }
    }

    private synchronized ImsPhoneConnection findConnection(ImsCall imsCall) {
        for (ImsPhoneConnection conn : this.mConnections) {
            if (conn.getImsCall() != imsCall) continue;
            return conn;
        }
        return null;
    }

    private synchronized void removeConnection(ImsPhoneConnection conn) {
        this.mConnections.remove(conn);
        if (this.mIsInEmergencyCall) {
            boolean isEmergencyCallInList = false;
            for (ImsPhoneConnection imsPhoneConnection : this.mConnections) {
                if (imsPhoneConnection == null || !imsPhoneConnection.isEmergency()) continue;
                isEmergencyCallInList = true;
                break;
            }
            if (!isEmergencyCallInList) {
                this.mIsInEmergencyCall = false;
                this.mPhone.sendEmergencyCallStateChange(false);
            }
        }
    }

    private synchronized void addConnection(ImsPhoneConnection conn) {
        this.mConnections.add(conn);
        if (conn.isEmergency()) {
            this.mIsInEmergencyCall = true;
            this.mPhone.sendEmergencyCallStateChange(true);
        }
    }

    private void processCallStateChange(ImsCall imsCall, Call.State state, int cause) {
        this.log("processCallStateChange " + imsCall + " state=" + (Object)((Object)state) + " cause=" + cause);
        this.processCallStateChange(imsCall, state, cause, false);
    }

    private void processCallStateChange(ImsCall imsCall, Call.State state, int cause, boolean ignoreState) {
        this.log("processCallStateChange state=" + (Object)((Object)state) + " cause=" + cause + " ignoreState=" + ignoreState);
        if (imsCall == null) {
            return;
        }
        boolean changed = false;
        ImsPhoneConnection conn = this.findConnection(imsCall);
        if (conn == null) {
            return;
        }
        conn.updateMediaCapabilities(imsCall);
        if (ignoreState) {
            conn.updateAddressDisplay(imsCall);
            conn.updateExtras(imsCall);
            this.maybeSetVideoCallProvider(conn, imsCall);
            return;
        }
        changed = conn.update(imsCall, state);
        if (state == Call.State.DISCONNECTED) {
            changed = conn.onDisconnect(cause) || changed;
            conn.getCall().detach(conn);
            this.removeConnection(conn);
        }
        if (changed) {
            if (conn.getCall() == this.mHandoverCall) {
                return;
            }
            this.updatePhoneState();
            this.mPhone.notifyPreciseCallStateChanged();
        }
    }

    private void maybeSetVideoCallProvider(ImsPhoneConnection conn, ImsCall imsCall) {
        Connection.VideoProvider connVideoProvider = conn.getVideoProvider();
        if (connVideoProvider != null || imsCall.getCallSession().getVideoCallProvider() == null) {
            return;
        }
        try {
            this.setVideoCallProvider(conn, imsCall);
        }
        catch (RemoteException e) {
            this.loge("maybeSetVideoCallProvider: exception " + e);
        }
    }

    public void addReasonCodeRemapping(Integer fromCode, String message, Integer toCode) {
        this.mImsReasonCodeMap.put(new Pair<Integer, String>(fromCode, message), toCode);
    }

    public int maybeRemapReasonCode(ImsReasonInfo reasonInfo) {
        int code = reasonInfo.getCode();
        Pair<Integer, String> toCheck = new Pair<Integer, String>(code, reasonInfo.getExtraMessage());
        Pair<Object, String> wildcardToCheck = new Pair<Object, String>(null, reasonInfo.getExtraMessage());
        if (this.mImsReasonCodeMap.containsKey(toCheck)) {
            int toCode = this.mImsReasonCodeMap.get(toCheck);
            this.log("maybeRemapReasonCode : fromCode = " + reasonInfo.getCode() + " ; message = " + reasonInfo.getExtraMessage() + " ; toCode = " + toCode);
            return toCode;
        }
        if (this.mImsReasonCodeMap.containsKey(wildcardToCheck)) {
            int toCode = this.mImsReasonCodeMap.get(wildcardToCheck);
            this.log("maybeRemapReasonCode : fromCode(wildcard) = " + reasonInfo.getCode() + " ; message = " + reasonInfo.getExtraMessage() + " ; toCode = " + toCode);
            return toCode;
        }
        return code;
    }

    public int getDisconnectCauseFromReasonInfo(ImsReasonInfo reasonInfo, Call.State callState) {
        int cause = 36;
        int code = this.maybeRemapReasonCode(reasonInfo);
        switch (code) {
            case 337: 
            case 341: {
                return 8;
            }
            case 338: {
                return 4;
            }
            case 501: {
                return 3;
            }
            case 108: {
                return 45;
            }
            case 143: 
            case 1404: {
                return 16;
            }
            case 510: {
                return 2;
            }
            case 332: {
                return 12;
            }
            case 321: 
            case 331: 
            case 340: 
            case 361: 
            case 362: {
                return 12;
            }
            case 333: 
            case 352: 
            case 354: {
                return 9;
            }
            case 106: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 131: 
            case 132: 
            case 144: {
                return 18;
            }
            case 201: 
            case 202: 
            case 203: 
            case 335: {
                return 13;
            }
            case 111: {
                return 17;
            }
            case 112: 
            case 505: {
                if (callState == Call.State.DIALING) {
                    return 62;
                }
                return 61;
            }
            case 241: {
                return 21;
            }
            case 243: {
                return 58;
            }
            case 1014: {
                return 52;
            }
            case 1016: {
                return 51;
            }
            case 1403: {
                return 53;
            }
            case 1406: {
                return 54;
            }
            case 1405: {
                return 55;
            }
            case 1407: {
                return 59;
            }
            case 1512: {
                return 60;
            }
        }
        return cause;
    }

    private int getPreciseDisconnectCauseFromReasonInfo(ImsReasonInfo reasonInfo) {
        return PRECISE_CAUSE_MAP.get(this.maybeRemapReasonCode(reasonInfo), 65535);
    }

    private boolean isPhoneInEcbMode() {
        return this.mPhone.isInEcm();
    }

    private void dialPendingMO() {
        boolean isPhoneInEcmMode = this.isPhoneInEcbMode();
        boolean isEmergencyNumber = this.mPendingMO.isEmergency();
        if (!isPhoneInEcmMode || isPhoneInEcmMode && isEmergencyNumber) {
            this.sendEmptyMessage(20);
        } else {
            this.sendEmptyMessage(21);
        }
    }

    public ImsUtInterface getUtInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw this.getImsManagerIsNullException();
        }
        ImsUtInterface ut = this.mImsManager.getSupplementaryServiceConfiguration();
        return ut;
    }

    private void transferHandoverConnections(ImsPhoneCall call) {
        if (call.mConnections != null) {
            for (Connection c : call.mConnections) {
                c.mPreHandoverState = call.mState;
                this.log("Connection state before handover is " + (Object)((Object)c.getStateBeforeHandover()));
            }
        }
        if (this.mHandoverCall.mConnections == null) {
            this.mHandoverCall.mConnections = call.mConnections;
        } else {
            this.mHandoverCall.mConnections.addAll(call.mConnections);
        }
        if (this.mHandoverCall.mConnections != null) {
            if (call.getImsCall() != null) {
                call.getImsCall().close();
            }
            for (Connection c : this.mHandoverCall.mConnections) {
                ((ImsPhoneConnection)c).changeParent(this.mHandoverCall);
                ((ImsPhoneConnection)c).releaseWakeLock();
            }
        }
        if (call.getState().isAlive()) {
            this.log("Call is alive and state is " + (Object)((Object)call.mState));
            this.mHandoverCall.mState = call.mState;
        }
        call.mConnections.clear();
        call.mState = Call.State.IDLE;
    }

    void notifySrvccState(Call.SrvccState state) {
        this.log("notifySrvccState state=" + (Object)((Object)state));
        this.mSrvccState = state;
        if (this.mSrvccState == Call.SrvccState.COMPLETED) {
            this.transferHandoverConnections(this.mForegroundCall);
            this.transferHandoverConnections(this.mBackgroundCall);
            this.transferHandoverConnections(this.mRingingCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        this.log("handleMessage what=" + msg.what);
        switch (msg.what) {
            case 18: {
                if (this.mPendingMO != null) {
                    this.mPendingMO.onDisconnect();
                    this.removeConnection(this.mPendingMO);
                    this.mPendingMO = null;
                }
                this.mPendingIntentExtras = null;
                this.updatePhoneState();
                this.mPhone.notifyPreciseCallStateChanged();
                break;
            }
            case 19: {
                try {
                    this.resumeWaitingOrHolding();
                }
                catch (CallStateException e) {
                    this.loge("handleMessage EVENT_RESUME_BACKGROUND exception=" + e);
                }
                break;
            }
            case 20: {
                this.dialInternal(this.mPendingMO, this.mClirMode, this.mPendingCallVideoState, this.mPendingIntentExtras);
                this.mPendingIntentExtras = null;
                break;
            }
            case 21: {
                if (this.mPendingMO == null) break;
                try {
                    this.getEcbmInterface().exitEmergencyCallbackMode();
                    this.mPhone.setOnEcbModeExitResponse(this, 14, null);
                    this.pendingCallClirMode = this.mClirMode;
                    this.pendingCallInEcm = true;
                }
                catch (ImsException e) {
                    e.printStackTrace();
                    this.mPendingMO.setDisconnectCause(36);
                    this.sendEmptyMessageDelayed(18, 500L);
                }
                break;
            }
            case 14: {
                if (this.pendingCallInEcm) {
                    this.dialInternal(this.mPendingMO, this.pendingCallClirMode, this.mPendingCallVideoState, this.mPendingIntentExtras);
                    this.mPendingIntentExtras = null;
                    this.pendingCallInEcm = false;
                }
                this.mPhone.unsetOnEcbModeExitResponse(this);
                break;
            }
            case 22: {
                AsyncResult ar = (AsyncResult)msg.obj;
                ImsCall call = (ImsCall)ar.userObj;
                Long usage = (long)((Long)ar.result);
                this.log("VT data usage update. usage = " + usage + ", imsCall = " + call);
                if (usage <= 0L) break;
                this.updateVtDataUsage(call, usage);
                break;
            }
            case 23: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (!(ar.result instanceof Pair)) break;
                Pair p = (Pair)ar.result;
                this.onDataEnabledChanged((Boolean)p.first, (Integer)p.second);
                break;
            }
            case 24: {
                try {
                    this.getImsService();
                }
                catch (ImsException e) {
                    this.loge("getImsService: " + e);
                    this.retryGetImsService();
                }
                break;
            }
            case 25: {
                ImsPhoneConnection conn;
                ImsCall imsCall;
                if (!(msg.obj instanceof ImsCall) || (imsCall = (ImsCall)msg.obj).isWifiCall() || (conn = this.findConnection(imsCall)) == null) break;
                conn.onHandoverToWifiFailed();
                break;
            }
            case 26: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    int serviceClass = args.argi1;
                    int[] enabledFeatures = (int[])args.arg1;
                    int[] disabledFeatures = (int[])args.arg2;
                    this.handleFeatureCapabilityChanged(serviceClass, enabledFeatures, disabledFeatures);
                    break;
                }
                finally {
                    args.recycle();
                }
            }
        }
    }

    private void updateVtDataUsage(ImsCall call, long dataUsage) {
        long oldUsage = 0L;
        if (this.mVtDataUsageMap.containsKey(call.uniqueId)) {
            oldUsage = this.mVtDataUsageMap.get(call.uniqueId);
        }
        long delta = dataUsage - oldUsage;
        this.mVtDataUsageMap.put(call.uniqueId, dataUsage);
        this.log("updateVtDataUsage: call=" + call + ", delta=" + delta);
        long currentTime = SystemClock.elapsedRealtime();
        int isRoaming = this.mPhone.getServiceState().getDataRoaming() ? 1 : 0;
        NetworkStats vtDataUsageSnapshot = new NetworkStats(currentTime, 1);
        vtDataUsageSnapshot.combineAllValues(this.mVtDataUsageSnapshot);
        vtDataUsageSnapshot.combineValues(new NetworkStats.Entry("vt_data0", -1, 1, 0, 1, isRoaming, delta / 2L, 0L, delta / 2L, 0L, 0L));
        this.mVtDataUsageSnapshot = vtDataUsageSnapshot;
        NetworkStats vtDataUsageUidSnapshot = new NetworkStats(currentTime, 1);
        vtDataUsageUidSnapshot.combineAllValues(this.mVtDataUsageUidSnapshot);
        if (this.mDefaultDialerUid.get() == -1) {
            TelecomManager telecomManager = (TelecomManager)this.mPhone.getContext().getSystemService("telecom");
            this.mDefaultDialerUid.set(this.getPackageUid(this.mPhone.getContext(), telecomManager.getDefaultDialerPackage()));
        }
        vtDataUsageUidSnapshot.combineValues(new NetworkStats.Entry("vt_data0", this.mDefaultDialerUid.get(), 1, 0, 1, isRoaming, delta / 2L, 0L, delta / 2L, 0L, 0L));
        this.mVtDataUsageUidSnapshot = vtDataUsageUidSnapshot;
    }

    @Override
    protected void log(String msg) {
        Rlog.d(LOG_TAG, "[ImsPhoneCallTracker] " + msg);
    }

    protected void loge(String msg) {
        Rlog.e(LOG_TAG, "[ImsPhoneCallTracker] " + msg);
    }

    void logState() {
        if (!VERBOSE_STATE_LOGGING) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Current IMS PhoneCall State:\n");
        sb.append(" Foreground: ");
        sb.append(this.mForegroundCall);
        sb.append("\n");
        sb.append(" Background: ");
        sb.append(this.mBackgroundCall);
        sb.append("\n");
        sb.append(" Ringing: ");
        sb.append(this.mRingingCall);
        sb.append("\n");
        sb.append(" Handover: ");
        sb.append(this.mHandoverCall);
        sb.append("\n");
        Rlog.v(LOG_TAG, sb.toString());
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ImsPhoneCallTracker extends:");
        super.dump(fd, pw, args);
        pw.println(" mVoiceCallEndedRegistrants=" + this.mVoiceCallEndedRegistrants);
        pw.println(" mVoiceCallStartedRegistrants=" + this.mVoiceCallStartedRegistrants);
        pw.println(" mRingingCall=" + this.mRingingCall);
        pw.println(" mForegroundCall=" + this.mForegroundCall);
        pw.println(" mBackgroundCall=" + this.mBackgroundCall);
        pw.println(" mHandoverCall=" + this.mHandoverCall);
        pw.println(" mPendingMO=" + this.mPendingMO);
        pw.println(" mPhone=" + this.mPhone);
        pw.println(" mDesiredMute=" + this.mDesiredMute);
        pw.println(" mState=" + (Object)((Object)this.mState));
        for (int i = 0; i < this.mImsFeatureEnabled.length; ++i) {
            pw.println(" " + this.mImsFeatureStrings[i] + ": " + (this.mImsFeatureEnabled[i] ? "enabled" : "disabled"));
        }
        pw.println(" mDefaultDialerUid=" + this.mDefaultDialerUid.get());
        pw.println(" mVtDataUsageSnapshot=" + this.mVtDataUsageSnapshot);
        pw.println(" mVtDataUsageUidSnapshot=" + this.mVtDataUsageUidSnapshot);
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            if (this.mImsManager != null) {
                this.mImsManager.dump(fd, pw, args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mConnections != null && this.mConnections.size() > 0) {
            pw.println("mConnections:");
            for (int i = 0; i < this.mConnections.size(); ++i) {
                pw.println("  [" + i + "]: " + this.mConnections.get(i));
            }
        }
    }

    @Override
    protected void handlePollCalls(AsyncResult ar) {
    }

    ImsEcbm getEcbmInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw this.getImsManagerIsNullException();
        }
        ImsEcbm ecbm = this.mImsManager.getEcbmInterface(this.mServiceId);
        return ecbm;
    }

    ImsMultiEndpoint getMultiEndpointInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw this.getImsManagerIsNullException();
        }
        try {
            return this.mImsManager.getMultiEndpointInterface(this.mServiceId);
        }
        catch (ImsException e) {
            if (e.getCode() == 902) {
                return null;
            }
            throw e;
        }
    }

    public boolean isInEmergencyCall() {
        return this.mIsInEmergencyCall;
    }

    public boolean isVolteEnabled() {
        return this.mImsFeatureEnabled[0];
    }

    public boolean isVowifiEnabled() {
        return this.mImsFeatureEnabled[2];
    }

    public boolean isVideoCallEnabled() {
        return this.mImsFeatureEnabled[1] || this.mImsFeatureEnabled[3];
    }

    @Override
    public PhoneConstants.State getState() {
        return this.mState;
    }

    private void retryGetImsService() {
        if (this.mImsManager.isServiceAvailable()) {
            return;
        }
        this.mImsManager = null;
        this.loge("getImsService: Retrying getting ImsService...");
        this.removeMessages(24);
        this.sendEmptyMessageDelayed(24, this.mRetryTimeout.get());
    }

    private void setVideoCallProvider(ImsPhoneConnection conn, ImsCall imsCall) throws RemoteException {
        IImsVideoCallProvider imsVideoCallProvider = imsCall.getCallSession().getVideoCallProvider();
        if (imsVideoCallProvider != null) {
            boolean useVideoPauseWorkaround = this.mPhone.getContext().getResources().getBoolean(17957048);
            ImsVideoCallProviderWrapper imsVideoCallProviderWrapper = new ImsVideoCallProviderWrapper(imsVideoCallProvider);
            if (useVideoPauseWorkaround) {
                imsVideoCallProviderWrapper.setUseVideoPauseWorkaround(useVideoPauseWorkaround);
            }
            conn.setVideoProvider(imsVideoCallProviderWrapper);
            imsVideoCallProviderWrapper.registerForDataUsageUpdate(this, 22, imsCall);
            imsVideoCallProviderWrapper.addImsVideoProviderCallback(conn);
        }
    }

    public boolean isUtEnabled() {
        return this.mImsFeatureEnabled[4] || this.mImsFeatureEnabled[5];
    }

    private String cleanseInstantLetteringMessage(String callSubject) {
        String escapedCharacters;
        if (TextUtils.isEmpty(callSubject)) {
            return callSubject;
        }
        CarrierConfigManager configMgr = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        if (configMgr == null) {
            return callSubject;
        }
        PersistableBundle carrierConfig = configMgr.getConfigForSubId(this.mPhone.getSubId());
        if (carrierConfig == null) {
            return callSubject;
        }
        String invalidCharacters = carrierConfig.getString("carrier_instant_lettering_invalid_chars_string");
        if (!TextUtils.isEmpty(invalidCharacters)) {
            callSubject = callSubject.replaceAll(invalidCharacters, "");
        }
        if (!TextUtils.isEmpty(escapedCharacters = carrierConfig.getString("carrier_instant_lettering_escaped_chars_string"))) {
            callSubject = this.escapeChars(escapedCharacters, callSubject);
        }
        return callSubject;
    }

    private String escapeChars(String toEscape, String source) {
        StringBuilder escaped = new StringBuilder();
        for (char c : source.toCharArray()) {
            if (toEscape.contains(Character.toString(c))) {
                escaped.append("\\");
            }
            escaped.append(c);
        }
        return escaped.toString();
    }

    @Override
    public void pullExternalCall(String number, int videoState, int dialogId) {
        Bundle extras = new Bundle();
        extras.putBoolean("CallPull", true);
        extras.putInt("android.telephony.ImsExternalCallTracker.extra.EXTERNAL_CALL_ID", dialogId);
        try {
            Connection connection = this.dial(number, videoState, extras);
            this.mPhone.notifyUnknownConnection(connection);
        }
        catch (CallStateException e) {
            this.loge("pullExternalCall failed - " + e);
        }
    }

    private ImsException getImsManagerIsNullException() {
        return new ImsException("no ims manager", 102);
    }

    /*
     * Unable to fully structure code
     */
    private boolean shouldDisconnectActiveCallOnAnswer(ImsCall activeCall, ImsCall incomingCall) {
        if (activeCall == null || incomingCall == null) {
            return false;
        }
        if (!this.mDropVideoCallWhenAnsweringAudioCall) {
            return false;
        }
        isActiveCallVideo = activeCall.isVideoCall() != false || this.mTreatDowngradedVideoCallsAsVideoCalls != false && activeCall.wasVideoCall() != false;
        isActiveCallOnWifi = activeCall.isWifiCall();
        if (!ImsManager.isWfcEnabledByPlatform(this.mPhone.getContext())) ** GOTO lbl-1000
        if (ImsManager.isWfcEnabledByUser(this.mPhone.getContext())) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isVoWifiEnabled = v0;
        isIncomingCallAudio = incomingCall.isVideoCall() == false;
        this.log("shouldDisconnectActiveCallOnAnswer : isActiveCallVideo=" + isActiveCallVideo + " isActiveCallOnWifi=" + isActiveCallOnWifi + " isIncomingCallAudio=" + isIncomingCallAudio + " isVowifiEnabled=" + isVoWifiEnabled);
        return isActiveCallVideo != false && isActiveCallOnWifi != false && isIncomingCallAudio != false && isVoWifiEnabled == false;
    }

    public NetworkStats getVtDataUsage(boolean perUidStats) {
        if (this.mState != PhoneConstants.State.IDLE) {
            for (ImsPhoneConnection conn : this.mConnections) {
                Connection.VideoProvider videoProvider = conn.getVideoProvider();
                if (videoProvider == null) continue;
                videoProvider.onRequestConnectionDataUsage();
            }
        }
        return perUidStats ? this.mVtDataUsageUidSnapshot : this.mVtDataUsageSnapshot;
    }

    public void registerPhoneStateListener(PhoneStateListener listener) {
        this.mPhoneStateListeners.add(listener);
    }

    public void unregisterPhoneStateListener(PhoneStateListener listener) {
        this.mPhoneStateListeners.remove(listener);
    }

    private void notifyPhoneStateChanged(PhoneConstants.State oldState, PhoneConstants.State newState) {
        for (PhoneStateListener listener : this.mPhoneStateListeners) {
            listener.onPhoneStateChanged(oldState, newState);
        }
    }

    private void modifyVideoCall(ImsCall imsCall, int newVideoState) {
        ImsPhoneConnection conn = this.findConnection(imsCall);
        if (conn != null) {
            int oldVideoState = conn.getVideoState();
            if (conn.getVideoProvider() != null) {
                conn.getVideoProvider().onSendSessionModifyRequest(new VideoProfile(oldVideoState), new VideoProfile(newVideoState));
            }
        }
    }

    private void onDataEnabledChanged(boolean enabled, int reason) {
        this.log("onDataEnabledChanged: enabled=" + enabled + ", reason=" + reason);
        ImsManager.getInstance(this.mPhone.getContext(), this.mPhone.getPhoneId()).setDataEnabled(enabled);
        this.mIsDataEnabled = enabled;
        if (!this.mIsViLteDataMetered) {
            this.log("Ignore data " + (enabled ? "enabled" : "disabled") + " - carrier policy " + "indicates that data is not metered for ViLTE calls.");
            return;
        }
        for (ImsPhoneConnection conn : this.mConnections) {
            conn.handleDataEnabledChange(enabled);
        }
        int reasonCode = reason == 3 ? 1405 : (reason == 2 ? 1406 : 1406);
        this.maybeNotifyDataDisabled(enabled, reasonCode);
        this.handleDataEnabledChange(enabled, reasonCode);
        if (!this.mShouldUpdateImsConfigOnDisconnect && reason != 0) {
            ImsManager.updateImsServiceConfig(this.mPhone.getContext(), this.mPhone.getPhoneId(), true);
        }
    }

    private void maybeNotifyDataDisabled(boolean enabled, int reasonCode) {
        if (!enabled) {
            for (ImsPhoneConnection conn : this.mConnections) {
                ImsCall imsCall = conn.getImsCall();
                if (imsCall == null || !imsCall.isVideoCall() || imsCall.isWifiCall() || !conn.hasCapabilities(3)) continue;
                if (reasonCode == 1406) {
                    conn.onConnectionEvent("android.telephony.event.EVENT_DOWNGRADE_DATA_DISABLED", null);
                    continue;
                }
                if (reasonCode != 1405) continue;
                conn.onConnectionEvent("android.telephony.event.EVENT_DOWNGRADE_DATA_LIMIT_REACHED", null);
            }
        }
    }

    private void handleDataEnabledChange(boolean enabled, int reasonCode) {
        if (!enabled) {
            for (ImsPhoneConnection conn : this.mConnections) {
                ImsCall imsCall = conn.getImsCall();
                if (imsCall == null || !imsCall.isVideoCall() || imsCall.isWifiCall()) continue;
                this.log("handleDataEnabledChange - downgrading " + conn);
                this.downgradeVideoCall(reasonCode, conn);
            }
        } else if (this.mSupportPauseVideo) {
            for (ImsPhoneConnection conn : this.mConnections) {
                this.log("handleDataEnabledChange - resuming " + conn);
                if (!VideoProfile.isPaused(conn.getVideoState()) || !conn.wasVideoPausedFromSource(2)) continue;
                conn.resumeVideo(2);
            }
            this.mShouldUpdateImsConfigOnDisconnect = false;
        }
    }

    private void downgradeVideoCall(int reasonCode, ImsPhoneConnection conn) {
        ImsCall imsCall = conn.getImsCall();
        if (imsCall != null) {
            if (conn.hasCapabilities(3)) {
                this.modifyVideoCall(imsCall, 0);
            } else if (this.mSupportPauseVideo && reasonCode != 1407) {
                this.mShouldUpdateImsConfigOnDisconnect = true;
                conn.pauseVideo(2);
            } else {
                try {
                    imsCall.terminate(501, reasonCode);
                }
                catch (ImsException ie) {
                    this.loge("Couldn't terminate call " + imsCall);
                }
            }
        }
    }

    private void resetImsCapabilities() {
        this.log("Resetting Capabilities...");
        for (int i = 0; i < this.mImsFeatureEnabled.length; ++i) {
            this.mImsFeatureEnabled[i] = false;
        }
    }

    private boolean isWifiConnected() {
        NetworkInfo ni;
        ConnectivityManager cm = (ConnectivityManager)this.mPhone.getContext().getSystemService("connectivity");
        if (cm != null && (ni = cm.getActiveNetworkInfo()) != null && ni.isConnected()) {
            return ni.getType() == 1;
        }
        return false;
    }

    public boolean isCarrierDowngradeOfVtCallSupported() {
        return this.mSupportDowngradeVtToAudio;
    }

    private void handleFeatureCapabilityChanged(int serviceClass, int[] enabledFeatures, int[] disabledFeatures) {
        if (serviceClass == 1) {
            boolean tmpIsVideoCallEnabled = this.isVideoCallEnabled();
            StringBuilder sb = new StringBuilder(120);
            sb.append("handleFeatureCapabilityChanged: ");
            for (int i = 0; i <= 5 && i < enabledFeatures.length; ++i) {
                if (enabledFeatures[i] == i) {
                    sb.append(this.mImsFeatureStrings[i]);
                    sb.append(":true ");
                    this.mImsFeatureEnabled[i] = true;
                    continue;
                }
                if (enabledFeatures[i] == -1) {
                    sb.append(this.mImsFeatureStrings[i]);
                    sb.append(":false ");
                    this.mImsFeatureEnabled[i] = false;
                    continue;
                }
                this.loge("handleFeatureCapabilityChanged(" + i + ", " + this.mImsFeatureStrings[i] + "): unexpectedValue=" + enabledFeatures[i]);
            }
            boolean isVideoEnabled = this.isVideoCallEnabled();
            boolean isVideoEnabledStatechanged = tmpIsVideoCallEnabled != isVideoEnabled;
            sb.append(" isVideoEnabledStateChanged=");
            sb.append(isVideoEnabledStatechanged);
            if (isVideoEnabledStatechanged) {
                this.log("handleFeatureCapabilityChanged - notifyForVideoCapabilityChanged=" + isVideoEnabled);
                this.mPhone.notifyForVideoCapabilityChanged(isVideoEnabled);
            }
            this.log(sb.toString());
            this.log("handleFeatureCapabilityChanged: isVolteEnabled=" + this.isVolteEnabled() + ", isVideoCallEnabled=" + this.isVideoCallEnabled() + ", isVowifiEnabled=" + this.isVowifiEnabled() + ", isUtEnabled=" + this.isUtEnabled());
            this.mPhone.onFeatureCapabilityChanged();
            this.mMetrics.writeOnImsCapabilities(this.mPhone.getPhoneId(), this.mImsFeatureEnabled);
        }
    }

    static {
        PRECISE_CAUSE_MAP.append(101, 1200);
        PRECISE_CAUSE_MAP.append(102, 1201);
        PRECISE_CAUSE_MAP.append(103, 1202);
        PRECISE_CAUSE_MAP.append(106, 1203);
        PRECISE_CAUSE_MAP.append(107, 1204);
        PRECISE_CAUSE_MAP.append(108, 16);
        PRECISE_CAUSE_MAP.append(111, 1205);
        PRECISE_CAUSE_MAP.append(112, 1206);
        PRECISE_CAUSE_MAP.append(121, 1207);
        PRECISE_CAUSE_MAP.append(122, 1208);
        PRECISE_CAUSE_MAP.append(123, 1209);
        PRECISE_CAUSE_MAP.append(124, 1210);
        PRECISE_CAUSE_MAP.append(131, 1211);
        PRECISE_CAUSE_MAP.append(132, 1212);
        PRECISE_CAUSE_MAP.append(141, 1213);
        PRECISE_CAUSE_MAP.append(143, 1214);
        PRECISE_CAUSE_MAP.append(144, 1215);
        PRECISE_CAUSE_MAP.append(145, 1216);
        PRECISE_CAUSE_MAP.append(146, 1217);
        PRECISE_CAUSE_MAP.append(147, 1218);
        PRECISE_CAUSE_MAP.append(148, 1219);
        PRECISE_CAUSE_MAP.append(149, 1220);
        PRECISE_CAUSE_MAP.append(201, 1221);
        PRECISE_CAUSE_MAP.append(202, 1222);
        PRECISE_CAUSE_MAP.append(203, 1223);
        PRECISE_CAUSE_MAP.append(241, 241);
        PRECISE_CAUSE_MAP.append(321, 1300);
        PRECISE_CAUSE_MAP.append(331, 1310);
        PRECISE_CAUSE_MAP.append(332, 1311);
        PRECISE_CAUSE_MAP.append(333, 1312);
        PRECISE_CAUSE_MAP.append(334, 1313);
        PRECISE_CAUSE_MAP.append(335, 1314);
        PRECISE_CAUSE_MAP.append(336, 1315);
        PRECISE_CAUSE_MAP.append(337, 1316);
        PRECISE_CAUSE_MAP.append(338, 1317);
        PRECISE_CAUSE_MAP.append(339, 1318);
        PRECISE_CAUSE_MAP.append(340, 1319);
        PRECISE_CAUSE_MAP.append(341, 1320);
        PRECISE_CAUSE_MAP.append(342, 1321);
        PRECISE_CAUSE_MAP.append(351, 1330);
        PRECISE_CAUSE_MAP.append(352, 1331);
        PRECISE_CAUSE_MAP.append(353, 1332);
        PRECISE_CAUSE_MAP.append(354, 1333);
        PRECISE_CAUSE_MAP.append(361, 1340);
        PRECISE_CAUSE_MAP.append(362, 1341);
        PRECISE_CAUSE_MAP.append(363, 1342);
        PRECISE_CAUSE_MAP.append(364, 1343);
        PRECISE_CAUSE_MAP.append(401, 1400);
        PRECISE_CAUSE_MAP.append(402, 1401);
        PRECISE_CAUSE_MAP.append(403, 1402);
        PRECISE_CAUSE_MAP.append(404, 1403);
        PRECISE_CAUSE_MAP.append(501, 1500);
        PRECISE_CAUSE_MAP.append(502, 1501);
        PRECISE_CAUSE_MAP.append(503, 1502);
        PRECISE_CAUSE_MAP.append(504, 1503);
        PRECISE_CAUSE_MAP.append(505, 1504);
        PRECISE_CAUSE_MAP.append(506, 1505);
        PRECISE_CAUSE_MAP.append(510, 1510);
        PRECISE_CAUSE_MAP.append(801, 1800);
        PRECISE_CAUSE_MAP.append(802, 1801);
        PRECISE_CAUSE_MAP.append(803, 1802);
        PRECISE_CAUSE_MAP.append(804, 1803);
        PRECISE_CAUSE_MAP.append(821, 1804);
        PRECISE_CAUSE_MAP.append(901, 1900);
        PRECISE_CAUSE_MAP.append(902, 1901);
        PRECISE_CAUSE_MAP.append(1100, 2000);
        PRECISE_CAUSE_MAP.append(1014, 2100);
        PRECISE_CAUSE_MAP.append(1015, 2101);
        PRECISE_CAUSE_MAP.append(1016, 2102);
        PRECISE_CAUSE_MAP.append(1201, 2300);
        PRECISE_CAUSE_MAP.append(1202, 2301);
        PRECISE_CAUSE_MAP.append(1203, 2302);
        PRECISE_CAUSE_MAP.append(1300, 2400);
        PRECISE_CAUSE_MAP.append(1400, 2500);
        PRECISE_CAUSE_MAP.append(1401, 2501);
        PRECISE_CAUSE_MAP.append(1402, 2502);
        PRECISE_CAUSE_MAP.append(1403, 2503);
        PRECISE_CAUSE_MAP.append(1404, 2504);
        PRECISE_CAUSE_MAP.append(1405, 2505);
        PRECISE_CAUSE_MAP.append(1406, 2506);
        PRECISE_CAUSE_MAP.append(1407, 2507);
        PRECISE_CAUSE_MAP.append(1500, 247);
        PRECISE_CAUSE_MAP.append(1501, 249);
        PRECISE_CAUSE_MAP.append(1502, 250);
        PRECISE_CAUSE_MAP.append(1503, 251);
        PRECISE_CAUSE_MAP.append(1504, 252);
        PRECISE_CAUSE_MAP.append(1505, 253);
        PRECISE_CAUSE_MAP.append(1506, 254);
        PRECISE_CAUSE_MAP.append(1507, 255);
        PRECISE_CAUSE_MAP.append(1508, 256);
        PRECISE_CAUSE_MAP.append(1509, 257);
        PRECISE_CAUSE_MAP.append(1510, 258);
        PRECISE_CAUSE_MAP.append(1511, 259);
        PRECISE_CAUSE_MAP.append(1512, 260);
        PRECISE_CAUSE_MAP.append(1513, 261);
        PRECISE_CAUSE_MAP.append(61441, 61441);
        PRECISE_CAUSE_MAP.append(61442, 61442);
        PRECISE_CAUSE_MAP.append(61443, 61443);
        PRECISE_CAUSE_MAP.append(61444, 61444);
        PRECISE_CAUSE_MAP.append(61445, 61445);
        PRECISE_CAUSE_MAP.append(61446, 61446);
        PRECISE_CAUSE_MAP.append(61447, 61447);
        PRECISE_CAUSE_MAP.append(61448, 61448);
        PRECISE_CAUSE_MAP.append(61449, 61449);
        PRECISE_CAUSE_MAP.append(61450, 61450);
        PRECISE_CAUSE_MAP.append(61451, 61451);
        PRECISE_CAUSE_MAP.append(61452, 61452);
        PRECISE_CAUSE_MAP.append(61453, 61453);
        PRECISE_CAUSE_MAP.append(61454, 61454);
        PRECISE_CAUSE_MAP.append(61455, 61455);
    }

    public static interface IRetryTimeout {
        public int get();
    }

    public static interface PhoneNumberUtilsProxy {
        public boolean isEmergencyNumber(String var1);
    }

    public static interface SharedPreferenceProxy {
        public SharedPreferences getDefaultSharedPreferences(Context var1);
    }

    public static interface PhoneStateListener {
        public void onPhoneStateChanged(PhoneConstants.State var1, PhoneConstants.State var2);
    }
}

