/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.IPackageManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Pair;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.ims.internal.IImsServiceController;
import com.android.ims.internal.IImsServiceFeatureListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ImsServiceController {
    private static final String LOG_TAG = "ImsServiceController";
    private static final int REBIND_RETRY_TIME = 5000;
    private final Context mContext;
    private final ComponentName mComponentName;
    private final Object mLock = new Object();
    private final HandlerThread mHandlerThread = new HandlerThread("ImsServiceControllerHandler");
    private final IPackageManager mPackageManager;
    private ImsServiceControllerCallbacks mCallbacks;
    private Handler mHandler;
    private boolean mIsBound = false;
    private boolean mIsBinding = false;
    private HashSet<Pair<Integer, Integer>> mImsFeatures;
    private IImsServiceController mIImsServiceController;
    private IBinder mImsServiceControllerBinder;
    private ImsServiceConnection mImsServiceConnection;
    private ImsDeathRecipient mImsDeathRecipient;
    private Set<IImsServiceFeatureListener> mImsStatusCallbacks = new HashSet<IImsServiceFeatureListener>();
    private Set<ImsFeatureStatusCallback> mFeatureStatusCallbacks = new HashSet<ImsFeatureStatusCallback>();
    private Runnable mRestartImsServiceRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = ImsServiceController.this.mLock;
            synchronized (object) {
                if (ImsServiceController.this.mIsBound) {
                    return;
                }
                ImsServiceController.this.bind(ImsServiceController.this.mImsFeatures);
            }
        }
    };
    private RebindRetry mRebindRetry = () -> 5000L;

    public void setRebindRetryTime(RebindRetry retry) {
        this.mRebindRetry = retry;
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public ImsServiceController(Context context, ComponentName componentName, ImsServiceControllerCallbacks callbacks) {
        this.mContext = context;
        this.mComponentName = componentName;
        this.mCallbacks = callbacks;
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mPackageManager = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
    }

    public ImsServiceController(Context context, ComponentName componentName, ImsServiceControllerCallbacks callbacks, Handler testHandler) {
        this.mContext = context;
        this.mComponentName = componentName;
        this.mCallbacks = callbacks;
        this.mHandler = testHandler;
        this.mPackageManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind(HashSet<Pair<Integer, Integer>> imsFeatureSet) {
        Object object = this.mLock;
        synchronized (object) {
            this.mHandler.removeCallbacks(this.mRestartImsServiceRunnable);
            if (!this.mIsBound && !this.mIsBinding) {
                this.mIsBinding = true;
                this.mImsFeatures = imsFeatureSet;
                Intent imsServiceIntent = new Intent("android.telephony.ims.ImsService").setComponent(this.mComponentName);
                this.mImsServiceConnection = new ImsServiceConnection();
                int serviceFlags = 0x4000041;
                Log.i(LOG_TAG, "Binding ImsService:" + this.mComponentName);
                try {
                    return this.mContext.bindService(imsServiceIntent, this.mImsServiceConnection, serviceFlags);
                }
                catch (Exception e) {
                    Log.e(LOG_TAG, "Error binding (" + this.mComponentName + ") with exception: " + e.getMessage());
                    return false;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.mHandler.removeCallbacks(this.mRestartImsServiceRunnable);
            if (this.mImsServiceConnection == null || this.mImsDeathRecipient == null) {
                return;
            }
            this.changeImsServiceFeatures(new HashSet<Pair<Integer, Integer>>());
            this.removeImsServiceFeatureListener();
            this.mImsServiceControllerBinder.unlinkToDeath(this.mImsDeathRecipient, 0);
            Log.i(LOG_TAG, "Unbinding ImsService: " + this.mComponentName);
            this.mContext.unbindService(this.mImsServiceConnection);
            this.cleanUpService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeImsServiceFeatures(HashSet<Pair<Integer, Integer>> newImsFeatures) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsBound) {
                HashSet<Pair<Integer, Integer>> newFeatures = new HashSet<Pair<Integer, Integer>>(newImsFeatures);
                newFeatures.removeAll(this.mImsFeatures);
                for (Pair<Integer, Integer> i : newFeatures) {
                    this.addImsServiceFeature(i);
                }
                HashSet<Pair<Integer, Integer>> oldFeatures = new HashSet<Pair<Integer, Integer>>(this.mImsFeatures);
                oldFeatures.removeAll(newImsFeatures);
                for (Pair<Integer, Integer> i : oldFeatures) {
                    this.removeImsServiceFeature(i);
                }
            }
            Log.i(LOG_TAG, "Features changed (" + this.mImsFeatures + "->" + newImsFeatures + ") for " + "ImsService: " + this.mComponentName);
            this.mImsFeatures = newImsFeatures;
        }
    }

    public IImsServiceController getImsServiceController() {
        return this.mIImsServiceController;
    }

    public IBinder getImsServiceControllerBinder() {
        return this.mImsServiceControllerBinder;
    }

    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImsServiceFeatureListener(IImsServiceFeatureListener callback) {
        Object object = this.mLock;
        synchronized (object) {
            this.mImsStatusCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeImsServiceFeatureListener() {
        Object object = this.mLock;
        synchronized (object) {
            this.mImsStatusCallbacks.clear();
        }
    }

    private void startDelayedRebindToService() {
        if (!this.mHandler.hasCallbacks(this.mRestartImsServiceRunnable)) {
            this.mHandler.postDelayed(this.mRestartImsServiceRunnable, this.mRebindRetry.getRetryTimeout());
        }
    }

    private void grantPermissionsToService() {
        Log.i(LOG_TAG, "Granting Runtime permissions to:" + this.getComponentName());
        String[] pkgToGrant = new String[]{this.mComponentName.getPackageName()};
        try {
            if (this.mPackageManager != null) {
                this.mPackageManager.grantDefaultPermissionsToEnabledImsServices(pkgToGrant, this.mContext.getUserId());
            }
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Unable to grant permissions, binder died.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendImsFeatureCreatedCallback(int slot, int feature) {
        Object object = this.mLock;
        synchronized (object) {
            Iterator<IImsServiceFeatureListener> i = this.mImsStatusCallbacks.iterator();
            while (i.hasNext()) {
                IImsServiceFeatureListener callbacks = i.next();
                try {
                    callbacks.imsFeatureCreated(slot, feature);
                }
                catch (RemoteException e) {
                    Log.w(LOG_TAG, "sendImsFeatureCreatedCallback: Binder died, removing callback. Exception:" + e.getMessage());
                    i.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendImsFeatureRemovedCallback(int slot, int feature) {
        Object object = this.mLock;
        synchronized (object) {
            Iterator<IImsServiceFeatureListener> i = this.mImsStatusCallbacks.iterator();
            while (i.hasNext()) {
                IImsServiceFeatureListener callbacks = i.next();
                try {
                    callbacks.imsFeatureRemoved(slot, feature);
                }
                catch (RemoteException e) {
                    Log.w(LOG_TAG, "sendImsFeatureRemovedCallback: Binder died, removing callback. Exception:" + e.getMessage());
                    i.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendImsFeatureStatusChanged(int slot, int feature, int status) {
        Object object = this.mLock;
        synchronized (object) {
            Iterator<IImsServiceFeatureListener> i = this.mImsStatusCallbacks.iterator();
            while (i.hasNext()) {
                IImsServiceFeatureListener callbacks = i.next();
                try {
                    callbacks.imsStatusChanged(slot, feature, status);
                }
                catch (RemoteException e) {
                    Log.w(LOG_TAG, "sendImsFeatureStatusChanged: Binder died, removing callback. Exception:" + e.getMessage());
                    i.remove();
                }
            }
        }
    }

    private void addImsServiceFeature(Pair<Integer, Integer> featurePair) throws RemoteException {
        if (this.mIImsServiceController == null || this.mCallbacks == null) {
            Log.w(LOG_TAG, "addImsServiceFeature called with null values.");
            return;
        }
        ImsFeatureStatusCallback c = new ImsFeatureStatusCallback((Integer)featurePair.first, (Integer)featurePair.second);
        this.mFeatureStatusCallbacks.add(c);
        this.mIImsServiceController.createImsFeature((Integer)featurePair.first, (Integer)featurePair.second, c.getCallback());
        this.mCallbacks.imsServiceFeatureCreated((Integer)featurePair.first, (Integer)featurePair.second, this);
        this.sendImsFeatureCreatedCallback((Integer)featurePair.first, (Integer)featurePair.second);
    }

    private void removeImsServiceFeature(Pair<Integer, Integer> featurePair) throws RemoteException {
        if (this.mIImsServiceController == null || this.mCallbacks == null) {
            Log.w(LOG_TAG, "removeImsServiceFeature called with null values.");
            return;
        }
        ImsFeatureStatusCallback callbackToRemove = this.mFeatureStatusCallbacks.stream().filter(c -> ((ImsFeatureStatusCallback)c).mSlotId == (Integer)pair.first && ((ImsFeatureStatusCallback)c).mFeatureType == (Integer)pair.second).findFirst().orElse(null);
        if (callbackToRemove != null) {
            this.mFeatureStatusCallbacks.remove(callbackToRemove);
        }
        this.mIImsServiceController.removeImsFeature((Integer)featurePair.first, (Integer)featurePair.second, callbackToRemove != null ? callbackToRemove.getCallback() : null);
        this.mCallbacks.imsServiceFeatureRemoved((Integer)featurePair.first, (Integer)featurePair.second, this);
        this.sendImsFeatureRemovedCallback((Integer)featurePair.first, (Integer)featurePair.second);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllFeaturesRemoved() {
        if (this.mCallbacks == null) {
            Log.w(LOG_TAG, "notifyAllFeaturesRemoved called with invalid callbacks.");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            for (Pair<Integer, Integer> feature : this.mImsFeatures) {
                this.mCallbacks.imsServiceFeatureRemoved((Integer)feature.first, (Integer)feature.second, this);
                this.sendImsFeatureRemovedCallback((Integer)feature.first, (Integer)feature.second);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpService() {
        Object object = this.mLock;
        synchronized (object) {
            this.mImsDeathRecipient = null;
            this.mImsServiceConnection = null;
            this.mImsServiceControllerBinder = null;
            this.mIImsServiceController = null;
            this.mIsBound = false;
        }
    }

    private class ImsFeatureStatusCallback {
        private int mSlotId;
        private int mFeatureType;
        private final IImsFeatureStatusCallback mCallback = new IImsFeatureStatusCallback.Stub(){

            @Override
            public void notifyImsFeatureStatus(int featureStatus) throws RemoteException {
                Log.i(ImsServiceController.LOG_TAG, "notifyImsFeatureStatus: slot=" + ImsFeatureStatusCallback.this.mSlotId + ", feature=" + ImsFeatureStatusCallback.this.mFeatureType + ", status=" + featureStatus);
                ImsServiceController.this.sendImsFeatureStatusChanged(ImsFeatureStatusCallback.this.mSlotId, ImsFeatureStatusCallback.this.mFeatureType, featureStatus);
            }
        };

        ImsFeatureStatusCallback(int slotId, int featureType) {
            this.mSlotId = slotId;
            this.mFeatureType = featureType;
        }

        public IImsFeatureStatusCallback getCallback() {
            return this.mCallback;
        }
    }

    public static interface RebindRetry {
        public long getRetryTimeout();
    }

    public static interface ImsServiceControllerCallbacks {
        public void imsServiceFeatureCreated(int var1, int var2, ImsServiceController var3);

        public void imsServiceFeatureRemoved(int var1, int var2, ImsServiceController var3);
    }

    class ImsServiceConnection
    implements ServiceConnection {
        ImsServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = ImsServiceController.this.mLock;
            synchronized (object) {
                ImsServiceController.this.mIsBound = true;
                ImsServiceController.this.mIsBinding = false;
                ImsServiceController.this.grantPermissionsToService();
                Log.d(ImsServiceController.LOG_TAG, "ImsService(" + name + "): onServiceConnected with binder: " + service);
                if (service != null) {
                    ImsServiceController.this.mImsDeathRecipient = new ImsDeathRecipient(name);
                    try {
                        service.linkToDeath(ImsServiceController.this.mImsDeathRecipient, 0);
                        ImsServiceController.this.mImsServiceControllerBinder = service;
                        ImsServiceController.this.mIImsServiceController = IImsServiceController.Stub.asInterface(service);
                        for (Pair i : ImsServiceController.this.mImsFeatures) {
                            ImsServiceController.this.addImsServiceFeature(i);
                        }
                    }
                    catch (RemoteException e) {
                        ImsServiceController.this.mIsBound = false;
                        ImsServiceController.this.mIsBinding = false;
                        if (ImsServiceController.this.mImsDeathRecipient != null) {
                            ImsServiceController.this.mImsDeathRecipient.binderDied();
                        }
                        Log.e(ImsServiceController.LOG_TAG, "ImsService(" + name + ") RemoteException:" + e.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Object object = ImsServiceController.this.mLock;
            synchronized (object) {
                ImsServiceController.this.mIsBinding = false;
            }
            if (ImsServiceController.this.mIImsServiceController != null) {
                ImsServiceController.this.mImsServiceControllerBinder.unlinkToDeath(ImsServiceController.this.mImsDeathRecipient, 0);
            }
            ImsServiceController.this.notifyAllFeaturesRemoved();
            ImsServiceController.this.cleanUpService();
            Log.w(ImsServiceController.LOG_TAG, "ImsService(" + name + "): onServiceDisconnected. Rebinding...");
            ImsServiceController.this.startDelayedRebindToService();
        }
    }

    class ImsDeathRecipient
    implements IBinder.DeathRecipient {
        private ComponentName mComponentName;

        ImsDeathRecipient(ComponentName name) {
            this.mComponentName = name;
        }

        @Override
        public void binderDied() {
            Log.e(ImsServiceController.LOG_TAG, "ImsService(" + this.mComponentName + ") died. Restarting...");
            ImsServiceController.this.notifyAllFeaturesRemoved();
            ImsServiceController.this.cleanUpService();
            ImsServiceController.this.startDelayedRebindToService();
        }
    }
}

