/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.ProgressDialog;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.NetworkConfig;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.NetworkUtils;
import android.net.ProxyInfo;
import android.net.TrafficStats;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.RegistrantList;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.CarrierConfigManager;
import android.telephony.CellLocation;
import android.telephony.PcoData;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.LocalLog;
import android.util.Pair;
import android.util.SparseArray;
import com.android.internal.telephony.DctConstants;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.SettingsObserver;
import com.android.internal.telephony.dataconnection.ApnContext;
import com.android.internal.telephony.dataconnection.ApnSetting;
import com.android.internal.telephony.dataconnection.DataConnection;
import com.android.internal.telephony.dataconnection.DataConnectionReasons;
import com.android.internal.telephony.dataconnection.DataEnabledSettings;
import com.android.internal.telephony.dataconnection.DataProfile;
import com.android.internal.telephony.dataconnection.DcAsyncChannel;
import com.android.internal.telephony.dataconnection.DcController;
import com.android.internal.telephony.dataconnection.DcFailCause;
import com.android.internal.telephony.dataconnection.DcTesterFailBringUpAll;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.AsyncChannel;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class DcTracker
extends Handler {
    private static final String LOG_TAG = "DCT";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final boolean VDBG_STALL = false;
    private static final boolean RADIO_TESTS = false;
    public AtomicBoolean isCleanupRequired = new AtomicBoolean(false);
    private final AlarmManager mAlarmManager;
    private String mRequestedApnType = "default";
    private final DataEnabledSettings mDataEnabledSettings = new DataEnabledSettings();
    private static final int POLL_NETSTAT_MILLIS = 1000;
    private static final int POLL_NETSTAT_SCREEN_OFF_MILLIS = 600000;
    private static final int NUMBER_SENT_PACKETS_OF_HANG = 10;
    private static final int DATA_STALL_ALARM_NON_AGGRESSIVE_DELAY_IN_MS_DEFAULT = 360000;
    private static final int DATA_STALL_ALARM_AGGRESSIVE_DELAY_IN_MS_DEFAULT = 60000;
    private static final String DATA_STALL_ALARM_TAG_EXTRA = "data.stall.alram.tag";
    private static final boolean DATA_STALL_SUSPECTED = true;
    private static final boolean DATA_STALL_NOT_SUSPECTED = false;
    private String RADIO_RESET_PROPERTY = "gsm.radioreset";
    private static final String INTENT_RECONNECT_ALARM = "com.android.internal.telephony.data-reconnect";
    private static final String INTENT_RECONNECT_ALARM_EXTRA_TYPE = "reconnect_alarm_extra_type";
    private static final String INTENT_RECONNECT_ALARM_EXTRA_REASON = "reconnect_alarm_extra_reason";
    private static final String INTENT_DATA_STALL_ALARM = "com.android.internal.telephony.data-stall";
    private DcTesterFailBringUpAll mDcTesterFailBringUpAll;
    private DcController mDcc;
    private final PriorityQueue<ApnContext> mPrioritySortedApnContexts = new PriorityQueue<ApnContext>(5, new Comparator<ApnContext>(){

        @Override
        public int compare(ApnContext c1, ApnContext c2) {
            return c2.priority - c1.priority;
        }
    });
    private ArrayList<ApnSetting> mAllApnSettings = null;
    private ApnSetting mPreferredApn = null;
    private boolean mIsPsRestricted = false;
    private ApnSetting mEmergencyApn = null;
    private boolean mIsDisposed = false;
    private ContentResolver mResolver;
    private boolean mIsProvisioning = false;
    private String mProvisioningUrl = null;
    private static final String INTENT_PROVISIONING_APN_ALARM = "com.android.internal.telephony.provisioning_apn_alarm";
    private static final String PROVISIONING_APN_ALARM_TAG_EXTRA = "provisioning.apn.alarm.tag";
    private static final String DEBUG_PROV_APN_ALARM = "persist.debug.prov_apn_alarm";
    private static final int PROVISIONING_APN_ALARM_DELAY_IN_MS_DEFAULT = 900000;
    private PendingIntent mProvisioningApnAlarmIntent = null;
    private int mProvisioningApnAlarmTag = (int)SystemClock.elapsedRealtime();
    private AsyncChannel mReplyAc = new AsyncChannel();
    private final LocalLog mDataRoamingLeakageLog = new LocalLog(50);
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.SCREEN_ON")) {
                DcTracker.this.log("screen on");
                DcTracker.this.mIsScreenOn = true;
                DcTracker.this.stopNetStatPoll();
                DcTracker.this.startNetStatPoll();
                DcTracker.this.restartDataStallAlarm();
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                DcTracker.this.log("screen off");
                DcTracker.this.mIsScreenOn = false;
                DcTracker.this.stopNetStatPoll();
                DcTracker.this.startNetStatPoll();
                DcTracker.this.restartDataStallAlarm();
            } else if (action.startsWith(DcTracker.INTENT_RECONNECT_ALARM)) {
                DcTracker.this.log("Reconnect alarm. Previous state was " + (Object)((Object)DcTracker.this.mState));
                DcTracker.this.onActionIntentReconnectAlarm(intent);
            } else if (action.equals(DcTracker.INTENT_DATA_STALL_ALARM)) {
                DcTracker.this.log("Data stall alarm");
                DcTracker.this.onActionIntentDataStallAlarm(intent);
            } else if (action.equals(DcTracker.INTENT_PROVISIONING_APN_ALARM)) {
                DcTracker.this.log("Provisioning apn alarm");
                DcTracker.this.onActionIntentProvisioningApnAlarm(intent);
            } else if (action.equals("android.net.wifi.STATE_CHANGE")) {
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                DcTracker.this.mIsWifiConnected = networkInfo != null && networkInfo.isConnected();
                DcTracker.this.log("NETWORK_STATE_CHANGED_ACTION: mIsWifiConnected=" + DcTracker.this.mIsWifiConnected);
            } else if (action.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                boolean enabled;
                DcTracker.this.log("Wifi state changed");
                boolean bl = enabled = intent.getIntExtra("wifi_state", 4) == 3;
                if (!enabled) {
                    DcTracker.this.mIsWifiConnected = false;
                }
                DcTracker.this.log("WIFI_STATE_CHANGED_ACTION: enabled=" + enabled + " mIsWifiConnected=" + DcTracker.this.mIsWifiConnected);
            } else if (action.equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                if (DcTracker.this.mIccRecords.get() != null && ((IccRecords)DcTracker.this.mIccRecords.get()).getRecordsLoaded()) {
                    DcTracker.this.setDefaultDataRoamingEnabled();
                }
            } else {
                DcTracker.this.log("onReceive: Unknown action=" + action);
            }
        }
    };
    private final Runnable mPollNetStat = new Runnable(){

        @Override
        public void run() {
            DcTracker.this.updateDataActivity();
            if (DcTracker.this.mIsScreenOn) {
                DcTracker.this.mNetStatPollPeriod = Settings.Global.getInt(DcTracker.this.mResolver, "pdp_watchdog_poll_interval_ms", 1000);
            } else {
                DcTracker.this.mNetStatPollPeriod = Settings.Global.getInt(DcTracker.this.mResolver, "pdp_watchdog_long_poll_interval_ms", 600000);
            }
            if (DcTracker.this.mNetStatPollEnabled) {
                DcTracker.this.mDataConnectionTracker.postDelayed(this, DcTracker.this.mNetStatPollPeriod);
            }
        }
    };
    private SubscriptionManager mSubscriptionManager;
    private final SubscriptionManager.OnSubscriptionsChangedListener mOnSubscriptionsChangedListener = new SubscriptionManager.OnSubscriptionsChangedListener(){
        public final AtomicInteger mPreviousSubId = new AtomicInteger(-1);

        @Override
        public void onSubscriptionsChanged() {
            DcTracker.this.log("SubscriptionListener.onSubscriptionInfoChanged");
            int subId = DcTracker.this.mPhone.getSubId();
            if (SubscriptionManager.isValidSubscriptionId(subId)) {
                DcTracker.this.registerSettingsObserver();
            }
            if (this.mPreviousSubId.getAndSet(subId) != subId && SubscriptionManager.isValidSubscriptionId(subId)) {
                DcTracker.this.onRecordsLoadedOrSubIdChanged();
            }
        }
    };
    private final SettingsObserver mSettingsObserver;
    private final ConnectivityManager mCm;
    private ArrayList<Message> mDisconnectAllCompleteMsgList = new ArrayList();
    private RegistrantList mAllDataDisconnectedRegistrants = new RegistrantList();
    private final Phone mPhone;
    private final UiccController mUiccController;
    private final AtomicReference<IccRecords> mIccRecords = new AtomicReference();
    private DctConstants.Activity mActivity = DctConstants.Activity.NONE;
    private DctConstants.State mState = DctConstants.State.IDLE;
    private final Handler mDataConnectionTracker;
    private long mTxPkts;
    private long mRxPkts;
    private int mNetStatPollPeriod;
    private boolean mNetStatPollEnabled = false;
    private TxRxSum mDataStallTxRxSum = new TxRxSum(0L, 0L);
    private int mDataStallAlarmTag = (int)SystemClock.elapsedRealtime();
    private PendingIntent mDataStallAlarmIntent = null;
    private long mSentSinceLastRecv;
    private int mNoRecvPollCount = 0;
    private static int sEnableFailFastRefCounter = 0;
    private volatile boolean mDataStallDetectionEnabled = true;
    private volatile boolean mFailFast = false;
    private boolean mInVoiceCall = false;
    private boolean mIsWifiConnected = false;
    private PendingIntent mReconnectIntent = null;
    private boolean mAutoAttachOnCreationConfig = false;
    private AtomicBoolean mAutoAttachOnCreation = new AtomicBoolean(false);
    private boolean mIsScreenOn = true;
    private boolean mMvnoMatched = false;
    private AtomicInteger mUniqueIdGenerator = new AtomicInteger(0);
    private HashMap<Integer, DataConnection> mDataConnections = new HashMap();
    private HashMap<Integer, DcAsyncChannel> mDataConnectionAcHashMap = new HashMap();
    private HashMap<String, Integer> mApnToDataConnectionId = new HashMap();
    private final ConcurrentHashMap<String, ApnContext> mApnContexts = new ConcurrentHashMap();
    private final SparseArray<ApnContext> mApnContextsById = new SparseArray();
    private int mDisconnectPendingCount = 0;
    private boolean mMeteredApnDisabled = false;
    private int mSetDataProfileStatus = 0;
    private boolean mReregisterOnReconnectFailure = false;
    private static final String PUPPET_MASTER_RADIO_STRESS_TEST = "gsm.defaultpdpcontext.active";
    private static final int POLL_PDP_MILLIS = 5000;
    private static final int PROVISIONING_SPINNER_TIMEOUT_MILLIS = 120000;
    static final Uri PREFERAPN_NO_UPDATE_URI_USING_SUBID = Uri.parse("content://telephony/carriers/preferapn_no_update/subId/");
    static final String APN_ID = "apn_id";
    private boolean mCanSetPreferApn = false;
    private AtomicBoolean mAttached = new AtomicBoolean(false);
    private ApnChangeObserver mApnObserver;
    private final String mProvisionActionName;
    private BroadcastReceiver mProvisionBroadcastReceiver;
    private ProgressDialog mProvisioningSpinner;
    public boolean mImsRegistrationState = false;

    private void registerSettingsObserver() {
        this.mSettingsObserver.unobserve();
        String simSuffix = "";
        if (TelephonyManager.getDefault().getSimCount() > 1) {
            simSuffix = Integer.toString(this.mPhone.getSubId());
        }
        this.mSettingsObserver.observe(Settings.Global.getUriFor("data_roaming" + simSuffix), 270384);
        this.mSettingsObserver.observe(Settings.Global.getUriFor("device_provisioned"), 270379);
        this.mSettingsObserver.observe(Settings.Global.getUriFor("device_provisioning_mobile_data"), 270379);
    }

    private void onActionIntentReconnectAlarm(Intent intent) {
        Message msg = this.obtainMessage(270383);
        msg.setData(intent.getExtras());
        this.sendMessage(msg);
    }

    private void onDataReconnect(Bundle bundle) {
        String reason = bundle.getString(INTENT_RECONNECT_ALARM_EXTRA_REASON);
        String apnType = bundle.getString(INTENT_RECONNECT_ALARM_EXTRA_TYPE);
        int phoneSubId = this.mPhone.getSubId();
        int currSubId = bundle.getInt("subscription", -1);
        this.log("onDataReconnect: currSubId = " + currSubId + " phoneSubId=" + phoneSubId);
        if (!SubscriptionManager.isValidSubscriptionId(currSubId) || currSubId != phoneSubId) {
            this.log("receive ReconnectAlarm but subId incorrect, ignore");
            return;
        }
        ApnContext apnContext = this.mApnContexts.get(apnType);
        this.log("onDataReconnect: mState=" + (Object)((Object)this.mState) + " reason=" + reason + " apnType=" + apnType + " apnContext=" + apnContext + " mDataConnectionAsyncChannels=" + this.mDataConnectionAcHashMap);
        if (apnContext != null && apnContext.isEnabled()) {
            apnContext.setReason(reason);
            DctConstants.State apnContextState = apnContext.getState();
            this.log("onDataReconnect: apnContext state=" + (Object)((Object)apnContextState));
            if (apnContextState == DctConstants.State.FAILED || apnContextState == DctConstants.State.IDLE) {
                this.log("onDataReconnect: state is FAILED|IDLE, disassociate");
                DcAsyncChannel dcac = apnContext.getDcAc();
                if (dcac != null) {
                    this.log("onDataReconnect: tearDown apnContext=" + apnContext);
                    dcac.tearDown(apnContext, "", null);
                }
                apnContext.setDataConnectionAc(null);
                apnContext.setState(DctConstants.State.IDLE);
            } else {
                this.log("onDataReconnect: keep associated");
            }
            this.sendMessage(this.obtainMessage(270339, apnContext));
            apnContext.setReconnectIntent(null);
        }
    }

    private void onActionIntentDataStallAlarm(Intent intent) {
        Message msg = this.obtainMessage(270353, intent.getAction());
        msg.arg1 = intent.getIntExtra(DATA_STALL_ALARM_TAG_EXTRA, 0);
        this.sendMessage(msg);
    }

    public DcTracker(Phone phone) {
        this.mPhone = phone;
        this.log("DCT.constructor");
        this.mResolver = this.mPhone.getContext().getContentResolver();
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 270369, null);
        this.mAlarmManager = (AlarmManager)this.mPhone.getContext().getSystemService("alarm");
        this.mCm = (ConnectivityManager)this.mPhone.getContext().getSystemService("connectivity");
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        filter.addAction(INTENT_DATA_STALL_ALARM);
        filter.addAction(INTENT_PROVISIONING_APN_ALARM);
        filter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        this.mDataEnabledSettings.setUserDataEnabled(this.getDataEnabled());
        this.mPhone.getContext().registerReceiver(this.mIntentReceiver, filter, null, this.mPhone);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext());
        this.mAutoAttachOnCreation.set(sp.getBoolean("disabled_on_boot_key", false));
        this.mSubscriptionManager = SubscriptionManager.from(this.mPhone.getContext());
        this.mSubscriptionManager.addOnSubscriptionsChangedListener(this.mOnSubscriptionsChangedListener);
        HandlerThread dcHandlerThread = new HandlerThread("DcHandlerThread");
        dcHandlerThread.start();
        Handler dcHandler = new Handler(dcHandlerThread.getLooper());
        this.mDcc = DcController.makeDcc(this.mPhone, this, dcHandler);
        this.mDcTesterFailBringUpAll = new DcTesterFailBringUpAll(this.mPhone, dcHandler);
        this.mDataConnectionTracker = this;
        this.registerForAllEvents();
        this.update();
        this.mApnObserver = new ApnChangeObserver();
        phone.getContext().getContentResolver().registerContentObserver(Telephony.Carriers.CONTENT_URI, true, this.mApnObserver);
        this.initApnContexts();
        for (ApnContext apnContext : this.mApnContexts.values()) {
            filter = new IntentFilter();
            filter.addAction("com.android.internal.telephony.data-reconnect." + apnContext.getApnType());
            this.mPhone.getContext().registerReceiver(this.mIntentReceiver, filter, null, this.mPhone);
        }
        this.initEmergencyApnSetting();
        this.addEmergencyApnSetting();
        this.mProvisionActionName = "com.android.internal.telephony.PROVISION" + phone.getPhoneId();
        this.mSettingsObserver = new SettingsObserver(this.mPhone.getContext(), this);
        this.registerSettingsObserver();
    }

    public DcTracker() {
        this.mAlarmManager = null;
        this.mCm = null;
        this.mPhone = null;
        this.mUiccController = null;
        this.mDataConnectionTracker = null;
        this.mProvisionActionName = null;
        this.mSettingsObserver = new SettingsObserver(null, this);
    }

    public void registerServiceStateTrackerEvents() {
        this.mPhone.getServiceStateTracker().registerForDataConnectionAttached(this, 270352, null);
        this.mPhone.getServiceStateTracker().registerForDataConnectionDetached(this, 270345, null);
        this.mPhone.getServiceStateTracker().registerForDataRoamingOn(this, 270347, null);
        this.mPhone.getServiceStateTracker().registerForDataRoamingOff(this, 270348, null, true);
        this.mPhone.getServiceStateTracker().registerForPsRestrictedEnabled(this, 270358, null);
        this.mPhone.getServiceStateTracker().registerForPsRestrictedDisabled(this, 270359, null);
        this.mPhone.getServiceStateTracker().registerForDataRegStateOrRatChanged(this, 270377, null);
    }

    public void unregisterServiceStateTrackerEvents() {
        this.mPhone.getServiceStateTracker().unregisterForDataConnectionAttached(this);
        this.mPhone.getServiceStateTracker().unregisterForDataConnectionDetached(this);
        this.mPhone.getServiceStateTracker().unregisterForDataRoamingOn(this);
        this.mPhone.getServiceStateTracker().unregisterForDataRoamingOff(this);
        this.mPhone.getServiceStateTracker().unregisterForPsRestrictedEnabled(this);
        this.mPhone.getServiceStateTracker().unregisterForPsRestrictedDisabled(this);
        this.mPhone.getServiceStateTracker().unregisterForDataRegStateOrRatChanged(this);
    }

    private void registerForAllEvents() {
        this.mPhone.mCi.registerForAvailable(this, 270337, null);
        this.mPhone.mCi.registerForOffOrNotAvailable(this, 270342, null);
        this.mPhone.mCi.registerForDataCallListChanged(this, 270340, null);
        this.mPhone.getCallTracker().registerForVoiceCallEnded(this, 270344, null);
        this.mPhone.getCallTracker().registerForVoiceCallStarted(this, 270343, null);
        this.registerServiceStateTrackerEvents();
        this.mPhone.mCi.registerForPcoData(this, 270381, null);
        this.mPhone.getCarrierActionAgent().registerForCarrierAction(0, this, 270382, null, false);
    }

    public void dispose() {
        this.log("DCT.dispose");
        if (this.mProvisionBroadcastReceiver != null) {
            this.mPhone.getContext().unregisterReceiver(this.mProvisionBroadcastReceiver);
            this.mProvisionBroadcastReceiver = null;
        }
        if (this.mProvisioningSpinner != null) {
            this.mProvisioningSpinner.dismiss();
            this.mProvisioningSpinner = null;
        }
        this.cleanUpAllConnections(true, null);
        for (DcAsyncChannel dcac : this.mDataConnectionAcHashMap.values()) {
            dcac.disconnect();
        }
        this.mDataConnectionAcHashMap.clear();
        this.mIsDisposed = true;
        this.mPhone.getContext().unregisterReceiver(this.mIntentReceiver);
        this.mUiccController.unregisterForIccChanged(this);
        this.mSettingsObserver.unobserve();
        this.mSubscriptionManager.removeOnSubscriptionsChangedListener(this.mOnSubscriptionsChangedListener);
        this.mDcc.dispose();
        this.mDcTesterFailBringUpAll.dispose();
        this.mPhone.getContext().getContentResolver().unregisterContentObserver(this.mApnObserver);
        this.mApnContexts.clear();
        this.mApnContextsById.clear();
        this.mPrioritySortedApnContexts.clear();
        this.unregisterForAllEvents();
        this.destroyDataConnections();
    }

    private void unregisterForAllEvents() {
        this.mPhone.mCi.unregisterForAvailable(this);
        this.mPhone.mCi.unregisterForOffOrNotAvailable(this);
        IccRecords r = this.mIccRecords.get();
        if (r != null) {
            r.unregisterForRecordsLoaded(this);
            this.mIccRecords.set(null);
        }
        this.mPhone.mCi.unregisterForDataCallListChanged(this);
        this.mPhone.getCallTracker().unregisterForVoiceCallEnded(this);
        this.mPhone.getCallTracker().unregisterForVoiceCallStarted(this);
        this.unregisterServiceStateTrackerEvents();
        this.mPhone.mCi.unregisterForPcoData(this);
        this.mPhone.getCarrierActionAgent().unregisterForCarrierAction(this, 0);
    }

    private void onResetDone(AsyncResult ar) {
        this.log("EVENT_RESET_DONE");
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        this.gotoIdleAndNotifyDataConnection(reason);
    }

    public void setDataEnabled(boolean enable) {
        Message msg = this.obtainMessage(270366);
        msg.arg1 = enable ? 1 : 0;
        this.log("setDataEnabled: sendMessage: enable=" + enable);
        this.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSetUserDataEnabled(boolean enabled) {
        DataEnabledSettings dataEnabledSettings = this.mDataEnabledSettings;
        synchronized (dataEnabledSettings) {
            if (this.mDataEnabledSettings.isUserDataEnabled() != enabled) {
                this.mDataEnabledSettings.setUserDataEnabled(enabled);
                if (TelephonyManager.getDefault().getSimCount() == 1) {
                    Settings.Global.putInt(this.mResolver, "mobile_data", enabled ? 1 : 0);
                } else {
                    int phoneSubId = this.mPhone.getSubId();
                    Settings.Global.putInt(this.mResolver, "mobile_data" + phoneSubId, enabled ? 1 : 0);
                }
                if (!this.getDataRoamingEnabled() && this.mPhone.getServiceState().getDataRoaming()) {
                    if (enabled) {
                        this.notifyOffApnsOfAvailability("roamingOn");
                    } else {
                        this.notifyOffApnsOfAvailability("dataDisabled");
                    }
                }
                if (enabled) {
                    this.reevaluateDataConnections();
                    this.onTrySetupData("dataEnabled");
                } else {
                    this.onCleanUpAllConnections("specificDisabled");
                }
            }
        }
    }

    private void reevaluateDataConnections() {
        if (this.mDataEnabledSettings.isDataEnabled()) {
            for (ApnContext apnContext : this.mApnContexts.values()) {
                DcAsyncChannel dcac;
                if (!apnContext.isConnectedOrConnecting() || (dcac = apnContext.getDcAc()) == null) continue;
                NetworkCapabilities netCaps = dcac.getNetworkCapabilitiesSync();
                if (netCaps != null && !netCaps.hasCapability(13) && !netCaps.hasCapability(11)) {
                    this.log("Tearing down restricted metered net:" + apnContext);
                    apnContext.setReason("dataEnabled");
                    this.cleanUpConnection(true, apnContext);
                    continue;
                }
                if (!apnContext.getApnSetting().isMetered(this.mPhone) || netCaps == null || !netCaps.hasCapability(11)) continue;
                this.log("Tearing down unmetered net:" + apnContext);
                apnContext.setReason("dataEnabled");
                this.cleanUpConnection(true, apnContext);
            }
        }
    }

    private void onDeviceProvisionedChange() {
        if (this.getDataEnabled()) {
            this.mDataEnabledSettings.setUserDataEnabled(true);
            this.reevaluateDataConnections();
            this.onTrySetupData("dataEnabled");
        } else {
            this.mDataEnabledSettings.setUserDataEnabled(false);
            this.onCleanUpAllConnections("specificDisabled");
        }
    }

    public long getSubId() {
        return this.mPhone.getSubId();
    }

    public DctConstants.Activity getActivity() {
        return this.mActivity;
    }

    private void setActivity(DctConstants.Activity activity) {
        this.log("setActivity = " + (Object)((Object)activity));
        this.mActivity = activity;
        this.mPhone.notifyDataActivity();
    }

    public void requestNetwork(NetworkRequest networkRequest, LocalLog log) {
        int apnId = ApnContext.apnIdForNetworkRequest(networkRequest);
        ApnContext apnContext = this.mApnContextsById.get(apnId);
        log.log("DcTracker.requestNetwork for " + networkRequest + " found " + apnContext);
        if (apnContext != null) {
            apnContext.requestNetwork(networkRequest, log);
        }
    }

    public void releaseNetwork(NetworkRequest networkRequest, LocalLog log) {
        int apnId = ApnContext.apnIdForNetworkRequest(networkRequest);
        ApnContext apnContext = this.mApnContextsById.get(apnId);
        log.log("DcTracker.releaseNetwork for " + networkRequest + " found " + apnContext);
        if (apnContext != null) {
            apnContext.releaseNetwork(networkRequest, log);
        }
    }

    public boolean isApnSupported(String name) {
        if (name == null) {
            this.loge("isApnSupported: name=null");
            return false;
        }
        ApnContext apnContext = this.mApnContexts.get(name);
        if (apnContext == null) {
            this.loge("Request for unsupported mobile name: " + name);
            return false;
        }
        return true;
    }

    public int getApnPriority(String name) {
        ApnContext apnContext = this.mApnContexts.get(name);
        if (apnContext == null) {
            this.loge("Request for unsupported mobile name: " + name);
        }
        return apnContext.priority;
    }

    private void setRadio(boolean on) {
        ITelephony phone = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
        try {
            phone.setRadio(on);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() {
        if (this.mPhone != null) {
            this.log("finalize");
        }
    }

    private ApnContext addApnContext(String type, NetworkConfig networkConfig) {
        ApnContext apnContext = new ApnContext(this.mPhone, type, LOG_TAG, networkConfig, this);
        this.mApnContexts.put(type, apnContext);
        this.mApnContextsById.put(ApnContext.apnIdForApnName(type), apnContext);
        this.mPrioritySortedApnContexts.add(apnContext);
        return apnContext;
    }

    private void initApnContexts() {
        String[] networkConfigStrings;
        this.log("initApnContexts: E");
        block12: for (String networkConfigString : networkConfigStrings = this.mPhone.getContext().getResources().getStringArray(17236047)) {
            NetworkConfig networkConfig = new NetworkConfig(networkConfigString);
            ApnContext apnContext = null;
            switch (networkConfig.type) {
                case 0: {
                    apnContext = this.addApnContext("default", networkConfig);
                    break;
                }
                case 2: {
                    apnContext = this.addApnContext("mms", networkConfig);
                    break;
                }
                case 3: {
                    apnContext = this.addApnContext("supl", networkConfig);
                    break;
                }
                case 4: {
                    apnContext = this.addApnContext("dun", networkConfig);
                    break;
                }
                case 5: {
                    apnContext = this.addApnContext("hipri", networkConfig);
                    break;
                }
                case 10: {
                    apnContext = this.addApnContext("fota", networkConfig);
                    break;
                }
                case 11: {
                    apnContext = this.addApnContext("ims", networkConfig);
                    break;
                }
                case 12: {
                    apnContext = this.addApnContext("cbs", networkConfig);
                    break;
                }
                case 14: {
                    apnContext = this.addApnContext("ia", networkConfig);
                    break;
                }
                case 15: {
                    apnContext = this.addApnContext("emergency", networkConfig);
                    break;
                }
                default: {
                    this.log("initApnContexts: skipping unknown type=" + networkConfig.type);
                    continue block12;
                }
            }
            this.log("initApnContexts: apnContext=" + apnContext);
        }
    }

    public LinkProperties getLinkProperties(String apnType) {
        DcAsyncChannel dcac;
        ApnContext apnContext = this.mApnContexts.get(apnType);
        if (apnContext != null && (dcac = apnContext.getDcAc()) != null) {
            this.log("return link properites for " + apnType);
            return dcac.getLinkPropertiesSync();
        }
        this.log("return new LinkProperties");
        return new LinkProperties();
    }

    public NetworkCapabilities getNetworkCapabilities(String apnType) {
        DcAsyncChannel dataConnectionAc;
        ApnContext apnContext = this.mApnContexts.get(apnType);
        if (apnContext != null && (dataConnectionAc = apnContext.getDcAc()) != null) {
            this.log("get active pdp is not null, return NetworkCapabilities for " + apnType);
            return dataConnectionAc.getNetworkCapabilitiesSync();
        }
        this.log("return new NetworkCapabilities");
        return new NetworkCapabilities();
    }

    public String[] getActiveApnTypes() {
        this.log("get all active apn types");
        ArrayList<String> result = new ArrayList<String>();
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (!this.mAttached.get() || !apnContext.isReady()) continue;
            result.add(apnContext.getApnType());
        }
        return result.toArray(new String[0]);
    }

    public String getActiveApnString(String apnType) {
        ApnSetting apnSetting;
        ApnContext apnContext = this.mApnContexts.get(apnType);
        if (apnContext != null && (apnSetting = apnContext.getApnSetting()) != null) {
            return apnSetting.apn;
        }
        return null;
    }

    public DctConstants.State getState(String apnType) {
        ApnContext apnContext = this.mApnContexts.get(apnType);
        if (apnContext != null) {
            return apnContext.getState();
        }
        return DctConstants.State.FAILED;
    }

    private boolean isProvisioningApn(String apnType) {
        ApnContext apnContext = this.mApnContexts.get(apnType);
        if (apnContext != null) {
            return apnContext.isProvisioningApn();
        }
        return false;
    }

    public DctConstants.State getOverallState() {
        boolean isConnecting = false;
        boolean isFailed = true;
        boolean isAnyEnabled = false;
        block5: for (ApnContext apnContext : this.mApnContexts.values()) {
            if (!apnContext.isEnabled()) continue;
            isAnyEnabled = true;
            switch (apnContext.getState()) {
                case CONNECTED: 
                case DISCONNECTING: {
                    return DctConstants.State.CONNECTED;
                }
                case RETRYING: 
                case CONNECTING: {
                    isConnecting = true;
                    isFailed = false;
                    continue block5;
                }
                case IDLE: 
                case SCANNING: {
                    isFailed = false;
                    continue block5;
                }
            }
            isAnyEnabled = true;
        }
        if (!isAnyEnabled) {
            return DctConstants.State.IDLE;
        }
        if (isConnecting) {
            return DctConstants.State.CONNECTING;
        }
        if (!isFailed) {
            return DctConstants.State.IDLE;
        }
        return DctConstants.State.FAILED;
    }

    public boolean isDataEnabled() {
        return this.mDataEnabledSettings.isDataEnabled();
    }

    private void onDataConnectionDetached() {
        this.log("onDataConnectionDetached: stop polling and notify detached");
        this.stopNetStatPoll();
        this.stopDataStallAlarm();
        this.notifyDataConnection("dataDetached");
        this.mAttached.set(false);
    }

    private void onDataConnectionAttached() {
        this.log("onDataConnectionAttached");
        this.mAttached.set(true);
        if (this.getOverallState() == DctConstants.State.CONNECTED) {
            this.log("onDataConnectionAttached: start polling notify attached");
            this.startNetStatPoll();
            this.startDataStallAlarm(false);
            this.notifyDataConnection("dataAttached");
        } else {
            this.notifyOffApnsOfAvailability("dataAttached");
        }
        if (this.mAutoAttachOnCreationConfig) {
            this.mAutoAttachOnCreation.set(true);
        }
        this.setupDataOnConnectableApns("dataAttached");
    }

    public boolean isDataAllowed(DataConnectionReasons dataConnectionReasons) {
        return this.isDataAllowed(null, dataConnectionReasons);
    }

    boolean isDataAllowed(ApnContext apnContext, DataConnectionReasons dataConnectionReasons) {
        DataConnectionReasons reasons = new DataConnectionReasons();
        boolean internalDataEnabled = this.mDataEnabledSettings.isInternalDataEnabled();
        boolean attachedState = this.mAttached.get();
        boolean desiredPowerState = this.mPhone.getServiceStateTracker().getDesiredPowerState();
        boolean radioStateFromCarrier = this.mPhone.getServiceStateTracker().getPowerStateFromCarrier();
        int radioTech = this.mPhone.getServiceState().getRilDataRadioTechnology();
        if (radioTech == 18) {
            desiredPowerState = true;
            radioStateFromCarrier = true;
        }
        boolean recordsLoaded = this.mIccRecords.get() != null && this.mIccRecords.get().getRecordsLoaded();
        boolean defaultDataSelected = SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultDataSubscriptionId());
        boolean isMeteredApnType = apnContext == null || ApnSetting.isMeteredApnType(apnContext.getApnType(), this.mPhone);
        PhoneConstants.State phoneState = PhoneConstants.State.IDLE;
        if (this.mPhone.getCallTracker() != null) {
            phoneState = this.mPhone.getCallTracker().getState();
        }
        if (apnContext != null && apnContext.getApnType().equals("emergency") && apnContext.isConnectable()) {
            if (dataConnectionReasons != null) {
                dataConnectionReasons.add(DataConnectionReasons.DataAllowedReasonType.EMERGENCY_APN);
            }
            return true;
        }
        if (apnContext != null && !apnContext.isConnectable()) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.APN_NOT_CONNECTABLE);
        }
        if (apnContext != null && (apnContext.getApnType().equals("default") || apnContext.getApnType().equals("ia")) && radioTech == 18) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.ON_IWLAN);
        }
        if (this.isEmergency()) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.IN_ECBM);
        }
        if (!attachedState && !this.mAutoAttachOnCreation.get()) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.NOT_ATTACHED);
        }
        if (!recordsLoaded) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.RECORD_NOT_LOADED);
        }
        if (phoneState != PhoneConstants.State.IDLE && !this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed()) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.INVALID_PHONE_STATE);
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.CONCURRENT_VOICE_DATA_NOT_ALLOWED);
        }
        if (!internalDataEnabled) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.INTERNAL_DATA_DISABLED);
        }
        if (!defaultDataSelected) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.DEFAULT_DATA_UNSELECTED);
        }
        if (this.mPhone.getServiceState().getDataRoaming() && !this.getDataRoamingEnabled()) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.ROAMING_DISABLED);
        }
        if (this.mIsPsRestricted) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.PS_RESTRICTED);
        }
        if (!desiredPowerState) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.UNDESIRED_POWER_STATE);
        }
        if (!radioStateFromCarrier) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.RADIO_DISABLED_BY_CARRIER);
        }
        if (!this.mDataEnabledSettings.isDataEnabled()) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.DATA_DISABLED);
        }
        if (reasons.containsHardDisallowedReasons()) {
            if (dataConnectionReasons != null) {
                dataConnectionReasons.copyFrom(reasons);
            }
            return false;
        }
        if (!isMeteredApnType && !reasons.allowed()) {
            reasons.add(DataConnectionReasons.DataAllowedReasonType.UNMETERED_APN);
        }
        if (apnContext != null && !apnContext.hasNoRestrictedRequests(true) && !reasons.allowed()) {
            reasons.add(DataConnectionReasons.DataAllowedReasonType.RESTRICTED_REQUEST);
        }
        if (reasons.allowed()) {
            reasons.add(DataConnectionReasons.DataAllowedReasonType.NORMAL);
        }
        if (dataConnectionReasons != null) {
            dataConnectionReasons.copyFrom(reasons);
        }
        return reasons.allowed();
    }

    private void setupDataOnConnectableApns(String reason) {
        this.setupDataOnConnectableApns(reason, RetryFailures.ALWAYS);
    }

    private void setupDataOnConnectableApns(String reason, RetryFailures retryFailures) {
        StringBuilder sb = new StringBuilder(120);
        for (ApnContext apnContext : this.mPrioritySortedApnContexts) {
            sb.append(apnContext.getApnType());
            sb.append(":[state=");
            sb.append((Object)apnContext.getState());
            sb.append(",enabled=");
            sb.append(apnContext.isEnabled());
            sb.append("] ");
        }
        this.log("setupDataOnConnectableApns: " + reason + " " + sb);
        for (ApnContext apnContext : this.mPrioritySortedApnContexts) {
            if (apnContext.getState() == DctConstants.State.FAILED || apnContext.getState() == DctConstants.State.SCANNING) {
                if (retryFailures == RetryFailures.ALWAYS) {
                    apnContext.releaseDataConnection(reason);
                } else if (!apnContext.isConcurrentVoiceAndDataAllowed() && this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed()) {
                    apnContext.releaseDataConnection(reason);
                }
            }
            if (!apnContext.isConnectable()) continue;
            this.log("isConnectable() call trySetupData");
            apnContext.setReason(reason);
            this.trySetupData(apnContext);
        }
    }

    boolean isEmergency() {
        boolean result = this.mPhone.isInEcm() || this.mPhone.isInEmergencyCall();
        this.log("isEmergency: result=" + result);
        return result;
    }

    private boolean trySetupData(ApnContext apnContext) {
        if (this.mPhone.getSimulatedRadioControl() != null) {
            apnContext.setState(DctConstants.State.CONNECTED);
            this.mPhone.notifyDataConnection(apnContext.getReason(), apnContext.getApnType());
            this.log("trySetupData: X We're on the simulator; assuming connected retValue=true");
            return true;
        }
        DataConnectionReasons dataConnectionReasons = new DataConnectionReasons();
        boolean isDataAllowed = this.isDataAllowed(apnContext, dataConnectionReasons);
        String logStr = "trySetupData for APN type " + apnContext.getApnType() + ", reason: " + apnContext.getReason() + ". " + dataConnectionReasons.toString();
        this.log(logStr);
        apnContext.requestLog(logStr);
        if (isDataAllowed) {
            if (apnContext.getState() == DctConstants.State.FAILED) {
                String str = "trySetupData: make a FAILED ApnContext IDLE so its reusable";
                this.log(str);
                apnContext.requestLog(str);
                apnContext.setState(DctConstants.State.IDLE);
            }
            int radioTech = this.mPhone.getServiceState().getRilDataRadioTechnology();
            apnContext.setConcurrentVoiceAndDataAllowed(this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed());
            if (apnContext.getState() == DctConstants.State.IDLE) {
                ArrayList<ApnSetting> waitingApns = this.buildWaitingApns(apnContext.getApnType(), radioTech);
                if (waitingApns.isEmpty()) {
                    this.notifyNoData(DcFailCause.MISSING_UNKNOWN_APN, apnContext);
                    this.notifyOffApnsOfAvailability(apnContext.getReason());
                    String str = "trySetupData: X No APN found retValue=false";
                    this.log(str);
                    apnContext.requestLog(str);
                    return false;
                }
                apnContext.setWaitingApns(waitingApns);
                this.log("trySetupData: Create from mAllApnSettings : " + this.apnListToString(this.mAllApnSettings));
            }
            boolean retValue = this.setupData(apnContext, radioTech, dataConnectionReasons.contains(DataConnectionReasons.DataAllowedReasonType.UNMETERED_APN));
            this.notifyOffApnsOfAvailability(apnContext.getReason());
            this.log("trySetupData: X retValue=" + retValue);
            return retValue;
        }
        if (!apnContext.getApnType().equals("default") && apnContext.isConnectable()) {
            this.mPhone.notifyDataConnectionFailed(apnContext.getReason(), apnContext.getApnType());
        }
        this.notifyOffApnsOfAvailability(apnContext.getReason());
        StringBuilder str = new StringBuilder();
        str.append("trySetupData failed. apnContext = [type=" + apnContext.getApnType() + ", mState=" + (Object)((Object)apnContext.getState()) + ", apnEnabled=" + apnContext.isEnabled() + ", mDependencyMet=" + apnContext.getDependencyMet() + "] ");
        if (!this.mDataEnabledSettings.isDataEnabled()) {
            str.append("isDataEnabled() = false. " + this.mDataEnabledSettings);
        }
        if (apnContext.getState() == DctConstants.State.SCANNING) {
            apnContext.setState(DctConstants.State.FAILED);
            str.append(" Stop retrying.");
        }
        this.log(str.toString());
        apnContext.requestLog(str.toString());
        return false;
    }

    private void notifyOffApnsOfAvailability(String reason) {
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (this.mAttached.get() && apnContext.isReady()) continue;
            this.mPhone.notifyDataConnection(reason != null ? reason : apnContext.getReason(), apnContext.getApnType(), PhoneConstants.DataState.DISCONNECTED);
        }
    }

    private boolean cleanUpAllConnections(boolean tearDown, String reason) {
        this.log("cleanUpAllConnections: tearDown=" + tearDown + " reason=" + reason);
        boolean didDisconnect = false;
        boolean disableMeteredOnly = false;
        if (!TextUtils.isEmpty(reason)) {
            disableMeteredOnly = reason.equals("specificDisabled") || reason.equals("roamingOn") || reason.equals("carrierActionDisableMeteredApn");
        }
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (!apnContext.isDisconnected()) {
                didDisconnect = true;
            }
            if (disableMeteredOnly) {
                ApnSetting apnSetting = apnContext.getApnSetting();
                if (apnSetting == null || !apnSetting.isMetered(this.mPhone)) continue;
                this.log("clean up metered ApnContext Type: " + apnContext.getApnType());
                apnContext.setReason(reason);
                this.cleanUpConnection(tearDown, apnContext);
                continue;
            }
            apnContext.setReason(reason);
            this.cleanUpConnection(tearDown, apnContext);
        }
        this.stopNetStatPoll();
        this.stopDataStallAlarm();
        this.mRequestedApnType = "default";
        this.log("cleanUpConnection: mDisconnectPendingCount = " + this.mDisconnectPendingCount);
        if (tearDown && this.mDisconnectPendingCount == 0) {
            this.notifyDataDisconnectComplete();
            this.notifyAllDataDisconnected();
        }
        return didDisconnect;
    }

    private void onCleanUpAllConnections(String cause) {
        this.cleanUpAllConnections(true, cause);
    }

    void sendCleanUpConnection(boolean tearDown, ApnContext apnContext) {
        this.log("sendCleanUpConnection: tearDown=" + tearDown + " apnContext=" + apnContext);
        Message msg = this.obtainMessage(270360);
        msg.arg1 = tearDown ? 1 : 0;
        msg.arg2 = 0;
        msg.obj = apnContext;
        this.sendMessage(msg);
    }

    private void cleanUpConnection(boolean tearDown, ApnContext apnContext) {
        if (apnContext == null) {
            this.log("cleanUpConnection: apn context is null");
            return;
        }
        DcAsyncChannel dcac = apnContext.getDcAc();
        String str = "cleanUpConnection: tearDown=" + tearDown + " reason=" + apnContext.getReason();
        apnContext.requestLog(str);
        if (tearDown) {
            if (apnContext.isDisconnected()) {
                apnContext.setState(DctConstants.State.IDLE);
                if (!apnContext.isReady()) {
                    if (dcac != null) {
                        str = "cleanUpConnection: teardown, disconnected, !ready";
                        this.log(str + " apnContext=" + apnContext);
                        apnContext.requestLog(str);
                        dcac.tearDown(apnContext, "", null);
                    }
                    apnContext.setDataConnectionAc(null);
                }
            } else if (dcac != null) {
                if (apnContext.getState() != DctConstants.State.DISCONNECTING) {
                    boolean disconnectAll = false;
                    if ("dun".equals(apnContext.getApnType()) && this.teardownForDun()) {
                        this.log("cleanUpConnection: disconnectAll DUN connection");
                        disconnectAll = true;
                    }
                    int generation = apnContext.getConnectionGeneration();
                    str = "cleanUpConnection: tearing down" + (disconnectAll ? " all" : "") + " using gen#" + generation;
                    this.log(str + "apnContext=" + apnContext);
                    apnContext.requestLog(str);
                    Pair<ApnContext, Integer> pair = new Pair<ApnContext, Integer>(apnContext, generation);
                    Message msg = this.obtainMessage(270351, pair);
                    if (disconnectAll) {
                        apnContext.getDcAc().tearDownAll(apnContext.getReason(), msg);
                    } else {
                        apnContext.getDcAc().tearDown(apnContext, apnContext.getReason(), msg);
                    }
                    apnContext.setState(DctConstants.State.DISCONNECTING);
                    ++this.mDisconnectPendingCount;
                }
            } else {
                apnContext.setState(DctConstants.State.IDLE);
                apnContext.requestLog("cleanUpConnection: connected, bug no DCAC");
                this.mPhone.notifyDataConnection(apnContext.getReason(), apnContext.getApnType());
            }
        } else {
            if (dcac != null) {
                dcac.reqReset();
            }
            apnContext.setState(DctConstants.State.IDLE);
            this.mPhone.notifyDataConnection(apnContext.getReason(), apnContext.getApnType());
            apnContext.setDataConnectionAc(null);
        }
        if (dcac != null) {
            this.cancelReconnectAlarm(apnContext);
        }
        str = "cleanUpConnection: X tearDown=" + tearDown + " reason=" + apnContext.getReason();
        this.log(str + " apnContext=" + apnContext + " dcac=" + apnContext.getDcAc());
        apnContext.requestLog(str);
    }

    public ApnSetting fetchDunApn() {
        String[] apnArrayData;
        if (SystemProperties.getBoolean("net.tethering.noprovisioning", false)) {
            this.log("fetchDunApn: net.tethering.noprovisioning=true ret: null");
            return null;
        }
        int bearer = this.mPhone.getServiceState().getRilDataRadioTechnology();
        IccRecords r = this.mIccRecords.get();
        String operator = r != null ? r.getOperatorNumeric() : "";
        ArrayList<ApnSetting> dunCandidates = new ArrayList<ApnSetting>();
        ApnSetting retDunSetting = null;
        String apnData = Settings.Global.getString(this.mResolver, "tether_dun_apn");
        if (!TextUtils.isEmpty(apnData)) {
            dunCandidates.addAll(ApnSetting.arrayFromString(apnData));
        }
        if (dunCandidates.isEmpty() && !ArrayUtils.isEmpty(apnArrayData = this.mPhone.getContext().getResources().getStringArray(17236030))) {
            for (String apnString : apnArrayData) {
                ApnSetting apn = ApnSetting.fromString(apnString);
                if (apn == null) continue;
                dunCandidates.add(apn);
            }
        }
        if (dunCandidates.isEmpty() && !ArrayUtils.isEmpty(this.mAllApnSettings)) {
            for (ApnSetting apn : this.mAllApnSettings) {
                if (!apn.canHandleType("dun")) continue;
                dunCandidates.add(apn);
            }
        }
        for (ApnSetting dunSetting : dunCandidates) {
            if (!ServiceState.bitmaskHasTech(dunSetting.bearerBitmask, bearer) || !dunSetting.numeric.equals(operator)) continue;
            if (dunSetting.hasMvnoParams()) {
                if (r == null || !ApnSetting.mvnoMatches(r, dunSetting.mvnoType, dunSetting.mvnoMatchData)) continue;
                retDunSetting = dunSetting;
                break;
            }
            if (this.mMvnoMatched) continue;
            retDunSetting = dunSetting;
            break;
        }
        return retDunSetting;
    }

    public boolean hasMatchedTetherApnSetting() {
        ApnSetting matched = this.fetchDunApn();
        this.log("hasMatchedTetherApnSetting: APN=" + matched);
        return matched != null;
    }

    private boolean teardownForDun() {
        int rilRat = this.mPhone.getServiceState().getRilDataRadioTechnology();
        if (ServiceState.isCdma(rilRat)) {
            return true;
        }
        return this.fetchDunApn() != null;
    }

    private void cancelReconnectAlarm(ApnContext apnContext) {
        if (apnContext == null) {
            return;
        }
        PendingIntent intent = apnContext.getReconnectIntent();
        if (intent != null) {
            AlarmManager am = (AlarmManager)this.mPhone.getContext().getSystemService("alarm");
            am.cancel(intent);
            apnContext.setReconnectIntent(null);
        }
    }

    private String[] parseTypes(String types) {
        String[] result = types == null || types.equals("") ? new String[]{"*"} : types.split(",");
        return result;
    }

    boolean isPermanentFailure(DcFailCause dcFailCause) {
        return dcFailCause.isPermanentFailure(this.mPhone.getContext(), this.mPhone.getSubId()) && (!this.mAttached.get() || dcFailCause != DcFailCause.SIGNAL_LOST);
    }

    private ApnSetting makeApnSetting(Cursor cursor) {
        String[] types = this.parseTypes(cursor.getString(cursor.getColumnIndexOrThrow("type")));
        ApnSetting apn = new ApnSetting(cursor.getInt(cursor.getColumnIndexOrThrow("_id")), cursor.getString(cursor.getColumnIndexOrThrow("numeric")), cursor.getString(cursor.getColumnIndexOrThrow("name")), cursor.getString(cursor.getColumnIndexOrThrow("apn")), NetworkUtils.trimV4AddrZeros(cursor.getString(cursor.getColumnIndexOrThrow("proxy"))), cursor.getString(cursor.getColumnIndexOrThrow("port")), NetworkUtils.trimV4AddrZeros(cursor.getString(cursor.getColumnIndexOrThrow("mmsc"))), NetworkUtils.trimV4AddrZeros(cursor.getString(cursor.getColumnIndexOrThrow("mmsproxy"))), cursor.getString(cursor.getColumnIndexOrThrow("mmsport")), cursor.getString(cursor.getColumnIndexOrThrow("user")), cursor.getString(cursor.getColumnIndexOrThrow("password")), cursor.getInt(cursor.getColumnIndexOrThrow("authtype")), types, cursor.getString(cursor.getColumnIndexOrThrow("protocol")), cursor.getString(cursor.getColumnIndexOrThrow("roaming_protocol")), cursor.getInt(cursor.getColumnIndexOrThrow("carrier_enabled")) == 1, cursor.getInt(cursor.getColumnIndexOrThrow("bearer")), cursor.getInt(cursor.getColumnIndexOrThrow("bearer_bitmask")), cursor.getInt(cursor.getColumnIndexOrThrow("profile_id")), cursor.getInt(cursor.getColumnIndexOrThrow("modem_cognitive")) == 1, cursor.getInt(cursor.getColumnIndexOrThrow("max_conns")), cursor.getInt(cursor.getColumnIndexOrThrow("wait_time")), cursor.getInt(cursor.getColumnIndexOrThrow("max_conns_time")), cursor.getInt(cursor.getColumnIndexOrThrow("mtu")), cursor.getString(cursor.getColumnIndexOrThrow("mvno_type")), cursor.getString(cursor.getColumnIndexOrThrow("mvno_match_data")));
        return apn;
    }

    private ArrayList<ApnSetting> createApnList(Cursor cursor) {
        ArrayList<ApnSetting> result;
        ArrayList<ApnSetting> mnoApns = new ArrayList<ApnSetting>();
        ArrayList<ApnSetting> mvnoApns = new ArrayList<ApnSetting>();
        IccRecords r = this.mIccRecords.get();
        if (cursor.moveToFirst()) {
            do {
                ApnSetting apn;
                if ((apn = this.makeApnSetting(cursor)) == null) continue;
                if (apn.hasMvnoParams()) {
                    if (r == null || !ApnSetting.mvnoMatches(r, apn.mvnoType, apn.mvnoMatchData)) continue;
                    mvnoApns.add(apn);
                    continue;
                }
                mnoApns.add(apn);
            } while (cursor.moveToNext());
        }
        if (mvnoApns.isEmpty()) {
            result = mnoApns;
            this.mMvnoMatched = false;
        } else {
            result = mvnoApns;
            this.mMvnoMatched = true;
        }
        this.log("createApnList: X result=" + result);
        return result;
    }

    private boolean dataConnectionNotInUse(DcAsyncChannel dcac) {
        this.log("dataConnectionNotInUse: check if dcac is inuse dcac=" + dcac);
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (apnContext.getDcAc() != dcac) continue;
            this.log("dataConnectionNotInUse: in use by apnContext=" + apnContext);
            return false;
        }
        this.log("dataConnectionNotInUse: tearDownAll");
        dcac.tearDownAll("No connection", null);
        this.log("dataConnectionNotInUse: not in use return true");
        return true;
    }

    private DcAsyncChannel findFreeDataConnection() {
        for (DcAsyncChannel dcac : this.mDataConnectionAcHashMap.values()) {
            if (!dcac.isInactiveSync() || !this.dataConnectionNotInUse(dcac)) continue;
            this.log("findFreeDataConnection: found free DataConnection= dcac=" + dcac);
            return dcac;
        }
        this.log("findFreeDataConnection: NO free DataConnection");
        return null;
    }

    private boolean setupData(ApnContext apnContext, int radioTech, boolean unmeteredUseOnly) {
        ApnSetting dcacApnSetting;
        this.log("setupData: apnContext=" + apnContext);
        apnContext.requestLog("setupData");
        DcAsyncChannel dcac = null;
        ApnSetting apnSetting = apnContext.getNextApnSetting();
        if (apnSetting == null) {
            this.log("setupData: return for no apn found!");
            return false;
        }
        int profileId = apnSetting.profileId;
        if (profileId == 0) {
            profileId = this.getApnProfileID(apnContext.getApnType());
        }
        if (!(apnContext.getApnType() == "dun" && this.teardownForDun() || (dcac = this.checkForCompatibleConnectedApnContext(apnContext)) == null || (dcacApnSetting = dcac.getApnSettingSync()) == null)) {
            apnSetting = dcacApnSetting;
        }
        if (dcac == null) {
            if (this.isOnlySingleDcAllowed(radioTech)) {
                if (this.isHigherPriorityApnContextActive(apnContext)) {
                    this.log("setupData: Higher priority ApnContext active.  Ignoring call");
                    return false;
                }
                if (this.cleanUpAllConnections(true, "SinglePdnArbitration")) {
                    this.log("setupData: Some calls are disconnecting first.  Wait and retry");
                    return false;
                }
                this.log("setupData: Single pdp. Continue setting up data call.");
            }
            if ((dcac = this.findFreeDataConnection()) == null) {
                dcac = this.createDataConnection();
            }
            if (dcac == null) {
                this.log("setupData: No free DataConnection and couldn't create one, WEIRD");
                return false;
            }
        }
        int generation = apnContext.incAndGetConnectionGeneration();
        this.log("setupData: dcac=" + dcac + " apnSetting=" + apnSetting + " gen#=" + generation);
        apnContext.setDataConnectionAc(dcac);
        apnContext.setApnSetting(apnSetting);
        apnContext.setState(DctConstants.State.CONNECTING);
        this.mPhone.notifyDataConnection(apnContext.getReason(), apnContext.getApnType());
        Message msg = this.obtainMessage();
        msg.what = 270336;
        msg.obj = new Pair<ApnContext, Integer>(apnContext, generation);
        dcac.bringUp(apnContext, profileId, radioTech, unmeteredUseOnly, msg, generation);
        this.log("setupData: initing!");
        return true;
    }

    private void setInitialAttachApn() {
        ApnSetting iaApnSetting = null;
        ApnSetting defaultApnSetting = null;
        ApnSetting firstApnSetting = null;
        this.log("setInitialApn: E mPreferredApn=" + this.mPreferredApn);
        if (this.mPreferredApn != null && this.mPreferredApn.canHandleType("ia")) {
            iaApnSetting = this.mPreferredApn;
        } else if (this.mAllApnSettings != null && !this.mAllApnSettings.isEmpty()) {
            firstApnSetting = this.mAllApnSettings.get(0);
            this.log("setInitialApn: firstApnSetting=" + firstApnSetting);
            for (ApnSetting apn : this.mAllApnSettings) {
                if (apn.canHandleType("ia")) {
                    this.log("setInitialApn: iaApnSetting=" + apn);
                    iaApnSetting = apn;
                    break;
                }
                if (defaultApnSetting != null || !apn.canHandleType("default")) continue;
                this.log("setInitialApn: defaultApnSetting=" + apn);
                defaultApnSetting = apn;
            }
        }
        ApnSetting initialAttachApnSetting = null;
        if (iaApnSetting != null) {
            this.log("setInitialAttachApn: using iaApnSetting");
            initialAttachApnSetting = iaApnSetting;
        } else if (this.mPreferredApn != null) {
            this.log("setInitialAttachApn: using mPreferredApn");
            initialAttachApnSetting = this.mPreferredApn;
        } else if (defaultApnSetting != null) {
            this.log("setInitialAttachApn: using defaultApnSetting");
            initialAttachApnSetting = defaultApnSetting;
        } else if (firstApnSetting != null) {
            this.log("setInitialAttachApn: using firstApnSetting");
            initialAttachApnSetting = firstApnSetting;
        }
        if (initialAttachApnSetting == null) {
            this.log("setInitialAttachApn: X There in no available apn");
        } else {
            this.log("setInitialAttachApn: X selected Apn=" + initialAttachApnSetting);
            this.mPhone.mCi.setInitialAttachApn(new DataProfile(initialAttachApnSetting), this.mPhone.getServiceState().getDataRoamingFromRegistration(), null);
        }
    }

    private void onApnChanged() {
        boolean isDisconnected;
        DctConstants.State overallState = this.getOverallState();
        boolean bl = isDisconnected = overallState == DctConstants.State.IDLE || overallState == DctConstants.State.FAILED;
        if (this.mPhone instanceof GsmCdmaPhone) {
            ((GsmCdmaPhone)this.mPhone).updateCurrentCarrierInProvider();
        }
        this.log("onApnChanged: createAllApnList and cleanUpAllConnections");
        this.createAllApnList();
        this.setInitialAttachApn();
        this.cleanUpConnectionsOnUpdatedApns(!isDisconnected, "apnChanged");
        if (this.mPhone.getSubId() == SubscriptionManager.getDefaultDataSubscriptionId()) {
            this.setupDataOnConnectableApns("apnChanged");
        }
    }

    private DcAsyncChannel findDataConnectionAcByCid(int cid) {
        for (DcAsyncChannel dcac : this.mDataConnectionAcHashMap.values()) {
            if (dcac.getCidSync() != cid) continue;
            return dcac;
        }
        return null;
    }

    private void gotoIdleAndNotifyDataConnection(String reason) {
        this.log("gotoIdleAndNotifyDataConnection: reason=" + reason);
        this.notifyDataConnection(reason);
    }

    private boolean isHigherPriorityApnContextActive(ApnContext apnContext) {
        for (ApnContext otherContext : this.mPrioritySortedApnContexts) {
            if (apnContext.getApnType().equalsIgnoreCase(otherContext.getApnType())) {
                return false;
            }
            if (!otherContext.isEnabled() || otherContext.getState() == DctConstants.State.FAILED) continue;
            return true;
        }
        return false;
    }

    private boolean isOnlySingleDcAllowed(int rilRadioTech) {
        PersistableBundle bundle;
        int[] singleDcRats = null;
        CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        if (configManager != null && (bundle = configManager.getConfig()) != null) {
            singleDcRats = bundle.getIntArray("only_single_dc_allowed_int_array");
        }
        boolean onlySingleDcAllowed = false;
        if (Build.IS_DEBUGGABLE && SystemProperties.getBoolean("persist.telephony.test.singleDc", false)) {
            onlySingleDcAllowed = true;
        }
        if (singleDcRats != null) {
            for (int i = 0; i < singleDcRats.length && !onlySingleDcAllowed; ++i) {
                if (rilRadioTech != singleDcRats[i]) continue;
                onlySingleDcAllowed = true;
            }
        }
        this.log("isOnlySingleDcAllowed(" + rilRadioTech + "): " + onlySingleDcAllowed);
        return onlySingleDcAllowed;
    }

    void sendRestartRadio() {
        this.log("sendRestartRadio:");
        Message msg = this.obtainMessage(270362);
        this.sendMessage(msg);
    }

    private void restartRadio() {
        this.log("restartRadio: ************TURN OFF RADIO**************");
        this.cleanUpAllConnections(true, "radioTurnedOff");
        this.mPhone.getServiceStateTracker().powerOffRadioSafely(this);
        int reset = Integer.parseInt(SystemProperties.get("net.ppp.reset-by-timeout", "0"));
        SystemProperties.set("net.ppp.reset-by-timeout", String.valueOf(reset + 1));
    }

    private boolean retryAfterDisconnected(ApnContext apnContext) {
        boolean retry = true;
        String reason = apnContext.getReason();
        if ("radioTurnedOff".equals(reason) || this.isOnlySingleDcAllowed(this.mPhone.getServiceState().getRilDataRadioTechnology()) && this.isHigherPriorityApnContextActive(apnContext)) {
            retry = false;
        }
        return retry;
    }

    private void startAlarmForReconnect(long delay, ApnContext apnContext) {
        String apnType = apnContext.getApnType();
        Intent intent = new Intent("com.android.internal.telephony.data-reconnect." + apnType);
        intent.putExtra(INTENT_RECONNECT_ALARM_EXTRA_REASON, apnContext.getReason());
        intent.putExtra(INTENT_RECONNECT_ALARM_EXTRA_TYPE, apnType);
        intent.addFlags(0x10000000);
        int subId = SubscriptionManager.getDefaultDataSubscriptionId();
        intent.putExtra("subscription", subId);
        this.log("startAlarmForReconnect: delay=" + delay + " action=" + intent.getAction() + " apn=" + apnContext);
        PendingIntent alarmIntent = PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
        apnContext.setReconnectIntent(alarmIntent);
        this.mAlarmManager.setExact(2, SystemClock.elapsedRealtime() + delay, alarmIntent);
    }

    private void notifyNoData(DcFailCause lastFailCauseCode, ApnContext apnContext) {
        this.log("notifyNoData: type=" + apnContext.getApnType());
        if (this.isPermanentFailure(lastFailCauseCode) && !apnContext.getApnType().equals("default")) {
            this.mPhone.notifyDataConnectionFailed(apnContext.getReason(), apnContext.getApnType());
        }
    }

    public boolean getAutoAttachOnCreation() {
        return this.mAutoAttachOnCreation.get();
    }

    private void onRecordsLoadedOrSubIdChanged() {
        this.log("onRecordsLoadedOrSubIdChanged: createAllApnList");
        this.mAutoAttachOnCreationConfig = this.mPhone.getContext().getResources().getBoolean(17956893);
        this.createAllApnList();
        this.setInitialAttachApn();
        if (this.mPhone.mCi.getRadioState().isOn()) {
            this.log("onRecordsLoadedOrSubIdChanged: notifying data availability");
            this.notifyOffApnsOfAvailability("simLoaded");
        }
        this.setupDataOnConnectableApns("simLoaded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSetCarrierDataEnabled(AsyncResult ar) {
        if (ar.exception != null) {
            Rlog.e(LOG_TAG, "CarrierDataEnable exception: " + ar.exception);
            return;
        }
        DataEnabledSettings dataEnabledSettings = this.mDataEnabledSettings;
        synchronized (dataEnabledSettings) {
            boolean enabled = (Boolean)ar.result;
            if (enabled != this.mDataEnabledSettings.isCarrierDataEnabled()) {
                this.log("carrier Action: set metered apns enabled: " + enabled);
                this.mDataEnabledSettings.setCarrierDataEnabled(enabled);
                if (!enabled) {
                    this.mPhone.notifyOtaspChanged(5);
                    this.cleanUpAllConnections(true, "carrierActionDisableMeteredApn");
                } else {
                    int otaspState = this.mPhone.getServiceStateTracker().getOtasp();
                    this.mPhone.notifyOtaspChanged(otaspState);
                    this.reevaluateDataConnections();
                    this.setupDataOnConnectableApns("dataEnabled");
                }
            }
        }
    }

    private void onSimNotReady() {
        this.log("onSimNotReady");
        this.cleanUpAllConnections(true, "simNotReady");
        this.mAllApnSettings = null;
        this.mAutoAttachOnCreationConfig = false;
        this.mAutoAttachOnCreation.set(false);
    }

    private void onSetDependencyMet(String apnType, boolean met) {
        if ("hipri".equals(apnType)) {
            return;
        }
        ApnContext apnContext = this.mApnContexts.get(apnType);
        if (apnContext == null) {
            this.loge("onSetDependencyMet: ApnContext not found in onSetDependencyMet(" + apnType + ", " + met + ")");
            return;
        }
        this.applyNewState(apnContext, apnContext.isEnabled(), met);
        if ("default".equals(apnType) && (apnContext = this.mApnContexts.get("hipri")) != null) {
            this.applyNewState(apnContext, apnContext.isEnabled(), met);
        }
    }

    public void setPolicyDataEnabled(boolean enabled) {
        this.log("setPolicyDataEnabled: " + enabled);
        Message msg = this.obtainMessage(270368);
        msg.arg1 = enabled ? 1 : 0;
        this.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSetPolicyDataEnabled(boolean enabled) {
        DataEnabledSettings dataEnabledSettings = this.mDataEnabledSettings;
        synchronized (dataEnabledSettings) {
            boolean prevEnabled = this.isDataEnabled();
            if (this.mDataEnabledSettings.isPolicyDataEnabled() != enabled) {
                this.mDataEnabledSettings.setPolicyDataEnabled(enabled);
                if (prevEnabled != this.isDataEnabled()) {
                    if (!prevEnabled) {
                        this.reevaluateDataConnections();
                        this.onTrySetupData("dataEnabled");
                    } else {
                        this.onCleanUpAllConnections("specificDisabled");
                    }
                }
            }
        }
    }

    private void applyNewState(ApnContext apnContext, boolean enabled, boolean met) {
        boolean cleanup = false;
        boolean trySetup = false;
        String str = "applyNewState(" + apnContext.getApnType() + ", " + enabled + "(" + apnContext.isEnabled() + "), " + met + "(" + apnContext.getDependencyMet() + "))";
        this.log(str);
        apnContext.requestLog(str);
        if (apnContext.isReady()) {
            cleanup = true;
            if (enabled && met) {
                DctConstants.State state = apnContext.getState();
                switch (state) {
                    case CONNECTED: 
                    case DISCONNECTING: 
                    case CONNECTING: {
                        this.log("applyNewState: 'ready' so return");
                        apnContext.requestLog("applyNewState state=" + (Object)((Object)state) + ", so return");
                        return;
                    }
                    case RETRYING: 
                    case IDLE: 
                    case SCANNING: 
                    case FAILED: {
                        trySetup = true;
                        apnContext.setReason("dataEnabled");
                    }
                }
            } else if (met) {
                apnContext.setReason("dataDisabled");
                if (apnContext.getApnType() == "dun" && this.teardownForDun() || apnContext.getState() != DctConstants.State.CONNECTED) {
                    str = "Clean up the connection. Apn type = " + apnContext.getApnType() + ", state = " + (Object)((Object)apnContext.getState());
                    this.log(str);
                    apnContext.requestLog(str);
                    cleanup = true;
                } else {
                    cleanup = false;
                }
            } else {
                apnContext.setReason("dependencyUnmet");
            }
        } else if (enabled && met) {
            if (apnContext.isEnabled()) {
                apnContext.setReason("dependencyMet");
            } else {
                apnContext.setReason("dataEnabled");
            }
            if (apnContext.getState() == DctConstants.State.FAILED) {
                apnContext.setState(DctConstants.State.IDLE);
            }
            trySetup = true;
        }
        apnContext.setEnabled(enabled);
        apnContext.setDependencyMet(met);
        if (cleanup) {
            this.cleanUpConnection(true, apnContext);
        }
        if (trySetup) {
            apnContext.resetErrorCodeRetries();
            this.trySetupData(apnContext);
        }
    }

    private DcAsyncChannel checkForCompatibleConnectedApnContext(ApnContext apnContext) {
        String apnType = apnContext.getApnType();
        ApnSetting dunSetting = null;
        if ("dun".equals(apnType)) {
            dunSetting = this.fetchDunApn();
        }
        this.log("checkForCompatibleConnectedApnContext: apnContext=" + apnContext);
        DcAsyncChannel potentialDcac = null;
        ApnContext potentialApnCtx = null;
        for (ApnContext curApnCtx : this.mApnContexts.values()) {
            DcAsyncChannel curDcac = curApnCtx.getDcAc();
            if (curDcac == null) continue;
            ApnSetting apnSetting = curApnCtx.getApnSetting();
            this.log("apnSetting: " + apnSetting);
            if (dunSetting != null) {
                if (!dunSetting.equals(apnSetting)) continue;
                switch (curApnCtx.getState()) {
                    case CONNECTED: {
                        this.log("checkForCompatibleConnectedApnContext: found dun conn=" + curDcac + " curApnCtx=" + curApnCtx);
                        return curDcac;
                    }
                    case RETRYING: 
                    case CONNECTING: {
                        potentialDcac = curDcac;
                        potentialApnCtx = curApnCtx;
                    }
                }
                continue;
            }
            if (apnSetting == null || !apnSetting.canHandleType(apnType)) continue;
            switch (curApnCtx.getState()) {
                case CONNECTED: {
                    this.log("checkForCompatibleConnectedApnContext: found canHandle conn=" + curDcac + " curApnCtx=" + curApnCtx);
                    return curDcac;
                }
                case RETRYING: 
                case CONNECTING: {
                    potentialDcac = curDcac;
                    potentialApnCtx = curApnCtx;
                }
            }
        }
        if (potentialDcac != null) {
            this.log("checkForCompatibleConnectedApnContext: found potential conn=" + potentialDcac + " curApnCtx=" + potentialApnCtx);
            return potentialDcac;
        }
        this.log("checkForCompatibleConnectedApnContext: NO conn apnContext=" + apnContext);
        return null;
    }

    public void setEnabled(int id2, boolean enable) {
        Message msg = this.obtainMessage(270349);
        msg.arg1 = id2;
        msg.arg2 = enable ? 1 : 0;
        this.sendMessage(msg);
    }

    private void onEnableApn(int apnId, int enabled) {
        ApnContext apnContext = this.mApnContextsById.get(apnId);
        if (apnContext == null) {
            this.loge("onEnableApn(" + apnId + ", " + enabled + "): NO ApnContext");
            return;
        }
        this.log("onEnableApn: apnContext=" + apnContext + " call applyNewState");
        this.applyNewState(apnContext, enabled == 1, apnContext.getDependencyMet());
        if (enabled == 0 && this.isOnlySingleDcAllowed(this.mPhone.getServiceState().getRilDataRadioTechnology()) && !this.isHigherPriorityApnContextActive(apnContext)) {
            this.log("onEnableApn: isOnlySingleDcAllowed true & higher priority APN disabled");
            this.setupDataOnConnectableApns("SinglePdnArbitration");
        }
    }

    private boolean onTrySetupData(String reason) {
        this.log("onTrySetupData: reason=" + reason);
        this.setupDataOnConnectableApns(reason);
        return true;
    }

    private boolean onTrySetupData(ApnContext apnContext) {
        this.log("onTrySetupData: apnContext=" + apnContext);
        return this.trySetupData(apnContext);
    }

    public boolean getDataEnabled() {
        int device_provisioned = Settings.Global.getInt(this.mResolver, "device_provisioned", 0);
        boolean retVal = "true".equalsIgnoreCase(SystemProperties.get("ro.com.android.mobiledata", "true"));
        if (TelephonyManager.getDefault().getSimCount() == 1) {
            retVal = Settings.Global.getInt(this.mResolver, "mobile_data", retVal ? 1 : 0) != 0;
        } else {
            int phoneSubId = this.mPhone.getSubId();
            try {
                retVal = TelephonyManager.getIntWithSubId(this.mResolver, "mobile_data", phoneSubId) != 0;
            }
            catch (Settings.SettingNotFoundException settingNotFoundException) {
                // empty catch block
            }
        }
        if (device_provisioned == 0) {
            String prov_property = SystemProperties.get("ro.com.android.prov_mobiledata", retVal ? "true" : "false");
            retVal = "true".equalsIgnoreCase(prov_property);
            int prov_mobile_data = Settings.Global.getInt(this.mResolver, "device_provisioning_mobile_data", retVal ? 1 : 0);
            retVal = prov_mobile_data != 0;
            this.log("getDataEnabled during provisioning retVal=" + retVal + " - (" + prov_property + ", " + prov_mobile_data + ")");
        }
        return retVal;
    }

    public void setDataRoamingEnabledByUser(boolean enabled) {
        int phoneSubId = this.mPhone.getSubId();
        if (this.getDataRoamingEnabled() != enabled) {
            int roaming;
            int n = roaming = enabled ? 1 : 0;
            if (TelephonyManager.getDefault().getSimCount() == 1) {
                Settings.Global.putInt(this.mResolver, "data_roaming", roaming);
                this.setDataRoamingFromUserAction(true);
            } else {
                Settings.Global.putInt(this.mResolver, "data_roaming" + phoneSubId, roaming);
            }
            this.mSubscriptionManager.setDataRoaming(roaming, phoneSubId);
            this.log("setDataRoamingEnabledByUser: set phoneSubId=" + phoneSubId + " isRoaming=" + enabled);
        } else {
            this.log("setDataRoamingEnabledByUser: unchanged phoneSubId=" + phoneSubId + " isRoaming=" + enabled);
        }
    }

    public boolean getDataRoamingEnabled() {
        boolean isDataRoamingEnabled;
        int phoneSubId = this.mPhone.getSubId();
        try {
            isDataRoamingEnabled = TelephonyManager.getDefault().getSimCount() == 1 ? Settings.Global.getInt(this.mResolver, "data_roaming", this.getDefaultDataRoamingEnabled() ? 1 : 0) != 0 : TelephonyManager.getIntWithSubId(this.mResolver, "data_roaming", phoneSubId) != 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            this.log("getDataRoamingEnabled: SettingNofFoundException snfe=" + snfe);
            isDataRoamingEnabled = this.getDefaultDataRoamingEnabled();
        }
        return isDataRoamingEnabled;
    }

    private boolean getDefaultDataRoamingEnabled() {
        CarrierConfigManager configMgr = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        boolean isDataRoamingEnabled = "true".equalsIgnoreCase(SystemProperties.get("ro.com.android.dataroaming", "false"));
        return isDataRoamingEnabled |= configMgr.getConfigForSubId(this.mPhone.getSubId()).getBoolean("carrier_default_data_roaming_enabled_bool");
    }

    private void setDefaultDataRoamingEnabled() {
        String setting = "data_roaming";
        boolean useCarrierSpecificDefault = false;
        if (TelephonyManager.getDefault().getSimCount() != 1) {
            setting = setting + this.mPhone.getSubId();
            try {
                Settings.Global.getInt(this.mResolver, setting);
            }
            catch (Settings.SettingNotFoundException ex) {
                useCarrierSpecificDefault = true;
            }
        } else if (!this.isDataRoamingFromUserAction()) {
            useCarrierSpecificDefault = true;
        }
        if (useCarrierSpecificDefault) {
            boolean defaultVal = this.getDefaultDataRoamingEnabled();
            this.log("setDefaultDataRoamingEnabled: " + setting + "default value: " + defaultVal);
            Settings.Global.putInt(this.mResolver, setting, defaultVal ? 1 : 0);
            this.mSubscriptionManager.setDataRoaming(defaultVal ? 1 : 0, this.mPhone.getSubId());
        }
    }

    private boolean isDataRoamingFromUserAction() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext());
        if (!sp.contains("data_roaming_is_user_setting_key") && Settings.Global.getInt(this.mResolver, "device_provisioned", 0) == 0) {
            sp.edit().putBoolean("data_roaming_is_user_setting_key", false).commit();
        }
        return sp.getBoolean("data_roaming_is_user_setting_key", true);
    }

    private void setDataRoamingFromUserAction(boolean isUserAction) {
        SharedPreferences.Editor sp = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext()).edit();
        sp.putBoolean("data_roaming_is_user_setting_key", isUserAction).commit();
    }

    private void onDataRoamingOff() {
        this.log("onDataRoamingOff");
        if (!this.getDataRoamingEnabled()) {
            this.setInitialAttachApn();
            this.setDataProfilesAsNeeded();
            this.notifyOffApnsOfAvailability("roamingOff");
            this.setupDataOnConnectableApns("roamingOff");
        } else {
            this.notifyDataConnection("roamingOff");
        }
    }

    private void onDataRoamingOnOrSettingsChanged(int messageType) {
        boolean settingChanged;
        this.log("onDataRoamingOnOrSettingsChanged");
        boolean bl = settingChanged = messageType == 270384;
        if (!this.mPhone.getServiceState().getDataRoaming()) {
            this.log("device is not roaming. ignored the request.");
            return;
        }
        this.checkDataRoamingStatus(settingChanged);
        if (this.getDataRoamingEnabled()) {
            this.log("onDataRoamingOnOrSettingsChanged: setup data on roaming");
            this.setupDataOnConnectableApns("roamingOn");
            this.notifyDataConnection("roamingOn");
        } else {
            this.log("onDataRoamingOnOrSettingsChanged: Tear down data connection on roaming.");
            this.cleanUpAllConnections(true, "roamingOn");
            this.notifyOffApnsOfAvailability("roamingOn");
        }
    }

    private void checkDataRoamingStatus(boolean settingChanged) {
        if (!settingChanged && !this.getDataRoamingEnabled() && this.mPhone.getServiceState().getDataRoaming()) {
            for (ApnContext apnContext : this.mApnContexts.values()) {
                if (apnContext.getState() != DctConstants.State.CONNECTED) continue;
                this.mDataRoamingLeakageLog.log("PossibleRoamingLeakage  connection params: " + (apnContext.getDcAc() != null ? apnContext.getDcAc().mLastConnectionParams : ""));
            }
        }
    }

    private void onRadioAvailable() {
        IccRecords r;
        this.log("onRadioAvailable");
        if (this.mPhone.getSimulatedRadioControl() != null) {
            this.notifyDataConnection(null);
            this.log("onRadioAvailable: We're on the simulator; assuming data is connected");
        }
        if ((r = this.mIccRecords.get()) != null && r.getRecordsLoaded()) {
            this.notifyOffApnsOfAvailability(null);
        }
        if (this.getOverallState() != DctConstants.State.IDLE) {
            this.cleanUpConnection(true, null);
        }
    }

    private void onRadioOffOrNotAvailable() {
        this.mReregisterOnReconnectFailure = false;
        this.mAutoAttachOnCreation.set(false);
        if (this.mPhone.getSimulatedRadioControl() != null) {
            this.log("We're on the simulator; assuming radio off is meaningless");
        } else {
            this.log("onRadioOffOrNotAvailable: is off and clean up all connections");
            this.cleanUpAllConnections(false, "radioTurnedOff");
        }
        this.notifyOffApnsOfAvailability(null);
    }

    private void completeConnection(ApnContext apnContext) {
        this.log("completeConnection: successful, notify the world apnContext=" + apnContext);
        if (this.mIsProvisioning && !TextUtils.isEmpty(this.mProvisioningUrl)) {
            this.log("completeConnection: MOBILE_PROVISIONING_ACTION url=" + this.mProvisioningUrl);
            Intent newIntent = Intent.makeMainSelectorActivity("android.intent.action.MAIN", "android.intent.category.APP_BROWSER");
            newIntent.setData(Uri.parse(this.mProvisioningUrl));
            newIntent.setFlags(0x10400000);
            try {
                this.mPhone.getContext().startActivity(newIntent);
            }
            catch (ActivityNotFoundException e) {
                this.loge("completeConnection: startActivityAsUser failed" + e);
            }
        }
        this.mIsProvisioning = false;
        this.mProvisioningUrl = null;
        if (this.mProvisioningSpinner != null) {
            this.sendMessage(this.obtainMessage(270378, this.mProvisioningSpinner));
        }
        this.mPhone.notifyDataConnection(apnContext.getReason(), apnContext.getApnType());
        this.startNetStatPoll();
        this.startDataStallAlarm(false);
    }

    private void onDataSetupComplete(AsyncResult ar) {
        DcFailCause cause = DcFailCause.UNKNOWN;
        boolean handleError = false;
        ApnContext apnContext = this.getValidApnContext(ar, "onDataSetupComplete");
        if (apnContext == null) {
            return;
        }
        if (ar.exception == null) {
            DcAsyncChannel dcac = apnContext.getDcAc();
            if (dcac == null) {
                this.log("onDataSetupComplete: no connection to DC, handle as error");
                cause = DcFailCause.CONNECTION_TO_DATACONNECTIONAC_BROKEN;
                handleError = true;
            } else {
                String radioTestProperty;
                int pcoVal;
                ApnSetting apn = apnContext.getApnSetting();
                this.log("onDataSetupComplete: success apn=" + (apn == null ? "unknown" : apn.apn));
                if (apn != null && apn.proxy != null && apn.proxy.length() != 0) {
                    try {
                        String port = apn.port;
                        if (TextUtils.isEmpty(port)) {
                            port = "8080";
                        }
                        ProxyInfo proxy = new ProxyInfo(apn.proxy, Integer.parseInt(port), null);
                        dcac.setLinkPropertiesHttpProxySync(proxy);
                    }
                    catch (NumberFormatException e) {
                        this.loge("onDataSetupComplete: NumberFormatException making ProxyProperties (" + apn.port + "): " + e);
                    }
                }
                if (TextUtils.equals(apnContext.getApnType(), "default")) {
                    try {
                        SystemProperties.set(PUPPET_MASTER_RADIO_STRESS_TEST, "true");
                    }
                    catch (RuntimeException ex) {
                        this.log("Failed to set PUPPET_MASTER_RADIO_STRESS_TEST to true");
                    }
                    if (this.mCanSetPreferApn && this.mPreferredApn == null) {
                        this.log("onDataSetupComplete: PREFERRED APN is null");
                        this.mPreferredApn = apn;
                        if (this.mPreferredApn != null) {
                            this.setPreferredApn(this.mPreferredApn.id);
                        }
                    }
                } else {
                    try {
                        SystemProperties.set(PUPPET_MASTER_RADIO_STRESS_TEST, "false");
                    }
                    catch (RuntimeException ex) {
                        this.log("Failed to set PUPPET_MASTER_RADIO_STRESS_TEST to false");
                    }
                }
                apnContext.setState(DctConstants.State.CONNECTED);
                this.checkDataRoamingStatus(false);
                boolean isProvApn = apnContext.isProvisioningApn();
                ConnectivityManager cm = ConnectivityManager.from(this.mPhone.getContext());
                if (this.mProvisionBroadcastReceiver != null) {
                    this.mPhone.getContext().unregisterReceiver(this.mProvisionBroadcastReceiver);
                    this.mProvisionBroadcastReceiver = null;
                }
                if (!isProvApn || this.mIsProvisioning) {
                    cm.setProvisioningNotificationVisible(false, 0, this.mProvisionActionName);
                    this.completeConnection(apnContext);
                } else {
                    this.log("onDataSetupComplete: successful, BUT send connected to prov apn as mIsProvisioning:" + this.mIsProvisioning + " == false" + " && (isProvisioningApn:" + isProvApn + " == true");
                    this.mProvisionBroadcastReceiver = new ProvisionNotificationBroadcastReceiver(cm.getMobileProvisioningUrl(), TelephonyManager.getDefault().getNetworkOperatorName());
                    this.mPhone.getContext().registerReceiver(this.mProvisionBroadcastReceiver, new IntentFilter(this.mProvisionActionName));
                    cm.setProvisioningNotificationVisible(true, 0, this.mProvisionActionName);
                    this.setRadio(false);
                }
                this.log("onDataSetupComplete: SETUP complete type=" + apnContext.getApnType() + ", reason:" + apnContext.getReason());
                if (Build.IS_DEBUGGABLE && (pcoVal = SystemProperties.getInt(radioTestProperty = "persist.radio.test.pco", -1)) != -1) {
                    this.log("PCO testing: read pco value from persist.radio.test.pco " + pcoVal);
                    byte[] value = new byte[]{(byte)pcoVal};
                    Intent intent = new Intent("com.android.internal.telephony.CARRIER_SIGNAL_PCO_VALUE");
                    intent.putExtra("apnType", "default");
                    intent.putExtra("apnProto", "IPV4V6");
                    intent.putExtra("pcoId", 65280);
                    intent.putExtra("pcoValue", value);
                    this.mPhone.getCarrierSignalAgent().notifyCarrierSignalReceivers(intent);
                }
            }
        } else {
            cause = (DcFailCause)((Object)ar.result);
            ApnSetting apn = apnContext.getApnSetting();
            this.log(String.format("onDataSetupComplete: error apn=%s cause=%s", new Object[]{apn == null ? "unknown" : apn.apn, cause}));
            if (cause.isEventLoggable()) {
                int cid = this.getCellLocationId();
                EventLog.writeEvent(50105, cause.ordinal(), cid, TelephonyManager.getDefault().getNetworkType());
            }
            apn = apnContext.getApnSetting();
            this.mPhone.notifyPreciseDataConnectionFailed(apnContext.getReason(), apnContext.getApnType(), apn != null ? apn.apn : "unknown", cause.toString());
            Intent intent = new Intent("com.android.internal.telephony.CARRIER_SIGNAL_REQUEST_NETWORK_FAILED");
            intent.putExtra("errorCode", cause.getErrorCode());
            intent.putExtra("apnType", apnContext.getApnType());
            this.mPhone.getCarrierSignalAgent().notifyCarrierSignalReceivers(intent);
            if (cause.isRestartRadioFail(this.mPhone.getContext(), this.mPhone.getSubId()) || apnContext.restartOnError(cause.getErrorCode())) {
                this.log("Modem restarted.");
                this.sendRestartRadio();
            }
            if (this.isPermanentFailure(cause)) {
                this.log("cause = " + (Object)((Object)cause) + ", mark apn as permanent failed. apn = " + apn);
                apnContext.markApnPermanentFailed(apn);
            }
            handleError = true;
        }
        if (handleError) {
            this.onDataSetupCompleteError(ar);
        }
        if (!this.mDataEnabledSettings.isInternalDataEnabled()) {
            this.cleanUpAllConnections("dataDisabled");
        }
    }

    private ApnContext getValidApnContext(AsyncResult ar, String logString) {
        if (ar != null && ar.userObj instanceof Pair) {
            Pair pair = (Pair)ar.userObj;
            ApnContext apnContext = (ApnContext)pair.first;
            if (apnContext != null) {
                int generation = apnContext.getConnectionGeneration();
                this.log("getValidApnContext (" + logString + ") on " + apnContext + " got " + generation + " vs " + pair.second);
                if (generation == (Integer)pair.second) {
                    return apnContext;
                }
                this.log("ignoring obsolete " + logString);
                return null;
            }
        }
        throw new RuntimeException(logString + ": No apnContext");
    }

    private void onDataSetupCompleteError(AsyncResult ar) {
        ApnContext apnContext = this.getValidApnContext(ar, "onDataSetupCompleteError");
        if (apnContext == null) {
            return;
        }
        long delay = apnContext.getDelayForNextApn(this.mFailFast);
        if (delay >= 0L) {
            this.log("onDataSetupCompleteError: Try next APN. delay = " + delay);
            apnContext.setState(DctConstants.State.SCANNING);
            this.startAlarmForReconnect(delay, apnContext);
        } else {
            apnContext.setState(DctConstants.State.FAILED);
            this.mPhone.notifyDataConnection("apnFailed", apnContext.getApnType());
            apnContext.setDataConnectionAc(null);
            this.log("onDataSetupCompleteError: Stop retrying APNs.");
        }
    }

    private void onDataConnectionRedirected(String redirectUrl) {
        if (!TextUtils.isEmpty(redirectUrl)) {
            Intent intent = new Intent("com.android.internal.telephony.CARRIER_SIGNAL_REDIRECTED");
            intent.putExtra("redirectionUrl", redirectUrl);
            this.mPhone.getCarrierSignalAgent().notifyCarrierSignalReceivers(intent);
            this.log("Notify carrier signal receivers with redirectUrl: " + redirectUrl);
        }
    }

    private void onDisconnectDone(AsyncResult ar) {
        ApnContext apnContext = this.getValidApnContext(ar, "onDisconnectDone");
        if (apnContext == null) {
            return;
        }
        this.log("onDisconnectDone: EVENT_DISCONNECT_DONE apnContext=" + apnContext);
        apnContext.setState(DctConstants.State.IDLE);
        this.mPhone.notifyDataConnection(apnContext.getReason(), apnContext.getApnType());
        if (this.isDisconnected() && this.mPhone.getServiceStateTracker().processPendingRadioPowerOffAfterDataOff()) {
            this.log("onDisconnectDone: radio will be turned off, no retries");
            apnContext.setApnSetting(null);
            apnContext.setDataConnectionAc(null);
            if (this.mDisconnectPendingCount > 0) {
                --this.mDisconnectPendingCount;
            }
            if (this.mDisconnectPendingCount == 0) {
                this.notifyDataDisconnectComplete();
                this.notifyAllDataDisconnected();
            }
            return;
        }
        if (this.mAttached.get() && apnContext.isReady() && this.retryAfterDisconnected(apnContext)) {
            try {
                SystemProperties.set(PUPPET_MASTER_RADIO_STRESS_TEST, "false");
            }
            catch (RuntimeException ex) {
                this.log("Failed to set PUPPET_MASTER_RADIO_STRESS_TEST to false");
            }
            this.log("onDisconnectDone: attached, ready and retry after disconnect");
            long delay = apnContext.getRetryAfterDisconnectDelay();
            if (delay > 0L) {
                this.startAlarmForReconnect(delay, apnContext);
            }
        } else {
            boolean restartRadioAfterProvisioning = this.mPhone.getContext().getResources().getBoolean(17956998);
            if (apnContext.isProvisioningApn() && restartRadioAfterProvisioning) {
                this.log("onDisconnectDone: restartRadio after provisioning");
                this.restartRadio();
            }
            apnContext.setApnSetting(null);
            apnContext.setDataConnectionAc(null);
            if (this.isOnlySingleDcAllowed(this.mPhone.getServiceState().getRilDataRadioTechnology())) {
                this.log("onDisconnectDone: isOnlySigneDcAllowed true so setup single apn");
                this.setupDataOnConnectableApns("SinglePdnArbitration");
            } else {
                this.log("onDisconnectDone: not retrying");
            }
        }
        if (this.mDisconnectPendingCount > 0) {
            --this.mDisconnectPendingCount;
        }
        if (this.mDisconnectPendingCount == 0) {
            apnContext.setConcurrentVoiceAndDataAllowed(this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed());
            this.notifyDataDisconnectComplete();
            this.notifyAllDataDisconnected();
        }
    }

    private void onDisconnectDcRetrying(AsyncResult ar) {
        ApnContext apnContext = this.getValidApnContext(ar, "onDisconnectDcRetrying");
        if (apnContext == null) {
            return;
        }
        apnContext.setState(DctConstants.State.RETRYING);
        this.log("onDisconnectDcRetrying: apnContext=" + apnContext);
        this.mPhone.notifyDataConnection(apnContext.getReason(), apnContext.getApnType());
    }

    private void onVoiceCallStarted() {
        this.log("onVoiceCallStarted");
        this.mInVoiceCall = true;
        if (this.isConnected() && !this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed()) {
            this.log("onVoiceCallStarted stop polling");
            this.stopNetStatPoll();
            this.stopDataStallAlarm();
            this.notifyDataConnection("2GVoiceCallStarted");
        }
    }

    private void onVoiceCallEnded() {
        this.log("onVoiceCallEnded");
        this.mInVoiceCall = false;
        if (this.isConnected()) {
            if (!this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed()) {
                this.startNetStatPoll();
                this.startDataStallAlarm(false);
                this.notifyDataConnection("2GVoiceCallEnded");
            } else {
                this.resetPollStats();
            }
        }
        this.setupDataOnConnectableApns("2GVoiceCallEnded");
    }

    private void onCleanUpConnection(boolean tearDown, int apnId, String reason) {
        this.log("onCleanUpConnection");
        ApnContext apnContext = this.mApnContextsById.get(apnId);
        if (apnContext != null) {
            apnContext.setReason(reason);
            this.cleanUpConnection(tearDown, apnContext);
        }
    }

    private boolean isConnected() {
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (apnContext.getState() != DctConstants.State.CONNECTED) continue;
            return true;
        }
        return false;
    }

    public boolean isDisconnected() {
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (apnContext.isDisconnected()) continue;
            return false;
        }
        return true;
    }

    private void notifyDataConnection(String reason) {
        this.log("notifyDataConnection: reason=" + reason);
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (!this.mAttached.get() || !apnContext.isReady()) continue;
            this.log("notifyDataConnection: type:" + apnContext.getApnType());
            this.mPhone.notifyDataConnection(reason != null ? reason : apnContext.getReason(), apnContext.getApnType());
        }
        this.notifyOffApnsOfAvailability(reason);
    }

    private void setDataProfilesAsNeeded() {
        this.log("setDataProfilesAsNeeded");
        if (this.mAllApnSettings != null && !this.mAllApnSettings.isEmpty()) {
            ArrayList<DataProfile> dps = new ArrayList<DataProfile>();
            for (ApnSetting apn : this.mAllApnSettings) {
                DataProfile dp;
                if (!apn.modemCognitive || dps.contains(dp = new DataProfile(apn))) continue;
                dps.add(dp);
            }
            if (dps.size() > 0) {
                this.mPhone.mCi.setDataProfile(dps.toArray(new DataProfile[0]), this.mPhone.getServiceState().getDataRoamingFromRegistration(), null);
            }
        }
    }

    private void createAllApnList() {
        String operator;
        this.mMvnoMatched = false;
        this.mAllApnSettings = new ArrayList();
        IccRecords r = this.mIccRecords.get();
        String string2 = operator = r != null ? r.getOperatorNumeric() : "";
        if (operator != null) {
            String selection = "numeric = '" + operator + "'";
            this.log("createAllApnList: selection=" + selection);
            Cursor cursor = this.mPhone.getContext().getContentResolver().query(Telephony.Carriers.CONTENT_URI, null, selection, null, "_id");
            if (cursor != null) {
                if (cursor.getCount() > 0) {
                    this.mAllApnSettings = this.createApnList(cursor);
                }
                cursor.close();
            }
        }
        this.addEmergencyApnSetting();
        this.dedupeApnSettings();
        if (this.mAllApnSettings.isEmpty()) {
            this.log("createAllApnList: No APN found for carrier: " + operator);
            this.mPreferredApn = null;
        } else {
            this.mPreferredApn = this.getPreferredApn();
            if (this.mPreferredApn != null && !this.mPreferredApn.numeric.equals(operator)) {
                this.mPreferredApn = null;
                this.setPreferredApn(-1);
            }
            this.log("createAllApnList: mPreferredApn=" + this.mPreferredApn);
        }
        this.log("createAllApnList: X mAllApnSettings=" + this.mAllApnSettings);
        this.setDataProfilesAsNeeded();
    }

    private void dedupeApnSettings() {
        ArrayList resultApns = new ArrayList();
        for (int i = 0; i < this.mAllApnSettings.size() - 1; ++i) {
            ApnSetting first = this.mAllApnSettings.get(i);
            ApnSetting second = null;
            int j = i + 1;
            while (j < this.mAllApnSettings.size()) {
                second = this.mAllApnSettings.get(j);
                if (first.similar(second)) {
                    ApnSetting newApn = this.mergeApns(first, second);
                    this.mAllApnSettings.set(i, newApn);
                    first = newApn;
                    this.mAllApnSettings.remove(j);
                    continue;
                }
                ++j;
            }
        }
    }

    private ApnSetting mergeApns(ApnSetting dest, ApnSetting src) {
        int id2 = dest.id;
        ArrayList<String> resultTypes = new ArrayList<String>();
        resultTypes.addAll(Arrays.asList(dest.types));
        for (String srcType : src.types) {
            if (!resultTypes.contains(srcType)) {
                resultTypes.add(srcType);
            }
            if (!srcType.equals("default")) continue;
            id2 = src.id;
        }
        String mmsc = TextUtils.isEmpty(dest.mmsc) ? src.mmsc : dest.mmsc;
        String mmsProxy = TextUtils.isEmpty(dest.mmsProxy) ? src.mmsProxy : dest.mmsProxy;
        String mmsPort = TextUtils.isEmpty(dest.mmsPort) ? src.mmsPort : dest.mmsPort;
        String proxy = TextUtils.isEmpty(dest.proxy) ? src.proxy : dest.proxy;
        String port = TextUtils.isEmpty(dest.port) ? src.port : dest.port;
        String protocol = src.protocol.equals("IPV4V6") ? src.protocol : dest.protocol;
        String roamingProtocol = src.roamingProtocol.equals("IPV4V6") ? src.roamingProtocol : dest.roamingProtocol;
        int bearerBitmask = dest.bearerBitmask == 0 || src.bearerBitmask == 0 ? 0 : dest.bearerBitmask | src.bearerBitmask;
        return new ApnSetting(id2, dest.numeric, dest.carrier, dest.apn, proxy, port, mmsc, mmsProxy, mmsPort, dest.user, dest.password, dest.authType, resultTypes.toArray(new String[0]), protocol, roamingProtocol, dest.carrierEnabled, 0, bearerBitmask, dest.profileId, dest.modemCognitive || src.modemCognitive, dest.maxConns, dest.waitTime, dest.maxConnsTime, dest.mtu, dest.mvnoType, dest.mvnoMatchData);
    }

    private DcAsyncChannel createDataConnection() {
        this.log("createDataConnection E");
        int id2 = this.mUniqueIdGenerator.getAndIncrement();
        DataConnection conn = DataConnection.makeDataConnection(this.mPhone, id2, this, this.mDcTesterFailBringUpAll, this.mDcc);
        this.mDataConnections.put(id2, conn);
        DcAsyncChannel dcac = new DcAsyncChannel(conn, LOG_TAG);
        int status = dcac.fullyConnectSync(this.mPhone.getContext(), this, conn.getHandler());
        if (status == 0) {
            this.mDataConnectionAcHashMap.put(dcac.getDataConnectionIdSync(), dcac);
        } else {
            this.loge("createDataConnection: Could not connect to dcac=" + dcac + " status=" + status);
        }
        this.log("createDataConnection() X id=" + id2 + " dc=" + conn);
        return dcac;
    }

    private void destroyDataConnections() {
        if (this.mDataConnections != null) {
            this.log("destroyDataConnections: clear mDataConnectionList");
            this.mDataConnections.clear();
        } else {
            this.log("destroyDataConnections: mDataConnecitonList is empty, ignore");
        }
    }

    private ArrayList<ApnSetting> buildWaitingApns(String requestedApnType, int radioTech) {
        ApnSetting dun;
        this.log("buildWaitingApns: E requestedApnType=" + requestedApnType);
        ArrayList<ApnSetting> apnList = new ArrayList<ApnSetting>();
        if (requestedApnType.equals("dun") && (dun = this.fetchDunApn()) != null) {
            apnList.add(dun);
            this.log("buildWaitingApns: X added APN_TYPE_DUN apnList=" + apnList);
            return apnList;
        }
        IccRecords r = this.mIccRecords.get();
        String operator = r != null ? r.getOperatorNumeric() : "";
        boolean usePreferred = true;
        try {
            usePreferred = !this.mPhone.getContext().getResources().getBoolean(17956930);
        }
        catch (Resources.NotFoundException e) {
            this.log("buildWaitingApns: usePreferred NotFoundException set to true");
            usePreferred = true;
        }
        if (usePreferred) {
            this.mPreferredApn = this.getPreferredApn();
        }
        this.log("buildWaitingApns: usePreferred=" + usePreferred + " canSetPreferApn=" + this.mCanSetPreferApn + " mPreferredApn=" + this.mPreferredApn + " operator=" + operator + " radioTech=" + radioTech + " IccRecords r=" + r);
        if (usePreferred && this.mCanSetPreferApn && this.mPreferredApn != null && this.mPreferredApn.canHandleType(requestedApnType)) {
            this.log("buildWaitingApns: Preferred APN:" + operator + ":" + this.mPreferredApn.numeric + ":" + this.mPreferredApn);
            if (this.mPreferredApn.numeric.equals(operator)) {
                if (ServiceState.bitmaskHasTech(this.mPreferredApn.bearerBitmask, radioTech)) {
                    apnList.add(this.mPreferredApn);
                    this.log("buildWaitingApns: X added preferred apnList=" + apnList);
                    return apnList;
                }
                this.log("buildWaitingApns: no preferred APN");
                this.setPreferredApn(-1);
                this.mPreferredApn = null;
            } else {
                this.log("buildWaitingApns: no preferred APN");
                this.setPreferredApn(-1);
                this.mPreferredApn = null;
            }
        }
        if (this.mAllApnSettings != null) {
            this.log("buildWaitingApns: mAllApnSettings=" + this.mAllApnSettings);
            for (ApnSetting apn : this.mAllApnSettings) {
                if (apn.canHandleType(requestedApnType)) {
                    if (ServiceState.bitmaskHasTech(apn.bearerBitmask, radioTech)) {
                        this.log("buildWaitingApns: adding apn=" + apn);
                        apnList.add(apn);
                        continue;
                    }
                    this.log("buildWaitingApns: bearerBitmask:" + apn.bearerBitmask + " does " + "not include radioTech:" + radioTech);
                    continue;
                }
                this.log("buildWaitingApns: couldn't handle requested ApnType=" + requestedApnType);
            }
        } else {
            this.loge("mAllApnSettings is null!");
        }
        this.log("buildWaitingApns: " + apnList.size() + " APNs in the list: " + apnList);
        return apnList;
    }

    private String apnListToString(ArrayList<ApnSetting> apns) {
        StringBuilder result = new StringBuilder();
        int size = apns.size();
        for (int i = 0; i < size; ++i) {
            result.append('[').append(apns.get(i).toString()).append(']');
        }
        return result.toString();
    }

    private void setPreferredApn(int pos) {
        if (!this.mCanSetPreferApn) {
            this.log("setPreferredApn: X !canSEtPreferApn");
            return;
        }
        String subId = Long.toString(this.mPhone.getSubId());
        Uri uri = Uri.withAppendedPath(PREFERAPN_NO_UPDATE_URI_USING_SUBID, subId);
        this.log("setPreferredApn: delete");
        ContentResolver resolver = this.mPhone.getContext().getContentResolver();
        resolver.delete(uri, null, null);
        if (pos >= 0) {
            this.log("setPreferredApn: insert");
            ContentValues values = new ContentValues();
            values.put(APN_ID, pos);
            resolver.insert(uri, values);
        }
    }

    private ApnSetting getPreferredApn() {
        if (this.mAllApnSettings == null || this.mAllApnSettings.isEmpty()) {
            this.log("getPreferredApn: mAllApnSettings is " + (this.mAllApnSettings == null ? "null" : "empty"));
            return null;
        }
        String subId = Long.toString(this.mPhone.getSubId());
        Uri uri = Uri.withAppendedPath(PREFERAPN_NO_UPDATE_URI_USING_SUBID, subId);
        Cursor cursor = this.mPhone.getContext().getContentResolver().query(uri, new String[]{"_id", "name", "apn"}, null, null, "name ASC");
        this.mCanSetPreferApn = cursor != null;
        this.log("getPreferredApn: mRequestedApnType=" + this.mRequestedApnType + " cursor=" + cursor + " cursor.count=" + (cursor != null ? cursor.getCount() : 0));
        if (this.mCanSetPreferApn && cursor.getCount() > 0) {
            cursor.moveToFirst();
            int pos = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
            for (ApnSetting p : this.mAllApnSettings) {
                this.log("getPreferredApn: apnSetting=" + p);
                if (p.id != pos || !p.canHandleType(this.mRequestedApnType)) continue;
                this.log("getPreferredApn: X found apnSetting" + p);
                cursor.close();
                return p;
            }
        }
        if (cursor != null) {
            cursor.close();
        }
        this.log("getPreferredApn: X not found");
        return null;
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 270338: {
                int subId = this.mPhone.getSubId();
                if (SubscriptionManager.isValidSubscriptionId(subId)) {
                    this.onRecordsLoadedOrSubIdChanged();
                    break;
                }
                this.log("Ignoring EVENT_RECORDS_LOADED as subId is not valid: " + subId);
                break;
            }
            case 270345: {
                this.onDataConnectionDetached();
                break;
            }
            case 270352: {
                this.onDataConnectionAttached();
                break;
            }
            case 270354: {
                this.doRecovery();
                break;
            }
            case 270355: {
                this.onApnChanged();
                break;
            }
            case 270358: {
                this.log("EVENT_PS_RESTRICT_ENABLED " + this.mIsPsRestricted);
                this.stopNetStatPoll();
                this.stopDataStallAlarm();
                this.mIsPsRestricted = true;
                break;
            }
            case 270359: {
                ApnContext apnContext;
                this.log("EVENT_PS_RESTRICT_DISABLED " + this.mIsPsRestricted);
                this.mIsPsRestricted = false;
                if (this.isConnected()) {
                    this.startNetStatPoll();
                    this.startDataStallAlarm(false);
                    break;
                }
                if (this.mState == DctConstants.State.FAILED) {
                    this.cleanUpAllConnections(false, "psRestrictEnabled");
                    this.mReregisterOnReconnectFailure = false;
                }
                if ((apnContext = this.mApnContextsById.get(0)) != null) {
                    apnContext.setReason("psRestrictEnabled");
                    this.trySetupData(apnContext);
                    break;
                }
                this.loge("**** Default ApnContext not found ****");
                if (!Build.IS_DEBUGGABLE) break;
                throw new RuntimeException("Default ApnContext not found");
            }
            case 270339: {
                if (msg.obj instanceof ApnContext) {
                    this.onTrySetupData((ApnContext)msg.obj);
                    break;
                }
                if (msg.obj instanceof String) {
                    this.onTrySetupData((String)msg.obj);
                    break;
                }
                this.loge("EVENT_TRY_SETUP request w/o apnContext or String");
                break;
            }
            case 270360: {
                boolean tearDown = msg.arg1 != 0;
                this.log("EVENT_CLEAN_UP_CONNECTION tearDown=" + tearDown);
                if (msg.obj instanceof ApnContext) {
                    this.cleanUpConnection(tearDown, (ApnContext)msg.obj);
                    break;
                }
                this.onCleanUpConnection(tearDown, msg.arg2, (String)msg.obj);
                break;
            }
            case 270363: {
                boolean enabled = msg.arg1 == 1;
                this.onSetInternalDataEnabled(enabled, (Message)msg.obj);
                break;
            }
            case 270365: {
                if (msg.obj != null && !(msg.obj instanceof String)) {
                    msg.obj = null;
                }
                this.onCleanUpAllConnections((String)msg.obj);
                break;
            }
            case 270377: {
                if (this.mPhone.getServiceState().getRilDataRadioTechnology() == 0) break;
                this.cleanUpConnectionsOnUpdatedApns(false, "nwTypeChanged");
                this.setupDataOnConnectableApns("nwTypeChanged", RetryFailures.ONLY_ON_CHANGE);
                break;
            }
            case 270378: {
                if (this.mProvisioningSpinner != msg.obj) break;
                this.mProvisioningSpinner.dismiss();
                this.mProvisioningSpinner = null;
                break;
            }
            case 69636: {
                this.log("DISCONNECTED_CONNECTED: msg=" + msg);
                DcAsyncChannel dcac = (DcAsyncChannel)msg.obj;
                this.mDataConnectionAcHashMap.remove(dcac.getDataConnectionIdSync());
                dcac.disconnected();
                break;
            }
            case 270349: {
                this.onEnableApn(msg.arg1, msg.arg2);
                break;
            }
            case 270353: {
                this.onDataStallAlarm(msg.arg1);
                break;
            }
            case 270348: {
                this.onDataRoamingOff();
                break;
            }
            case 270347: 
            case 270384: {
                this.onDataRoamingOnOrSettingsChanged(msg.what);
                break;
            }
            case 270379: {
                this.onDeviceProvisionedChange();
                break;
            }
            case 270380: {
                String url = (String)msg.obj;
                this.log("dataConnectionTracker.handleMessage: EVENT_REDIRECTION_DETECTED=" + url);
                this.onDataConnectionRedirected(url);
            }
            case 270337: {
                this.onRadioAvailable();
                break;
            }
            case 270342: {
                this.onRadioOffOrNotAvailable();
                break;
            }
            case 270336: {
                this.onDataSetupComplete((AsyncResult)msg.obj);
                break;
            }
            case 270371: {
                this.onDataSetupCompleteError((AsyncResult)msg.obj);
                break;
            }
            case 270351: {
                this.log("DataConnectionTracker.handleMessage: EVENT_DISCONNECT_DONE msg=" + msg);
                this.onDisconnectDone((AsyncResult)msg.obj);
                break;
            }
            case 270370: {
                this.log("DataConnectionTracker.handleMessage: EVENT_DISCONNECT_DC_RETRYING msg=" + msg);
                this.onDisconnectDcRetrying((AsyncResult)msg.obj);
                break;
            }
            case 270343: {
                this.onVoiceCallStarted();
                break;
            }
            case 270344: {
                this.onVoiceCallEnded();
                break;
            }
            case 270364: {
                this.log("EVENT_RESET_DONE");
                this.onResetDone((AsyncResult)msg.obj);
                break;
            }
            case 270366: {
                boolean enabled = msg.arg1 == 1;
                this.log("CMD_SET_USER_DATA_ENABLE enabled=" + enabled);
                this.onSetUserDataEnabled(enabled);
                break;
            }
            case 270367: {
                String apnType;
                boolean met = msg.arg1 == 1;
                this.log("CMD_SET_DEPENDENCY_MET met=" + met);
                Bundle bundle = msg.getData();
                if (bundle == null || (apnType = (String)bundle.get("apnType")) == null) break;
                this.onSetDependencyMet(apnType, met);
                break;
            }
            case 270368: {
                boolean enabled = msg.arg1 == 1;
                this.onSetPolicyDataEnabled(enabled);
                break;
            }
            case 270372: {
                this.log("CMD_SET_ENABLE_FAIL_FAST_MOBILE_DATA:  sEnableFailFastRefCounter=" + (sEnableFailFastRefCounter += msg.arg1 == 1 ? 1 : -1));
                if (sEnableFailFastRefCounter < 0) {
                    String s = "CMD_SET_ENABLE_FAIL_FAST_MOBILE_DATA: sEnableFailFastRefCounter:" + sEnableFailFastRefCounter + " < 0";
                    this.loge(s);
                    sEnableFailFastRefCounter = 0;
                }
                boolean enabled = sEnableFailFastRefCounter > 0;
                this.log("CMD_SET_ENABLE_FAIL_FAST_MOBILE_DATA: enabled=" + enabled + " sEnableFailFastRefCounter=" + sEnableFailFastRefCounter);
                if (this.mFailFast == enabled) break;
                this.mFailFast = enabled;
                boolean bl = this.mDataStallDetectionEnabled = !enabled;
                if (this.mDataStallDetectionEnabled && this.getOverallState() == DctConstants.State.CONNECTED && (!this.mInVoiceCall || this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed())) {
                    this.log("CMD_SET_ENABLE_FAIL_FAST_MOBILE_DATA: start data stall");
                    this.stopDataStallAlarm();
                    this.startDataStallAlarm(false);
                    break;
                }
                this.log("CMD_SET_ENABLE_FAIL_FAST_MOBILE_DATA: stop data stall");
                this.stopDataStallAlarm();
                break;
            }
            case 270373: {
                Bundle bundle = msg.getData();
                if (bundle != null) {
                    try {
                        this.mProvisioningUrl = (String)bundle.get("provisioningUrl");
                    }
                    catch (ClassCastException e) {
                        this.loge("CMD_ENABLE_MOBILE_PROVISIONING: provisioning url not a string" + e);
                        this.mProvisioningUrl = null;
                    }
                }
                if (TextUtils.isEmpty(this.mProvisioningUrl)) {
                    this.loge("CMD_ENABLE_MOBILE_PROVISIONING: provisioning url is empty, ignoring");
                    this.mIsProvisioning = false;
                    this.mProvisioningUrl = null;
                    break;
                }
                this.loge("CMD_ENABLE_MOBILE_PROVISIONING: provisioningUrl=" + this.mProvisioningUrl);
                this.mIsProvisioning = true;
                this.startProvisioningApnAlarm();
                break;
            }
            case 270375: {
                this.log("EVENT_PROVISIONING_APN_ALARM");
                ApnContext apnCtx = this.mApnContextsById.get(0);
                if (apnCtx.isProvisioningApn() && apnCtx.isConnectedOrConnecting()) {
                    if (this.mProvisioningApnAlarmTag == msg.arg1) {
                        this.log("EVENT_PROVISIONING_APN_ALARM: Disconnecting");
                        this.mIsProvisioning = false;
                        this.mProvisioningUrl = null;
                        this.stopProvisioningApnAlarm();
                        this.sendCleanUpConnection(true, apnCtx);
                        break;
                    }
                    this.log("EVENT_PROVISIONING_APN_ALARM: ignore stale tag, mProvisioningApnAlarmTag:" + this.mProvisioningApnAlarmTag + " != arg1:" + msg.arg1);
                    break;
                }
                this.log("EVENT_PROVISIONING_APN_ALARM: Not connected ignore");
                break;
            }
            case 270374: {
                boolean isProvApn;
                this.log("CMD_IS_PROVISIONING_APN");
                try {
                    String apnType = null;
                    Bundle bundle = msg.getData();
                    if (bundle != null) {
                        apnType = (String)bundle.get("apnType");
                    }
                    if (TextUtils.isEmpty(apnType)) {
                        this.loge("CMD_IS_PROVISIONING_APN: apnType is empty");
                        isProvApn = false;
                    } else {
                        isProvApn = this.isProvisioningApn(apnType);
                    }
                }
                catch (ClassCastException e) {
                    this.loge("CMD_IS_PROVISIONING_APN: NO provisioning url ignoring");
                    isProvApn = false;
                }
                this.log("CMD_IS_PROVISIONING_APN: ret=" + isProvApn);
                this.mReplyAc.replyToMessage(msg, 270374, isProvApn ? 1 : 0);
                break;
            }
            case 270369: {
                this.onUpdateIcc();
                break;
            }
            case 270362: {
                this.restartRadio();
                break;
            }
            case 270376: {
                if (msg.arg1 == 1) {
                    this.handleStartNetStatPoll((DctConstants.Activity)((Object)msg.obj));
                    break;
                }
                if (msg.arg1 != 0) break;
                this.handleStopNetStatPoll((DctConstants.Activity)((Object)msg.obj));
                break;
            }
            case 270340: {
                break;
            }
            case 270381: {
                this.handlePcoData((AsyncResult)msg.obj);
                break;
            }
            case 270382: {
                this.onSetCarrierDataEnabled((AsyncResult)msg.obj);
                break;
            }
            case 270383: {
                this.onDataReconnect(msg.getData());
                break;
            }
            default: {
                Rlog.e("DcTracker", "Unhandled event=" + msg);
            }
        }
    }

    private int getApnProfileID(String apnType) {
        if (TextUtils.equals(apnType, "ims")) {
            return 2;
        }
        if (TextUtils.equals(apnType, "fota")) {
            return 3;
        }
        if (TextUtils.equals(apnType, "cbs")) {
            return 4;
        }
        if (TextUtils.equals(apnType, "ia")) {
            return 0;
        }
        if (TextUtils.equals(apnType, "dun")) {
            return 1;
        }
        return 0;
    }

    private int getCellLocationId() {
        int cid = -1;
        CellLocation loc = this.mPhone.getCellLocation();
        if (loc != null) {
            if (loc instanceof GsmCellLocation) {
                cid = ((GsmCellLocation)loc).getCid();
            } else if (loc instanceof CdmaCellLocation) {
                cid = ((CdmaCellLocation)loc).getBaseStationId();
            }
        }
        return cid;
    }

    private IccRecords getUiccRecords(int appFamily) {
        return this.mUiccController.getIccRecords(this.mPhone.getPhoneId(), appFamily);
    }

    private void onUpdateIcc() {
        if (this.mUiccController == null) {
            return;
        }
        IccRecords newIccRecords = this.getUiccRecords(1);
        IccRecords r = this.mIccRecords.get();
        if (r != newIccRecords) {
            if (r != null) {
                this.log("Removing stale icc objects.");
                r.unregisterForRecordsLoaded(this);
                this.mIccRecords.set(null);
            }
            if (newIccRecords != null) {
                if (SubscriptionManager.isValidSubscriptionId(this.mPhone.getSubId())) {
                    this.log("New records found.");
                    this.mIccRecords.set(newIccRecords);
                    newIccRecords.registerForRecordsLoaded(this, 270338, null);
                }
            } else {
                this.onSimNotReady();
            }
        }
    }

    public void update() {
        this.log("update sub = " + this.mPhone.getSubId());
        this.log("update(): Active DDS, register for all events now!");
        this.onUpdateIcc();
        this.mDataEnabledSettings.setUserDataEnabled(this.getDataEnabled());
        this.mAutoAttachOnCreation.set(false);
        ((GsmCdmaPhone)this.mPhone).updateCurrentCarrierInProvider();
    }

    public void cleanUpAllConnections(String cause) {
        this.cleanUpAllConnections(cause, null);
    }

    public void updateRecords() {
        this.onUpdateIcc();
    }

    public void cleanUpAllConnections(String cause, Message disconnectAllCompleteMsg) {
        this.log("cleanUpAllConnections");
        if (disconnectAllCompleteMsg != null) {
            this.mDisconnectAllCompleteMsgList.add(disconnectAllCompleteMsg);
        }
        Message msg = this.obtainMessage(270365);
        msg.obj = cause;
        this.sendMessage(msg);
    }

    private void notifyDataDisconnectComplete() {
        this.log("notifyDataDisconnectComplete");
        for (Message m : this.mDisconnectAllCompleteMsgList) {
            m.sendToTarget();
        }
        this.mDisconnectAllCompleteMsgList.clear();
    }

    private void notifyAllDataDisconnected() {
        sEnableFailFastRefCounter = 0;
        this.mFailFast = false;
        this.mAllDataDisconnectedRegistrants.notifyRegistrants();
    }

    public void registerForAllDataDisconnected(Handler h, int what, Object obj) {
        this.mAllDataDisconnectedRegistrants.addUnique(h, what, obj);
        if (this.isDisconnected()) {
            this.log("notify All Data Disconnected");
            this.notifyAllDataDisconnected();
        }
    }

    public void unregisterForAllDataDisconnected(Handler h) {
        this.mAllDataDisconnectedRegistrants.remove(h);
    }

    public void registerForDataEnabledChanged(Handler h, int what, Object obj) {
        this.mDataEnabledSettings.registerForDataEnabledChanged(h, what, obj);
    }

    public void unregisterForDataEnabledChanged(Handler h) {
        this.mDataEnabledSettings.unregisterForDataEnabledChanged(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSetInternalDataEnabled(boolean enabled, Message onCompleteMsg) {
        DataEnabledSettings dataEnabledSettings = this.mDataEnabledSettings;
        synchronized (dataEnabledSettings) {
            this.log("onSetInternalDataEnabled: enabled=" + enabled);
            boolean sendOnComplete = true;
            this.mDataEnabledSettings.setInternalDataEnabled(enabled);
            if (enabled) {
                this.log("onSetInternalDataEnabled: changed to enabled, try to setup data call");
                this.onTrySetupData("dataEnabled");
            } else {
                sendOnComplete = false;
                this.log("onSetInternalDataEnabled: changed to disabled, cleanUpAllConnections");
                this.cleanUpAllConnections("dataDisabled", onCompleteMsg);
            }
            if (sendOnComplete && onCompleteMsg != null) {
                onCompleteMsg.sendToTarget();
            }
        }
    }

    public boolean setInternalDataEnabled(boolean enable) {
        return this.setInternalDataEnabled(enable, null);
    }

    public boolean setInternalDataEnabled(boolean enable, Message onCompleteMsg) {
        this.log("setInternalDataEnabled(" + enable + ")");
        Message msg = this.obtainMessage(270363, onCompleteMsg);
        msg.arg1 = enable ? 1 : 0;
        this.sendMessage(msg);
        return true;
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private void loge(String s) {
        Rlog.e(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    /*
     * WARNING - void declaration
     */
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("DcTracker:");
        pw.println(" RADIO_TESTS=false");
        pw.println(" mDataEnabledSettings=" + this.mDataEnabledSettings);
        pw.println(" isDataAllowed=" + this.isDataAllowed(null));
        pw.flush();
        pw.println(" mRequestedApnType=" + this.mRequestedApnType);
        pw.println(" mPhone=" + this.mPhone.getPhoneName());
        pw.println(" mActivity=" + (Object)((Object)this.mActivity));
        pw.println(" mState=" + (Object)((Object)this.mState));
        pw.println(" mTxPkts=" + this.mTxPkts);
        pw.println(" mRxPkts=" + this.mRxPkts);
        pw.println(" mNetStatPollPeriod=" + this.mNetStatPollPeriod);
        pw.println(" mNetStatPollEnabled=" + this.mNetStatPollEnabled);
        pw.println(" mDataStallTxRxSum=" + this.mDataStallTxRxSum);
        pw.println(" mDataStallAlarmTag=" + this.mDataStallAlarmTag);
        pw.println(" mDataStallDetectionEnabled=" + this.mDataStallDetectionEnabled);
        pw.println(" mSentSinceLastRecv=" + this.mSentSinceLastRecv);
        pw.println(" mNoRecvPollCount=" + this.mNoRecvPollCount);
        pw.println(" mResolver=" + this.mResolver);
        pw.println(" mIsWifiConnected=" + this.mIsWifiConnected);
        pw.println(" mReconnectIntent=" + this.mReconnectIntent);
        pw.println(" mAutoAttachOnCreation=" + this.mAutoAttachOnCreation.get());
        pw.println(" mIsScreenOn=" + this.mIsScreenOn);
        pw.println(" mUniqueIdGenerator=" + this.mUniqueIdGenerator);
        pw.println(" mDataRoamingLeakageLog= ");
        this.mDataRoamingLeakageLog.dump(fd, pw, args);
        pw.flush();
        pw.println(" ***************************************");
        DcController dcc = this.mDcc;
        if (dcc != null) {
            dcc.dump(fd, pw, args);
        } else {
            pw.println(" mDcc=null");
        }
        pw.println(" ***************************************");
        HashMap<Integer, DataConnection> dcs = this.mDataConnections;
        if (dcs != null) {
            Set<Map.Entry<Integer, DataConnection>> mDcSet = this.mDataConnections.entrySet();
            pw.println(" mDataConnections: count=" + mDcSet.size());
            for (Map.Entry<Integer, DataConnection> entry : mDcSet) {
                pw.printf(" *** mDataConnection[%d] \n", entry.getKey());
                entry.getValue().dump(fd, pw, args);
            }
        } else {
            pw.println("mDataConnections=null");
        }
        pw.println(" ***************************************");
        pw.flush();
        HashMap<String, Integer> apnToDcId = this.mApnToDataConnectionId;
        if (apnToDcId != null) {
            Set<Map.Entry<String, Integer>> apnToDcIdSet = apnToDcId.entrySet();
            pw.println(" mApnToDataConnectonId size=" + apnToDcIdSet.size());
            for (Map.Entry<String, Integer> entry : apnToDcIdSet) {
                pw.printf(" mApnToDataConnectonId[%s]=%d\n", entry.getKey(), entry.getValue());
            }
        } else {
            pw.println("mApnToDataConnectionId=null");
        }
        pw.println(" ***************************************");
        pw.flush();
        ConcurrentHashMap<String, ApnContext> apnCtxs = this.mApnContexts;
        if (apnCtxs != null) {
            Set<Map.Entry<String, ApnContext>> set = apnCtxs.entrySet();
            pw.println(" mApnContexts size=" + set.size());
            for (Map.Entry<String, ApnContext> entry : set) {
                entry.getValue().dump(fd, pw, args);
            }
            pw.println(" ***************************************");
        } else {
            pw.println(" mApnContexts=null");
        }
        pw.flush();
        ArrayList<ApnSetting> arrayList = this.mAllApnSettings;
        if (arrayList != null) {
            void var9_18;
            pw.println(" mAllApnSettings size=" + arrayList.size());
            boolean bl = false;
            while (var9_18 < arrayList.size()) {
                pw.printf(" mAllApnSettings[%d]: %s\n", (int)var9_18, arrayList.get((int)var9_18));
                ++var9_18;
            }
            pw.flush();
        } else {
            pw.println(" mAllApnSettings=null");
        }
        pw.println(" mPreferredApn=" + this.mPreferredApn);
        pw.println(" mIsPsRestricted=" + this.mIsPsRestricted);
        pw.println(" mIsDisposed=" + this.mIsDisposed);
        pw.println(" mIntentReceiver=" + this.mIntentReceiver);
        pw.println(" mReregisterOnReconnectFailure=" + this.mReregisterOnReconnectFailure);
        pw.println(" canSetPreferApn=" + this.mCanSetPreferApn);
        pw.println(" mApnObserver=" + this.mApnObserver);
        pw.println(" getOverallState=" + (Object)((Object)this.getOverallState()));
        pw.println(" mDataConnectionAsyncChannels=%s\n" + this.mDataConnectionAcHashMap);
        pw.println(" mAttached=" + this.mAttached.get());
        pw.flush();
    }

    public String[] getPcscfAddress(String apnType) {
        this.log("getPcscfAddress()");
        ApnContext apnContext = null;
        if (apnType == null) {
            this.log("apnType is null, return null");
            return null;
        }
        if (TextUtils.equals(apnType, "emergency")) {
            apnContext = this.mApnContextsById.get(9);
        } else if (TextUtils.equals(apnType, "ims")) {
            apnContext = this.mApnContextsById.get(5);
        } else {
            this.log("apnType is invalid, return null");
            return null;
        }
        if (apnContext == null) {
            this.log("apnContext is null, return null");
            return null;
        }
        DcAsyncChannel dcac = apnContext.getDcAc();
        String[] result = null;
        if (dcac != null) {
            result = dcac.getPcscfAddr();
            for (int i = 0; i < result.length; ++i) {
                this.log("Pcscf[" + i + "]: " + result[i]);
            }
            return result;
        }
        return null;
    }

    private void initEmergencyApnSetting() {
        String selection = "type=\"emergency\"";
        Cursor cursor = this.mPhone.getContext().getContentResolver().query(Telephony.Carriers.CONTENT_URI, null, selection, null, null);
        if (cursor != null) {
            if (cursor.getCount() > 0 && cursor.moveToFirst()) {
                this.mEmergencyApn = this.makeApnSetting(cursor);
            }
            cursor.close();
        }
    }

    private void addEmergencyApnSetting() {
        if (this.mEmergencyApn != null) {
            if (this.mAllApnSettings == null) {
                this.mAllApnSettings = new ArrayList();
            } else {
                boolean hasEmergencyApn = false;
                for (ApnSetting apn : this.mAllApnSettings) {
                    if (!ArrayUtils.contains(apn.types, "emergency")) continue;
                    hasEmergencyApn = true;
                    break;
                }
                if (!hasEmergencyApn) {
                    this.mAllApnSettings.add(this.mEmergencyApn);
                } else {
                    this.log("addEmergencyApnSetting - E-APN setting is already present");
                }
            }
        }
    }

    private boolean containsAllApns(ArrayList<ApnSetting> oldApnList, ArrayList<ApnSetting> newApnList) {
        for (ApnSetting newApnSetting : newApnList) {
            boolean canHandle = false;
            for (ApnSetting oldApnSetting : oldApnList) {
                if (!oldApnSetting.equals(newApnSetting, this.mPhone.getServiceState().getDataRoamingFromRegistration())) continue;
                canHandle = true;
                break;
            }
            if (canHandle) continue;
            return false;
        }
        return true;
    }

    private void cleanUpConnectionsOnUpdatedApns(boolean tearDown, String reason) {
        this.log("cleanUpConnectionsOnUpdatedApns: tearDown=" + tearDown);
        if (this.mAllApnSettings != null && this.mAllApnSettings.isEmpty()) {
            this.cleanUpAllConnections(tearDown, "apnChanged");
        } else {
            for (ApnContext apnContext : this.mApnContexts.values()) {
                ArrayList<ApnSetting> currentWaitingApns = apnContext.getWaitingApns();
                ArrayList<ApnSetting> waitingApns = this.buildWaitingApns(apnContext.getApnType(), this.mPhone.getServiceState().getRilDataRadioTechnology());
                if (currentWaitingApns == null || waitingApns.size() == currentWaitingApns.size() && this.containsAllApns(currentWaitingApns, waitingApns)) continue;
                apnContext.setWaitingApns(waitingApns);
                if (apnContext.isDisconnected()) continue;
                apnContext.setReason(reason);
                this.cleanUpConnection(true, apnContext);
            }
        }
        if (!this.isConnected()) {
            this.stopNetStatPoll();
            this.stopDataStallAlarm();
        }
        this.mRequestedApnType = "default";
        this.log("mDisconnectPendingCount = " + this.mDisconnectPendingCount);
        if (tearDown && this.mDisconnectPendingCount == 0) {
            this.notifyDataDisconnectComplete();
            this.notifyAllDataDisconnected();
        }
    }

    private void resetPollStats() {
        this.mTxPkts = -1L;
        this.mRxPkts = -1L;
        this.mNetStatPollPeriod = 1000;
    }

    private void startNetStatPoll() {
        if (this.getOverallState() == DctConstants.State.CONNECTED && !this.mNetStatPollEnabled) {
            this.log("startNetStatPoll");
            this.resetPollStats();
            this.mNetStatPollEnabled = true;
            this.mPollNetStat.run();
        }
        if (this.mPhone != null) {
            this.mPhone.notifyDataActivity();
        }
    }

    private void stopNetStatPoll() {
        this.mNetStatPollEnabled = false;
        this.removeCallbacks(this.mPollNetStat);
        this.log("stopNetStatPoll");
        if (this.mPhone != null) {
            this.mPhone.notifyDataActivity();
        }
    }

    public void sendStartNetStatPoll(DctConstants.Activity activity) {
        Message msg = this.obtainMessage(270376);
        msg.arg1 = 1;
        msg.obj = activity;
        this.sendMessage(msg);
    }

    private void handleStartNetStatPoll(DctConstants.Activity activity) {
        this.startNetStatPoll();
        this.startDataStallAlarm(false);
        this.setActivity(activity);
    }

    public void sendStopNetStatPoll(DctConstants.Activity activity) {
        Message msg = this.obtainMessage(270376);
        msg.arg1 = 0;
        msg.obj = activity;
        this.sendMessage(msg);
    }

    private void handleStopNetStatPoll(DctConstants.Activity activity) {
        this.stopNetStatPoll();
        this.stopDataStallAlarm();
        this.setActivity(activity);
    }

    private void updateDataActivity() {
        TxRxSum preTxRxSum = new TxRxSum(this.mTxPkts, this.mRxPkts);
        TxRxSum curTxRxSum = new TxRxSum();
        curTxRxSum.updateTxRxSum();
        this.mTxPkts = curTxRxSum.txPkts;
        this.mRxPkts = curTxRxSum.rxPkts;
        if (this.mNetStatPollEnabled && (preTxRxSum.txPkts > 0L || preTxRxSum.rxPkts > 0L)) {
            DctConstants.Activity newActivity;
            long sent = this.mTxPkts - preTxRxSum.txPkts;
            long received = this.mRxPkts - preTxRxSum.rxPkts;
            if (sent > 0L && received > 0L) {
                newActivity = DctConstants.Activity.DATAINANDOUT;
            } else if (sent > 0L && received == 0L) {
                newActivity = DctConstants.Activity.DATAOUT;
            } else if (sent == 0L && received > 0L) {
                newActivity = DctConstants.Activity.DATAIN;
            } else {
                DctConstants.Activity activity = newActivity = this.mActivity == DctConstants.Activity.DORMANT ? this.mActivity : DctConstants.Activity.NONE;
            }
            if (this.mActivity != newActivity && this.mIsScreenOn) {
                this.mActivity = newActivity;
                this.mPhone.notifyDataActivity();
            }
        }
    }

    private void handlePcoData(AsyncResult ar) {
        if (ar.exception != null) {
            Rlog.e(LOG_TAG, "PCO_DATA exception: " + ar.exception);
            return;
        }
        PcoData pcoData = (PcoData)ar.result;
        ArrayList<DataConnection> dcList = new ArrayList<DataConnection>();
        DataConnection temp = this.mDcc.getActiveDcByCid(pcoData.cid);
        if (temp != null) {
            dcList.add(temp);
        }
        if (dcList.size() == 0) {
            Rlog.e(LOG_TAG, "PCO_DATA for unknown cid: " + pcoData.cid + ", inferring");
            block0: for (DataConnection dc : this.mDataConnections.values()) {
                int cid = dc.getCid();
                if (cid == pcoData.cid) {
                    dcList.clear();
                    dcList.add(dc);
                    break;
                }
                if (cid != -1) continue;
                for (ApnContext apnContext : dc.mApnContexts.keySet()) {
                    if (apnContext.getState() != DctConstants.State.CONNECTING) continue;
                    dcList.add(dc);
                    continue block0;
                }
            }
        }
        if (dcList.size() == 0) {
            Rlog.e(LOG_TAG, "PCO_DATA - couldn't infer cid");
            return;
        }
        for (DataConnection dc : dcList) {
            if (dc.mApnContexts.size() == 0) break;
            for (ApnContext apnContext : dc.mApnContexts.keySet()) {
                String apnType = apnContext.getApnType();
                Intent intent = new Intent("com.android.internal.telephony.CARRIER_SIGNAL_PCO_VALUE");
                intent.putExtra("apnType", apnType);
                intent.putExtra("apnProto", pcoData.bearerProto);
                intent.putExtra("pcoId", pcoData.pcoId);
                intent.putExtra("pcoValue", pcoData.contents);
                this.mPhone.getCarrierSignalAgent().notifyCarrierSignalReceivers(intent);
            }
        }
    }

    private int getRecoveryAction() {
        int action = Settings.System.getInt(this.mResolver, "radio.data.stall.recovery.action", 0);
        return action;
    }

    private void putRecoveryAction(int action) {
        Settings.System.putInt(this.mResolver, "radio.data.stall.recovery.action", action);
    }

    private void doRecovery() {
        if (this.getOverallState() == DctConstants.State.CONNECTED) {
            int recoveryAction = this.getRecoveryAction();
            TelephonyMetrics.getInstance().writeDataStallEvent(this.mPhone.getPhoneId(), recoveryAction);
            switch (recoveryAction) {
                case 0: {
                    EventLog.writeEvent(50118, this.mSentSinceLastRecv);
                    this.log("doRecovery() get data call list");
                    this.mPhone.mCi.getDataCallList(this.obtainMessage(270340));
                    this.putRecoveryAction(1);
                    break;
                }
                case 1: {
                    EventLog.writeEvent(50119, this.mSentSinceLastRecv);
                    this.log("doRecovery() cleanup all connections");
                    this.cleanUpAllConnections("pdpReset");
                    this.putRecoveryAction(2);
                    break;
                }
                case 2: {
                    EventLog.writeEvent(50120, this.mSentSinceLastRecv);
                    this.log("doRecovery() re-register");
                    this.mPhone.getServiceStateTracker().reRegisterNetwork(null);
                    this.putRecoveryAction(3);
                    break;
                }
                case 3: {
                    EventLog.writeEvent(50121, this.mSentSinceLastRecv);
                    this.log("restarting radio");
                    this.putRecoveryAction(4);
                    this.restartRadio();
                    break;
                }
                case 4: {
                    EventLog.writeEvent(50122, -1);
                    this.log("restarting radio with gsm.radioreset to true");
                    SystemProperties.set(this.RADIO_RESET_PROPERTY, "true");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.restartRadio();
                    this.putRecoveryAction(0);
                    break;
                }
                default: {
                    throw new RuntimeException("doRecovery: Invalid recoveryAction=" + recoveryAction);
                }
            }
            this.mSentSinceLastRecv = 0L;
        }
    }

    private void updateDataStallInfo() {
        TxRxSum preTxRxSum = new TxRxSum(this.mDataStallTxRxSum);
        this.mDataStallTxRxSum.updateTxRxSum();
        long sent = this.mDataStallTxRxSum.txPkts - preTxRxSum.txPkts;
        long received = this.mDataStallTxRxSum.rxPkts - preTxRxSum.rxPkts;
        if (sent > 0L && received > 0L) {
            this.mSentSinceLastRecv = 0L;
            this.putRecoveryAction(0);
        } else if (sent > 0L && received == 0L) {
            this.mSentSinceLastRecv = this.isPhoneStateIdle() ? (this.mSentSinceLastRecv += sent) : 0L;
            this.log("updateDataStallInfo: OUT sent=" + sent + " mSentSinceLastRecv=" + this.mSentSinceLastRecv);
        } else if (sent == 0L && received > 0L) {
            this.mSentSinceLastRecv = 0L;
            this.putRecoveryAction(0);
        }
    }

    private boolean isPhoneStateIdle() {
        for (int i = 0; i < TelephonyManager.getDefault().getPhoneCount(); ++i) {
            Phone phone = PhoneFactory.getPhone(i);
            if (phone == null || phone.getState() == PhoneConstants.State.IDLE) continue;
            this.log("isPhoneStateIdle false: Voice call active on phone " + i);
            return false;
        }
        return true;
    }

    private void onDataStallAlarm(int tag) {
        if (this.mDataStallAlarmTag != tag) {
            this.log("onDataStallAlarm: ignore, tag=" + tag + " expecting " + this.mDataStallAlarmTag);
            return;
        }
        this.updateDataStallInfo();
        int hangWatchdogTrigger = Settings.Global.getInt(this.mResolver, "pdp_watchdog_trigger_packet_count", 10);
        boolean suspectedStall = false;
        if (this.mSentSinceLastRecv >= (long)hangWatchdogTrigger) {
            this.log("onDataStallAlarm: tag=" + tag + " do recovery action=" + this.getRecoveryAction());
            suspectedStall = true;
            this.sendMessage(this.obtainMessage(270354));
        }
        this.startDataStallAlarm(suspectedStall);
    }

    private void startDataStallAlarm(boolean suspectedStall) {
        int nextAction = this.getRecoveryAction();
        if (this.mDataStallDetectionEnabled && this.getOverallState() == DctConstants.State.CONNECTED) {
            int delayInMs = this.mIsScreenOn || suspectedStall || RecoveryAction.isAggressiveRecovery(nextAction) ? Settings.Global.getInt(this.mResolver, "data_stall_alarm_aggressive_delay_in_ms", 60000) : Settings.Global.getInt(this.mResolver, "data_stall_alarm_non_aggressive_delay_in_ms", 360000);
            ++this.mDataStallAlarmTag;
            Intent intent = new Intent(INTENT_DATA_STALL_ALARM);
            intent.putExtra(DATA_STALL_ALARM_TAG_EXTRA, this.mDataStallAlarmTag);
            this.mDataStallAlarmIntent = PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
            this.mAlarmManager.set(3, SystemClock.elapsedRealtime() + (long)delayInMs, this.mDataStallAlarmIntent);
        }
    }

    private void stopDataStallAlarm() {
        ++this.mDataStallAlarmTag;
        if (this.mDataStallAlarmIntent != null) {
            this.mAlarmManager.cancel(this.mDataStallAlarmIntent);
            this.mDataStallAlarmIntent = null;
        }
    }

    private void restartDataStallAlarm() {
        if (!this.isConnected()) {
            return;
        }
        int nextAction = this.getRecoveryAction();
        if (RecoveryAction.isAggressiveRecovery(nextAction)) {
            this.log("restartDataStallAlarm: action is pending. not resetting the alarm.");
            return;
        }
        this.stopDataStallAlarm();
        this.startDataStallAlarm(false);
    }

    private void onActionIntentProvisioningApnAlarm(Intent intent) {
        this.log("onActionIntentProvisioningApnAlarm: action=" + intent.getAction());
        Message msg = this.obtainMessage(270375, intent.getAction());
        msg.arg1 = intent.getIntExtra(PROVISIONING_APN_ALARM_TAG_EXTRA, 0);
        this.sendMessage(msg);
    }

    private void startProvisioningApnAlarm() {
        int delayInMs = Settings.Global.getInt(this.mResolver, "provisioning_apn_alarm_delay_in_ms", 900000);
        if (Build.IS_DEBUGGABLE) {
            String delayInMsStrg = Integer.toString(delayInMs);
            delayInMsStrg = System.getProperty(DEBUG_PROV_APN_ALARM, delayInMsStrg);
            try {
                delayInMs = Integer.parseInt(delayInMsStrg);
            }
            catch (NumberFormatException e) {
                this.loge("startProvisioningApnAlarm: e=" + e);
            }
        }
        ++this.mProvisioningApnAlarmTag;
        this.log("startProvisioningApnAlarm: tag=" + this.mProvisioningApnAlarmTag + " delay=" + delayInMs / 1000 + "s");
        Intent intent = new Intent(INTENT_PROVISIONING_APN_ALARM);
        intent.putExtra(PROVISIONING_APN_ALARM_TAG_EXTRA, this.mProvisioningApnAlarmTag);
        this.mProvisioningApnAlarmIntent = PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
        this.mAlarmManager.set(2, SystemClock.elapsedRealtime() + (long)delayInMs, this.mProvisioningApnAlarmIntent);
    }

    private void stopProvisioningApnAlarm() {
        this.log("stopProvisioningApnAlarm: current tag=" + this.mProvisioningApnAlarmTag + " mProvsioningApnAlarmIntent=" + this.mProvisioningApnAlarmIntent);
        ++this.mProvisioningApnAlarmTag;
        if (this.mProvisioningApnAlarmIntent != null) {
            this.mAlarmManager.cancel(this.mProvisioningApnAlarmIntent);
            this.mProvisioningApnAlarmIntent = null;
        }
    }

    private static class RecoveryAction {
        public static final int GET_DATA_CALL_LIST = 0;
        public static final int CLEANUP = 1;
        public static final int REREGISTER = 2;
        public static final int RADIO_RESTART = 3;
        public static final int RADIO_RESTART_WITH_PROP = 4;

        private RecoveryAction() {
        }

        private static boolean isAggressiveRecovery(int value) {
            return value == 1 || value == 2 || value == 3 || value == 4;
        }
    }

    private static enum RetryFailures {
        ALWAYS,
        ONLY_ON_CHANGE;

    }

    private class ProvisionNotificationBroadcastReceiver
    extends BroadcastReceiver {
        private final String mNetworkOperator;
        private final String mProvisionUrl;

        public ProvisionNotificationBroadcastReceiver(String provisionUrl, String networkOperator) {
            this.mNetworkOperator = networkOperator;
            this.mProvisionUrl = provisionUrl;
        }

        private void setEnableFailFastMobileData(int enabled) {
            DcTracker.this.sendMessage(DcTracker.this.obtainMessage(270372, enabled, 0));
        }

        private void enableMobileProvisioning() {
            Message msg = DcTracker.this.obtainMessage(270373);
            msg.setData(Bundle.forPair("provisioningUrl", this.mProvisionUrl));
            DcTracker.this.sendMessage(msg);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            DcTracker.this.log("onReceive : ProvisionNotificationBroadcastReceiver");
            DcTracker.this.mProvisioningSpinner = new ProgressDialog(context);
            DcTracker.this.mProvisioningSpinner.setTitle(this.mNetworkOperator);
            DcTracker.this.mProvisioningSpinner.setMessage(context.getText(17040156));
            DcTracker.this.mProvisioningSpinner.setIndeterminate(true);
            DcTracker.this.mProvisioningSpinner.setCancelable(true);
            DcTracker.this.mProvisioningSpinner.getWindow().setType(2009);
            DcTracker.this.mProvisioningSpinner.show();
            DcTracker.this.sendMessageDelayed(DcTracker.this.obtainMessage(270378, DcTracker.this.mProvisioningSpinner), 120000L);
            DcTracker.this.setRadio(true);
            this.setEnableFailFastMobileData(1);
            this.enableMobileProvisioning();
        }
    }

    private class ApnChangeObserver
    extends ContentObserver {
        public ApnChangeObserver() {
            super(DcTracker.this.mDataConnectionTracker);
        }

        @Override
        public void onChange(boolean selfChange) {
            DcTracker.this.sendMessage(DcTracker.this.obtainMessage(270355));
        }
    }

    public static class TxRxSum {
        public long txPkts;
        public long rxPkts;

        public TxRxSum() {
            this.reset();
        }

        public TxRxSum(long txPkts, long rxPkts) {
            this.txPkts = txPkts;
            this.rxPkts = rxPkts;
        }

        public TxRxSum(TxRxSum sum) {
            this.txPkts = sum.txPkts;
            this.rxPkts = sum.rxPkts;
        }

        public void reset() {
            this.txPkts = -1L;
            this.rxPkts = -1L;
        }

        public String toString() {
            return "{txSum=" + this.txPkts + " rxSum=" + this.rxPkts + "}";
        }

        public void updateTxRxSum() {
            this.txPkts = TrafficStats.getMobileTcpTxPackets();
            this.rxPkts = TrafficStats.getMobileTcpRxPackets();
        }
    }
}

