/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.content.Context;
import android.net.NetworkCapabilities;
import android.net.NetworkConfig;
import android.net.NetworkRequest;
import android.telephony.Rlog;
import com.android.internal.telephony.dataconnection.ApnContext;
import java.util.HashMap;

public class DcRequest
implements Comparable<DcRequest> {
    private static final String LOG_TAG = "DcRequest";
    public final NetworkRequest networkRequest;
    public final int priority;
    public final int apnId;
    private static final HashMap<Integer, Integer> sApnPriorityMap = new HashMap();

    public DcRequest(NetworkRequest nr, Context context) {
        this.initApnPriorities(context);
        this.networkRequest = nr;
        this.apnId = this.apnIdForNetworkRequest(this.networkRequest);
        this.priority = this.priorityForApnId(this.apnId);
    }

    public String toString() {
        return this.networkRequest.toString() + ", priority=" + this.priority + ", apnId=" + this.apnId;
    }

    public int hashCode() {
        return this.networkRequest.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DcRequest) {
            return this.networkRequest.equals(((DcRequest)o).networkRequest);
        }
        return false;
    }

    @Override
    public int compareTo(DcRequest o) {
        return o.priority - this.priority;
    }

    private int apnIdForNetworkRequest(NetworkRequest nr) {
        NetworkCapabilities nc = nr.networkCapabilities;
        if (nc.getTransportTypes().length > 0 && !nc.hasTransport(0)) {
            return -1;
        }
        int apnId = -1;
        boolean error = false;
        if (nc.hasCapability(12)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 0;
        }
        if (nc.hasCapability(0)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 1;
        }
        if (nc.hasCapability(1)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 2;
        }
        if (nc.hasCapability(2)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 3;
        }
        if (nc.hasCapability(3)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 6;
        }
        if (nc.hasCapability(4)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 5;
        }
        if (nc.hasCapability(5)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 7;
        }
        if (nc.hasCapability(7)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 8;
        }
        if (nc.hasCapability(8)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = -1;
            this.loge("RCS APN type not yet supported");
        }
        if (nc.hasCapability(9)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = -1;
            this.loge("XCAP APN type not yet supported");
        }
        if (nc.hasCapability(10)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 9;
        }
        if (error) {
            this.loge("Multiple apn types specified in request - result is unspecified!");
        }
        if (apnId == -1) {
            this.loge("Unsupported NetworkRequest in Telephony: nr=" + nr);
        }
        return apnId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initApnPriorities(Context context) {
        HashMap<Integer, Integer> hashMap = sApnPriorityMap;
        synchronized (hashMap) {
            if (sApnPriorityMap.isEmpty()) {
                String[] networkConfigStrings;
                for (String networkConfigString : networkConfigStrings = context.getResources().getStringArray(17236047)) {
                    NetworkConfig networkConfig = new NetworkConfig(networkConfigString);
                    int apnId = ApnContext.apnIdForType(networkConfig.type);
                    sApnPriorityMap.put(apnId, networkConfig.priority);
                }
            }
        }
    }

    private int priorityForApnId(int apnId) {
        Integer priority = sApnPriorityMap.get(apnId);
        return priority != null ? priority : 0;
    }

    private void loge(String s) {
        Rlog.e(LOG_TAG, s);
    }
}

