/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.hardware.radio.V1_0.CdmaSmsMessage;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.cdma.sms.CdmaSmsAddress;
import com.android.internal.telephony.cdma.sms.CdmaSmsSubaddress;
import com.android.internal.telephony.cdma.sms.SmsEnvelope;

public class SmsMessageConverter {
    static final String LOG_TAG = "SmsMessageConverter";
    private static final String LOGGABLE_TAG = "CDMA:SMS";
    private static final boolean VDBG = false;

    public static SmsMessage newCdmaSmsMessageFromRil(CdmaSmsMessage cdmaSmsMessage) {
        int index;
        SmsEnvelope env = new SmsEnvelope();
        CdmaSmsAddress addr = new CdmaSmsAddress();
        CdmaSmsSubaddress subaddr = new CdmaSmsSubaddress();
        env.teleService = cdmaSmsMessage.teleserviceId;
        env.messageType = cdmaSmsMessage.isServicePresent ? 1 : (0 == env.teleService ? 2 : 0);
        env.serviceCategory = cdmaSmsMessage.serviceCategory;
        int addressDigitMode = cdmaSmsMessage.address.digitMode;
        addr.digitMode = (byte)(0xFF & addressDigitMode);
        addr.numberMode = (byte)(0xFF & cdmaSmsMessage.address.numberMode);
        addr.ton = cdmaSmsMessage.address.numberType;
        addr.numberPlan = (byte)(0xFF & cdmaSmsMessage.address.numberPlan);
        int count = cdmaSmsMessage.address.digits.size();
        addr.numberOfDigits = count;
        byte[] data = new byte[count];
        for (index = 0; index < count; ++index) {
            data[index] = cdmaSmsMessage.address.digits.get(index);
            if (addressDigitMode != 0) continue;
            data[index] = SmsMessage.convertDtmfToAscii(data[index]);
        }
        addr.origBytes = data;
        subaddr.type = cdmaSmsMessage.subAddress.subaddressType;
        subaddr.odd = (byte)(cdmaSmsMessage.subAddress.odd ? 1 : 0);
        count = (byte)cdmaSmsMessage.subAddress.digits.size();
        if (count < 0) {
            count = 0;
        }
        data = new byte[count];
        for (index = 0; index < count; ++index) {
            data[index] = cdmaSmsMessage.subAddress.digits.get(index);
        }
        subaddr.origBytes = data;
        int countInt = cdmaSmsMessage.bearerData.size();
        if (countInt < 0) {
            countInt = 0;
        }
        data = new byte[countInt];
        for (index = 0; index < countInt; ++index) {
            data[index] = cdmaSmsMessage.bearerData.get(index);
        }
        env.bearerData = data;
        env.origAddress = addr;
        env.origSubaddress = subaddr;
        SmsMessage msg = new SmsMessage(addr, env);
        return msg;
    }

    public static android.telephony.SmsMessage newSmsMessageFromCdmaSmsMessage(CdmaSmsMessage msg) {
        return new android.telephony.SmsMessage(SmsMessageConverter.newCdmaSmsMessageFromRil(msg));
    }
}

