/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.hardware.radio.V1_0.Carrier;
import android.hardware.radio.V1_0.CarrierRestrictions;
import android.hardware.radio.V1_0.CdmaBroadcastSmsConfigInfo;
import android.hardware.radio.V1_0.CdmaSmsAck;
import android.hardware.radio.V1_0.CdmaSmsMessage;
import android.hardware.radio.V1_0.CdmaSmsWriteArgs;
import android.hardware.radio.V1_0.CellInfo;
import android.hardware.radio.V1_0.CellInfoCdma;
import android.hardware.radio.V1_0.CellInfoGsm;
import android.hardware.radio.V1_0.CellInfoLte;
import android.hardware.radio.V1_0.CellInfoWcdma;
import android.hardware.radio.V1_0.DataProfileInfo;
import android.hardware.radio.V1_0.Dial;
import android.hardware.radio.V1_0.GsmBroadcastSmsConfigInfo;
import android.hardware.radio.V1_0.GsmSmsMessage;
import android.hardware.radio.V1_0.HardwareConfigModem;
import android.hardware.radio.V1_0.IRadio;
import android.hardware.radio.V1_0.IccIo;
import android.hardware.radio.V1_0.ImsSmsMessage;
import android.hardware.radio.V1_0.LceDataInfo;
import android.hardware.radio.V1_0.NvWriteItem;
import android.hardware.radio.V1_0.RadioResponseInfo;
import android.hardware.radio.V1_0.SelectUiccSub;
import android.hardware.radio.V1_0.SetupDataCallResult;
import android.hardware.radio.V1_0.SimApdu;
import android.hardware.radio.V1_0.SmsWriteArgs;
import android.hardware.radio.V1_0.UusInfo;
import android.hardware.radio.V1_1.ImsiEncryptionInfo;
import android.hardware.radio.deprecated.V1_0.IOemHook;
import android.net.ConnectivityManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.IHwBinder;
import android.os.Message;
import android.os.Parcel;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.service.carrier.CarrierIdentifier;
import android.telephony.ClientRequestStats;
import android.telephony.ModemActivityInfo;
import android.telephony.NeighboringCellInfo;
import android.telephony.NetworkScanRequest;
import android.telephony.PhoneNumberUtils;
import android.telephony.RadioAccessFamily;
import android.telephony.RadioAccessSpecifier;
import android.telephony.Rlog;
import android.telephony.SignalStrength;
import android.telephony.TelephonyHistogram;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.telephony.BaseCommands;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.ClientWakelockTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.HardwareConfig;
import com.android.internal.telephony.OemHookIndication;
import com.android.internal.telephony.OemHookResponse;
import com.android.internal.telephony.RILRequest;
import com.android.internal.telephony.RadioCapability;
import com.android.internal.telephony.RadioIndication;
import com.android.internal.telephony.RadioResponse;
import com.android.internal.telephony.TelephonyDevController;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaInformationRecords;
import com.android.internal.telephony.cdma.CdmaSmsBroadcastConfigInfo;
import com.android.internal.telephony.dataconnection.DataCallResponse;
import com.android.internal.telephony.dataconnection.DataProfile;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.util.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class RIL
extends BaseCommands
implements CommandsInterface {
    static final String RILJ_LOG_TAG = "RILJ";
    static final String RILJ_ACK_WAKELOCK_NAME = "RILJ_ACK_WL";
    static final boolean RILJ_LOGD = true;
    static final boolean RILJ_LOGV = false;
    static final int RIL_HISTOGRAM_BUCKET_COUNT = 5;
    private static final int DEFAULT_WAKE_LOCK_TIMEOUT_MS = 60000;
    private static final int DEFAULT_ACK_WAKE_LOCK_TIMEOUT_MS = 200;
    private static final int DEFAULT_BLOCKING_MESSAGE_RESPONSE_TIMEOUT_MS = 2000;
    public static final int INVALID_WAKELOCK = -1;
    public static final int FOR_WAKELOCK = 0;
    public static final int FOR_ACK_WAKELOCK = 1;
    private final ClientWakelockTracker mClientWakelockTracker = new ClientWakelockTracker();
    final PowerManager.WakeLock mWakeLock;
    final PowerManager.WakeLock mAckWakeLock;
    final int mWakeLockTimeout;
    final int mAckWakeLockTimeout;
    int mWakeLockCount;
    volatile int mWlSequenceNum = 0;
    volatile int mAckWlSequenceNum = 0;
    SparseArray<RILRequest> mRequestList = new SparseArray();
    static SparseArray<TelephonyHistogram> mRilTimeHistograms = new SparseArray();
    Object[] mLastNITZTimeInfo;
    AtomicBoolean mTestingEmergencyCall = new AtomicBoolean(false);
    final Integer mPhoneId;
    private WorkSource mRILDefaultWorkSource;
    private WorkSource mActiveWakelockWorkSource;
    private TelephonyMetrics mMetrics = TelephonyMetrics.getInstance();
    boolean mIsMobileNetworkSupported;
    RadioResponse mRadioResponse;
    RadioIndication mRadioIndication;
    volatile IRadio mRadioProxy = null;
    OemHookResponse mOemHookResponse;
    OemHookIndication mOemHookIndication;
    volatile IOemHook mOemHookProxy = null;
    final AtomicLong mRadioProxyCookie = new AtomicLong(0L);
    final RadioProxyDeathRecipient mRadioProxyDeathRecipient;
    final RilHandler mRilHandler;
    static final int EVENT_WAKE_LOCK_TIMEOUT = 2;
    static final int EVENT_ACK_WAKE_LOCK_TIMEOUT = 4;
    static final int EVENT_BLOCKING_RESPONSE_TIMEOUT = 5;
    static final int EVENT_RADIO_PROXY_DEAD = 6;
    static final String[] HIDL_SERVICE_NAME = new String[]{"slot1", "slot2", "slot3"};
    static final int IRADIO_GET_SERVICE_DELAY_MILLIS = 4000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TelephonyHistogram> getTelephonyRILTimingHistograms() {
        ArrayList<TelephonyHistogram> list;
        SparseArray<TelephonyHistogram> sparseArray = mRilTimeHistograms;
        synchronized (sparseArray) {
            list = new ArrayList<TelephonyHistogram>(mRilTimeHistograms.size());
            for (int i = 0; i < mRilTimeHistograms.size(); ++i) {
                TelephonyHistogram entry = new TelephonyHistogram(mRilTimeHistograms.valueAt(i));
                list.add(entry);
            }
        }
        return list;
    }

    private static Object getResponseForTimedOutRILRequest(RILRequest rr) {
        if (rr == null) {
            return null;
        }
        ModemActivityInfo timeoutResponse = null;
        switch (rr.mRequest) {
            case 135: {
                timeoutResponse = new ModemActivityInfo(0L, 0, 0, new int[5], 0, 0);
            }
        }
        return timeoutResponse;
    }

    private void resetProxyAndRequestList() {
        this.mRadioProxy = null;
        this.mOemHookProxy = null;
        this.mRadioProxyCookie.incrementAndGet();
        this.setRadioState(CommandsInterface.RadioState.RADIO_UNAVAILABLE);
        RILRequest.resetSerial();
        this.clearRequestList(1, false);
    }

    private IRadio getRadioProxy(Message result) {
        if (!this.mIsMobileNetworkSupported) {
            if (result != null) {
                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(1));
                result.sendToTarget();
            }
            return null;
        }
        if (this.mRadioProxy != null) {
            return this.mRadioProxy;
        }
        try {
            this.mRadioProxy = IRadio.getService(HIDL_SERVICE_NAME[this.mPhoneId == null ? 0 : this.mPhoneId]);
            if (this.mRadioProxy != null) {
                this.mRadioProxy.linkToDeath(this.mRadioProxyDeathRecipient, this.mRadioProxyCookie.incrementAndGet());
                this.mRadioProxy.setResponseFunctions(this.mRadioResponse, this.mRadioIndication);
            } else {
                this.riljLoge("getRadioProxy: mRadioProxy == null");
            }
        }
        catch (RemoteException | RuntimeException e) {
            this.mRadioProxy = null;
            this.riljLoge("RadioProxy getService/setResponseFunctions: " + e);
        }
        if (this.mRadioProxy == null) {
            if (result != null) {
                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(1));
                result.sendToTarget();
            }
            this.mRilHandler.sendMessageDelayed(this.mRilHandler.obtainMessage(6, this.mRadioProxyCookie.incrementAndGet()), 4000L);
        }
        return this.mRadioProxy;
    }

    private IOemHook getOemHookProxy(Message result) {
        if (!this.mIsMobileNetworkSupported) {
            if (result != null) {
                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(1));
                result.sendToTarget();
            }
            return null;
        }
        if (this.mOemHookProxy != null) {
            return this.mOemHookProxy;
        }
        try {
            this.mOemHookProxy = IOemHook.getService(HIDL_SERVICE_NAME[this.mPhoneId == null ? 0 : this.mPhoneId]);
            if (this.mOemHookProxy != null) {
                this.mOemHookProxy.setResponseFunctions(this.mOemHookResponse, this.mOemHookIndication);
            } else {
                this.riljLoge("getOemHookProxy: mOemHookProxy == null");
            }
        }
        catch (RemoteException | RuntimeException e) {
            this.mOemHookProxy = null;
            this.riljLoge("OemHookProxy getService/setResponseFunctions: " + e);
        }
        if (this.mOemHookProxy == null) {
            if (result != null) {
                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(1));
                result.sendToTarget();
            }
            this.mRilHandler.sendMessageDelayed(this.mRilHandler.obtainMessage(6, this.mRadioProxyCookie.incrementAndGet()), 4000L);
        }
        return this.mOemHookProxy;
    }

    public RIL(Context context, int preferredNetworkType, int cdmaSubscription) {
        this(context, preferredNetworkType, cdmaSubscription, null);
    }

    public RIL(Context context, int preferredNetworkType, int cdmaSubscription, Integer instanceId) {
        super(context);
        this.riljLog("RIL: init preferredNetworkType=" + preferredNetworkType + " cdmaSubscription=" + cdmaSubscription + ")");
        this.mContext = context;
        this.mCdmaSubscription = cdmaSubscription;
        this.mPreferredNetworkType = preferredNetworkType;
        this.mPhoneType = 0;
        this.mPhoneId = instanceId;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        this.mIsMobileNetworkSupported = cm.isNetworkSupported(0);
        this.mRadioResponse = new RadioResponse(this);
        this.mRadioIndication = new RadioIndication(this);
        this.mOemHookResponse = new OemHookResponse(this);
        this.mOemHookIndication = new OemHookIndication(this);
        this.mRilHandler = new RilHandler();
        this.mRadioProxyDeathRecipient = new RadioProxyDeathRecipient();
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, RILJ_LOG_TAG);
        this.mWakeLock.setReferenceCounted(false);
        this.mAckWakeLock = pm.newWakeLock(1, RILJ_ACK_WAKELOCK_NAME);
        this.mAckWakeLock.setReferenceCounted(false);
        this.mWakeLockTimeout = SystemProperties.getInt("ro.ril.wake_lock_timeout", 60000);
        this.mAckWakeLockTimeout = SystemProperties.getInt("ro.ril.wake_lock_timeout", 200);
        this.mWakeLockCount = 0;
        this.mRILDefaultWorkSource = new WorkSource(context.getApplicationInfo().uid, context.getPackageName());
        TelephonyDevController tdc = TelephonyDevController.getInstance();
        TelephonyDevController.registerRIL(this);
        this.getRadioProxy(null);
        this.getOemHookProxy(null);
    }

    @Override
    public void setOnNITZTime(Handler h, int what, Object obj) {
        super.setOnNITZTime(h, what, obj);
        if (this.mLastNITZTimeInfo != null) {
            this.mNITZTimeRegistrant.notifyRegistrant(new AsyncResult(null, this.mLastNITZTimeInfo, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(RILRequest rr) {
        this.acquireWakeLock(rr, 0);
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            rr.mStartTimeMs = SystemClock.elapsedRealtime();
            this.mRequestList.append(rr.mSerial, rr);
        }
    }

    private RILRequest obtainRequest(int request, Message result, WorkSource workSource) {
        RILRequest rr = RILRequest.obtain(request, result, workSource);
        this.addRequest(rr);
        return rr;
    }

    private void handleRadioProxyExceptionForRR(RILRequest rr, String caller, Exception e) {
        this.riljLoge(caller + ": " + e);
        this.resetProxyAndRequestList();
        this.mRilHandler.sendMessageDelayed(this.mRilHandler.obtainMessage(6, this.mRadioProxyCookie.incrementAndGet()), 4000L);
    }

    private String convertNullToEmptyString(String string2) {
        return string2 != null ? string2 : "";
    }

    @Override
    public void getIccCardStatus(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(1, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getIccCardStatus(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getIccCardStatus", e);
            }
        }
    }

    @Override
    public void supplyIccPin(String pin, Message result) {
        this.supplyIccPinForApp(pin, null, result);
    }

    @Override
    public void supplyIccPinForApp(String pin, String aid, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(2, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " aid = " + aid);
            try {
                radioProxy.supplyIccPinForApp(rr.mSerial, this.convertNullToEmptyString(pin), this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "supplyIccPinForApp", e);
            }
        }
    }

    @Override
    public void supplyIccPuk(String puk, String newPin, Message result) {
        this.supplyIccPukForApp(puk, newPin, null, result);
    }

    @Override
    public void supplyIccPukForApp(String puk, String newPin, String aid, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(3, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " aid = " + aid);
            try {
                radioProxy.supplyIccPukForApp(rr.mSerial, this.convertNullToEmptyString(puk), this.convertNullToEmptyString(newPin), this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "supplyIccPukForApp", e);
            }
        }
    }

    @Override
    public void supplyIccPin2(String pin, Message result) {
        this.supplyIccPin2ForApp(pin, null, result);
    }

    @Override
    public void supplyIccPin2ForApp(String pin, String aid, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(4, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " aid = " + aid);
            try {
                radioProxy.supplyIccPin2ForApp(rr.mSerial, this.convertNullToEmptyString(pin), this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "supplyIccPin2ForApp", e);
            }
        }
    }

    @Override
    public void supplyIccPuk2(String puk2, String newPin2, Message result) {
        this.supplyIccPuk2ForApp(puk2, newPin2, null, result);
    }

    @Override
    public void supplyIccPuk2ForApp(String puk, String newPin2, String aid, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(5, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " aid = " + aid);
            try {
                radioProxy.supplyIccPuk2ForApp(rr.mSerial, this.convertNullToEmptyString(puk), this.convertNullToEmptyString(newPin2), this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "supplyIccPuk2ForApp", e);
            }
        }
    }

    @Override
    public void changeIccPin(String oldPin, String newPin, Message result) {
        this.changeIccPinForApp(oldPin, newPin, null, result);
    }

    @Override
    public void changeIccPinForApp(String oldPin, String newPin, String aid, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(6, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " oldPin = " + oldPin + " newPin = " + newPin + " aid = " + aid);
            try {
                radioProxy.changeIccPinForApp(rr.mSerial, this.convertNullToEmptyString(oldPin), this.convertNullToEmptyString(newPin), this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "changeIccPinForApp", e);
            }
        }
    }

    @Override
    public void changeIccPin2(String oldPin2, String newPin2, Message result) {
        this.changeIccPin2ForApp(oldPin2, newPin2, null, result);
    }

    @Override
    public void changeIccPin2ForApp(String oldPin2, String newPin2, String aid, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(7, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " oldPin = " + oldPin2 + " newPin = " + newPin2 + " aid = " + aid);
            try {
                radioProxy.changeIccPin2ForApp(rr.mSerial, this.convertNullToEmptyString(oldPin2), this.convertNullToEmptyString(newPin2), this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "changeIccPin2ForApp", e);
            }
        }
    }

    @Override
    public void supplyNetworkDepersonalization(String netpin, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(8, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " netpin = " + netpin);
            try {
                radioProxy.supplyNetworkDepersonalization(rr.mSerial, this.convertNullToEmptyString(netpin));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "supplyNetworkDepersonalization", e);
            }
        }
    }

    @Override
    public void getCurrentCalls(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(9, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getCurrentCalls(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getCurrentCalls", e);
            }
        }
    }

    @Override
    public void dial(String address, int clirMode, Message result) {
        this.dial(address, clirMode, null, result);
    }

    @Override
    public void dial(String address, int clirMode, UUSInfo uusInfo, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(10, result, this.mRILDefaultWorkSource);
            Dial dialInfo = new Dial();
            dialInfo.address = this.convertNullToEmptyString(address);
            dialInfo.clir = clirMode;
            if (uusInfo != null) {
                UusInfo info = new UusInfo();
                info.uusType = uusInfo.getType();
                info.uusDcs = uusInfo.getDcs();
                info.uusData = new String(uusInfo.getUserData());
                dialInfo.uusInfo.add(info);
            }
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.dial(rr.mSerial, dialInfo);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "dial", e);
            }
        }
    }

    @Override
    public void getIMSI(Message result) {
        this.getIMSIForApp(null, result);
    }

    @Override
    public void getIMSIForApp(String aid, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(11, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + ">  " + RIL.requestToString(rr.mRequest) + " aid = " + aid);
            try {
                radioProxy.getImsiForApp(rr.mSerial, this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getIMSIForApp", e);
            }
        }
    }

    @Override
    public void hangupConnection(int gsmIndex, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(12, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " gsmIndex = " + gsmIndex);
            try {
                radioProxy.hangup(rr.mSerial, gsmIndex);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "hangupConnection", e);
            }
        }
    }

    @Override
    public void hangupWaitingOrBackground(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(13, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.hangupWaitingOrBackground(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "hangupWaitingOrBackground", e);
            }
        }
    }

    @Override
    public void hangupForegroundResumeBackground(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(14, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.hangupForegroundResumeBackground(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "hangupForegroundResumeBackground", e);
            }
        }
    }

    @Override
    public void switchWaitingOrHoldingAndActive(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(15, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.switchWaitingOrHoldingAndActive(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "switchWaitingOrHoldingAndActive", e);
            }
        }
    }

    @Override
    public void conference(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(16, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.conference(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "conference", e);
            }
        }
    }

    @Override
    public void rejectCall(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(17, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.rejectCall(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "rejectCall", e);
            }
        }
    }

    @Override
    public void getLastCallFailCause(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(18, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getLastCallFailCause(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getLastCallFailCause", e);
            }
        }
    }

    @Override
    public void getSignalStrength(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(19, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getSignalStrength(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getSignalStrength", e);
            }
        }
    }

    @Override
    public void getVoiceRegistrationState(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(20, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getVoiceRegistrationState(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getVoiceRegistrationState", e);
            }
        }
    }

    @Override
    public void getDataRegistrationState(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(21, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getDataRegistrationState(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getDataRegistrationState", e);
            }
        }
    }

    @Override
    public void getOperator(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(22, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getOperator(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getOperator", e);
            }
        }
    }

    @Override
    public void setRadioPower(boolean on, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(23, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " on = " + on);
            try {
                radioProxy.setRadioPower(rr.mSerial, on);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setRadioPower", e);
            }
        }
    }

    @Override
    public void sendDtmf(char c, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(24, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.sendDtmf(rr.mSerial, c + "");
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendDtmf", e);
            }
        }
    }

    private GsmSmsMessage constructGsmSendSmsRilRequest(String smscPdu, String pdu) {
        GsmSmsMessage msg = new GsmSmsMessage();
        msg.smscPdu = smscPdu == null ? "" : smscPdu;
        msg.pdu = pdu == null ? "" : pdu;
        return msg;
    }

    @Override
    public void sendSMS(String smscPdu, String pdu, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(25, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            GsmSmsMessage msg = this.constructGsmSendSmsRilRequest(smscPdu, pdu);
            try {
                radioProxy.sendSms(rr.mSerial, msg);
                this.mMetrics.writeRilSendSms(this.mPhoneId, rr.mSerial, 1, 1);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendSMS", e);
            }
        }
    }

    @Override
    public void sendSMSExpectMore(String smscPdu, String pdu, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(26, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            GsmSmsMessage msg = this.constructGsmSendSmsRilRequest(smscPdu, pdu);
            try {
                radioProxy.sendSMSExpectMore(rr.mSerial, msg);
                this.mMetrics.writeRilSendSms(this.mPhoneId, rr.mSerial, 1, 1);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendSMSExpectMore", e);
            }
        }
    }

    private static int convertToHalMvnoType(String mvnoType) {
        switch (mvnoType) {
            case "imsi": {
                return 1;
            }
            case "gid": {
                return 2;
            }
            case "spn": {
                return 3;
            }
        }
        return 0;
    }

    private static DataProfileInfo convertToHalDataProfile(DataProfile dp) {
        DataProfileInfo dpi = new DataProfileInfo();
        dpi.profileId = dp.profileId;
        dpi.apn = dp.apn;
        dpi.protocol = dp.protocol;
        dpi.roamingProtocol = dp.roamingProtocol;
        dpi.authType = dp.authType;
        dpi.user = dp.user;
        dpi.password = dp.password;
        dpi.type = dp.type;
        dpi.maxConnsTime = dp.maxConnsTime;
        dpi.maxConns = dp.maxConns;
        dpi.waitTime = dp.waitTime;
        dpi.enabled = dp.enabled;
        dpi.supportedApnTypesBitmap = dp.supportedApnTypesBitmap;
        dpi.bearerBitmap = dp.bearerBitmap;
        dpi.mtu = dp.mtu;
        dpi.mvnoType = RIL.convertToHalMvnoType(dp.mvnoType);
        dpi.mvnoMatchData = dp.mvnoMatchData;
        return dpi;
    }

    private static int convertToHalResetNvType(int resetType) {
        switch (resetType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    static DataCallResponse convertDataCallResult(SetupDataCallResult dcResult) {
        return new DataCallResponse(dcResult.status, dcResult.suggestedRetryTime, dcResult.cid, dcResult.active, dcResult.type, dcResult.ifname, dcResult.addresses, dcResult.dnses, dcResult.gateways, dcResult.pcscf, dcResult.mtu);
    }

    @Override
    public void setupDataCall(int radioTechnology, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(27, result, this.mRILDefaultWorkSource);
            DataProfileInfo dpi = RIL.convertToHalDataProfile(dataProfile);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ",radioTechnology=" + radioTechnology + ",isRoaming=" + isRoaming + ",allowRoaming=" + allowRoaming + "," + dataProfile);
            try {
                radioProxy.setupDataCall(rr.mSerial, radioTechnology, dpi, dataProfile.modemCognitive, allowRoaming, isRoaming);
                this.mMetrics.writeRilSetupDataCall(this.mPhoneId, rr.mSerial, radioTechnology, dpi.profileId, dpi.apn, dpi.authType, dpi.protocol);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setupDataCall", e);
            }
        }
    }

    @Override
    public void iccIO(int command, int fileId, String path, int p1, int p2, int p3, String data, String pin2, Message result) {
        this.iccIOForApp(command, fileId, path, p1, p2, p3, data, pin2, null, result);
    }

    @Override
    public void iccIOForApp(int command, int fileId, String path, int p1, int p2, int p3, String data, String pin2, String aid, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(28, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> iccIO: " + RIL.requestToString(rr.mRequest) + " command = 0x" + Integer.toHexString(command) + " fileId = 0x" + Integer.toHexString(fileId) + " path = " + path + " p1 = " + p1 + " p2 = " + p2 + " p3 = " + " data = " + data + " aid = " + aid);
            IccIo iccIo = new IccIo();
            iccIo.command = command;
            iccIo.fileId = fileId;
            iccIo.path = this.convertNullToEmptyString(path);
            iccIo.p1 = p1;
            iccIo.p2 = p2;
            iccIo.p3 = p3;
            iccIo.data = this.convertNullToEmptyString(data);
            iccIo.pin2 = this.convertNullToEmptyString(pin2);
            iccIo.aid = this.convertNullToEmptyString(aid);
            try {
                radioProxy.iccIOForApp(rr.mSerial, iccIo);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "iccIOForApp", e);
            }
        }
    }

    @Override
    public void sendUSSD(String ussd, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(29, result, this.mRILDefaultWorkSource);
            String logUssd = "*******";
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " ussd = " + logUssd);
            try {
                radioProxy.sendUssd(rr.mSerial, this.convertNullToEmptyString(ussd));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendUSSD", e);
            }
        }
    }

    @Override
    public void cancelPendingUssd(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(30, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.cancelPendingUssd(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "cancelPendingUssd", e);
            }
        }
    }

    @Override
    public void getCLIR(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(31, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getClir(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getCLIR", e);
            }
        }
    }

    @Override
    public void setCLIR(int clirMode, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(32, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " clirMode = " + clirMode);
            try {
                radioProxy.setClir(rr.mSerial, clirMode);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCLIR", e);
            }
        }
    }

    @Override
    public void queryCallForwardStatus(int cfReason, int serviceClass, String number, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(33, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " cfreason = " + cfReason + " serviceClass = " + serviceClass);
            android.hardware.radio.V1_0.CallForwardInfo cfInfo = new android.hardware.radio.V1_0.CallForwardInfo();
            cfInfo.reason = cfReason;
            cfInfo.serviceClass = serviceClass;
            cfInfo.toa = PhoneNumberUtils.toaFromString(number);
            cfInfo.number = this.convertNullToEmptyString(number);
            cfInfo.timeSeconds = 0;
            try {
                radioProxy.getCallForwardStatus(rr.mSerial, cfInfo);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "queryCallForwardStatus", e);
            }
        }
    }

    @Override
    public void setCallForward(int action, int cfReason, int serviceClass, String number, int timeSeconds, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(34, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " action = " + action + " cfReason = " + cfReason + " serviceClass = " + serviceClass + " timeSeconds = " + timeSeconds);
            android.hardware.radio.V1_0.CallForwardInfo cfInfo = new android.hardware.radio.V1_0.CallForwardInfo();
            cfInfo.status = action;
            cfInfo.reason = cfReason;
            cfInfo.serviceClass = serviceClass;
            cfInfo.toa = PhoneNumberUtils.toaFromString(number);
            cfInfo.number = this.convertNullToEmptyString(number);
            cfInfo.timeSeconds = timeSeconds;
            try {
                radioProxy.setCallForward(rr.mSerial, cfInfo);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCallForward", e);
            }
        }
    }

    @Override
    public void queryCallWaiting(int serviceClass, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(35, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " serviceClass = " + serviceClass);
            try {
                radioProxy.getCallWaiting(rr.mSerial, serviceClass);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "queryCallWaiting", e);
            }
        }
    }

    @Override
    public void setCallWaiting(boolean enable, int serviceClass, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(36, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " enable = " + enable + " serviceClass = " + serviceClass);
            try {
                radioProxy.setCallWaiting(rr.mSerial, enable, serviceClass);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCallWaiting", e);
            }
        }
    }

    @Override
    public void acknowledgeLastIncomingGsmSms(boolean success, int cause, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(37, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " success = " + success + " cause = " + cause);
            try {
                radioProxy.acknowledgeLastIncomingGsmSms(rr.mSerial, success, cause);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "acknowledgeLastIncomingGsmSms", e);
            }
        }
    }

    @Override
    public void acceptCall(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(40, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.acceptCall(rr.mSerial);
                this.mMetrics.writeRilAnswer(this.mPhoneId, rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "acceptCall", e);
            }
        }
    }

    @Override
    public void deactivateDataCall(int cid, int reason, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(41, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " cid = " + cid + " reason = " + reason);
            try {
                radioProxy.deactivateDataCall(rr.mSerial, cid, reason != 0);
                this.mMetrics.writeRilDeactivateDataCall(this.mPhoneId, rr.mSerial, cid, reason);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "deactivateDataCall", e);
            }
        }
    }

    @Override
    public void queryFacilityLock(String facility, String password, int serviceClass, Message result) {
        this.queryFacilityLockForApp(facility, password, serviceClass, null, result);
    }

    @Override
    public void queryFacilityLockForApp(String facility, String password, int serviceClass, String appId, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(42, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " facility = " + facility + " serviceClass = " + serviceClass + " appId = " + appId);
            try {
                radioProxy.getFacilityLockForApp(rr.mSerial, this.convertNullToEmptyString(facility), this.convertNullToEmptyString(password), serviceClass, this.convertNullToEmptyString(appId));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getFacilityLockForApp", e);
            }
        }
    }

    @Override
    public void setFacilityLock(String facility, boolean lockState, String password, int serviceClass, Message result) {
        this.setFacilityLockForApp(facility, lockState, password, serviceClass, null, result);
    }

    @Override
    public void setFacilityLockForApp(String facility, boolean lockState, String password, int serviceClass, String appId, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(43, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " facility = " + facility + " lockstate = " + lockState + " serviceClass = " + serviceClass + " appId = " + appId);
            try {
                radioProxy.setFacilityLockForApp(rr.mSerial, this.convertNullToEmptyString(facility), lockState, this.convertNullToEmptyString(password), serviceClass, this.convertNullToEmptyString(appId));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setFacilityLockForApp", e);
            }
        }
    }

    @Override
    public void changeBarringPassword(String facility, String oldPwd, String newPwd, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(44, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + "facility = " + facility);
            try {
                radioProxy.setBarringPassword(rr.mSerial, this.convertNullToEmptyString(facility), this.convertNullToEmptyString(oldPwd), this.convertNullToEmptyString(newPwd));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "changeBarringPassword", e);
            }
        }
    }

    @Override
    public void getNetworkSelectionMode(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(45, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getNetworkSelectionMode(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getNetworkSelectionMode", e);
            }
        }
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(46, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.setNetworkSelectionModeAutomatic(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setNetworkSelectionModeAutomatic", e);
            }
        }
    }

    @Override
    public void setNetworkSelectionModeManual(String operatorNumeric, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(47, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " operatorNumeric = " + operatorNumeric);
            try {
                radioProxy.setNetworkSelectionModeManual(rr.mSerial, this.convertNullToEmptyString(operatorNumeric));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setNetworkSelectionModeManual", e);
            }
        }
    }

    @Override
    public void getAvailableNetworks(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(48, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getAvailableNetworks(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getAvailableNetworks", e);
            }
        }
    }

    @Override
    public void startNetworkScan(NetworkScanRequest nsr, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            android.hardware.radio.V1_1.IRadio radioProxy11 = android.hardware.radio.V1_1.IRadio.castFrom(radioProxy);
            if (radioProxy11 == null) {
                if (result != null) {
                    AsyncResult.forMessage(result, null, CommandException.fromRilErrno(6));
                    result.sendToTarget();
                }
            } else {
                android.hardware.radio.V1_1.NetworkScanRequest request = new android.hardware.radio.V1_1.NetworkScanRequest();
                request.type = nsr.scanType;
                request.interval = 60;
                for (RadioAccessSpecifier ras : nsr.specifiers) {
                    android.hardware.radio.V1_1.RadioAccessSpecifier s = new android.hardware.radio.V1_1.RadioAccessSpecifier();
                    s.radioAccessNetwork = ras.radioAccessNetwork;
                    ArrayList<Integer> bands = null;
                    switch (ras.radioAccessNetwork) {
                        case 1: {
                            bands = s.geranBands;
                            break;
                        }
                        case 2: {
                            bands = s.utranBands;
                            break;
                        }
                        case 3: {
                            bands = s.eutranBands;
                            break;
                        }
                        default: {
                            Log.wtf(RILJ_LOG_TAG, "radioAccessNetwork " + ras.radioAccessNetwork + " not supported!");
                            return;
                        }
                    }
                    if (ras.bands != null) {
                        for (int band : ras.bands) {
                            bands.add(band);
                        }
                    }
                    if (ras.channels != null) {
                        for (int channel : ras.channels) {
                            s.channels.add(channel);
                        }
                    }
                    request.specifiers.add(s);
                }
                RILRequest rr = this.obtainRequest(142, result, this.mRILDefaultWorkSource);
                this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
                try {
                    radioProxy11.startNetworkScan(rr.mSerial, request);
                }
                catch (RemoteException | RuntimeException e) {
                    this.handleRadioProxyExceptionForRR(rr, "startNetworkScan", e);
                }
            }
        }
    }

    @Override
    public void stopNetworkScan(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            android.hardware.radio.V1_1.IRadio radioProxy11 = android.hardware.radio.V1_1.IRadio.castFrom(radioProxy);
            if (radioProxy11 == null) {
                if (result != null) {
                    AsyncResult.forMessage(result, null, CommandException.fromRilErrno(6));
                    result.sendToTarget();
                }
            } else {
                RILRequest rr = this.obtainRequest(143, result, this.mRILDefaultWorkSource);
                this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
                try {
                    radioProxy11.stopNetworkScan(rr.mSerial);
                }
                catch (RemoteException | RuntimeException e) {
                    this.handleRadioProxyExceptionForRR(rr, "stopNetworkScan", e);
                }
            }
        }
    }

    @Override
    public void startDtmf(char c, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(49, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.startDtmf(rr.mSerial, c + "");
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "startDtmf", e);
            }
        }
    }

    @Override
    public void stopDtmf(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(50, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.stopDtmf(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "stopDtmf", e);
            }
        }
    }

    @Override
    public void separateConnection(int gsmIndex, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(52, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " gsmIndex = " + gsmIndex);
            try {
                radioProxy.separateConnection(rr.mSerial, gsmIndex);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "separateConnection", e);
            }
        }
    }

    @Override
    public void getBasebandVersion(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(51, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getBasebandVersion(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getBasebandVersion", e);
            }
        }
    }

    @Override
    public void setMute(boolean enableMute, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(53, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " enableMute = " + enableMute);
            try {
                radioProxy.setMute(rr.mSerial, enableMute);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setMute", e);
            }
        }
    }

    @Override
    public void getMute(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(54, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getMute(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getMute", e);
            }
        }
    }

    @Override
    public void queryCLIP(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(55, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getClip(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "queryCLIP", e);
            }
        }
    }

    @Override
    @Deprecated
    public void getPDPContextList(Message result) {
        this.getDataCallList(result);
    }

    @Override
    public void getDataCallList(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(57, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getDataCallList(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getDataCallList", e);
            }
        }
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] data, Message response) {
        IOemHook oemHookProxy = this.getOemHookProxy(response);
        if (oemHookProxy != null) {
            RILRequest rr = this.obtainRequest(59, response, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + "[" + IccUtils.bytesToHexString(data) + "]");
            try {
                oemHookProxy.sendRequestRaw(rr.mSerial, RIL.primitiveArrayToArrayList(data));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "invokeOemRilRequestStrings", e);
            }
        }
    }

    @Override
    public void invokeOemRilRequestStrings(String[] strings, Message result) {
        IOemHook oemHookProxy = this.getOemHookProxy(result);
        if (oemHookProxy != null) {
            RILRequest rr = this.obtainRequest(60, result, this.mRILDefaultWorkSource);
            String logStr = "";
            for (int i = 0; i < strings.length; ++i) {
                logStr = logStr + strings[i] + " ";
            }
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " strings = " + logStr);
            try {
                oemHookProxy.sendRequestStrings(rr.mSerial, new ArrayList<String>(Arrays.asList(strings)));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "invokeOemRilRequestStrings", e);
            }
        }
    }

    @Override
    public void setSuppServiceNotifications(boolean enable, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(62, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " enable = " + enable);
            try {
                radioProxy.setSuppServiceNotifications(rr.mSerial, enable);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setSuppServiceNotifications", e);
            }
        }
    }

    @Override
    public void writeSmsToSim(int status, String smsc, String pdu, Message result) {
        status = this.translateStatus(status);
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(63, result, this.mRILDefaultWorkSource);
            SmsWriteArgs args = new SmsWriteArgs();
            args.status = status;
            args.smsc = this.convertNullToEmptyString(smsc);
            args.pdu = this.convertNullToEmptyString(pdu);
            try {
                radioProxy.writeSmsToSim(rr.mSerial, args);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "writeSmsToSim", e);
            }
        }
    }

    @Override
    public void deleteSmsOnSim(int index, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(64, result, this.mRILDefaultWorkSource);
            try {
                radioProxy.deleteSmsOnSim(rr.mSerial, index);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "deleteSmsOnSim", e);
            }
        }
    }

    @Override
    public void setBandMode(int bandMode, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(65, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " bandMode = " + bandMode);
            try {
                radioProxy.setBandMode(rr.mSerial, bandMode);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setBandMode", e);
            }
        }
    }

    @Override
    public void queryAvailableBandMode(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(66, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getAvailableBandModes(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "queryAvailableBandMode", e);
            }
        }
    }

    @Override
    public void sendEnvelope(String contents, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(69, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " contents = " + contents);
            try {
                radioProxy.sendEnvelope(rr.mSerial, this.convertNullToEmptyString(contents));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendEnvelope", e);
            }
        }
    }

    @Override
    public void sendTerminalResponse(String contents, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(70, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " contents = " + contents);
            try {
                radioProxy.sendTerminalResponseToSim(rr.mSerial, this.convertNullToEmptyString(contents));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendTerminalResponse", e);
            }
        }
    }

    @Override
    public void sendEnvelopeWithStatus(String contents, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(107, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " contents = " + contents);
            try {
                radioProxy.sendEnvelopeWithStatus(rr.mSerial, this.convertNullToEmptyString(contents));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendEnvelopeWithStatus", e);
            }
        }
    }

    @Override
    public void explicitCallTransfer(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(72, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.explicitCallTransfer(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "explicitCallTransfer", e);
            }
        }
    }

    @Override
    public void setPreferredNetworkType(int networkType, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(73, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " networkType = " + networkType);
            this.mPreferredNetworkType = networkType;
            this.mMetrics.writeSetPreferredNetworkType(this.mPhoneId, networkType);
            try {
                radioProxy.setPreferredNetworkType(rr.mSerial, networkType);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setPreferredNetworkType", e);
            }
        }
    }

    @Override
    public void getPreferredNetworkType(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(74, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getPreferredNetworkType(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getPreferredNetworkType", e);
            }
        }
    }

    @Override
    public void getNeighboringCids(Message result, WorkSource workSource) {
        workSource = this.getDeafultWorkSourceIfInvalid(workSource);
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(75, result, workSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getNeighboringCids(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getNeighboringCids", e);
            }
        }
    }

    @Override
    public void setLocationUpdates(boolean enable, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(76, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " enable = " + enable);
            try {
                radioProxy.setLocationUpdates(rr.mSerial, enable);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setLocationUpdates", e);
            }
        }
    }

    @Override
    public void setCdmaSubscriptionSource(int cdmaSubscription, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(77, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " cdmaSubscription = " + cdmaSubscription);
            try {
                radioProxy.setCdmaSubscriptionSource(rr.mSerial, cdmaSubscription);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCdmaSubscriptionSource", e);
            }
        }
    }

    @Override
    public void queryCdmaRoamingPreference(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(79, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getCdmaRoamingPreference(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "queryCdmaRoamingPreference", e);
            }
        }
    }

    @Override
    public void setCdmaRoamingPreference(int cdmaRoamingType, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(78, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " cdmaRoamingType = " + cdmaRoamingType);
            try {
                radioProxy.setCdmaRoamingPreference(rr.mSerial, cdmaRoamingType);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCdmaRoamingPreference", e);
            }
        }
    }

    @Override
    public void queryTTYMode(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(81, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getTTYMode(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "queryTTYMode", e);
            }
        }
    }

    @Override
    public void setTTYMode(int ttyMode, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(80, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " ttyMode = " + ttyMode);
            try {
                radioProxy.setTTYMode(rr.mSerial, ttyMode);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setTTYMode", e);
            }
        }
    }

    @Override
    public void setPreferredVoicePrivacy(boolean enable, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(82, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " enable = " + enable);
            try {
                radioProxy.setPreferredVoicePrivacy(rr.mSerial, enable);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setPreferredVoicePrivacy", e);
            }
        }
    }

    @Override
    public void getPreferredVoicePrivacy(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(83, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getPreferredVoicePrivacy(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getPreferredVoicePrivacy", e);
            }
        }
    }

    @Override
    public void sendCDMAFeatureCode(String featureCode, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(84, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " featureCode = " + featureCode);
            try {
                radioProxy.sendCDMAFeatureCode(rr.mSerial, this.convertNullToEmptyString(featureCode));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendCDMAFeatureCode", e);
            }
        }
    }

    @Override
    public void sendBurstDtmf(String dtmfString, int on, int off, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(85, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " dtmfString = " + dtmfString + " on = " + on + " off = " + off);
            try {
                radioProxy.sendBurstDtmf(rr.mSerial, this.convertNullToEmptyString(dtmfString), on, off);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendBurstDtmf", e);
            }
        }
    }

    private void constructCdmaSendSmsRilRequest(CdmaSmsMessage msg, byte[] pdu) {
        ByteArrayInputStream bais = new ByteArrayInputStream(pdu);
        DataInputStream dis = new DataInputStream(bais);
        try {
            int i;
            msg.teleserviceId = dis.readInt();
            msg.isServicePresent = (byte)dis.readInt() == 1;
            msg.serviceCategory = dis.readInt();
            msg.address.digitMode = dis.read();
            msg.address.numberMode = dis.read();
            msg.address.numberType = dis.read();
            msg.address.numberPlan = dis.read();
            int addrNbrOfDigits = dis.read();
            for (i = 0; i < addrNbrOfDigits; ++i) {
                msg.address.digits.add(dis.readByte());
            }
            msg.subAddress.subaddressType = dis.read();
            msg.subAddress.odd = (byte)dis.read() == 1;
            int subaddrNbrOfDigits = dis.read();
            for (i = 0; i < subaddrNbrOfDigits; ++i) {
                msg.subAddress.digits.add(dis.readByte());
            }
            int bearerDataLength = dis.read();
            for (i = 0; i < bearerDataLength; ++i) {
                msg.bearerData.add(dis.readByte());
            }
        }
        catch (IOException ex) {
            this.riljLog("sendSmsCdma: conversion from input stream to object failed: " + ex);
        }
    }

    @Override
    public void sendCdmaSms(byte[] pdu, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(87, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            CdmaSmsMessage msg = new CdmaSmsMessage();
            this.constructCdmaSendSmsRilRequest(msg, pdu);
            try {
                radioProxy.sendCdmaSms(rr.mSerial, msg);
                this.mMetrics.writeRilSendSms(this.mPhoneId, rr.mSerial, 2, 2);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendCdmaSms", e);
            }
        }
    }

    @Override
    public void acknowledgeLastIncomingCdmaSms(boolean success, int cause, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(88, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " success = " + success + " cause = " + cause);
            CdmaSmsAck msg = new CdmaSmsAck();
            msg.errorClass = success ? 0 : 1;
            msg.smsCauseCode = cause;
            try {
                radioProxy.acknowledgeLastIncomingCdmaSms(rr.mSerial, msg);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "acknowledgeLastIncomingCdmaSms", e);
            }
        }
    }

    @Override
    public void getGsmBroadcastConfig(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(89, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getGsmBroadcastConfig(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getGsmBroadcastConfig", e);
            }
        }
    }

    @Override
    public void setGsmBroadcastConfig(SmsBroadcastConfigInfo[] config, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(90, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " with " + config.length + " configs : ");
            for (int i = 0; i < config.length; ++i) {
                this.riljLog(config[i].toString());
            }
            ArrayList<GsmBroadcastSmsConfigInfo> configs = new ArrayList<GsmBroadcastSmsConfigInfo>();
            int numOfConfig = config.length;
            for (int i = 0; i < numOfConfig; ++i) {
                GsmBroadcastSmsConfigInfo info = new GsmBroadcastSmsConfigInfo();
                info.fromServiceId = config[i].getFromServiceId();
                info.toServiceId = config[i].getToServiceId();
                info.fromCodeScheme = config[i].getFromCodeScheme();
                info.toCodeScheme = config[i].getToCodeScheme();
                info.selected = config[i].isSelected();
                configs.add(info);
            }
            try {
                radioProxy.setGsmBroadcastConfig(rr.mSerial, configs);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setGsmBroadcastConfig", e);
            }
        }
    }

    @Override
    public void setGsmBroadcastActivation(boolean activate, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(91, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " activate = " + activate);
            try {
                radioProxy.setGsmBroadcastActivation(rr.mSerial, activate);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setGsmBroadcastActivation", e);
            }
        }
    }

    @Override
    public void getCdmaBroadcastConfig(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(92, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getCdmaBroadcastConfig(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getCdmaBroadcastConfig", e);
            }
        }
    }

    @Override
    public void setCdmaBroadcastConfig(CdmaSmsBroadcastConfigInfo[] configs, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(93, result, this.mRILDefaultWorkSource);
            ArrayList<CdmaBroadcastSmsConfigInfo> halConfigs = new ArrayList<CdmaBroadcastSmsConfigInfo>();
            for (CdmaSmsBroadcastConfigInfo config : configs) {
                int i = config.getFromServiceCategory();
                while (i <= config.getToServiceCategory()) {
                    CdmaBroadcastSmsConfigInfo info = new CdmaBroadcastSmsConfigInfo();
                    info.serviceCategory = i++;
                    info.language = config.getLanguage();
                    info.selected = config.isSelected();
                    halConfigs.add(info);
                }
            }
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " with " + halConfigs.size() + " configs : ");
            for (CdmaBroadcastSmsConfigInfo config : halConfigs) {
                this.riljLog(config.toString());
            }
            try {
                radioProxy.setCdmaBroadcastConfig(rr.mSerial, halConfigs);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCdmaBroadcastConfig", e);
            }
        }
    }

    @Override
    public void setCdmaBroadcastActivation(boolean activate, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(94, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " activate = " + activate);
            try {
                radioProxy.setCdmaBroadcastActivation(rr.mSerial, activate);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCdmaBroadcastActivation", e);
            }
        }
    }

    @Override
    public void getCDMASubscription(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(95, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getCDMASubscription(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getCDMASubscription", e);
            }
        }
    }

    @Override
    public void writeSmsToRuim(int status, String pdu, Message result) {
        status = this.translateStatus(status);
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(96, result, this.mRILDefaultWorkSource);
            CdmaSmsWriteArgs args = new CdmaSmsWriteArgs();
            args.status = status;
            this.constructCdmaSendSmsRilRequest(args.message, pdu.getBytes());
            try {
                radioProxy.writeSmsToRuim(rr.mSerial, args);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "writeSmsToRuim", e);
            }
        }
    }

    @Override
    public void deleteSmsOnRuim(int index, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(97, result, this.mRILDefaultWorkSource);
            try {
                radioProxy.deleteSmsOnRuim(rr.mSerial, index);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "deleteSmsOnRuim", e);
            }
        }
    }

    @Override
    public void getDeviceIdentity(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(98, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getDeviceIdentity(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getDeviceIdentity", e);
            }
        }
    }

    @Override
    public void exitEmergencyCallbackMode(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(99, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.exitEmergencyCallbackMode(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "exitEmergencyCallbackMode", e);
            }
        }
    }

    @Override
    public void getSmscAddress(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(100, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getSmscAddress(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getSmscAddress", e);
            }
        }
    }

    @Override
    public void setSmscAddress(String address, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(101, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " address = " + address);
            try {
                radioProxy.setSmscAddress(rr.mSerial, this.convertNullToEmptyString(address));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setSmscAddress", e);
            }
        }
    }

    @Override
    public void reportSmsMemoryStatus(boolean available, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(102, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " available = " + available);
            try {
                radioProxy.reportSmsMemoryStatus(rr.mSerial, available);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "reportSmsMemoryStatus", e);
            }
        }
    }

    @Override
    public void reportStkServiceIsRunning(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(103, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.reportStkServiceIsRunning(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "reportStkServiceIsRunning", e);
            }
        }
    }

    @Override
    public void getCdmaSubscriptionSource(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(104, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getCdmaSubscriptionSource(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getCdmaSubscriptionSource", e);
            }
        }
    }

    @Override
    public void requestIsimAuthentication(String nonce, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(105, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " nonce = " + nonce);
            try {
                radioProxy.requestIsimAuthentication(rr.mSerial, this.convertNullToEmptyString(nonce));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "requestIsimAuthentication", e);
            }
        }
    }

    @Override
    public void acknowledgeIncomingGsmSmsWithPdu(boolean success, String ackPdu, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(106, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " success = " + success);
            try {
                radioProxy.acknowledgeIncomingGsmSmsWithPdu(rr.mSerial, success, this.convertNullToEmptyString(ackPdu));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "acknowledgeIncomingGsmSmsWithPdu", e);
            }
        }
    }

    @Override
    public void getVoiceRadioTechnology(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(108, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getVoiceRadioTechnology(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getVoiceRadioTechnology", e);
            }
        }
    }

    @Override
    public void getCellInfoList(Message result, WorkSource workSource) {
        workSource = this.getDeafultWorkSourceIfInvalid(workSource);
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(109, result, workSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getCellInfoList(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getCellInfoList", e);
            }
        }
    }

    @Override
    public void setCellInfoListRate(int rateInMillis, Message result, WorkSource workSource) {
        workSource = this.getDeafultWorkSourceIfInvalid(workSource);
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(110, result, workSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " rateInMillis = " + rateInMillis);
            try {
                radioProxy.setCellInfoListRate(rr.mSerial, rateInMillis);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCellInfoListRate", e);
            }
        }
    }

    void setCellInfoListRate() {
        this.setCellInfoListRate(Integer.MAX_VALUE, null, this.mRILDefaultWorkSource);
    }

    @Override
    public void setInitialAttachApn(DataProfile dataProfile, boolean isRoaming, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(111, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + dataProfile);
            try {
                radioProxy.setInitialAttachApn(rr.mSerial, RIL.convertToHalDataProfile(dataProfile), dataProfile.modemCognitive, isRoaming);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setInitialAttachApn", e);
            }
        }
    }

    @Override
    public void getImsRegistrationState(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(112, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getImsRegistrationState(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getImsRegistrationState", e);
            }
        }
    }

    @Override
    public void sendImsGsmSms(String smscPdu, String pdu, int retry, int messageRef, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(113, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            ImsSmsMessage msg = new ImsSmsMessage();
            msg.tech = 1;
            msg.retry = (byte)retry == 1;
            msg.messageRef = messageRef;
            GsmSmsMessage gsmMsg = this.constructGsmSendSmsRilRequest(smscPdu, pdu);
            msg.gsmMessage.add(gsmMsg);
            try {
                radioProxy.sendImsSms(rr.mSerial, msg);
                this.mMetrics.writeRilSendSms(this.mPhoneId, rr.mSerial, 3, 1);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendImsGsmSms", e);
            }
        }
    }

    @Override
    public void sendImsCdmaSms(byte[] pdu, int retry, int messageRef, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(113, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            ImsSmsMessage msg = new ImsSmsMessage();
            msg.tech = 2;
            msg.retry = (byte)retry == 1;
            msg.messageRef = messageRef;
            CdmaSmsMessage cdmaMsg = new CdmaSmsMessage();
            this.constructCdmaSendSmsRilRequest(cdmaMsg, pdu);
            msg.cdmaMessage.add(cdmaMsg);
            try {
                radioProxy.sendImsSms(rr.mSerial, msg);
                this.mMetrics.writeRilSendSms(this.mPhoneId, rr.mSerial, 3, 1);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendImsCdmaSms", e);
            }
        }
    }

    private SimApdu createSimApdu(int channel, int cla, int instruction, int p1, int p2, int p3, String data) {
        SimApdu msg = new SimApdu();
        msg.sessionId = channel;
        msg.cla = cla;
        msg.instruction = instruction;
        msg.p1 = p1;
        msg.p2 = p2;
        msg.p3 = p3;
        msg.data = this.convertNullToEmptyString(data);
        return msg;
    }

    @Override
    public void iccTransmitApduBasicChannel(int cla, int instruction, int p1, int p2, int p3, String data, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(114, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " cla = " + cla + " instruction = " + instruction + " p1 = " + p1 + " p2 = " + " p3 = " + p3 + " data = " + data);
            SimApdu msg = this.createSimApdu(0, cla, instruction, p1, p2, p3, data);
            try {
                radioProxy.iccTransmitApduBasicChannel(rr.mSerial, msg);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "iccTransmitApduBasicChannel", e);
            }
        }
    }

    @Override
    public void iccOpenLogicalChannel(String aid, int p2, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(115, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " aid = " + aid + " p2 = " + p2);
            try {
                radioProxy.iccOpenLogicalChannel(rr.mSerial, this.convertNullToEmptyString(aid), p2);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "iccOpenLogicalChannel", e);
            }
        }
    }

    @Override
    public void iccCloseLogicalChannel(int channel, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(116, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " channel = " + channel);
            try {
                radioProxy.iccCloseLogicalChannel(rr.mSerial, channel);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "iccCloseLogicalChannel", e);
            }
        }
    }

    @Override
    public void iccTransmitApduLogicalChannel(int channel, int cla, int instruction, int p1, int p2, int p3, String data, Message result) {
        if (channel <= 0) {
            throw new RuntimeException("Invalid channel in iccTransmitApduLogicalChannel: " + channel);
        }
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(117, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " channel = " + channel + " cla = " + cla + " instruction = " + instruction + " p1 = " + p1 + " p2 = " + " p3 = " + p3 + " data = " + data);
            SimApdu msg = this.createSimApdu(channel, cla, instruction, p1, p2, p3, data);
            try {
                radioProxy.iccTransmitApduLogicalChannel(rr.mSerial, msg);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "iccTransmitApduLogicalChannel", e);
            }
        }
    }

    @Override
    public void nvReadItem(int itemID, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(118, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " itemId = " + itemID);
            try {
                radioProxy.nvReadItem(rr.mSerial, itemID);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "nvReadItem", e);
            }
        }
    }

    @Override
    public void nvWriteItem(int itemId, String itemValue, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(119, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " itemId = " + itemId + " itemValue = " + itemValue);
            NvWriteItem item = new NvWriteItem();
            item.itemId = itemId;
            item.value = this.convertNullToEmptyString(itemValue);
            try {
                radioProxy.nvWriteItem(rr.mSerial, item);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "nvWriteItem", e);
            }
        }
    }

    @Override
    public void nvWriteCdmaPrl(byte[] preferredRoamingList, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(120, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " PreferredRoamingList = 0x" + IccUtils.bytesToHexString(preferredRoamingList));
            ArrayList<Byte> arrList = new ArrayList<Byte>();
            for (int i = 0; i < preferredRoamingList.length; ++i) {
                arrList.add(preferredRoamingList[i]);
            }
            try {
                radioProxy.nvWriteCdmaPrl(rr.mSerial, arrList);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "nvWriteCdmaPrl", e);
            }
        }
    }

    @Override
    public void nvResetConfig(int resetType, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(121, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " resetType = " + resetType);
            try {
                radioProxy.nvResetConfig(rr.mSerial, RIL.convertToHalResetNvType(resetType));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "nvResetConfig", e);
            }
        }
    }

    @Override
    public void setUiccSubscription(int slotId, int appIndex, int subId, int subStatus, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(122, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " slot = " + slotId + " appIndex = " + appIndex + " subId = " + subId + " subStatus = " + subStatus);
            SelectUiccSub info = new SelectUiccSub();
            info.slot = slotId;
            info.appIndex = appIndex;
            info.subType = subId;
            info.actStatus = subStatus;
            try {
                radioProxy.setUiccSubscription(rr.mSerial, info);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setUiccSubscription", e);
            }
        }
    }

    @Override
    public void setDataAllowed(boolean allowed, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(123, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " allowed = " + allowed);
            try {
                radioProxy.setDataAllowed(rr.mSerial, allowed);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setDataAllowed", e);
            }
        }
    }

    @Override
    public void getHardwareConfig(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(124, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getHardwareConfig(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getHardwareConfig", e);
            }
        }
    }

    @Override
    public void requestIccSimAuthentication(int authContext, String data, String aid, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(125, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.requestIccSimAuthentication(rr.mSerial, authContext, this.convertNullToEmptyString(data), this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "requestIccSimAuthentication", e);
            }
        }
    }

    @Override
    public void setDataProfile(DataProfile[] dps, boolean isRoaming, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(128, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " with data profiles : ");
            for (DataProfile profile : dps) {
                this.riljLog(profile.toString());
            }
            ArrayList<DataProfileInfo> dpis = new ArrayList<DataProfileInfo>();
            for (DataProfile dp : dps) {
                dpis.add(RIL.convertToHalDataProfile(dp));
            }
            try {
                radioProxy.setDataProfile(rr.mSerial, dpis, isRoaming);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setDataProfile", e);
            }
        }
    }

    @Override
    public void requestShutdown(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(129, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.requestShutdown(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "requestShutdown", e);
            }
        }
    }

    @Override
    public void getRadioCapability(Message response) {
        IRadio radioProxy = this.getRadioProxy(response);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(130, response, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getRadioCapability(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getRadioCapability", e);
            }
        }
    }

    @Override
    public void setRadioCapability(RadioCapability rc, Message response) {
        IRadio radioProxy = this.getRadioProxy(response);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(131, response, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " RadioCapability = " + rc.toString());
            android.hardware.radio.V1_0.RadioCapability halRc = new android.hardware.radio.V1_0.RadioCapability();
            halRc.session = rc.getSession();
            halRc.phase = rc.getPhase();
            halRc.raf = rc.getRadioAccessFamily();
            halRc.logicalModemUuid = this.convertNullToEmptyString(rc.getLogicalModemUuid());
            halRc.status = rc.getStatus();
            try {
                radioProxy.setRadioCapability(rr.mSerial, halRc);
            }
            catch (Exception e) {
                this.handleRadioProxyExceptionForRR(rr, "setRadioCapability", e);
            }
        }
    }

    @Override
    public void startLceService(int reportIntervalMs, boolean pullMode, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(132, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " reportIntervalMs = " + reportIntervalMs + " pullMode = " + pullMode);
            try {
                radioProxy.startLceService(rr.mSerial, reportIntervalMs, pullMode);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "startLceService", e);
            }
        }
    }

    @Override
    public void stopLceService(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(133, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.stopLceService(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "stopLceService", e);
            }
        }
    }

    @Override
    public void pullLceData(Message response) {
        IRadio radioProxy = this.getRadioProxy(response);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(134, response, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.pullLceData(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "pullLceData", e);
            }
        }
    }

    @Override
    public void getModemActivityInfo(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(135, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getModemActivityInfo(rr.mSerial);
                Message msg = this.mRilHandler.obtainMessage(5);
                msg.obj = null;
                msg.arg1 = rr.mSerial;
                this.mRilHandler.sendMessageDelayed(msg, 2000L);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getModemActivityInfo", e);
            }
        }
    }

    @Override
    public void setAllowedCarriers(List<CarrierIdentifier> carriers, Message result) {
        Preconditions.checkNotNull(carriers, "Allowed carriers list cannot be null.");
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(136, result, this.mRILDefaultWorkSource);
            String logStr = "";
            for (int i = 0; i < carriers.size(); ++i) {
                logStr = logStr + carriers.get(i) + " ";
            }
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " carriers = " + logStr);
            boolean allAllowed = carriers.size() == 0;
            CarrierRestrictions carrierList = new CarrierRestrictions();
            for (CarrierIdentifier ci : carriers) {
                Carrier c = new Carrier();
                c.mcc = this.convertNullToEmptyString(ci.getMcc());
                c.mnc = this.convertNullToEmptyString(ci.getMnc());
                int matchType = 0;
                String matchData = null;
                if (!TextUtils.isEmpty(ci.getSpn())) {
                    matchType = 1;
                    matchData = ci.getSpn();
                } else if (!TextUtils.isEmpty(ci.getImsi())) {
                    matchType = 2;
                    matchData = ci.getImsi();
                } else if (!TextUtils.isEmpty(ci.getGid1())) {
                    matchType = 3;
                    matchData = ci.getGid1();
                } else if (!TextUtils.isEmpty(ci.getGid2())) {
                    matchType = 4;
                    matchData = ci.getGid2();
                }
                c.matchType = matchType;
                c.matchData = this.convertNullToEmptyString(matchData);
                carrierList.allowedCarriers.add(c);
            }
            try {
                radioProxy.setAllowedCarriers(rr.mSerial, allAllowed, carrierList);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setAllowedCarriers", e);
            }
        }
    }

    @Override
    public void getAllowedCarriers(Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(137, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getAllowedCarriers(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getAllowedCarriers", e);
            }
        }
    }

    @Override
    public void sendDeviceState(int stateType, boolean state, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(138, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + stateType + ":" + state);
            try {
                radioProxy.sendDeviceState(rr.mSerial, stateType, state);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendDeviceState", e);
            }
        }
    }

    @Override
    public void setUnsolResponseFilter(int filter, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(139, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + filter);
            try {
                radioProxy.setIndicationFilter(rr.mSerial, filter);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setIndicationFilter", e);
            }
        }
    }

    @Override
    public void setSimCardPower(int state, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(140, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + state);
            android.hardware.radio.V1_1.IRadio radioProxy11 = android.hardware.radio.V1_1.IRadio.castFrom(radioProxy);
            if (radioProxy11 == null) {
                try {
                    switch (state) {
                        case 0: {
                            radioProxy.setSimCardPower(rr.mSerial, false);
                            break;
                        }
                        case 1: {
                            radioProxy.setSimCardPower(rr.mSerial, true);
                            break;
                        }
                        default: {
                            if (result != null) {
                                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(6));
                                result.sendToTarget();
                            }
                            break;
                        }
                    }
                }
                catch (RemoteException | RuntimeException e) {
                    this.handleRadioProxyExceptionForRR(rr, "setSimCardPower", e);
                }
            } else {
                try {
                    radioProxy11.setSimCardPower_1_1(rr.mSerial, state);
                }
                catch (RemoteException | RuntimeException e) {
                    this.handleRadioProxyExceptionForRR(rr, "setSimCardPower", e);
                }
            }
        }
    }

    @Override
    public void setCarrierInfoForImsiEncryption(android.telephony.ImsiEncryptionInfo imsiEncryptionInfo, Message result) {
        Preconditions.checkNotNull(imsiEncryptionInfo, "ImsiEncryptionInfo cannot be null.");
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            android.hardware.radio.V1_1.IRadio radioProxy11 = android.hardware.radio.V1_1.IRadio.castFrom(radioProxy);
            if (radioProxy11 == null) {
                if (result != null) {
                    AsyncResult.forMessage(result, null, CommandException.fromRilErrno(6));
                    result.sendToTarget();
                }
            } else {
                RILRequest rr = this.obtainRequest(141, result, this.mRILDefaultWorkSource);
                this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
                try {
                    ImsiEncryptionInfo halImsiInfo = new ImsiEncryptionInfo();
                    halImsiInfo.mnc = imsiEncryptionInfo.getMnc();
                    halImsiInfo.mcc = imsiEncryptionInfo.getMcc();
                    halImsiInfo.keyIdentifier = imsiEncryptionInfo.getKeyIdentifier();
                    if (imsiEncryptionInfo.getExpirationTime() != null) {
                        halImsiInfo.expirationTime = imsiEncryptionInfo.getExpirationTime().getTime();
                    }
                    for (byte b : imsiEncryptionInfo.getPublicKey().getEncoded()) {
                        halImsiInfo.carrierKey.add(new Byte(b));
                    }
                    radioProxy11.setCarrierInfoForImsiEncryption(rr.mSerial, halImsiInfo);
                }
                catch (RemoteException | RuntimeException e) {
                    this.handleRadioProxyExceptionForRR(rr, "setCarrierInfoForImsiEncryption", e);
                }
            }
        }
    }

    @Override
    public void getIMEI(Message result) {
        throw new RuntimeException("getIMEI not expected to be called");
    }

    @Override
    public void getIMEISV(Message result) {
        throw new RuntimeException("getIMEISV not expected to be called");
    }

    @Override
    @Deprecated
    public void getLastPdpFailCause(Message result) {
        throw new RuntimeException("getLastPdpFailCause not expected to be called");
    }

    @Override
    public void getLastDataCallFailCause(Message result) {
        throw new RuntimeException("getLastDataCallFailCause not expected to be called");
    }

    private int translateStatus(int status) {
        switch (status & 7) {
            case 1: {
                return 1;
            }
            case 3: {
                return 0;
            }
            case 5: {
                return 3;
            }
            case 7: {
                return 2;
            }
        }
        return 1;
    }

    @Override
    public void resetRadio(Message result) {
        throw new RuntimeException("resetRadio not expected to be called");
    }

    @Override
    public void handleCallSetupRequestFromSim(boolean accept, Message result) {
        IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(71, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.handleStkCallSetupRequestFromSim(rr.mSerial, accept);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getAllowedCarriers", e);
            }
        }
    }

    void processIndication(int indicationType) {
        if (indicationType == 1) {
            this.sendAck();
            this.riljLog("Unsol response received; Sending ack to ril.cpp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processRequestAck(int serial) {
        RILRequest rr;
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            rr = this.mRequestList.get(serial);
        }
        if (rr == null) {
            Rlog.w(RILJ_LOG_TAG, "processRequestAck: Unexpected solicited ack response! serial: " + serial);
        } else {
            this.decrementWakeLock(rr);
            this.riljLog(rr.serialString() + " Ack < " + RIL.requestToString(rr.mRequest));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RILRequest processResponse(RadioResponseInfo responseInfo) {
        int serial = responseInfo.serial;
        int error = responseInfo.error;
        int type = responseInfo.type;
        RILRequest rr = null;
        if (type == 1) {
            SparseArray<RILRequest> sparseArray = this.mRequestList;
            synchronized (sparseArray) {
                rr = this.mRequestList.get(serial);
            }
            if (rr == null) {
                Rlog.w(RILJ_LOG_TAG, "Unexpected solicited ack response! sn: " + serial);
            } else {
                this.decrementWakeLock(rr);
                this.riljLog(rr.serialString() + " Ack < " + RIL.requestToString(rr.mRequest));
            }
            return rr;
        }
        rr = this.findAndRemoveRequestFromList(serial);
        if (rr == null) {
            Rlog.e(RILJ_LOG_TAG, "processResponse: Unexpected response! serial: " + serial + " error: " + error);
            return null;
        }
        this.addToRilHistogram(rr);
        if (type == 2) {
            this.sendAck();
            this.riljLog("Response received for " + rr.serialString() + " " + RIL.requestToString(rr.mRequest) + " Sending ack to ril.cpp");
        }
        switch (rr.mRequest) {
            case 3: 
            case 5: {
                if (this.mIccStatusChangedRegistrants == null) break;
                this.riljLog("ON enter sim puk fakeSimStatusChanged: reg count=" + this.mIccStatusChangedRegistrants.size());
                this.mIccStatusChangedRegistrants.notifyRegistrants();
                break;
            }
            case 129: {
                this.setRadioState(CommandsInterface.RadioState.RADIO_UNAVAILABLE);
            }
        }
        if (error != 0) {
            switch (rr.mRequest) {
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 43: {
                    if (this.mIccStatusChangedRegistrants == null) break;
                    this.riljLog("ON some errors fakeSimStatusChanged: reg count=" + this.mIccStatusChangedRegistrants.size());
                    this.mIccStatusChangedRegistrants.notifyRegistrants();
                }
            }
        } else {
            switch (rr.mRequest) {
                case 14: {
                    if (!this.mTestingEmergencyCall.getAndSet(false) || this.mEmergencyCallbackModeRegistrant == null) break;
                    this.riljLog("testing emergency call, notify ECM Registrants");
                    this.mEmergencyCallbackModeRegistrant.notifyRegistrant();
                }
            }
        }
        return rr;
    }

    void processResponseDone(RILRequest rr, RadioResponseInfo responseInfo, Object ret) {
        if (responseInfo.error == 0) {
            this.riljLog(rr.serialString() + "< " + RIL.requestToString(rr.mRequest) + " " + RIL.retToString(rr.mRequest, ret));
        } else {
            this.riljLog(rr.serialString() + "< " + RIL.requestToString(rr.mRequest) + " error " + responseInfo.error);
            rr.onError(responseInfo.error, ret);
        }
        this.mMetrics.writeOnRilSolicitedResponse(this.mPhoneId, rr.mSerial, responseInfo.error, rr.mRequest, ret);
        if (rr != null) {
            if (responseInfo.type == 0) {
                this.decrementWakeLock(rr);
            }
            rr.release();
        }
    }

    private void sendAck() {
        RILRequest rr = RILRequest.obtain(800, null, this.mRILDefaultWorkSource);
        this.acquireWakeLock(rr, 1);
        IRadio radioProxy = this.getRadioProxy(null);
        if (radioProxy != null) {
            try {
                radioProxy.responseAcknowledgement();
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendAck", e);
                this.riljLoge("sendAck: " + e);
            }
        } else {
            Rlog.e(RILJ_LOG_TAG, "Error trying to send ack, radioProxy = null");
        }
        rr.release();
    }

    private WorkSource getDeafultWorkSourceIfInvalid(WorkSource workSource) {
        if (workSource == null) {
            workSource = this.mRILDefaultWorkSource;
        }
        return workSource;
    }

    private String getWorkSourceClientId(WorkSource workSource) {
        if (workSource != null) {
            return String.valueOf(workSource.get(0)) + ":" + workSource.getName(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireWakeLock(RILRequest rr, int wakeLockType) {
        RILRequest rILRequest = rr;
        synchronized (rILRequest) {
            if (rr.mWakeLockType != -1) {
                Rlog.d(RILJ_LOG_TAG, "Failed to aquire wakelock for " + rr.serialString());
                return;
            }
            switch (wakeLockType) {
                case 0: {
                    PowerManager.WakeLock wakeLock = this.mWakeLock;
                    synchronized (wakeLock) {
                        this.mWakeLock.acquire();
                        ++this.mWakeLockCount;
                        ++this.mWlSequenceNum;
                        String clientId = this.getWorkSourceClientId(rr.mWorkSource);
                        if (!this.mClientWakelockTracker.isClientActive(clientId)) {
                            if (this.mActiveWakelockWorkSource != null) {
                                this.mActiveWakelockWorkSource.add(rr.mWorkSource);
                            } else {
                                this.mActiveWakelockWorkSource = rr.mWorkSource;
                            }
                            this.mWakeLock.setWorkSource(this.mActiveWakelockWorkSource);
                        }
                        this.mClientWakelockTracker.startTracking(rr.mClientId, rr.mRequest, rr.mSerial, this.mWakeLockCount);
                        Message msg = this.mRilHandler.obtainMessage(2);
                        msg.arg1 = this.mWlSequenceNum;
                        this.mRilHandler.sendMessageDelayed(msg, this.mWakeLockTimeout);
                        break;
                    }
                }
                case 1: {
                    PowerManager.WakeLock wakeLock = this.mAckWakeLock;
                    synchronized (wakeLock) {
                        this.mAckWakeLock.acquire();
                        ++this.mAckWlSequenceNum;
                        Message msg = this.mRilHandler.obtainMessage(4);
                        msg.arg1 = this.mAckWlSequenceNum;
                        this.mRilHandler.sendMessageDelayed(msg, this.mAckWakeLockTimeout);
                        break;
                    }
                }
                default: {
                    Rlog.w(RILJ_LOG_TAG, "Acquiring Invalid Wakelock type " + wakeLockType);
                    return;
                }
            }
            rr.mWakeLockType = wakeLockType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementWakeLock(RILRequest rr) {
        RILRequest rILRequest = rr;
        synchronized (rILRequest) {
            switch (rr.mWakeLockType) {
                case 0: {
                    PowerManager.WakeLock wakeLock = this.mWakeLock;
                    synchronized (wakeLock) {
                        this.mClientWakelockTracker.stopTracking(rr.mClientId, rr.mRequest, rr.mSerial, this.mWakeLockCount > 1 ? this.mWakeLockCount - 1 : 0);
                        String clientId = this.getWorkSourceClientId(rr.mWorkSource);
                        if (!this.mClientWakelockTracker.isClientActive(clientId) && this.mActiveWakelockWorkSource != null) {
                            this.mActiveWakelockWorkSource.remove(rr.mWorkSource);
                            if (this.mActiveWakelockWorkSource.size() == 0) {
                                this.mActiveWakelockWorkSource = null;
                            }
                            this.mWakeLock.setWorkSource(this.mActiveWakelockWorkSource);
                        }
                        if (this.mWakeLockCount > 1) {
                            --this.mWakeLockCount;
                        } else {
                            this.mWakeLockCount = 0;
                            this.mWakeLock.release();
                        }
                        break;
                    }
                }
                case 1: {
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    Rlog.w(RILJ_LOG_TAG, "Decrementing Invalid Wakelock type " + rr.mWakeLockType);
                }
            }
            rr.mWakeLockType = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearWakeLock(int wakeLockType) {
        if (wakeLockType == 0) {
            PowerManager.WakeLock wakeLock = this.mWakeLock;
            synchronized (wakeLock) {
                if (this.mWakeLockCount == 0 && !this.mWakeLock.isHeld()) {
                    return false;
                }
                Rlog.d(RILJ_LOG_TAG, "NOTE: mWakeLockCount is " + this.mWakeLockCount + "at time of clearing");
                this.mWakeLockCount = 0;
                this.mWakeLock.release();
                this.mClientWakelockTracker.stopTrackingAll();
                this.mActiveWakelockWorkSource = null;
                return true;
            }
        }
        PowerManager.WakeLock wakeLock = this.mAckWakeLock;
        synchronized (wakeLock) {
            if (!this.mAckWakeLock.isHeld()) {
                return false;
            }
            this.mAckWakeLock.release();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRequestList(int error, boolean loggable) {
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            int count = this.mRequestList.size();
            if (loggable) {
                Rlog.d(RILJ_LOG_TAG, "clearRequestList  mWakeLockCount=" + this.mWakeLockCount + " mRequestList=" + count);
            }
            for (int i = 0; i < count; ++i) {
                RILRequest rr = this.mRequestList.valueAt(i);
                if (loggable) {
                    Rlog.d(RILJ_LOG_TAG, i + ": [" + rr.mSerial + "] " + RIL.requestToString(rr.mRequest));
                }
                rr.onError(error, null);
                this.decrementWakeLock(rr);
                rr.release();
            }
            this.mRequestList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RILRequest findAndRemoveRequestFromList(int serial) {
        RILRequest rr = null;
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            rr = this.mRequestList.get(serial);
            if (rr != null) {
                this.mRequestList.remove(serial);
            }
        }
        return rr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToRilHistogram(RILRequest rr) {
        long endTime = SystemClock.elapsedRealtime();
        int totalTime = (int)(endTime - rr.mStartTimeMs);
        SparseArray<TelephonyHistogram> sparseArray = mRilTimeHistograms;
        synchronized (sparseArray) {
            TelephonyHistogram entry = mRilTimeHistograms.get(rr.mRequest);
            if (entry == null) {
                entry = new TelephonyHistogram(1, rr.mRequest, 5);
                mRilTimeHistograms.put(rr.mRequest, entry);
            }
            entry.addTimeTaken(totalTime);
        }
    }

    RadioCapability makeStaticRadioCapability() {
        int raf = 1;
        String rafString = this.mContext.getResources().getString(17039686);
        if (!TextUtils.isEmpty(rafString)) {
            raf = RadioAccessFamily.rafTypeFromString(rafString);
        }
        RadioCapability rc = new RadioCapability(this.mPhoneId, 0, 0, raf, "", 1);
        this.riljLog("Faking RIL_REQUEST_GET_RADIO_CAPABILITY response using " + raf);
        return rc;
    }

    static String retToString(int req, Object ret) {
        String s;
        if (ret == null) {
            return "";
        }
        switch (req) {
            case 11: 
            case 38: 
            case 39: 
            case 115: 
            case 117: {
                return "";
            }
        }
        if (ret instanceof int[]) {
            int[] intArray = (int[])ret;
            int length = intArray.length;
            StringBuilder sb = new StringBuilder("{");
            if (length > 0) {
                int i = 0;
                sb.append(intArray[i++]);
                while (i < length) {
                    sb.append(", ").append(intArray[i++]);
                }
            }
            sb.append("}");
            s = sb.toString();
        } else if (ret instanceof String[]) {
            String[] strings = (String[])ret;
            int length = strings.length;
            StringBuilder sb = new StringBuilder("{");
            if (length > 0) {
                int i = 0;
                sb.append(strings[i++]);
                while (i < length) {
                    sb.append(", ").append(strings[i++]);
                }
            }
            sb.append("}");
            s = sb.toString();
        } else if (req == 9) {
            ArrayList calls = (ArrayList)ret;
            StringBuilder sb = new StringBuilder("{");
            for (DriverCall dc : calls) {
                sb.append("[").append(dc).append("] ");
            }
            sb.append("}");
            s = sb.toString();
        } else if (req == 75) {
            ArrayList cells = (ArrayList)ret;
            StringBuilder sb = new StringBuilder("{");
            for (NeighboringCellInfo cell : cells) {
                sb.append("[").append(cell).append("] ");
            }
            sb.append("}");
            s = sb.toString();
        } else if (req == 33) {
            CallForwardInfo[] cinfo = (CallForwardInfo[])ret;
            int length = cinfo.length;
            StringBuilder sb = new StringBuilder("{");
            for (int i = 0; i < length; ++i) {
                sb.append("[").append(cinfo[i]).append("] ");
            }
            sb.append("}");
            s = sb.toString();
        } else if (req == 124) {
            ArrayList hwcfgs = (ArrayList)ret;
            StringBuilder sb = new StringBuilder(" ");
            for (HardwareConfig hwcfg : hwcfgs) {
                sb.append("[").append(hwcfg).append("] ");
            }
            s = sb.toString();
        } else {
            s = ret.toString();
        }
        return s;
    }

    void writeMetricsNewSms(int tech, int format) {
        this.mMetrics.writeRilNewSms(this.mPhoneId, tech, format);
    }

    void writeMetricsCallRing(char[] response) {
        this.mMetrics.writeRilCallRing(this.mPhoneId, response);
    }

    void writeMetricsSrvcc(int state) {
        this.mMetrics.writeRilSrvcc(this.mPhoneId, state);
    }

    void writeMetricsModemRestartEvent(String reason) {
        this.mMetrics.writeModemRestartEvent(this.mPhoneId, reason);
    }

    void notifyRegistrantsRilConnectionChanged(int rilVer) {
        this.mRilVersion = rilVer;
        if (this.mRilConnectedRegistrants != null) {
            this.mRilConnectedRegistrants.notifyRegistrants(new AsyncResult(null, new Integer(rilVer), null));
        }
    }

    void notifyRegistrantsCdmaInfoRec(CdmaInformationRecords infoRec) {
        int response = 1027;
        if (infoRec.record instanceof CdmaInformationRecords.CdmaDisplayInfoRec) {
            if (this.mDisplayInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mDisplayInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaSignalInfoRec) {
            if (this.mSignalInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mSignalInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaNumberInfoRec) {
            if (this.mNumberInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mNumberInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaRedirectingNumberInfoRec) {
            if (this.mRedirNumInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mRedirNumInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaLineControlInfoRec) {
            if (this.mLineControlInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mLineControlInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaT53ClirInfoRec) {
            if (this.mT53ClirInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mT53ClirInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaT53AudioControlInfoRec && this.mT53AudCntrlInfoRegistrants != null) {
            this.unsljLogRet(response, infoRec.record);
            this.mT53AudCntrlInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
        }
    }

    static String requestToString(int request) {
        switch (request) {
            case 1: {
                return "GET_SIM_STATUS";
            }
            case 2: {
                return "ENTER_SIM_PIN";
            }
            case 3: {
                return "ENTER_SIM_PUK";
            }
            case 4: {
                return "ENTER_SIM_PIN2";
            }
            case 5: {
                return "ENTER_SIM_PUK2";
            }
            case 6: {
                return "CHANGE_SIM_PIN";
            }
            case 7: {
                return "CHANGE_SIM_PIN2";
            }
            case 8: {
                return "ENTER_NETWORK_DEPERSONALIZATION";
            }
            case 9: {
                return "GET_CURRENT_CALLS";
            }
            case 10: {
                return "DIAL";
            }
            case 11: {
                return "GET_IMSI";
            }
            case 12: {
                return "HANGUP";
            }
            case 13: {
                return "HANGUP_WAITING_OR_BACKGROUND";
            }
            case 14: {
                return "HANGUP_FOREGROUND_RESUME_BACKGROUND";
            }
            case 15: {
                return "REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE";
            }
            case 16: {
                return "CONFERENCE";
            }
            case 17: {
                return "UDUB";
            }
            case 18: {
                return "LAST_CALL_FAIL_CAUSE";
            }
            case 19: {
                return "SIGNAL_STRENGTH";
            }
            case 20: {
                return "VOICE_REGISTRATION_STATE";
            }
            case 21: {
                return "DATA_REGISTRATION_STATE";
            }
            case 22: {
                return "OPERATOR";
            }
            case 23: {
                return "RADIO_POWER";
            }
            case 24: {
                return "DTMF";
            }
            case 25: {
                return "SEND_SMS";
            }
            case 26: {
                return "SEND_SMS_EXPECT_MORE";
            }
            case 27: {
                return "SETUP_DATA_CALL";
            }
            case 28: {
                return "SIM_IO";
            }
            case 29: {
                return "SEND_USSD";
            }
            case 30: {
                return "CANCEL_USSD";
            }
            case 31: {
                return "GET_CLIR";
            }
            case 32: {
                return "SET_CLIR";
            }
            case 33: {
                return "QUERY_CALL_FORWARD_STATUS";
            }
            case 34: {
                return "SET_CALL_FORWARD";
            }
            case 35: {
                return "QUERY_CALL_WAITING";
            }
            case 36: {
                return "SET_CALL_WAITING";
            }
            case 37: {
                return "SMS_ACKNOWLEDGE";
            }
            case 38: {
                return "GET_IMEI";
            }
            case 39: {
                return "GET_IMEISV";
            }
            case 40: {
                return "ANSWER";
            }
            case 41: {
                return "DEACTIVATE_DATA_CALL";
            }
            case 42: {
                return "QUERY_FACILITY_LOCK";
            }
            case 43: {
                return "SET_FACILITY_LOCK";
            }
            case 44: {
                return "CHANGE_BARRING_PASSWORD";
            }
            case 45: {
                return "QUERY_NETWORK_SELECTION_MODE";
            }
            case 46: {
                return "SET_NETWORK_SELECTION_AUTOMATIC";
            }
            case 47: {
                return "SET_NETWORK_SELECTION_MANUAL";
            }
            case 48: {
                return "QUERY_AVAILABLE_NETWORKS ";
            }
            case 49: {
                return "DTMF_START";
            }
            case 50: {
                return "DTMF_STOP";
            }
            case 51: {
                return "BASEBAND_VERSION";
            }
            case 52: {
                return "SEPARATE_CONNECTION";
            }
            case 53: {
                return "SET_MUTE";
            }
            case 54: {
                return "GET_MUTE";
            }
            case 55: {
                return "QUERY_CLIP";
            }
            case 56: {
                return "LAST_DATA_CALL_FAIL_CAUSE";
            }
            case 57: {
                return "DATA_CALL_LIST";
            }
            case 58: {
                return "RESET_RADIO";
            }
            case 59: {
                return "OEM_HOOK_RAW";
            }
            case 60: {
                return "OEM_HOOK_STRINGS";
            }
            case 61: {
                return "SCREEN_STATE";
            }
            case 62: {
                return "SET_SUPP_SVC_NOTIFICATION";
            }
            case 63: {
                return "WRITE_SMS_TO_SIM";
            }
            case 64: {
                return "DELETE_SMS_ON_SIM";
            }
            case 65: {
                return "SET_BAND_MODE";
            }
            case 66: {
                return "QUERY_AVAILABLE_BAND_MODE";
            }
            case 67: {
                return "REQUEST_STK_GET_PROFILE";
            }
            case 68: {
                return "REQUEST_STK_SET_PROFILE";
            }
            case 69: {
                return "REQUEST_STK_SEND_ENVELOPE_COMMAND";
            }
            case 70: {
                return "REQUEST_STK_SEND_TERMINAL_RESPONSE";
            }
            case 71: {
                return "REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM";
            }
            case 72: {
                return "REQUEST_EXPLICIT_CALL_TRANSFER";
            }
            case 73: {
                return "REQUEST_SET_PREFERRED_NETWORK_TYPE";
            }
            case 74: {
                return "REQUEST_GET_PREFERRED_NETWORK_TYPE";
            }
            case 75: {
                return "REQUEST_GET_NEIGHBORING_CELL_IDS";
            }
            case 76: {
                return "REQUEST_SET_LOCATION_UPDATES";
            }
            case 77: {
                return "RIL_REQUEST_CDMA_SET_SUBSCRIPTION_SOURCE";
            }
            case 78: {
                return "RIL_REQUEST_CDMA_SET_ROAMING_PREFERENCE";
            }
            case 79: {
                return "RIL_REQUEST_CDMA_QUERY_ROAMING_PREFERENCE";
            }
            case 80: {
                return "RIL_REQUEST_SET_TTY_MODE";
            }
            case 81: {
                return "RIL_REQUEST_QUERY_TTY_MODE";
            }
            case 82: {
                return "RIL_REQUEST_CDMA_SET_PREFERRED_VOICE_PRIVACY_MODE";
            }
            case 83: {
                return "RIL_REQUEST_CDMA_QUERY_PREFERRED_VOICE_PRIVACY_MODE";
            }
            case 84: {
                return "RIL_REQUEST_CDMA_FLASH";
            }
            case 85: {
                return "RIL_REQUEST_CDMA_BURST_DTMF";
            }
            case 87: {
                return "RIL_REQUEST_CDMA_SEND_SMS";
            }
            case 88: {
                return "RIL_REQUEST_CDMA_SMS_ACKNOWLEDGE";
            }
            case 89: {
                return "RIL_REQUEST_GSM_GET_BROADCAST_CONFIG";
            }
            case 90: {
                return "RIL_REQUEST_GSM_SET_BROADCAST_CONFIG";
            }
            case 92: {
                return "RIL_REQUEST_CDMA_GET_BROADCAST_CONFIG";
            }
            case 93: {
                return "RIL_REQUEST_CDMA_SET_BROADCAST_CONFIG";
            }
            case 91: {
                return "RIL_REQUEST_GSM_BROADCAST_ACTIVATION";
            }
            case 86: {
                return "RIL_REQUEST_CDMA_VALIDATE_AND_WRITE_AKEY";
            }
            case 94: {
                return "RIL_REQUEST_CDMA_BROADCAST_ACTIVATION";
            }
            case 95: {
                return "RIL_REQUEST_CDMA_SUBSCRIPTION";
            }
            case 96: {
                return "RIL_REQUEST_CDMA_WRITE_SMS_TO_RUIM";
            }
            case 97: {
                return "RIL_REQUEST_CDMA_DELETE_SMS_ON_RUIM";
            }
            case 98: {
                return "RIL_REQUEST_DEVICE_IDENTITY";
            }
            case 100: {
                return "RIL_REQUEST_GET_SMSC_ADDRESS";
            }
            case 101: {
                return "RIL_REQUEST_SET_SMSC_ADDRESS";
            }
            case 99: {
                return "REQUEST_EXIT_EMERGENCY_CALLBACK_MODE";
            }
            case 102: {
                return "RIL_REQUEST_REPORT_SMS_MEMORY_STATUS";
            }
            case 103: {
                return "RIL_REQUEST_REPORT_STK_SERVICE_IS_RUNNING";
            }
            case 104: {
                return "RIL_REQUEST_CDMA_GET_SUBSCRIPTION_SOURCE";
            }
            case 105: {
                return "RIL_REQUEST_ISIM_AUTHENTICATION";
            }
            case 106: {
                return "RIL_REQUEST_ACKNOWLEDGE_INCOMING_GSM_SMS_WITH_PDU";
            }
            case 107: {
                return "RIL_REQUEST_STK_SEND_ENVELOPE_WITH_STATUS";
            }
            case 108: {
                return "RIL_REQUEST_VOICE_RADIO_TECH";
            }
            case 109: {
                return "RIL_REQUEST_GET_CELL_INFO_LIST";
            }
            case 110: {
                return "RIL_REQUEST_SET_CELL_INFO_LIST_RATE";
            }
            case 111: {
                return "RIL_REQUEST_SET_INITIAL_ATTACH_APN";
            }
            case 128: {
                return "RIL_REQUEST_SET_DATA_PROFILE";
            }
            case 112: {
                return "RIL_REQUEST_IMS_REGISTRATION_STATE";
            }
            case 113: {
                return "RIL_REQUEST_IMS_SEND_SMS";
            }
            case 114: {
                return "RIL_REQUEST_SIM_TRANSMIT_APDU_BASIC";
            }
            case 115: {
                return "RIL_REQUEST_SIM_OPEN_CHANNEL";
            }
            case 116: {
                return "RIL_REQUEST_SIM_CLOSE_CHANNEL";
            }
            case 117: {
                return "RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL";
            }
            case 118: {
                return "RIL_REQUEST_NV_READ_ITEM";
            }
            case 119: {
                return "RIL_REQUEST_NV_WRITE_ITEM";
            }
            case 120: {
                return "RIL_REQUEST_NV_WRITE_CDMA_PRL";
            }
            case 121: {
                return "RIL_REQUEST_NV_RESET_CONFIG";
            }
            case 122: {
                return "RIL_REQUEST_SET_UICC_SUBSCRIPTION";
            }
            case 123: {
                return "RIL_REQUEST_ALLOW_DATA";
            }
            case 124: {
                return "GET_HARDWARE_CONFIG";
            }
            case 125: {
                return "RIL_REQUEST_SIM_AUTHENTICATION";
            }
            case 129: {
                return "RIL_REQUEST_SHUTDOWN";
            }
            case 131: {
                return "RIL_REQUEST_SET_RADIO_CAPABILITY";
            }
            case 130: {
                return "RIL_REQUEST_GET_RADIO_CAPABILITY";
            }
            case 132: {
                return "RIL_REQUEST_START_LCE";
            }
            case 133: {
                return "RIL_REQUEST_STOP_LCE";
            }
            case 134: {
                return "RIL_REQUEST_PULL_LCEDATA";
            }
            case 135: {
                return "RIL_REQUEST_GET_ACTIVITY_INFO";
            }
            case 136: {
                return "RIL_REQUEST_SET_ALLOWED_CARRIERS";
            }
            case 137: {
                return "RIL_REQUEST_GET_ALLOWED_CARRIERS";
            }
            case 140: {
                return "RIL_REQUEST_SET_SIM_CARD_POWER";
            }
            case 138: {
                return "RIL_REQUEST_SEND_DEVICE_STATE";
            }
            case 139: {
                return "RIL_REQUEST_SET_UNSOLICITED_RESPONSE_FILTER";
            }
            case 800: {
                return "RIL_RESPONSE_ACKNOWLEDGEMENT";
            }
            case 141: {
                return "RIL_REQUEST_SET_CARRIER_INFO_IMSI_ENCRYPTION";
            }
            case 142: {
                return "RIL_REQUEST_START_NETWORK_SCAN";
            }
            case 143: {
                return "RIL_REQUEST_STOP_NETWORK_SCAN";
            }
        }
        return "<unknown request>";
    }

    static String responseToString(int request) {
        switch (request) {
            case 1000: {
                return "UNSOL_RESPONSE_RADIO_STATE_CHANGED";
            }
            case 1001: {
                return "UNSOL_RESPONSE_CALL_STATE_CHANGED";
            }
            case 1002: {
                return "UNSOL_RESPONSE_NETWORK_STATE_CHANGED";
            }
            case 1003: {
                return "UNSOL_RESPONSE_NEW_SMS";
            }
            case 1004: {
                return "UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT";
            }
            case 1005: {
                return "UNSOL_RESPONSE_NEW_SMS_ON_SIM";
            }
            case 1006: {
                return "UNSOL_ON_USSD";
            }
            case 1007: {
                return "UNSOL_ON_USSD_REQUEST";
            }
            case 1008: {
                return "UNSOL_NITZ_TIME_RECEIVED";
            }
            case 1009: {
                return "UNSOL_SIGNAL_STRENGTH";
            }
            case 1010: {
                return "UNSOL_DATA_CALL_LIST_CHANGED";
            }
            case 1011: {
                return "UNSOL_SUPP_SVC_NOTIFICATION";
            }
            case 1012: {
                return "UNSOL_STK_SESSION_END";
            }
            case 1013: {
                return "UNSOL_STK_PROACTIVE_COMMAND";
            }
            case 1014: {
                return "UNSOL_STK_EVENT_NOTIFY";
            }
            case 1015: {
                return "UNSOL_STK_CALL_SETUP";
            }
            case 1016: {
                return "UNSOL_SIM_SMS_STORAGE_FULL";
            }
            case 1017: {
                return "UNSOL_SIM_REFRESH";
            }
            case 1018: {
                return "UNSOL_CALL_RING";
            }
            case 1019: {
                return "UNSOL_RESPONSE_SIM_STATUS_CHANGED";
            }
            case 1020: {
                return "UNSOL_RESPONSE_CDMA_NEW_SMS";
            }
            case 1021: {
                return "UNSOL_RESPONSE_NEW_BROADCAST_SMS";
            }
            case 1022: {
                return "UNSOL_CDMA_RUIM_SMS_STORAGE_FULL";
            }
            case 1023: {
                return "UNSOL_RESTRICTED_STATE_CHANGED";
            }
            case 1024: {
                return "UNSOL_ENTER_EMERGENCY_CALLBACK_MODE";
            }
            case 1025: {
                return "UNSOL_CDMA_CALL_WAITING";
            }
            case 1026: {
                return "UNSOL_CDMA_OTA_PROVISION_STATUS";
            }
            case 1027: {
                return "UNSOL_CDMA_INFO_REC";
            }
            case 1028: {
                return "UNSOL_OEM_HOOK_RAW";
            }
            case 1029: {
                return "UNSOL_RINGBACK_TONE";
            }
            case 1030: {
                return "UNSOL_RESEND_INCALL_MUTE";
            }
            case 1031: {
                return "CDMA_SUBSCRIPTION_SOURCE_CHANGED";
            }
            case 1032: {
                return "UNSOL_CDMA_PRL_CHANGED";
            }
            case 1033: {
                return "UNSOL_EXIT_EMERGENCY_CALLBACK_MODE";
            }
            case 1034: {
                return "UNSOL_RIL_CONNECTED";
            }
            case 1035: {
                return "UNSOL_VOICE_RADIO_TECH_CHANGED";
            }
            case 1036: {
                return "UNSOL_CELL_INFO_LIST";
            }
            case 1037: {
                return "UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED";
            }
            case 1038: {
                return "RIL_UNSOL_UICC_SUBSCRIPTION_STATUS_CHANGED";
            }
            case 1039: {
                return "UNSOL_SRVCC_STATE_NOTIFY";
            }
            case 1040: {
                return "RIL_UNSOL_HARDWARE_CONFIG_CHANGED";
            }
            case 1042: {
                return "RIL_UNSOL_RADIO_CAPABILITY";
            }
            case 1043: {
                return "UNSOL_ON_SS";
            }
            case 1044: {
                return "UNSOL_STK_CC_ALPHA_NOTIFY";
            }
            case 1045: {
                return "UNSOL_LCE_INFO_RECV";
            }
            case 1046: {
                return "UNSOL_PCO_DATA";
            }
            case 1047: {
                return "UNSOL_MODEM_RESTART";
            }
            case 1048: {
                return "RIL_UNSOL_CARRIER_INFO_IMSI_ENCRYPTION";
            }
            case 1049: {
                return "RIL_UNSOL_NETWORK_SCAN_RESULT";
            }
        }
        return "<unknown response>";
    }

    void riljLog(String msg) {
        Rlog.d(RILJ_LOG_TAG, msg + (this.mPhoneId != null ? " [SUB" + this.mPhoneId + "]" : ""));
    }

    void riljLoge(String msg) {
        Rlog.e(RILJ_LOG_TAG, msg + (this.mPhoneId != null ? " [SUB" + this.mPhoneId + "]" : ""));
    }

    void riljLoge(String msg, Exception e) {
        Rlog.e(RILJ_LOG_TAG, msg + (this.mPhoneId != null ? " [SUB" + this.mPhoneId + "]" : ""), e);
    }

    void riljLogv(String msg) {
        Rlog.v(RILJ_LOG_TAG, msg + (this.mPhoneId != null ? " [SUB" + this.mPhoneId + "]" : ""));
    }

    void unsljLog(int response) {
        this.riljLog("[UNSL]< " + RIL.responseToString(response));
    }

    void unsljLogMore(int response, String more) {
        this.riljLog("[UNSL]< " + RIL.responseToString(response) + " " + more);
    }

    void unsljLogRet(int response, Object ret) {
        this.riljLog("[UNSL]< " + RIL.responseToString(response) + " " + RIL.retToString(response, ret));
    }

    void unsljLogvRet(int response, Object ret) {
        this.riljLogv("[UNSL]< " + RIL.responseToString(response) + " " + RIL.retToString(response, ret));
    }

    @Override
    public void setPhoneType(int phoneType) {
        this.riljLog("setPhoneType=" + phoneType + " old value=" + this.mPhoneType);
        this.mPhoneType = phoneType;
    }

    @Override
    public void testingEmergencyCall() {
        this.riljLog("testingEmergencyCall");
        this.mTestingEmergencyCall.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("RIL: " + this);
        pw.println(" mWakeLock=" + this.mWakeLock);
        pw.println(" mWakeLockTimeout=" + this.mWakeLockTimeout);
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            PowerManager.WakeLock wakeLock = this.mWakeLock;
            synchronized (wakeLock) {
                pw.println(" mWakeLockCount=" + this.mWakeLockCount);
            }
            int count = this.mRequestList.size();
            pw.println(" mRequestList count=" + count);
            for (int i = 0; i < count; ++i) {
                RILRequest rr = this.mRequestList.valueAt(i);
                pw.println("  [" + rr.mSerial + "] " + RIL.requestToString(rr.mRequest));
            }
        }
        pw.println(" mLastNITZTimeInfo=" + Arrays.toString(this.mLastNITZTimeInfo));
        pw.println(" mTestingEmergencyCall=" + this.mTestingEmergencyCall.get());
        this.mClientWakelockTracker.dumpClientRequestTracker(pw);
    }

    @Override
    public List<ClientRequestStats> getClientRequestStats() {
        return this.mClientWakelockTracker.getClientRequestStats();
    }

    public static ArrayList<Byte> primitiveArrayToArrayList(byte[] arr) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>(arr.length);
        for (byte b : arr) {
            arrayList.add(b);
        }
        return arrayList;
    }

    public static byte[] arrayListToPrimitiveArray(ArrayList<Byte> bytes) {
        byte[] ret = new byte[bytes.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = bytes.get(i);
        }
        return ret;
    }

    static ArrayList<HardwareConfig> convertHalHwConfigList(ArrayList<android.hardware.radio.V1_0.HardwareConfig> hwListRil, RIL ril) {
        int num = hwListRil.size();
        ArrayList<HardwareConfig> response = new ArrayList<HardwareConfig>(num);
        for (android.hardware.radio.V1_0.HardwareConfig hwRil : hwListRil) {
            HardwareConfig hw;
            int type = hwRil.type;
            switch (type) {
                case 0: {
                    hw = new HardwareConfig(type);
                    HardwareConfigModem hwModem = hwRil.modem.get(0);
                    hw.assignModem(hwRil.uuid, hwRil.state, hwModem.rilModel, hwModem.rat, hwModem.maxVoice, hwModem.maxData, hwModem.maxStandby);
                    break;
                }
                case 1: {
                    hw = new HardwareConfig(type);
                    hw.assignSim(hwRil.uuid, hwRil.state, hwRil.sim.get((int)0).modemUuid);
                    break;
                }
                default: {
                    throw new RuntimeException("RIL_REQUEST_GET_HARDWARE_CONFIG invalid hardward type:" + type);
                }
            }
            response.add(hw);
        }
        return response;
    }

    static RadioCapability convertHalRadioCapability(android.hardware.radio.V1_0.RadioCapability rcRil, RIL ril) {
        int session = rcRil.session;
        int phase = rcRil.phase;
        int rat = rcRil.raf;
        String logicModemUuid = rcRil.logicalModemUuid;
        int status = rcRil.status;
        ril.riljLog("convertHalRadioCapability: session=" + session + ", phase=" + phase + ", rat=" + rat + ", logicModemUuid=" + logicModemUuid + ", status=" + status);
        RadioCapability rc = new RadioCapability(ril.mPhoneId, session, phase, rat, logicModemUuid, status);
        return rc;
    }

    static ArrayList<Integer> convertHalLceData(LceDataInfo lce, RIL ril) {
        ArrayList<Integer> capacityResponse = new ArrayList<Integer>();
        int capacityDownKbps = lce.lastHopCapacityKbps;
        int confidenceLevel = Byte.toUnsignedInt(lce.confidenceLevel);
        int lceSuspended = lce.lceSuspended ? 1 : 0;
        ril.riljLog("LCE capacity information received: capacity=" + capacityDownKbps + " confidence=" + confidenceLevel + " lceSuspended=" + lceSuspended);
        capacityResponse.add(capacityDownKbps);
        capacityResponse.add(confidenceLevel);
        capacityResponse.add(lceSuspended);
        return capacityResponse;
    }

    static ArrayList<android.telephony.CellInfo> convertHalCellInfoList(ArrayList<CellInfo> records) {
        ArrayList<android.telephony.CellInfo> response = new ArrayList<android.telephony.CellInfo>(records.size());
        for (CellInfo record : records) {
            Parcel p = Parcel.obtain();
            p.writeInt(record.cellInfoType);
            p.writeInt(record.registered ? 1 : 0);
            p.writeInt(record.timeStampType);
            p.writeLong(record.timeStamp);
            switch (record.cellInfoType) {
                case 1: {
                    CellInfoGsm cellInfoGsm = record.gsm.get(0);
                    p.writeInt(Integer.parseInt(cellInfoGsm.cellIdentityGsm.mcc));
                    p.writeInt(Integer.parseInt(cellInfoGsm.cellIdentityGsm.mnc));
                    p.writeInt(cellInfoGsm.cellIdentityGsm.lac);
                    p.writeInt(cellInfoGsm.cellIdentityGsm.cid);
                    p.writeInt(cellInfoGsm.cellIdentityGsm.arfcn);
                    p.writeInt(Byte.toUnsignedInt(cellInfoGsm.cellIdentityGsm.bsic));
                    p.writeInt(cellInfoGsm.signalStrengthGsm.signalStrength);
                    p.writeInt(cellInfoGsm.signalStrengthGsm.bitErrorRate);
                    p.writeInt(cellInfoGsm.signalStrengthGsm.timingAdvance);
                    break;
                }
                case 2: {
                    CellInfoCdma cellInfoCdma = record.cdma.get(0);
                    p.writeInt(cellInfoCdma.cellIdentityCdma.networkId);
                    p.writeInt(cellInfoCdma.cellIdentityCdma.systemId);
                    p.writeInt(cellInfoCdma.cellIdentityCdma.baseStationId);
                    p.writeInt(cellInfoCdma.cellIdentityCdma.longitude);
                    p.writeInt(cellInfoCdma.cellIdentityCdma.latitude);
                    p.writeInt(cellInfoCdma.signalStrengthCdma.dbm);
                    p.writeInt(cellInfoCdma.signalStrengthCdma.ecio);
                    p.writeInt(cellInfoCdma.signalStrengthEvdo.dbm);
                    p.writeInt(cellInfoCdma.signalStrengthEvdo.ecio);
                    p.writeInt(cellInfoCdma.signalStrengthEvdo.signalNoiseRatio);
                    break;
                }
                case 3: {
                    CellInfoLte cellInfoLte = record.lte.get(0);
                    p.writeInt(Integer.parseInt(cellInfoLte.cellIdentityLte.mcc));
                    p.writeInt(Integer.parseInt(cellInfoLte.cellIdentityLte.mnc));
                    p.writeInt(cellInfoLte.cellIdentityLte.ci);
                    p.writeInt(cellInfoLte.cellIdentityLte.pci);
                    p.writeInt(cellInfoLte.cellIdentityLte.tac);
                    p.writeInt(cellInfoLte.cellIdentityLte.earfcn);
                    p.writeInt(cellInfoLte.signalStrengthLte.signalStrength);
                    p.writeInt(cellInfoLte.signalStrengthLte.rsrp);
                    p.writeInt(cellInfoLte.signalStrengthLte.rsrq);
                    p.writeInt(cellInfoLte.signalStrengthLte.rssnr);
                    p.writeInt(cellInfoLte.signalStrengthLte.cqi);
                    p.writeInt(cellInfoLte.signalStrengthLte.timingAdvance);
                    break;
                }
                case 4: {
                    CellInfoWcdma cellInfoWcdma = record.wcdma.get(0);
                    p.writeInt(Integer.parseInt(cellInfoWcdma.cellIdentityWcdma.mcc));
                    p.writeInt(Integer.parseInt(cellInfoWcdma.cellIdentityWcdma.mnc));
                    p.writeInt(cellInfoWcdma.cellIdentityWcdma.lac);
                    p.writeInt(cellInfoWcdma.cellIdentityWcdma.cid);
                    p.writeInt(cellInfoWcdma.cellIdentityWcdma.psc);
                    p.writeInt(cellInfoWcdma.cellIdentityWcdma.uarfcn);
                    p.writeInt(cellInfoWcdma.signalStrengthWcdma.signalStrength);
                    p.writeInt(cellInfoWcdma.signalStrengthWcdma.bitErrorRate);
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected cellinfotype: " + record.cellInfoType);
                }
            }
            p.setDataPosition(0);
            android.telephony.CellInfo InfoRec = android.telephony.CellInfo.CREATOR.createFromParcel(p);
            p.recycle();
            response.add(InfoRec);
        }
        return response;
    }

    static SignalStrength convertHalSignalStrength(android.hardware.radio.V1_0.SignalStrength signalStrength) {
        return new SignalStrength(signalStrength.gw.signalStrength, signalStrength.gw.bitErrorRate, signalStrength.cdma.dbm, signalStrength.cdma.ecio, signalStrength.evdo.dbm, signalStrength.evdo.ecio, signalStrength.evdo.signalNoiseRatio, signalStrength.lte.signalStrength, signalStrength.lte.rsrp, signalStrength.lte.rsrq, signalStrength.lte.rssnr, signalStrength.lte.cqi, signalStrength.tdScdma.rscp, false);
    }

    final class RadioProxyDeathRecipient
    implements IHwBinder.DeathRecipient {
        RadioProxyDeathRecipient() {
        }

        @Override
        public void serviceDied(long cookie) {
            RIL.this.riljLog("serviceDied");
            RIL.this.mRilHandler.sendMessageDelayed(RIL.this.mRilHandler.obtainMessage(6, cookie), 4000L);
        }
    }

    class RilHandler
    extends Handler {
        RilHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    SparseArray<RILRequest> sparseArray = RIL.this.mRequestList;
                    synchronized (sparseArray) {
                        if (msg.arg1 == RIL.this.mWlSequenceNum && RIL.this.clearWakeLock(0)) {
                            int count = RIL.this.mRequestList.size();
                            Rlog.d(RIL.RILJ_LOG_TAG, "WAKE_LOCK_TIMEOUT  mRequestList=" + count);
                            for (int i = 0; i < count; ++i) {
                                RILRequest rr = RIL.this.mRequestList.valueAt(i);
                                Rlog.d(RIL.RILJ_LOG_TAG, i + ": [" + rr.mSerial + "] " + RIL.requestToString(rr.mRequest));
                            }
                        }
                        break;
                    }
                }
                case 4: {
                    if (msg.arg1 != RIL.this.mAckWlSequenceNum || !RIL.this.clearWakeLock(1)) break;
                    break;
                }
                case 5: {
                    int serial = msg.arg1;
                    RILRequest rr = RIL.this.findAndRemoveRequestFromList(serial);
                    if (rr == null) break;
                    if (rr.mResult != null) {
                        Object timeoutResponse = RIL.getResponseForTimedOutRILRequest(rr);
                        AsyncResult.forMessage(rr.mResult, timeoutResponse, null);
                        rr.mResult.sendToTarget();
                        RIL.this.mMetrics.writeOnRilTimeoutResponse(RIL.this.mPhoneId, rr.mSerial, rr.mRequest);
                    }
                    RIL.this.decrementWakeLock(rr);
                    rr.release();
                    break;
                }
                case 6: {
                    RIL.this.riljLog("handleMessage: EVENT_RADIO_PROXY_DEAD cookie = " + msg.obj + " mRadioProxyCookie = " + RIL.this.mRadioProxyCookie.get());
                    if (((Long)msg.obj).longValue() != RIL.this.mRadioProxyCookie.get()) break;
                    RIL.this.resetProxyAndRequestList();
                    RIL.this.getRadioProxy(null);
                    RIL.this.getOemHookProxy(null);
                }
            }
        }
    }
}

