/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.telephony.ClientRequestStats;
import android.telephony.Rlog;
import com.android.internal.telephony.RilWakelockInfo;
import java.util.ArrayList;

public class ClientWakelockAccountant {
    public static final String LOG_TAG = "ClientWakelockAccountant: ";
    public ClientRequestStats mRequestStats = new ClientRequestStats();
    public ArrayList<RilWakelockInfo> mPendingRilWakelocks = new ArrayList();

    public ClientWakelockAccountant(String callingPackage) {
        this.mRequestStats.setCallingPackage(callingPackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAttributingWakelock(int request, int token, int concurrentRequests, long time) {
        RilWakelockInfo wlInfo = new RilWakelockInfo(request, token, concurrentRequests, time);
        ArrayList<RilWakelockInfo> arrayList = this.mPendingRilWakelocks;
        synchronized (arrayList) {
            this.mPendingRilWakelocks.add(wlInfo);
        }
    }

    public void stopAttributingWakelock(int request, int token, long time) {
        RilWakelockInfo wlInfo = this.removePendingWakelock(request, token);
        if (wlInfo != null) {
            this.completeRequest(wlInfo, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllPendingRequests(long time) {
        ArrayList<RilWakelockInfo> arrayList = this.mPendingRilWakelocks;
        synchronized (arrayList) {
            for (RilWakelockInfo wlInfo : this.mPendingRilWakelocks) {
                this.completeRequest(wlInfo, time);
            }
            this.mPendingRilWakelocks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeConcurrentRequests(int concurrentRequests, long time) {
        ArrayList<RilWakelockInfo> arrayList = this.mPendingRilWakelocks;
        synchronized (arrayList) {
            for (RilWakelockInfo wlInfo : this.mPendingRilWakelocks) {
                wlInfo.updateConcurrentRequests(concurrentRequests, time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRequest(RilWakelockInfo wlInfo, long time) {
        wlInfo.setResponseTime(time);
        ClientRequestStats clientRequestStats = this.mRequestStats;
        synchronized (clientRequestStats) {
            this.mRequestStats.addCompletedWakelockTime(wlInfo.getWakelockTimeAttributedToClient());
            this.mRequestStats.incrementCompletedRequestsCount();
            this.mRequestStats.updateRequestHistograms(wlInfo.getRilRequestSent(), (int)wlInfo.getWakelockTimeAttributedToClient());
        }
    }

    public int getPendingRequestCount() {
        return this.mPendingRilWakelocks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long updatePendingRequestWakelockTime(long uptime) {
        long totalPendingWakelockTime = 0L;
        Object object = this.mPendingRilWakelocks;
        synchronized (object) {
            for (RilWakelockInfo wlInfo : this.mPendingRilWakelocks) {
                wlInfo.updateTime(uptime);
                totalPendingWakelockTime += wlInfo.getWakelockTimeAttributedToClient();
            }
        }
        object = this.mRequestStats;
        synchronized (object) {
            this.mRequestStats.setPendingRequestsCount(this.getPendingRequestCount());
            this.mRequestStats.setPendingRequestsWakelockTime(totalPendingWakelockTime);
        }
        return totalPendingWakelockTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RilWakelockInfo removePendingWakelock(int request, int token) {
        RilWakelockInfo result = null;
        ArrayList<RilWakelockInfo> arrayList = this.mPendingRilWakelocks;
        synchronized (arrayList) {
            for (RilWakelockInfo wlInfo : this.mPendingRilWakelocks) {
                if (wlInfo.getTokenNumber() != token || wlInfo.getRilRequestSent() != request) continue;
                result = wlInfo;
            }
            if (result != null) {
                this.mPendingRilWakelocks.remove(result);
            }
        }
        if (result == null) {
            Rlog.w(LOG_TAG, "Looking for Request<" + request + "," + token + "> in " + this.mPendingRilWakelocks);
        }
        return result;
    }

    public String toString() {
        return "ClientWakelockAccountant{mRequestStats=" + this.mRequestStats + ", mPendingRilWakelocks=" + this.mPendingRilWakelocks + '}';
    }
}

