/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.provider.Settings;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.ServiceStateTracker;
import java.util.HashMap;
import java.util.Map;

public class CarrierServiceStateTracker
extends Handler {
    private static final String LOG_TAG = "CSST";
    protected static final int CARRIER_EVENT_BASE = 100;
    protected static final int CARRIER_EVENT_VOICE_REGISTRATION = 101;
    protected static final int CARRIER_EVENT_VOICE_DEREGISTRATION = 102;
    protected static final int CARRIER_EVENT_DATA_REGISTRATION = 103;
    protected static final int CARRIER_EVENT_DATA_DEREGISTRATION = 104;
    private static final int UNINITIALIZED_DELAY_VALUE = -1;
    private Phone mPhone;
    private ServiceStateTracker mSST;
    public static final int NOTIFICATION_PREF_NETWORK = 1000;
    public static final int NOTIFICATION_EMERGENCY_NETWORK = 1001;
    private final Map<Integer, NotificationType> mNotificationTypeMap = new HashMap<Integer, NotificationType>();
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            CarrierConfigManager carrierConfigManager = (CarrierConfigManager)context.getSystemService("carrier_config");
            PersistableBundle b = carrierConfigManager.getConfigForSubId(CarrierServiceStateTracker.this.mPhone.getSubId());
            for (Map.Entry entry : CarrierServiceStateTracker.this.mNotificationTypeMap.entrySet()) {
                NotificationType notificationType = (NotificationType)entry.getValue();
                notificationType.setDelay(b);
            }
            CarrierServiceStateTracker.this.handleConfigChanges();
        }
    };

    public CarrierServiceStateTracker(Phone phone, ServiceStateTracker sst) {
        this.mPhone = phone;
        this.mSST = sst;
        phone.getContext().registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"));
        this.registerNotificationTypes();
    }

    private void registerNotificationTypes() {
        this.mNotificationTypeMap.put(1000, new PrefNetworkNotification(1000));
        this.mNotificationTypeMap.put(1001, new EmergencyNetworkNotification(1001));
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                this.handleConfigChanges();
                break;
            }
            case 1000: 
            case 1001: {
                Rlog.d(LOG_TAG, "sending notification after delay: " + msg.what);
                NotificationType notificationType = this.mNotificationTypeMap.get(msg.what);
                if (notificationType == null) break;
                this.sendNotification(notificationType);
            }
        }
    }

    private boolean isPhoneStillRegistered() {
        if (this.mSST.mSS == null) {
            return true;
        }
        return this.mSST.mSS.getVoiceRegState() == 0 || this.mSST.mSS.getDataRegState() == 0;
    }

    private boolean isPhoneVoiceRegistered() {
        if (this.mSST.mSS == null) {
            return true;
        }
        return this.mSST.mSS.getVoiceRegState() == 0;
    }

    private boolean isPhoneRegisteredForWifiCalling() {
        Rlog.d(LOG_TAG, "isPhoneRegisteredForWifiCalling: " + this.mPhone.isWifiCallingEnabled());
        return this.mPhone.isWifiCallingEnabled();
    }

    public boolean isRadioOffOrAirplaneMode() {
        Context context = this.mPhone.getContext();
        int airplaneMode = -1;
        try {
            airplaneMode = Settings.Global.getInt(context.getContentResolver(), "airplane_mode_on", 0);
        }
        catch (Exception e) {
            Rlog.e(LOG_TAG, "Unable to get AIRPLACE_MODE_ON.");
            return true;
        }
        return !this.mSST.isRadioOn() || airplaneMode != 0;
    }

    private boolean isGlobalMode() {
        Context context = this.mPhone.getContext();
        int preferredNetworkSetting = -1;
        try {
            preferredNetworkSetting = Settings.Global.getInt(context.getContentResolver(), "preferred_network_mode" + this.mPhone.getSubId(), Phone.PREFERRED_NT_MODE);
        }
        catch (Exception e) {
            Rlog.e(LOG_TAG, "Unable to get PREFERRED_NETWORK_MODE.");
            return true;
        }
        return preferredNetworkSetting == 10;
    }

    private void handleConfigChanges() {
        for (Map.Entry<Integer, NotificationType> entry : this.mNotificationTypeMap.entrySet()) {
            NotificationType notificationType = entry.getValue();
            if (this.evaluateSendingMessage(notificationType)) {
                Message notificationMsg = this.obtainMessage(notificationType.getTypeId(), null);
                Rlog.i(LOG_TAG, "starting timer for notifications." + notificationType.getTypeId());
                this.sendMessageDelayed(notificationMsg, this.getDelay(notificationType));
                continue;
            }
            this.cancelNotification(notificationType.getTypeId());
            Rlog.i(LOG_TAG, "canceling notifications: " + notificationType.getTypeId());
        }
    }

    public boolean evaluateSendingMessage(NotificationType notificationType) {
        return notificationType.sendMessage();
    }

    public int getDelay(NotificationType notificationType) {
        return notificationType.getDelay();
    }

    public Notification.Builder getNotificationBuilder(NotificationType notificationType) {
        return notificationType.getNotificationBuilder();
    }

    public NotificationManager getNotificationManager(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }

    public void sendNotification(NotificationType notificationType) {
        if (!this.evaluateSendingMessage(notificationType)) {
            return;
        }
        Context context = this.mPhone.getContext();
        Notification.Builder builder = this.getNotificationBuilder(notificationType);
        builder.setWhen(System.currentTimeMillis()).setAutoCancel(true).setSmallIcon(17301642).setColor(context.getResources().getColor(17170763));
        this.getNotificationManager(context).notify(notificationType.getTypeId(), builder.build());
    }

    public void cancelNotification(int notificationId) {
        Context context = this.mPhone.getContext();
        this.removeMessages(notificationId);
        this.getNotificationManager(context).cancel(notificationId);
    }

    public class EmergencyNetworkNotification
    implements NotificationType {
        private final int mTypeId;
        private int mDelay = -1;

        EmergencyNetworkNotification(int typeId) {
            this.mTypeId = typeId;
        }

        @Override
        public void setDelay(PersistableBundle bundle) {
            if (bundle == null) {
                Rlog.e(CarrierServiceStateTracker.LOG_TAG, "bundle is null");
                return;
            }
            this.mDelay = bundle.getInt("emergency_notification_delay_int");
            Rlog.i(CarrierServiceStateTracker.LOG_TAG, "reading time to delay notification emergency: " + this.mDelay);
        }

        @Override
        public int getDelay() {
            return this.mDelay;
        }

        @Override
        public int getTypeId() {
            return this.mTypeId;
        }

        @Override
        public boolean sendMessage() {
            Rlog.i(CarrierServiceStateTracker.LOG_TAG, "EmergencyNetworkNotification: sendMessage() w/values: ," + CarrierServiceStateTracker.this.isPhoneVoiceRegistered() + "," + this.mDelay + "," + CarrierServiceStateTracker.this.isPhoneRegisteredForWifiCalling() + "," + CarrierServiceStateTracker.this.mSST.isRadioOn());
            return this.mDelay != -1 && !CarrierServiceStateTracker.this.isPhoneVoiceRegistered() && CarrierServiceStateTracker.this.isPhoneRegisteredForWifiCalling();
        }

        @Override
        public Notification.Builder getNotificationBuilder() {
            Context context = CarrierServiceStateTracker.this.mPhone.getContext();
            CharSequence title = context.getText(17039404);
            CharSequence details = context.getText(17039403);
            return new Notification.Builder(context).setContentTitle(title).setStyle(new Notification.BigTextStyle().bigText(details)).setContentText(details).setChannel("wfc");
        }
    }

    public class PrefNetworkNotification
    implements NotificationType {
        private final int mTypeId;
        private int mDelay = -1;

        PrefNetworkNotification(int typeId) {
            this.mTypeId = typeId;
        }

        @Override
        public void setDelay(PersistableBundle bundle) {
            if (bundle == null) {
                Rlog.e(CarrierServiceStateTracker.LOG_TAG, "bundle is null");
                return;
            }
            this.mDelay = bundle.getInt("network_notification_delay_int");
            Rlog.i(CarrierServiceStateTracker.LOG_TAG, "reading time to delay notification emergency: " + this.mDelay);
        }

        @Override
        public int getDelay() {
            return this.mDelay;
        }

        @Override
        public int getTypeId() {
            return this.mTypeId;
        }

        @Override
        public boolean sendMessage() {
            Rlog.i(CarrierServiceStateTracker.LOG_TAG, "PrefNetworkNotification: sendMessage() w/values: ," + CarrierServiceStateTracker.this.isPhoneStillRegistered() + "," + this.mDelay + "," + CarrierServiceStateTracker.this.isGlobalMode() + "," + CarrierServiceStateTracker.this.mSST.isRadioOn());
            return this.mDelay != -1 && !CarrierServiceStateTracker.this.isPhoneStillRegistered() && !CarrierServiceStateTracker.this.isGlobalMode() && !CarrierServiceStateTracker.this.isRadioOffOrAirplaneMode();
        }

        @Override
        public Notification.Builder getNotificationBuilder() {
            Context context = CarrierServiceStateTracker.this.mPhone.getContext();
            Intent notificationIntent = new Intent("android.settings.DATA_ROAMING_SETTINGS");
            PendingIntent settingsIntent = PendingIntent.getActivity(context, 0, notificationIntent, 0x40000000);
            CharSequence title = context.getText(17039407);
            CharSequence details = context.getText(17039406);
            return new Notification.Builder(context).setContentTitle(title).setStyle(new Notification.BigTextStyle().bigText(details)).setContentText(details).setChannel("alert").setContentIntent(settingsIntent);
        }
    }

    public static interface NotificationType {
        public boolean sendMessage();

        public int getDelay();

        public void setDelay(PersistableBundle var1);

        public int getTypeId();

        public Notification.Builder getNotificationBuilder();
    }
}

