/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.Credentials;
import android.net.LocalSocket;
import android.os.FactoryTest;
import android.os.Process;
import android.os.SystemProperties;
import android.os.Trace;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructPollfd;
import android.util.Log;
import com.android.internal.os.RoSystemProperties;
import com.android.internal.os.WrapperInit;
import com.android.internal.os.Zygote;
import com.android.internal.os.ZygoteInit;
import com.android.internal.os.ZygoteSecurityException;
import com.android.internal.os.ZygoteServer;
import dalvik.system.VMRuntime;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import libcore.io.IoUtils;

class ZygoteConnection {
    private static final String TAG = "Zygote";
    private static final int[][] intArray2d = new int[0][0];
    private final LocalSocket mSocket;
    private final DataOutputStream mSocketOutStream;
    private final BufferedReader mSocketReader;
    private final Credentials peer;
    private final String abiList;
    private boolean isEof;

    ZygoteConnection(LocalSocket socket, String abiList) throws IOException {
        this.mSocket = socket;
        this.abiList = abiList;
        this.mSocketOutStream = new DataOutputStream(socket.getOutputStream());
        this.mSocketReader = new BufferedReader(new InputStreamReader(socket.getInputStream()), 256);
        this.mSocket.setSoTimeout(1000);
        try {
            this.peer = this.mSocket.getPeerCredentials();
        }
        catch (IOException ex) {
            Log.e(TAG, "Cannot read peer credentials", ex);
            throw ex;
        }
        this.isEof = false;
    }

    FileDescriptor getFileDesciptor() {
        return this.mSocket.getFileDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Runnable processOneCommand(ZygoteServer zygoteServer) {
        FileDescriptor[] descriptors;
        String[] args;
        Arguments parsedArgs = null;
        try {
            args = this.readArgumentList();
            descriptors = this.mSocket.getAncillaryFileDescriptors();
        }
        catch (IOException ex) {
            throw new IllegalStateException("IOException on command socket", ex);
        }
        if (args == null) {
            this.isEof = true;
            return null;
        }
        int pid = -1;
        FileDescriptor childPipeFd = null;
        FileDescriptor serverPipeFd = null;
        parsedArgs = new Arguments(args);
        if (parsedArgs.abiListQuery) {
            this.handleAbiListQuery();
            return null;
        }
        if (parsedArgs.preloadDefault) {
            this.handlePreload();
            return null;
        }
        if (parsedArgs.preloadPackage != null) {
            this.handlePreloadPackage(parsedArgs.preloadPackage, parsedArgs.preloadPackageLibs, parsedArgs.preloadPackageCacheKey);
            return null;
        }
        if (parsedArgs.permittedCapabilities != 0L || parsedArgs.effectiveCapabilities != 0L) {
            throw new ZygoteSecurityException("Client may not specify capabilities: permitted=0x" + Long.toHexString(parsedArgs.permittedCapabilities) + ", effective=0x" + Long.toHexString(parsedArgs.effectiveCapabilities));
        }
        ZygoteConnection.applyUidSecurityPolicy(parsedArgs, this.peer);
        ZygoteConnection.applyInvokeWithSecurityPolicy(parsedArgs, this.peer);
        ZygoteConnection.applyDebuggerSystemProperty(parsedArgs);
        ZygoteConnection.applyInvokeWithSystemProperty(parsedArgs);
        int[][] rlimits = null;
        if (parsedArgs.rlimits != null) {
            rlimits = (int[][])parsedArgs.rlimits.toArray((T[])intArray2d);
        }
        int[] fdsToIgnore = null;
        if (parsedArgs.invokeWith != null) {
            try {
                FileDescriptor[] pipeFds = Os.pipe2(OsConstants.O_CLOEXEC);
                childPipeFd = pipeFds[1];
                serverPipeFd = pipeFds[0];
                Os.fcntlInt(childPipeFd, OsConstants.F_SETFD, 0);
                fdsToIgnore = new int[]{childPipeFd.getInt$(), serverPipeFd.getInt$()};
            }
            catch (ErrnoException errnoEx) {
                throw new IllegalStateException("Unable to set up pipe for invoke-with", errnoEx);
            }
        }
        int[] fdsToClose = new int[]{-1, -1};
        FileDescriptor fd = this.mSocket.getFileDescriptor();
        if (fd != null) {
            fdsToClose[0] = fd.getInt$();
        }
        if ((fd = zygoteServer.getServerSocketFileDescriptor()) != null) {
            fdsToClose[1] = fd.getInt$();
        }
        fd = null;
        pid = Zygote.forkAndSpecialize(parsedArgs.uid, parsedArgs.gid, parsedArgs.gids, parsedArgs.debugFlags, rlimits, parsedArgs.mountExternal, parsedArgs.seInfo, parsedArgs.niceName, fdsToClose, fdsToIgnore, parsedArgs.instructionSet, parsedArgs.appDataDir);
        try {
            if (pid == 0) {
                zygoteServer.setForkChild();
                zygoteServer.closeServerSocket();
                IoUtils.closeQuietly(serverPipeFd);
                serverPipeFd = null;
                Runnable runnable = this.handleChildProc(parsedArgs, descriptors, childPipeFd);
                return runnable;
            }
            IoUtils.closeQuietly(childPipeFd);
            childPipeFd = null;
            this.handleParentProc(pid, descriptors, serverPipeFd);
            Runnable runnable = null;
            return runnable;
        }
        finally {
            IoUtils.closeQuietly(childPipeFd);
            IoUtils.closeQuietly(serverPipeFd);
        }
    }

    private void handleAbiListQuery() {
        try {
            byte[] abiListBytes = this.abiList.getBytes(StandardCharsets.US_ASCII);
            this.mSocketOutStream.writeInt(abiListBytes.length);
            this.mSocketOutStream.write(abiListBytes);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error writing to command socket", ioe);
        }
    }

    private void handlePreload() {
        try {
            if (this.isPreloadComplete()) {
                this.mSocketOutStream.writeInt(1);
            } else {
                this.preload();
                this.mSocketOutStream.writeInt(0);
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error writing to command socket", ioe);
        }
    }

    protected void preload() {
        ZygoteInit.lazyPreload();
    }

    protected boolean isPreloadComplete() {
        return ZygoteInit.isPreloadComplete();
    }

    protected DataOutputStream getSocketOutputStream() {
        return this.mSocketOutStream;
    }

    protected void handlePreloadPackage(String packagePath, String libsPath, String cacheKey) {
        throw new RuntimeException("Zyogte does not support package preloading");
    }

    void closeSocket() {
        try {
            this.mSocket.close();
        }
        catch (IOException ex) {
            Log.e(TAG, "Exception while closing command socket in parent", ex);
        }
    }

    boolean isClosedByPeer() {
        return this.isEof;
    }

    private String[] readArgumentList() throws IOException {
        int argc;
        try {
            String s = this.mSocketReader.readLine();
            if (s == null) {
                return null;
            }
            argc = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            Log.e(TAG, "invalid Zygote wire format: non-int at argc");
            throw new IOException("invalid wire format");
        }
        if (argc > 1024) {
            throw new IOException("max arg count exceeded");
        }
        String[] result = new String[argc];
        for (int i = 0; i < argc; ++i) {
            result[i] = this.mSocketReader.readLine();
            if (result[i] != null) continue;
            throw new IOException("truncated request");
        }
        return result;
    }

    private static void applyUidSecurityPolicy(Arguments args, Credentials peer) throws ZygoteSecurityException {
        if (peer.getUid() == 1000) {
            boolean uidRestricted;
            boolean bl = uidRestricted = FactoryTest.getMode() == 0;
            if (uidRestricted && args.uidSpecified && args.uid < 1000) {
                throw new ZygoteSecurityException("System UID may not launch process with UID < 1000");
            }
        }
        if (!args.uidSpecified) {
            args.uid = peer.getUid();
            args.uidSpecified = true;
        }
        if (!args.gidSpecified) {
            args.gid = peer.getGid();
            args.gidSpecified = true;
        }
    }

    public static void applyDebuggerSystemProperty(Arguments args) {
        if (RoSystemProperties.DEBUGGABLE) {
            args.debugFlags |= 1;
        }
    }

    private static void applyInvokeWithSecurityPolicy(Arguments args, Credentials peer) throws ZygoteSecurityException {
        int peerUid = peer.getUid();
        if (args.invokeWith != null && peerUid != 0 && (args.debugFlags & 1) == 0) {
            throw new ZygoteSecurityException("Peer is permitted to specify anexplicit invoke-with wrapper command only for debuggableapplications.");
        }
    }

    public static void applyInvokeWithSystemProperty(Arguments args) {
        if (args.invokeWith == null && args.niceName != null) {
            String property = "wrap." + args.niceName;
            args.invokeWith = SystemProperties.get(property);
            if (args.invokeWith != null && args.invokeWith.length() == 0) {
                args.invokeWith = null;
            }
        }
    }

    private Runnable handleChildProc(Arguments parsedArgs, FileDescriptor[] descriptors, FileDescriptor pipeFd) {
        this.closeSocket();
        if (descriptors != null) {
            try {
                Os.dup2(descriptors[0], OsConstants.STDIN_FILENO);
                Os.dup2(descriptors[1], OsConstants.STDOUT_FILENO);
                Os.dup2(descriptors[2], OsConstants.STDERR_FILENO);
                for (FileDescriptor fd : descriptors) {
                    IoUtils.closeQuietly(fd);
                }
            }
            catch (ErrnoException ex) {
                Log.e(TAG, "Error reopening stdio", ex);
            }
        }
        if (parsedArgs.niceName != null) {
            Process.setArgV0(parsedArgs.niceName);
        }
        Trace.traceEnd(64L);
        if (parsedArgs.invokeWith != null) {
            WrapperInit.execApplication(parsedArgs.invokeWith, parsedArgs.niceName, parsedArgs.targetSdkVersion, VMRuntime.getCurrentInstructionSet(), pipeFd, parsedArgs.remainingArgs);
            throw new IllegalStateException("WrapperInit.execApplication unexpectedly returned");
        }
        return ZygoteInit.zygoteInit(parsedArgs.targetSdkVersion, parsedArgs.remainingArgs, null);
    }

    private void handleParentProc(int pid, FileDescriptor[] descriptors, FileDescriptor pipeFd) {
        if (pid > 0) {
            this.setChildPgid(pid);
        }
        if (descriptors != null) {
            for (FileDescriptor fd : descriptors) {
                IoUtils.closeQuietly(fd);
            }
        }
        boolean usingWrapper = false;
        if (pipeFd != null && pid > 0) {
            int innerPid = -1;
            try {
                int BYTES_REQUIRED = 4;
                StructPollfd[] fds = new StructPollfd[]{new StructPollfd()};
                byte[] data = new byte[4];
                int remainingSleepTime = 30000;
                int dataIndex = 0;
                long startTime = System.nanoTime();
                while (dataIndex < data.length && remainingSleepTime > 0) {
                    fds[0].fd = pipeFd;
                    fds[0].events = (short)OsConstants.POLLIN;
                    fds[0].revents = 0;
                    fds[0].userData = null;
                    int res = Os.poll(fds, remainingSleepTime);
                    long endTime = System.nanoTime();
                    int elapsedTimeMs = (int)((endTime - startTime) / 1000000L);
                    remainingSleepTime = 30000 - elapsedTimeMs;
                    if (res > 0) {
                        if ((fds[0].revents & OsConstants.POLLIN) == 0) break;
                        int readBytes = Os.read(pipeFd, data, dataIndex, 1);
                        if (readBytes < 0) {
                            throw new RuntimeException("Some error");
                        }
                        dataIndex += readBytes;
                        continue;
                    }
                    if (res != 0) continue;
                    Log.w(TAG, "Timed out waiting for child.");
                }
                if (dataIndex == data.length) {
                    DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
                    innerPid = is.readInt();
                }
                if (innerPid == -1) {
                    Log.w(TAG, "Error reading pid from wrapped process, child may have died");
                }
            }
            catch (Exception ex) {
                Log.w(TAG, "Error reading pid from wrapped process, child may have died", ex);
            }
            if (innerPid > 0) {
                int parentPid = innerPid;
                while (parentPid > 0 && parentPid != pid) {
                    parentPid = Process.getParentPid(parentPid);
                }
                if (parentPid > 0) {
                    Log.i(TAG, "Wrapped process has pid " + innerPid);
                    pid = innerPid;
                    usingWrapper = true;
                } else {
                    Log.w(TAG, "Wrapped process reported a pid that is not a child of the process that we forked: childPid=" + pid + " innerPid=" + innerPid);
                }
            }
        }
        try {
            this.mSocketOutStream.writeInt(pid);
            this.mSocketOutStream.writeBoolean(usingWrapper);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error writing to command socket", ex);
        }
    }

    private void setChildPgid(int pid) {
        try {
            Os.setpgid(pid, Os.getpgid(this.peer.getPid()));
        }
        catch (ErrnoException ex) {
            Log.i(TAG, "Zygote: setpgid failed. This is normal if peer is not in our session");
        }
    }

    static class Arguments {
        int uid = 0;
        boolean uidSpecified;
        int gid = 0;
        boolean gidSpecified;
        int[] gids;
        int debugFlags;
        int mountExternal = 0;
        int targetSdkVersion;
        boolean targetSdkVersionSpecified;
        String niceName;
        boolean capabilitiesSpecified;
        long permittedCapabilities;
        long effectiveCapabilities;
        boolean seInfoSpecified;
        String seInfo;
        ArrayList<int[]> rlimits;
        String invokeWith;
        String[] remainingArgs;
        boolean abiListQuery;
        String instructionSet;
        String appDataDir;
        String preloadPackage;
        String preloadPackageLibs;
        String preloadPackageCacheKey;
        boolean preloadDefault;

        Arguments(String[] args) throws IllegalArgumentException {
            this.parseArgs(args);
        }

        private void parseArgs(String[] args) throws IllegalArgumentException {
            int curArg;
            boolean seenRuntimeArgs = false;
            for (curArg = 0; curArg < args.length; ++curArg) {
                String arg = args[curArg];
                if (arg.equals("--")) {
                    ++curArg;
                    break;
                }
                if (arg.startsWith("--setuid=")) {
                    if (this.uidSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.uidSpecified = true;
                    this.uid = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                if (arg.startsWith("--setgid=")) {
                    if (this.gidSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.gidSpecified = true;
                    this.gid = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                if (arg.startsWith("--target-sdk-version=")) {
                    if (this.targetSdkVersionSpecified) {
                        throw new IllegalArgumentException("Duplicate target-sdk-version specified");
                    }
                    this.targetSdkVersionSpecified = true;
                    this.targetSdkVersion = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                if (arg.equals("--enable-jdwp")) {
                    this.debugFlags |= 1;
                    continue;
                }
                if (arg.equals("--enable-safemode")) {
                    this.debugFlags |= 8;
                    continue;
                }
                if (arg.equals("--enable-checkjni")) {
                    this.debugFlags |= 2;
                    continue;
                }
                if (arg.equals("--generate-debug-info")) {
                    this.debugFlags |= 0x20;
                    continue;
                }
                if (arg.equals("--always-jit")) {
                    this.debugFlags |= 0x40;
                    continue;
                }
                if (arg.equals("--native-debuggable")) {
                    this.debugFlags |= 0x80;
                    continue;
                }
                if (arg.equals("--java-debuggable")) {
                    this.debugFlags |= 0x100;
                    continue;
                }
                if (arg.equals("--enable-jni-logging")) {
                    this.debugFlags |= 0x10;
                    continue;
                }
                if (arg.equals("--enable-assert")) {
                    this.debugFlags |= 4;
                    continue;
                }
                if (arg.equals("--runtime-args")) {
                    seenRuntimeArgs = true;
                    continue;
                }
                if (arg.startsWith("--seinfo=")) {
                    if (this.seInfoSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.seInfoSpecified = true;
                    this.seInfo = arg.substring(arg.indexOf(61) + 1);
                    continue;
                }
                if (arg.startsWith("--capabilities=")) {
                    if (this.capabilitiesSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.capabilitiesSpecified = true;
                    String capString = arg.substring(arg.indexOf(61) + 1);
                    String[] capStrings = capString.split(",", 2);
                    if (capStrings.length == 1) {
                        this.permittedCapabilities = this.effectiveCapabilities = Long.decode(capStrings[0]).longValue();
                        continue;
                    }
                    this.permittedCapabilities = Long.decode(capStrings[0]);
                    this.effectiveCapabilities = Long.decode(capStrings[1]);
                    continue;
                }
                if (arg.startsWith("--rlimit=")) {
                    String[] limitStrings = arg.substring(arg.indexOf(61) + 1).split(",");
                    if (limitStrings.length != 3) {
                        throw new IllegalArgumentException("--rlimit= should have 3 comma-delimited ints");
                    }
                    int[] rlimitTuple = new int[limitStrings.length];
                    for (int i = 0; i < limitStrings.length; ++i) {
                        rlimitTuple[i] = Integer.parseInt(limitStrings[i]);
                    }
                    if (this.rlimits == null) {
                        this.rlimits = new ArrayList();
                    }
                    this.rlimits.add(rlimitTuple);
                    continue;
                }
                if (arg.startsWith("--setgroups=")) {
                    if (this.gids != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    String[] params = arg.substring(arg.indexOf(61) + 1).split(",");
                    this.gids = new int[params.length];
                    for (int i = params.length - 1; i >= 0; --i) {
                        this.gids[i] = Integer.parseInt(params[i]);
                    }
                    continue;
                }
                if (arg.equals("--invoke-with")) {
                    if (this.invokeWith != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    try {
                        this.invokeWith = args[++curArg];
                        continue;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new IllegalArgumentException("--invoke-with requires argument");
                    }
                }
                if (arg.startsWith("--nice-name=")) {
                    if (this.niceName != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.niceName = arg.substring(arg.indexOf(61) + 1);
                    continue;
                }
                if (arg.equals("--mount-external-default")) {
                    this.mountExternal = 1;
                    continue;
                }
                if (arg.equals("--mount-external-read")) {
                    this.mountExternal = 2;
                    continue;
                }
                if (arg.equals("--mount-external-write")) {
                    this.mountExternal = 3;
                    continue;
                }
                if (arg.equals("--query-abi-list")) {
                    this.abiListQuery = true;
                    continue;
                }
                if (arg.startsWith("--instruction-set=")) {
                    this.instructionSet = arg.substring(arg.indexOf(61) + 1);
                    continue;
                }
                if (arg.startsWith("--app-data-dir=")) {
                    this.appDataDir = arg.substring(arg.indexOf(61) + 1);
                    continue;
                }
                if (arg.equals("--preload-package")) {
                    this.preloadPackage = args[++curArg];
                    this.preloadPackageLibs = args[++curArg];
                    this.preloadPackageCacheKey = args[++curArg];
                    continue;
                }
                if (!arg.equals("--preload-default")) break;
                this.preloadDefault = true;
            }
            if (this.abiListQuery) {
                if (args.length - curArg > 0) {
                    throw new IllegalArgumentException("Unexpected arguments after --query-abi-list.");
                }
            } else if (this.preloadPackage != null) {
                if (args.length - curArg > 0) {
                    throw new IllegalArgumentException("Unexpected arguments after --preload-package.");
                }
            } else if (!this.preloadDefault) {
                if (!seenRuntimeArgs) {
                    throw new IllegalArgumentException("Unexpected argument : " + args[curArg]);
                }
                this.remainingArgs = new String[args.length - curArg];
                System.arraycopy(args, curArg, this.remainingArgs, 0, this.remainingArgs.length);
            }
        }
    }
}

