/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManager;
import android.service.chooser.ChooserTarget;
import android.service.chooser.IChooserTargetResult;
import android.service.chooser.IChooserTargetService;
import android.text.TextUtils;
import android.util.FloatProperty;
import android.util.Log;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.Space;
import com.android.internal.app.IntentForwarderActivity;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverListController;
import com.android.internal.app.ResolverTargetActionsDialogFragment;
import com.android.internal.logging.MetricsLogger;
import com.google.android.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ChooserActivity
extends ResolverActivity {
    private static final String TAG = "ChooserActivity";
    public static final String EXTRA_PRIVATE_RETAIN_IN_ON_STOP = "com.android.internal.app.ChooserActivity.EXTRA_PRIVATE_RETAIN_IN_ON_STOP";
    private static final boolean DEBUG = false;
    private static final int QUERY_TARGET_SERVICE_LIMIT = 5;
    private static final int WATCHDOG_TIMEOUT_MILLIS = 2000;
    private Bundle mReplacementExtras;
    private IntentSender mChosenComponentSender;
    private IntentSender mRefinementIntentSender;
    private RefinementResultReceiver mRefinementResultReceiver;
    private ChooserTarget[] mCallerChooserTargets;
    private ComponentName[] mFilteredComponentNames;
    private Intent mReferrerFillInIntent;
    private long mChooserShownTime;
    protected boolean mIsSuccessfullySelected;
    private ChooserListAdapter mChooserListAdapter;
    private ChooserRowAdapter mChooserRowAdapter;
    private SharedPreferences mPinnedSharedPrefs;
    private static final float PINNED_TARGET_SCORE_BOOST = 1000.0f;
    private static final float CALLER_TARGET_SCORE_BOOST = 900.0f;
    private static final String PINNED_SHARED_PREFS_NAME = "chooser_pin_settings";
    private static final String TARGET_DETAILS_FRAGMENT_TAG = "targetDetailsFragment";
    private final List<ChooserTargetServiceConnection> mServiceConnections = new ArrayList<ChooserTargetServiceConnection>();
    private static final int CHOOSER_TARGET_SERVICE_RESULT = 1;
    private static final int CHOOSER_TARGET_SERVICE_WATCHDOG_TIMEOUT = 2;
    private final Handler mChooserHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (ChooserActivity.this.isDestroyed()) break;
                    ServiceResultInfo sri = (ServiceResultInfo)msg.obj;
                    if (!ChooserActivity.this.mServiceConnections.contains(sri.connection)) {
                        Log.w(ChooserActivity.TAG, "ChooserTargetServiceConnection " + sri.connection + " returned after being removed from active connections." + " Have you considered returning results faster?");
                        break;
                    }
                    if (sri.resultTargets != null) {
                        ChooserActivity.this.mChooserListAdapter.addServiceResults(sri.originalTarget, sri.resultTargets);
                    }
                    ChooserActivity.this.unbindService(sri.connection);
                    sri.connection.destroy();
                    ChooserActivity.this.mServiceConnections.remove(sri.connection);
                    if (!ChooserActivity.this.mServiceConnections.isEmpty()) break;
                    ChooserActivity.this.mChooserHandler.removeMessages(2);
                    ChooserActivity.this.sendVoiceChoicesIfNeeded();
                    ChooserActivity.this.mChooserListAdapter.setShowServiceTargets(true);
                    break;
                }
                case 2: {
                    ChooserActivity.this.unbindRemainingServices();
                    ChooserActivity.this.sendVoiceChoicesIfNeeded();
                    ChooserActivity.this.mChooserListAdapter.setShowServiceTargets(true);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Parcelable[] targetsParcelable;
        long intentReceivedTime = System.currentTimeMillis();
        this.mIsSuccessfullySelected = false;
        Intent intent = this.getIntent();
        Object targetParcelable = intent.getParcelableExtra("android.intent.extra.INTENT");
        if (!(targetParcelable instanceof Intent)) {
            Log.w(TAG, "Target is not an intent: " + targetParcelable);
            this.finish();
            super.onCreate(null);
            return;
        }
        Intent target = (Intent)targetParcelable;
        if (target != null) {
            this.modifyTargetIntent(target);
        }
        if ((targetsParcelable = intent.getParcelableArrayExtra("android.intent.extra.ALTERNATE_INTENTS")) != null) {
            boolean offset = target == null;
            Intent[] additionalTargets = new Intent[offset ? targetsParcelable.length - 1 : targetsParcelable.length];
            for (int i = 0; i < targetsParcelable.length; ++i) {
                if (!(targetsParcelable[i] instanceof Intent)) {
                    Log.w(TAG, "EXTRA_ALTERNATE_INTENTS array entry #" + i + " is not an Intent: " + targetsParcelable[i]);
                    this.finish();
                    super.onCreate(null);
                    return;
                }
                Intent additionalTarget = (Intent)targetsParcelable[i];
                if (i == 0 && target == null) {
                    target = additionalTarget;
                    this.modifyTargetIntent(target);
                    continue;
                }
                additionalTargets[offset ? i - 1 : i] = additionalTarget;
                this.modifyTargetIntent(additionalTarget);
            }
            this.setAdditionalTargets(additionalTargets);
        }
        this.mReplacementExtras = intent.getBundleExtra("android.intent.extra.REPLACEMENT_EXTRAS");
        CharSequence title = intent.getCharSequenceExtra("android.intent.extra.TITLE");
        int defaultTitleRes = 0;
        if (title == null) {
            defaultTitleRes = 17039609;
        }
        Parcelable[] pa = intent.getParcelableArrayExtra("android.intent.extra.INITIAL_INTENTS");
        Intent[] initialIntents = null;
        if (pa != null) {
            initialIntents = new Intent[pa.length];
            for (int i = 0; i < pa.length; ++i) {
                if (!(pa[i] instanceof Intent)) {
                    Log.w(TAG, "Initial intent #" + i + " not an Intent: " + pa[i]);
                    this.finish();
                    super.onCreate(null);
                    return;
                }
                Intent in = (Intent)pa[i];
                this.modifyTargetIntent(in);
                initialIntents[i] = in;
            }
        }
        this.mReferrerFillInIntent = new Intent().putExtra("android.intent.extra.REFERRER", this.getReferrer());
        this.mChosenComponentSender = (IntentSender)intent.getParcelableExtra("android.intent.extra.CHOSEN_COMPONENT_INTENT_SENDER");
        this.mRefinementIntentSender = (IntentSender)intent.getParcelableExtra("android.intent.extra.CHOOSER_REFINEMENT_INTENT_SENDER");
        this.setSafeForwardingMode(true);
        pa = intent.getParcelableArrayExtra("android.intent.extra.EXCLUDE_COMPONENTS");
        if (pa != null) {
            ComponentName[] names = new ComponentName[pa.length];
            for (int i = 0; i < pa.length; ++i) {
                if (!(pa[i] instanceof ComponentName)) {
                    Log.w(TAG, "Filtered component #" + i + " not a ComponentName: " + pa[i]);
                    names = null;
                    break;
                }
                names[i] = (ComponentName)pa[i];
            }
            this.mFilteredComponentNames = names;
        }
        if ((pa = intent.getParcelableArrayExtra("android.intent.extra.CHOOSER_TARGETS")) != null) {
            ChooserTarget[] targets = new ChooserTarget[pa.length];
            for (int i = 0; i < pa.length; ++i) {
                if (!(pa[i] instanceof ChooserTarget)) {
                    Log.w(TAG, "Chooser target #" + i + " not a ChooserTarget: " + pa[i]);
                    targets = null;
                    break;
                }
                targets[i] = (ChooserTarget)pa[i];
            }
            this.mCallerChooserTargets = targets;
        }
        this.mPinnedSharedPrefs = ChooserActivity.getPinnedSharedPrefs(this);
        this.setRetainInOnStop(intent.getBooleanExtra(EXTRA_PRIVATE_RETAIN_IN_ON_STOP, false));
        super.onCreate(savedInstanceState, target, title, defaultTitleRes, initialIntents, null, false);
        MetricsLogger.action(this, 214);
        this.mChooserShownTime = System.currentTimeMillis();
        long systemCost = this.mChooserShownTime - intentReceivedTime;
        MetricsLogger.histogram(null, "system_cost_for_smart_sharing", (int)systemCost);
    }

    static SharedPreferences getPinnedSharedPrefs(Context context) {
        File prefsFile = new File(new File(Environment.getDataUserCePackageDirectory(StorageManager.UUID_PRIVATE_INTERNAL, context.getUserId(), context.getPackageName()), "shared_prefs"), "chooser_pin_settings.xml");
        return context.getSharedPreferences(prefsFile, 0);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.mRefinementResultReceiver != null) {
            this.mRefinementResultReceiver.destroy();
            this.mRefinementResultReceiver = null;
        }
        this.unbindRemainingServices();
        this.mChooserHandler.removeMessages(1);
    }

    @Override
    public Intent getReplacementIntent(ActivityInfo aInfo, Intent defIntent) {
        Bundle replExtras;
        Intent result = defIntent;
        if (this.mReplacementExtras != null && (replExtras = this.mReplacementExtras.getBundle(aInfo.packageName)) != null) {
            result = new Intent(defIntent);
            result.putExtras(replExtras);
        }
        if (aInfo.name.equals(IntentForwarderActivity.FORWARD_INTENT_TO_PARENT) || aInfo.name.equals(IntentForwarderActivity.FORWARD_INTENT_TO_MANAGED_PROFILE)) {
            result = Intent.createChooser(result, this.getIntent().getCharSequenceExtra("android.intent.extra.TITLE"));
            result.putExtra("android.intent.extra.AUTO_LAUNCH_SINGLE_CHOICE", false);
        }
        return result;
    }

    @Override
    public void onActivityStarted(ResolverActivity.TargetInfo cti) {
        ComponentName target;
        if (this.mChosenComponentSender != null && (target = cti.getResolvedComponentName()) != null) {
            Intent fillIn = new Intent().putExtra("android.intent.extra.CHOSEN_COMPONENT", target);
            try {
                this.mChosenComponentSender.sendIntent(this, -1, fillIn, null, null);
            }
            catch (IntentSender.SendIntentException e) {
                Slog.e(TAG, "Unable to launch supplied IntentSender to report the chosen component: " + e);
            }
        }
    }

    @Override
    public void onPrepareAdapterView(AbsListView adapterView, ResolverActivity.ResolveListAdapter adapter) {
        ListView listView = adapterView instanceof ListView ? (ListView)adapterView : null;
        this.mChooserListAdapter = (ChooserListAdapter)adapter;
        if (this.mCallerChooserTargets != null && this.mCallerChooserTargets.length > 0) {
            this.mChooserListAdapter.addServiceResults(null, Lists.newArrayList(this.mCallerChooserTargets));
        }
        this.mChooserRowAdapter = new ChooserRowAdapter(this.mChooserListAdapter);
        this.mChooserRowAdapter.registerDataSetObserver(new OffsetDataSetObserver(adapterView));
        adapterView.setAdapter(this.mChooserRowAdapter);
        if (listView != null) {
            listView.setItemsCanFocus(true);
        }
    }

    @Override
    public int getLayoutResource() {
        return 17367111;
    }

    @Override
    public boolean shouldGetActivityMetadata() {
        return true;
    }

    @Override
    public boolean shouldAutoLaunchSingleChoice(ResolverActivity.TargetInfo target) {
        return this.getIntent().getBooleanExtra("android.intent.extra.AUTO_LAUNCH_SINGLE_CHOICE", super.shouldAutoLaunchSingleChoice(target));
    }

    @Override
    public void showTargetDetails(ResolveInfo ri) {
        ComponentName name = ri.activityInfo.getComponentName();
        boolean pinned = this.mPinnedSharedPrefs.getBoolean(name.flattenToString(), false);
        ResolverTargetActionsDialogFragment f = new ResolverTargetActionsDialogFragment(ri.loadLabel(this.getPackageManager()), name, pinned);
        f.show(this.getFragmentManager(), TARGET_DETAILS_FRAGMENT_TAG);
    }

    private void modifyTargetIntent(Intent in) {
        String action = in.getAction();
        if ("android.intent.action.SEND".equals(action) || "android.intent.action.SEND_MULTIPLE".equals(action)) {
            in.addFlags(0x8080000);
        }
    }

    @Override
    protected boolean onTargetSelected(ResolverActivity.TargetInfo target, boolean alwaysCheck) {
        if (this.mRefinementIntentSender != null) {
            Intent fillIn = new Intent();
            List<Intent> sourceIntents = target.getAllSourceIntents();
            if (!sourceIntents.isEmpty()) {
                fillIn.putExtra("android.intent.extra.INTENT", sourceIntents.get(0));
                if (sourceIntents.size() > 1) {
                    Parcelable[] alts = new Intent[sourceIntents.size() - 1];
                    int N = sourceIntents.size();
                    for (int i = 1; i < N; ++i) {
                        alts[i - 1] = sourceIntents.get(i);
                    }
                    fillIn.putExtra("android.intent.extra.ALTERNATE_INTENTS", alts);
                }
                if (this.mRefinementResultReceiver != null) {
                    this.mRefinementResultReceiver.destroy();
                }
                this.mRefinementResultReceiver = new RefinementResultReceiver(this, target, null);
                fillIn.putExtra("android.intent.extra.RESULT_RECEIVER", this.mRefinementResultReceiver);
                try {
                    this.mRefinementIntentSender.sendIntent(this, 0, fillIn, null, null);
                    return false;
                }
                catch (IntentSender.SendIntentException e) {
                    Log.e(TAG, "Refinement IntentSender failed to send", e);
                }
            }
        }
        this.updateModelAndChooserCounts(target);
        return super.onTargetSelected(target, alwaysCheck);
    }

    @Override
    public void startSelected(int which, boolean always, boolean filtered) {
        long selectionCost = System.currentTimeMillis() - this.mChooserShownTime;
        super.startSelected(which, always, filtered);
        if (this.mChooserListAdapter != null) {
            int cat = 0;
            int value = which;
            switch (this.mChooserListAdapter.getPositionTargetType(which)) {
                case 0: {
                    cat = 215;
                    break;
                }
                case 1: {
                    cat = 216;
                    value -= this.mChooserListAdapter.getCallerTargetCount();
                    break;
                }
                case 2: {
                    cat = 217;
                    value -= this.mChooserListAdapter.getCallerTargetCount() + this.mChooserListAdapter.getServiceTargetCount();
                }
            }
            if (cat != 0) {
                MetricsLogger.action((Context)this, cat, value);
            }
            if (this.mIsSuccessfullySelected) {
                MetricsLogger.histogram(null, "user_selection_cost_for_smart_sharing", (int)selectionCost);
                MetricsLogger.histogram(null, "app_position_for_smart_sharing", value);
            }
        }
    }

    void queryTargetServices(ChooserListAdapter adapter) {
        PackageManager pm = this.getPackageManager();
        int targetsToQuery = 0;
        int N = adapter.getDisplayResolveInfoCount();
        for (int i = 0; i < N; ++i) {
            String serviceName;
            ResolverActivity.DisplayResolveInfo dri = adapter.getDisplayResolveInfo(i);
            if (adapter.getScore(dri) == 0.0f) continue;
            ActivityInfo ai = dri.getResolveInfo().activityInfo;
            Bundle md = ai.metaData;
            String string2 = serviceName = md != null ? this.convertServiceName(ai.packageName, md.getString("android.service.chooser.chooser_target_service")) : null;
            if (serviceName != null) {
                Intent serviceIntent;
                block8: {
                    ComponentName serviceComponent = new ComponentName(ai.packageName, serviceName);
                    serviceIntent = new Intent("android.service.chooser.ChooserTargetService").setComponent(serviceComponent);
                    try {
                        String perm = pm.getServiceInfo((ComponentName)serviceComponent, (int)0).permission;
                        if (!"android.permission.BIND_CHOOSER_TARGET_SERVICE".equals(perm)) {
                            Log.w(TAG, "ChooserTargetService " + serviceComponent + " does not require" + " permission " + "android.permission.BIND_CHOOSER_TARGET_SERVICE" + " - this service will not be queried for ChooserTargets." + " add android:permission=\"" + "android.permission.BIND_CHOOSER_TARGET_SERVICE" + "\"" + " to the <service> tag for " + serviceComponent + " in the manifest.");
                        }
                        break block8;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Log.e(TAG, "Could not look up service " + serviceComponent + "; component name not found");
                    }
                    continue;
                }
                ChooserTargetServiceConnection conn = new ChooserTargetServiceConnection(this, dri);
                if (this.bindServiceAsUser(serviceIntent, conn, 5, Process.myUserHandle())) {
                    this.mServiceConnections.add(conn);
                    ++targetsToQuery;
                }
            }
            if (targetsToQuery >= 5) break;
        }
        if (!this.mServiceConnections.isEmpty()) {
            this.mChooserHandler.sendEmptyMessageDelayed(2, 2000L);
        } else {
            this.sendVoiceChoicesIfNeeded();
        }
    }

    private String convertServiceName(String packageName, String serviceName) {
        if (TextUtils.isEmpty(serviceName)) {
            return null;
        }
        String fullName = serviceName.startsWith(".") ? packageName + serviceName : (serviceName.indexOf(46) >= 0 ? serviceName : null);
        return fullName;
    }

    void unbindRemainingServices() {
        int N = this.mServiceConnections.size();
        for (int i = 0; i < N; ++i) {
            ChooserTargetServiceConnection conn = this.mServiceConnections.get(i);
            this.unbindService(conn);
            conn.destroy();
        }
        this.mServiceConnections.clear();
        this.mChooserHandler.removeMessages(2);
    }

    @Override
    public void onSetupVoiceInteraction() {
    }

    void updateModelAndChooserCounts(ResolverActivity.TargetInfo info) {
        if (info != null) {
            ResolveInfo ri = info.getResolveInfo();
            Intent targetIntent = this.getTargetIntent();
            if (ri != null && ri.activityInfo != null && targetIntent != null && this.mAdapter != null) {
                this.mAdapter.updateModel(info.getResolvedComponentName());
                this.mAdapter.updateChooserCounts(ri.activityInfo.packageName, this.getUserId(), targetIntent.getAction());
            }
        }
        this.mIsSuccessfullySelected = true;
    }

    void onRefinementResult(ResolverActivity.TargetInfo selectedTarget, Intent matchingIntent) {
        if (this.mRefinementResultReceiver != null) {
            this.mRefinementResultReceiver.destroy();
            this.mRefinementResultReceiver = null;
        }
        if (selectedTarget == null) {
            Log.e(TAG, "Refinement result intent did not match any known targets; canceling");
        } else if (!this.checkTargetSourceIntent(selectedTarget, matchingIntent)) {
            Log.e(TAG, "onRefinementResult: Selected target " + selectedTarget + " cannot match refined source intent " + matchingIntent);
        } else {
            ResolverActivity.TargetInfo clonedTarget = selectedTarget.cloneFilledIn(matchingIntent, 0);
            if (super.onTargetSelected(clonedTarget, false)) {
                this.updateModelAndChooserCounts(clonedTarget);
                this.finish();
                return;
            }
        }
        this.onRefinementCanceled();
    }

    void onRefinementCanceled() {
        if (this.mRefinementResultReceiver != null) {
            this.mRefinementResultReceiver.destroy();
            this.mRefinementResultReceiver = null;
        }
        this.finish();
    }

    boolean checkTargetSourceIntent(ResolverActivity.TargetInfo target, Intent matchingIntent) {
        List<Intent> targetIntents = target.getAllSourceIntents();
        int N = targetIntents.size();
        for (int i = 0; i < N; ++i) {
            Intent targetIntent = targetIntents.get(i);
            if (!targetIntent.filterEquals(matchingIntent)) continue;
            return true;
        }
        return false;
    }

    void filterServiceTargets(String packageName, List<ChooserTarget> targets) {
        if (targets == null) {
            return;
        }
        PackageManager pm = this.getPackageManager();
        for (int i = targets.size() - 1; i >= 0; --i) {
            boolean remove;
            ChooserTarget target = targets.get(i);
            ComponentName targetName = target.getComponentName();
            if (packageName != null && packageName.equals(targetName.getPackageName())) continue;
            try {
                ActivityInfo ai = pm.getActivityInfo(targetName, 0);
                remove = !ai.exported || ai.permission != null;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(TAG, "Target " + target + " returned by " + packageName + " component not found");
                remove = true;
            }
            if (!remove) continue;
            targets.remove(i);
        }
    }

    @Override
    public ResolverActivity.ResolveListAdapter createAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid, boolean filterLastUsed) {
        ChooserListAdapter adapter = new ChooserListAdapter(context, payloadIntents, initialIntents, rList, launchedFromUid, filterLastUsed, this.createListController());
        return adapter;
    }

    @Override
    protected ResolverListController createListController() {
        return new ChooserListController(this, this.mPm, this.getTargetIntent(), this.getReferrerPackageName(), this.mLaunchedFromUid);
    }

    class OffsetDataSetObserver
    extends DataSetObserver {
        private final AbsListView mListView;
        private int mCachedViewType = -1;
        private View mCachedView;

        public OffsetDataSetObserver(AbsListView listView) {
            this.mListView = listView;
        }

        @Override
        public void onChanged() {
            if (ChooserActivity.this.mResolverDrawerLayout == null) {
                return;
            }
            int chooserTargetRows = ChooserActivity.this.mChooserRowAdapter.getServiceTargetRowCount();
            int offset = 0;
            for (int i = 0; i < chooserTargetRows; ++i) {
                int pos = ChooserActivity.this.mChooserRowAdapter.getCallerTargetRowCount() + i;
                int vt = ChooserActivity.this.mChooserRowAdapter.getItemViewType(pos);
                if (vt != this.mCachedViewType) {
                    this.mCachedView = null;
                }
                View v = ChooserActivity.this.mChooserRowAdapter.getView(pos, this.mCachedView, this.mListView);
                int height = ((RowViewHolder)v.getTag()).measuredRowHeight;
                offset += (int)((float)height * ChooserActivity.this.mChooserRowAdapter.getRowScale(pos));
                if (vt >= 0) {
                    this.mCachedViewType = vt;
                    this.mCachedView = v;
                    continue;
                }
                this.mCachedViewType = -1;
            }
            ChooserActivity.this.mResolverDrawerLayout.setCollapsibleHeightReserved(offset);
        }
    }

    static class RefinementResultReceiver
    extends ResultReceiver {
        private ChooserActivity mChooserActivity;
        private ResolverActivity.TargetInfo mSelectedTarget;

        public RefinementResultReceiver(ChooserActivity host, ResolverActivity.TargetInfo target, Handler handler) {
            super(handler);
            this.mChooserActivity = host;
            this.mSelectedTarget = target;
        }

        @Override
        protected void onReceiveResult(int resultCode, Bundle resultData) {
            if (this.mChooserActivity == null) {
                Log.e(ChooserActivity.TAG, "Destroyed RefinementResultReceiver received a result");
                return;
            }
            if (resultData == null) {
                Log.e(ChooserActivity.TAG, "RefinementResultReceiver received null resultData");
                return;
            }
            switch (resultCode) {
                case 0: {
                    this.mChooserActivity.onRefinementCanceled();
                    break;
                }
                case -1: {
                    Object intentParcelable = resultData.getParcelable("android.intent.extra.INTENT");
                    if (intentParcelable instanceof Intent) {
                        this.mChooserActivity.onRefinementResult(this.mSelectedTarget, (Intent)intentParcelable);
                        break;
                    }
                    Log.e(ChooserActivity.TAG, "RefinementResultReceiver received RESULT_OK but no Intent in resultData with key Intent.EXTRA_INTENT");
                    break;
                }
                default: {
                    Log.w(ChooserActivity.TAG, "Unknown result code " + resultCode + " sent to RefinementResultReceiver");
                }
            }
        }

        public void destroy() {
            this.mChooserActivity = null;
            this.mSelectedTarget = null;
        }
    }

    static class ServiceResultInfo {
        public final ResolverActivity.DisplayResolveInfo originalTarget;
        public final List<ChooserTarget> resultTargets;
        public final ChooserTargetServiceConnection connection;

        public ServiceResultInfo(ResolverActivity.DisplayResolveInfo ot, List<ChooserTarget> rt, ChooserTargetServiceConnection c) {
            this.originalTarget = ot;
            this.resultTargets = rt;
            this.connection = c;
        }
    }

    static class ChooserTargetServiceConnection
    implements ServiceConnection {
        private ResolverActivity.DisplayResolveInfo mOriginalTarget;
        private ComponentName mConnectedComponent;
        private ChooserActivity mChooserActivity;
        private final Object mLock = new Object();
        private final IChooserTargetResult mChooserTargetResult = new IChooserTargetResult.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendResult(List<ChooserTarget> targets) throws RemoteException {
                Object object = mLock;
                synchronized (object) {
                    if (mChooserActivity == null) {
                        Log.e(ChooserActivity.TAG, "destroyed ChooserTargetServiceConnection received result from " + mConnectedComponent + "; ignoring...");
                        return;
                    }
                    mChooserActivity.filterServiceTargets(((ChooserTargetServiceConnection)this).mOriginalTarget.getResolveInfo().activityInfo.packageName, targets);
                    Message msg = Message.obtain();
                    msg.what = 1;
                    msg.obj = new ServiceResultInfo(mOriginalTarget, targets, this);
                    mChooserActivity.mChooserHandler.sendMessage(msg);
                }
            }
        };

        public ChooserTargetServiceConnection(ChooserActivity chooserActivity, ResolverActivity.DisplayResolveInfo dri) {
            this.mChooserActivity = chooserActivity;
            this.mOriginalTarget = dri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mChooserActivity == null) {
                    Log.e(ChooserActivity.TAG, "destroyed ChooserTargetServiceConnection got onServiceConnected");
                    return;
                }
                IChooserTargetService icts = IChooserTargetService.Stub.asInterface(service);
                try {
                    icts.getChooserTargets(this.mOriginalTarget.getResolvedComponentName(), this.mOriginalTarget.getResolveInfo().filter, this.mChooserTargetResult);
                }
                catch (RemoteException e) {
                    Log.e(ChooserActivity.TAG, "Querying ChooserTargetService " + name + " failed.", e);
                    this.mChooserActivity.unbindService(this);
                    this.mChooserActivity.mServiceConnections.remove(this);
                    this.destroy();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mChooserActivity == null) {
                    Log.e(ChooserActivity.TAG, "destroyed ChooserTargetServiceConnection got onServiceDisconnected");
                    return;
                }
                this.mChooserActivity.unbindService(this);
                this.mChooserActivity.mServiceConnections.remove(this);
                if (this.mChooserActivity.mServiceConnections.isEmpty()) {
                    this.mChooserActivity.mChooserHandler.removeMessages(2);
                    this.mChooserActivity.sendVoiceChoicesIfNeeded();
                }
                this.mConnectedComponent = null;
                this.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Object object = this.mLock;
            synchronized (object) {
                this.mChooserActivity = null;
                this.mOriginalTarget = null;
            }
        }

        public String toString() {
            return "ChooserTargetServiceConnection{service=" + this.mConnectedComponent + ", activity=" + (this.mOriginalTarget != null ? this.mOriginalTarget.getResolveInfo().activityInfo.toString() : "<connection destroyed>") + "}";
        }
    }

    static class RowViewHolder {
        final View[] cells;
        final ViewGroup row;
        int measuredRowHeight;
        int[] itemIndices;

        public RowViewHolder(ViewGroup row, int cellCount) {
            this.row = row;
            this.cells = new View[cellCount];
            this.itemIndices = new int[cellCount];
        }

        public void measure() {
            int spec = View.MeasureSpec.makeMeasureSpec(0, 0);
            this.row.measure(spec, spec);
            this.measuredRowHeight = this.row.getMeasuredHeight();
        }
    }

    class ChooserRowAdapter
    extends BaseAdapter {
        private ChooserListAdapter mChooserListAdapter;
        private final LayoutInflater mLayoutInflater;
        private final int mColumnCount = 4;
        private RowScale[] mServiceTargetScale;
        private final Interpolator mInterpolator;
        private int mAnimationCount = 0;

        public ChooserRowAdapter(ChooserListAdapter wrappedAdapter) {
            this.mChooserListAdapter = wrappedAdapter;
            this.mLayoutInflater = LayoutInflater.from(ChooserActivity.this);
            this.mInterpolator = AnimationUtils.loadInterpolator(ChooserActivity.this, 17563653);
            wrappedAdapter.registerDataSetObserver(new DataSetObserver(){

                @Override
                public void onChanged() {
                    super.onChanged();
                    int rcount = ChooserRowAdapter.this.getServiceTargetRowCount();
                    if (ChooserRowAdapter.this.mServiceTargetScale == null || ChooserRowAdapter.this.mServiceTargetScale.length != rcount) {
                        int i;
                        RowScale[] old = ChooserRowAdapter.this.mServiceTargetScale;
                        int oldRCount = old != null ? old.length : 0;
                        ChooserRowAdapter.access$602(ChooserRowAdapter.this, new RowScale[rcount]);
                        if (old != null && rcount > 0) {
                            System.arraycopy(old, 0, ChooserRowAdapter.this.mServiceTargetScale, 0, Math.min(old.length, rcount));
                        }
                        for (i = rcount; i < oldRCount; ++i) {
                            old[i].cancelAnimation();
                        }
                        for (i = oldRCount; i < rcount; ++i) {
                            RowScale rs;
                            ((ChooserRowAdapter)ChooserRowAdapter.this).mServiceTargetScale[i] = rs = new RowScale(ChooserRowAdapter.this, 0.0f, 1.0f).setInterpolator(ChooserRowAdapter.this.mInterpolator);
                        }
                        for (i = oldRCount; i < rcount; ++i) {
                            ChooserRowAdapter.this.mServiceTargetScale[i].startAnimation();
                        }
                    }
                    ChooserRowAdapter.this.notifyDataSetChanged();
                }

                @Override
                public void onInvalidated() {
                    super.onInvalidated();
                    ChooserRowAdapter.this.notifyDataSetInvalidated();
                    if (ChooserRowAdapter.this.mServiceTargetScale != null) {
                        for (RowScale rs : ChooserRowAdapter.this.mServiceTargetScale) {
                            rs.cancelAnimation();
                        }
                    }
                }
            });
        }

        private float getRowScale(int rowPosition) {
            int start = this.getCallerTargetRowCount();
            int end = start + this.getServiceTargetRowCount();
            if (rowPosition >= start && rowPosition < end) {
                return this.mServiceTargetScale[rowPosition - start].get();
            }
            return 1.0f;
        }

        public void onAnimationStart() {
            boolean lock = this.mAnimationCount == 0;
            ++this.mAnimationCount;
            if (lock) {
                ChooserActivity.this.mResolverDrawerLayout.setDismissLocked(true);
            }
        }

        public void onAnimationEnd() {
            --this.mAnimationCount;
            if (this.mAnimationCount == 0) {
                ChooserActivity.this.mResolverDrawerLayout.setDismissLocked(false);
            }
        }

        @Override
        public int getCount() {
            return (int)((double)(this.getCallerTargetRowCount() + this.getServiceTargetRowCount()) + Math.ceil((float)this.mChooserListAdapter.getStandardTargetCount() / 4.0f));
        }

        public int getCallerTargetRowCount() {
            return (int)Math.ceil((float)this.mChooserListAdapter.getCallerTargetCount() / 4.0f);
        }

        public int getServiceTargetRowCount() {
            return (int)Math.ceil((float)this.mChooserListAdapter.getServiceTargetCount() / 4.0f);
        }

        @Override
        public Object getItem(int position) {
            return position;
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            RowViewHolder holder = convertView == null ? this.createViewHolder(parent) : (RowViewHolder)convertView.getTag();
            this.bindViewHolder(position, holder);
            return holder.row;
        }

        RowViewHolder createViewHolder(ViewGroup parent) {
            ViewGroup row = (ViewGroup)this.mLayoutInflater.inflate(17367112, parent, false);
            final RowViewHolder holder = new RowViewHolder(row, 4);
            int spec = View.MeasureSpec.makeMeasureSpec(0, 0);
            for (int i = 0; i < 4; ++i) {
                View v = this.mChooserListAdapter.createView(row);
                final int column = i;
                v.setOnClickListener(new View.OnClickListener(){

                    @Override
                    public void onClick(View v) {
                        ChooserActivity.this.startSelected(holder.itemIndices[column], false, true);
                    }
                });
                v.setOnLongClickListener(new View.OnLongClickListener(){

                    @Override
                    public boolean onLongClick(View v) {
                        ChooserActivity.this.showTargetDetails(ChooserRowAdapter.this.mChooserListAdapter.resolveInfoForPosition(holder.itemIndices[column], true));
                        return true;
                    }
                });
                row.addView(v);
                holder.cells[i] = v;
                ViewGroup.LayoutParams lp = v.getLayoutParams();
                v.measure(spec, spec);
                if (lp == null) {
                    lp = new ViewGroup.LayoutParams(-1, v.getMeasuredHeight());
                    row.setLayoutParams(lp);
                } else {
                    lp.height = v.getMeasuredHeight();
                }
                if (i == 3) continue;
                row.addView((View)new Space(ChooserActivity.this), new LinearLayout.LayoutParams(0, 0, 1.0f));
            }
            holder.measure();
            ViewGroup.LayoutParams lp = row.getLayoutParams();
            if (lp == null) {
                lp = new ViewGroup.LayoutParams(-1, holder.measuredRowHeight);
                row.setLayoutParams(lp);
            } else {
                lp.height = holder.measuredRowHeight;
            }
            row.setTag(holder);
            return holder;
        }

        void bindViewHolder(int rowPosition, RowViewHolder holder) {
            int serviceSpacing;
            int end;
            int start = this.getFirstRowPosition(rowPosition);
            int startType = this.mChooserListAdapter.getPositionTargetType(start);
            for (end = start + 4 - 1; this.mChooserListAdapter.getPositionTargetType(end) != startType && end >= start; --end) {
            }
            if (startType == 1) {
                holder.row.setBackgroundColor(ChooserActivity.this.getColor(17170520));
                int nextStartType = this.mChooserListAdapter.getPositionTargetType(this.getFirstRowPosition(rowPosition + 1));
                serviceSpacing = holder.row.getContext().getResources().getDimensionPixelSize(17104946);
                if (rowPosition == 0 && nextStartType != 1) {
                    this.setVertPadding(holder, 0, 0);
                } else {
                    int top;
                    int n = top = rowPosition == 0 ? serviceSpacing : 0;
                    if (nextStartType != 1) {
                        this.setVertPadding(holder, top, serviceSpacing);
                    } else {
                        this.setVertPadding(holder, top, 0);
                    }
                }
            } else {
                holder.row.setBackgroundColor(0);
                int lastStartType = this.mChooserListAdapter.getPositionTargetType(this.getFirstRowPosition(rowPosition - 1));
                if (lastStartType == 1 || rowPosition == 0) {
                    serviceSpacing = holder.row.getContext().getResources().getDimensionPixelSize(17104946);
                    this.setVertPadding(holder, serviceSpacing, 0);
                } else {
                    this.setVertPadding(holder, 0, 0);
                }
            }
            int oldHeight = holder.row.getLayoutParams().height;
            holder.row.getLayoutParams().height = Math.max(1, (int)((float)holder.measuredRowHeight * this.getRowScale(rowPosition)));
            if (holder.row.getLayoutParams().height != oldHeight) {
                holder.row.requestLayout();
            }
            for (int i = 0; i < 4; ++i) {
                View v = holder.cells[i];
                if (start + i <= end) {
                    v.setVisibility(0);
                    holder.itemIndices[i] = start + i;
                    this.mChooserListAdapter.bindView(holder.itemIndices[i], v);
                    continue;
                }
                v.setVisibility(4);
            }
        }

        private void setVertPadding(RowViewHolder holder, int top, int bottom) {
            holder.row.setPadding(holder.row.getPaddingLeft(), top, holder.row.getPaddingRight(), bottom);
        }

        int getFirstRowPosition(int row) {
            int callerCount = this.mChooserListAdapter.getCallerTargetCount();
            int callerRows = (int)Math.ceil((float)callerCount / 4.0f);
            if (row < callerRows) {
                return row * 4;
            }
            int serviceCount = this.mChooserListAdapter.getServiceTargetCount();
            int serviceRows = (int)Math.ceil((float)serviceCount / 4.0f);
            if (row < callerRows + serviceRows) {
                return callerCount + (row - callerRows) * 4;
            }
            return callerCount + serviceCount + (row - callerRows - serviceRows) * 4;
        }

        static /* synthetic */ RowScale[] access$602(ChooserRowAdapter x0, RowScale[] x1) {
            x0.mServiceTargetScale = x1;
            return x1;
        }
    }

    static class RowScale {
        private static final int DURATION = 400;
        float mScale;
        ChooserRowAdapter mAdapter;
        private final ObjectAnimator mAnimator;
        public static final FloatProperty<RowScale> PROPERTY = new FloatProperty<RowScale>("scale"){

            @Override
            public void setValue(RowScale object, float value) {
                object.mScale = value;
                object.mAdapter.notifyDataSetChanged();
            }

            @Override
            public Float get(RowScale object) {
                return Float.valueOf(object.mScale);
            }
        };

        public RowScale(ChooserRowAdapter adapter, float from, float to) {
            this.mAdapter = adapter;
            this.mScale = from;
            if (from == to) {
                this.mAnimator = null;
                return;
            }
            this.mAnimator = ObjectAnimator.ofFloat(this, PROPERTY, from, to).setDuration(400L);
            this.mAnimator.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationStart(Animator animation) {
                    mAdapter.onAnimationStart();
                }

                @Override
                public void onAnimationEnd(Animator animation) {
                    mAdapter.onAnimationEnd();
                }
            });
        }

        public RowScale setInterpolator(Interpolator interpolator2) {
            if (this.mAnimator != null) {
                this.mAnimator.setInterpolator(interpolator2);
            }
            return this;
        }

        public float get() {
            return this.mScale;
        }

        public void startAnimation() {
            if (this.mAnimator != null) {
                this.mAnimator.start();
            }
        }

        public void cancelAnimation() {
            if (this.mAnimator != null) {
                this.mAnimator.cancel();
            }
        }
    }

    static class BaseChooserTargetComparator
    implements Comparator<ChooserTarget> {
        BaseChooserTargetComparator() {
        }

        @Override
        public int compare(ChooserTarget lhs, ChooserTarget rhs) {
            return (int)Math.signum(rhs.getScore() - lhs.getScore());
        }
    }

    public class ChooserListAdapter
    extends ResolverActivity.ResolveListAdapter {
        public static final int TARGET_BAD = -1;
        public static final int TARGET_CALLER = 0;
        public static final int TARGET_SERVICE = 1;
        public static final int TARGET_STANDARD = 2;
        private static final int MAX_SERVICE_TARGETS = 8;
        private static final int MAX_TARGETS_PER_SERVICE = 4;
        private final List<ChooserTargetInfo> mServiceTargets;
        private final List<ResolverActivity.TargetInfo> mCallerTargets;
        private boolean mShowServiceTargets;
        private float mLateFee;
        private final BaseChooserTargetComparator mBaseTargetComparator;

        public ChooserListAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid, boolean filterLastUsed, ResolverListController resolverListController) {
            super(context, payloadIntents, null, rList, launchedFromUid, filterLastUsed, resolverListController);
            this.mServiceTargets = new ArrayList<ChooserTargetInfo>();
            this.mCallerTargets = new ArrayList<ResolverActivity.TargetInfo>();
            this.mLateFee = 1.0f;
            this.mBaseTargetComparator = new BaseChooserTargetComparator();
            if (initialIntents != null) {
                PackageManager pm = ChooserActivity.this.getPackageManager();
                for (int i = 0; i < initialIntents.length; ++i) {
                    Intent ii = initialIntents[i];
                    if (ii == null) continue;
                    ResolveInfo ri = null;
                    ActivityInfo ai = null;
                    ComponentName cn = ii.getComponent();
                    if (cn != null) {
                        try {
                            ai = pm.getActivityInfo(ii.getComponent(), 0);
                            ri = new ResolveInfo();
                            ri.activityInfo = ai;
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (ai == null) {
                        ri = pm.resolveActivity(ii, 65536);
                        ActivityInfo activityInfo = ai = ri != null ? ri.activityInfo : null;
                    }
                    if (ai == null) {
                        Log.w(ChooserActivity.TAG, "No activity found for " + ii);
                        continue;
                    }
                    UserManager userManager = (UserManager)ChooserActivity.this.getSystemService("user");
                    if (ii instanceof LabeledIntent) {
                        LabeledIntent li = (LabeledIntent)ii;
                        ri.resolvePackageName = li.getSourcePackage();
                        ri.labelRes = li.getLabelResource();
                        ri.nonLocalizedLabel = li.getNonLocalizedLabel();
                        ri.iconResourceId = ri.icon = li.getIconResource();
                    }
                    if (userManager.isManagedProfile()) {
                        ri.noResourceId = true;
                        ri.icon = 0;
                    }
                    this.mCallerTargets.add(new ResolverActivity.DisplayResolveInfo(ii, ri, ri.loadLabel(pm), null, ii));
                }
            }
        }

        @Override
        public boolean showsExtendedInfo(ResolverActivity.TargetInfo info) {
            return false;
        }

        @Override
        public boolean isComponentPinned(ComponentName name) {
            return ChooserActivity.this.mPinnedSharedPrefs.getBoolean(name.flattenToString(), false);
        }

        @Override
        public View onCreateView(ViewGroup parent) {
            return this.mInflater.inflate(17367238, parent, false);
        }

        @Override
        public void onListRebuilt() {
            if (this.mServiceTargets != null) {
                this.pruneServiceTargets();
            }
            ChooserActivity.this.queryTargetServices(this);
        }

        @Override
        public boolean shouldGetResolvedFilter() {
            return true;
        }

        @Override
        public int getCount() {
            return super.getCount() + this.getServiceTargetCount() + this.getCallerTargetCount();
        }

        @Override
        public int getUnfilteredCount() {
            return super.getUnfilteredCount() + this.getServiceTargetCount() + this.getCallerTargetCount();
        }

        public int getCallerTargetCount() {
            return this.mCallerTargets.size();
        }

        public int getServiceTargetCount() {
            if (!this.mShowServiceTargets) {
                return 0;
            }
            return Math.min(this.mServiceTargets.size(), 8);
        }

        public int getStandardTargetCount() {
            return super.getCount();
        }

        public int getPositionTargetType(int position) {
            int offset = 0;
            int callerTargetCount = this.getCallerTargetCount();
            if (position < callerTargetCount) {
                return 0;
            }
            int serviceTargetCount = this.getServiceTargetCount();
            if (position - (offset += callerTargetCount) < serviceTargetCount) {
                return 1;
            }
            int standardTargetCount = super.getCount();
            if (position - (offset += serviceTargetCount) < standardTargetCount) {
                return 2;
            }
            return -1;
        }

        @Override
        public ResolverActivity.TargetInfo getItem(int position) {
            return this.targetInfoForPosition(position, true);
        }

        @Override
        public ResolverActivity.TargetInfo targetInfoForPosition(int position, boolean filtered) {
            int offset = 0;
            int callerTargetCount = this.getCallerTargetCount();
            if (position < callerTargetCount) {
                return this.mCallerTargets.get(position);
            }
            int serviceTargetCount = this.getServiceTargetCount();
            if (position - (offset += callerTargetCount) < serviceTargetCount) {
                return this.mServiceTargets.get(position - offset);
            }
            return filtered ? super.getItem(position - offset) : this.getDisplayInfoAt(position - (offset += serviceTargetCount));
        }

        public void addServiceResults(ResolverActivity.DisplayResolveInfo origTarget, List<ChooserTarget> targets) {
            float parentScore = this.getScore(origTarget);
            Collections.sort(targets, this.mBaseTargetComparator);
            float lastScore = 0.0f;
            int N = Math.min(targets.size(), 4);
            for (int i = 0; i < N; ++i) {
                ChooserTarget target = targets.get(i);
                float targetScore = target.getScore();
                targetScore *= parentScore;
                targetScore *= this.mLateFee;
                if (i > 0 && targetScore >= lastScore) {
                    targetScore = lastScore * 0.95f;
                }
                this.insertServiceTarget(new ChooserTargetInfo(origTarget, target, targetScore));
                lastScore = targetScore;
            }
            this.mLateFee *= 0.95f;
            this.notifyDataSetChanged();
        }

        public void setShowServiceTargets(boolean show) {
            if (show != this.mShowServiceTargets) {
                this.mShowServiceTargets = show;
                this.notifyDataSetChanged();
            }
        }

        private void insertServiceTarget(ChooserTargetInfo chooserTargetInfo) {
            float newScore = chooserTargetInfo.getModifiedScore();
            int N = this.mServiceTargets.size();
            for (int i = 0; i < N; ++i) {
                ChooserTargetInfo serviceTarget = this.mServiceTargets.get(i);
                if (!(newScore > serviceTarget.getModifiedScore())) continue;
                this.mServiceTargets.add(i, chooserTargetInfo);
                return;
            }
            this.mServiceTargets.add(chooserTargetInfo);
        }

        private void pruneServiceTargets() {
            for (int i = this.mServiceTargets.size() - 1; i >= 0; --i) {
                ChooserTargetInfo cti = this.mServiceTargets.get(i);
                if (this.hasResolvedTarget(cti.getResolveInfo())) continue;
                this.mServiceTargets.remove(i);
            }
        }
    }

    final class ChooserTargetInfo
    implements ResolverActivity.TargetInfo {
        private final ResolverActivity.DisplayResolveInfo mSourceInfo;
        private final ResolveInfo mBackupResolveInfo;
        private final ChooserTarget mChooserTarget;
        private Drawable mBadgeIcon = null;
        private CharSequence mBadgeContentDescription;
        private Drawable mDisplayIcon;
        private final Intent mFillInIntent;
        private final int mFillInFlags;
        private final float mModifiedScore;

        public ChooserTargetInfo(ResolverActivity.DisplayResolveInfo sourceInfo, ChooserTarget chooserTarget, float modifiedScore) {
            Icon icon;
            ActivityInfo ai;
            ResolveInfo ri;
            this.mSourceInfo = sourceInfo;
            this.mChooserTarget = chooserTarget;
            this.mModifiedScore = modifiedScore;
            if (sourceInfo != null && (ri = sourceInfo.getResolveInfo()) != null && (ai = ri.activityInfo) != null && ai.applicationInfo != null) {
                PackageManager pm = ChooserActivity.this.getPackageManager();
                this.mBadgeIcon = pm.getApplicationIcon(ai.applicationInfo);
                this.mBadgeContentDescription = pm.getApplicationLabel(ai.applicationInfo);
            }
            this.mDisplayIcon = (icon = chooserTarget.getIcon()) != null ? icon.loadDrawable(ChooserActivity.this) : null;
            this.mBackupResolveInfo = sourceInfo != null ? null : ChooserActivity.this.getPackageManager().resolveActivity(this.getResolvedIntent(), 0);
            this.mFillInIntent = null;
            this.mFillInFlags = 0;
        }

        private ChooserTargetInfo(ChooserTargetInfo other, Intent fillInIntent, int flags) {
            this.mSourceInfo = other.mSourceInfo;
            this.mBackupResolveInfo = other.mBackupResolveInfo;
            this.mChooserTarget = other.mChooserTarget;
            this.mBadgeIcon = other.mBadgeIcon;
            this.mBadgeContentDescription = other.mBadgeContentDescription;
            this.mDisplayIcon = other.mDisplayIcon;
            this.mFillInIntent = fillInIntent;
            this.mFillInFlags = flags;
            this.mModifiedScore = other.mModifiedScore;
        }

        public float getModifiedScore() {
            return this.mModifiedScore;
        }

        @Override
        public Intent getResolvedIntent() {
            if (this.mSourceInfo != null) {
                return this.mSourceInfo.getResolvedIntent();
            }
            Intent targetIntent = new Intent(ChooserActivity.this.getTargetIntent());
            targetIntent.setComponent(this.mChooserTarget.getComponentName());
            targetIntent.putExtras(this.mChooserTarget.getIntentExtras());
            return targetIntent;
        }

        @Override
        public ComponentName getResolvedComponentName() {
            if (this.mSourceInfo != null) {
                return this.mSourceInfo.getResolvedComponentName();
            }
            if (this.mBackupResolveInfo != null) {
                return new ComponentName(this.mBackupResolveInfo.activityInfo.packageName, this.mBackupResolveInfo.activityInfo.name);
            }
            return null;
        }

        private Intent getBaseIntentToSend() {
            Intent result = this.getResolvedIntent();
            if (result == null) {
                Log.e(ChooserActivity.TAG, "ChooserTargetInfo: no base intent available to send");
            } else {
                result = new Intent(result);
                if (this.mFillInIntent != null) {
                    result.fillIn(this.mFillInIntent, this.mFillInFlags);
                }
                result.fillIn(ChooserActivity.this.mReferrerFillInIntent, 0);
            }
            return result;
        }

        @Override
        public boolean start(Activity activity, Bundle options) {
            throw new RuntimeException("ChooserTargets should be started as caller.");
        }

        @Override
        public boolean startAsCaller(Activity activity, Bundle options, int userId) {
            Intent intent = this.getBaseIntentToSend();
            if (intent == null) {
                return false;
            }
            intent.setComponent(this.mChooserTarget.getComponentName());
            intent.putExtras(this.mChooserTarget.getIntentExtras());
            boolean ignoreTargetSecurity = this.mSourceInfo != null && this.mSourceInfo.getResolvedComponentName().getPackageName().equals(this.mChooserTarget.getComponentName().getPackageName());
            activity.startActivityAsCaller(intent, options, ignoreTargetSecurity, userId);
            return true;
        }

        @Override
        public boolean startAsUser(Activity activity, Bundle options, UserHandle user) {
            throw new RuntimeException("ChooserTargets should be started as caller.");
        }

        @Override
        public ResolveInfo getResolveInfo() {
            return this.mSourceInfo != null ? this.mSourceInfo.getResolveInfo() : this.mBackupResolveInfo;
        }

        @Override
        public CharSequence getDisplayLabel() {
            return this.mChooserTarget.getTitle();
        }

        @Override
        public CharSequence getExtendedInfo() {
            return null;
        }

        @Override
        public Drawable getDisplayIcon() {
            return this.mDisplayIcon;
        }

        @Override
        public Drawable getBadgeIcon() {
            return this.mBadgeIcon;
        }

        @Override
        public CharSequence getBadgeContentDescription() {
            return this.mBadgeContentDescription;
        }

        @Override
        public ResolverActivity.TargetInfo cloneFilledIn(Intent fillInIntent, int flags) {
            return new ChooserTargetInfo(this, fillInIntent, flags);
        }

        @Override
        public List<Intent> getAllSourceIntents() {
            ArrayList<Intent> results = new ArrayList<Intent>();
            if (this.mSourceInfo != null) {
                results.add(this.mSourceInfo.getAllSourceIntents().get(0));
            }
            return results;
        }

        @Override
        public boolean isPinned() {
            return this.mSourceInfo != null ? this.mSourceInfo.isPinned() : false;
        }
    }

    public class ChooserListController
    extends ResolverListController {
        public ChooserListController(Context context, PackageManager pm, Intent targetIntent, String referrerPackageName, int launchedFromUid) {
            super(context, pm, targetIntent, referrerPackageName, launchedFromUid);
        }

        @Override
        boolean isComponentPinned(ComponentName name) {
            return ChooserActivity.this.mPinnedSharedPrefs.getBoolean(name.flattenToString(), false);
        }

        @Override
        boolean isComponentFiltered(ComponentName name) {
            if (ChooserActivity.this.mFilteredComponentNames == null) {
                return false;
            }
            for (ComponentName filteredComponentName : ChooserActivity.this.mFilteredComponentNames) {
                if (!name.equals(filteredComponentName)) continue;
                return true;
            }
            return false;
        }

        @Override
        public float getScore(ResolverActivity.DisplayResolveInfo target) {
            if (target == null) {
                return 900.0f;
            }
            float score = super.getScore(target);
            if (target.isPinned()) {
                score += 1000.0f;
            }
            return score;
        }
    }
}

