/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims;

import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.Rlog;
import com.android.ims.ImsCallForwardInfo;
import com.android.ims.ImsException;
import com.android.ims.ImsReasonInfo;
import com.android.ims.ImsSsInfo;
import com.android.ims.ImsUtInterface;
import com.android.ims.internal.IImsUt;
import com.android.ims.internal.IImsUtListener;
import java.util.HashMap;
import java.util.Map;

public class ImsUt
implements ImsUtInterface {
    public static final String KEY_ACTION = "action";
    public static final String KEY_CATEGORY = "category";
    public static final String CATEGORY_OIP = "OIP";
    public static final String CATEGORY_OIR = "OIR";
    public static final String CATEGORY_TIP = "TIP";
    public static final String CATEGORY_TIR = "TIR";
    public static final String CATEGORY_CDIV = "CDIV";
    public static final String CATEGORY_CB = "CB";
    public static final String CATEGORY_CW = "CW";
    public static final String CATEGORY_CONF = "CONF";
    private static final String TAG = "ImsUt";
    private static final boolean DBG = true;
    private Object mLockObj = new Object();
    private final IImsUt miUt;
    private HashMap<Integer, Message> mPendingCmds = new HashMap();

    public ImsUt(IImsUt iUt) {
        this.miUt = iUt;
        if (this.miUt != null) {
            try {
                this.miUt.setListener(new IImsUtListenerProxy());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.miUt != null) {
                try {
                    this.miUt.close();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (!this.mPendingCmds.isEmpty()) {
                Map.Entry[] entries;
                for (Map.Entry entry : entries = this.mPendingCmds.entrySet().toArray(new Map.Entry[this.mPendingCmds.size()])) {
                    this.sendFailureReport((Message)entry.getValue(), new ImsReasonInfo(802, 0));
                }
                this.mPendingCmds.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryCallBarring(int cbType, Message result) {
        this.log("queryCallBarring :: Ut=" + this.miUt + ", cbType=" + cbType);
        Object object = this.mLockObj;
        synchronized (object) {
            try {
                int id2 = this.miUt.queryCallBarring(cbType);
                if (id2 < 0) {
                    this.sendFailureReport(result, new ImsReasonInfo(802, 0));
                    return;
                }
                this.mPendingCmds.put(id2, result);
            }
            catch (RemoteException e) {
                this.sendFailureReport(result, new ImsReasonInfo(802, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryCallForward(int condition, String number, Message result) {
        this.log("queryCallForward :: Ut=" + this.miUt + ", condition=" + condition + ", number=" + Rlog.pii(TAG, (Object)number));
        Object object = this.mLockObj;
        synchronized (object) {
            try {
                int id2 = this.miUt.queryCallForward(condition, number);
                if (id2 < 0) {
                    this.sendFailureReport(result, new ImsReasonInfo(802, 0));
                    return;
                }
                this.mPendingCmds.put(id2, result);
            }
            catch (RemoteException e) {
                this.sendFailureReport(result, new ImsReasonInfo(802, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryCallWaiting(Message result) {
        this.log("queryCallWaiting :: Ut=" + this.miUt);
        Object object = this.mLockObj;
        synchronized (object) {
            try {
                int id2 = this.miUt.queryCallWaiting();
                if (id2 < 0) {
                    this.sendFailureReport(result, new ImsReasonInfo(802, 0));
                    return;
                }
                this.mPendingCmds.put(id2, result);
            }
            catch (RemoteException e) {
                this.sendFailureReport(result, new ImsReasonInfo(802, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryCLIR(Message result) {
        this.log("queryCLIR :: Ut=" + this.miUt);
        Object object = this.mLockObj;
        synchronized (object) {
            try {
                int id2 = this.miUt.queryCLIR();
                if (id2 < 0) {
                    this.sendFailureReport(result, new ImsReasonInfo(802, 0));
                    return;
                }
                this.mPendingCmds.put(id2, result);
            }
            catch (RemoteException e) {
                this.sendFailureReport(result, new ImsReasonInfo(802, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryCLIP(Message result) {
        this.log("queryCLIP :: Ut=" + this.miUt);
        Object object = this.mLockObj;
        synchronized (object) {
            try {
                int id2 = this.miUt.queryCLIP();
                if (id2 < 0) {
                    this.sendFailureReport(result, new ImsReasonInfo(802, 0));
                    return;
                }
                this.mPendingCmds.put(id2, result);
            }
            catch (RemoteException e) {
                this.sendFailureReport(result, new ImsReasonInfo(802, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryCOLR(Message result) {
        this.log("queryCOLR :: Ut=" + this.miUt);
        Object object = this.mLockObj;
        synchronized (object) {
            try {
                int id2 = this.miUt.queryCOLR();
                if (id2 < 0) {
                    this.sendFailureReport(result, new ImsReasonInfo(802, 0));
                    return;
                }
                this.mPendingCmds.put(id2, result);
            }
            catch (RemoteException e) {
                this.sendFailureReport(result, new ImsReasonInfo(802, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryCOLP(Message result) {
        this.log("queryCOLP :: Ut=" + this.miUt);
        Object object = this.mLockObj;
        synchronized (object) {
            try {
                int id2 = this.miUt.queryCOLP();
                if (id2 < 0) {
                    this.sendFailureReport(result, new ImsReasonInfo(802, 0));
                    return;
                }
                this.mPendingCmds.put(id2, result);
            }
            catch (RemoteException e) {
                this.sendFailureReport(result, new ImsReasonInfo(802, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCallBarring(int cbType, int action, Message result, String[] barrList) {
        if (barrList != null) {
            String bList = new String();
            for (int i = 0; i < barrList.length; ++i) {
                bList.concat(barrList[i] + " ");
            }
            this.log("updateCallBarring :: Ut=" + this.miUt + ", cbType=" + cbType + ", action=" + action + ", barrList=" + bList);
        } else {
            this.log("updateCallBarring :: Ut=" + this.miUt + ", cbType=" + cbType + ", action=" + action);
        }
        Object object = this.mLockObj;
        synchronized (object) {
            try {
                int id2 = this.miUt.updateCallBarring(cbType, action, barrList);
                if (id2 < 0) {
                    this.sendFailureReport(result, new ImsReasonInfo(802, 0));
                    return;
                }
                this.mPendingCmds.put(id2, result);
            }
            catch (RemoteException e) {
                this.sendFailureReport(result, new ImsReasonInfo(802, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCallForward(int action, int condition, String number, int serviceClass, int timeSeconds, Message result) {
        this.log("updateCallForward :: Ut=" + this.miUt + ", action=" + action + ", condition=" + condition + ", number=" + Rlog.pii(TAG, (Object)number) + ", serviceClass=" + serviceClass + ", timeSeconds=" + timeSeconds);
        Object object = this.mLockObj;
        synchronized (object) {
            try {
                int id2 = this.miUt.updateCallForward(action, condition, number, serviceClass, timeSeconds);
                if (id2 < 0) {
                    this.sendFailureReport(result, new ImsReasonInfo(802, 0));
                    return;
                }
                this.mPendingCmds.put(id2, result);
            }
            catch (RemoteException e) {
                this.sendFailureReport(result, new ImsReasonInfo(802, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCallWaiting(boolean enable, int serviceClass, Message result) {
        this.log("updateCallWaiting :: Ut=" + this.miUt + ", enable=" + enable + ",serviceClass=" + serviceClass);
        Object object = this.mLockObj;
        synchronized (object) {
            try {
                int id2 = this.miUt.updateCallWaiting(enable, serviceClass);
                if (id2 < 0) {
                    this.sendFailureReport(result, new ImsReasonInfo(802, 0));
                    return;
                }
                this.mPendingCmds.put(id2, result);
            }
            catch (RemoteException e) {
                this.sendFailureReport(result, new ImsReasonInfo(802, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCLIR(int clirMode, Message result) {
        this.log("updateCLIR :: Ut=" + this.miUt + ", clirMode=" + clirMode);
        Object object = this.mLockObj;
        synchronized (object) {
            try {
                int id2 = this.miUt.updateCLIR(clirMode);
                if (id2 < 0) {
                    this.sendFailureReport(result, new ImsReasonInfo(802, 0));
                    return;
                }
                this.mPendingCmds.put(id2, result);
            }
            catch (RemoteException e) {
                this.sendFailureReport(result, new ImsReasonInfo(802, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCLIP(boolean enable, Message result) {
        this.log("updateCLIP :: Ut=" + this.miUt + ", enable=" + enable);
        Object object = this.mLockObj;
        synchronized (object) {
            try {
                int id2 = this.miUt.updateCLIP(enable);
                if (id2 < 0) {
                    this.sendFailureReport(result, new ImsReasonInfo(802, 0));
                    return;
                }
                this.mPendingCmds.put(id2, result);
            }
            catch (RemoteException e) {
                this.sendFailureReport(result, new ImsReasonInfo(802, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCOLR(int presentation, Message result) {
        this.log("updateCOLR :: Ut=" + this.miUt + ", presentation=" + presentation);
        Object object = this.mLockObj;
        synchronized (object) {
            try {
                int id2 = this.miUt.updateCOLR(presentation);
                if (id2 < 0) {
                    this.sendFailureReport(result, new ImsReasonInfo(802, 0));
                    return;
                }
                this.mPendingCmds.put(id2, result);
            }
            catch (RemoteException e) {
                this.sendFailureReport(result, new ImsReasonInfo(802, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCOLP(boolean enable, Message result) {
        this.log("updateCallWaiting :: Ut=" + this.miUt + ", enable=" + enable);
        Object object = this.mLockObj;
        synchronized (object) {
            try {
                int id2 = this.miUt.updateCOLP(enable);
                if (id2 < 0) {
                    this.sendFailureReport(result, new ImsReasonInfo(802, 0));
                    return;
                }
                this.mPendingCmds.put(id2, result);
            }
            catch (RemoteException e) {
                this.sendFailureReport(result, new ImsReasonInfo(802, 0));
            }
        }
    }

    public boolean isBinderAlive() {
        return this.miUt.asBinder().isBinderAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transact(Bundle ssInfo, Message result) {
        this.log("transact :: Ut=" + this.miUt + ", ssInfo=" + ssInfo);
        Object object = this.mLockObj;
        synchronized (object) {
            try {
                int id2 = this.miUt.transact(ssInfo);
                if (id2 < 0) {
                    this.sendFailureReport(result, new ImsReasonInfo(802, 0));
                    return;
                }
                this.mPendingCmds.put(id2, result);
            }
            catch (RemoteException e) {
                this.sendFailureReport(result, new ImsReasonInfo(802, 0));
            }
        }
    }

    private void sendFailureReport(Message result, ImsReasonInfo error) {
        if (result == null || error == null) {
            return;
        }
        String errorString = error.mExtraMessage == null ? Resources.getSystem().getString(17040257) : new String(error.mExtraMessage);
        AsyncResult.forMessage(result, null, new ImsException(errorString, error.mCode));
        result.sendToTarget();
    }

    private void sendSuccessReport(Message result) {
        if (result == null) {
            return;
        }
        AsyncResult.forMessage(result, null, null);
        result.sendToTarget();
    }

    private void sendSuccessReport(Message result, Object ssInfo) {
        if (result == null) {
            return;
        }
        AsyncResult.forMessage(result, ssInfo, null);
        result.sendToTarget();
    }

    private void log(String s) {
        Rlog.d(TAG, s);
    }

    private void loge(String s) {
        Rlog.e(TAG, s);
    }

    private void loge(String s, Throwable t) {
        Rlog.e(TAG, s, t);
    }

    private class IImsUtListenerProxy
    extends IImsUtListener.Stub {
        private IImsUtListenerProxy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void utConfigurationUpdated(IImsUt ut, int id2) {
            Integer key = id2;
            Object object = ImsUt.this.mLockObj;
            synchronized (object) {
                ImsUt.this.sendSuccessReport((Message)ImsUt.this.mPendingCmds.get(key));
                ImsUt.this.mPendingCmds.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void utConfigurationUpdateFailed(IImsUt ut, int id2, ImsReasonInfo error) {
            Integer key = id2;
            Object object = ImsUt.this.mLockObj;
            synchronized (object) {
                ImsUt.this.sendFailureReport((Message)ImsUt.this.mPendingCmds.get(key), error);
                ImsUt.this.mPendingCmds.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void utConfigurationQueried(IImsUt ut, int id2, Bundle ssInfo) {
            Integer key = id2;
            Object object = ImsUt.this.mLockObj;
            synchronized (object) {
                ImsUt.this.sendSuccessReport((Message)ImsUt.this.mPendingCmds.get(key), ssInfo);
                ImsUt.this.mPendingCmds.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void utConfigurationQueryFailed(IImsUt ut, int id2, ImsReasonInfo error) {
            Integer key = id2;
            Object object = ImsUt.this.mLockObj;
            synchronized (object) {
                ImsUt.this.sendFailureReport((Message)ImsUt.this.mPendingCmds.get(key), error);
                ImsUt.this.mPendingCmds.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void utConfigurationCallBarringQueried(IImsUt ut, int id2, ImsSsInfo[] cbInfo) {
            Integer key = id2;
            Object object = ImsUt.this.mLockObj;
            synchronized (object) {
                ImsUt.this.sendSuccessReport((Message)ImsUt.this.mPendingCmds.get(key), cbInfo);
                ImsUt.this.mPendingCmds.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void utConfigurationCallForwardQueried(IImsUt ut, int id2, ImsCallForwardInfo[] cfInfo) {
            Integer key = id2;
            Object object = ImsUt.this.mLockObj;
            synchronized (object) {
                ImsUt.this.sendSuccessReport((Message)ImsUt.this.mPendingCmds.get(key), cfInfo);
                ImsUt.this.mPendingCmds.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void utConfigurationCallWaitingQueried(IImsUt ut, int id2, ImsSsInfo[] cwInfo) {
            Integer key = id2;
            Object object = ImsUt.this.mLockObj;
            synchronized (object) {
                ImsUt.this.sendSuccessReport((Message)ImsUt.this.mPendingCmds.get(key), cwInfo);
                ImsUt.this.mPendingCmds.remove(key);
            }
        }
    }
}

