/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.content.ClipDescription;
import android.content.ContentProvider;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import com.android.internal.inputmethod.IInputContentUriToken;
import java.security.InvalidParameterException;

public final class InputContentInfo
implements Parcelable {
    private final Uri mContentUri;
    private final int mContentUriOwnerUserId;
    private final ClipDescription mDescription;
    private final Uri mLinkUri;
    private IInputContentUriToken mUriToken;
    public static final Parcelable.Creator<InputContentInfo> CREATOR = new Parcelable.Creator<InputContentInfo>(){

        @Override
        public InputContentInfo createFromParcel(Parcel source) {
            return new InputContentInfo(source);
        }

        public InputContentInfo[] newArray(int size) {
            return new InputContentInfo[size];
        }
    };

    public InputContentInfo(Uri contentUri, ClipDescription description) {
        this(contentUri, description, null);
    }

    public InputContentInfo(Uri contentUri, ClipDescription description, Uri linkUri) {
        InputContentInfo.validateInternal(contentUri, description, linkUri, true);
        this.mContentUri = contentUri;
        this.mContentUriOwnerUserId = ContentProvider.getUserIdFromUri(this.mContentUri, UserHandle.myUserId());
        this.mDescription = description;
        this.mLinkUri = linkUri;
    }

    public boolean validate() {
        return InputContentInfo.validateInternal(this.mContentUri, this.mDescription, this.mLinkUri, false);
    }

    private static boolean validateInternal(Uri contentUri, ClipDescription description, Uri linkUri, boolean throwException) {
        String scheme;
        if (contentUri == null) {
            if (throwException) {
                throw new NullPointerException("contentUri");
            }
            return false;
        }
        if (description == null) {
            if (throwException) {
                throw new NullPointerException("description");
            }
            return false;
        }
        String contentUriScheme = contentUri.getScheme();
        if (!"content".equals(contentUriScheme)) {
            if (throwException) {
                throw new InvalidParameterException("contentUri must have content scheme");
            }
            return false;
        }
        if (linkUri != null && ((scheme = linkUri.getScheme()) == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https"))) {
            if (throwException) {
                throw new InvalidParameterException("linkUri must have either http or https scheme");
            }
            return false;
        }
        return true;
    }

    public Uri getContentUri() {
        if (this.mContentUriOwnerUserId != UserHandle.myUserId()) {
            return ContentProvider.maybeAddUserId(this.mContentUri, this.mContentUriOwnerUserId);
        }
        return this.mContentUri;
    }

    public ClipDescription getDescription() {
        return this.mDescription;
    }

    public Uri getLinkUri() {
        return this.mLinkUri;
    }

    void setUriToken(IInputContentUriToken token) {
        if (this.mUriToken != null) {
            throw new IllegalStateException("URI token is already set");
        }
        this.mUriToken = token;
    }

    public void requestPermission() {
        if (this.mUriToken == null) {
            return;
        }
        try {
            this.mUriToken.take();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void releasePermission() {
        if (this.mUriToken == null) {
            return;
        }
        try {
            this.mUriToken.release();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Uri.writeToParcel(dest, this.mContentUri);
        dest.writeInt(this.mContentUriOwnerUserId);
        this.mDescription.writeToParcel(dest, flags);
        Uri.writeToParcel(dest, this.mLinkUri);
        if (this.mUriToken != null) {
            dest.writeInt(1);
            dest.writeStrongBinder(this.mUriToken.asBinder());
        } else {
            dest.writeInt(0);
        }
    }

    private InputContentInfo(Parcel source) {
        this.mContentUri = Uri.CREATOR.createFromParcel(source);
        this.mContentUriOwnerUserId = source.readInt();
        this.mDescription = ClipDescription.CREATOR.createFromParcel(source);
        this.mLinkUri = Uri.CREATOR.createFromParcel(source);
        this.mUriToken = source.readInt() == 1 ? IInputContentUriToken.Stub.asInterface(source.readStrongBinder()) : null;
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

