/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.view.IInputFilter;
import android.view.IInputFilterHost;
import android.view.InputEvent;
import android.view.InputEventConsistencyVerifier;

public abstract class InputFilter
extends IInputFilter.Stub {
    private static final int MSG_INSTALL = 1;
    private static final int MSG_UNINSTALL = 2;
    private static final int MSG_INPUT_EVENT = 3;
    private final InputEventConsistencyVerifier mInboundInputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 1, "InputFilter#InboundInputEventConsistencyVerifier") : null;
    private final InputEventConsistencyVerifier mOutboundInputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 1, "InputFilter#OutboundInputEventConsistencyVerifier") : null;
    private final H mH;
    private IInputFilterHost mHost;

    public InputFilter(Looper looper) {
        this.mH = new H(looper);
    }

    @Override
    public final void install(IInputFilterHost host) {
        this.mH.obtainMessage(1, host).sendToTarget();
    }

    @Override
    public final void uninstall() {
        this.mH.obtainMessage(2).sendToTarget();
    }

    @Override
    public final void filterInputEvent(InputEvent event, int policyFlags) {
        this.mH.obtainMessage(3, policyFlags, 0, event).sendToTarget();
    }

    public void sendInputEvent(InputEvent event, int policyFlags) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (this.mHost == null) {
            throw new IllegalStateException("Cannot send input event because the input filter is not installed.");
        }
        if (this.mOutboundInputEventConsistencyVerifier != null) {
            this.mOutboundInputEventConsistencyVerifier.onInputEvent(event, 0);
        }
        try {
            this.mHost.sendInputEvent(event, policyFlags);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void onInputEvent(InputEvent event, int policyFlags) {
        this.sendInputEvent(event, policyFlags);
    }

    public void onInstalled() {
    }

    public void onUninstalled() {
    }

    private final class H
    extends Handler {
        public H(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    InputFilter.this.mHost = (IInputFilterHost)msg.obj;
                    if (InputFilter.this.mInboundInputEventConsistencyVerifier != null) {
                        InputFilter.this.mInboundInputEventConsistencyVerifier.reset();
                    }
                    if (InputFilter.this.mOutboundInputEventConsistencyVerifier != null) {
                        InputFilter.this.mOutboundInputEventConsistencyVerifier.reset();
                    }
                    InputFilter.this.onInstalled();
                    break;
                }
                case 2: {
                    try {
                        InputFilter.this.onUninstalled();
                        break;
                    }
                    finally {
                        InputFilter.this.mHost = null;
                    }
                }
                case 3: {
                    InputEvent event = (InputEvent)msg.obj;
                    try {
                        if (InputFilter.this.mInboundInputEventConsistencyVerifier != null) {
                            InputFilter.this.mInboundInputEventConsistencyVerifier.onInputEvent(event, 0);
                        }
                        InputFilter.this.onInputEvent(event, msg.arg1);
                        break;
                    }
                    finally {
                        event.recycle();
                    }
                }
            }
        }
    }
}

