/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.SpanSet;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.CharacterStyle;
import android.text.style.MetricAffectingSpan;
import android.text.style.ReplacementSpan;
import com.android.internal.util.ArrayUtils;
import java.util.ArrayList;

class TextLine {
    private static final boolean DEBUG = false;
    private TextPaint mPaint;
    private CharSequence mText;
    private int mStart;
    private int mLen;
    private int mDir;
    private Layout.Directions mDirections;
    private boolean mHasTabs;
    private Layout.TabStops mTabs;
    private char[] mChars;
    private boolean mCharsValid;
    private Spanned mSpanned;
    private float mAddedWidth;
    private final TextPaint mWorkPaint = new TextPaint();
    private final TextPaint mActivePaint = new TextPaint();
    private final SpanSet<MetricAffectingSpan> mMetricAffectingSpanSpanSet = new SpanSet<MetricAffectingSpan>(MetricAffectingSpan.class);
    private final SpanSet<CharacterStyle> mCharacterStyleSpanSet = new SpanSet<CharacterStyle>(CharacterStyle.class);
    private final SpanSet<ReplacementSpan> mReplacementSpanSpanSet = new SpanSet<ReplacementSpan>(ReplacementSpan.class);
    private final DecorationInfo mDecorationInfo = new DecorationInfo();
    private final ArrayList<DecorationInfo> mDecorations = new ArrayList();
    private static final TextLine[] sCached = new TextLine[3];
    private static final int TAB_INCREMENT = 20;

    TextLine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TextLine obtain() {
        TextLine[] textLineArray = sCached;
        synchronized (sCached) {
            int i = sCached.length;
            while (--i >= 0) {
                if (sCached[i] == null) continue;
                TextLine tl = sCached[i];
                TextLine.sCached[i] = null;
                // ** MonitorExit[var0] (shouldn't be in output)
                return tl;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            TextLine tl = new TextLine();
            return tl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TextLine recycle(TextLine tl) {
        tl.mText = null;
        tl.mPaint = null;
        tl.mDirections = null;
        tl.mSpanned = null;
        tl.mTabs = null;
        tl.mChars = null;
        tl.mMetricAffectingSpanSpanSet.recycle();
        tl.mCharacterStyleSpanSet.recycle();
        tl.mReplacementSpanSpanSet.recycle();
        TextLine[] textLineArray = sCached;
        synchronized (sCached) {
            for (int i = 0; i < sCached.length; ++i) {
                if (sCached[i] != null) continue;
                TextLine.sCached[i] = tl;
                break;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    void set(TextPaint paint, CharSequence text, int start, int limit, int dir, Layout.Directions directions, boolean hasTabs, Layout.TabStops tabStops) {
        this.mPaint = paint;
        this.mText = text;
        this.mStart = start;
        this.mLen = limit - start;
        this.mDir = dir;
        this.mDirections = directions;
        if (this.mDirections == null) {
            throw new IllegalArgumentException("Directions cannot be null");
        }
        this.mHasTabs = hasTabs;
        this.mSpanned = null;
        boolean hasReplacement = false;
        if (text instanceof Spanned) {
            this.mSpanned = (Spanned)text;
            this.mReplacementSpanSpanSet.init(this.mSpanned, start, limit);
            hasReplacement = this.mReplacementSpanSpanSet.numberOfSpans > 0;
        }
        boolean bl = this.mCharsValid = hasReplacement || hasTabs || directions != Layout.DIRS_ALL_LEFT_TO_RIGHT;
        if (this.mCharsValid) {
            if (this.mChars == null || this.mChars.length < this.mLen) {
                this.mChars = ArrayUtils.newUnpaddedCharArray(this.mLen);
            }
            TextUtils.getChars(text, start, limit, this.mChars, 0);
            if (hasReplacement) {
                char[] chars = this.mChars;
                int i = start;
                while (i < limit) {
                    int inext = this.mReplacementSpanSpanSet.getNextTransition(i, limit);
                    if (this.mReplacementSpanSpanSet.hasSpansIntersecting(i, inext)) {
                        chars[i - start] = 65532;
                        int e = inext - start;
                        for (int j = i - start + 1; j < e; ++j) {
                            chars[j] = 65279;
                        }
                    }
                    i = inext;
                }
            }
        }
        this.mTabs = tabStops;
        this.mAddedWidth = 0.0f;
    }

    void justify(float justifyWidth) {
        int end;
        for (end = this.mLen; end > 0 && TextLine.isLineEndSpace(this.mText.charAt(this.mStart + end - 1)); --end) {
        }
        int spaces = this.countStretchableSpaces(0, end);
        if (spaces == 0) {
            return;
        }
        float width = Math.abs(this.measure(end, false, null));
        this.mAddedWidth = (justifyWidth - width) / (float)spaces;
    }

    void draw(Canvas c, float x, int top, int y, int bottom) {
        if (!this.mHasTabs) {
            if (this.mDirections == Layout.DIRS_ALL_LEFT_TO_RIGHT) {
                this.drawRun(c, 0, this.mLen, false, x, top, y, bottom, false);
                return;
            }
            if (this.mDirections == Layout.DIRS_ALL_RIGHT_TO_LEFT) {
                this.drawRun(c, 0, this.mLen, true, x, top, y, bottom, false);
                return;
            }
        }
        float h = 0.0f;
        int[] runs = this.mDirections.mDirections;
        int lastRunIndex = runs.length - 2;
        for (int i = 0; i < runs.length; i += 2) {
            int j;
            int runStart = runs[i];
            int runLimit = runStart + (runs[i + 1] & 0x3FFFFFF);
            if (runLimit > this.mLen) {
                runLimit = this.mLen;
            }
            boolean runIsRtl = (runs[i + 1] & 0x4000000) != 0;
            int segstart = runStart;
            int n = j = this.mHasTabs ? runStart : runLimit;
            while (j <= runLimit) {
                int codept = 0;
                if (this.mHasTabs && j < runLimit && (codept = this.mChars[j]) >= 55296 && codept < 56320 && j + 1 < runLimit && (codept = Character.codePointAt(this.mChars, j)) > 65535) {
                    ++j;
                } else if (j == runLimit || codept == 9) {
                    h += this.drawRun(c, segstart, j, runIsRtl, x + h, top, y, bottom, i != lastRunIndex || j != this.mLen);
                    if (codept == 9) {
                        h = (float)this.mDir * this.nextTab(h * (float)this.mDir);
                    }
                    segstart = j + 1;
                }
                ++j;
            }
        }
    }

    float metrics(Paint.FontMetricsInt fmi) {
        return this.measure(this.mLen, false, fmi);
    }

    float measure(int offset, boolean trailing, Paint.FontMetricsInt fmi) {
        int target;
        int n = target = trailing ? offset - 1 : offset;
        if (target < 0) {
            return 0.0f;
        }
        float h = 0.0f;
        if (!this.mHasTabs) {
            if (this.mDirections == Layout.DIRS_ALL_LEFT_TO_RIGHT) {
                return this.measureRun(0, offset, this.mLen, false, fmi);
            }
            if (this.mDirections == Layout.DIRS_ALL_RIGHT_TO_LEFT) {
                return this.measureRun(0, offset, this.mLen, true, fmi);
            }
        }
        char[] chars = this.mChars;
        int[] runs = this.mDirections.mDirections;
        for (int i = 0; i < runs.length; i += 2) {
            int j;
            int runStart = runs[i];
            int runLimit = runStart + (runs[i + 1] & 0x3FFFFFF);
            if (runLimit > this.mLen) {
                runLimit = this.mLen;
            }
            boolean runIsRtl = (runs[i + 1] & 0x4000000) != 0;
            int segstart = runStart;
            int n2 = j = this.mHasTabs ? runStart : runLimit;
            while (j <= runLimit) {
                int codept = 0;
                if (this.mHasTabs && j < runLimit && (codept = chars[j]) >= 55296 && codept < 56320 && j + 1 < runLimit && (codept = Character.codePointAt(chars, j)) > 65535) {
                    ++j;
                } else if (j == runLimit || codept == 9) {
                    boolean advance;
                    boolean inSegment = target >= segstart && target < j;
                    boolean bl = advance = this.mDir == -1 == runIsRtl;
                    if (inSegment && advance) {
                        return h += this.measureRun(segstart, offset, j, runIsRtl, fmi);
                    }
                    float w = this.measureRun(segstart, j, j, runIsRtl, fmi);
                    h += advance ? w : -w;
                    if (inSegment) {
                        return h += this.measureRun(segstart, offset, j, runIsRtl, null);
                    }
                    if (codept == 9) {
                        if (offset == j) {
                            return h;
                        }
                        h = (float)this.mDir * this.nextTab(h * (float)this.mDir);
                        if (target == j) {
                            return h;
                        }
                    }
                    segstart = j + 1;
                }
                ++j;
            }
        }
        return h;
    }

    private float drawRun(Canvas c, int start, int limit, boolean runIsRtl, float x, int top, int y, int bottom, boolean needWidth) {
        if (this.mDir == 1 == runIsRtl) {
            float w = -this.measureRun(start, limit, limit, runIsRtl, null);
            this.handleRun(start, limit, limit, runIsRtl, c, x + w, top, y, bottom, null, false);
            return w;
        }
        return this.handleRun(start, limit, limit, runIsRtl, c, x, top, y, bottom, null, needWidth);
    }

    private float measureRun(int start, int offset, int limit, boolean runIsRtl, Paint.FontMetricsInt fmi) {
        return this.handleRun(start, offset, limit, runIsRtl, null, 0.0f, 0, 0, 0, fmi, true);
    }

    int getOffsetToLeftRightOf(int cursor, boolean toLeft) {
        int newCaret;
        block13: {
            boolean advance;
            int lineEnd;
            int lineStart;
            block14: {
                int otherRunIndex;
                int runIndex;
                lineStart = 0;
                lineEnd = this.mLen;
                boolean paraIsRtl = this.mDir == -1;
                int[] runs = this.mDirections.mDirections;
                int runLevel = 0;
                int runStart = lineStart;
                int runLimit = lineEnd;
                newCaret = -1;
                boolean trailing = false;
                if (cursor == lineStart) {
                    runIndex = -2;
                } else if (cursor == lineEnd) {
                    runIndex = runs.length;
                } else {
                    boolean runIsRtl;
                    boolean advance2;
                    block0: for (runIndex = 0; runIndex < runs.length; runIndex += 2) {
                        runStart = lineStart + runs[runIndex];
                        if (cursor < runStart) continue;
                        runLimit = runStart + (runs[runIndex + 1] & 0x3FFFFFF);
                        if (runLimit > lineEnd) {
                            runLimit = lineEnd;
                        }
                        if (cursor >= runLimit) continue;
                        runLevel = runs[runIndex + 1] >>> 26 & 0x3F;
                        if (cursor != runStart) break;
                        int pos = cursor - 1;
                        for (int prevRunIndex = 0; prevRunIndex < runs.length; prevRunIndex += 2) {
                            int prevRunLevel;
                            int prevRunStart = lineStart + runs[prevRunIndex];
                            if (pos < prevRunStart) continue;
                            int prevRunLimit = prevRunStart + (runs[prevRunIndex + 1] & 0x3FFFFFF);
                            if (prevRunLimit > lineEnd) {
                                prevRunLimit = lineEnd;
                            }
                            if (pos >= prevRunLimit || (prevRunLevel = runs[prevRunIndex + 1] >>> 26 & 0x3F) >= runLevel) continue;
                            runIndex = prevRunIndex;
                            runLevel = prevRunLevel;
                            runStart = prevRunStart;
                            runLimit = prevRunLimit;
                            trailing = true;
                            break block0;
                        }
                        break;
                    }
                    if (runIndex != runs.length && (cursor != ((advance2 = toLeft == (runIsRtl = runLevel & true)) ? runLimit : runStart) || advance2 != trailing) && (newCaret = this.getOffsetBeforeAfter(runIndex, runStart, runLimit, runIsRtl, cursor, advance2)) != (advance2 ? runLimit : runStart)) {
                        return newCaret;
                    }
                }
                while ((otherRunIndex = runIndex + ((advance = toLeft == paraIsRtl) ? 2 : -2)) >= 0 && otherRunIndex < runs.length) {
                    int otherRunLevel;
                    int otherRunStart = lineStart + runs[otherRunIndex];
                    int otherRunLimit = otherRunStart + (runs[otherRunIndex + 1] & 0x3FFFFFF);
                    if (otherRunLimit > lineEnd) {
                        otherRunLimit = lineEnd;
                    }
                    boolean otherRunIsRtl = ((otherRunLevel = runs[otherRunIndex + 1] >>> 26 & 0x3F) & 1) != 0;
                    boolean bl = advance = toLeft == otherRunIsRtl;
                    if (newCaret == -1) {
                        newCaret = this.getOffsetBeforeAfter(otherRunIndex, otherRunStart, otherRunLimit, otherRunIsRtl, advance ? otherRunStart : otherRunLimit, advance);
                        if (newCaret == (advance ? otherRunLimit : otherRunStart)) {
                            runIndex = otherRunIndex;
                            runLevel = otherRunLevel;
                            continue;
                        }
                        break block13;
                    }
                    if (otherRunLevel >= runLevel) break block13;
                    newCaret = advance ? otherRunStart : otherRunLimit;
                    break block13;
                }
                if (newCaret != -1) break block14;
                newCaret = advance ? this.mLen + 1 : -1;
                break block13;
            }
            if (newCaret > lineEnd) break block13;
            newCaret = advance ? lineEnd : lineStart;
        }
        return newCaret;
    }

    private int getOffsetBeforeAfter(int runIndex, int runStart, int runLimit, boolean runIsRtl, int offset, boolean after) {
        int cursorOpt;
        int spanLimit;
        if (runIndex < 0 || offset == (after ? this.mLen : 0)) {
            if (after) {
                return TextUtils.getOffsetAfter(this.mText, offset + this.mStart) - this.mStart;
            }
            return TextUtils.getOffsetBefore(this.mText, offset + this.mStart) - this.mStart;
        }
        TextPaint wp = this.mWorkPaint;
        wp.set(this.mPaint);
        wp.setWordSpacing(this.mAddedWidth);
        int spanStart = runStart;
        if (this.mSpanned == null) {
            spanLimit = runLimit;
        } else {
            int target = after ? offset + 1 : offset;
            int limit = this.mStart + runLimit;
            while ((spanLimit = this.mSpanned.nextSpanTransition(this.mStart + spanStart, limit, MetricAffectingSpan.class) - this.mStart) < target) {
                spanStart = spanLimit;
            }
            MetricAffectingSpan[] spans = this.mSpanned.getSpans(this.mStart + spanStart, this.mStart + spanLimit, MetricAffectingSpan.class);
            spans = TextUtils.removeEmptySpans(spans, this.mSpanned, MetricAffectingSpan.class);
            if (spans.length > 0) {
                ReplacementSpan replacement = null;
                for (int j = 0; j < spans.length; ++j) {
                    MetricAffectingSpan span = spans[j];
                    if (span instanceof ReplacementSpan) {
                        replacement = (ReplacementSpan)span;
                        continue;
                    }
                    span.updateMeasureState(wp);
                }
                if (replacement != null) {
                    return after ? spanLimit : spanStart;
                }
            }
        }
        int dir = runIsRtl ? 1 : 0;
        int n = cursorOpt = after ? 0 : 2;
        if (this.mCharsValid) {
            return wp.getTextRunCursor(this.mChars, spanStart, spanLimit - spanStart, dir, offset, cursorOpt);
        }
        return wp.getTextRunCursor(this.mText, this.mStart + spanStart, this.mStart + spanLimit, dir, this.mStart + offset, cursorOpt) - this.mStart;
    }

    private static void expandMetricsFromPaint(Paint.FontMetricsInt fmi, TextPaint wp) {
        int previousTop = fmi.top;
        int previousAscent = fmi.ascent;
        int previousDescent = fmi.descent;
        int previousBottom = fmi.bottom;
        int previousLeading = fmi.leading;
        wp.getFontMetricsInt(fmi);
        TextLine.updateMetrics(fmi, previousTop, previousAscent, previousDescent, previousBottom, previousLeading);
    }

    static void updateMetrics(Paint.FontMetricsInt fmi, int previousTop, int previousAscent, int previousDescent, int previousBottom, int previousLeading) {
        fmi.top = Math.min(fmi.top, previousTop);
        fmi.ascent = Math.min(fmi.ascent, previousAscent);
        fmi.descent = Math.max(fmi.descent, previousDescent);
        fmi.bottom = Math.max(fmi.bottom, previousBottom);
        fmi.leading = Math.max(fmi.leading, previousLeading);
    }

    private static void drawStroke(TextPaint wp, Canvas c, int color2, float position, float thickness, float xleft, float xright, float baseline) {
        float strokeTop = baseline + (float)wp.baselineShift + position;
        int previousColor = wp.getColor();
        Paint.Style previousStyle = wp.getStyle();
        boolean previousAntiAlias = wp.isAntiAlias();
        wp.setStyle(Paint.Style.FILL);
        wp.setAntiAlias(true);
        wp.setColor(color2);
        c.drawRect(xleft, strokeTop, xright, strokeTop + thickness, wp);
        wp.setStyle(previousStyle);
        wp.setColor(previousColor);
        wp.setAntiAlias(previousAntiAlias);
    }

    private float getRunAdvance(TextPaint wp, int start, int end, int contextStart, int contextEnd, boolean runIsRtl, int offset) {
        if (this.mCharsValid) {
            return wp.getRunAdvance(this.mChars, start, end, contextStart, contextEnd, runIsRtl, offset);
        }
        int delta = this.mStart;
        return wp.getRunAdvance(this.mText, delta + start, delta + end, delta + contextStart, delta + contextEnd, runIsRtl, delta + offset);
    }

    private float handleText(TextPaint wp, int start, int end, int contextStart, int contextEnd, boolean runIsRtl, Canvas c, float x, int top, int y, int bottom, Paint.FontMetricsInt fmi, boolean needWidth, int offset, ArrayList<DecorationInfo> decorations) {
        int numDecorations;
        wp.setWordSpacing(this.mAddedWidth);
        if (fmi != null) {
            TextLine.expandMetricsFromPaint(fmi, wp);
        }
        if (end == start) {
            return 0.0f;
        }
        float totalWidth = 0.0f;
        int n = numDecorations = decorations == null ? 0 : decorations.size();
        if (needWidth || c != null && (wp.bgColor != 0 || numDecorations != 0 || runIsRtl)) {
            totalWidth = this.getRunAdvance(wp, start, end, contextStart, contextEnd, runIsRtl, offset);
        }
        if (c != null) {
            float rightX;
            float leftX;
            if (runIsRtl) {
                leftX = x - totalWidth;
                rightX = x;
            } else {
                leftX = x;
                rightX = x + totalWidth;
            }
            if (wp.bgColor != 0) {
                int previousColor = wp.getColor();
                Paint.Style previousStyle = wp.getStyle();
                wp.setColor(wp.bgColor);
                wp.setStyle(Paint.Style.FILL);
                c.drawRect(leftX, top, rightX, bottom, wp);
                wp.setStyle(previousStyle);
                wp.setColor(previousColor);
            }
            if (numDecorations != 0) {
                for (int i = 0; i < numDecorations; ++i) {
                    float thickness;
                    float decorationXRight;
                    float decorationXLeft;
                    DecorationInfo info = decorations.get(i);
                    int decorationStart = Math.max(info.start, start);
                    int decorationEnd = Math.min(info.end, offset);
                    float decorationStartAdvance = this.getRunAdvance(wp, start, end, contextStart, contextEnd, runIsRtl, decorationStart);
                    float decorationEndAdvance = this.getRunAdvance(wp, start, end, contextStart, contextEnd, runIsRtl, decorationEnd);
                    if (runIsRtl) {
                        decorationXLeft = rightX - decorationEndAdvance;
                        decorationXRight = rightX - decorationStartAdvance;
                    } else {
                        decorationXLeft = leftX + decorationStartAdvance;
                        decorationXRight = leftX + decorationEndAdvance;
                    }
                    if (info.underlineColor != 0) {
                        TextLine.drawStroke(wp, c, info.underlineColor, wp.getUnderlinePosition(), info.underlineThickness, decorationXLeft, decorationXRight, y);
                    }
                    if (info.isUnderlineText) {
                        thickness = Math.max(((Paint)wp).getUnderlineThickness(), 1.0f);
                        TextLine.drawStroke(wp, c, wp.getColor(), wp.getUnderlinePosition(), thickness, decorationXLeft, decorationXRight, y);
                    }
                    if (!info.isStrikeThruText) continue;
                    thickness = Math.max(wp.getStrikeThruThickness(), 1.0f);
                    TextLine.drawStroke(wp, c, wp.getColor(), wp.getStrikeThruPosition(), thickness, decorationXLeft, decorationXRight, y);
                }
            }
            this.drawTextRun(c, wp, start, end, contextStart, contextEnd, runIsRtl, leftX, y + wp.baselineShift);
        }
        return runIsRtl ? -totalWidth : totalWidth;
    }

    private float handleReplacement(ReplacementSpan replacement, TextPaint wp, int start, int limit, boolean runIsRtl, Canvas c, float x, int top, int y, int bottom, Paint.FontMetricsInt fmi, boolean needWidth) {
        float ret = 0.0f;
        int textStart = this.mStart + start;
        int textLimit = this.mStart + limit;
        if (needWidth || c != null && runIsRtl) {
            boolean needUpdateMetrics;
            int previousTop = 0;
            int previousAscent = 0;
            int previousDescent = 0;
            int previousBottom = 0;
            int previousLeading = 0;
            boolean bl = needUpdateMetrics = fmi != null;
            if (needUpdateMetrics) {
                previousTop = fmi.top;
                previousAscent = fmi.ascent;
                previousDescent = fmi.descent;
                previousBottom = fmi.bottom;
                previousLeading = fmi.leading;
            }
            ret = replacement.getSize(wp, this.mText, textStart, textLimit, fmi);
            if (needUpdateMetrics) {
                TextLine.updateMetrics(fmi, previousTop, previousAscent, previousDescent, previousBottom, previousLeading);
            }
        }
        if (c != null) {
            if (runIsRtl) {
                x -= ret;
            }
            replacement.draw(c, this.mText, textStart, textLimit, x, top, y, bottom, wp);
        }
        return runIsRtl ? -ret : ret;
    }

    private int adjustHyphenEdit(int start, int limit, int hyphenEdit) {
        int result = hyphenEdit;
        if (start > 0) {
            result &= 0xFFFFFFE7;
        }
        if (limit < this.mLen) {
            result &= 0xFFFFFFF8;
        }
        return result;
    }

    private void extractDecorationInfo(TextPaint paint, DecorationInfo info) {
        info.isStrikeThruText = paint.isStrikeThruText();
        if (info.isStrikeThruText) {
            paint.setStrikeThruText(false);
        }
        info.isUnderlineText = paint.isUnderlineText();
        if (info.isUnderlineText) {
            paint.setUnderlineText(false);
        }
        info.underlineColor = paint.underlineColor;
        info.underlineThickness = paint.underlineThickness;
        paint.setUnderlineText(0, 0.0f);
    }

    private float handleRun(int start, int measureLimit, int limit, boolean runIsRtl, Canvas c, float x, int top, int y, int bottom, Paint.FontMetricsInt fmi, boolean needWidth) {
        boolean needsSpanMeasurement;
        if (measureLimit < start || measureLimit > limit) {
            throw new IndexOutOfBoundsException("measureLimit (" + measureLimit + ") is out of " + "start (" + start + ") and limit (" + limit + ") bounds");
        }
        if (start == measureLimit) {
            TextPaint wp = this.mWorkPaint;
            wp.set(this.mPaint);
            if (fmi != null) {
                TextLine.expandMetricsFromPaint(fmi, wp);
            }
            return 0.0f;
        }
        if (this.mSpanned == null) {
            needsSpanMeasurement = false;
        } else {
            this.mMetricAffectingSpanSpanSet.init(this.mSpanned, this.mStart + start, this.mStart + limit);
            this.mCharacterStyleSpanSet.init(this.mSpanned, this.mStart + start, this.mStart + limit);
            boolean bl = needsSpanMeasurement = this.mMetricAffectingSpanSpanSet.numberOfSpans != 0 || this.mCharacterStyleSpanSet.numberOfSpans != 0;
        }
        if (!needsSpanMeasurement) {
            TextPaint wp = this.mWorkPaint;
            wp.set(this.mPaint);
            wp.setHyphenEdit(this.adjustHyphenEdit(start, limit, wp.getHyphenEdit()));
            return this.handleText(wp, start, limit, start, limit, runIsRtl, c, x, top, y, bottom, fmi, needWidth, measureLimit, null);
        }
        float originalX = x;
        int i = start;
        while (i < measureLimit) {
            TextPaint wp = this.mWorkPaint;
            wp.set(this.mPaint);
            int inext = this.mMetricAffectingSpanSpanSet.getNextTransition(this.mStart + i, this.mStart + limit) - this.mStart;
            int mlimit = Math.min(inext, measureLimit);
            ReplacementSpan replacement = null;
            for (int j = 0; j < this.mMetricAffectingSpanSpanSet.numberOfSpans; ++j) {
                if (this.mMetricAffectingSpanSpanSet.spanStarts[j] >= this.mStart + mlimit || this.mMetricAffectingSpanSpanSet.spanEnds[j] <= this.mStart + i) continue;
                MetricAffectingSpan span = ((MetricAffectingSpan[])this.mMetricAffectingSpanSpanSet.spans)[j];
                if (span instanceof ReplacementSpan) {
                    replacement = (ReplacementSpan)span;
                    continue;
                }
                span.updateDrawState(wp);
            }
            if (replacement != null) {
                x += this.handleReplacement(replacement, wp, i, mlimit, runIsRtl, c, x, top, y, bottom, fmi, needWidth || mlimit < measureLimit);
            } else {
                TextPaint activePaint = this.mActivePaint;
                activePaint.set(this.mPaint);
                int activeStart = i;
                int activeEnd = mlimit;
                DecorationInfo decorationInfo = this.mDecorationInfo;
                this.mDecorations.clear();
                int j = i;
                while (j < mlimit) {
                    int jnext = this.mCharacterStyleSpanSet.getNextTransition(this.mStart + j, this.mStart + inext) - this.mStart;
                    int offset = Math.min(jnext, mlimit);
                    wp.set(this.mPaint);
                    for (int k = 0; k < this.mCharacterStyleSpanSet.numberOfSpans; ++k) {
                        if (this.mCharacterStyleSpanSet.spanStarts[k] >= this.mStart + offset || this.mCharacterStyleSpanSet.spanEnds[k] <= this.mStart + j) continue;
                        CharacterStyle span = ((CharacterStyle[])this.mCharacterStyleSpanSet.spans)[k];
                        span.updateDrawState(wp);
                    }
                    this.extractDecorationInfo(wp, decorationInfo);
                    if (j == i) {
                        activePaint.set(wp);
                    } else if (!wp.hasEqualAttributes(activePaint)) {
                        activePaint.setHyphenEdit(this.adjustHyphenEdit(activeStart, activeEnd, this.mPaint.getHyphenEdit()));
                        x += this.handleText(activePaint, activeStart, activeEnd, i, inext, runIsRtl, c, x, top, y, bottom, fmi, needWidth || activeEnd < measureLimit, Math.min(activeEnd, mlimit), this.mDecorations);
                        activeStart = j;
                        activePaint.set(wp);
                        this.mDecorations.clear();
                    }
                    activeEnd = jnext;
                    if (decorationInfo.hasDecoration()) {
                        DecorationInfo copy = decorationInfo.copyInfo();
                        copy.start = j;
                        copy.end = jnext;
                        this.mDecorations.add(copy);
                    }
                    j = jnext;
                }
                activePaint.setHyphenEdit(this.adjustHyphenEdit(activeStart, activeEnd, this.mPaint.getHyphenEdit()));
                x += this.handleText(activePaint, activeStart, activeEnd, i, inext, runIsRtl, c, x, top, y, bottom, fmi, needWidth || activeEnd < measureLimit, Math.min(activeEnd, mlimit), this.mDecorations);
            }
            i = inext;
        }
        return x - originalX;
    }

    private void drawTextRun(Canvas c, TextPaint wp, int start, int end, int contextStart, int contextEnd, boolean runIsRtl, float x, int y) {
        if (this.mCharsValid) {
            int count = end - start;
            int contextCount = contextEnd - contextStart;
            c.drawTextRun(this.mChars, start, count, contextStart, contextCount, x, (float)y, runIsRtl, (Paint)wp);
        } else {
            int delta = this.mStart;
            c.drawTextRun(this.mText, delta + start, delta + end, delta + contextStart, delta + contextEnd, x, (float)y, runIsRtl, (Paint)wp);
        }
    }

    float nextTab(float h) {
        if (this.mTabs != null) {
            return this.mTabs.nextTab(h);
        }
        return Layout.TabStops.nextDefaultStop(h, 20);
    }

    private boolean isStretchableWhitespace(int ch) {
        return ch == 32 || ch == 160;
    }

    private int nextStretchableSpace(int start, int end) {
        for (int i = start; i < end; ++i) {
            char c;
            char c2 = c = this.mCharsValid ? this.mChars[i] : this.mText.charAt(i + this.mStart);
            if (!this.isStretchableWhitespace(c)) continue;
            return i;
        }
        return end;
    }

    private int countStretchableSpaces(int start, int end) {
        int count = 0;
        int i = start;
        while (i < end) {
            ++count;
            i = this.nextStretchableSpace(i + 1, end);
        }
        return count;
    }

    public static boolean isLineEndSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\u1680' || '\u2000' <= ch && ch <= '\u200a' && ch != '\u2007' || ch == '\u205f' || ch == '\u3000';
    }

    private static final class DecorationInfo {
        public boolean isStrikeThruText;
        public boolean isUnderlineText;
        public int underlineColor;
        public float underlineThickness;
        public int start = -1;
        public int end = -1;

        private DecorationInfo() {
        }

        public boolean hasDecoration() {
            return this.isStrikeThruText || this.isUnderlineText || this.underlineColor != 0;
        }

        public DecorationInfo copyInfo() {
            DecorationInfo copy = new DecorationInfo();
            copy.isStrikeThruText = this.isStrikeThruText;
            copy.isUnderlineText = this.isUnderlineText;
            copy.underlineColor = this.underlineColor;
            copy.underlineThickness = this.underlineThickness;
            return copy;
        }
    }
}

