/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Paint;
import android.os.LocaleList;
import android.text.AndroidBidi;
import android.text.Hyphenator;
import android.text.Layout;
import android.text.MeasuredText;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.TabStopSpan;
import android.util.Log;
import android.util.Pools;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;

public class StaticLayout
extends Layout {
    static final String TAG = "StaticLayout";
    private int mLineCount;
    private int mTopPadding;
    private int mBottomPadding;
    private int mColumns;
    private int mEllipsizedWidth;
    private boolean mEllipsized;
    private int mMaxLineHeight = -1;
    private static final int COLUMNS_NORMAL = 4;
    private static final int COLUMNS_ELLIPSIZE = 6;
    private static final int START = 0;
    private static final int DIR = 0;
    private static final int TAB = 0;
    private static final int TOP = 1;
    private static final int DESCENT = 2;
    private static final int HYPHEN = 3;
    private static final int ELLIPSIS_START = 4;
    private static final int ELLIPSIS_COUNT = 5;
    private int[] mLines;
    private Layout.Directions[] mLineDirections;
    private int mMaximumVisibleLineCount = Integer.MAX_VALUE;
    private static final int START_MASK = 0x1FFFFFFF;
    private static final int DIR_SHIFT = 30;
    private static final int TAB_MASK = 0x20000000;
    private static final int HYPHEN_MASK = 255;
    private static final int TAB_INCREMENT = 20;
    private static final char CHAR_NEW_LINE = '\n';
    private static final double EXTRA_ROUNDING = 0.5;
    private static final int DEFAULT_MAX_LINE_HEIGHT = -1;
    private int[] mLeftIndents;
    private int[] mRightIndents;

    public StaticLayout(CharSequence source, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
        this(source, 0, source.length(), paint, width, align, spacingmult, spacingadd, includepad);
    }

    public StaticLayout(CharSequence source, TextPaint paint, int width, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad) {
        this(source, 0, source.length(), paint, width, align, textDir, spacingmult, spacingadd, includepad);
    }

    public StaticLayout(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
        this(source, bufstart, bufend, paint, outerwidth, align, spacingmult, spacingadd, includepad, null, 0);
    }

    public StaticLayout(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad) {
        this(source, bufstart, bufend, paint, outerwidth, align, textDir, spacingmult, spacingadd, includepad, null, 0, Integer.MAX_VALUE);
    }

    public StaticLayout(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        this(source, bufstart, bufend, paint, outerwidth, align, TextDirectionHeuristics.FIRSTSTRONG_LTR, spacingmult, spacingadd, includepad, ellipsize, ellipsizedWidth, Integer.MAX_VALUE);
    }

    public StaticLayout(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth, int maxLines) {
        super(ellipsize == null ? source : (source instanceof Spanned ? new Layout.SpannedEllipsizer(source) : new Layout.Ellipsizer(source)), paint, outerwidth, align, textDir, spacingmult, spacingadd);
        Builder b = Builder.obtain(source, bufstart, bufend, paint, outerwidth).setAlignment(align).setTextDirection(textDir).setLineSpacing(spacingadd, spacingmult).setIncludePad(includepad).setEllipsizedWidth(ellipsizedWidth).setEllipsize(ellipsize).setMaxLines(maxLines);
        if (ellipsize != null) {
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = ellipsizedWidth;
            e.mMethod = ellipsize;
            this.mEllipsizedWidth = ellipsizedWidth;
            this.mColumns = 6;
        } else {
            this.mColumns = 4;
            this.mEllipsizedWidth = outerwidth;
        }
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2 * this.mColumns);
        this.mLines = new int[this.mLineDirections.length];
        this.mMaximumVisibleLineCount = maxLines;
        this.generate(b, b.mIncludePad, b.mIncludePad);
        Builder.recycle(b);
    }

    StaticLayout(CharSequence text) {
        super(text, null, 0, null, 0.0f, 0.0f);
        this.mColumns = 6;
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2 * this.mColumns);
        this.mLines = new int[this.mLineDirections.length];
    }

    private StaticLayout(Builder b) {
        super(b.mEllipsize == null ? b.mText : (b.mText instanceof Spanned ? new Layout.SpannedEllipsizer(b.mText) : new Layout.Ellipsizer(b.mText)), b.mPaint, b.mWidth, b.mAlignment, b.mSpacingMult, b.mSpacingAdd);
        if (b.mEllipsize != null) {
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = b.mEllipsizedWidth;
            e.mMethod = b.mEllipsize;
            this.mEllipsizedWidth = b.mEllipsizedWidth;
            this.mColumns = 6;
        } else {
            this.mColumns = 4;
            this.mEllipsizedWidth = b.mWidth;
        }
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2 * this.mColumns);
        this.mLines = new int[this.mLineDirections.length];
        this.mMaximumVisibleLineCount = b.mMaxLines;
        this.mLeftIndents = b.mLeftIndents;
        this.mRightIndents = b.mRightIndents;
        this.setJustificationMode(b.mJustificationMode);
        this.generate(b, b.mIncludePad, b.mIncludePad);
    }

    void generate(Builder b, boolean includepad, boolean trackpad) {
        CharSequence source = b.mText;
        int bufStart = b.mStart;
        int bufEnd = b.mEnd;
        TextPaint paint = b.mPaint;
        int outerWidth = b.mWidth;
        TextDirectionHeuristic textDir = b.mTextDir;
        float spacingmult = b.mSpacingMult;
        float spacingadd = b.mSpacingAdd;
        float ellipsizedWidth = b.mEllipsizedWidth;
        TextUtils.TruncateAt ellipsize = b.mEllipsize;
        LineBreaks lineBreaks = new LineBreaks();
        int[] spanEndCache = new int[4];
        int[] fmCache = new int[16];
        b.setLocales(paint.getTextLocales());
        this.mLineCount = 0;
        this.mEllipsized = false;
        this.mMaxLineHeight = this.mMaximumVisibleLineCount < 1 ? 0 : -1;
        int v = 0;
        boolean needMultiply = spacingmult != 1.0f || spacingadd != 0.0f;
        Paint.FontMetricsInt fm = b.mFontMetricsInt;
        int[] chooseHtv = null;
        MeasuredText measured = b.mMeasuredText;
        Spanned spanned = null;
        if (source instanceof Spanned) {
            spanned = (Spanned)source;
        }
        int paraStart = bufStart;
        while (paraStart <= bufEnd) {
            boolean ellipsisMayBeApplied;
            TabStopSpan[] spans;
            int paraEnd = TextUtils.indexOf(source, '\n', paraStart, bufEnd);
            paraEnd = paraEnd < 0 ? bufEnd : ++paraEnd;
            int firstWidthLineCount = 1;
            int firstWidth = outerWidth;
            int restWidth = outerWidth;
            LineHeightSpan[] chooseHt = null;
            if (spanned != null) {
                int i;
                LeadingMarginSpan[] sp = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LeadingMarginSpan.class);
                for (i = 0; i < sp.length; ++i) {
                    LeadingMarginSpan lms = sp[i];
                    firstWidth -= sp[i].getLeadingMargin(true);
                    restWidth -= sp[i].getLeadingMargin(false);
                    if (!(lms instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
                    LeadingMarginSpan.LeadingMarginSpan2 lms2 = (LeadingMarginSpan.LeadingMarginSpan2)lms;
                    firstWidthLineCount = Math.max(firstWidthLineCount, lms2.getLeadingMarginLineCount());
                }
                chooseHt = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LineHeightSpan.class);
                if (chooseHt.length == 0) {
                    chooseHt = null;
                } else {
                    if (chooseHtv == null || chooseHtv.length < chooseHt.length) {
                        chooseHtv = ArrayUtils.newUnpaddedIntArray(chooseHt.length);
                    }
                    for (i = 0; i < chooseHt.length; ++i) {
                        int o = spanned.getSpanStart(chooseHt[i]);
                        chooseHtv[i] = o < paraStart ? this.getLineTop(this.getLineForOffset(o)) : v;
                    }
                }
            }
            measured.setPara(source, paraStart, paraEnd, textDir, b);
            char[] chs = measured.mChars;
            float[] widths = measured.mWidths;
            byte[] chdirs = measured.mLevels;
            int dir = measured.mDir;
            boolean easy = measured.mEasy;
            int[] variableTabStops = null;
            if (spanned != null && (spans = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, TabStopSpan.class)).length > 0) {
                int[] stops = new int[spans.length];
                for (int i = 0; i < spans.length; ++i) {
                    stops[i] = spans[i].getTabStop();
                }
                Arrays.sort(stops, 0, stops.length);
                variableTabStops = stops;
            }
            StaticLayout.nSetupParagraph(b.mNativePtr, chs, paraEnd - paraStart, firstWidth, firstWidthLineCount, restWidth, variableTabStops, 20, b.mBreakStrategy, b.mHyphenationFrequency, b.mJustificationMode != 0);
            if (this.mLeftIndents != null || this.mRightIndents != null) {
                int leftLen = this.mLeftIndents == null ? 0 : this.mLeftIndents.length;
                int rightLen = this.mRightIndents == null ? 0 : this.mRightIndents.length;
                int indentsLen = Math.max(1, Math.max(leftLen, rightLen) - this.mLineCount);
                int[] indents = new int[indentsLen];
                for (int i = 0; i < indentsLen; ++i) {
                    int leftMargin = this.mLeftIndents == null ? 0 : this.mLeftIndents[Math.min(i + this.mLineCount, leftLen - 1)];
                    int rightMargin = this.mRightIndents == null ? 0 : this.mRightIndents[Math.min(i + this.mLineCount, rightLen - 1)];
                    indents[i] = leftMargin + rightMargin;
                }
                StaticLayout.nSetIndents(b.mNativePtr, indents);
            }
            int fmCacheCount = 0;
            int spanEndCacheCount = 0;
            int spanStart = paraStart;
            while (spanStart < paraEnd) {
                int spanLen;
                int spanEnd;
                if (fmCacheCount * 4 >= fmCache.length) {
                    int[] grow = new int[fmCacheCount * 4 * 2];
                    System.arraycopy((int[])fmCache, (int)0, (int[])grow, (int)0, (int)(fmCacheCount * 4));
                    fmCache = grow;
                }
                if (spanEndCacheCount >= spanEndCache.length) {
                    int[] grow = new int[spanEndCacheCount * 2];
                    System.arraycopy((int[])spanEndCache, (int)0, (int[])grow, (int)0, (int)spanEndCacheCount);
                    spanEndCache = grow;
                }
                if (spanned == null) {
                    spanEnd = paraEnd;
                    spanLen = spanEnd - spanStart;
                    measured.addStyleRun(paint, spanLen, fm);
                } else {
                    spanEnd = spanned.nextSpanTransition(spanStart, paraEnd, MetricAffectingSpan.class);
                    spanLen = spanEnd - spanStart;
                    MetricAffectingSpan[] spans2 = spanned.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                    spans2 = TextUtils.removeEmptySpans(spans2, spanned, MetricAffectingSpan.class);
                    measured.addStyleRun(paint, spans2, spanLen, fm);
                }
                fmCache[fmCacheCount * 4 + 0] = fm.top;
                fmCache[fmCacheCount * 4 + 1] = fm.bottom;
                fmCache[fmCacheCount * 4 + 2] = fm.ascent;
                fmCache[fmCacheCount * 4 + 3] = fm.descent;
                ++fmCacheCount;
                spanEndCache[spanEndCacheCount] = spanEnd;
                ++spanEndCacheCount;
                spanStart = spanEnd;
            }
            StaticLayout.nGetWidths(b.mNativePtr, widths);
            int breakCount = StaticLayout.nComputeLineBreaks(b.mNativePtr, lineBreaks, lineBreaks.breaks, lineBreaks.widths, lineBreaks.flags, lineBreaks.breaks.length);
            int[] breaks = lineBreaks.breaks;
            float[] lineWidths = lineBreaks.widths;
            int[] flags = lineBreaks.flags;
            int remainingLineCount = this.mMaximumVisibleLineCount - this.mLineCount;
            boolean bl = ellipsisMayBeApplied = ellipsize != null && (ellipsize == TextUtils.TruncateAt.END || this.mMaximumVisibleLineCount == 1 && ellipsize != TextUtils.TruncateAt.MARQUEE);
            if (remainingLineCount > 0 && remainingLineCount < breakCount && ellipsisMayBeApplied) {
                float width = 0.0f;
                int flag = 0;
                for (int i = remainingLineCount - 1; i < breakCount; ++i) {
                    if (i == breakCount - 1) {
                        width += lineWidths[i];
                    } else {
                        int j;
                        int n = j = i == 0 ? 0 : breaks[i - 1];
                        while (j < breaks[i]) {
                            width += widths[j];
                            ++j;
                        }
                    }
                    flag |= flags[i] & 0x20000000;
                }
                breaks[remainingLineCount - 1] = breaks[breakCount - 1];
                lineWidths[remainingLineCount - 1] = width;
                flags[remainingLineCount - 1] = flag;
                breakCount = remainingLineCount;
            }
            int here = paraStart;
            int fmTop = 0;
            int fmBottom = 0;
            int fmAscent = 0;
            int fmDescent = 0;
            int fmCacheIndex = 0;
            int spanEndCacheIndex = 0;
            int breakIndex = 0;
            int spanStart2 = paraStart;
            while (spanStart2 < paraEnd) {
                int spanEnd = spanEndCache[spanEndCacheIndex++];
                fm.top = fmCache[fmCacheIndex * 4 + 0];
                fm.bottom = fmCache[fmCacheIndex * 4 + 1];
                fm.ascent = fmCache[fmCacheIndex * 4 + 2];
                fm.descent = fmCache[fmCacheIndex * 4 + 3];
                ++fmCacheIndex;
                if (fm.top < fmTop) {
                    fmTop = fm.top;
                }
                if (fm.ascent < fmAscent) {
                    fmAscent = fm.ascent;
                }
                if (fm.descent > fmDescent) {
                    fmDescent = fm.descent;
                }
                if (fm.bottom > fmBottom) {
                    fmBottom = fm.bottom;
                }
                while (breakIndex < breakCount && paraStart + breaks[breakIndex] < spanStart2) {
                    ++breakIndex;
                }
                while (breakIndex < breakCount && paraStart + breaks[breakIndex] <= spanEnd) {
                    int endPos = paraStart + breaks[breakIndex];
                    boolean moreChars = endPos < bufEnd;
                    v = this.out(source, here, endPos, fmAscent, fmDescent, fmTop, fmBottom, v, spacingmult, spacingadd, chooseHt, chooseHtv, fm, flags[breakIndex], needMultiply, chdirs, dir, easy, bufEnd, includepad, trackpad, chs, widths, paraStart, ellipsize, ellipsizedWidth, lineWidths[breakIndex], paint, moreChars);
                    if (endPos < spanEnd) {
                        fmTop = fm.top;
                        fmBottom = fm.bottom;
                        fmAscent = fm.ascent;
                        fmDescent = fm.descent;
                    } else {
                        fmDescent = 0;
                        fmAscent = 0;
                        fmBottom = 0;
                        fmTop = 0;
                    }
                    here = endPos;
                    ++breakIndex;
                    if (this.mLineCount < this.mMaximumVisibleLineCount || !this.mEllipsized) continue;
                    return;
                }
                spanStart2 = spanEnd;
            }
            if (paraEnd == bufEnd) break;
            paraStart = paraEnd;
        }
        if ((bufEnd == bufStart || source.charAt(bufEnd - 1) == '\n') && this.mLineCount < this.mMaximumVisibleLineCount) {
            measured.setPara(source, bufEnd, bufEnd, textDir, b);
            paint.getFontMetricsInt(fm);
            v = this.out(source, bufEnd, bufEnd, fm.ascent, fm.descent, fm.top, fm.bottom, v, spacingmult, spacingadd, null, null, fm, 0, needMultiply, measured.mLevels, measured.mDir, measured.mEasy, bufEnd, includepad, trackpad, null, null, bufStart, ellipsize, ellipsizedWidth, 0.0f, paint, false);
        }
    }

    private int out(CharSequence text, int start, int end, int above, int below, int top, int bottom, int v, float spacingmult, float spacingadd, LineHeightSpan[] chooseHt, int[] chooseHtv, Paint.FontMetricsInt fm, int flags, boolean needMultiply, byte[] chdirs, int dir, boolean easy, int bufEnd, boolean includePad, boolean trackPad, char[] chs, float[] widths, int widthStart, TextUtils.TruncateAt ellipsize, float ellipsisWidth, float textWidth, TextPaint paint, boolean moreChars) {
        double ex;
        boolean lastLine;
        boolean currentLineIsTheLastVisibleOne;
        int j = this.mLineCount;
        int off = j * this.mColumns;
        int want = off + this.mColumns + 1;
        int[] lines = this.mLines;
        if (want >= lines.length) {
            Layout.Directions[] grow2 = ArrayUtils.newUnpaddedArray(Layout.Directions.class, GrowingArrayUtils.growSize(want));
            System.arraycopy(this.mLineDirections, 0, grow2, 0, this.mLineDirections.length);
            this.mLineDirections = grow2;
            int[] grow = new int[grow2.length];
            System.arraycopy((int[])lines, (int)0, (int[])grow, (int)0, (int)lines.length);
            this.mLines = grow;
            lines = grow;
        }
        if (chooseHt != null) {
            fm.ascent = above;
            fm.descent = below;
            fm.top = top;
            fm.bottom = bottom;
            for (int i = 0; i < chooseHt.length; ++i) {
                if (chooseHt[i] instanceof LineHeightSpan.WithDensity) {
                    ((LineHeightSpan.WithDensity)chooseHt[i]).chooseHeight(text, start, end, chooseHtv[i], v, fm, paint);
                    continue;
                }
                chooseHt[i].chooseHeight(text, start, end, chooseHtv[i], v, fm);
            }
            above = fm.ascent;
            below = fm.descent;
            top = fm.top;
            bottom = fm.bottom;
        }
        boolean firstLine = j == 0;
        boolean bl = currentLineIsTheLastVisibleOne = j + 1 == this.mMaximumVisibleLineCount;
        if (ellipsize != null) {
            boolean doEllipsis;
            boolean forceEllipsis = moreChars && this.mLineCount + 1 == this.mMaximumVisibleLineCount;
            boolean bl2 = doEllipsis = (this.mMaximumVisibleLineCount == 1 && moreChars || firstLine && !moreChars) && ellipsize != TextUtils.TruncateAt.MARQUEE || !firstLine && (currentLineIsTheLastVisibleOne || !moreChars) && ellipsize == TextUtils.TruncateAt.END;
            if (doEllipsis) {
                this.calculateEllipsis(start, end, widths, widthStart, ellipsisWidth, ellipsize, j, textWidth, paint, forceEllipsis);
            }
        }
        boolean bl3 = lastLine = this.mEllipsized || end == bufEnd;
        if (firstLine) {
            if (trackPad) {
                this.mTopPadding = top - above;
            }
            if (includePad) {
                above = top;
            }
        }
        if (lastLine) {
            if (trackPad) {
                this.mBottomPadding = bottom - below;
            }
            if (includePad) {
                below = bottom;
            }
        }
        int extra = needMultiply && !lastLine ? ((ex = (double)((float)(below - above) * (spacingmult - 1.0f) + spacingadd)) >= 0.0 ? (int)(ex + 0.5) : -((int)(-ex + 0.5))) : 0;
        lines[off + 0] = start;
        lines[off + 1] = v;
        lines[off + 2] = below + extra;
        if (!this.mEllipsized && currentLineIsTheLastVisibleOne) {
            int maxLineBelow = includePad ? bottom : below;
            this.mMaxLineHeight = v + (maxLineBelow - above);
        }
        lines[off + this.mColumns + 0] = end;
        lines[off + this.mColumns + 1] = v += below - above + extra;
        int n = off + 0;
        lines[n] = lines[n] | flags & 0x20000000;
        lines[off + 3] = flags;
        int n2 = off + 0;
        lines[n2] = lines[n2] | dir << 30;
        Layout.Directions linedirs = DIRS_ALL_LEFT_TO_RIGHT;
        this.mLineDirections[j] = easy ? linedirs : AndroidBidi.directions(dir, chdirs, start - widthStart, chs, start - widthStart, end - start);
        ++this.mLineCount;
        return v;
    }

    private void calculateEllipsis(int lineStart, int lineEnd, float[] widths, int widthStart, float avail, TextUtils.TruncateAt where, int line, float textWidth, TextPaint paint, boolean forceEllipsis) {
        if (textWidth <= (avail -= this.getTotalInsets(line)) && !forceEllipsis) {
            this.mLines[this.mColumns * line + 4] = 0;
            this.mLines[this.mColumns * line + 5] = 0;
            return;
        }
        float ellipsisWidth = paint.measureText(where == TextUtils.TruncateAt.END_SMALL ? TextUtils.ELLIPSIS_TWO_DOTS : TextUtils.ELLIPSIS_NORMAL, 0, 1);
        int ellipsisStart = 0;
        int ellipsisCount = 0;
        int len = lineEnd - lineStart;
        if (where == TextUtils.TruncateAt.START) {
            if (this.mMaximumVisibleLineCount == 1) {
                int i;
                float sum = 0.0f;
                for (i = len; i > 0; --i) {
                    float w = widths[i - 1 + lineStart - widthStart];
                    if (w + sum + ellipsisWidth > avail) {
                        while (i < len && widths[i + lineStart - widthStart] == 0.0f) {
                            ++i;
                        }
                        break;
                    }
                    sum += w;
                }
                ellipsisStart = 0;
                ellipsisCount = i;
            } else if (Log.isLoggable(TAG, 5)) {
                Log.w(TAG, "Start Ellipsis only supported with one line");
            }
        } else if (where == TextUtils.TruncateAt.END || where == TextUtils.TruncateAt.MARQUEE || where == TextUtils.TruncateAt.END_SMALL) {
            float w;
            int i;
            float sum = 0.0f;
            for (i = 0; i < len && !((w = widths[i + lineStart - widthStart]) + sum + ellipsisWidth > avail); ++i) {
                sum += w;
            }
            ellipsisStart = i;
            ellipsisCount = len - i;
            if (forceEllipsis && ellipsisCount == 0 && len > 0) {
                ellipsisStart = len - 1;
                ellipsisCount = 1;
            }
        } else if (this.mMaximumVisibleLineCount == 1) {
            float w;
            float lsum = 0.0f;
            float rsum = 0.0f;
            int left = 0;
            int right = len;
            float ravail = (avail - ellipsisWidth) / 2.0f;
            for (right = len; right > 0; --right) {
                float w2 = widths[right - 1 + lineStart - widthStart];
                if (w2 + rsum > ravail) {
                    while (right < len && widths[right + lineStart - widthStart] == 0.0f) {
                        ++right;
                    }
                    break;
                }
                rsum += w2;
            }
            float lavail = avail - ellipsisWidth - rsum;
            for (left = 0; left < right && !((w = widths[left + lineStart - widthStart]) + lsum > lavail); ++left) {
                lsum += w;
            }
            ellipsisStart = left;
            ellipsisCount = right - left;
        } else if (Log.isLoggable(TAG, 5)) {
            Log.w(TAG, "Middle Ellipsis only supported with one line");
        }
        this.mEllipsized = true;
        this.mLines[this.mColumns * line + 4] = ellipsisStart;
        this.mLines[this.mColumns * line + 5] = ellipsisCount;
    }

    private float getTotalInsets(int line) {
        int totalIndent = 0;
        if (this.mLeftIndents != null) {
            totalIndent = this.mLeftIndents[Math.min(line, this.mLeftIndents.length - 1)];
        }
        if (this.mRightIndents != null) {
            totalIndent += this.mRightIndents[Math.min(line, this.mRightIndents.length - 1)];
        }
        return totalIndent;
    }

    @Override
    public int getLineForVertical(int vertical) {
        int high = this.mLineCount;
        int low = -1;
        int[] lines = this.mLines;
        while (high - low > 1) {
            int guess = high + low >> 1;
            if (lines[this.mColumns * guess + 1] > vertical) {
                high = guess;
                continue;
            }
            low = guess;
        }
        if (low < 0) {
            return 0;
        }
        return low;
    }

    @Override
    public int getLineCount() {
        return this.mLineCount;
    }

    @Override
    public int getLineTop(int line) {
        return this.mLines[this.mColumns * line + 1];
    }

    @Override
    public int getLineDescent(int line) {
        return this.mLines[this.mColumns * line + 2];
    }

    @Override
    public int getLineStart(int line) {
        return this.mLines[this.mColumns * line + 0] & 0x1FFFFFFF;
    }

    @Override
    public int getParagraphDirection(int line) {
        return this.mLines[this.mColumns * line + 0] >> 30;
    }

    @Override
    public boolean getLineContainsTab(int line) {
        return (this.mLines[this.mColumns * line + 0] & 0x20000000) != 0;
    }

    @Override
    public final Layout.Directions getLineDirections(int line) {
        return this.mLineDirections[line];
    }

    @Override
    public int getTopPadding() {
        return this.mTopPadding;
    }

    @Override
    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    @Override
    public int getHyphen(int line) {
        return this.mLines[this.mColumns * line + 3] & 0xFF;
    }

    @Override
    public int getIndentAdjust(int line, Layout.Alignment align) {
        if (align == Layout.Alignment.ALIGN_LEFT) {
            if (this.mLeftIndents == null) {
                return 0;
            }
            return this.mLeftIndents[Math.min(line, this.mLeftIndents.length - 1)];
        }
        if (align == Layout.Alignment.ALIGN_RIGHT) {
            if (this.mRightIndents == null) {
                return 0;
            }
            return -this.mRightIndents[Math.min(line, this.mRightIndents.length - 1)];
        }
        if (align == Layout.Alignment.ALIGN_CENTER) {
            int left = 0;
            if (this.mLeftIndents != null) {
                left = this.mLeftIndents[Math.min(line, this.mLeftIndents.length - 1)];
            }
            int right = 0;
            if (this.mRightIndents != null) {
                right = this.mRightIndents[Math.min(line, this.mRightIndents.length - 1)];
            }
            return left - right >> 1;
        }
        throw new AssertionError((Object)("unhandled alignment " + (Object)((Object)align)));
    }

    @Override
    public int getEllipsisCount(int line) {
        if (this.mColumns < 6) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 5];
    }

    @Override
    public int getEllipsisStart(int line) {
        if (this.mColumns < 6) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 4];
    }

    @Override
    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    @Override
    public int getHeight(boolean cap) {
        if (cap && this.mLineCount >= this.mMaximumVisibleLineCount && this.mMaxLineHeight == -1 && Log.isLoggable(TAG, 5)) {
            Log.w(TAG, "maxLineHeight should not be -1.  maxLines:" + this.mMaximumVisibleLineCount + " lineCount:" + this.mLineCount);
        }
        return cap && this.mLineCount >= this.mMaximumVisibleLineCount && this.mMaxLineHeight != -1 ? this.mMaxLineHeight : super.getHeight();
    }

    private static native long nNewBuilder();

    private static native void nFreeBuilder(long var0);

    private static native void nFinishBuilder(long var0);

    static native long nLoadHyphenator(ByteBuffer var0, int var1, int var2, int var3);

    private static native void nSetLocales(long var0, String var2, long[] var3);

    private static native void nSetIndents(long var0, int[] var2);

    private static native void nSetupParagraph(long var0, char[] var2, int var3, float var4, int var5, float var6, int[] var7, int var8, int var9, int var10, boolean var11);

    private static native float nAddStyleRun(long var0, long var2, long var4, int var6, int var7, boolean var8);

    private static native void nAddMeasuredRun(long var0, int var2, int var3, float[] var4);

    private static native void nAddReplacementRun(long var0, int var2, int var3, float var4);

    private static native void nGetWidths(long var0, float[] var2);

    private static native int nComputeLineBreaks(long var0, LineBreaks var2, int[] var3, float[] var4, int[] var5, int var6);

    static class LineBreaks {
        private static final int INITIAL_SIZE = 16;
        public int[] breaks = new int[16];
        public float[] widths = new float[16];
        public int[] flags = new int[16];

        LineBreaks() {
        }
    }

    public static final class Builder {
        long mNativePtr;
        CharSequence mText;
        int mStart;
        int mEnd;
        TextPaint mPaint;
        int mWidth;
        Layout.Alignment mAlignment;
        TextDirectionHeuristic mTextDir;
        float mSpacingMult;
        float mSpacingAdd;
        boolean mIncludePad;
        int mEllipsizedWidth;
        TextUtils.TruncateAt mEllipsize;
        int mMaxLines;
        int mBreakStrategy;
        int mHyphenationFrequency;
        int[] mLeftIndents;
        int[] mRightIndents;
        int mJustificationMode;
        Paint.FontMetricsInt mFontMetricsInt = new Paint.FontMetricsInt();
        MeasuredText mMeasuredText;
        LocaleList mLocales;
        private static final Pools.SynchronizedPool<Builder> sPool = new Pools.SynchronizedPool(3);

        private Builder() {
            this.mNativePtr = StaticLayout.nNewBuilder();
        }

        public static Builder obtain(CharSequence source, int start, int end, TextPaint paint, int width) {
            Builder b = sPool.acquire();
            if (b == null) {
                b = new Builder();
            }
            b.mText = source;
            b.mStart = start;
            b.mEnd = end;
            b.mPaint = paint;
            b.mWidth = width;
            b.mAlignment = Layout.Alignment.ALIGN_NORMAL;
            b.mTextDir = TextDirectionHeuristics.FIRSTSTRONG_LTR;
            b.mSpacingMult = 1.0f;
            b.mSpacingAdd = 0.0f;
            b.mIncludePad = true;
            b.mEllipsizedWidth = width;
            b.mEllipsize = null;
            b.mMaxLines = Integer.MAX_VALUE;
            b.mBreakStrategy = 0;
            b.mHyphenationFrequency = 0;
            b.mJustificationMode = 0;
            b.mMeasuredText = MeasuredText.obtain();
            return b;
        }

        private static void recycle(Builder b) {
            b.mPaint = null;
            b.mText = null;
            MeasuredText.recycle(b.mMeasuredText);
            b.mMeasuredText = null;
            b.mLeftIndents = null;
            b.mRightIndents = null;
            StaticLayout.nFinishBuilder(b.mNativePtr);
            sPool.release(b);
        }

        void finish() {
            StaticLayout.nFinishBuilder(this.mNativePtr);
            this.mText = null;
            this.mPaint = null;
            this.mLeftIndents = null;
            this.mRightIndents = null;
            this.mMeasuredText.finish();
        }

        public Builder setText(CharSequence source) {
            return this.setText(source, 0, source.length());
        }

        public Builder setText(CharSequence source, int start, int end) {
            this.mText = source;
            this.mStart = start;
            this.mEnd = end;
            return this;
        }

        public Builder setPaint(TextPaint paint) {
            this.mPaint = paint;
            return this;
        }

        public Builder setWidth(int width) {
            this.mWidth = width;
            if (this.mEllipsize == null) {
                this.mEllipsizedWidth = width;
            }
            return this;
        }

        public Builder setAlignment(Layout.Alignment alignment) {
            this.mAlignment = alignment;
            return this;
        }

        public Builder setTextDirection(TextDirectionHeuristic textDir) {
            this.mTextDir = textDir;
            return this;
        }

        public Builder setLineSpacing(float spacingAdd, float spacingMult) {
            this.mSpacingAdd = spacingAdd;
            this.mSpacingMult = spacingMult;
            return this;
        }

        public Builder setIncludePad(boolean includePad) {
            this.mIncludePad = includePad;
            return this;
        }

        public Builder setEllipsizedWidth(int ellipsizedWidth) {
            this.mEllipsizedWidth = ellipsizedWidth;
            return this;
        }

        public Builder setEllipsize(TextUtils.TruncateAt ellipsize) {
            this.mEllipsize = ellipsize;
            return this;
        }

        public Builder setMaxLines(int maxLines) {
            this.mMaxLines = maxLines;
            return this;
        }

        public Builder setBreakStrategy(int breakStrategy) {
            this.mBreakStrategy = breakStrategy;
            return this;
        }

        public Builder setHyphenationFrequency(int hyphenationFrequency) {
            this.mHyphenationFrequency = hyphenationFrequency;
            return this;
        }

        public Builder setIndents(int[] leftIndents, int[] rightIndents) {
            this.mLeftIndents = leftIndents;
            this.mRightIndents = rightIndents;
            int leftLen = leftIndents == null ? 0 : leftIndents.length;
            int rightLen = rightIndents == null ? 0 : rightIndents.length;
            int[] indents = new int[Math.max(leftLen, rightLen)];
            for (int i = 0; i < indents.length; ++i) {
                int leftMargin = i < leftLen ? leftIndents[i] : 0;
                int rightMargin = i < rightLen ? rightIndents[i] : 0;
                indents[i] = leftMargin + rightMargin;
            }
            StaticLayout.nSetIndents(this.mNativePtr, indents);
            return this;
        }

        public Builder setJustificationMode(int justificationMode) {
            this.mJustificationMode = justificationMode;
            return this;
        }

        private long[] getHyphenators(LocaleList locales) {
            int length = locales.size();
            long[] result = new long[length];
            for (int i = 0; i < length; ++i) {
                Locale locale = locales.get(i);
                result[i] = Hyphenator.get(locale).getNativePtr();
            }
            return result;
        }

        private void setLocales(LocaleList locales) {
            if (!locales.equals(this.mLocales)) {
                StaticLayout.nSetLocales(this.mNativePtr, locales.toLanguageTags(), this.getHyphenators(locales));
                this.mLocales = locales;
            }
        }

        float addStyleRun(TextPaint paint, int start, int end, boolean isRtl) {
            this.setLocales(paint.getTextLocales());
            return StaticLayout.nAddStyleRun(this.mNativePtr, paint.getNativeInstance(), paint.mNativeTypeface, start, end, isRtl);
        }

        void addMeasuredRun(int start, int end, float[] widths) {
            StaticLayout.nAddMeasuredRun(this.mNativePtr, start, end, widths);
        }

        void addReplacementRun(int start, int end, float width) {
            StaticLayout.nAddReplacementRun(this.mNativePtr, start, end, width);
        }

        public StaticLayout build() {
            StaticLayout result = new StaticLayout(this);
            Builder.recycle(this);
            return result;
        }

        protected void finalize() throws Throwable {
            try {
                StaticLayout.nFreeBuilder(this.mNativePtr);
            }
            finally {
                super.finalize();
            }
        }
    }
}

