/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.StaticLayout;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Locale;

public class Hyphenator {
    private static String TAG = "Hyphenator";
    private static final int INDIC_MIN_PREFIX = 2;
    private static final int INDIC_MIN_SUFFIX = 2;
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    static final HashMap<Locale, Hyphenator> sMap = new HashMap();
    private static final int DEFAULT_MIN_PREFIX = 2;
    private static final int DEFAULT_MIN_SUFFIX = 2;
    static final Hyphenator sEmptyHyphenator = new Hyphenator(StaticLayout.nLoadHyphenator(null, 0, 2, 2), null);
    private final long mNativePtr;
    private final ByteBuffer mBuffer;
    private static final String[][] LOCALE_FALLBACK_DATA = new String[][]{{"en-AS", "en-US"}, {"en-GU", "en-US"}, {"en-MH", "en-US"}, {"en-MP", "en-US"}, {"en-PR", "en-US"}, {"en-UM", "en-US"}, {"en-VI", "en-US"}, {"en", "en-GB"}, {"de", "de-1996"}, {"de-LI-1901", "de-CH-1901"}, {"no", "nb"}, {"mn", "mn-Cyrl"}, {"am", "und-Ethi"}, {"byn", "und-Ethi"}, {"gez", "und-Ethi"}, {"ti", "und-Ethi"}, {"wal", "und-Ethi"}};
    private static final HyphenationData[] AVAILABLE_LANGUAGES = new HyphenationData[]{new HyphenationData("as", 2, 2), new HyphenationData("bg", 2, 2), new HyphenationData("bn", 2, 2), new HyphenationData("cu", 1, 2), new HyphenationData("cy", 2, 3), new HyphenationData("da", 2, 2), new HyphenationData("de-1901", 2, 2), new HyphenationData("de-1996", 2, 2), new HyphenationData("de-CH-1901", 2, 2), new HyphenationData("en-GB", 2, 3), new HyphenationData("en-US", 2, 3), new HyphenationData("es", 2, 2), new HyphenationData("et", 2, 3), new HyphenationData("eu", 2, 2), new HyphenationData("fr", 2, 3), new HyphenationData("ga", 2, 3), new HyphenationData("gu", 2, 2), new HyphenationData("hi", 2, 2), new HyphenationData("hr", 2, 2), new HyphenationData("hu", 2, 2), new HyphenationData("hy", 2, 2), new HyphenationData("kn", 2, 2), new HyphenationData("ml", 2, 2), new HyphenationData("mn-Cyrl", 2, 2), new HyphenationData("mr", 2, 2), new HyphenationData("nb", 2, 2), new HyphenationData("nn", 2, 2), new HyphenationData("or", 2, 2), new HyphenationData("pa", 2, 2), new HyphenationData("pt", 2, 3), new HyphenationData("sl", 2, 2), new HyphenationData("ta", 2, 2), new HyphenationData("te", 2, 2), new HyphenationData("tk", 2, 2), new HyphenationData("und-Ethi", 1, 1)};

    private Hyphenator(long nativePtr, ByteBuffer b) {
        this.mNativePtr = nativePtr;
        this.mBuffer = b;
    }

    public long getNativePtr() {
        return this.mNativePtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hyphenator get(Locale locale) {
        Object object = sLock;
        synchronized (object) {
            Locale scriptOnlyLocale;
            Locale languageAndVariantOnlyLocale;
            Hyphenator result = sMap.get(locale);
            if (result != null) {
                return result;
            }
            String variant = locale.getVariant();
            if (!variant.isEmpty() && (result = sMap.get(languageAndVariantOnlyLocale = new Locale(locale.getLanguage(), "", variant))) != null) {
                sMap.put(locale, result);
                return result;
            }
            Locale languageOnlyLocale = new Locale(locale.getLanguage());
            result = sMap.get(languageOnlyLocale);
            if (result != null) {
                sMap.put(locale, result);
                return result;
            }
            String script = locale.getScript();
            if (!script.equals("") && (result = sMap.get(scriptOnlyLocale = new Locale.Builder().setLanguage("und").setScript(script).build())) != null) {
                sMap.put(locale, result);
                return result;
            }
            sMap.put(locale, sEmptyHyphenator);
        }
        return sEmptyHyphenator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hyphenator loadHyphenator(HyphenationData data) {
        Hyphenator hyphenator;
        String patternFilename = "hyph-" + data.mLanguageTag.toLowerCase(Locale.US) + ".hyb";
        File patternFile = new File(Hyphenator.getSystemHyphenatorLocation(), patternFilename);
        if (!patternFile.canRead()) {
            Log.e(TAG, "hyphenation patterns for " + patternFile + " not found or unreadable");
            return null;
        }
        RandomAccessFile f = new RandomAccessFile(patternFile, "r");
        try {
            FileChannel fc = f.getChannel();
            MappedByteBuffer buf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            long nativePtr = StaticLayout.nLoadHyphenator(buf, 0, data.mMinPrefix, data.mMinSuffix);
            hyphenator = new Hyphenator(nativePtr, buf);
        }
        catch (Throwable throwable) {
            try {
                f.close();
                throw throwable;
            }
            catch (IOException e) {
                Log.e(TAG, "error loading hyphenation " + patternFile, e);
                return null;
            }
        }
        f.close();
        return hyphenator;
    }

    private static File getSystemHyphenatorLocation() {
        return new File("/system/usr/hyphen-data");
    }

    public static void init() {
        int i;
        sMap.put(null, null);
        for (i = 0; i < AVAILABLE_LANGUAGES.length; ++i) {
            HyphenationData data = AVAILABLE_LANGUAGES[i];
            Hyphenator h = Hyphenator.loadHyphenator(data);
            if (h == null) continue;
            sMap.put(Locale.forLanguageTag(data.mLanguageTag), h);
        }
        for (i = 0; i < LOCALE_FALLBACK_DATA.length; ++i) {
            String language = LOCALE_FALLBACK_DATA[i][0];
            String fallback = LOCALE_FALLBACK_DATA[i][1];
            sMap.put(Locale.forLanguageTag(language), sMap.get(Locale.forLanguageTag(fallback)));
        }
    }

    private static class HyphenationData {
        final String mLanguageTag;
        final int mMinPrefix;
        final int mMinSuffix;

        HyphenationData(String languageTag, int minPrefix, int minSuffix) {
            this.mLanguageTag = languageTag;
            this.mMinPrefix = minPrefix;
            this.mMinSuffix = minSuffix;
        }
    }
}

