/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.mbms;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.telephony.mbms.MbmsUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;

public class MbmsTempFileProvider
extends ContentProvider {
    public static final String TEMP_FILE_ROOT_PREF_FILE_NAME = "MbmsTempFileRootPrefs";
    public static final String TEMP_FILE_ROOT_PREF_NAME = "mbms_temp_file_root";
    private String mAuthority;
    private Context mContext;

    @Override
    public boolean onCreate() {
        return true;
    }

    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        throw new UnsupportedOperationException("No querying supported");
    }

    @Override
    public String getType(Uri uri) {
        return "application/octet-stream";
    }

    @Override
    public Uri insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException("No inserting supported");
    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("No deleting supported");
    }

    @Override
    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("No updating supported");
    }

    @Override
    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        File file = MbmsTempFileProvider.getFileForUri(this.mContext, this.mAuthority, uri);
        int fileMode = ParcelFileDescriptor.parseMode(mode);
        return ParcelFileDescriptor.open(file, fileMode);
    }

    @Override
    public void attachInfo(Context context, ProviderInfo info) {
        super.attachInfo(context, info);
        if (info.exported) {
            throw new SecurityException("Provider must not be exported");
        }
        if (!info.grantUriPermissions) {
            throw new SecurityException("Provider must grant uri permissions");
        }
        this.mAuthority = info.authority;
        this.mContext = context;
    }

    public static Uri getUriForFile(Context context, String authority, File file) {
        String tempFileDirPath;
        String filePath;
        try {
            filePath = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not get canonical path for file " + file);
        }
        File tempFileDir = MbmsTempFileProvider.getEmbmsTempFileDir(context);
        if (!MbmsUtils.isContainedIn(tempFileDir, file)) {
            throw new IllegalArgumentException("File " + file + " is not contained in the temp " + "file directory, which is " + tempFileDir);
        }
        try {
            tempFileDirPath = tempFileDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get canonical path for temp file root dir " + tempFileDir);
        }
        String pathFragment = tempFileDirPath.endsWith("/") ? filePath.substring(tempFileDirPath.length()) : filePath.substring(tempFileDirPath.length() + 1);
        String encodedPath = Uri.encode(pathFragment);
        return new Uri.Builder().scheme("content").authority(authority).encodedPath(encodedPath).build();
    }

    public static File getFileForUri(Context context, String authority, Uri uri) throws FileNotFoundException {
        File file;
        File tempFileDir;
        if (!"content".equals(uri.getScheme())) {
            throw new IllegalArgumentException("Uri must have scheme content");
        }
        if (!Objects.equals(authority, uri.getAuthority())) {
            throw new IllegalArgumentException("Uri does not have a matching authority: " + authority + ", " + uri.getAuthority());
        }
        String relPath = Uri.decode(uri.getEncodedPath());
        try {
            tempFileDir = MbmsTempFileProvider.getEmbmsTempFileDir(context).getCanonicalFile();
            file = new File(tempFileDir, relPath).getCanonicalFile();
        }
        catch (IOException e) {
            throw new FileNotFoundException("Could not resolve paths");
        }
        if (!file.getPath().startsWith(tempFileDir.getPath())) {
            throw new SecurityException("Resolved path jumped beyond configured root");
        }
        return file;
    }

    public static File getEmbmsTempFileDir(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(TEMP_FILE_ROOT_PREF_FILE_NAME, 0);
        String storedTempFileRoot = prefs.getString(TEMP_FILE_ROOT_PREF_NAME, null);
        try {
            if (storedTempFileRoot != null) {
                return new File(storedTempFileRoot).getCanonicalFile();
            }
            return new File(context.getFilesDir(), "androidMbmsTempFileRoot").getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to canonicalize temp file root path " + e);
        }
    }
}

